from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class downscaleanythingrffastProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'downscale_anything_rf_fast'

    def name(self):
        return self.tr('Downscale Anything with Random Forest')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.downscale_anything_rf_fast import DownscaleAnythingRFFast
        self.addAlgorithm(DownscaleAnythingRFFast())

