# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Download_rasterDialog
                                 A QGIS plugin
 download_raster_gee
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-11-09
        git sha              : $Format:%H$
        copyright            : (C) 2022 by aleksi
        email                : alexis@odd.co
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os


from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.core import *

from qgis.PyQt import uic
from qgis.PyQt import *




#--------------------------------
import requests
import urllib.request
import ee
from .task_download_manager import *
from .scripts.utils import create_message,get_data_from_catalog,new_windget_config,valid_data,validate_selected_bands
try:
    from pydevd import *
except ImportError:
    None


#--------------------------------
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'download_raster_dialog_base.ui'))


class Download_rasterDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(Download_rasterDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.init_config()
        self.download_bd()          
        self.download_enabled_widget(False)

    def init_config(self):
        name_path = os.path.expanduser("~").replace("\\","//")+'//default.tif'
        self.output_line.setText(name_path)       
    
    def addRaster(self):
        self.progressBar.setValue(0)
        self.iface.addRasterLayer(self.output_line.text())

    def download_enabled_widget(self,status):
        self.btn_output.setEnabled(status)

    def download_bd(self):
        print("download_bd")
        r = requests.get('https://earthengine-stac.storage.googleapis.com/catalog/catalog.json')
        data = r.json()
        for i in data['links']:
            try:
                self.comboBox_sat_json.addItem(i["title"])
                
            except Exception as err:
                print(f'download bd {err}')

    #create functions 
    def download_bd_sat(self,id_sat):
        rs = requests.get(f'https://earthengine-stac.storage.googleapis.com/catalog/{id_sat}/catalog.json')
        sat_ = rs.json()
        self.comboBox_sat_bands_json.clear()
        for i in sat_['links']:
            try:
                self.comboBox_sat_bands_json.addItem(i["title"])
            except Exception as err:
                print(f'download_bd_sat err {err}')


    def read_sat(self,id_bands):
        id = self.comboBox_sat_json.currentText()
        self.selected_bands.clear()
        try:
            req_sat = requests.get(f'https://earthengine-stac.storage.googleapis.com/catalog/{id}/{id_bands}.json')
            sat_data = req_sat.json()
            pref_bands = sat_data['summaries']['gee:visualizations']
            self.predefined_bands.clear()
            for b in pref_bands:
                self.predefined_bands.addItem(b['display_name'])
        
            for i in sat_data['links']:
                try:
                    if i['type'] == 'image/png':
                        url = i["href"]
                        data = urllib.request.urlopen(url).read()
                        image = QImage()
                        image.loadFromData(data)                        
                        pixmap = QPixmap(image)
                        self.label_9.setPixmap(pixmap)
                except Exception as err:
                    print(f'read_sat err {err}')
            new_windget_config(self,get_data_from_catalog(self))
            self.load_bands()
        except Exception as e:
            print(f'{e}')

    def load_bands(self):
        data = get_data_from_catalog(self)
        self.list_bands.clear()
        for i in data["eoBands"]:
            self.list_bands.addItem(i['name'])

    def load_description(self,bands):
            data = get_data_from_catalog(self)
            for i in data["eoBands"]:
                try:
                    if i['name'] == bands:
                        descriptions = i["description"]
                    
                        self.textEdit.setText(f'{descriptions}')
                except Exception as e:
                    return 0

    def info_box(self):
        bands = self.comboBox_sat_bands_json.currentText()
        data = get_data_from_catalog(self)
        init_d = f'{data["init_date"][0]}-{data["init_date"][1]}-{data["init_date"][2]}'
        end_d = f'{data["end_date"][0]}-{data["end_date"][1]}-{data["end_date"][2]}'
        provider = ''
        for provi in data['prov']:
            provider = provider + '<p>  <a href="'+provi['url']+'">more info : '+provi['name']+'</a>  </p>'
        self.info.setText(f'{provider} Init date: {init_d} <br> end date: {end_d} <br> Save directory raster: {self.output_line.text()} <br> Cloud cover:{self.cloudcover.text()} <br> name: {bands} <br> config Sat: {self.combo_pross.currentText()}')
        self.info.setOpenExternalLinks(True)
    
    # def validate_selected_bands(self,bands_):

    #     for bs in range(self.selected_bands.count()):
    #         if self.selected_bands.item(bs).text() == bands_:
    #             return True
            
    def add_select_bands(self):
        try:
            band = self.list_bands.currentItem().text()
            self.list_bands.takeItem(self.list_bands.currentRow())
            self.selected_bands.addItem(band)
        except Exception as e:
            return 0
        

    def directory_save(self):
        file_directoy = QFileDialog.getSaveFileName(self,'Save Tiff',"","Tif File (*.tif);;all File (*)")
        self.output_line.setText(file_directoy[0])
        if self.output_line.text() != '':
            print(f'vacio')
        self.info_box()


    def remove_select_bands(self):
        try:
            band = self.selected_bands.currentItem().text()
            self.selected_bands.takeItem(self.selected_bands.currentRow())
            self.list_bands.addItem(band)
        except Exception as e:
            return 0
        
    def add_pref_bands(self):
        bands_selected = get_data_from_catalog(self)['bands']
        select = []
        rmv = []
        try:
            #buscamos las bandas predefinidas que seleccionamos
            for b in bands_selected:
                if b['display_name'] == self.predefined_bands.currentText():
                    select = b["image_visualization"]["band_vis"]["bands"]
            #agregamos a la lista seleccionada
            for b in select:
                if validate_selected_bands(self,b):
                    print(f'exist {b}')
                else:
                    self.selected_bands.addItem(b)
            #buscamos los indices de la seleccion 
            for b in range(self.list_bands.count()):
                for s in select:
                    if s == self.list_bands.item(b).text():
                        rmv.append(b)
            #removemos las bandas duplicadas con los indices de la seleccion
            for r in rmv:
                self.list_bands.takeItem(r)            
                                 
        except Exception as e:
            print(f'add_pref_bandas {e}') 

    def update_end_date(self,new_date):
        self.dateEdit_end.setDate(new_date.addDays(4))
        self.info_box()
    
    def update_dlg_startdate(self,end_date):
        if end_date <= self.dateEdit_ini.date():
            self.dateEdit_ini.setDate(end_date.addDays(-1))
        self.info_box()
    
    def change_bands(self):
        self.selected_bands.clear()
        self.load_bands()
    
    def get_config_data(self):
        date_init = self.dateEdit_ini.date().toString("yyyy-MM-dd")      
        date_end = self.dateEdit_end.date().toString("yyyy-MM-dd")
        out_path = self.output_line.text()
        cloud_cover = int(self.cloudcover.cleanText())
        e = self.ones.outputExtent()
        region = ee.Geometry.BBox(e.xMinimum(),e.yMinimum(),e.xMaximum(),e.yMaximum())

        return date_init,date_end,out_path,region,cloud_cover

    def create_task_from_fuction(self):
        if valid_data(self):
            self.progressBar.setValue(0)
            d_i,d_e,o_p,r,cc = self.get_config_data() #i = init date, e = end date, o_p output path, r roi, cc cloud cover
            resolution = self.resolution.text()
            jsonn = get_data_from_catalog(self)
            id_dataset = jsonn['id']
            btn = self.btn_output
            pross = self.combo_pross.currentText()
            sat_b = []
            for i in range(self.selected_bands.count()):
                b = self.selected_bands.item(i).text()
                sat_b.append(b)
            #simple task test
            #create_test_task()
            #------------------
            
            createTask(d_i,d_e,o_p,r,self.progressBar,id_dataset,cc,btn,sat_b,pross,resolution)
        else :
            create_message('Download Error','Error al descargar')
    
