# -*- coding: utf-8 -*-
"""
/***************************************************************************
 add_donerDialog
                                 A QGIS plugin
 Draw an ellipse
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-06-03
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Pavel Pereverzev
        email                : pasha004@yandex.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import math 
import json

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt import QtCore
from PyQt5.QtWidgets import QApplication, QWidget, QCheckBox, QLabel, QLineEdit, QGridLayout, QPushButton, QMessageBox
from qgis._core import *
from qgis.utils import iface

folder_documents = r"C:\Users\{}\Documents".format(os.environ['USERNAME'])
doner_folder = os.path.join(folder_documents, "mapDoner")
doner_folder_qgis = os.path.join(doner_folder, "qgis_doner")
cfg_file = os.path.join(doner_folder_qgis, 'cfg_doner_qgis.json')
layer_file = os.path.join(doner_folder_qgis, 'Doner.shp')

default_cfg = {
    "width": "90",
    "height": "90",
    "round": False,
    "apply_symbology": True
}

symbology_orange = {
    'border_width_map_unit_scale': '3x:0,0,0,0,0,0', 
    'color': '255,149,1,255', 
    'joinstyle': 'bevel', 
    'offset': '0,0', 
    'offset_map_unit_scale': 
    '3x:0,0,0,0,0,0', 
    'offset_unit': 'MM', 
    'outline_color': '35,35,35,255', 
    'outline_style': 'no', 
    'outline_width': '0.26', 
    'outline_width_unit': 'MM', 
    'style': 'solid'
}



class geom_get(object):
    def __init__(self):
        self.cfg = {}

    def readCfg(self):
        if os.path.isfile(cfg_file):
            with open(cfg_file, 'r') as fp:
                data = json.load(fp)
        else:
            data = default_cfg
            self.writeCfg(data)
        self.cfg = data
        return self.cfg

    def writeCfg(self, data_cfg):
        with open(cfg_file, "w", encoding='utf-8') as d:
            json.dump(data_cfg, d, indent=4, ensure_ascii=False)

    def get_extent(self):
        self.readCfg()
        wk = int(self.cfg["width"])/100
        hk = int(self.cfg["height"])/100
        qgs_extent = iface.mapCanvas().extent()
        fp = qgs_extent.center() 
        w = wk * qgs_extent.width() / 2
        h = hk * qgs_extent.height() / 2
        if int(self.cfg["round"]):
            w = h
        return fp, w, h

    def get_geom(self, pnt, w, h):
        list_circle =[]
        for i in range(0,36):
            an =math.radians(i * 10)
            np_x = pnt.x() + (w* math.sin(an))
            np_y = pnt.y() + (h* math.cos(an))
            pnt_new = QgsPointXY(np_x,np_y) 
            list_circle.append(pnt_new) 
        ellipse_geom = QgsGeometry.fromPolygonXY([list_circle])
        return ellipse_geom

    def edit_layer(self, layer, el_geom, method):
        d_geoms = list(layer.getFeatures())
        init_geometry = d_geoms[0].geometry() if d_geoms else None

        layer.startEditing()
        if method == "add":
            if init_geometry:
                polygon = el_geom.combine(init_geometry)
                last_id = d_geoms[0].id()
                layer.changeGeometry(last_id, polygon)
            else:
                new_feature = QgsFeature()
                new_feature.setFields(layer.fields())
                new_feature.setGeometry(el_geom)
                layer.dataProvider().addFeatures([new_feature])
        else:
            if init_geometry:
                polygon = init_geometry.difference(el_geom) 
                last_id = d_geoms[0].id()
                if not polygon.area(): 
                    layer.dataProvider().deleteFeatures([last_id])
                else:
                    layer.changeGeometry(last_id, polygon)
            else:
                pass
        layer.commitChanges()
        return


class doner_main(QWidget):
    def __init__(self, parent=None):
        """Constructor."""
        super(doner_main, self).__init__(parent)
        self.current_crs = QgsProject.instance().crs()
        self.geom_tool = geom_get()
        self.layer = self.check_layer()

    def layer_create(self, path):
        iface.mainWindow().blockSignals(True)
        tech_layer = QgsVectorLayer("MultiPolygon", 'Doner', path)
        tech_layer.setCrs(self.current_crs)
        iface.mainWindow().blockSignals(False)
        file_writer = QgsVectorFileWriter(
            vectorFileName=os.path.join(path), 
            fileEncoding='utf-8', 
            fields=tech_layer.fields(), 
            geometryType=6, 
            driverName='ESRI Shapefile'
        )
        del file_writer
        out_layer = QgsVectorLayer("MultiPolygon", 'Doner', path)
        return  

    def paint_layer(self, lyr):
        smb = QgsSimpleFillSymbolLayer.create(symbology_orange)
        symbol_new= QgsFillSymbol()
        symbol_new.appendSymbolLayer(smb.clone())
        symbol_new.deleteSymbolLayer(0)
        renderer = QgsSingleSymbolRenderer(symbol_new.clone())

        lyr.setRenderer(renderer)
        lyr.setOpacity(.5)
        lyr.renderer().setSymbol(symbol_new)
        lyr.triggerRepaint()
        return

    def check_layer(self):
        current_layer = iface.activeLayer()
        for dir_doner in [doner_folder, doner_folder_qgis]:
            if not os.path.isdir(dir_doner):
                os.mkdir(dir_doner)
        cfg = self.geom_tool.readCfg()
        d_layer = QgsProject.instance().mapLayersByName('Doner')
        if d_layer:
            doner_layer = d_layer[0]
        else:
            if not os.path.isfile(layer_file):
                self.layer_create(layer_file)
            doner_layer = QgsVectorLayer(layer_file, 'Doner', "ogr")
            QgsProject.instance().addMapLayer(doner_layer) 
            doner_layer.setCrs(self.current_crs)
        if int(cfg["apply_symbology"]):
            self.paint_layer(doner_layer)
        iface.setActiveLayer(current_layer)
        return doner_layer

    def add_ellipse(self):

        p,w,h = self.geom_tool.get_extent()
        geom_new = self.geom_tool.get_geom(p,w,h)
        self.geom_tool.edit_layer(self.layer, geom_new, 'add')

        self.layer.triggerRepaint()
        iface.mapCanvas().refresh()
        return

    def cut_ellipse(self):
        p,w,h = self.geom_tool.get_extent()
        geom_new = self.geom_tool.get_geom(p,w,h)
        self.geom_tool.edit_layer(self.layer, geom_new, 'cut')
        self.layer.triggerRepaint()
        iface.mapCanvas().refresh()
        return


class settings_window(QWidget):
    def __init__(self):
        super().__init__()
        self.initUI()
        self.setWindowTitle('Doner-settings')

    def readCfg(self):
        if os.path.isfile(cfg_file):
            with open(cfg_file, 'r') as fp:
                data = json.load(fp)
            
        else:
            self.writeCfg(default_cfg)
            data = default_cfg
        self.width.setText(data["width"])
        self.height.setText(data["height"])
        if data["round"]:
            self.check_round.setChecked(True)
        else:
            self.check_round.setChecked(False)
        if data["apply_symbology"]:
            self.check_paint.setChecked(True)
        else:
            self.check_paint.setChecked(False)
        self.state_w(self.check_round)

        return data

    def writeCfg(self, data_cfg):
        with open(cfg_file, "w", encoding='utf-8') as d:
            json.dump(data_cfg, d, indent=4, ensure_ascii=False)

    def initUI(self):
        """Настройка интерфейса
        """
        self.folder_path = r''
        self.setWindowFlags(self.windowFlags() | QtCore.Qt.WindowStaysOnTopHint)
        self.grid = QGridLayout()
        self.grid.setSpacing(10)

        # self.setGeometry(500, 500, 400, 520)

        self.lable_w = QLabel("Width, %")
        self.lable_h = QLabel("Height, %")
        self.lable_r = QLabel("Round")
        self.lable_p = QLabel("Paint")

        self.width = QLineEdit(self)
        self.height = QLineEdit(self)

        self.check_round = QCheckBox()
        self.check_paint = QCheckBox()

        self.btn_help = QPushButton("Help")
        self.btn_save = QPushButton("Save")

        self.setLayout(self.grid)

        self.grid.addWidget(self.lable_w, 0, 1, 1, 1)
        self.grid.addWidget(self.lable_h, 1, 1, 1, 1)
        self.grid.addWidget(self.width, 0, 2, 1, 1)
        self.grid.addWidget(self.height, 1, 2, 1, 1)

        self.grid.addWidget(self.lable_r, 2, 1, 1, 1)
        self.grid.addWidget(self.lable_p, 3, 1, 1, 1)

        self.grid.addWidget(self.check_round, 2, 2, 1, 1)
        self.grid.addWidget(self.check_paint, 3, 2, 1, 1)

        self.grid.addWidget(self.btn_help, 4, 1, 1, 2)
        self.grid.addWidget(self.btn_save, 5, 1, 1, 2)

        self.data_cfg = self.readCfg()

        self.check_round.stateChanged.connect(lambda:self.state_w(self.check_round))
        self.btn_help.clicked.connect(self.help)
        self.btn_save.clicked.connect(self.save)

        self.show()

    def state_w(self, chk_round):
        if chk_round.isChecked() == True:
            self.width.setDisabled(True)
        else:
            self.width.setDisabled(False)

    def warning_message(self, err_text):
        msg = QMessageBox()
        msg.warning(self, "Warning", err_text)

    def save(self):
        if not all(n.text().isdigit() and n.text()!="0" for n in [self.width, self.height]):
            self.warning_message("Enter valid numbers")
            return

        self.data_cfg["width"] = self.width.text()
        self.data_cfg["height"] = self.height.text()
        state_round = True if self.check_round.isChecked() else False
        state_paint = True if self.check_paint.isChecked() else False
        self.data_cfg["round"] = state_round
        self.data_cfg["apply_symbology"] = state_paint

        self.writeCfg(self.data_cfg)
        self.warning_message("Config has been saved")
        self.close()

    def help(self):
        os.system("start https://kylsha.github.io/doner/eng.html#qgis")
