# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ProtokolleVerknuepfen
                                 A QGIS plugin
 Werkzeuge rund um das Kanalmanagement
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-11-01
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Armin Matzl
        email                : arminmatzl@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import math
import sqlite3
import pandas as pd
import json
from datetime import datetime
from qgis.PyQt.QtCore import Qt, QRegExp, QLine, pyqtSignal, QSignalBlocker, QVariant, QDateTime
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtGui import  QRegExpValidator
from qgis.utils import iface
from qgis.gui import QgsMessageBar, QgsMapToolIdentifyFeature, QgsMapToolPan, QgsSpinBox
from qgis.core import QgsVectorLayer, QgsMessageLog, QgsGeometry, Qgis, QgsProject, QgsFeature,QgsPoint, edit,QgsExpressionContextUtils
from qgis.PyQt.QtWidgets import (QMessageBox, QCompleter, QDialog, QGridLayout, QLabel, QComboBox,
                                QDialogButtonBox,QTableWidgetItem, QTableWidget,
                                QLineEdit, QStyledItemDelegate, QListWidget, QListWidgetItem, QCheckBox,
                                QHBoxLayout, QPushButton)


# eigene klassen
from ..tools.mapIdentify import selectTool
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__),"../","ui", 'protokolle_oeffnen.ui'))


class Open(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()
    load_haltung = pyqtSignal()
    load_schacht = pyqtSignal()
    #load_leitung = pyqtSignal()

    def __init__(self,iface, parent=None):
        """Constructor."""
        super(Open, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setCursor(Qt.WaitCursor)
        self.iface = iface
        self.setupUi(self)
        #self.txt_haltungID.setVisible(False) # Textfeld mit HaltungsID verbergen
        #self.load_attribute_names_to_dict()
        self.setup_ui_dict()
        #self.haltungNr_add_completer()
        #self.schachtNr_add_completer()
        self.pfad_dict = {}
        for typ in ("haltung", "schacht", "leitung"):
            if self.setup_dict[typ]["vorhanden"]:
                self.add_completer(typ)
                
                self.setup_dict[typ]["ui"]["button_select"].clicked.connect(lambda t, layer=self.layer_object[typ], id = self.setup_dict[typ]["variablen"]["attribut_id"], typ = typ: self.select_object(layer,id, typ))
                self.setup_dict[typ]["ui"]["txt_nr"].returnPressed.connect(lambda typ = typ: self.load_layer_from_textField(typ))
                self.setup_dict[typ]["ui"]["txt_nr"].textEdited.connect(lambda t, typ=typ: self.change_txt_col(typ))

                self.pfad_dict[typ] = {}
                for doc, ui_dict in self.setup_dict[typ]["ui"].items():
                    if isinstance(ui_dict,dict):
                        self.pfad_dict[typ][doc] = {
                                                        "pfad" : [],
                                                        "datum" : []
                                                    }
        self.setup_dict["haltung"]["ui"]["protokoll"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["haltung"]["protokoll"]["pfad"][self.setup_dict["haltung"]["ui"]["protokoll"]["combobox"].currentIndex()]))
        self.setup_dict["haltung"]["ui"]["dp"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["haltung"]["dp"]["pfad"][self.setup_dict["haltung"]["ui"]["dp"]["combobox"].currentIndex()]))
        self.setup_dict["haltung"]["ui"]["video"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["haltung"]["video"]["pfad"][self.setup_dict["haltung"]["ui"]["video"]["combobox"].currentIndex()]))
        self.setup_dict["haltung"]["ui"]["andere"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["haltung"]["andere"]["pfad"][self.setup_dict["haltung"]["ui"]["andere"]["combobox"].currentIndex()]))
        self.setup_dict["haltung"]["ui"]["button_protokoll_video"].clicked.connect(lambda: self.open_file(self.pfad_dict["haltung"]["protokoll"]["pfad"][self.setup_dict["haltung"]["ui"]["protokoll"]["combobox"].currentIndex()],self.pfad_dict["haltung"]["video"]["pfad"][self.setup_dict["haltung"]["ui"]["video"]["combobox"].currentIndex()]))

        self.setup_dict["schacht"]["ui"]["protokoll"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["schacht"]["protokoll"]["pfad"][self.setup_dict["schacht"]["ui"]["protokoll"]["combobox"].currentIndex()]))
        self.setup_dict["schacht"]["ui"]["dp"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["schacht"]["dp"]["pfad"][self.setup_dict["schacht"]["ui"]["dp"]["combobox"].currentIndex()]))
        self.setup_dict["schacht"]["ui"]["video"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["schacht"]["video"]["pfad"][self.setup_dict["schacht"]["ui"]["video"]["combobox"].currentIndex()]))
        self.setup_dict["schacht"]["ui"]["andere"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["schacht"]["andere"]["pfad"][self.setup_dict["schacht"]["ui"]["andere"]["combobox"].currentIndex()]))
        self.setup_dict["schacht"]["ui"]["button_protokoll_video"].clicked.connect(lambda: self.open_file(self.pfad_dict["schacht"]["protokoll"]["pfad"][self.setup_dict["schacht"]["ui"]["andere"]["combobox"].currentIndex()],self.pfad_dict["schacht"]["video"]["pfad"][self.setup_dict["schacht"]["ui"]["andere"]["combobox"].currentIndex()]))

        self.setup_dict["leitung"]["ui"]["protokoll"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["leitung"]["protokoll"]["pfad"][self.setup_dict["leitung"]["ui"]["protokoll"]["combobox"].currentIndex()]))
        self.setup_dict["leitung"]["ui"]["dp"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["leitung"]["dp"]["pfad"][self.setup_dict["leitung"]["ui"]["dp"]["combobox"].currentIndex()]))
        self.setup_dict["leitung"]["ui"]["video"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["leitung"]["video"]["pfad"][self.setup_dict["leitung"]["ui"]["video"]["combobox"].currentIndex()]))
        self.setup_dict["leitung"]["ui"]["andere"]["button"].clicked.connect(lambda: self.open_file(self.pfad_dict["leitung"]["andere"]["pfad"][self.setup_dict["leitung"]["ui"]["andere"]["combobox"].currentIndex()]))
        self.setup_dict["leitung"]["ui"]["button_protokoll_video"].clicked.connect(lambda: self.open_file(self.pfad_dict["leitung"]["protokoll"]["pfad"][self.setup_dict["leitung"]["ui"]["andere"]["combobox"].currentIndex()],self.pfad_dict["leitung"]["video"]["pfad"][self.setup_dict["leitung"]["ui"]["andere"]["combobox"].currentIndex()]))

        self.setup_dict["haltung"]["ui"]["button_zoom"].clicked.connect(lambda: self.zoom_to_object(self.layer_object["haltung"], self.features["haltung"].id()))
        self.setup_dict["schacht"]["ui"]["button_zoom"].clicked.connect(lambda: self.zoom_to_object(self.layer_object["schacht"], self.features["schacht"].id()))
        self.setup_dict["leitung"]["ui"]["button_zoom"].clicked.connect(lambda: self.zoom_to_object(self.layer_object["leitung"], self.features["leitung"].id()))

        #connectors definieren

        """
        self.button_select_haltung.clicked.connect(lambda: self.select_object(self.layer_object["haltung"],self.variablen["attribut_haltungNr"], "Haltung"))
        self.txt_haltungNr.returnPressed.connect(lambda: self.load_layer_from_textField("Haltung"))
        self.txt_haltungNr.textEdited.connect(self.change_col_haltungNr)

        self.button_select_schacht.clicked.connect(lambda: self.select_object(self.layer_object["schacht"],self.variablen["attribut_schachtNr"],"Schacht"))
        self.txt_schachtNr.returnPressed.connect(lambda: self.load_layer_from_textField("Schacht"))
        self.txt_schachtNr.textEdited.connect(self.change_col_schachtNr)

        self.button_h_protokoll.clicked.connect(lambda: self.open_file(self.tv_pfad[self.h_combobox_protokoll.currentIndex()]))
        self.button_h_dp.clicked.connect(lambda: self.open_file(self.druck_pfad[self.h_combobox_druck.currentIndex()]))
        self.button_h_video.clicked.connect(lambda: self.open_file(self.video_pfad[self.h_combobox_video.currentIndex()]))
        self.button_h_protokoll_video.clicked.connect(lambda: self.open_file(self.tv_pfad[self.button_h_protokoll.currentIndex()],self.video_pfad[self.combobox_video.currentIndex()]))
        self.button_zoom_haltung.clicked.connect(lambda: self.zoom_to_object(self.layer_object["haltung"], self.features["haltung"].id()))
        
        self.button_s_protokoll.clicked.connect(lambda: self.open_file(self.protokoll_pfad[self.s_combobox_protokoll.currentIndex()]))
        self.button_s_video_schacht.clicked.connect(lambda: self.open_file(self.video_schacht_pfad[self.s_combobox_video.currentIndex()]))
        self.button_s_protokoll_video.clicked.connect(lambda: self.open_file(self.protokoll_pfad[self.s_combobox_protokoll.currentIndex()],self.video_schacht_pfad[self.s_combobox_video.currentIndex()]))
        self.button_zoom_schacht.clicked.connect(lambda: self.zoom_to_object(self.layer_object["schacht"], self.features["schacht"].id()))

        #wenn leitung definiert dann leitung initialisieren

        if self.leitung_defined:
            self.leitungNr_add_completer()

            self.button_select_leitung.clicked.connect(lambda: self.select_object(self.layer_object["leitung"],self.variablen["attribut_leitungNr"], "Leitung"))
            self.txt_leitungNr.returnPressed.connect(lambda: self.load_layer_from_textField("Leitung"))
            self.txt_leitungNr.textEdited.connect(self.change_col_leitungNr)

            self.button_tv_leitung.clicked.connect(lambda: self.open_file(self.tv_pfad_leitung[self.combobox_tv_leitung.currentIndex()]))
            self.button_druck_leitung.clicked.connect(lambda: self.open_file(self.druck_pfad_leitung[self.combobox_druck_leitung.currentIndex()]))
            self.button_video_leitung.clicked.connect(lambda: self.open_file(self.video_pfad_leitung[self.combobox_video_leitung.currentIndex()]))
            self.button_tv_video_leitung.clicked.connect(lambda: self.open_file(self.tv_pfad_leitung[self.combobox_tv_leitung.currentIndex()],self.video_pfad_leitung[self.combobox_video_leitung.currentIndex()]))
            self.button_zoom_leitung.clicked.connect(lambda: self.zoom_to_object(self.layer_object["leitung"], self.features["leitung"].id()))
        else:
            self.tabWidget.removeTab(2)
        
        """
        self.tabWidget.currentChanged.connect(self.tab_changed)
        
        self.setCursor(Qt.ArrowCursor)

   
    def tab_changed(self,tab_nr):
        try:
            tool = self.iface.mapCanvas().mapTool().toolName()

            if tool == "Kanalmanagement Objekt abfragen":
                lab = self.tabWidget.tabText(tab_nr)[0].lower() + self.tabWidget.tabText(tab_nr)[1:]
                self.select_object(self.layer_object[lab],self.setup_dict[lab]["variablen"]["attribut_id"], lab)
        except:
            pass

    def setup_ui_dict(self):
        saved_dict = json.loads(QgsExpressionContextUtils.projectScope(QgsProject.instance()).variable('Dokumente_Setup'))
        self.setup_dict = {
            "haltung" : {
                "ui": {
                    "protokoll":
                    {
                        "label" : self.h_protokoll_label,
                        "txt" : self.txt_h_protokoll_anzahl,
                        "combobox" : self.h_combobox_protokoll,
                        "button" : self.button_h_protokoll
                    },
                    "dp" :
                    {
                        "label" : self.h_dp_label,
                        "txt" : self.txt_h_dp_anzahl,
                        "combobox" : self.h_combobox_dp,
                        "button" : self.button_h_dp
                    },
                    "video":
                    {
                        "label" : self.h_video_label,
                        "txt" : self.txt_h_video_anzahl,
                        "combobox" : self.h_combobox_video,
                        "button" : self.button_h_video
                    },
                    "andere":
                    {
                        "label" : self.h_andere_label,
                        "txt" : self.txt_h_andere_anzahl,
                        "combobox" : self.h_combobox_andere,
                        "button" : self.button_h_andere
                    },
                    "button_select" : self.button_select_haltung,
                    "txt_nr" : self.txt_haltungNr,
                    "txt_ergebnisDP" : self.txt_h_ergebnisDP,
                    "button_zoom" : self.button_zoom_haltung,
                    "button_protokoll_video" : self.button_h_protokoll_video
                },
                "variablen": {
                    "layer_protokolle" : "Dateien_Haltung",
                    "layer_id" : saved_dict["haltung"]["layer_id"],
                    "attribut_id" : saved_dict["haltung"]["attribut_id"],
                    "1_attribut" : saved_dict["haltung"]["1_attribut"],
                    "attribut1" : saved_dict["haltung"]["attribut1"],
                    "attribut2" : saved_dict["haltung"]["attribut2"],
                    "typ" : saved_dict["haltung"]["typ"],
                    "bezeichnung_protokoll" : saved_dict["haltung"]["bezeichnung_protokoll"],
                    "bezeichnung_dp" : saved_dict["haltung"]["bezeichnung_dp"] ,
                    "bezeichnung_video" : saved_dict["haltung"]["bezeichnung_video"],
                    "ergebnis_dp" : saved_dict["haltung"]["ergebnis_dp"],
                    "tab_id": 0
                }
            },
            "schacht": {
                "ui": {
                    "protokoll":
                    {
                        "label" : self.s_protokoll_label,
                        "txt" : self.txt_s_protokoll_anzahl,
                        "combobox" : self.s_combobox_protokoll,
                        "button" : self.button_s_protokoll
                    },
                    "dp" :
                    {
                        "label" : self.s_dp_label,
                        "txt" : self.txt_s_dp_anzahl,
                        "combobox" : self.s_combobox_dp,
                        "button" : self.button_s_dp
                    },
                    "video":
                    {
                        "label" : self.s_video_label,
                        "txt" : self.txt_s_video_anzahl,
                        "combobox" : self.s_combobox_video,
                        "button" : self.button_s_video
                    },
                    "andere":
                    {
                        "label" : self.s_andere_label,
                        "txt" : self.txt_s_andere_anzahl,
                        "combobox" : self.s_combobox_andere,
                        "button" : self.button_s_andere
                    },
                    "button_select" : self.button_select_schacht,
                    "txt_nr" : self.txt_schachtNr,
                    "txt_ergebnisDP" : self.txt_s_ergebnisDP,
                    "button_zoom" : self.button_zoom_schacht,
                    "button_protokoll_video" : self.button_s_protokoll_video
                },
                "variablen": {
                    "layer_protokolle" : "Dateien_Schacht",
                    "layer_id" : saved_dict["schacht"]["layer_id"],
                    "attribut_id" : saved_dict["schacht"]["attribut_id"],
                    "1_attribut" : saved_dict["schacht"]["1_attribut"],
                    "attribut1" : saved_dict["schacht"]["attribut1"],
                    "attribut2" : saved_dict["schacht"]["attribut2"],
                    "typ" : saved_dict["schacht"]["typ"],
                    "bezeichnung_protokoll" : saved_dict["schacht"]["bezeichnung_protokoll"],
                    "bezeichnung_dp" : saved_dict["schacht"]["bezeichnung_dp"] ,
                    "bezeichnung_video" : saved_dict["schacht"]["bezeichnung_video"],
                    "ergebnis_dp" : saved_dict["schacht"]["ergebnis_dp"],
                    "tab_id": 1
                }
            },
            "leitung": {
                "ui": {
                    "protokoll":
                    {
                        "label" : self.l_protokoll_label,
                        "txt" : self.txt_l_protokoll_anzahl,
                        "combobox" : self.l_combobox_protokoll,
                        "button" : self.button_l_protokoll
                    },
                    "dp" :
                    {
                        "label" : self.l_dp_label,
                        "txt" : self.txt_l_dp_anzahl,
                        "combobox" : self.l_combobox_dp,
                        "button" : self.button_l_dp
                    },
                    "video":
                    {
                        "label" : self.l_video_label,
                        "txt" : self.txt_l_video_anzahl,
                        "combobox" : self.l_combobox_video,
                        "button" : self.button_l_video
                    },
                    "andere":
                    {
                        "label" : self.l_andere_label,
                        "txt" : self.txt_l_andere_anzahl,
                        "combobox" : self.l_combobox_andere,
                        "button" : self.button_l_andere
                    },
                    "button_select" : self.button_select_leitung,
                    "txt_nr" : self.txt_leitungNr,
                    "txt_ergebnisDP" : self.txt_l_ergebnisDP,
                    "button_zoom" : self.button_zoom_leitung,
                    "button_protokoll_video" : self.button_l_protokoll_video
                },
                "variablen": {
                    "layer_protokolle" : "Dateien_Leitung",
                    "layer_id" : saved_dict["leitung"]["layer_id"],
                    "attribut_id" : saved_dict["leitung"]["attribut_id"],
                    "1_attribut" : saved_dict["leitung"]["1_attribut"],
                    "attribut1" : saved_dict["leitung"]["attribut1"],
                    "attribut2" : saved_dict["leitung"]["attribut2"],
                    "typ" : saved_dict["leitung"]["typ"],
                    "bezeichnung_protokoll" : saved_dict["leitung"]["bezeichnung_protokoll"],
                    "bezeichnung_dp" : saved_dict["leitung"]["bezeichnung_dp"] ,
                    "bezeichnung_video" : saved_dict["leitung"]["bezeichnung_video"],
                    "ergebnis_dp" : saved_dict["leitung"]["ergebnis_dp"],
                    "tab_id": 2
                }
            },
            "allgemein": {
                    "trennzeichen" : saved_dict["trennzeichen"],
                    "datum" : saved_dict["datum"],
                    "case_bezeichnung" : saved_dict["case_bezeichnung"],
                    "case_attribut" : saved_dict["case_attribut"],
                    "case_typ" : saved_dict["case_typ"],
                    "zoom_massstab" : saved_dict["zoom_massstab"],
                    "ignorieren" : saved_dict["ignorieren"],
                    "db_protokolle_path" : saved_dict["db_protokolle_path"]
            }  
        }

        self.layer_object = {}
        del_tabs = []
        for typ, values in self.setup_dict.items():
            if typ != "allgemein":
                typ_dict = self.setup_dict[typ]
                if QgsProject.instance().mapLayer(typ_dict["variablen"]["layer_id"]) == None:
                    #self.tabWidget.removeTab(typ_dict["variablen"]["tab_id"])
                    del_tabs.append(typ_dict["variablen"]["tab_id"])
                    typ_dict["vorhanden"] = False
                    continue

                else:
                    typ_dict["vorhanden"] = True
                    if QgsProject.instance().mapLayer(typ_dict["variablen"]["layer_id"]).isValid():
                        self.layer_object[typ] = QgsProject.instance().mapLayer(typ_dict["variablen"]["layer_id"])
                        self.layer_object[f"{typ}_clone"] = QgsProject.instance().mapLayer(typ_dict["variablen"]["layer_id"]).clone()
                if typ_dict["variablen"]["bezeichnung_protokoll"][0] == "":
                    for element in typ_dict["ui"]["protokoll"].values():
                        element.hide()
                    typ_dict["ui"]["protokoll"]["vorhanden"] = False
                else:
                    typ_dict["ui"]["protokoll"]["vorhanden"] = True

                if typ_dict["variablen"]["bezeichnung_dp"][0] == "":
                    for element in typ_dict["ui"]["dp"].values():
                        element.hide()
                    typ_dict["ui"]["dp"]["vorhanden"] = False
                else:
                    typ_dict["ui"]["dp"]["vorhanden"] = True

                if typ_dict["variablen"]["bezeichnung_video"][0] == "":
                    for element in typ_dict["ui"]["video"].values():
                        element.hide()
                    typ_dict["ui"]["video"]["vorhanden"] = False
                else:
                    typ_dict["ui"]["video"]["vorhanden"] = True
                typ_dict["ui"]["andere"]["vorhanden"] = True

        self.features = {}

        for nr in sorted(del_tabs, reverse = True):
            self.tabWidget.removeTab(nr)

        
        

    def closeEvent(self, event):
        """
        Wird bei beenden des Fenserts ausgeführt
        """
        self.closingPlugin.emit()
        event.accept()
        panTool = QgsMapToolPan(self.iface.mapCanvas())
        self.iface.mapCanvas().setMapTool(panTool)
        self.deleteLater()

    def add_completer(self,typ):
        """
        Fügt einen Completer für QLineEdit des eindeutigen Objektnamen für manuelle Eingabe ein
        """
        id_idx = self.layer_object[typ].fields().indexOf(self.setup_dict[typ]["variablen"]["attribut_id"])
        objekte = sorted(self.layer_object[typ].uniqueValues(id_idx))
        objekte = [str(element) for element in objekte if not isinstance(element,QVariant)]
        completer = QCompleter(objekte)
        completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.setup_dict[typ]["ui"]["txt_nr"].setCompleter(completer)

    def select_object(self, selection_layer, name_shown, object_type):
        """
        Aktion zum Wählen einer Haltung
        """
        self.selection = selectTool(iface = self.iface,
                                    name_shown = name_shown, #Attribut das in Auswahl angezeigt wird
                                    selection_layer = selection_layer
                                    )
        self.selection.objectFound.connect(lambda feature, object_type = object_type: self.feature_selected(feature, object_type))
        self.iface.mapCanvas().setMapTool(self.selection)
    
    def feature_selected(self,feature, object_type):
        self.features[object_type] = feature
        self.load_layer(object_type = object_type)
    
    def change_txt_col(self,typ, valid =None):
        if valid != None:
            self.setup_dict[typ]["ui"]["txt_nr"].setStyleSheet("")
            self.setup_dict[typ]["ui"]["button_zoom"].setEnabled(True)
        else:
            self.setup_dict[typ]["ui"]["txt_nr"].setStyleSheet("QLineEdit::editable {background-color: orange;}")
            self.setup_dict[typ]["ui"]["button_zoom"].setEnabled(False)

    def load_layer_from_textField(self, object_type):
        self.setCursor(Qt.WaitCursor)
        objekt = self.setup_dict[object_type]
        filter = self.layer_object[object_type].subsetString()
        self.layer_object[f"{object_type}_clone"].setSubsetString(f"{objekt['variablen']['attribut_id']}='{objekt['ui']['txt_nr'].text()}'")

        error_msg = {
            "haltung" : ["Haltung nicht gefunden", "Die angegebene Haltungsnummer ist ungültig."],
            "schacht" : ["Schacht nicht gefunden", "Die angegebene Schachtnummer ist ungültig."],
            "leitung" : ["Leitung nicht gefunden", "Die angegebene Leitungsnummer ist ungültig."]
        }

        if self.layer_object[f"{object_type}_clone"].featureCount() == 1:
            feature = QgsFeature()
            self.layer_object[f"{object_type}_clone"].getFeatures().nextFeature(feature)
            self.features[object_type] = feature
            self.load_layer(load_from_txt_field = True, object_type = object_type)
            self.change_txt_col(object_type, valid = True)
        else:
            self.clear_all(object_type)
            self.iface.messageBar().pushMessage(error_msg[object_type][0],error_msg[object_type][1], level=Qgis.Warning, duration=2)
            #self.setup_dict[object_type]["ui"]["button_zoom"].setEnabled(False)
        self.layer_object[f"{object_type}_clone"].setSubsetString(filter)
        
        self.setCursor(Qt.ArrowCursor)

    def load_layer(self, object_type, load_from_txt_field = False): 
        objekt = self.setup_dict[object_type]          
        if not load_from_txt_field:
            self.setup_dict[object_type]["ui"]["txt_nr"].setText(self.features[object_type].attribute(objekt["variablen"]["attribut_id"]))
        self.change_txt_col(object_type, valid = True)        

        if objekt["ui"]["dp"]["vorhanden"]:    
            try:
                ergebnisDP = str(self.features[object_type].attribute(objekt["variablen"]["ergebnis_dp"]))
            except:
                ergebnisDP = 'NULL'
            if ergebnisDP == "NULL":
                ergebnisDP = "keine DP"
            objekt["ui"]["txt_ergebnisDP"].setText(ergebnisDP)
            self.change_col_ergebnisDP(object_type)

        #self.load_haltung.emit()

        self.load_protokolle(object_type)
 
    def clear_all(self,object_type):
        #for objekt, typ_dict in self.setup_dict.items():
        #    if objekt != "allgemein":
        #        if typ_dict["vorhanden"]:
        for typ, ui_dict in self.setup_dict[object_type]["ui"].items():
            if isinstance(ui_dict,dict):
                if ui_dict["vorhanden"]:
                    ui_dict["txt"].setText("")
                    ui_dict["combobox"].clear()
                    ui_dict["button"].setEnabled(False)
        #typ_dict["ui"]["txt_nr"].setText("")
        self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].setText("")
        self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].setStyleSheet("")
        self.setup_dict[object_type]["ui"]["button_zoom"].setEnabled(False)
        self.setup_dict[object_type]["ui"]["button_protokoll_video"].setEnabled(False)

 
    def zoom_to_object(self,layer, id):
        layer.selectByIds([id], QgsVectorLayer.SetSelection)
        bbox = layer.boundingBoxOfSelected()
        self.iface.mapCanvas().setExtent(bbox)
        scale = self.setup_dict["allgemein"]["zoom_massstab"]
        self.iface.mapCanvas().zoomScale(scale)
        self.iface.mapCanvas().refresh()

    ################
    #
    # hier weiter coden
    #
    ###############
    def load_protokolle(self, object_type):
        objekt = self.setup_dict[object_type]
        protokolle = QgsVectorLayer(self.setup_dict["allgemein"]["db_protokolle_path"]+"|layername="+self.setup_dict[object_type]["variablen"]["layer_protokolle"], "Protokolle", "ogr")
        if objekt["variablen"]["1_attribut"]:
            if self.setup_dict["allgemein"]["case_attribut"]:
                protokolle.setSubsetString(f"lower(attribut1) = lower('{self.features[object_type].attribute(objekt['variablen']['attribut1'])}')")
            else:
                protokolle.setSubsetString(f"attribut1 = '{self.features[object_type].attribute(objekt['variablen']['attribut1'])}'")
        else:
            if self.setup_dict["allgemein"]["case_attribut"]:
                protokolle.setSubsetString(f"lower(attribut1) = lower('{self.features[object_type].attribute(objekt['variablen']['attribut1'])}') and lower(attribut2) = lower('{self.features[object_type].attribute(objekt['variablen']['attribut2'])}')")
            else:
                protokolle.setSubsetString(f"attribut1 = '{self.features[object_type].attribute(objekt['variablen']['attribut1'])}' and attribut2 = '{self.features[object_type].attribute(objekt['variablen']['attribut2'])}'")

        for doc, ui_dict in self.setup_dict[object_type]["ui"].items():
            if isinstance(ui_dict,dict):
                self.pfad_dict[object_type][doc] = {
                    "pfad" : [],
                    "datum" : []
                }

        for feature in protokolle.getFeatures():
            if feature.attribute("bezeichnung") in [i.lower() if self.setup_dict["allgemein"]["case_bezeichnung"] else i for i in objekt["variablen"]["bezeichnung_protokoll"]]:
                self.pfad_dict[object_type]["protokoll"]["pfad"].append(feature.attribute("pfad"))
                if feature.attribute("datum") != '':
                    self.pfad_dict[object_type]["protokoll"]["datum"].append(feature.attribute("datum"))
                else:
                    self.pfad_dict[object_type]["protokoll"]["datum"].append("1900-01-01 00:00:00") # wenn datum fehlt
            elif feature.attribute("bezeichnung") in [i.lower() if self.setup_dict["allgemein"]["case_bezeichnung"] else i for i in objekt["variablen"]["bezeichnung_video"]]:
                self.pfad_dict[object_type]["video"]["pfad"].append(feature.attribute("pfad"))
                if feature.attribute("datum") != '':
                    self.pfad_dict[object_type]["video"]["datum"].append(feature.attribute("datum"))
                else:
                    self.pfad_dict[object_type]["video"]["datum"].append("1900-01-01 00:00:00")
            elif feature.attribute("bezeichnung") in [i.lower() if self.setup_dict["allgemein"]["case_bezeichnung"] else i for i in objekt["variablen"]["bezeichnung_dp"]]:
                self.pfad_dict[object_type]["dp"]["pfad"].append(feature.attribute("pfad"))
                if feature.attribute("datum") != '':
                    self.pfad_dict[object_type]["dp"]["datum"].append(feature.attribute("datum"))
                else:
                    self.pfad_dict[object_type]["dp"]["datum"].append("1900-01-01 00:00:00")
            elif feature.attribute("bezeichnung") is not None and feature.attribute("typ") in [i.lower() if self.setup_dict["allgemein"]["case_typ"] else i for i in objekt["variablen"]["typ"]]:
                self.pfad_dict[object_type]["andere"]["pfad"].append(feature.attribute("pfad"))
                if feature.attribute("datum") != '':
                    self.pfad_dict[object_type]["andere"]["datum"].append(feature.attribute("datum"))
                else:
                    self.pfad_dict[object_type]["andere"]["datum"].append("1900-01-01 00:00:00")
        
        counter = 0
        for doc, ui_dict in self.setup_dict[object_type]["ui"].items():
            if isinstance(ui_dict,dict):
                datum_strp = self.pfad_dict[object_type][doc]["datum"]

                protokoll_zip = sorted(zip(datum_strp,self.pfad_dict[object_type][doc]["datum"],self.pfad_dict[object_type][doc]["pfad"]), reverse = True)
                datum_strp = [a for a,b,c in protokoll_zip]
                self.pfad_dict[object_type][doc]["datum"] = [a.toString("dd.MM.yyyy") for a,b,c in protokoll_zip]
                self.pfad_dict[object_type][doc]["pfad"] = [c for a,b,c in protokoll_zip]
                counter += len(self.pfad_dict[object_type][doc]["pfad"])                

            
                # auswahl in combobox einfügen
                ui_dict["combobox"].clear()
                ui_dict["txt"].setText("")
                if len(self.pfad_dict[object_type][doc]["pfad"]) != 0:
                    pfad_short = [os.path.basename(f) for f in self.pfad_dict[object_type][doc]["pfad"]]
                    lst = [list(i) for i in zip(self.pfad_dict[object_type][doc]["datum"],pfad_short)]
                    lst = [":  ".join(i) for i in lst]
                    ui_dict["combobox"].addItems(lst)
                    ui_dict["txt"].setText(str(len(self.pfad_dict[object_type][doc]["pfad"])))
                    ui_dict["button"].setEnabled(True)
                else:
                    ui_dict["button"].setEnabled(False)
            
        #button tv-protokoll+video ein bzw ausschalten
        if len(self.pfad_dict[object_type]["video"]["pfad"]) != 0 and len(self.pfad_dict[object_type]["protokoll"]["pfad"]) != 0:
            self.setup_dict[object_type]["ui"]["button_protokoll_video"].setEnabled(True)
        else:
            self.setup_dict[object_type]["ui"]["button_protokoll_video"].setEnabled(False)
        if counter == 0:
            if object_type == "haltung":
                self.iface.messageBar().pushMessage("Fehlende Inspektionsdaten", "Zu dieser Haltung wurden keine Inspektionsdaten gefunden", level=Qgis.Warning, duration=3)
            elif object_type == "schacht":
                self.iface.messageBar().pushMessage("Fehlende Inspektionsdaten", "Zu diesem Schacht wurden keine Inspektionsdaten gefunden", level=Qgis.Warning, duration=3)
            elif object_type == "leitung":
                self.iface.messageBar().pushMessage("Fehlende Inspektionsdaten", "Zu dieser Leitung wurden keine Inspektionsdaten gefunden", level=Qgis.Warning, duration=3)

        else:
            self.iface.messageBar().pushMessage("Inspektionsdaten geladen.", f"Inspektionsdaten von {object_type[0].upper()+object_type[1:]} {self.setup_dict[object_type]['ui']['txt_nr'].text()} erfolgreich geladen.", level=Qgis.Success, duration=2)

    def open_file(self,file1, file2 = None, file3 = None):
        if file1 != None:
            try:
                os.startfile(file1)
            except:
                QMessageBox.warning(self,"Fehler!",f"Datei<br><b>{file1}</b><br>konnte nicht geöffnet werden.<br>Womöglich wurde die Datei verschoben.<br>Funktion 'Inspektionsdaten verknüpfen' erneut ausführen und neue Datenbank erstellen'")
        if file2 != None:
            try:
                os.startfile(file2)
            except:
                QMessageBox.warning(self,"Fehler!",f"Datei<br><b>{file2}</b><br> konnte nicht geöffnet werden.<br>Womöglich wurde die Datei verschoben.<br>Funktion 'Inspektionsdaten verknüpfen' erneut ausführen und neue Datenbank erstellen'")
        if file3 != None:
            try:
                os.startfile(file3)
            except:
                QMessageBox.warning(self,"Fehler!",f"Datei<br><b>{file3}</b><br>konnte nicht geöffnet werden.<br>Womöglich wurde die Datei verschoben.<br>Funktion 'Inspektionsdaten verknüpfen' erneut ausführen und neue Datenbank erstellen'")


    def change_col_ergebnisDP(self, object_type):
        txt = self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].text().lower()
        if "undicht" in txt:
            self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].setStyleSheet("QLabel {background-color: #ff3030;}")
        elif "dicht" in txt:
            self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].setStyleSheet("QLabel {background-color: #aaff00;}")
        elif "keine" in txt or "nicht" in txt:
            self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].setStyleSheet("QLabel {background-color: orange;}")
        else:
            self.setup_dict[object_type]["ui"]["txt_ergebnisDP"].setStyleSheet("")