# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DocumentConnector
                                 A QGIS plugin
 With this Plugin documents can be connected to objects. It is designed for sewer system inspection data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-11-03
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Armin Matzl
        email                : arminmatzl@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QDockWidget
from qgis.core import QgsProject

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
#from .document_connector_dialog import DocumentConnectorDialog
from .code.Einstellungen import Einstellungen, InputChecker
from .code.ProtokolleVerknuepfen import Link
from .code.ProtokolleOeffnen import Open
import os.path


class DocumentConnector:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'DocumentConnector_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Dokumente verknüpfen')
        self.toolbar = self.iface.addToolBar(u"Dokumente")
        self.toolbar.setObjectName(u"Dokumente")

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.protokolleOeffnenisActive = False
        QgsProject.instance().homePathChanged.connect(self.checkInput)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('DocumentConnector', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
        check_input = False):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)
        
        action.check_input = check_input
        self.actions.append(action)


        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_dir = ':/plugins/document_connector/icons'
        """self.add_action(
            icon_path,
            text=self.tr(u'Dokumente verknüpfen'),
            callback=self.run,
            parent=self.iface.mainWindow())"""
        self.add_action(
            os.path.join(icon_dir,"einstellungen.png"),
            text=self.tr(u'Einstellungen'),
            callback=self.run_einstellungen,
            parent=self.iface.mainWindow())
        
        self.add_action(
            os.path.join(icon_dir,"link.png"),
            text=self.tr(u'Dateien verknüpfen'),
            callback=self.run_link,
            parent=self.iface.mainWindow())
        
        self.add_action(
            os.path.join(icon_dir,"kamera.png"),
            text=self.tr(u'Dateien öffnen'),
            callback=self.run_open,
            parent=self.iface.mainWindow(),
            check_input = True)

        # will be set False in run()
        self.first_start = True
        self.checkInput()


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Dokumente verknüpfen'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            #self.dlg = DocumentConnectorDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def run_einstellungen(self):
        dlg = Einstellungen(self.iface)
        dlg.okpressed.connect(self.checkInput)
        dlg.okpressed.connect(self.reload_open)
        dlg.show()
        dlg.exec_()
    
    def run_link(self):
        dlg = Link()
        dlg.okpressed.connect(self.checkInput)
        dlg.show()
        dlg.exec_()
    
    def run_open(self):

        if not self.protokolleOeffnenisActive:
            self.protokolleOeffnenisActive = True
            # Create the dockwidget (after translation) and keep reference
            self.protokolleWidget = Open(self.iface)

            # connect to provide cleanup on closing of dockwidget
            self.protokolleWidget.closingPlugin.connect(self.onCloseProtokolleDockWidget)

            # show the dockwidget
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.protokolleWidget)

            self.protokolleWidget.show()
            self.protokolleWidget.setVisible(True)
            self.protokolleWidget.raise_()
    
    def onCloseProtokolleDockWidget(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        # disconnects
        self.protokolleWidget.closingPlugin.disconnect(self.onCloseProtokolleDockWidget)
        self.protokolleWidget = None
        self.protokolleOeffnenisActive = False
    
    def reload_open(self):
        for dlg in self.iface.mainWindow().findChildren(QDockWidget):
            if dlg.objectName() == "oeffnen_dlg":
                dlg.deleteLater()
                self.onCloseProtokolleDockWidget()
                self.run_open()
                return
            
    def checkInput(self):
        checker = InputChecker()
        ergebnis = checker.check_input()
        for action in self.actions:
            if action.check_input:
                action.setEnabled(ergebnis)

