# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DissolveAdjacentPolygons
                                 A QGIS plugin
 This plugin dissolves polygons adjacent to other polygons, according to user-chosen options.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-16
        copyright            : (C) 2022 by Antonio Sobral Almeida
        email                : 66124.almeida@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Antonio Sobral Almeida'
__date__ = '2022-02-16'
__copyright__ = '(C) 2022 by Antonio Sobral Almeida'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingUtils
import processing

class DissolveAdjacentPolygons(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):

        self.addParameter(QgsProcessingParameterVectorLayer('Inputpolygonlayer', 'Input polygon layer', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('Dissolveallpolygonssmallerthansqmapunits', ' Dissolve all polygons smaller than (sq. map units):', type=QgsProcessingParameterNumber.Integer, minValue=0, defaultValue=0))
        self.addParameter(QgsProcessingParameterNumber('Dissolvepolygoninto1Largestadjacentpolygon2Smallestadjacentpolygon', 'Dissolve polygon into: 0 - Largest adjacent polygon; 1 - Smallest adjacent polygon; 2 - Largest common boundary', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=2, defaultValue=0))
        self.addParameter(QgsProcessingParameterFeatureSink('FieldCalculator2', 'Dissolved', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        
    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(5, model_feedback)
        results = {}
        outputs = {}

        # Multipart to singleparts
        alg_params = {
            'INPUT': parameters['Inputpolygonlayer'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MultipartToSingleparts'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Fix geometries
        alg_params = {
            'INPUT': outputs['MultipartToSingleparts']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FixGeometries'] = processing.run('native:fixgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Test if there are features smaller or larger than the threshold  <Dissolveallpolygonssmallerthansqmapunits>
        vl  = outputs['FixGeometries']['OUTPUT']   
        lyr = QgsProcessingUtils.mapLayerFromString(vl, context)
        param1 = parameters['Dissolveallpolygonssmallerthansqmapunits']
        flag=[]
        for f in lyr.getFeatures():
            if (f.geometry().area())>(param1):
                flag.append(1)
            else:
                flag.append(2)
        print (1 in flag)
        print (2 in flag)
        if not (1 in flag) :
            feedback.setProgressText('************************************************')
            feedback.setProgressText('Value set for "Dissolve all polygons smaller than" option is too high!')
            feedback.setProgressText('Please choose a value lower than the area of the feature largest area.')
            feedback.setProgressText('')
            feedback.setProgressText('************************************************')            
        if not (2 in flag):
            feedback.setProgressText('************************************************')            
            feedback.setProgressText('Value set for "Dissolve all polygons smaller than" option is too low!')
            feedback.setProgressText('Please choose a value higher than the area of the feature smallest area.')
            feedback.setProgressText('')
            feedback.setProgressText('************************************************')               

# ********************************  Select features as asked  ***************************************************************************************************************************************

        # Field calculator1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'Area_m2',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$area',
            'INPUT': outputs['FixGeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculator1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Select by attribute
        alg_params = {
            'FIELD': 'Area_m2',
            'INPUT': outputs['FieldCalculator1']['OUTPUT'],
            'METHOD': 0,
            'OPERATOR': 5,
            'VALUE': parameters['Dissolveallpolygonssmallerthansqmapunits']
        }
        outputs['SelectByAttribute'] = processing.run('qgis:selectbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

# ********************************  Choose between common line  OR  common vertex  OR  largest common boundary  ***************************************************************************************************************************************

        param2 = parameters['Dissolvepolygoninto1Largestadjacentpolygon2Smallestadjacentpolygon']
        # Eliminate selected polygons
        alg_params = {
            'INPUT': outputs['SelectByAttribute']['OUTPUT'],
            'MODE': param2,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EliminateSelectedPolygons'] = processing.run('qgis:eliminateselectedpolygons', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}
     
        # Field calculator2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'Area_m2',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$area',
            'INPUT': outputs['EliminateSelectedPolygons']['OUTPUT'],
            'OUTPUT': parameters['FieldCalculator2']
        }
        outputs['FieldCalculator2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['FieldCalculator2'] = outputs['FieldCalculator2']['OUTPUT']

        return results

    def name(self):
        return 'Dissolve adjacent polygons'

    def displayName(self):
        return 'Dissolve adjacent polygons'

    def group(self):
        return None

    def groupId(self):
        return None

    def createInstance(self):
        return DissolveAdjacentPolygons()
