from qgis.core import QgsApplication
from .processing_provider import DirectionalSlopeProvider

class DirectionalSlopePolygonsPlugin:
    def __init__(self, iface):
        self.iface = iface
        self.provider = None

    def initGui(self):
        self.provider = DirectionalSlopeProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        if self.provider:
            QgsApplication.processingRegistry().removeProvider(self.provider)
            self.provider = None

