# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DimensionsSelector
                                 A QGIS plugin
 Dimensions Selector Plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-07-05
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Camptocamp
        email                : info@camptocamp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from pkg_resources import resource_filename

from qgis.core import QgsApplication

from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtWidgets import QAction

from .core import DimensionsManager

# Initialize Qt resources from file resources.py
from .resources import *  # noqa: F401 F403
# Import the code for the dialog
from .gui.actions import DimensionSelectorAction
from .gui.settings_dialog import SettingsDialog


class DimensionsSelectorPlugin():
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = resource_filename("dimensions_selector", "i18n/{}.qm".format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.dimensionsSelectors = []

        self.manager = DimensionsManager('dimensions_selector', iface.mainWindow())
        self.manager.configurationChanged.connect(self.configurationChanged)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('DimensionsSelectorPlugin', message)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        self.menu = self.tr(u'&Dimensions selector')
        self.toolbar = self.iface.addToolBar(self.tr(u'Dimensions selector'))
        self.toolbar.setObjectName(u'DimensionsSelector')

        settings_action = QAction(QgsApplication.getThemeIcon("/propertyicons/settings.svg"),
                                  self.tr('Settings'),
                                  self.iface.mainWindow())
        settings_action.triggered.connect(self.showSettings)
        self.iface.addPluginToMenu(self.menu, settings_action)
        self.toolbar.addAction(settings_action)
        self.actions.append(settings_action)

        active_action = QAction(QgsApplication.getThemeIcon("/mActionFilter2.svg"),
                                self.tr('Toggle filtering'),
                                self.iface.mainWindow())
        active_action.setCheckable(True)
        active_action.setChecked(self.manager.active())
        active_action.toggled.connect(self.set_active)
        self.active_action = active_action
        self.toolbar.addAction(active_action)
        self.actions.append(active_action)

        self.configurationChanged()

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.manager.restore_subset_strings()
        self.manager.deleteLater()
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Dimensions selector'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def set_active(self, active):
        self.manager.set_active(active)

    def configurationChanged(self):
        self.active_action.setChecked(self.manager.active())
        self.resetSelectors()

    def resetSelectors(self):
        for action in self.dimensionsSelectors:
            self.toolbar.removeAction(action)
        for dimension in self.manager.dimensions():
            if not dimension.active:
                continue
            action = DimensionSelectorAction(dimension, self.iface.mainWindow())
            action.valueChanged.connect(self.dimensionValueChanged)
            self.toolbar.addAction(action)
            self.dimensionsSelectors.append(action)

    def dimensionValueChanged(self):
        self.manager.refresh_filters()

    def showSettings(self):
        dlg = SettingsDialog(self.manager)
        result = dlg.exec_()
        if result:
            self.resetSelectors()
