# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Dimensioning
                                 A QGIS plugin
 This plugin creates dimensioning with a Temporary Layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-03-18
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Ing. Martin Studer
        email                : martin.studer@vorarlberg.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
#from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.core import *
from qgis.utils import *

from qgis.gui import QgsColorButton

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .dimensioning_dialog import DimensioningDialog
import os.path


class Dimensioning:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        
        self.toolButton = QToolButton()
        self.toolButton.setMenu(QMenu())
        self.toolButton.setPopupMode(QToolButton.MenuButtonPopup)
        self.toolBtnAction = self.iface.addToolBarWidget(self.toolButton)
        
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Dimensioning_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Dimensioning')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Dimensioning', message)

      

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
            
        self.actionRun = QAction(
            QIcon(os.path.join(os.path.dirname(__file__), "icon.png")),
            self.tr('Dimensioning'),
            self.iface.mainWindow()
        )
        self.iface.addPluginToMenu(self.tr('&Dimensioning'), self.actionRun)
        m = self.toolButton.menu()
        m.addAction(self.actionRun)
        self.toolButton.setDefaultAction(self.actionRun)
        self.actionRun.triggered.connect(self.run)
        self.actionConfigure = QAction(
            QIcon(os.path.join(os.path.dirname(__file__), "configure.png")),
            self.tr('Configure'),
            self.iface.mainWindow()
        )
        self.iface.registerMainWindowAction(self.actionConfigure, "Configue")
        self.actionConfigure.setToolTip(self.tr('Configure'))
        m.addAction(self.actionConfigure)
        self.iface.addPluginToMenu(self.tr('&Dimensioning'), self.actionConfigure)
        self.actionConfigure.triggered.connect(self.configure)        
        
        # will be set False in run()
        self.first_start = True      

        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        for action in [self.actionRun,self.actionConfigure]:
            self.iface.removePluginMenu(self.tr('&Dimensioning'),action)
            self.iface.removeToolBarIcon(action)
            self.iface.unregisterMainWindowAction(action)

        self.iface.removeToolBarIcon(self.toolBtnAction)
    
    def run(self):
        """Run method that performs all the real work"""
        # Load a simple QLR containing a vector layer.
        # QgsProject.instance().removeAllMapLayers()
        
        iface.messageBar().pushMessage(self.tr('use snapping if possible'), level=Qgis.Info, duration=10)
        
        if not QgsProject.instance().mapLayersByName(self.tr('Dimensioning')):        
            layer = QgsLayerDefinition.loadLayerDefinition(
                os.path.dirname(os.path.realpath(__file__))+ '/Dimensioning.qlr',
                QgsProject.instance(), QgsProject.instance().layerTreeRoot())    
            


            # Find Layer  
            layer = QgsProject.instance().mapLayersByName('Dimensioning')[0]  
            
            # set CRS from project
            crs_layer = layer.crs()
            crs = QgsProject.instance().crs()            
            layer.setCrs(crs)
            
            # create a QgsLayerTreeLayer object from layer by its id
            myvl = QgsProject.instance().layerTreeRoot().findLayer(layer.id())
            # clone the myvl QgsLayerTreeLayer object
            myvlclone = myvl.clone()
            # get the parent. If None (layer is not in group) returns ''
            parent = myvl.parent()
            # move the cloned layer to the top (0)
            parent.insertChildNode(0, myvlclone)
        
            myvlclone.setName(self.tr('Dimensioning'))
        
            # remove the original myvl
            QgsProject.instance().layerTreeRoot().removeChildNode(myvl)
            # set layer active 
            self.iface.setActiveLayer(layer)
            # start edit
            self.iface.actionToggleEditing().trigger()
            # enable tool
            self.iface.actionAddFeature().trigger()  

           
            
    def configure(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = DimensioningDialog()
            self.dlg.pushButton_3.setColor(QColor.fromRgb(0,0,0))
            self.dlg.doubleSpinBox.setValue(10)
        # show the dialog
        self.dlg.show()    
        # Run the dialog event loop
        result = self.dlg.exec_()

        # See if OK was pressed
        if result:
            # Change Color
            if not QgsProject.instance().mapLayersByName(self.tr('Dimensioning')):
                self.run()         
            
            color_value = self.dlg.pushButton_3.color()
            layer = QgsProject.instance().mapLayersByName(self.tr('Dimensioning'))[0]
            symbol = layer.renderer().symbol()
            symbol.setColor(QColor(color_value))
            
            # set offset markerlines
            offset = self.dlg.doubleSpinBox.value()
            #if offset == 0.0:
            #    offset_marker = offset
            #else:
            offset_marker = offset + 2.0
            symbol.symbolLayer(0).subSymbol()[1].setWidth(offset_marker)
            
            # set arrow offset ("-" means left side)
            arrow_offset = (offset*(-1)+1)           
            symbol.symbolLayer(0).subSymbol()[0].setOffset(arrow_offset)                    
            
            # set label offset
            label_offset = (offset*(-1)-3)
            symbol.symbolLayer(0).subSymbol()[2].setOffset(label_offset)            
            layer.triggerRepaint()           
            pass    
                         
            
