# from pyproj import CRS
# from pyproj.aoi import AreaOfInterest
# from pyproj.database import query_utm_crs_info
import os
import csv
import random
from glob import glob1

from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtWidgets import QDialogButtonBox
from qgis.PyQt.QtWidgets import QLabel
from qgis.PyQt.QtWidgets import QVBoxLayout
from qgis.PyQt.QtWidgets import QProgressDialog
from qgis.PyQt.QtGui import QColor
from qgis.PyQt.QtCore import QVariant
from qgis.PyQt.QtCore import QCoreApplication

from qgis.core import Qgis
from qgis.core import QgsFeature
from qgis.core import QgsEditorWidgetSetup
from qgis.core import QgsVectorLayerJoinInfo
from qgis.core import QgsProject
from qgis.core import QgsSymbol
from qgis.core import QgsRendererCategory
from qgis.core import QgsCategorizedSymbolRenderer
from qgis.core import QgsSingleSymbolRenderer
from qgis.core import QgsLineSymbol
from qgis.core import QgsMarkerSymbol
from qgis.core import QgsPalLayerSettings
from qgis.core import QgsTextFormat
from qgis.core import QgsVectorLayerSimpleLabeling
from qgis.core import QgsTextBufferSettings
from qgis.core import QgsSvgMarkerSymbolLayer
from qgis.core import QgsField

# ## also import pyqtRemoveInputHook
# from qgis.PyQt.QtCore import pyqtRemoveInputHook
# import pdb

# pyqtRemoveInputHook()
# # pdb.set_trace()

THIS_PATH = os.path.dirname(__file__)

class QuestionDialog(QDialog):
    """Dialog with question with button box"""
    def __init__(self, parent=None):
        super().__init__(parent)

        self.setWindowTitle("Upload data!")

        QBtn = QDialogButtonBox.Ok | QDialogButtonBox.Cancel

        self.buttonBox = QDialogButtonBox(QBtn)
        self.buttonBox.accepted.connect(self.accept)
        self.buttonBox.rejected.connect(self.reject)

        self.layout = QVBoxLayout()
        message = QLabel("Do you want to upload the last create plants?")
        self.layout.addWidget(message)
        self.layout.addWidget(self.buttonBox)
        self.setLayout(self.layout)

    # def accept(self):
    #     """Upload create data
    #     """


    # def reject(self):
    #     """Not upload data"""


class ProgressBarDialog(QProgressDialog):
    """Dialog with progress bar"""
    def __init__(self, parent=None, label=None, title=None):
        super().__init__(parent)
        if title:
            self.setWindowTitle(title)
        else:
            self.setWindowTitle("DigiAgriApp: operation progress")
        if label:
            self.setLabelText(label)
        self.setMinimumWidth(300)
        self.setMinimumDuration(0)
        self.setMinimum(0)
        self.setMaximum(100)
        self.setValue(0)
        self.setAutoClose(True)
        self.setCancelButton(None)
        self.setModal(True)
        self.show()


def get_utm_srid_from_extent(extent):
    """Return the right UTM code from Django geometry envelope

    Args:
        extent (obj): list or Envelope geometry in longitude and latitude (EPSG 4326)

    Returns:
        CRS object
    """
    lon = (extent[0] + extent[2]) / 2
    lat = (extent[1] + extent[3]) / 2
    EPSG_srid = int(32700-round((45+lat)/90,0)*100 + round((183+lon)/6,0))
    return EPSG_srid

# def utm_from_extent(extent):
#     """Return the right UTM code from Django geometry envelope

#     Args:
#         extent (obj): list or Envelope geometry in longitude and latitude (EPSG 4326)

#     Returns:
#         CRS object
#     """
#     utm_crs_list = query_utm_crs_info(
#         datum_name="WGS 84",
#         area_of_interest=AreaOfInterest(
#             west_lon_degree=extent[0],
#             south_lat_degree=extent[1],
#             east_lon_degree=extent[2],
#             north_lat_degree=extent[3],
#         ),
#     )
#     return CRS.from_epsg(utm_crs_list[0].code)


def createPlantPoleFeature(in_dict, geom, farm, field, subfield, row):
    """Create a QGIS feature from a dictionary with keys

    Args:
        in_dict (dict): A dictionary with the following fields
        geom (obj): a QGIS Point geometry
        farm (int): The farm ID
        field (int): The field ID
        subfield (int): The subfield ID
        row (int): The row ID

    Returns:
        obj: A QGIS feature object
    """
    if not in_dict["label"]:
        label = None
    else:
        label = str(in_dict["label"])
    if not in_dict["thesis"]:
        thesis = None
    else:
        thesis = in_dict["thesis"]
    if not in_dict["experiment"]:
        experiment = None
    else:
        experiment = in_dict["experiment"]
    # check if is a foro F/f or empty E/e
    if in_dict["material"] in ["F", "f", "E", "e"]:
        material = None
    # check if is a pole P/p
    elif in_dict["material"] in ["", "p", "P"]:
        raise ValueError("The first plant seem to be a pole")
    else:
        material = in_dict["material"]
    plant_feat = QgsFeature()
    plant_feat.setGeometry(geom)
    plant_feat.setAttributes([
        "plant",
        material,
        label,
        thesis,
        experiment,
        farm,
        field,
        subfield,
        row
    ])
    return plant_feat


def field_to_value_map(layer, field, inputlayer):
    """Function to set editing form to map values

    Args:
        layer (obj): The QGIS layer object to be used to set the map value
        field (str): The field to be set
        inputlayer (obj): The QGIS layer object to get values from

    Returns:
        boolean: return True if everything works well
    """
    if layer is None:
        return False
    list_values = {}
    if isinstance(inputlayer, dict):
        list_values = inputlayer
    else:
        for idd, name in inputlayer.items():
            list_values[name] = idd
    config = {'map' : list_values}
    widget_setup = QgsEditorWidgetSetup('ValueMap', config)
    field_idx = layer.fields().indexFromName(field)
    layer.setEditorWidgetSetup(field_idx, widget_setup)
    return True


def join_layer_csv(vect_layer, vect_col, csv_layer, csv_col):
    """Function to join a csv layer with a vector

    Args:
        vect_layer (obj): the vector layer to join
        vect_col (str): the column of vector to make the join
        csv_layer (obj): the csv layer to join with vector layer
        csv_col (str): the column of CSV to make the join

    Returns:
        bool: if everything is work properly
    """
    if vect_layer is None or csv_layer is None:
        return False
    print("before join")
    joinObject = QgsVectorLayerJoinInfo()
    joinObject.setJoinLayer(csv_layer)
    # csv column is id for material id
    joinObject.setJoinFieldName(csv_col)
    joinObject.setTargetFieldName(vect_col)
    joinObject.setUsingMemoryCache(True)
    vect_layer.addJoin(joinObject)
    print("after join")
    return True

def get_project_path():
    """Function to return the directory where project is saved

    Returns:
        str: the path of the project's directory
    """
    path = QgsProject.instance().absolutePath()
    if path:
        return path
    return None

def set_label(layer, field_name, text_size=6, position="auto"):
    label_settings = QgsPalLayerSettings()
    #label_settings.drawBackground = True
    label_settings.fieldName = field_name
    text_format = QgsTextFormat()
    text_buffer = QgsTextBufferSettings()
    text_buffer.setColor(QColor("#FFFFFF"))
    text_buffer.setSize(1 + text_size / 10)
    text_buffer.setEnabled(True)
    text_format.setBuffer(text_buffer)
    text_format.setSize(text_size)
    text_format.setOpacity(0.9)
    if position == "left":
        label_settings.placement = Qgis.LabelPlacement.OverPoint
        label_settings.quadOffset = QgsPalLayerSettings.QuadrantRight
        label_settings.xOffset = 3
    else:
        label_settings.placement = Qgis.LabelPlacement.OrderedPositionsAroundPoint
    label_settings.setFormat(text_format)
    layer.setLabeling(QgsVectorLayerSimpleLabeling(label_settings))
    layer.setLabelsEnabled(True)
    return True

def set_style_plant_material_svg(layer, csv_layer, colname, field_name="name", icon_size=5, text_size=5, iface=None):
    if csv_layer is None:
        if iface:
            iface.messageBar().pushMessage(
                QCoreApplication.translate("functions", "Error"),
                QCoreApplication.translate("functions", "CSV layer is empty but it is required by this function"),
                level=Qgis.Warning,
            )
            return False
        raise ValueError("CSV layer is empty but it is required by this function")
    full_path = csv_layer.dataProvider().dataSourceUri().split("?")[0].replace("file://","")
    csvfile = open(full_path, newline='')
    csvdata = csv.reader(csvfile, delimiter=',')
    try:
        headers = next(csvdata)
    except:
        if iface:
            iface.messageBar().pushMessage(
                QCoreApplication.translate("functions", "Error"),
                QCoreApplication.translate("functions", "Problem reading the CSV file, has it some rows?"),
                level=Qgis.Warning,
            )
            return False
        raise ValueError("Problem reading the CSV file, has it some rows?")
    col_index = headers.index(colname)
    icon_index = headers.index("icon")
    newcol_name = f"{colname}_icon"
    newcol_index = layer.fields().indexOf(newcol_name)
    if newcol_index != -1:
        layer.dataProvider().deleteAttributes([newcol_index])
        layer.updateFields()
    field = QgsField(newcol_name, QVariant.Type.String)
    layer.addExpressionField(f'concat("{csv_layer.name()}_{colname}", \'_\', "icon")', field)
    layer.updateFields()
    classes = {}
    for row in csvdata:
        try:
            var = row[col_index]
        except IndexError:
            var = 'none'
        try:
            svg = row[icon_index]
        except IndexError:
            svg = 'plant.svg'
        identi = f"{var}_{svg}"
        if identi not in classes.keys():
            classes[identi] = (
                "#"+''.join([random.choice('0123456789ABCDEF') for j in range(6)]),
                identi,
                svg
            )
    for svgfile in glob1(os.path.join(THIS_PATH, "plant_icons"), "*.svg"):
        identi = f"_{svgfile}"
        classes[identi] = (
            "#"+''.join([random.choice('0123456789ABCDEF') for j in range(6)]),
            identi,
            svgfile
        )
    csvfile.close()
    # Create list to store symbology properties
    categories = []
    # Iterate through the dictionary
    for classes, (color, variety, svg) in classes.items():
        # Automatically set symbols based on layer's geometry
        symbol = QgsSymbol.defaultSymbol(layer.geometryType())
        # Set colour
        symbol.setColor(QColor(color))
        # Set symbol with value = 0 to be transparent
        symbol.setOpacity(0.6)
        symbol.setSize(icon_size)
        # Set the renderer properties

        svgStyle = {}
        svgStyle['fill'] = '#000000'
        svgStyle['name'] = os.path.join(THIS_PATH, "plant_icons", svg)
        svgStyle['size'] = icon_size - (icon_size / 4)

        symbol_layer = QgsSvgMarkerSymbolLayer.create(svgStyle)
        symbol.appendSymbolLayer(symbol_layer.clone())
        category = QgsRendererCategory(variety, symbol, classes.replace("_", " ").replace(".svg", ""))
        categories.append(category)

    # Field name
    expression = f"{csv_layer.name()}_{colname}"
    # Set the categorized renderer
    renderer = QgsCategorizedSymbolRenderer(f"{colname}_icon", categories)
    layer.setRenderer(renderer)
    lname = layer.name()
    if "_row" not in lname and "_pole" not in lname:
        if "_plant" in lname:
            set_label(layer, field_name, text_size, position="left")
        else:
            set_label(layer, field_name, text_size)
    # Refresh layer

    layer.triggerRepaint()
    return True

def set_single_style(layer, color, fieldName="name", icon_size=5, text_size=5, iface=None):
    # Set the categorized renderer
    if layer:
        lname = layer.name()
    else:
        if iface:
            iface.messageBar().pushMessage(
                QCoreApplication.translate("functions", "Error"),
                QCoreApplication.translate("functions", "Layer is empty but it is required to style it"),
                level=Qgis.Warning,
            )
            return False
    if "_pole" in lname:
        symbol = QgsMarkerSymbol.createSimple({'name': 'rectangle', "angle": "90"})
    else:
        symbol = QgsSymbol.defaultSymbol(layer.geometryType())
    symbol.setColor(QColor(color))
    if isinstance(symbol, QgsLineSymbol):
        symbol.setWidth(1)
    elif isinstance(symbol, QgsMarkerSymbol):
        symbol.setSize(icon_size)
    elif isinstance(symbol, QgsMarkerSymbol):
        symbol.setOpacity(0.6)
    renderer = QgsSingleSymbolRenderer(symbol)
    layer.setRenderer(renderer)
    if "_row" not in lname and "_pole" not in lname:
        if "_plant" in lname:
            set_label(layer, fieldName, text_size, position="left")
        else:
            set_label(layer, fieldName, text_size)
    # Refresh layer
    layer.triggerRepaint()
    return True

def set_style_plant_material_simple(layer, colname, field_name="name", svgdir="/usr/share/qgis/svg", icon_size=5, text_size=5):
    idx = layer.fields().indexOf(colname)
    uniq_values = layer.uniqueValues(idx)
    classes = {}
    usable = [
        os.path.join("crosses", "Star1.svg"),
        os.path.join("arrows", "Arrow_01.svg"),
        os.path.join("backgrounds", "background_circle.svg"),
        os.path.join("backgrounds", "background_safety.svg"),
        os.path.join("symbol", "poi_peak.svg"),
        os.path.join("backgrounds", "background_tilted_square.svg"),
        os.path.join("arrows", "NorthArrow_05.svg"),
        os.path.join("services", "amenity=pharmacy.svg"),
        os.path.join("backgrounds", "background_security.svg"),
        os.path.join("backgrounds", "background_square_rounded.svg"),
        os.path.join("crosses", "Cross4.svg"),
        os.path.join("arrows", "Arrow_05.svg"),
        os.path.join("backgrounds", "background_forbidden.svg"),
        os.path.join("backgrounds", "background_triangle.svg"),
        os.path.join("tourist", "tourist_castle.svg"),
        os.path.join("wind_roses", "WindRose_01.svg"),
        os.path.join("backgrounds", "background_security_02.svg"),
        os.path.join("backgrounds", "background_square.svg"),
        os.path.join("crosses", "Cross6.svg"),
        os.path.join("emergency", "amenity=hospital.svg"),
        os.path.join("arrows", "NorthArrow_11.svg"),
        os.path.join("entertainment", "amenity=cinema.svg"),
        os.path.join("religion", "place_of_worship_bahai3.svg"),
        os.path.join("transport", "barrier_bollard.svg"),
        os.path.join("transport", "transport_roundabout_clockwise.svg")
    ]
    rownum = 0
    fill = "#fff"
    for row in uniq_values:
        print(row, fill, rownum)
        if row not in classes.keys():
            fullpath = os.path.join(svgdir, usable[rownum])
            if not os.path.exists(fullpath):
                print(f"{fullpath} does not exists")
            classes[row] = (
                fullpath,
                fill
            )
            if fill == "#fff":
                fill = "#000"
                continue
            else:
                fill = "#fff"
            if rownum == (len(usable) - 1):
                rownum = 0
            else:
                rownum += 1
    # Create list to store symbology properties
    categories = []
    # Iterate through the dictionary
    for classe, (svg, color) in classes.items():
        # Automatically set symbols based on layer's geometry
        symbol = QgsSymbol.defaultSymbol(layer.geometryType())
        # Set colour
        if color == "#000":
            symbol.setColor(QColor("#fff"))
        else:
            symbol.setColor(QColor("#000"))
        # Set symbol with value = 0 to be transparent
        symbol.setOpacity(1)
        symbol.setSize(icon_size)
        # Set the renderer properties

        svgStyle = {}
        svgStyle['fill'] = color
        svgStyle['color'] = "#000"
        svgStyle['name'] = os.path.join(svgdir, svg)
        svgStyle['size'] = icon_size - (icon_size / 4)

        symbol_layer = QgsSvgMarkerSymbolLayer.create(svgStyle)
        symbol.appendSymbolLayer(symbol_layer.clone())

        # Set the renderer properties
        if isinstance(classe, QVariant):
            category = QgsRendererCategory(str(classe), symbol.clone(), str(classe).replace(".svg", ""))
            categories.append(category)
            continue
        category = QgsRendererCategory(classe, symbol.clone(), classe.replace(".svg", ""))
        categories.append(category)

    # Set the categorized renderer
    renderer = QgsCategorizedSymbolRenderer(f"{colname}", categories)
    layer.setRenderer(renderer)
    lname = layer.name()
    if "_row" not in lname and "_pole" not in lname:
        if "_plant" in lname:
            set_label(layer, field_name, text_size, position="left")
        else:
            set_label(layer, field_name, text_size)
    # Refresh layer

    layer.triggerRepaint()
    return True
