# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DeteccionDePalmeras
                                 A QGIS plugin
 Este plug-in permite detectar automáticamente 3 especies de palmeras en imágenes RGB adquiridas con RPAs:aguaje (Mauritia flexuosa), huasai (Euterpe precautoria) y ungurahui (Oenocarpus bataua). 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-10-06
        copyright            : (C) 2021 by Susan Palacios, Rodolfo Cardenas, Ximena Tagle
        email                : spalacios.salcedo@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Susan Palacios, Rodolfo Cardenas, Ximena Tagle'
__date__ = '2021-10-06'
__copyright__ = '(C) 2021 by Susan Palacios, Rodolfo Cardenas, Ximena Tagle'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os #icon
import inspect #icon
from qgis.PyQt.QtGui import QIcon #icon


from qgis.core import QgsProcessingProvider
from .deteccion_de_palmeras_algorithm import DeteccionDePalmerasAlgorithm


class DeteccionDePalmerasProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        Dependencies will be checked when the algorithm is actually run.
        """
        self.addAlgorithm(DeteccionDePalmerasAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Palmeras'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Palmeras')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]#icon
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))#icon
        return icon
        #return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
