# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DeraProjectsAndStudies
                                 A QGIS plugin
 DeraPro for projects and studies allows the download of the reference spatial data of Andalusia and make a cut of the information for a specific study area
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-07
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Manuel Cano
        email                : mcanop29@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import qgis.utils
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog, QMessageBox, QProgressBar

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Dera_Pro_dialog import DeraProjectsAndStudiesDialog
import os.path
import errno
from os import remove
import processing, os, subprocess, time
from qgis.utils import *
from qgis.core import *
from qgis.gui import QgsMessageBar
# from qgis.PyQt.QtGui import QProgressBar
from qgis.PyQt.QtCore import *

from processing.algs.gdal.GdalUtils import GdalUtils
from .listacapa import *

listTema = LISTTEMA
listCapa = LISTCAPA

import qgis

class DeraProjectsAndStudies:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            '{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = DeraProjectsAndStudiesDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&DeraPro')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'DeraPro')
        self.toolbar.setObjectName(u'DeraPro')

        self.dlg.lineEdit.clear()
        self.initFolder();
        self.dlg.pushButton.clicked.connect(self.selectOutputFile);

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('DeraProjectsAndStudies', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/dera_pro/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'DeraProjectsAndStudies'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&DeraPro'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar


    def initFolder(self):
        path_project = QgsProject.instance().fileName()
        path_project = path_project[:path_project.rfind("/"):]

        self.folderName = path_project

        self.dlg.lineEdit.setText(self.folderName);

    def selectOutputFile(self):
        folderTmp = QFileDialog.getExistingDirectory(self.dlg,
            self.tr("Select output folder "), self.folderName)

        if folderTmp != "":
            self.folderName = folderTmp

        self.dlg.lineEdit.setText(self.folderName);

    def isFileOpened(self, file_path):
        if os.path.exists(file_path):
            try:
                os.rename(file_path, file_path+"_")
                os.rename(file_path+"_", file_path)
                return False
            except OSError as e:
                return True

    def run(self):
        """Run method that performs all the real work"""
        self.dlg.comboBox.clear()
        layers = QgsProject.instance().mapLayers().values()
        # fill selection combo, only polygon layers
        n = 0
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer and \
                layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                self.dlg.comboBox.addItem( layer.name(), layer )
                n += 1

        if n == 0:  # no polygon layer
            iface.messageBar().pushMessage(self.tr("Información"),
                self.tr("Cargue la capa poligonal que delimite su área de estudio o proyecto"),
                level=Qgis.Info)
            return

        # show the dialog
        self.dlg.show()
        self.dlg.comboBox_tema.clear()
        self.dlg.comboBox_capa.clear()
        self.dlg.comboBox_tema.addItems(listTema)
        self.dlg.comboBox_tema.currentIndexChanged.connect(self.filter_capa)
        self.dlg.pushButton_2.clicked.connect(self.capa)


        
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:

            dirName = self.dlg.lineEdit.text().strip()
            if len(dirName) == 0:
                iface.messageBar().pushMessage(self.tr("DeraPro"),
                    self.tr("Debe seleccionar una carpeta de salida"), level=Qgis.Info)
                return

            index = self.dlg.comboBox.currentIndex()
            selection = self.dlg.comboBox.itemData(index)
            
            checkedLayers = QgsProject.instance().layerTreeRoot().checkedLayers()
            
            #search existence of output folder, if not create it
            if not os.path.isdir(self.folderName):
                raise FileNotFoundError(
                    errno.ENOENT, os.strerror(errno.ENOENT), self.folderName)

            directory = self.folderName
            if not os.path.exists(directory):
                os.makedirs(directory)


                

            
            # Progress bar
            progressMessageBar = iface.messageBar().createMessage(self.tr("DeraPro_Procesando_datos..."))
            progress = QProgressBar()
            progress.setMaximum(len(checkedLayers) - 1)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            progression = 0

            #clip part
            for layer in checkedLayers  :
                out = None
                # clip vector layer (if displayed and checked)
                if layer.type() == QgsMapLayer.VectorLayer and \
                   layer != selection:
                    output = self.folderName + "/clip_" + layer.name() + ".shp"
                    
                    # check file isn't openned and is writable
                    version = 0
                    while self.isFileOpened(output):
                        output = self.folderName + "/clip_" + \
                            layer.name() + "("+ str(version) + ").shp"
                        version +=1

                    result = processing.run("native:clip", {"INPUT" : layer.id(), "OVERLAY" : selection.id(), "OUTPUT" : "memory:"})

                    # save the layer with the same encoding, crs and format as the original loaded
                    #newName = output
                    #QgsVectorFileWriter.writeAsVectorFormat(result["OUTPUT"], output, layer.dataProvider().encoding(), layer.crs(), layer.dataProvider().storageType(), newFilename=newName)
                    # use above when i know how to detect the exact name created, newFilename do no return nothing
                    QgsVectorFileWriter.writeAsVectorFormat(result["OUTPUT"], output, "UTF-8",
                                                            layer.crs(), 'ESRI Shapefile')
                    #layer.dataProvider().encoding()

                    # load layer

                    out = iface.addVectorLayer(output, "", "ogr")
                    if not out:
                        iface.messageBar().pushMessage(self.tr("Error"),
                                                        self.tr("Could not load ") + output,
                                                        level=Qgis.Warning)


                
                # Update progression
                time.sleep(1)
                progress.setValue(progression + 1)
                progression += 1

            iface.messageBar().clearWidgets()

        if self.dlg.checkBox.isChecked():

            project_file_name = self.folderName + "/DeraPro_clip_" + ".qgs"
            project_file_path = os.path.join(self.folderName, project_file_name)
            project = QgsProject.instance()
            project.write(project_file_path)
            iface.messageBar().pushMessage("Success: ",
                                           "Dera_Pro...QGIS project salvado.",
                                           level=3)
            def sanitize(layer_name):
                forbidden_chars = r'<>:"/\|?*'
                return ''.join(c if c not in forbidden_chars else '_' for c in layer_name)

            project = QgsProject.instance()
            layers = project.mapLayers().values()
            unique_names = set()
            non_unique_names = []

            for layer in project.mapLayers().values():
                name = layer.name()
                if name in unique_names:
                    # Layer name is not unique, so add it to the list
                    non_unique_names.append(name)

                else:
                    # Add the layer name to the set
                    unique_names.add(name)
            # Check if all layer names are unique
            if len(unique_names) == len(layers):


                        # Save each layer in the project
                        for layer in project.mapLayers().values():
                            layer_name = sanitize(layer.name())
                            layer_file_path = os.path.join(self.folderName, layer_name)

                            # Save vector layers
                            if layer.type() == QgsMapLayerType.VectorLayer:
                                layerProvider = layer.dataProvider()
                                layerStorage = layerProvider.storageType()
                                # Save SHP layers as SHP files
                                if layerStorage == "ESRI Shapefile":
                                    output_file = os.path.join(self.folderName, layer_name + ".shp")

                                    # SHP file does not exist in the folder, write it for the first time
                                    if not os.path.exists(output_file):
                                        error, error_string = QgsVectorFileWriter.writeAsVectorFormat(layer,
                                                                                                      output_file,
                                                                                                      "utf-8",
                                                                                                      layer.crs(),
                                                                                                      "ESRI Shapefile")


    def load_vectors(self):
        """
        Load vectors for QGIS table of contents
        """
        self.dlg.comboBox.clear()
        self.dlg.comboBox.addItem(self.tr("--- Seleccione Capa de Corte ---"))
        for layer in QgsProject.instance().mapLayers().values():
            if layer.type() == QgsMapLayer.VectorLayer:
                if layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                    self.dlg.comboBox.addItem(layer.name())


    def filter_capa(self, index):
        """Message for fields without information"""

        tema = self.dlg.comboBox_tema.currentText()
        self.dlg.comboBox_capa.clear()

        self.dlg.comboBox_capa.addItems([cap for cap in listCapa if cap[6:8] == tema[6:8]])

        capa = self.dlg.comboBox_capa.currentText()

    def capa(self):
        """Cuando elegimos nuestra capa de informacion"""
        if self.dlg.comboBox_tema.currentIndex() == 0:
            iface.messageBar().pushMessage(self.tr("DeraPro"),
                self.tr("Debe seleccionar una capa"), level=Qgis.Info)
            return

        else:
            qgis.utils.reloadPlugin('dera_pro')

            tmp_tema = "pagingEnabled='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='{capa}' url='http://www.ideandalucia.es/services/{tema}/wfs?'"

            capa = self.dlg.comboBox_capa.currentText()
            tema = self.dlg.comboBox_tema.currentText()

            tmp_capa = QgsVectorLayer(tmp_tema.format(capa=capa, tema=tema), self.dlg.comboBox_capa.currentText(),
                                  'wfs')

            QgsProject.instance().addMapLayer(tmp_capa)



            layer = iface.activeLayer()
            crs = layer.crs().authid()
            nombre = layer.name()
            indice_c = nombre.index(':')
            subnombre = nombre[indice_c + 2:]
            layer.setName('{} ({})'.format(subnombre, crs))
            return










