# -*- coding: utf-8 -*-
"""
Created on Tue Jan 20 13:45:24 2026

@author: brad@retailgravity.com
"""

"""
Configuration file for demographic data packages.
Defines which variables are included in each package tier.
"""

# Professional Package - contains all variables
PROFESSIONAL_VARIABLES = [
    'BGID','CY_POP','CY_MPOP','CY_MPOP0_17','CY_MPOP18_24','CY_MPOP25_44','CY_MPOP45_64',
    'CY_MPOP65_84','CY_MPOP85PL','CY_FPOP','CY_FPOP0_17','CY_FPOP18_24','CY_FPOP25_44',
    'CY_FPOP45_64','CY_FPOP65_84','CY_FPOP85PL','POP_DENSITY','FY_POP','POP_GROWTH','CY_MEDAGE',
    'CY_MMEDAGE','CY_FMEDAGE','CY_WHITE','CY_BLACK','CY_NATIVEAM','CY_ASIAN','CY_NATIVEHI',
    'CY_OTHERRACE','CY_RACE2+','CY_NOTHISP','CY_HISPANIC','CY_HOUSEHOLDS','HH_DENSITY',
    'CY_AVGHHSIZE','CY_MARHH','CY_MARHHWCH','CY_MARHHNOCH','CY_COHHH','CY_COHHHWCH','CY_COHHHNOCH',
    'CY_FEMHH','CY_FEMHHLA','CY_FEMHHWCH','CY_FEMHHNOCH','CY_FEMHHNR','CY_MALEHH','CY_MALEHHLA',
    'CY_MALEHHWCH','CY_MALEHHNOCH','CY_MALEHHNR','CY_FAMHH2','CY_FAMHH3','CY_FAMHH4','CY_FAMHH5',
    'CY_FAMHH6','CY_FAMHH7','CY_NFAMHH1','CY_NFAMHH2','CY_NFAMHH3','CY_NFAMHH4','CY_NFAMHH5',
    'CY_NFAMHH6','CY_NFAMHH7','CY_POP15PL','CY_MPOP15PL','CY_MNMAR','CY_MMAR','CY_MWID',
    'CY_MDIV','CY_FPOP15PL','CY_FNMAR','CY_FMAR','CY_FWID','CY_FDIV','CY_POP18PL','CY_VETERAN',
    'CY_NVETERAN','CY_INCLT10K','CY_INC10_15K','CY_INC15_20K','CY_INC20_25K','CY_INC25_30K',
    'CY_INC30_35K','CY_INC35_40K','CY_INC40_45K','CY_INC45_50K','CY_INC50_60K','CY_INC60_75K',
    'CY_INC75_100K','CY_INC100_125K','CY_INC125_150K','CY_INC150_200K','CY_INC200K+','CY_AVGHHINC',
    'CY_MEDHHINC','CY_AGGINCOME','CY_POP3PL','CY_MPOP3PL','CY_MENROLLED','CY_MNENROLLED','CY_FPOP3PL',
    'CY_FENROLLED','CY_FNENROLLED','CY_POP25PL','CY_EDULT8GR','CY_EDU9_12','CY_EDUHSGRAD',
    'CY_EDU2YRCOL','CY_EDUBACH','CY_EDUMAST+','CY_POP5PL','CY_POP5_17','CY_ENGLNG5_17','CY_SPALNG5_17',
    'CY_OTHLNG5_17','CY_POP18_64','CY_ENGLNG18_64','CY_SPALNG18_64','CY_OTHLNG18_64','CY_POP65PL',
    'CY_ENGLNG65PL','CY_SPALNG65PL','CY_OTHLNG65PL','CY_UNITS','CY_UNITSOCC','CY_UNITSVAC',
    'CY_HUOWNER','CY_HUOWN15_34','CY_HUOWN35_64','CY_HUOWN65+','CY_HURENTER','CY_HURENT15_34',
    'CY_HURENT35_64','CY_HURENT65+','CY_HU1ROOM','CY_HU2ROOM','CY_HU3ROOM','CY_HU4ROOM',
    'CY_HU5ROOM','CY_HU6ROOM','CY_HU7ROOM','CY_HU8ROOM','CY_HU9ROOM','CY_HU1DET','CY_HU1ATT',
    'CY_HU2','CY_HU3_4','CY_HU5_9','CY_HU10_19','CY_HU20_49','CY_HU50PLUS','CY_HUMOB',
    'CY_HUOTHER','CY_YRB20+','CY_YRB10_19','CY_YRB00_09','CY_YRB90_99','CY_YRB80_89',
    'CY_YRB70_79','CY_YRB60_69','CY_YRB50_59','CY_YRB40_49','CY_YRBLT39','CY_MEDYEAR',
    'CY_POP16PL','CY_ILF','CY_ILFCIV','CY_ILFCIVEMP','CY_ILFUNEMP','CY_ILFAF','CY_NOTILF',
    'CY_WORKPOP','CY_WORKPRIV','CY_WORKGOVT','CY_WORKSELF','CY_WORKFAM','CY_OCCPOP',
    'CY_WHTCOLLAR','CY_SERVICES','CY_BLUECOLLAR','CY_TRNSBASE','CY_TRNSAUTO','CY_TRNSPUBLIC',
    'CY_TRNSOTHER','CY_WRKHOME','CY_COMMBASE','CY_COMMLT15','CY_COMM15_30','CY_COMM30_45',
    'CY_COMM45_60','CY_COMM60_90','CY_COMM90+','CY_POP1PL','CY_MOBSAME','CY_MOBDIFF',
    'CY_MOBABR','LAND_AREA'
]

# Expanded Package
EXPANDED_VARIABLES = [
    'BGID','CY_POP','CY_MPOP','CY_MPOP0_17','CY_MPOP18_24','CY_MPOP25_44','CY_MPOP45_64',
    'CY_MPOP65_84','CY_MPOP85PL','CY_FPOP','CY_FPOP0_17','CY_FPOP18_24','CY_FPOP25_44',
    'CY_FPOP45_64','CY_FPOP65_84','CY_FPOP85PL','POP_DENSITY','FY_POP','POP_GROWTH','CY_MEDAGE',
    'CY_MMEDAGE','CY_FMEDAGE','CY_WHITE','CY_BLACK','CY_NATIVEAM','CY_ASIAN','CY_NATIVEHI',
    'CY_OTHERRACE','CY_RACE2+','CY_NOTHISP','CY_HISPANIC','CY_HOUSEHOLDS','HH_DENSITY','CY_AVGHHSIZE',
    'CY_INCLT10K','CY_INC10_15K','CY_INC15_20K','CY_INC20_25K','CY_INC25_30K','CY_INC30_35K',
    'CY_INC35_40K','CY_INC40_45K','CY_INC45_50K','CY_INC50_60K','CY_INC60_75K','CY_INC75_100K',
    'CY_INC100_125K','CY_INC125_150K','CY_INC150_200K','CY_INC200K+','CY_AVGHHINC','CY_MEDHHINC',
    'CY_AGGINCOME','CY_POP25PL','CY_EDULT8GR','CY_EDU9_12','CY_EDUHSGRAD','CY_EDU2YRCOL',
    'CY_EDUBACH','CY_EDUMAST+','CY_UNITS','CY_UNITSOCC','CY_UNITSVAC','CY_HUOWNER','CY_HURENTER',
    'CY_HU1DET','CY_HU1ATT','CY_HU2','CY_HU3_4','CY_HU5_9','CY_HU10_19','CY_HU20_49','CY_HU50PLUS',
    'CY_HUMOB','CY_HUOTHER','CY_YRB20+','CY_YRB10_19','CY_YRB00_09','CY_YRB90_99','CY_YRB80_89',
    'CY_YRB70_79','CY_YRB60_69','CY_YRB50_59','CY_YRB40_49','CY_YRBLT39','CY_MEDYEAR','CY_POP16PL',
    'CY_ILF','CY_ILFCIV','CY_ILFCIVEMP','CY_ILFUNEMP','CY_ILFAF','CY_NOTILF','CY_WORKPOP',
    'CY_WORKPRIV','CY_WORKGOVT','CY_WORKSELF','CY_WORKFAM','CY_OCCPOP','CY_WHTCOLLAR',
    'CY_SERVICES','CY_BLUECOLLAR','LAND_AREA'
]

# Basic Package
BASIC_VARIABLES = [
    'BGID','CY_POP','POP_DENSITY','FY_POP','POP_GROWTH','CY_MEDAGE','CY_WHITE','CY_BLACK',
    'CY_NATIVEAM','CY_ASIAN','CY_NATIVEHI','CY_OTHERRACE','CY_RACE2+','CY_HOUSEHOLDS','HH_DENSITY',
    'CY_AVGHHSIZE','CY_INCLT10K','CY_INC10_15K','CY_INC15_20K','CY_INC20_25K','CY_INC25_30K',
    'CY_INC30_35K','CY_INC35_40K','CY_INC40_45K','CY_INC45_50K','CY_INC50_60K','CY_INC60_75K',
    'CY_INC75_100K','CY_INC100_125K','CY_INC125_150K','CY_INC150_200K','CY_INC200K+','CY_AVGHHINC',
    'CY_MEDHHINC','CY_AGGINCOME','CY_POP25PL','CY_EDULT8GR','CY_EDU9_12','CY_EDUHSGRAD',
    'CY_EDU2YRCOL','CY_EDUBACH','CY_EDUMAST+','CY_UNITS','CY_UNITSOCC','CY_UNITSVAC',
    'CY_OCCPOP','CY_WHTCOLLAR','CY_SERVICES','CY_BLUECOLLAR','LAND_AREA'
]

# Variable categories for organizing reports
VARIABLE_CATEGORIES = {
    'GEO': ['BGID','LAND_AREA'],
    'POPULATION': ['CY_POP','CY_MPOP','CY_MPOP0_17','CY_MPOP18_24','CY_MPOP25_44','CY_MPOP45_64','CY_MPOP65_84',
                   'CY_MPOP85PL','CY_FPOP','CY_FPOP0_17','CY_FPOP18_24','CY_FPOP25_44','CY_FPOP45_64','CY_FPOP65_84',
                   'CY_FPOP85PL','POP_DENSITY','FY_POP','POP_GROWTH'],
    'AGE': ['CY_MEDAGE','CY_MMEDAGE','CY_FMEDAGE'],
    'RACE & ETHNICITY': ['CY_WHITE','CY_BLACK','CY_NATIVEAM','CY_ASIAN','CY_NATIVEHI','CY_OTHERRACE',
                         'CY_RACE2+','CY_NOTHISP','CY_HISPANIC'],
    'HOUSEHOLDS': ['CY_HOUSEHOLDS','HH_DENSITY','CY_AVGHHSIZE','CY_MARHH','CY_MARHHWCH','CY_MARHHNOCH',
                   'CY_COHHH','CY_COHHHWCH','CY_COHHHNOCH','CY_FEMHH','CY_FEMHHLA','CY_FEMHHWCH','CY_FEMHHNOCH','CY_FEMHHNR',
                   'CY_MALEHH','CY_MALEHHLA','CY_MALEHHWCH','CY_MALEHHNOCH','CY_MALEHHNR','CY_FAMHH2','CY_FAMHH3',
                   'CY_FAMHH4','CY_FAMHH5','CY_FAMHH6','CY_FAMHH7','CY_NFAMHH1','CY_NFAMHH2','CY_NFAMHH3','CY_NFAMHH4',
                   'CY_NFAMHH5','CY_NFAMHH6','CY_NFAMHH7'],
    'MARITAL STATUS': ['CY_POP15PL','CY_MPOP15PL','CY_MNMAR','CY_MMAR','CY_MWID','CY_MDIV',
                       'CY_FPOP15PL','CY_FNMAR','CY_FMAR','CY_FWID','CY_FDIV'],
    'VETERAN STATUS': ['CY_POP18PL','CY_VETERAN','CY_NVETERAN'],
    'INCOME': ['CY_INCLT10K','CY_INC10_15K','CY_INC15_20K','CY_INC20_25K','CY_INC25_30K','CY_INC30_35K',
               'CY_INC35_40K','CY_INC40_45K','CY_INC45_50K','CY_INC50_60K','CY_INC60_75K','CY_INC75_100K','CY_INC100_125K',
               'CY_INC125_150K','CY_INC150_200K','CY_INC200K+','CY_AVGHHINC','CY_MEDHHINC','CY_AGGINCOME'],
    'SCHOOL ENROLLMENT': ['CY_POP3PL','CY_MPOP3PL','CY_MENROLLED','CY_MNENROLLED','CY_FPOP3PL',
                          'CY_FENROLLED','CY_FNENROLLED'],
    'EDUCATION': ['CY_POP25PL','CY_EDULT8GR','CY_EDU9_12','CY_EDUHSGRAD','CY_EDU2YRCOL','CY_EDUBACH','CY_EDUMAST+'],
    'LANGUAGE': ['CY_POP5PL','CY_POP5_17','CY_ENGLNG5_17','CY_SPALNG5_17','CY_OTHLNG5_17','CY_POP18_64','CY_ENGLNG18_64',
                 'CY_SPALNG18_64','CY_OTHLNG18_64','CY_POP65PL','CY_ENGLNG65PL','CY_SPALNG65PL','CY_OTHLNG65PL'],
    'HOUSING': ['CY_UNITS','CY_UNITSOCC','CY_UNITSVAC','CY_HUOWNER','CY_HUOWN15_34','CY_HUOWN35_64',
                'CY_HUOWN65+','CY_HURENTER','CY_HURENT15_34','CY_HURENT35_64','CY_HURENT65+','CY_HU1ROOM','CY_HU2ROOM',
                'CY_HU3ROOM','CY_HU4ROOM','CY_HU5ROOM','CY_HU6ROOM','CY_HU7ROOM','CY_HU8ROOM','CY_HU9ROOM','CY_HU1DET',
                'CY_HU1ATT','CY_HU2','CY_HU3_4','CY_HU5_9','CY_HU10_19','CY_HU20_49','CY_HU50PLUS','CY_HUMOB','CY_HUOTHER',
                'CY_YRB20+','CY_YRB10_19','CY_YRB00_09','CY_YRB90_99','CY_YRB80_89','CY_YRB70_79','CY_YRB60_69','CY_YRB50_59',
                'CY_YRB40_49','CY_YRBLT39','CY_MEDYEAR'],
    'EMPLOYMENT': ['CY_POP16PL','CY_ILF','CY_ILFCIV','CY_ILFCIVEMP','CY_ILFUNEMP','CY_ILFAF','CY_NOTILF'],
    'OCCUPATION': ['CY_WORKPOP','CY_WORKPRIV','CY_WORKGOVT','CY_WORKSELF','CY_WORKFAM'],
    'OCCUPATION TYPE': ['CY_OCCPOP','CY_WHTCOLLAR','CY_SERVICES','CY_BLUECOLLAR'],
    'TRANSPORTATION': ['CY_TRNSBASE','CY_TRNSAUTO','CY_TRNSPUBLIC','CY_TRNSOTHER','CY_WRKHOME','CY_COMMBASE',
                       'CY_COMMLT15','CY_COMM15_30','CY_COMM30_45','CY_COMM45_60','CY_COMM60_90','CY_COMM90+'],
    'MOBILITY': ['CY_POP1PL','CY_MOBSAME','CY_MOBDIFF','CY_MOBABR']
}

# Variable definitions for tooltips/help
VARIABLE_DEFINITIONS = {
    'BGID': 'Block Group ID (State 00, County 000, Census Tract 000000, Block Group 0)',
    'CY_POP': 'Current Year Estimate: Total Population (Population and Race Base)',
    'CY_MPOP': 'Current Year Estimate: Male Population',
    'CY_MPOP0_17': 'Current Year Estimate: Male Population: Age 0 to 17',
    'CY_MPOP18_24': 'Current Year Estimate: Male Population: Age 18 to 24',
    'CY_MPOP25_44': 'Current Year Estimate: Male Population: Age 25 to 44',
    'CY_MPOP45_64': 'Current Year Estimate: Male Population: Age 45 to 64',
    'CY_MPOP65_84': 'Current Year Estimate: Male Population: Age 65 to 84',
    'CY_MPOP85PL': 'Current Year Estimate: Male Population: Age 85+',
    'CY_FPOP': 'Current Year Estimate: Female Population',
    'CY_FPOP0_17': 'Current Year Estimate: Female Population: Age 0 to 17',
    'CY_FPOP18_24': 'Current Year Estimate: Female Population: Age 18 to 24',
    'CY_FPOP25_44': 'Current Year Estimate: Female Population: Age 25 to 44',
    'CY_FPOP45_64': 'Current Year Estimate: Female Population: Age 45 to 64',
    'CY_FPOP65_84': 'Current Year Estimate: Female Population: Age 65 to 84',
    'CY_FPOP85PL': 'Current Year Estimate: Female Population: Age 85+',
    'POP_DENSITY': 'Current Year Estimate: Total Population Density per Square Mile',
    'FY_POP': 'Future 5-Year Estimate: Future 5-Year Total Population',
    'POP_GROWTH': 'Future 5-Year Estimate: 5-Year Populaton Growth %',
    'CY_MEDAGE': 'Current Year Estimate: Median Age',
    'CY_MMEDAGE': 'Current Year Estimate: Male Median Age',
    'CY_FMEDAGE': 'Current Year Estimate: Female Median Age',
    'CY_WHITE': 'Current Year Estimate: White',
    'CY_BLACK': 'Current Year Estimate: Black or African American',
    'CY_NATIVEAM': 'Current Year Estimate: Native American or Native Alaskan',
    'CY_ASIAN': 'Current Year Estimate: Asian',
    'CY_NATIVEHI': 'Current Year Estimate: Native Hawaiian / Pacific Islander',
    'CY_OTHERRACE': 'Current Year Estimate: Other Race',
    'CY_RACE2+': 'Current Year Estimate: Two or More Races',
    'CY_NOTHISP': 'Current Year Estimate: Not Hispanic or Latino',
    'CY_HISPANIC': 'Current Year Estimate: Hispanic or Latino',
    'CY_HOUSEHOLDS': 'Current Year Estimate: Total Households (Households Base)',
    'HH_DENSITY': 'Current Year Estimate: Total Household Density per Square Mile',
    'CY_AVGHHSIZE': 'Current Year Estimate: Average Household Size (minus Group Quarters Population)',
    'CY_MARHH': 'Current Year Estimate: Married Couple Households',
    'CY_MARHHWCH': 'Current Year Estimate: Married Couple Households: With Children',
    'CY_MARHHNOCH': 'Current Year Estimate: Married Couple Households: With No Children',
    'CY_COHHH': 'Current Year Estimate: Cohabiting Couple Households',
    'CY_COHHHWCH': 'Current Year Estimate: Cohabiting Couple Households: With Children',
    'CY_COHHHNOCH': 'Current Year Estimate: Cohabiting Couple Households: With No Children',
    'CY_FEMHH': 'Current Year Estimate: Single Female Households',
    'CY_FEMHHLA': 'Current Year Estimate: Single Female Households: Living Alone',
    'CY_FEMHHWCH': 'Current Year Estimate: Single Female Households: With Children',
    'CY_FEMHHNOCH': 'Current Year Estimate: Single Female Households: With Relatives, No Children',
    'CY_FEMHHNR': 'Current Year Estimate: Single Female Households: With Nonrelatives Only',
    'CY_MALEHH': 'Current Year Estimate: Single Male Households',
    'CY_MALEHHLA': 'Current Year Estimate: Single Male Households: Living Alone',
    'CY_MALEHHWCH': 'Current Year Estimate: Single Male Households: With Children',
    'CY_MALEHHNOCH': 'Current Year Estimate: Single Male Households: With Relatives, No Children',
    'CY_MALEHHNR': 'Current Year Estimate: Single Male Households: With Nonrelatives Only',
    'CY_FAMHH2': 'Current Year Estimate: Family Households: 2 Persons',
    'CY_FAMHH3': 'Current Year Estimate: Family Households: 3 Persons',
    'CY_FAMHH4': 'Current Year Estimate: Family Households: 4 Persons',
    'CY_FAMHH5': 'Current Year Estimate: Family Households: 5 Persons',
    'CY_FAMHH6': 'Current Year Estimate: Family Households: 6 Persons',
    'CY_FAMHH7': 'Current Year Estimate: Family Households: 7+ Persons',
    'CY_NFAMHH1': 'Current Year Estimate: Nonfamily Households: 1 Person',
    'CY_NFAMHH2': 'Current Year Estimate: Nonfamily Households: 2 Persons',
    'CY_NFAMHH3': 'Current Year Estimate: Nonfamily Households: 3 Persons',
    'CY_NFAMHH4': 'Current Year Estimate: Nonfamily Households: 4 Persons',
    'CY_NFAMHH5': 'Current Year Estimate: Nonfamily Households: 5 Persons',
    'CY_NFAMHH6': 'Current Year Estimate: Nonfamily Households: 6 Persons',
    'CY_NFAMHH7': 'Current Year Estimate: Nonfamily Households: 7+ Persons',
    'CY_POP15PL': 'Current Year Estimate: Total Population Age 15+ (Marital Status Base)',
    'CY_MPOP15PL': 'Current Year Estimate: Male Population Age 15+',
    'CY_MNMAR': 'Current Year Estimate: Male: Never Married',
    'CY_MMAR': 'Current Year Estimate: Male: Currently Married',
    'CY_MWID': 'Current Year Estimate: Male: Widowed',
    'CY_MDIV': 'Current Year Estimate: Male: Divorced',
    'CY_FPOP15PL': 'Current Year Estimate: Female Population Age 15+',
    'CY_FNMAR': 'Current Year Estimate: Female: Never Married',
    'CY_FMAR': 'Current Year Estimate: Female: Currently Married',
    'CY_FWID': 'Current Year Estimate: Female: Widowed',
    'CY_FDIV': 'Current Year Estimate: Female: Divorced',
    'CY_POP18PL': 'Current Year Estimate: Total Population Age 18+ (Veteran Status Base)',
    'CY_VETERAN': 'Current Year Estimate: Veteran',
    'CY_NVETERAN': 'Current Year Estimate: Nonveteran',
    'CY_INCLT10K': 'Current Year Estimate: Households with Income Less Than $10K',
    'CY_INC10_15K': 'Current Year Estimate: Households with Income $10K to $15K',
    'CY_INC15_20K': 'Current Year Estimate: Households with Income $15K to $20K',
    'CY_INC20_25K': 'Current Year Estimate: Households with Income $20K to $25K',
    'CY_INC25_30K': 'Current Year Estimate: Households with Income $25K to $30K',
    'CY_INC30_35K': 'Current Year Estimate: Households with Income $30K to $35K',
    'CY_INC35_40K': 'Current Year Estimate: Households with Income $35K to $40K',
    'CY_INC40_45K': 'Current Year Estimate: Households with Income $40K to $45K',
    'CY_INC45_50K': 'Current Year Estimate: Households with Income $45K to $50K',
    'CY_INC50_60K': 'Current Year Estimate: Households with Income $50K to $60K',
    'CY_INC60_75K': 'Current Year Estimate: Households with Income $60K to $75K',
    'CY_INC75_100K': 'Current Year Estimate: Households with Income $75K to $100K',
    'CY_INC100_125K': 'Current Year Estimate: Households with Income $100K to $125K',
    'CY_INC125_150K': 'Current Year Estimate: Households with Income $125K to $150K',
    'CY_INC150_200K': 'Current Year Estimate: Households with Income $150K to $200K',
    'CY_INC200K+': 'Current Year Estimate: Households with Income $200K+',
    'CY_AVGHHINC': 'Current Year Estimate: Average Household Income',
    'CY_MEDHHINC': 'Current Year Estimate: Median Household Income',
    'CY_AGGINCOME': 'Current Year Estimate: Aggregate Household Income',
    'CY_POP3PL': 'Current Year Estimate: Total Population Age 3+ (School Enrollment Base)',
    'CY_MPOP3PL': 'Current Year Estimate: Male Population Age 3+',
    'CY_MENROLLED': 'Current Year Estimate: Male Enrolled in School',
    'CY_MNENROLLED': 'Current Year Estimate: Male Not Enrolled in School',
    'CY_FPOP3PL': 'Current Year Estimate: Female Population Age 3+',
    'CY_FENROLLED': 'Current Year Estimate: Female Enrolled in School',
    'CY_FNENROLLED': 'Current Year Estimate: Female Not Enrolled in School',
    'CY_POP25PL': 'Current Year Estimate: Total Population Age 25+ (Education Base)',
    'CY_EDULT8GR': 'Current Year Estimate: 8th Grade or Less',
    'CY_EDU9_12': 'Current Year Estimate: 9th Grade to 12th Grade',
    'CY_EDUHSGRAD': 'Current Year Estimate: High School Grad or Equivalent',
    'CY_EDU2YRCOL': 'Current Year Estimate: Some College to Associates / Professional Degree',
    'CY_EDUBACH': 'Current Year Estimate: Bachelors Degree',
    'CY_EDUMAST+': 'Current Year Estimate: Masters or Doctorate Degree',
    'CY_POP5PL': 'Current Year Estimate: Total Population Age 5+ (Language Base)',
    'CY_POP5_17': 'Current Year Estimate: Total Population Age 5 to 17',
    'CY_ENGLNG5_17': 'Current Year Estimate: Population Age 5 to 17: Speaks English Only',
    'CY_SPALNG5_17': 'Current Year Estimate: Population Age 5 to 17: Speaks Spanish',
    'CY_OTHLNG5_17': 'Current Year Estimate: Population Age 5 to 17: Speaks Other Language(s)',
    'CY_POP18_64': 'Current Year Estimate: Total Population Age 18 to 64',
    'CY_ENGLNG18_64': 'Current Year Estimate: Population Age 18 to 64: Speaks English Only',
    'CY_SPALNG18_64': 'Current Year Estimate: Population Age 18 to 64: Speaks Spanish',
    'CY_OTHLNG18_64': 'Current Year Estimate: Population Age 18 to 64: Speaks Other Language(s)',
    'CY_POP65PL': 'Current Year Estimate: Total Population Age 65+',
    'CY_ENGLNG65PL': 'Current Year Estimate: Population Age 65+: Speaks English Only',
    'CY_SPALNG65PL': 'Current Year Estimate: Population Age 65+: Speaks Spanish',
    'CY_OTHLNG65PL': 'Current Year Estimate: Population Age 65+: Speaks Other Language(s)',
    'CY_UNITS': 'Current Year Estimate: Total Housing Units (Housing Base)',
    'CY_UNITSOCC': 'Current Year Estimate: Occupied Housing Units',
    'CY_UNITSVAC': 'Current Year Estimate: Vacant Housing Units',
    'CY_HUOWNER': 'Current Year Estimate: Owner Occupied Housing',
    'CY_HUOWN15_34': 'Current Year Estimate: Owner Occupied Housing: Householder Age 15 to 34',
    'CY_HUOWN35_64': 'Current Year Estimate: Owner Occupied Housing: Householder Age 35 to 44',
    'CY_HUOWN65+': 'Current Year Estimate: Owner Occupied Housing: Householder Age 65+',
    'CY_HURENTER': 'Current Year Estimate: Renter Occupied Housing',
    'CY_HURENT15_34': 'Current Year Estimate: Renter Occupied Housing: Householder Age 15 to 34',
    'CY_HURENT35_64': 'Current Year Estimate: Renter Occupied Housing: Householder Age 35 to 44',
    'CY_HURENT65+': 'Current Year Estimate: Renter Occupied Housing: Householder Age 65+',
    'CY_HU1ROOM': 'Current Year Estimate: 1 Room Housing Units',
    'CY_HU2ROOM': 'Current Year Estimate: 2 Room Housing Units',
    'CY_HU3ROOM': 'Current Year Estimate: 3 Room Housing Units',
    'CY_HU4ROOM': 'Current Year Estimate: 4 Room Housing Units',
    'CY_HU5ROOM': 'Current Year Estimate: 5 Room Housing Units',
    'CY_HU6ROOM': 'Current Year Estimate: 6 Room Housing Units',
    'CY_HU7ROOM': 'Current Year Estimate: 7 Room Housing Units',
    'CY_HU8ROOM': 'Current Year Estimate: 8 Room Housing Units',
    'CY_HU9ROOM': 'Current Year Estimate: 9+ Room Housing Units',
    'CY_HU1DET': 'Current Year Estimate: 1 Unit Detached Structures',
    'CY_HU1ATT': 'Current Year Estimate: 1 Unit Attached Structures',
    'CY_HU2': 'Current Year Estimate: 2 Unit Structures',
    'CY_HU3_4': 'Current Year Estimate: 3 or 4 Unit Structures',
    'CY_HU5_9': 'Current Year Estimate: 5 to 9 Unit Structures',
    'CY_HU10_19': 'Current Year Estimate: 10 to 19 Unit Structures',
    'CY_HU20_49': 'Current Year Estimate: 20 to 49 Unit Structures',
    'CY_HU50PLUS': 'Current Year Estimate: 50 or More Unit Structures',
    'CY_HUMOB': 'Current Year Estimate: Mobile Home Units',
    'CY_HUOTHER': 'Current Year Estimate: Other Housing Units',
    'CY_YRB20+': 'Current Year Estimate: Structure Built 2020+',
    'CY_YRB10_19': 'Current Year Estimate: Structure Built 2010 to 2019',
    'CY_YRB00_09': 'Current Year Estimate: Structure Built 2000 to 2009',
    'CY_YRB90_99': 'Current Year Estimate: Structure Built 1990 to 1999',
    'CY_YRB80_89': 'Current Year Estimate: Structure Built 1980 to 1989',
    'CY_YRB70_79': 'Current Year Estimate: Structure Built 1970 to 1979',
    'CY_YRB60_69': 'Current Year Estimate: Structure Built 1960 to 1969',
    'CY_YRB50_59': 'Current Year Estimate: Structure Built 1950 to 1959',
    'CY_YRB40_49': 'Current Year Estimate: Structure Built 1940 to 1949',
    'CY_YRBLT39': 'Current Year Estimate: Structure Built 1939 or Earlier',
    'CY_MEDYEAR': 'Current Year Estimate: Median Year Structure Built',
    'CY_POP16PL': 'Current Year Estimate: Total Population Age 16+ (Employment Base)',
    'CY_ILF': 'Current Year Estimate: In Labor Force',
    'CY_ILFCIV': 'Current Year Estimate: In Civilian Labor Force',
    'CY_ILFCIVEMP': 'Current Year Estimate: In Civilian Labor Force: Employed',
    'CY_ILFUNEMP': 'Current Year Estimate: In Civilian Labor Force: Unemployed',
    'CY_ILFAF': 'Current Year Estimate: In Armed Forces',
    'CY_NOTILF': 'Current Year Estimate: Not In Labor Force',
    'CY_WORKPOP': 'Current Year Estimate: Employed Civilian Population (Occupation Base)',
    'CY_WORKPRIV': 'Current Year Estimate: Private Business Workers',
    'CY_WORKGOVT': 'Current Year Estimate: Local/State/Federal Government Workers',
    'CY_WORKSELF': 'Current Year Estimate: Self-Employed Workers',
    'CY_WORKFAM': 'Current Year Estimate: Family Workers',
    'CY_OCCPOP': 'Current Year Estimate: Employed Civilian Population (Occupation Type Base)',
    'CY_WHTCOLLAR': 'Current Year Estimate: White Collar Workers',
    'CY_SERVICES': 'Current Year Estimate: Services Workers',
    'CY_BLUECOLLAR': 'Current Year Estimate: Blue Collar Workers',
    'CY_TRNSBASE': 'Current Year Estimate: Total Commuter-Adjusted Population (Transportation Base)',
    'CY_TRNSAUTO': 'Current Year Estimate: Commute via Automobile',
    'CY_TRNSPUBLIC': 'Current Year Estimate: Commute via Public Transportation',
    'CY_TRNSOTHER': 'Current Year Estimate: Commute via Any Other Means',
    'CY_WRKHOME': 'Current Year Estimate: Works from Home',
    'CY_COMMBASE': 'Current Year Estimate: Total Commuting Workers (Commute Base)',
    'CY_COMMLT15': 'Current Year Estimate: Commute Time Less Than 15 Minutes',
    'CY_COMM15_30': 'Current Year Estimate: Commute Time 15 to 30 Minutes',
    'CY_COMM30_45': 'Current Year Estimate: Commute Time 30 to 45 Minutes',
    'CY_COMM45_60': 'Current Year Estimate: Commute Time 45 to 60 Minutes',
    'CY_COMM60_90': 'Current Year Estimate: Commute Time 60 to 90 Minutes',
    'CY_COMM90+': 'Current Year Estimate: Commute Time 90+ Minutes',
    'CY_POP1PL': 'Current Year Estimate: Total Population Age 1+ (Mobility Base)',
    'CY_MOBSAME': 'Current Year Estimate: Same House from Last Year',
    'CY_MOBDIFF': 'Current Year Estimate: Different House from Last Year',
    'CY_MOBABR': 'Current Year Estimate: Abroad Last Year',
    'LAND_AREA': 'Estimated Land Area in Square Miles'
}

def get_package_variables(package_name):
    """
    Returns list of variables for the specified package.
    
    Args:
        package_name (str): One of 'Basic Package', 'Expanded Package', 'Professional Package'
    
    Returns:
        list: List of variable names included in that package
    """
    if package_name == 'Professional Package':
        return PROFESSIONAL_VARIABLES
    elif package_name == 'Expanded Package':
        return EXPANDED_VARIABLES
    elif package_name == 'Basic Package':
        return BASIC_VARIABLES
    else:
        return []