# demand_provider.py
import os

from qgis.core import QgsProcessingProvider
from PyQt5.QtGui import QIcon
from .demand_allocator_algorithm import DemandAllocatorAlgorithm

class DemandAllocatorProvider(QgsProcessingProvider):
    def loadAlgorithms(self):
        self.addAlgorithm(DemandAllocatorAlgorithm())

    def id(self):
        return 'demand_allocator'

    def name(self):
        return 'Demand Allocator'

    def icon(self):
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(icon_path)