# DemandAllocator.py
from qgis.core import QgsApplication
from qgis import processing
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction
import os

from .demand_provider import DemandAllocatorProvider


class DemandAllocator:
    def __init__(self, iface):
        self.iface = iface
        self.provider = None
        self.action = None

    def initGui(self):
        # Create action with icon
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        self.action = QAction(
            QIcon(icon_path),
            'Allocate Demand Points',
            self.iface.mainWindow()
        )
        self.action.triggered.connect(self.run)

        # Add to toolbar and menu
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu('&Demand Allocator', self.action)

        # Register Processing provider (keeps it available in Toolbox too)
        self.initProcessing()

    def initProcessing(self):
        self.provider = DemandAllocatorProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        # Remove toolbar icon and menu
        if self.action:
            self.iface.removeToolBarIcon(self.action)
            self.iface.removePluginMenu('&Demand Allocator', self.action)

        # Remove Processing provider
        if self.provider:
            QgsApplication.processingRegistry().removeProvider(self.provider)

    def run(self):
        """Opens the algorithm dialog directly when icon is clicked"""
        algorithm_id = "demand_allocator:allocate_demand_points"

        try:
            processing.execAlgorithmDialog(algorithm_id)
        except Exception as e:
            from qgis.utils import iface
            iface.messageBar().pushMessage(
                "Demand Allocator",
                f"Failed to open dialog: {str(e)}",
                level=1,  # Warning
                duration=10
            )