# Demand Allocator

QGIS plugin that allocates house/building demand to the nearest pipe network.

Overview
This tool snaps house polygon centroids to pipes, clusters nearby points, creates aggregated demand/load points and draws reference lines from each house to its demand point.  
Useful for water supply, sewer design and utility planning.

Features

1. Computes centroids of house polygons
2. Snaps centroids to nearest point on pipe lines
3. Clusters snapped points within a user-defined threshold
4. Generates aggregated demand points (with house count)
5. Creates reference lines (centroid ? demand point)

Installation

Download the zip and:

1. Install the zipped plugin:

   Open QGIS  
   Manage and Install Plugins  
   Install from ZIP  
   Browse and Select ZIP  
   OK.

2. Or extract and copy the plugin folder into the QGIS plugin directory:

   For Windows:  
   %APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\

   Quick way: Settings ? User Profiles ? Open Active Profile Folder ? python/plugins

3. Restart QGIS and activate the plugin from the Plugin Manager.

Usage

Open QGIS and navigate to Processing Toolbox.  
Search for "Allocate Demand Points".

Configure the input parameters:

1. House Polygons: polygon layer (required)
2. Pipe Network: line layer (required)
3. Clustering Threshold (meters): e.g. 50 (required)
4. Output CRS: projected CRS in meters (recommended)
5. Output Folder: optional (for saving shapefiles)

Click Run to generate:
- House Load Points layer
- Reference Lines layer

Important Notes

- Input layers must use a **projected CRS in meters** (e.g. UTM zone).  

Contact
haqqanuddin18@gmail.com
