# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DeltaLakeDialog
                                 A QGIS plugin
 With this plugin you can load data from delta shares
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-12-29
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Richard Kooijman
        email                : kooijman.richard@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import operator
import pyproj
from pyproj.enums import PJType

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from .provider.delta_lake_provider import client_connect

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'delta_lake_dialog_base.ui'))


class DeltaLakeDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(DeltaLakeDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self._tables = None
        self._crs_list = None
        self._share_combo_box.activated.connect(self._table_selected)
        self._connection_profile_path.fileChanged.connect(self._add_list_tables)

        self._crs_combo_box.activated.connect(self._crs_selected)
        self._connection_profile_path.fileChanged.connect(self._add_list_crs)

    @property
    def connection_profile_path(self):
        return self._connection_profile_path.filePath()

    @property
    def share_name(self):
        return self._share_name.text()

    @property
    def schema_name(self):
        return self._schema_name.text()

    @property
    def table_name(self):
        return self._table_name.text()

    @property
    def epsg_id(self):
        return self._epsg_id.text()

    def _add_list_tables(self):
        self._share_combo_box.clear()
        try:
            client = client_connect(self._connection_profile_path.filePath())
            self._tables = sorted(client.list_all_tables(), key=operator.attrgetter("schema", "name"))
            self._share_combo_box.addItems([f"{table.schema} - {table.name}" for table in self._tables])
        except FileNotFoundError:
            # connection failed, clear resulting values
            self._share_name.clear()
            self._schema_name.clear()
            self._table_name.clear()

    def _get_current_table(self):
        return self._tables[self._share_combo_box.currentIndex()]

    def _table_selected(self):
        self._share_name.setText(self._get_current_table().share)
        self._schema_name.setText(self._get_current_table().schema)
        self._table_name.setText(self._get_current_table().name)

    def _add_list_crs(self):
        self._crs_combo_box.clear()
        self._crs_list = [(crs.code, crs.name) for crs in
                          pyproj.database.query_crs_info(auth_name="EPSG",
                                                         pj_types=[PJType.PROJECTED_CRS, PJType.GEOGRAPHIC_CRS])
                          if "World" in crs.area_of_use.name or "Netherlands" in crs.area_of_use.name]
        self._crs_combo_box.addItems([f"{crs[0]} - {crs[1]}" for crs in self._crs_list])

    def _get_current_crs(self):
        return self._crs_list[self._crs_combo_box.currentIndex()]

    def _crs_selected(self):
        self._epsg_id.setText(self._get_current_crs()[0])

    def validate(self):
        if (self.share_name == ""
                or self.schema_name == ""
                or self.table_name == ""
                or self.epsg_id == ""):
            return False
        try:
            epsg_code = int(self.epsg_id)
            if epsg_code < 0:
                return False
        except ValueError:
            return False
        return True
