# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Delete_Null_Fields
                                 A QGIS plugin
 This plugin will delete all fields/columns from a vector layer or data which has all values equal to NULL.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-12-31
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Abdullah / Mphil RS and GIS
        email                : spaciandd@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import QgsMessageLog
from qgis.core import QgsMapLayer
from qgis.core import QgsVectorLayer
from qgis.core import QgsProject
from qgis.core import QgsVectorDataProvider
from qgis.core import QgsVectorFileWriter
import processing
from qgis.analysis import QgsNativeAlgorithms
import os
from PyQt5.QtGui import QStandardItemModel, QStandardItem
from PyQt5.QtWidgets import QMessageBox
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .delete_null_fields_dialog import Delete_Null_FieldsDialog
import os.path


class Delete_Null_Fields:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Delete_Null_Fields_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Delete NULL Fields from Vector Data')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Delete_Null_Fields', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/delete_null_fields/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Delete Null Value Columns from Attribute Table'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Delete NULL Fields from Vector Data'),
                action)
            self.iface.removeToolBarIcon(action)

    def add_vector_file(self):
        file_names, _filter = QFileDialog.getOpenFileNames(self.dlg, "Select files", "", "Files (*.json *.geojson *.shp)")
        if file_names:
            for fname in file_names:
                v_file_name = os.path.basename(fname)
                self.dlg.cb_in_vector.addItem(v_file_name, fname)

    def out_vector_file(self):
        file_name, _filter = QFileDialog.getSaveFileName(self.dlg, "Output file ","", '*.shp')
        if file_name:
            self.dlg.le_out_vector.setText(file_name)

    def update_list_view(self):
        if not self.dlg.cb_in_vector.currentData():
            return
        
        if isinstance(self.dlg.cb_in_vector.currentData(), QgsVectorLayer):
            lyr_name = self.dlg.cb_in_vector.currentText()
            sel_lyr = QgsProject.instance().mapLayersByName(lyr_name)[0]
        else:
            sel_lyr_path = self.dlg.cb_in_vector.currentData()
            lyr_name = os.path.basename(sel_lyr_path)
            sel_lyr = QgsVectorLayer(sel_lyr_path, lyr_name, "ogr")

        sel_lyr.selectAll()
        self.sel_lyr_tmp = processing.run("native:saveselectedfeatures", {'INPUT': sel_lyr, 'OUTPUT': 'memory:'})['OUTPUT']
        field_names = self.sel_lyr_tmp.fields().names()
        values_list = []
        feature_count = self.sel_lyr_tmp.featureCount()
        self.dlg.lw_list_fields.clear()
        for fname in field_names:
            for f in self.sel_lyr_tmp.getFeatures():
                if f[fname]:
                    break
                values_list.append(f[fname])

            if(len(values_list) == feature_count and not all(v is None for v in values_list)):
                self.dlg.lw_list_fields.addItem(fname)

            values_list = []


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Delete_Null_FieldsDialog()
            self.dlg.tb_in_vector.clicked.connect(self.add_vector_file)
            self.dlg.tb_out_vector.clicked.connect(self.out_vector_file)
            self.dlg.cb_in_vector.currentIndexChanged.connect(self.update_list_view)

        self.dlg.cb_in_vector.clear()
        layer_list = QgsProject.instance().mapLayers().values()
        for lyr in layer_list:
            if lyr.type() == QgsMapLayer.VectorLayer:
                self.dlg.cb_in_vector.addItem(lyr.name(), lyr)
        
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            sel_field_names = [f.text() for f in self.dlg.lw_list_fields.selectedItems()]
            if sel_field_names:
                caps = self.sel_lyr_tmp.dataProvider().capabilities()
                if caps and QgsVectorDataProvider.DeleteAttributes:
                    for fname in sel_field_names:
                        field_index = self.sel_lyr_tmp.fields().indexFromName(fname)
                        self.sel_lyr_tmp.dataProvider().deleteAttributes([field_index])
                        self.sel_lyr_tmp.updateFields()

                    if self.dlg.le_out_vector.text() and os.path.exists(os.path.split(self.dlg.le_out_vector.text())[0]) and os.path.split(self.dlg.le_out_vector.text())[1].split('.')[-1].lower() == 'shp':
                        QgsMessageLog.logMessage("Output Path is valid", "Saving...")
                        QgsVectorFileWriter.writeAsVectorFormat(self.sel_lyr_tmp, self.dlg.le_out_vector.text(), "utf-8", self.sel_lyr_tmp.crs(), "ESRI Shapefile")
                    else:
                        QgsMessageLog.logMessage("Output Path is not valid", "Creating Map Layer...")
                        QgsProject.instance().addMapLayer(self.sel_lyr_tmp)
                
                msg = QMessageBox()
                msg.setWindowTitle("Success")
                msg.setIcon(1024) # QMessageBox.Ok
                msg.setText("Congrats! NULL fields deleted from the file.")
                # msg.show()
                msg.exec_()
            else:
                msg = QMessageBox()
                msg.setWindowTitle("Error")
                msg.setIcon(3) # QMessageBox.Critical
                msg.setText("Selected does not have any NULL value column OR You did not select the field/s to delete.")
                # msg.show()
                msg.exec_()
