# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DepthReaderOCRDialog
                                 A QGIS plugin
 Automatically extracts depth values from nautical charts using OCR.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-06-21
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Elivaldo Rocha
        email                : carvalhovaldo09@gmail.com
 ***************************************************************************/

/***************************************************************************
 * *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 * *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QFileDialog

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'deep_reader_ocr_dialog_base.ui'))


class DepthReaderOCRDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(DepthReaderOCRDialog, self).__init__(parent)
        self.setupUi(self)

        # Conectar botões de procurar
        self.btnBrowseDebugDir.clicked.connect(self.browse_debug_directory)
        self.btnBrowseCSV.clicked.connect(self.browse_csv_file)

        # Configurar valores padrão para os QLineEdits
        default_user_dir = os.path.expanduser("~")
        self.leDebugDir.setText(os.path.join(default_user_dir, "depth_reader_debug"))
        self.leCSVPath.setText(os.path.join(default_user_dir, "batimetria.csv"))

        # Configurar QComboBox para o tamanho do recorte
        self.cbClipSize.addItems(["16", "32", "48", "64", "80", "96"])
        self.cbClipSize.setCurrentText("96") # Define 96 como padrão

        # Configurar informações para o usuário
        info_text = (
    "Este plugin permite aos usuários extrair automaticamente valores de profundidade de cartas náuticas raster (GeoTIFF) da Marinha do Brasil usando OCR.\n\n" 
    
    "• Onde Baixar Cartas Náuticas Raster ?\n\n"
    "Você pode baixar as Cartas Raster (GeoTIFF) gratuitamente para fins acadêmicos no site oficial da Marinha do Brasil:\n\n"
    "https://www.marinha.mil.br/chm/dados-do-segnav/cartas-raster\n\n"
    
    "• Requisitos do Sistema - Tesseract OCR:\n\n"
    "Para funcionamento ideal, é necessário instalar o Tesseract OCR em seu sistema:\n\n"
    "🔗 Download Tesseract OCR (Windows): https://github.com/UB-Mannheim/tesseract/wiki\n"
    "🔗 Download Tesseract OCR (Linux/Mac): https://tesseract-ocr.github.io/tessdoc/Installation.html\n\n"
    "⚠️ IMPORTANTE: Durante a instalação no Windows, marque a opção 'Add Tesseract to PATH' para que o plugin possa encontrá-lo automaticamente.\n\n"
    
    "• Informações Importantes sobre as Cartas Raster (GeoTIFF) da Marinha:\n\n"
    "1) Solicita-se a colaboração dos usuários na avaliação do produto e no envio de sugestões visando a sua melhoria.\n\n"
    "2) As eventuais sugestões podem ser encaminhadas por e-mail (chm.cartografia@marinha.mil.br).\n\n"
    "3) As Cartas Raster disponibilizadas gratuitamente pela DHN/CHM não podem ser reproduzidas/compiladas/derivadas para fins comerciais.\n\n"
    "4) A DHN detém exclusivamente os Direitos Autorais e de copyright.\n\n"
    "5) Os arquivos GeoTIFF são disponibilizados para fins acadêmicos e não devem, sob hipótese alguma, serem utilizados como auxílio à navegação, uma vez que não são atualizados regularmente.\n\n"
    
    "• Como Usar Este Plugin:\n\n"
    "Este plugin detecta profundidades em cartas náuticas usando OCR.\n\n"
    "• Diretório para Imagens de Debug: Local onde serão salvas as imagens "
    "recortadas e processadas para depuração. Útil para verificar o desempenho do OCR.\n\n"
    "• Caminho para o Arquivo CSV da Batimetria: Local e nome do arquivo CSV "
    "onde as profundidades detectadas e suas coordenadas (X, Y) serão registradas.\n\n"
    "• Tamanho do Recorte: Define o tamanho do quadrado (em pixels) ao redor "
    "do ponto clicado que será analisado pelo OCR. Múltiplos de 16 são recomendados para otimização.\n\n"
    "• Tecnologias Utilizadas: Para um desempenho ideal, certifique-se de que o Tesseract OCR "
    "está instalado e configurado corretamente em seu sistema. EasyOCR também é usado se disponível."
        )
        self.tbInfo.setText(info_text)

    def browse_debug_directory(self):
        """Abre um diálogo para selecionar o diretório onde as imagens de debug serão salvas."""
        directory = QFileDialog.getExistingDirectory(self, "Selecionar Diretório para Imagens de Debug",
                                                     self.leDebugDir.text())
        if directory:
            self.leDebugDir.setText(directory)

    def browse_csv_file(self):
        """Abre um diálogo para selecionar o caminho e nome do arquivo CSV da batimetria."""
        file_path, _ = QFileDialog.getSaveFileName(self, "Salvar Arquivo CSV da Batimetria",
                                                   self.leCSVPath.text(), "Arquivos CSV (*.csv)")
        if file_path:
            self.leCSVPath.setText(file_path)

    def get_debug_directory(self):
        """Retorna o caminho do diretório de debug selecionado pelo usuário."""
        return self.leDebugDir.text()

    def get_csv_path(self):
        """Retorna o caminho do arquivo CSV da batimetria selecionado pelo usuário."""
        return self.leCSVPath.text()

    def get_clip_size(self):
        """Retorna o tamanho do recorte (em pixels) selecionado pelo usuário."""
        return int(self.cbClipSize.currentText())