# -*- coding: utf-8 -*-
"""
/***************************************************************************
                                 A QGIS plugin
 dbprisk2
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-12
        copyright            : (C) 2025 by KIOS Smart Water Team
        email                : mkiria01@ucy.ac.cy
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

import importlib
from typing import List

from qgis.core import QgsMessageLog, Qgis
PLUGIN_TAG = "dbpRisk"

def log(msg, lvl=Qgis.Info):
    QgsMessageLog.logMessage(str(msg), PLUGIN_TAG, lvl)

SUBPLUGINS = ["dbpriskapp", "dbpSimulatorUI"]

class _Wrap:
    def __init__(self, iface, pkg: str):
        self.iface = iface
        self.pkg = pkg
        self.mod = None
        self.inst = None

    def load(self) -> bool:
        try:
            self.mod = importlib.import_module(f".{self.pkg}", __package__)
        except Exception as e:
            log(f"Import failed for '{self.pkg}': {e}", Qgis.Critical)
            return False
        if not hasattr(self.mod, "classFactory"):
            log(f"'{self.pkg}' missing classFactory(iface)", Qgis.Critical)
            return False
        try:
            self.inst = self.mod.classFactory(self.iface)
        except Exception as e:
            log(f"classFactory() error in '{self.pkg}': {e}", Qgis.Critical)
            return False
        return True

    def init_gui(self):
        if hasattr(self.inst, "initGui"):
            try:
                self.inst.initGui()
                log(f"initGui OK: {self.pkg}")
            except Exception as e:
                log(f"initGui failed: {self.pkg}: {e}", Qgis.Critical)

    def unload(self):
        if hasattr(self.inst, "unload"):
            try:
                self.inst.unload()
                log(f"unload OK: {self.pkg}")
            except Exception as e:
                log(f"unload failed: {self.pkg}: {e}", Qgis.Critical)

class dbpRisk2Plugin:
    def __init__(self, iface):
        self.iface = iface
        self.children: List[_Wrap] = []

    def initGui(self):
        for name in SUBPLUGINS:
            w = _Wrap(self.iface, name)
            if w.load():
                self.children.append(w)
                w.init_gui()
            else:
                log(f"Skipped '{name}' due to load error", Qgis.Warning)

    def unload(self):
        for w in reversed(self.children):
            w.unload()
        self.children.clear()
