# -*- coding: utf-8 -*-

#******************************************************************************
#
# Statist
# ---------------------------------------------------------
# Provides basic statistics information on any (numeric or string) field
# of vector layer.
#
# Copyright (C) 2009-2013 Alexander Bruy (alexander.bruy@gmail.com)
#
# This source is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 2 of the License, or (at your option)
# any later version.
#
# This code is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# A copy of the GNU General Public License is available on the World Wide Web
# at <http://www.gnu.org/licenses/>. You can also obtain it by writing
# to the Free Software Foundation, 51 Franklin Street, Suite 500 Boston,
# MA 02110-1335 USA.
#
#******************************************************************************


from builtins import str
import locale

##from PyQt4.QtCore import *
from qgis.PyQt.QtWidgets import QDialog, QAction, QFileDialog, QMessageBox

from qgis.core import *
from qgis.gui import *
from scipy import sparse
from scipy.sparse import dia_matrix, eye as speye
from scipy.sparse.linalg import spsolve
import numpy as np



def getVectorLayerNames():
    # API 2: layerMap = QgsMapLayerRegistry.instance().mapLayers()
    layerMap =  QgsProject.instance().mapLayers()
    layerNames = []
    for name, layer in layerMap.items():
        if layer.type() == QgsMapLayer.VectorLayer:
            layerNames.append(str(layer.name()))
    return sorted(layerNames) #, cmp=locale.strcoll)


def getVectorLayerByName(layerName):
    layerMap =  QgsProject.instance().mapLayers()
    #layerMap = QgsMapLayerRegistry.instance().mapLayers()
    for name, layer in layerMap.items():
        if layer.type() == QgsMapLayer.VectorLayer and layer.name() == layerName:
            if layer.isValid():
                return layer
            else:
                return None

def getFieldNames(layer, fieldTypes):
    fields = layer.fields()
    fieldNames = []
    for field in fields:
        if field.type() in fieldTypes and not field.name() in fieldNames:
            fieldNames.append(str(field.name()))
    return sorted(fieldNames)#, cmp=locale.strcoll)


def getFieldType(layer, fieldName):
    fields = layer.fields()
    for field in fields:
        if field.name() == fieldName:
            return field.typeName()


def getUniqueValuesCount(layer, fieldIndex, useSelection):
    count = 0
    values = []
    if useSelection:
        for f in layer.selectedFeatures():
            if f[fieldIndex] not in values:
                values.append(f[fieldIndex])
                count += 1
    else:
        request = QgsFeatureRequest().setFlags(QgsFeatureRequest.NoGeometry)
        for f in layer.getFeatures(request):
            if f[fieldIndex] not in values:
                values.append(f[fieldIndex])
                count += 1
    return count


