# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DataAW
                                 A QGIS plugin
 DataAW compares two files using area-weighted data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-12-03
        copyright            : (C) 2024 by Eunice Barbosa
        email                : e_kbb8@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Eunice Barbosa'
__date__ = '2024-12-03'
__copyright__ = '(C) 2024 by Eunice Barbosa'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSink
import os
import inspect
from qgis.PyQt.QtGui import QIcon
import processing


class DataAWAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('data_open_file', 'Data open file', defaultValue=None))
        self.addParameter(QgsProcessingParameterField('data_select_field', 'Data select field', type=QgsProcessingParameterField.Any, parentLayerParameterName='data_open_file', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('grid_open_file', 'Grid open file', defaultValue=None))
        self.addParameter(QgsProcessingParameterField('grid_select_field_id', 'Grid select field id', type=QgsProcessingParameterField.Any, parentLayerParameterName='grid_open_file', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('SaveFile', 'Save file', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(8, model_feedback)
        results = {}
        outputs = {}

        # Rename field data
        alg_params = {
            'FIELD': parameters['data_select_field'],
            'INPUT': parameters['data_open_file'],
            'NEW_NAME': 'DataS',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RenameFieldData'] = processing.run('native:renametablefield', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Rename field grid
        alg_params = {
            'FIELD': parameters['grid_select_field_id'],
            'INPUT': parameters['grid_open_file'],
            'NEW_NAME': 'IdG',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RenameFieldGrid'] = processing.run('native:renametablefield', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Field calculator Area data
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'AreaG',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Decimal (double)
            'FORMULA': '$area',
            'INPUT': outputs['RenameFieldData']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorAreaData'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Intersection
        alg_params = {
            'GRID_SIZE': None,
            'INPUT': outputs['RenameFieldGrid']['OUTPUT'],
            'INPUT_FIELDS': ['IdG'],
            'OVERLAY': outputs['FieldCalculatorAreaData']['OUTPUT'],
            'OVERLAY_FIELDS': ['DataS','AreaG'],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Field calculator areap
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'AreaP',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Decimal (double)
            'FORMULA': '$area',
            'INPUT': outputs['Intersection']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorAreap'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Field calculator - DataAW
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'DataAW',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Decimal (double)
            'FORMULA': 'sum((DataS*(AreaP/AreaG)) , group_by:="IdG")\n\n',
            'INPUT': outputs['FieldCalculatorAreap']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorDataaw'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Join attributes by field value
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'FIELD': 'IdG',
            'FIELDS_TO_COPY': [''],
            'FIELD_2': 'IdG',
            'INPUT': outputs['RenameFieldGrid']['OUTPUT'],
            'INPUT_2': outputs['FieldCalculatorDataaw']['OUTPUT'],
            'METHOD': 1,  # Take attributes of the first matching feature only (one-to-one)
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByFieldValue'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Retain fields
        alg_params = {
            'FIELDS': ['IdG','DataAW'],
            'INPUT': outputs['JoinAttributesByFieldValue']['OUTPUT'],
            'OUTPUT': parameters['SaveFile']
        }
        outputs['RetainFields'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['SaveFile'] = outputs['RetainFields']['OUTPUT']
        return results
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'icon.png')))
        return icon
    def name(self):
        return 'DataAW'

    def displayName(self):
        return 'DataAW'

    def group(self):
        return 'DataAW'

    def groupId(self):
        return 'DataAW'

    def createInstance(self):
        return DataAWAlgorithm()
