# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DasymetricV
                                 A QGIS plugin
 EO-based method for generating POP density grid map (reproducible for European cities)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-10
        copyright            : (C) 2021 by Mariella Aquilino
        email                : mariella.aquilino@poliba.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Mariella Aquilino'
__date__ = '2021-12-10'
__copyright__ = '(C) 2021 by Mariella Aquilino'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

#from qgis.PyQt.QtCore import QCoreApplication
#from qgis.core import (QgsProcessing,
 #                      QgsFeatureSink,
  #                     QgsProcessingAlgorithm,
   #                    QgsProcessingParameterFeatureSource,
    #                   QgsProcessingParameterFeatureSink,
     #                  QgsProcessing,
      #                 QgsProcessingMultiStepFeedback,
       #                QgsProcessingParameterRasterLayer,
        #               QgsProcessingParameterVectorLayer,
         #              QgsProcessingParameterFeatureSink)
import os, tempfile, shutil, errno
from qgis.core import *
import processing
from qgis.analysis import *
from processing.core.Processing import Processing
from qgis.PyQt.QtCore import QVariant,QSettings, QTranslator, qVersion, QCoreApplication

class DasymetricVAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('CENSUS', 'Pop_census (rename pop field "POP")', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('Builtup', 'Built-up', defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('HLIDAR', 'Building_heights',optional=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('UrbanAtlas', 'UrbanAtlas', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Output', 'OUTPUT', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True,  defaultValue=None))
        #self.addParameter(QgsProcessingParameterFeatureSink('Out1', 'out1', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        #self.addParameter(QgsProcessingParameterFeatureSink('Out3', 'out3', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        #self.addParameter(QgsProcessingParameterFeatureSink('Out2', 'out2', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))


    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        Processing.initialize()
        feedback = QgsProcessingMultiStepFeedback(20, model_feedback)
        results = {}
        outputs = {}
        

        # Riproietta layer
        alg_params = {
            'INPUT': parameters['CENSUS'],
            'OPERATION': '',
            'TARGET_CRS': parameters['UrbanAtlas'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RiproiettaLayer'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Estrai/ritaglia da estensione
        alg_params = {
            'CLIP': outputs['RiproiettaLayer']['OUTPUT'],
            'EXTENT': outputs['RiproiettaLayer']['OUTPUT'],
            'INPUT': parameters['UrbanAtlas'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstrairitagliaDaEstensione'] = processing.run('native:extractbyextent', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi_censusID
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'CENSUS_ID',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': ' $id ',
            'INPUT': outputs['RiproiettaLayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi_censusid'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
           return {}

        # Crea reticolo
        alg_params = {
            'CRS': parameters['UrbanAtlas'],
            'EXTENT': outputs['RiproiettaLayer']['OUTPUT'],
            'HOVERLAY': 0,
            'HSPACING': 100,
            'TYPE': 2,
            'VOVERLAY': 0,
            'VSPACING': 100,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CreaReticolo'] = processing.run('native:creategrid', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Crea indice spaziale_census
        alg_params = {
            'INPUT': outputs['CalcolatoreDiCampi_censusid']['OUTPUT']
        }
        outputs['CreaIndiceSpaziale_census'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Calcolatore campi_class
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'BUclass',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 2,
            'FORMULA': 'CASE \r\nWHEN \"code_2018\"=\'11100\' THEN \'Res\' \r\nWHEN \"code_2018\"=\'11210\' THEN \'Res\' \r\nWHEN \"code_2018\"=\'11220\' THEN \'Res\'    \r\nWHEN \"code_2018\"=\'11230\' THEN \'Res\' \r\nWHEN \"code_2018\"=\'11240\' THEN \'Res\'  \r\nWHEN \"code_2018\"=\'12100\' THEN \'IndCommLei\'\r\nWHEN \"code_2018\"=\'14100\' THEN \'IndCommLei\' \r\nWHEN \"code_2018\"=\'14200\' THEN \'IndCommLei\' \r\nWHEN \"code_2018\"=\'21000\' THEN \'Rural\' \r\nWHEN \"code_2018\"=\'22000\' THEN \'Rural\' \r\nWHEN \"code_2018\"=\'23000\' THEN \'Rural\' \r\nWHEN \"code_2018\"=\'24000\' THEN \'Rural\' \r\nWHEN \"code_2018\"=\'32000\' THEN \'Rural\' \r\nWHEN \"code_2018\"=\'33000\' THEN \'Rural\'\r\nWHEN \"code_2018\"=\'12210\' THEN \'RoadsEt\'\r\nWHEN \"code_2018\"=\'12220\' THEN \'RoadsEt\'\r\nWHEN \"code_2018\"=\'12230\' THEN \'RoadsEt\'\r\nWHEN \"code_2018\"=\'12300\' THEN \'RoadsEt\'\r\nWHEN \"code_2018\"=\'12400\' THEN \'RoadsEt\'     \r\nELSE \'Other\'\r\nEND',
            'INPUT': outputs['EstrairitagliaDaEstensione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreCampi_class'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}


        # Calcolatore di campi_Factor
        alg_params = {
            'FIELD_LENGTH': 2,
            'FIELD_NAME': 'Factor',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': 'CASE \r\nWHEN \"BUclass\"=\'Res\' THEN 1 \r\nWHEN \"BUclass\"=\'IndCommLei\' THEN 0.1 \r\nWHEN \"BUclass\"=\'Rural\' THEN 0.7    \r\nWHEN \"BUclass\"=\'RoadsEt\' THEN 0.0   \r\nELSE 0.01\r\nEND',
            'INPUT': outputs['CalcolatoreCampi_class']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi_factor'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Crea indice spaziale_grid
        alg_params = {
            'INPUT': outputs['CreaReticolo']['OUTPUT']
        }
        outputs['CreaIndiceSpaziale_grid'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Int1
        alg_params = {
            'INPUT': outputs['CreaIndiceSpaziale_census']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['CalcolatoreDiCampi_factor']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Int1'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Int2
        alg_params = {
            'INPUT': outputs['CreaReticolo']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['Int1']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Int2'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}
        #print(str(parameters['HLIDAR']))
        
        ##create temporary file
        # Processing.initialize()
        #tempdir1 = tempfile.mkdtemp()
        try:
            with tempfile.TemporaryDirectory() as tempdir1:
                # Save vector features to file
                alg_params = {
                'DATASOURCE_OPTIONS': '',
                'INPUT': outputs['Int2']['OUTPUT'],
                'LAYER_NAME': '',
                'LAYER_OPTIONS': '',
                'OUTPUT':tempdir1+'\\outint'+'.shp'
                }
                outputs['SaveVectorFeaturesToFile'] = processing.run('native:savefeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                feedback.setCurrentStep(11)
                if feedback.isCanceled():
                   return {}                
                alg_params = {
                'CRS': QgsCoordinateReferenceSystem('EPSG:3035'),
                'INPUT': tempdir1+'\\outint'+'.shp',
                'OUTPUT': tempdir1+'\\outint2'+'.shp'
                }
                outputs['AssignProjection'] = processing.run('native:assignprojection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                feedback.setCurrentStep(12)
                if feedback.isCanceled():
                   return {}                 
                # Statistiche zonali BUcount
                alg_params = {
                'COLUMN_PREFIX': '_',
                'INPUT_RASTER': parameters['Builtup'],
                'INPUT_VECTOR': tempdir1+'\\outint2'+'.shp',#outputs['Int2']['OUTPUT'],
                'RASTER_BAND': 1,
                'STATISTICS': [0]
                }
                outputs['StatisticheZonaliBucount'] = processing.run('native:zonalstatistics', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                
                feedback.setCurrentStep(13)
                if feedback.isCanceled():
                   return {}
                #Prov1=tempdir1+'\\out1'+'.shp'      
                #print(tempdir1.name)#Prov1=str(tempdir1.name)+'\\out1'+'.shp'
                if str(parameters['HLIDAR'])=='None':
                    print ("WARNING: Building heights layer failed to load!")
                    #Processing.initialize()
                    alg_params = {
                    'COLUMN_PREFIX': 'prr',
                    'INPUT_RASTER': parameters['Builtup'],
                    #'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:3035')
                    'INPUT_VECTOR': outputs['StatisticheZonaliBucount']['INPUT_VECTOR'],#outputs['Int2']['OUTPUT']
                    'RASTER_BAND': 1,
                    'STATISTICS': [2]
                    }                 
                    outputs['StatisticheZonaliBumean'] = processing.run('native:zonalstatistics', alg_params,context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(14)
                    if feedback.isCanceled():
                        return {}
                    # Calcolatore campo Voladj
                    #Processing.initialize()
                    alg_params = {
                    'FIELD_LENGTH': 10,
                    'FIELD_NAME': 'VOL_subel',
                    'FIELD_PRECISION': 2,
                    'FIELD_TYPE': 0,
                    'FORMULA': '\"Factor\"*\"_count\"*100',
                    'INPUT': outputs['StatisticheZonaliBumean']['INPUT_VECTOR'],#outputs['Int2']['OUTPUT'],
                    'OUTPUT':  tempdir1+'\\out1'+'.shp'}
                    outputs['CalcolatoreCampoVoladj'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                    feedback.setCurrentStep(15)
                    if feedback.isCanceled():
                        return {}
                else:
                 # Statistiche zonali Hmean ##PASSAGGIO OPZIONALE CHE SI PUO ATTUARE SOLO IN PRESENZA DI DATI SULLE ALTEZZE
                    #Processing.initialize()
                    alg_params = {
                    'COLUMN_PREFIX': 'Hint_',
                    'INPUT_RASTER': parameters['HLIDAR'],
                    'INPUT_VECTOR': outputs['StatisticheZonaliBucount']['INPUT_VECTOR'],#outputs['Int2']['OUTPUT'], #outputs['StatisticheZonaliBucount']['INPUT_VECTOR'],#
                    'RASTER_BAND': 1,
                    'STATISTICS': [2],
                    'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT                    
                    }
                    outputs['StatisticheZonaliHmean'] = processing.run('native:zonalstatistics', alg_params,context=context, feedback=feedback, is_child_algorithm=True)
            
                    feedback.setCurrentStep(14)
                    if feedback.isCanceled():
                        return {}
                 # Calcolatore campo Voladj
                    #Processing.initialize()
                    alg_params = {
                    'FIELD_LENGTH': 10,
                    'FIELD_NAME': 'VOL_subel',
                    'FIELD_PRECISION': 2,
                    'FIELD_TYPE': 0,
                    'FORMULA': '\"Factor\"*\"_count\"*100*\"Hint_mean\"',
                    'INPUT':  outputs['StatisticheZonaliHmean']['INPUT_VECTOR'],#outputs['Int2']['OUTPUT'],
                    'OUTPUT': tempdir1+'\\out1'+'.shp'}

                    outputs['CalcolatoreCampoVoladj'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                    feedback.setCurrentStep(15)
                    if feedback.isCanceled():
                        return {}


                 # Dissolvi
                alg_params = {
                'COMPUTE_AREA': False,
                'COMPUTE_STATISTICS': True,
                'COUNT_FEATURES': False,
                'EXPLODE_COLLECTIONS': False,
                'FIELD': 'CENSUS_ID',
                'GEOMETRY': 'geometry',
                'INPUT': outputs['CalcolatoreCampoVoladj']['OUTPUT'],
                #'INPUT': out1,
                'KEEP_ATTRIBUTES': False,
                'OPTIONS': '',
                'STATISTICS_ATTRIBUTE': 'Vol_subel',
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}
                outputs['Dissolvi'] = processing.run('gdal:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                feedback.setCurrentStep(16)
                if feedback.isCanceled():
                    return {}
            
                Prov2=tempdir1+'\\out2'+'.shp'
             # Unisci attributi secondo il valore del campo
                alg_params = {
                'DISCARD_NONMATCHING': False,
                'FIELD': 'CENSUS_ID',
                'FIELDS_TO_COPY': ['sum'],
                'FIELD_2': 'CENSUS_ID',
                'INPUT': outputs['CalcolatoreCampoVoladj']['OUTPUT'],
                'INPUT_2': outputs['Dissolvi']['OUTPUT'],
                'METHOD': 1,
                'PREFIX': 'Vol_subel',
                #'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT
                'OUTPUT': Prov2}
                outputs['UnisciAttributiSecondoIlValoreDelCampo'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                #results['Out2'] = outputs['UnisciAttributiSecondoIlValoreDelCampo']['OUTPUT']

                feedback.setCurrentStep(17)
                if feedback.isCanceled():
                    return {}

                #Out2 = QgsVectorLayer(QgsProcessing.TEMPORARY_OUTPUT,"out2","ogr")
                    #if not Out2.isValid():
                # print ("out2 failed to load!")
                Prov3=tempdir1+'\\out3'+'.shp'
                # Calcolatore di campiPOPw
                alg_params = {
                'FIELD_LENGTH': 10,
                'FIELD_NAME': 'POPw',
                'FIELD_PRECISION': 2,
                'FIELD_TYPE': 0,
                'FORMULA': ' (  \"POP\"  *  \"VOL_subel\"  )  /  \"Vol_subels\" ',
                'INPUT': outputs['UnisciAttributiSecondoIlValoreDelCampo']['OUTPUT'],
                #'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT
                #'OUTPUT': parameters['Out3']
                'OUTPUT': Prov3}
                outputs['CalcolatoreDiCampipopw'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                #results['Out3'] = outputs['CalcolatoreDiCampipopw']['OUTPUT']

                feedback.setCurrentStep(18)
                if feedback.isCanceled():
                    return {}



                # Dissolvi2
                alg_params = {
                'COMPUTE_AREA': False,
                'COMPUTE_STATISTICS': True,
                'COUNT_FEATURES': False,
                'EXPLODE_COLLECTIONS': False,
                'FIELD': 'id',
                'GEOMETRY': 'geometry',
                #'INPUT':Out3,
                'INPUT': Prov3,#outputs['CalcolatoreDiCampipopw']['OUTPUT'],
                'KEEP_ATTRIBUTES': False,
                'OPTIONS': '',
                'STATISTICS_ATTRIBUTE': 'POPw',
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}
                outputs['Dissolvi2'] = processing.run('gdal:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                feedback.setCurrentStep(19)
                if feedback.isCanceled():
                    return {}
                       
        
                # Calcolatore di campi_finale
                alg_params = {
                'FIELD_LENGTH': 10,
                'FIELD_NAME': 'POPgrid',
                'FIELD_PRECISION': 3,
                'FIELD_TYPE': 0,
                'FORMULA': 'to_real(\"sum\")',
                'INPUT': outputs['Dissolvi2']['OUTPUT'],
                'OUTPUT': parameters['Output']}
                outputs['CalcolatoreDiCampi_finale'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                feedback.setCurrentStep(20)
                if feedback.isCanceled():
                    return {}
                results['Output'] = outputs['CalcolatoreDiCampi_finale']['OUTPUT']
        except:
            print('File error')
        return results

        # del(out1)
        # del(out2)
        # del(out3)
        


        
        # del tempdir1
        # try:
        #     yield tempdir1
        #     finally:
        #         shutil.rmtree(tempdir1)

        # shutil.rmtree(tempdir1.name)
        # os.rmdir(tempdir1.name)
        # try:
        #     shutil.rmtree(str(tempdir1.name))  # delete directory
        # except OSError as exc:
        #     if exc.errno != errno.ENOENT:  # ENOENT - no such file or directory
        #         raise  # re-raise exception
        # return results
        # os.remove(str(tempdir1.name)+'\\out1'+'.shp')
        # os.remove(str(tempdir1.name)+'\\out1'+'.dbf')
        # os.remove(str(tempdir1.name)+'\\out1'+'.shx')
        # os.remove(str(tempdir1.name)+'\\out1'+'.prj')
        # os.remove(str(tempdir1.name)+'\\out2'+'.shp')
        # os.remove(str(tempdir1.name)+'\\out2'+'.dbf')
        # os.remove(str(tempdir1.name)+'\\out2'+'.shx')
        # os.remove(str(tempdir1.name)+'\\out2'+'.prj')        
        # os.remove(str(tempdir1.name)+'\\out3'+'.shp')
        # os.remove(str(tempdir1.name)+'\\out3'+'.dbf')
        # os.remove(str(tempdir1.name)+'\\out3'+'.shx')
        # os.remove(str(tempdir1.name)+'\\out3'+'.prj')        
        # os.rmdir(tempdir1.name)

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Das2'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Interpolazione dati demografici'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return DasymetricVAlgorithm()