# -*- coding: utf-8 -*-

from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QStyle

from qgis.core import QgsApplication
import os

from .plugin_globals import PluginGlobals
from .singleton import Singleton


@Singleton
class PluginIcons:
    """ """

    def __init__(self):
        """ """

        # Folder icon
        QgsApplication.initQgis()
        style = QgsApplication.style()
        self.folder_icon = style.standardIcon(QStyle.SP_DirClosedIcon)

        warn_icon_path = os.path.join(
            PluginGlobals.instance().images_dir_path,
            PluginGlobals.instance().ICON_WARN_FILE_NAME,
        )
        self.warn_icon = QIcon(warn_icon_path)

        shape_icon_path = os.path.join(
            PluginGlobals.instance().images_dir_path,
            PluginGlobals.instance().ICON_SHAPE,
        )
        self.shape_icon = QIcon(shape_icon_path)

        add_icon_path = os.path.join(
            PluginGlobals.instance().images_dir_path,
            PluginGlobals.instance().ICON_ADD,
        )
        self.add_icon = QIcon(add_icon_path)

        csv_icon_path = os.path.join(
            PluginGlobals.instance().images_dir_path,
            "csv_icon.png",
        )
        self.csv_icon = QIcon(csv_icon_path)

        json_icon_path = os.path.join(
            PluginGlobals.instance().images_dir_path,
            "json_icon.png",
        )
        self.json_icon = QIcon(json_icon_path)

        geojson_icon_path = os.path.join(
            PluginGlobals.instance().images_dir_path,
            "geojson_icon.png",
        )
        self.geojson_icon = QIcon(geojson_icon_path)
