# Author : MSE @ BPM-Conseil
# Coding template from DataGrandEst plugin
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import (
    QWidget,
    QDockWidget,
    QVBoxLayout,
    QLineEdit,
    QComboBox,
    QMessageBox,
)
from qgis.utils import iface
from .tree_widget import TreeWidget

class D4CDockWidget(QDockWidget):
    """Class for the D4C Dock Widget."""
    def __init__(self, parent=None):
        """ """
        super(D4CDockWidget, self).__init__()
        objectName = "SimpleAccessDock"
        self.init_gui()

    def init_gui(self):
        """ """
        self.setWindowTitle(u"Data4Citizen")
        self.setAllowedAreas(Qt.LeftDockWidgetArea | Qt.RightDockWidgetArea)

        self.treeWidget = TreeWidget()

        self.layout = QVBoxLayout()
        self.layout.setSpacing(2)
        self.layout.setMargin(0)
        self.layout.addWidget(self.treeWidget)

        self.D4CDockWidgetContents = QWidget()
        self.D4CDockWidgetContents.setLayout(self.layout)
        self.setWidget(self.D4CDockWidgetContents)

    def set_tree_content(self, resources_tree):
        """
        Creates the items of the tree widget
        """
        self.treeWidget.set_tree_content(resources_tree)
        self.update_visibility_of_tree_items()

    def update_visibility_of_tree_items(self):
        """
        Update the visibility of tree items:
        - visibility of empty groups
        - visibility of items with status = warn
        """
        self.treeWidget.update_visibility_of_tree_items()

    def dockStateChanged(self, floating):
        """ """
        if floating:
            self.resize(300, 450)
        else:
            pass
