# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'd4c_api_dialog_showsites.ui'
#
# Created by: PyQt5 UI code generator 5.15.9
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from PyQt5 import QtCore, QtGui, QtWidgets
from .d4c_api_dialog_editsites import Ui_EditSites
from PyQt5.QtWidgets import QMessageBox
import os
import json
from cryptography.fernet import Fernet


class Ui_ShowSites(object):

    def __init__(self):

        self.fernet = None
        self.plugin_dir = os.path.dirname(__file__)

    def setupUi(self, ShowSites):
        ShowSites.setObjectName("ShowSites")
        ShowSites.resize(421, 260)
        self.listWidget = QtWidgets.QListWidget(ShowSites)
        self.listWidget.setGeometry(QtCore.QRect(20, 20, 256, 192))
        self.listWidget.setObjectName("listWidget")
        self.pushButton = QtWidgets.QPushButton(ShowSites)
        self.pushButton.setGeometry(QtCore.QRect(310, 30, 91, 31))
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(os.path.join(self.plugin_dir, 'img', 'add_icon.png')), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton.setIcon(icon)
        self.pushButton.setObjectName("pushButton")
        self.pushButton_2 = QtWidgets.QPushButton(ShowSites)
        self.pushButton_2.setGeometry(QtCore.QRect(310, 140, 91, 31))
        icon1 = QtGui.QIcon()
        icon1.addPixmap(QtGui.QPixmap(os.path.join(self.plugin_dir, 'img', 'update_icon.png')), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_2.setIcon(icon1)
        self.pushButton_2.setObjectName("pushButton_2")
        self.pushButton_3 = QtWidgets.QPushButton(ShowSites)
        self.pushButton_3.setGeometry(QtCore.QRect(310, 180, 91, 31))
        icon2 = QtGui.QIcon()
        icon2.addPixmap(QtGui.QPixmap(os.path.join(self.plugin_dir, 'img', 'delete_icon.png')), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_3.setIcon(icon2)
        self.pushButton_3.setObjectName("pushButton_3")
        self.pushClose = QtWidgets.QPushButton(ShowSites)
        self.pushClose.setGeometry(QtCore.QRect(330, 230, 75, 23))
        self.pushClose.setObjectName("pushClose")
        self.pushDuplicate = QtWidgets.QPushButton(ShowSites)
        self.pushDuplicate.setGeometry(QtCore.QRect(310, 100, 91, 31))
        self.pushDuplicate.setObjectName("pushDuplicate")

        self.pushButton.clicked.connect(self.openAddSite)
        self.pushButton_2.clicked.connect(self.openAddSite_forUpdate)
        self.pushButton_3.clicked.connect(self.deleteSite)
        self.pushDuplicate.clicked.connect(self.duplicateSite)
        self.read()
        self.retranslateUi(ShowSites)
        QtCore.QMetaObject.connectSlotsByName(ShowSites)

    def retranslateUi(self, ShowSites):
        _translate = QtCore.QCoreApplication.translate
        ShowSites.setWindowTitle(_translate("ShowSites", "Mes Sites"))
        self.pushButton.setText(_translate("ShowSites", "Ajouter"))
        self.pushButton_2.setText(_translate("ShowSites", "Modifier"))
        self.pushButton_3.setText(_translate("ShowSites", "Supprimer"))
        self.pushClose.setText(_translate("ShowSites", "Fermer"))
        self.pushDuplicate.setText(_translate("ShowSites", "Dupliquer"))
        

    def read(self):
        with open(self.plugin_dir + '/help/source/_static/const/temp/k_e_y_p_w_d.txt', 'rb') as file:
            for line in file:
                key = line
            
        self.fernet = Fernet(key[2:-1])


    def openAddSite(self):
        self.windowEdit = QtWidgets.QDialog()
        self.uiEdit = Ui_EditSites()
        self.uiEdit.setupUi(self.windowEdit)

        self.uiEdit.edit_sites.siteEntered.connect(self.addNewSite)
        self.windowEdit.exec_()

    def addNewSite(self, siteUrl, siteName, user, pwd):
        site_url = siteUrl.lower()
        name = siteName
        username = user
        password = pwd
        if password == '':
            encrypted_password = ''
        else:
            encrypted_password = self.fernet.encrypt(password.encode())
         # Set up the destination folder
        if not os.path.exists(os.path.expanduser("~") + '/.d4cplugin/'):
            os.makedirs(os.path.expanduser("~") + '/.d4cplugin/')

        sites_file_path = os.path.join(os.path.expanduser("~"), '.d4cplugin', 'sites.json')

        if os.path.exists(sites_file_path):
            # Charger les données JSON existantes
            with open(sites_file_path, 'r') as json_file:
                site_data = json.load(json_file)
        else:
            site_data = {
                "saved_sites": {
                    "sites": []
                }
            }

        # Vérifier si la nouvelle entrée est identique à une entrée existante
        for site_info in site_data["saved_sites"]["sites"]:
            if site_info.get("site_url") == site_url and site_info.get("username") == username:
                # Si l'entrée est identique, ne la sauvegarde pas à nouveau
                self.show_info_message('Ce site est déjà enregistré, veuillez recommencer')
                return

        # Ajouter la nouvelle entrée aux données
        new_site_info = {
            "site_url": site_url,
            "name" : name,
            "username": username,
            "password": str(encrypted_password),  # N'oubliez pas de chiffrer le mot de passe
        }
        site_data["saved_sites"]["sites"].append(new_site_info)

        # Enregistrer les données mises à jour dans le fichier sites.json
        with open(sites_file_path, 'w') as json_file:
            json.dump(site_data, json_file, indent=4)

        self.windowEdit.close()
        self.updateList()


    def updateList(self):
        self.listWidget.clear()
        sites_file_path = os.path.join(os.path.expanduser("~"), '.d4cplugin', 'sites.json')

        if os.path.exists(sites_file_path):
            with open(sites_file_path, 'r') as json_file:
                data = json.load(json_file)
                for sites in data['saved_sites']['sites']:
                    if sites['name'] == '':
                        self.listWidget.addItem(sites['site_url'] + ' - ' + sites['username'])
                    else:
                        self.listWidget.addItem(sites['name'])
    

    def deleteSite(self):
        siteNb = self.listWidget.currentRow()
        if siteNb == -1:
            return
        site = self.listWidget.currentItem().text()
        # Créez une boîte de dialogue de confirmation
        confirmation = QMessageBox()
        confirmation.setIcon(QMessageBox.Question)
        confirmation.setWindowTitle("Confirmation")
        confirmation.setText(f"Etes vous sûr de vouloir supprimer {site}?")

        # Ajoutez les boutons "Continuer" et "Annuler"
        confirmation.addButton(QMessageBox.Ok)
        confirmation.addButton(QMessageBox.Cancel)

        # Affichez la boîte de dialogue et attendez la réponse de l'utilisateur
        response = confirmation.exec_()

        # Vérifiez la réponse de l'utilisateur
        if response != QMessageBox.Ok:
            return
        
        
        

        sites_file_path = os.path.join(os.path.expanduser("~"), '.d4cplugin', 'sites.json')
        if os.path.exists(sites_file_path):
            with open(sites_file_path, 'r') as json_file:
                data = json.load(json_file)
            
            if siteNb < len(data['saved_sites']['sites']):
                data['saved_sites']['sites'].pop(siteNb)
            
            with open(sites_file_path, 'w') as json_file:
                json.dump(data, json_file, indent=4)
        
        self.updateList()


    def updateSite(self, siteUrl, siteName, user, pwd):

        siteUrl = siteUrl.lower()
        siteNb = self.listWidget.currentRow()

        if siteNb == -1:
            return
        
        sites_file_path = os.path.join(os.path.expanduser("~"), '.d4cplugin', 'sites.json')
        if os.path.exists(sites_file_path):
            with open(sites_file_path, 'r') as json_file:
                data = json.load(json_file)
            
            
            # Vérifier si la nouvelle entrée est identique à une entrée existante
            for site_info in data["saved_sites"]["sites"]:
                if site_info.get("password") != '':
                    mdp = self.fernet.decrypt(site_info.get("password")[1:-1])
                    mdp = mdp.decode('utf-8')
                else:
                    mdp = ''
                
                if site_info.get("site_url") == siteUrl and site_info.get("username") == user and site_info.get("name") == siteName and mdp == pwd:
                # Si l'entrée est identique, ne la sauvegarde pas à nouveau
                    self.show_info_message('Ce site est déjà enregistré, veuillez recommencer')
                    return
                
            data['saved_sites']['sites'][siteNb]['site_url'] = siteUrl
            data['saved_sites']['sites'][siteNb]['name'] = siteName
            data['saved_sites']['sites'][siteNb]['username'] = user
            data['saved_sites']['sites'][siteNb]['password'] = str(self.fernet.encrypt(pwd.encode()))

            with open(sites_file_path, 'w') as json_file:
                json.dump(data, json_file, indent=4)
        
        self.windowEdit2.close()
        self.updateList()


    def openAddSite_forUpdate(self):
            
            siteNb = self.listWidget.currentRow()

            if siteNb == -1:
                return

            sites_file_path = os.path.join(os.path.expanduser("~"), '.d4cplugin', 'sites.json')
            if os.path.exists(sites_file_path):
                with open(sites_file_path, 'r') as json_file:
                    data = json.load(json_file)
            
            site = data['saved_sites']['sites'][siteNb]['site_url']
            name = data['saved_sites']['sites'][siteNb]['name']
            username = data['saved_sites']['sites'][siteNb]['username']
            password = data['saved_sites']['sites'][siteNb]['password']
            
            if password == '':
                password = ''
            else:

                mdp = self.fernet.decrypt(password[1:-1])
                mdp = mdp.decode('utf-8')
                password = mdp

            self.windowEdit2 = QtWidgets.QDialog()
            self.uiEdit2 = Ui_EditSites()
            self.uiEdit2.setupUi(self.windowEdit2)
            self.uiEdit2.siteUrl.setText(site)
            self.uiEdit2.user_2.setText(name)
            self.uiEdit2.user.setText(username)
            self.uiEdit2.password.setText(password)
            self.uiEdit2.edit_sites.siteEntered.connect(self.updateSite)
            self.windowEdit2.exec_()
            

    def show_info_message(self, message):
        info_box = QMessageBox()
        info_box.setIcon(QMessageBox.Information)
        info_box.setWindowTitle('Information')
        info_box.setText(message)
        info_box.exec_()


    def duplicateSite(self):
        siteNb = self.listWidget.currentRow()

        if siteNb == -1:
            return
        

        sites_file_path = os.path.join(os.path.expanduser("~"), '.d4cplugin', 'sites.json')

        if os.path.exists(sites_file_path):
            # Charger les données JSON existantes
            with open(sites_file_path, 'r') as json_file:
                site_data = json.load(json_file)


            # Ajouter la nouvelle entrée aux données
            new_site_info = {
                "site_url": site_data["saved_sites"]["sites"][siteNb]["site_url"],
                "name" : site_data["saved_sites"]["sites"][siteNb]["name"] + " - copie",
                "username": site_data["saved_sites"]["sites"][siteNb]["username"],
                "password": site_data["saved_sites"]["sites"][siteNb]["password"],  # N'oubliez pas de chiffrer le mot de passe
            }
            site_data["saved_sites"]["sites"].append(new_site_info)

            # Enregistrer les données mises à jour dans le fichier sites.json
            with open(sites_file_path, 'w') as json_file:
                json.dump(site_data, json_file, indent=4)
        
        self.updateList()