# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Data4Citizen API
                                 A QGIS plugin
 Using Data4Citizen api to manipulate ckan data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-09-29
        git sha              : $Format:%H$
        copyright            : (C) 2024 by MSE @ BPM-conseil
        email                : matthieu.serek@bpm-conseil.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QTranslator, QCoreApplication, Qt, QLocale , QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QApplication, QStyle, QMainWindow
from qgis.core import QgsVectorLayer, QgsMapLayer, QgsField, QgsFields, QgsGeometry, QgsFeature, QgsProject, QgsWkbTypes, QgsApplication, QgsVectorFileWriter
from qgis.analysis import QgsNativeAlgorithms
from processing.core.Processing import Processing

from PyQt5 import QtWidgets, QtGui, QtCore
import csv

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .d4c_api_dialog import d4cAPIDialog
from .d4c_api_dialog_logins import Ui_LoginsWindow
from .d4c_api_dialog_export import Ui_d4cAPIDialogExport
from .d4c_api_dialog_add_dataset import Ui_Dialog
from .d4c_api_dialog_plugininfos import Ui_pluginInfos
from .d4c_api_dialog_infos import Ui_showInfos
from .d4c_api_dialog_searchdataset import Ui_searchDataset
from .d4c_api_dialog_params import Ui_Params
from .d4c_api_dialog_changemetadatas import Ui_changeMetadatas
from .d4c_api_dialog_multiple_import import Ui_DialogImport
from .d4c_api_dialog_geoparams import Ui_GeoParams
from .d4c_api_dialog_deletegeoparam import Ui_DeleteGeoParam

from .d4c_api_dock import D4CDockWidget
from .nodes.tree_node_factory import TreeNodeFactory
from .utils.plugin_globals import PluginGlobals
from .utils.d4c_provider import d4cProvider

import os
import pathlib
import requests
import json
import subprocess
import shutil
## Import de Cryptography, si non installé, l'installe
import importlib

try:
    importlib.import_module('cryptography')
except ImportError:
    import subprocess
    subprocess.check_call(['python', '-m', 'pip', 'install', '--upgrade', 'pip'])
    subprocess.check_call(['python', '-m', 'pip', 'install', 'cryptography'])

from cryptography.fernet import Fernet

# Classe pour la fenêtre de prévisualisation
class TableWindow(QMainWindow):
    def __init__(self, parent=None):
        super(TableWindow, self).__init__(parent)
        self.setWindowTitle("Tableau")
        self.setGeometry(300, 300, 500, 400)

        self.table = QtWidgets.QTableWidget(self)
        self.setCentralWidget(self.table)

        
# Classe principale du plugin
class d4cAPI:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = pathlib.Path(__file__).resolve().parent
        # initialize locale
        self.translator = QTranslator()
        self.lang = None
        self.saveFile_folder = None
        # Set up the destination folder
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin'):
            os.makedirs(pathlib.Path.home() / '.d4cplugin')
        
        # Chargez les sessions existantes depuis le fichier JSON
        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'

        # rename file logs.json to history.json
        if pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' / 'logs.json'):
            os.rename(pathlib.Path.home() / '.d4cplugin' / 'logs.json', pathlib.Path.home() / '.d4cplugin' / 'history.json')
            # json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'

        if not pathlib.Path.exists(self.plugin_dir / 'resources'):
            os.makedirs(self.plugin_dir / 'resources')
        
        if not(pathlib.Path.exists(json_file_path)):
            data = {
                "last_session": {
                    "sessions": []
                },
                "lang": "fr",
                "folder_path" : str(self.plugin_dir / 'resources')
            }
            # Enregistrez les données mises à jour dans le fichier JSON
            # type windowpath into string to avoid error
            with open(str(json_file_path), 'w') as json_file:
                json.dump(data, json_file, indent=4)
            self.lang = 'fr'
            self.saveFile_folder = str(self.plugin_dir / 'resources')
        else:
            with open(str(json_file_path), 'r') as json_file:
                data = json.load(json_file)
                self.lang = data['lang']
                self.saveFile_folder = data['folder_path']

        # Déplacer les fichiers enums
        if pathlib.Path.exists(self.plugin_dir / 'enums_geo.txt'):
            if not(pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' / 'enums_geo.txt')):
                shutil.move(self.plugin_dir / 'enums_geo.txt', pathlib.Path.home() / '.d4cplugin')
            else:
                os.remove(self.plugin_dir / 'enums_geo.txt')

        if pathlib.Path.exists(self.plugin_dir / 'enums_tuple_geo.txt'):
            if not(pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' / 'enums_tuple_geo.txt')):
                shutil.move(self.plugin_dir / 'enums_tuple_geo.txt', pathlib.Path.home() / '.d4cplugin')
            else:
                os.remove(self.plugin_dir / 'enums_tuple_geo.txt')

        if pathlib.Path.exists(self.plugin_dir / 'enums_cache_jdd.txt'):
            if not(pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' / 'enums_cache_jdd.txt')):
                shutil.move(self.plugin_dir / 'enums_cache_jdd.txt', pathlib.Path.home() / '.d4cplugin')
            else:
                os.remove(self.plugin_dir / 'enums_cache_jdd.txt')
           
        
        self.loadTranslation(self.lang)  # Charge la traduction française par défaut
        if self.lang == 'fr':
            self.locale = QLocale(QLocale.French, QLocale.France)
        else:
            self.locale = QLocale(QLocale.English, QLocale.UnitedKingdom)
        QLocale.setDefault(self.locale)
        

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Data4Citizen Plugin')
        # Read the resources tree file and update the GUI
        PluginGlobals.instance().set_plugin_path(str(self.plugin_dir))
        PluginGlobals.instance().set_plugin_iface(self.iface)
        PluginGlobals.instance().reload_globals_from_qgis_settings()
        
        # create the config file
        self.createConfigFile()


        self.ressources_tree = TreeNodeFactory(
            PluginGlobals.instance().config_file_path
        ).root_node

        self.registry = QgsApplication.instance().dataItemProviderRegistry()
        self.provider = d4cProvider(self.iface)

        # Some Global variables

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.sit = None
        self.usr = None
        self.pwd = None
        self.ui = None # Logins window
        self.ui2 = None # Export window
        self.resourceDict = {} # Dictionnaire des ressources du jeu de données
        self.listExistingResourceById = {} 
        self.selectedDataId = None # Id du jeu de données sélectionné
        self.selectedDataOrg = None # Organisation du jeu de données sélectionné
        self.selectedDataPrivate = None # Private du jeu de données sélectionné
        self.csv_icon = None
        self.geojson_icon = None
        self.json_icon = None
        self.zip_icon = None
        self.key = None
        self.fernet = None
        self.isDelete = False # Variable pour savoir si on supprime une ressource ou un jeu de données
        self.currentDataset_id = None # Id du jeu de données courant
        self.isLoadedSite = False # Variable pour savoir si on a chargé un site

        # Informations du jeu de données
        self.data_title = None
        self.data_name = None
        self.data_author = None
        self.data_org = None
        self.data_license = None
        self.data_private = None
        self.data_url = None

        self.backofficeurl = None
        self.isAlldatasetsLoaded = False
        self.Alldatasetlist = [] # Liste des jeux de données

        self.tableWidget = None

        self.previousOpenDataResource = None

        self.layer1isSet = False
        self.layer2isSet = False

        self.opendatadict = {}

        self.post_ui_init()
        

    def post_ui_init(self):
        self.registry.addProvider(self.provider)
    
    def createConfigFile(self):
        configFilePath = PluginGlobals.instance().config_file_path
        resourceFilePath = self.plugin_dir / 'resources'
        historyFilePath = pathlib.Path.home() / '.d4cplugin' / 'history.json'
        if not pathlib.Path.exists(pathlib.Path(configFilePath)):
            data = {
                "title": "Data4Citizen - version du 1er juillet 2024",
                "description": "",
                "type": "folder",
                "children": [
                    {
                        "title": "Dernières ressources ajoutées",
                        "description": "Ressources ajoutées récemment",
                        "type": "folder",
                        "children": []
                    },
                    {
                        "title": "Derni\u00e8res connexions",
                        "description": "Derni\u00e8res connexions r\u00e9alis\u00e9es",
                        "type": "folder",
                        "children": []
                    }
                ]
            }
            with open(configFilePath, 'w') as config_file:
                json.dump(data, config_file, indent=4)
        with open(configFilePath, 'r') as config_file:
            config_data = json.load(config_file)
            config_data['children'][0]['children'] = []
        for file in pathlib.Path(resourceFilePath).iterdir():
            if file.is_file():
                data = {
                    "title": file.name,
                    "description": "",
                    "type": "file",
                    "metadata_url": "",
                    "params": {
                        "uri": str(file),
                        "name": file.name,
                        "format" : file.suffix.replace('.',''),
                        "srs" : "EPSG:4326"
                    }

                }
                
                config_data['children'][0]['children'].append(data)
        
        
        with open(historyFilePath, 'r') as json_file:
            data = json.load(json_file)

        data_sessions_list = []    
        already_in = []


        for session in data['last_session']['sessions']:
            data_sessions = {
            "title": "",
            "description": "",
            "type": "folder",
            "children": []
            }
            if session["site_url"] not in already_in:
                already_in.append(session["site_url"])
                data_sessions['title'] = session["site_url"].replace('https://','').replace('.data4citizen.com','')
                data_sessions['description'] = session["site_url"]
                datachild = { 
                    "title": session["datasets"],
                    "description": session["datasets"],
                    "type": "dataset",
                    "metadata_url": "",
                    "params": {
                        "uri": session["site_url"],
                        "name": session["datasets"],
                        "format" : "",
                        "srs" : "EPSG:4326"
                    }
                }
                data_sessions['children'].append(datachild)
                data_sessions_list.append(data_sessions)
            else:
                datachild = { 
                    "title": session["datasets"],
                    "description": session["datasets"],
                    "type": "dataset",
                    "metadata_url": "",
                    "params": {
                        "uri": session["site_url"],
                        "name": session["datasets"],
                        "format" : "",
                        "srs" : "EPSG:4326"
                    }
                }
                for data_session in data_sessions_list:
                    if data_session['title'] == session["site_url"].replace('https://','').replace('.data4citizen.com',''):
                        data_session['children'].append(datachild)
        
        config_data['children'][1]['children'] = data_sessions_list
        with open(configFilePath, 'w') as config_file:
            json.dump(config_data, config_file, indent=4)

    def updateConfigFile(self):
        self.createConfigFile()
        self.ressources_tree = TreeNodeFactory(
            PluginGlobals.instance().config_file_path
        ).root_node
        self.dock.set_tree_content(self.ressources_tree)
    
    def reloadBrowser(self):
        self.registry.removeProvider(self.provider)
        self.registry = QgsApplication.instance().dataItemProviderRegistry()
        self.provider = d4cProvider(self.iface)
        self.registry.addProvider(self.provider)


    def loadTranslation(self, locale):
        locale_path = self.plugin_dir / 'i18n' / f'd4c_api_{locale}.qm'

        if pathlib.Path.exists(locale_path):
            self.translator.load(str(locale_path))
            QCoreApplication.installTranslator(self.translator)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('d4cAPI', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        whats_this = self.tr(u'Test')
        status_tip = self.tr(u'Test')

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

        

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/d4c_api/icon.png'
        param_path = ':/plugins/d4c_api/param_icon.png' 
        self.add_action(
            icon_path,
            text=self.tr(u'Data4Citizen extension'),
            callback=self.run,
            status_tip=self.tr(u'Data4Citizen extension'),
            whats_this=self.tr(u'Data4Citizen extension'),
            parent=self.iface.mainWindow())
        self.iface.registerMainWindowAction(self.actions[-1], "this extension connects to a Data4Citizen/Ckan platform and allows to manipulate its datasets")
        
        # Ajouter une action de menu pour ouvrir la boîte de dialogue des paramètres
        self.add_action(
            param_path,
            text=self.tr(u'Configuration'),
            callback=self.open_settings_dialog,
            parent=self.iface.mainWindow()
        )
        
        # Add the plugin dock widget
        self.dock = D4CDockWidget()
        self.dock.set_tree_content(self.ressources_tree)
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dock)
        
        # will be set False in run()
        self.first_start = True
    
    # Ouvre la fenêtre de paramètres
    def open_settings_dialog(self):
        self.windowParams = QtWidgets.QDialog()
        self.uiParams = Ui_Params()
        self.uiParams.setupUi(self.windowParams)
        
        france_icon_path = str(self.plugin_dir / 'img' / 'france_icon.png')
        uk_icon_path = str(self.plugin_dir / 'img' / 'uk_icon.png' )

        france_icon = QIcon(france_icon_path)
        uk_icon = QIcon(uk_icon_path)

        self.uiParams.languageBox.addItem(france_icon, '')
        self.uiParams.languageBox.addItem(uk_icon, '')
        
        json_file_path = pathlib.Path.home() /'.d4cplugin' / 'history.json'
        if pathlib.Path.exists(pathlib.Path.home() /'.d4cplugin' / 'logs.json'):
            os.rename(pathlib.Path.home() /'.d4cplugin' / 'logs.json', json_file_path)
        
        if not(pathlib.Path.exists(json_file_path)):
            data = {
                "last_session": {
                    "sessions": []
                },
                "lang": "fr",
                "folder_path" : str(self.plugin_dir / 'resources')
            }
                    # Enregistrez les données mises à jour dans le fichier JSON
            with open(str(json_file_path), 'w') as json_file:
                json.dump(data, json_file, indent=4)
            resource_file_path = self.plugin_dir / 'resources'
        else :
            with open(str(json_file_path), 'r') as json_file:
                data = json.load(json_file)
                resource_file_path = data['folder_path']
                self.uiParams.lineEdit.setText(resource_file_path)
                if data['lang'] == 'fr':
                    self.uiParams.languageBox.setCurrentIndex(0)
                else:
                    self.uiParams.languageBox.setCurrentIndex(1)

        self.uiParams.pushCancel.clicked.connect(self.windowParams.close)
        self.uiParams.pushOk.clicked.connect(self.saveSettings)
        self.uiParams.pushBrowse.clicked.connect(self.openFolderDialog)

        
        self.windowParams.show()

    #Sauvegarde les paramètres
    def saveSettings(self):
        
        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'

        language_id = self.uiParams.languageBox.currentIndex()
        if language_id == 0:
            language = 'fr'
        elif language_id == 1:
            language = 'en'
        
        new_folder_path = pathlib.Path(self.uiParams.lineEdit.text())

        if new_folder_path != '':
            if not pathlib.Path.exists(new_folder_path):
                os.makedirs(new_folder_path)
            with open(str(json_file_path), 'r') as json_file:
                data = json.load(json_file)
                data['folder_path'] = str(new_folder_path)
                data['lang'] = language
            with open(str(json_file_path), 'w') as json_file:
                json.dump(data, json_file)
        
            QMessageBox.information(None, "Information", "Les paramètres ont été sauvegardés ! Veuillez redémarrer QGIS pour que les changements de langue soient pris en compte.")
            self.windowParams.close()
        else:
            QMessageBox.warning(None, "Attention", "Veuillez renseigner un chemin valide!")
    
    def openFolderDialog(self):
        folder_path = QtWidgets.QFileDialog.getExistingDirectory(None, "Selectionner un dossier", str(pathlib.Path.home()))
        self.uiParams.lineEdit.setText(folder_path)

        



    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.registry.removeProvider(self.provider)
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Data4Citizen Plugin'),
                action)
            self.iface.removeToolBarIcon(action)


    # Méthode principale du plugin
    def run(self):
        """Run method that performs all the real work"""
        destination_folder = str(pathlib.Path.home() / '.d4cplugin')  # Modifier le chemin selon vos besoins
        json_file_path = pathlib.Path.home() / '.d4cplugin'/ 'history.json'
        if not(pathlib.Path.exists(json_file_path)):
            data = {
                "last_session": {
                    "sessions": []
                },
                "lang": "fr"
            }
                    # Enregistrez les données mises à jour dans le fichier JSON
            with open(json_file_path, 'w') as json_file:
                json.dump(data, json_file, indent=4)
        csv.field_size_limit(1200000)
        if self.first_start:

            

            self.first_start = False
            self.dlg = d4cAPIDialog()
            self.setupIcons()
            self.disableButtons()
            self.disableSearchButtons()
            self.read()
            self.setupD4CcomboBox()
            self.dlg.searchOpenData.setHidden(True)
            
            # On connecte les boutons aux fonctions
            self.dlg.ExecUrlApi.clicked.connect(self.getD4Cdatasets)
            self.dlg.pushWindowlogin.clicked.connect(self.openLoginsWindow)
            self.dlg.pushImportresource.clicked.connect(self.importResource)
            self.dlg.resourcesList.itemDoubleClicked.connect(self.importResource)
            self.dlg.pushExportAsNewresource.clicked.connect(self.exportAsNewResource)
            self.dlg.pushEmptyCache.clicked.connect(self.emptyCache)
            self.dlg.pushRefresh.clicked.connect(self.showExportableLayers)
            self.dlg.pushExit.clicked.connect(self.closePlugin)
            self.dlg.pushExportAsExistingresource.clicked.connect(self.showExistingResources)
            self.dlg.pushHistory.clicked.connect(self.loadPreviousSession)
            self.dlg.historyList.itemDoubleClicked.connect(self.loadPreviousSession)
            self.dlg.pushNewdataset.clicked.connect(self.openAddDatasetWindow)
            self.dlg.pushDeleteResource.clicked.connect(self.deleteResource)
            self.dlg.pushDeletedataset.clicked.connect(self.deleteDataset)
            self.dlg.pushInfos.clicked.connect(self.showInfoWindow)
            self.dlg.pushOpenFiledirectory.clicked.connect(self.openResourceFile)
            self.dlg.pushLoadHistoryfile.clicked.connect(self.openResourcefromFile)
            self.dlg.filesList.itemDoubleClicked.connect(self.openResourcefromFile)
            self.dlg.pushChangedataset.clicked.connect(self.getD4Cdatasets)
            self.dlg.siteField.textChanged.connect(self.turnOffAllDatasetLoaded)
            self.dlg.pushDisplayAllDatasets.clicked.connect(self.openAllDatasets)
            self.dlg.historyList.itemSelectionChanged.connect(self.updateHistoryPush)
            self.dlg.filesList.itemSelectionChanged.connect(self.updateFilesPush)
            self.dlg.pushDisplayAllDatasets2.clicked.connect(self.openAllDatasets)
            self.dlg.checkPrevisu.stateChanged.connect(self.showPrevisu)
            self.dlg.resourcesList.itemSelectionChanged.connect(self.updatePrevisu)
            self.dlg.pushOpenTableWindow.clicked.connect(self.openTableWindow)
            self.dlg.pushAbout.clicked.connect(self.openAbout)
            self.dlg.pushHelp.clicked.connect(self.openHelp)
            self.dlg.clearHistory.clicked.connect(self.clearHistory)
            
            self.dlg.tabWidget.currentChanged.connect(self.updateManipulateCB)
            self.dlg.comboBoxLayer1F.currentIndexChanged.connect(self.addLayer1F)
            self.dlg.comboBoxLayer2F.currentIndexChanged.connect(self.addLayer2F)
            self.dlg.pushRefreshlastImport.clicked.connect(self.updateLastimportedfiles)
            self.dlg.pushAddLayerF.clicked.connect(self.addLayerFPlus)
            self.dlg.pushRemoveLayerF.clicked.connect(self.removeSelectedLayerF)
            self.dlg.pushCreateLayerF.clicked.connect(self.createLayerF)
            self.dlg.comboBoxOperation.currentIndexChanged.connect(self.displayCheckCentroid)
            self.dlg.pushSearchOpenData.clicked.connect(self.searchOpenDatas)
           
            self.dlg.pushImportOpenData.clicked.connect(self.downloadOpenDataResource)
            
            self.dlg.label_urlOpendata.setHidden(True)
            self.dlg.OpenDataURL.setHidden(True)
            self.dlg.radioDataGouvOrga.setHidden(True)
            self.dlg.radioDataGouvDataset.setHidden(True)
            self.dlg.D4CcomboBox.setHidden(True)
            self.dlg.radioDataGouv.clicked.connect(self.disableUrlField)
            self.dlg.radioD4C.clicked.connect(self.enableUrlField)
            self.dlg.radioODS.clicked.connect(self.enableUrlField)
            self.dlg.radioCKAN.clicked.connect(self.enableUrlField)
            self.dlg.radioDataGouvDataset.clicked.connect(self.radioLikeForGouvData)
            self.dlg.radioDataGouvOrga.clicked.connect(self.radioLikeForGouvOrga)
            self.dlg.checkPreviewOpenData.stateChanged.connect(self.showPreviewOpenData)
            self.dlg.listResourceOpenData.itemSelectionChanged.connect(self.updatePreviewOpenData)
            self.dlg.listOpenData.itemSelectionChanged.connect(self.displayOpenDataResources)
            self.dlg.searchOpenData.textChanged.connect(self.searchBarOpenData)

            self.dlg.pushSetGeoParams.clicked.connect(self.openGeoParams)
            self.dlg.pushSetGeoParams_2.clicked.connect(self.openGeoParams)
            self.dlg.pushSetGeoParams_3.clicked.connect(self.openGeoParams)
            # Changement des langues
            if self.lang == 'fr':
                self.dlg.languageBox.setCurrentIndex(0)
            else:
                self.dlg.languageBox.setCurrentIndex(1)
            self.dlg.languageBox.currentIndexChanged.connect(self.changeLanguage)
            self.updateLastimportedfiles()
            self.updateHistory()
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here
            pass

    def closePlugin(self):
        self.dlg.close()


    # Agrandir la fenêtre de prévisualisation
    def showPrevisu(self, state):
        if state == Qt.Checked:
            self.dlg.setMaximumSize(900,622)
            self.dlg.resize(900,622)
        else:
            self.dlg.setMaximumSize(627,622)
            self.dlg.resize(627,622)


    def disableButtons(self):
        self.dlg.pushImportresource.setEnabled(False)
        self.dlg.pushSetGeoParams.setEnabled(False)
        self.dlg.pushExportAsNewresource.setEnabled(False)
        self.dlg.pushExportAsExistingresource.setEnabled(False)
        self.dlg.pushDeleteResource.setEnabled(False)
        self.dlg.pushDeletedataset.setEnabled(False)
        self.dlg.pushInfos.setEnabled(False)
        self.dlg.checkPrevisu.setEnabled(False)


    def enableButtons(self):
        self.dlg.pushImportresource.setEnabled(True)
        self.dlg.pushExportAsNewresource.setEnabled(True)
        self.dlg.pushExportAsExistingresource.setEnabled(True)
        self.dlg.pushDeleteResource.setEnabled(True)
        self.dlg.pushDeletedataset.setEnabled(True)
        self.dlg.pushInfos.setEnabled(True)
        self.dlg.checkPrevisu.setEnabled(True)
        self.dlg.pushSetGeoParams.setEnabled(True)
        


    def disableSearchButtons(self):
        self.dlg.ExecUrlApi.setEnabled(False)
        self.dlg.pushNewdataset.setEnabled(False)
        self.dlg.datasetId.setEnabled(False)
        self.dlg.pushChangedataset.setEnabled(False)
        self.dlg.exportLine.setEnabled(False)
        self.dlg.pushDisplayAllDatasets.setEnabled(False)
        self.dlg.pushDisplayAllDatasets2.setEnabled(False)



    def enableSearchButtons(self):
        self.dlg.ExecUrlApi.setEnabled(True)
        self.dlg.pushNewdataset.setEnabled(True)
        self.dlg.datasetId.setEnabled(True)
        self.dlg.pushChangedataset.setEnabled(True)
        self.dlg.exportLine.setEnabled(True)
        self.dlg.pushDisplayAllDatasets.setEnabled(True)
        self.dlg.pushDisplayAllDatasets2.setEnabled(True)


    # Chargement des icones
    def setupIcons(self):
        
        # Icon Paths
        arrow_bottom_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'arrow_bottom.png')
        arrow_double_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'arrow_double.png')
        arrow_top_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'arrow_top.png')
        csv_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'csv_icon.png')
        geojson_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'geojson_icon.png')
        json_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'json_icon.png')
        refresh_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'refresh_icon.png')
        search_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'search_icon.png')
        zip_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'zip_icon.png')
        add_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'add_icon.png')
        delete_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'delete_icon.png')
        update_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'update_icon.png')
        info_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'info_icon.png')
        d4c_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'd4c_icon.png')
        question_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'question_icon.png')
        france_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'france_icon.png')
        uk_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'uk_icon.png')
        data_gouv_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'data_gouv_icon.png')
        ods_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'ods_icon.png')
        ckan_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'ckan_icon.png')
        geoloc_icon_path = str(pathlib.Path(self.plugin_dir) / 'img' / 'geoloc_icon.png')

        # Init Icons
        arrow_bottom = QIcon(arrow_bottom_icon_path)
        arrow_double = QIcon(arrow_double_icon_path)
        arrow_top = QIcon(arrow_top_icon_path)
        self.csv_icon = QIcon(csv_icon_path)
        self.geojson_icon = QIcon(geojson_icon_path)
        self.json_icon = QIcon(json_icon_path)
        refresh_icon = QIcon(refresh_icon_path)
        search_icon = QIcon(search_icon_path)
        self.zip_icon = QIcon(zip_icon_path)
        add_icon = QIcon(add_icon_path)
        delete_icon = QIcon(delete_icon_path)
        update_icon = QIcon(update_icon_path)
        info_icon = QIcon(info_icon_path)
        question_icon = QIcon(question_icon_path)
        france_icon = QIcon(france_icon_path)
        uk_icon = QIcon(uk_icon_path)
        data_gouv_icon = QIcon(data_gouv_icon_path)
        ods_icon = QIcon(ods_icon_path)
        ckan_icon = QIcon(ckan_icon_path)
        d4c_icon = QIcon(d4c_icon_path)
        geoloc_icon = QIcon(geoloc_icon_path)




        # Set Icons
        self.dlg.pushWindowlogin.setIcon(arrow_double)
        self.dlg.ExecUrlApi.setIcon(search_icon)
        self.dlg.pushImportresource.setIcon(arrow_bottom)
        self.dlg.pushRefresh.setIcon(refresh_icon)
        self.dlg.pushExportAsNewresource.setIcon(arrow_top)
        self.dlg.pushExportAsExistingresource.setIcon(arrow_top)
        self.dlg.pushExportAsNewresource.setIcon(add_icon)
        self.dlg.pushExportAsExistingresource.setIcon(update_icon)
        self.dlg.pushDeleteResource.setIcon(delete_icon)
        self.dlg.pushNewdataset.setIcon(add_icon)
        self.dlg.pushDeletedataset.setIcon(delete_icon)
        self.dlg.pushInfos.setIcon(info_icon)
        self.dlg.label_13.setPixmap(QtGui.QPixmap(d4c_icon_path))
        self.dlg.pushChangedataset.setIcon(arrow_double)
        self.dlg.pushAbout.setIcon(info_icon)
        self.dlg.pushHelp.setIcon(question_icon)
        self.dlg.languageBox.addItem(france_icon, '')
        self.dlg.languageBox.addItem(uk_icon, '')
        self.dlg.pushImportOpenData.setIcon(arrow_bottom)
        self.dlg.pushSearchOpenData.setIcon(search_icon)
        self.dlg.radioDataGouv.setIcon(data_gouv_icon)
        self.dlg.radioODS.setIcon(ods_icon)
        self.dlg.radioCKAN.setIcon(ckan_icon)
        self.dlg.radioD4C.setIcon(d4c_icon)
        self.dlg.pushSetGeoParams.setIcon(geoloc_icon)
        self.dlg.pushSetGeoParams_2.setIcon(geoloc_icon)
        self.dlg.pushSetGeoParams_3.setIcon(geoloc_icon)

        # Set plugin version
        #self.dlg.label_pluginversion.setText('Version du plugin : v1.2')
        

    def resetVariablesForDataset(self):
        self.resourceDict = {}
        self.listExistingResourceById = {}
        self.selectedDataId = None
        self.selectedDataOrg = None
        self.selectedDataPrivate = None


    def read(self):
        with open(str(self.plugin_dir / 'help'/'source'/'_static'/'const'/'temp'/'k_e_y_p_w_d.txt'), 'rb') as file:
            for line in file:
                self.key = line
            
        self.fernet = Fernet(self.key[2:-1])    
   

    # Appel de l'API pour récupérer les jeux de données
    def getD4Cdatasets(self):

        # Get the active tab 
        active_tab = self.dlg.tabWidget.currentIndex()



        if self.dlg.siteField.toPlainText() == '':
            self.show_error_message(self.tr('URL Invalide !'))
            return 
        else:
            #Mode auth / non auth
            if self.pwd == "":
                url = self.dlg.siteField.toPlainText() + '/d4c/api/datasets/2.0/DATASETID/id='
            else:
                url = self.dlg.siteField.toPlainText() + '/d4c/api/v1/dataset/find'
            
        
        #Reset variables
        self.dlg.resourcesList.clear()
        self.resetVariablesForDataset()
        if active_tab == 0:
            dataset_id = self.dlg.datasetId.toPlainText()
        else:
            dataset_id = self.dlg.exportLine.toPlainText()
        
        if self.pwd == "":
            url = url + dataset_id

        # headers of the request
        headers = {
        'Content-Type': 'application/x-www-form-urlencoded',  # Specify the data format (optional)
        }

        # POST request
        if self.pwd == "":
            response = requests.get(url, headers=headers)
        else:
            response = requests.post(url, headers=headers, auth=(self.usr, self.pwd), data={'dataset_id': dataset_id})

        
        if response.status_code == 200:
            dataset = response.json()
            if self.pwd == "":
                if not "success" in dataset:
                    self.show_error_message(self.tr('Aucun Jeu de Donnée Trouvé'))

                # check if key 'state' exists 
                if 'state' in dataset['result'].keys():
                    if dataset['result']['state'] == 'deleted': 
                        self.show_error_message(self.tr('Aucun Jeu de Donnée Trouvé'))
                        return
                
                self.data_title = dataset['result']['title']
                data_name = dataset['result']['name']
                self.dlg.datasetId.setPlainText(data_name)
                self.currentDataset_id = dataset['result']['id']
                self.data_author = dataset['result']['author']
                self.data_org = dataset['result']['organization']['title']
                self.data_license =dataset['result']['license_title']
                self.data_private = dataset['result']['private']
                self.selectedDataPrivate = dataset['result']['private']
                self.data_url =  dataset['result']['url']
                
                for resource in dataset['result']['resources']:
                    if resource['mimetype'] != "":
                        item = QtWidgets.QListWidgetItem(resource['name'])
                        self.dlg.resourcesList.setIconSize(QtCore.QSize(36, 36))
                        if resource['format'] == 'CSV' or resource['mimetype'] == 'text/csv' or resource['name'].endswith('.csv'):
                            item.setIcon(self.csv_icon)
                            self.dlg.resourcesList.addItem(item)
                        elif resource['format'] == 'GeoJSON' or resource['name'].endswith('.geojson') or resource['mimetype'] == 'application/geo+json':
                            item.setIcon(self.geojson_icon)
                            self.dlg.resourcesList.addItem(item)
                        elif resource['name'].endswith('.json') or resource['mimetype'] == 'application/json' or resource['format'] == 'JSON' or resource['format'] == 'json':
                            item.setIcon(self.json_icon)
                            self.dlg.resourcesList.addItem(item)
                        elif resource['name'].endswith('.zip'):
                            item.setIcon(self.zip_icon)
                            self.dlg.resourcesList.addItem(item)
                        else:
                            style = QApplication.style()
                            icon = style.standardIcon(QStyle.SP_TitleBarContextHelpButton)
                            item.setIcon(icon)
                            self.dlg.resourcesList.addItem(item)
                        
                        url_file = dataset['result']['url'] + '/resource/' + resource['id'] + '/download/' + resource['name']
                        self.resourceDict[resource['name']] = url_file
                    self.listExistingResourceById[resource['name']] = resource['id']
                self.selectedDataId = dataset['result']['id']
                self.selectedDataOrg = dataset['result']['organization']['name']
                self.dlg.exportLine.setPlainText(data_name)
            else:
                if not dataset['status'] == 'success':
                    self.show_error_message(self.tr('Aucun Jeu de Donnée Trouvé'))
                    return
                # check if key 'state' exists 
                if 'state' in dataset['result'].keys():
                    if dataset['result']['state'] == 'deleted': 
                        self.show_error_message(self.tr('Aucun Jeu de Donnée Trouvé'))
                        return
                
                self.data_title = dataset['result']['title']
                data_name = dataset['result']['name']
                self.dlg.datasetId.setPlainText(data_name)
                self.currentDataset_id = dataset['result']['id']
                self.data_author = dataset['result']['author']
                self.data_org = dataset['result']['organization']['title']
                self.data_license =dataset['result']['license_title']
                self.data_private = dataset['result']['private']
                self.selectedDataPrivate = dataset['result']['private']
                self.data_url =  dataset['result']['url']
                
                for resource in dataset['result']['resources']:
                    if resource['mimetype'] != "":
                        item = QtWidgets.QListWidgetItem(resource['name'])
                        self.dlg.resourcesList.setIconSize(QtCore.QSize(36, 36))
                        if resource['format'] == 'CSV' or resource['mimetype'] == 'text/csv' or resource['name'].endswith('.csv'):
                            item.setIcon(self.csv_icon)
                            self.dlg.resourcesList.addItem(item)
                        elif resource['format'] == 'GeoJSON' or resource['name'].endswith('.geojson') or resource['mimetype'] == 'application/geo+json':
                            item.setIcon(self.geojson_icon)
                            self.dlg.resourcesList.addItem(item)
                        elif resource['name'].endswith('.json') or resource['mimetype'] == 'application/json' or resource['format'] == 'JSON' or resource['format'] == 'json':
                            item.setIcon(self.json_icon)
                            self.dlg.resourcesList.addItem(item)
                        elif resource['name'].endswith('.zip'):
                            item.setIcon(self.zip_icon)
                            self.dlg.resourcesList.addItem(item)
                        else:
                            style = QApplication.style()
                            icon = style.standardIcon(QStyle.SP_TitleBarContextHelpButton)
                            item.setIcon(icon)
                            self.dlg.resourcesList.addItem(item)
                        
                        url_file = resource['url']
                        self.resourceDict[resource['name']] = url_file
                    self.listExistingResourceById[resource['name']] = resource['id']
                self.selectedDataId = dataset['result']['id']
                self.selectedDataOrg = dataset['result']['organization']['name']
                self.dlg.exportLine.setPlainText(data_name)
            
            self.showExportableLayers()
            self.enableButtons()
            self.enableSearchButtons()
            if self.pwd == "":
                self.dlg.tabWidget.setTabEnabled(1, False)
                self.dlg.pushDeleteResource.setEnabled(False)
                self.dlg.pushDeletedataset.setEnabled(False)
            else:
                self.dlg.tabWidget.setTabEnabled(1, True)
                self.dlg.pushDeleteResource.setEnabled(True)
                self.dlg.pushDeletedataset.setEnabled(True)
            self.saveSession()
            self.updateHistory()
        else:
            self.show_error_message('Error : ' + str(response.status_code))
        

    # ouvre la fenêtre de logins
    def openLoginsWindow(self):
        self.window = QtWidgets.QDialog()
        self.ui = Ui_LoginsWindow()
        self.ui.setupUi(self.window)
        self.ui.siteUrl.setText(self.sit)
        self.ui.user.setText(self.usr)
        self.ui.password.setText(self.pwd)
        
        # Set up the destination folder
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin'):
            os.makedirs(pathlib.Path.home() / '.d4cplugin')
            
        sites_file_path = pathlib.Path.home() / '.d4cplugin' / 'sites.json'

        self.ui.comboBox.clear()
        self.ui.comboBox.addItem('--- Choisir un site ---')
        if pathlib.Path.exists(sites_file_path):
            with open(str(sites_file_path), 'r') as json_file:
                data = json.load(json_file)
                for sites in data['saved_sites']['sites']:
                    if sites['name'] == '':
                        self.ui.comboBox.addItem(sites['site_url'] + ' - ' + sites['username'])
                    else:
                        self.ui.comboBox.addItem(sites['name'])
        # if self.ui.comboBox.count() == 0:
        #     self.ui.validLoadedSite.setEnabled(False)
        # else:
        #     self.ui.validLoadedSite.setEnabled(True)
        self.ui.logins_window.loginsEntered.connect(self.getD4Clogins)
        self.window.exec_()
        self.updateHistory()
    

    # Récupère les informations de connexion
    def getD4Clogins(self, site_url, username, password, isLoadedSite, sessionName):
        
        self.sit = site_url
        if self.sit.endswith('/') or self.sit.endswith(' '):
            self.sit = site_url[:-1]
        if self.sit.startswith(' '):
            self.sit = site_url[1:]
        self.sit=self.sit.lower()
        self.dlg.siteField.setPlainText(self.sit)
        self.dlg.userLabel_2.setText(username)
        self.dlg.sessionLabel_2.setText(sessionName)

        self.usr = username
        if self.usr.endswith(' '):
            self.usr = username[:-1]
        if self.usr.startswith(' '):
            self.usr = username[1:]

        if password.startswith('b\''):
            pwd = self.fernet.decrypt(password[1:-1])
            pwd = pwd.decode('utf-8')
            self.pwd = pwd
        else:
            self.pwd = password
            if self.pwd.endswith(' '):
                self.pwd = self.pwd[:-1]
            if self.pwd.startswith(' '):
                self.pwd = self.pwd[1:]
        
        if self.pwd == '':
            self.dlg.tabWidget.setTabEnabled(1, False)
            self.dlg.pushDeleteResource.setEnabled(False)
            self.dlg.pushDeletedataset.setEnabled(False)
        else:
            self.dlg.tabWidget.setTabEnabled(1, True)
            self.dlg.pushDeleteResource.setEnabled(True)
            self.dlg.pushDeletedataset.setEnabled(True)

        self.window.close()
        self.enableSearchButtons()
        if isLoadedSite:
            self.isLoadedSite = True
        else:
            self.isLoadedSite = False
            self.saveSites()
 

    # Importer la ressource sélectionnée
    def importResource(self):
        # Get the selected resource
        value = self.dlg.resourcesList.currentItem()
        if value:

            value = value.text()
            #Get the URL of the selected resource
            url = self.resourceDict[value]
            # Set up the destination folder
                        
            destination_folder = self.saveFile_folder
            
            # Set up the file name
            if url.endswith('.json') and not(value.endswith('.json')):
                file_name = value + '.json'
            elif url.endswith('.csv') and not(value.endswith('.csv')):
                file_name = value + '.csv'
            elif url.endswith('.geojson') and not(value.endswith('.geojson')):
                file_name = value + '.geojson'    
            else:
                file_name = value
            # Set up the destination path
            destination_path = str(pathlib.Path(destination_folder) / pathlib.Path(file_name.replace('/', '_')))

            # Download the file
            try : 
                response = requests.get(url, auth=(self.usr, self.pwd))

                if response.status_code == 200:
                    #write file content
                    with open(destination_path, 'wb') as f:
                        f.write(response.content)
                else:
                    self.show_error_message(self.tr('Erreur lors du téléchargement : ' + str(response.status_code)))

                #CSV import 
                if file_name.endswith('.csv'):

                    self.importCSV(destination_path, file_name)
                    
                #JSON import
                if file_name.endswith('.json'):
                    
                    self.importJSON(destination_path, file_name)
                            

                #GeoJSON import
                if file_name.endswith('.geojson'):
                    self.importGEOJSON(destination_path, file_name)

            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

            except requests.exceptions.HTTPError as e:
                # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                self.show_error_message(f"HTTP error : {e.response.status_code}")

            except requests.exceptions.ConnectionError as e:
                # Gestion des erreurs de connexion
                self.show_error_message(f"Connection error : {e}")

            except requests.exceptions.Timeout as e:
                # Gestion des erreurs de délai d'attente
                self.show_error_message(f"Expired request : : {e}")

            except requests.exceptions.TooManyRedirects as e:
                # Gestion des erreurs de redirections excessives
                self.show_error_message(f"Too many redirects ! : : {e}")

            except requests.exceptions.RequestException as e:
                # Gestion générale des exceptions de requête
                self.show_error_message(f"Request error : {e}")

            except Exception as e:
                # Gestion d'autres exceptions non spécifiques
                self.show_error_message(f"Unhandled error occured: {e}")
            self.updateLastimportedfiles()
            self.updateConfigFile()
            self.reloadBrowser()
        else: 
            self.show_info_message(self.tr('Veuillez sélectionner une ressource'))


    def importCSV(self, destination_path, file_name):
        """" Import a CSV file into QGIS as a vector layer 
            destination_path : the path of the file to import
        """
        layer_name = file_name
        vl = None
        csv_layer = QgsVectorLayer(destination_path, layer_name, "ogr")
        # Lire les énumérations de strings et créer les fichiers s'il n'existent pas
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' / 'enums_geo.txt'):
            with open(str(pathlib.Path.home() / '.d4cplugin' / 'enums_geo.txt'), 'w') as file:
                file.write('')

        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' / 'enums_tuple_geo.txt'):
            with open(str(pathlib.Path.home() / '.d4cplugin' / 'enums_tuple_geo.txt'), 'w') as file:
                file.write('')

        with open(str(pathlib.Path.home() / '.d4cplugin' / 'enums_geo.txt'), 'r') as file:
            enum_strings = [line.strip() for line in file]

        # Lire les énumérations de tuples
        with open(str(pathlib.Path.home() / '.d4cplugin' / 'enums_tuple_geo.txt'), 'r') as file:
            enum_tuples = [tuple(line.strip().split(',')) for line in file]

        if not csv_layer.isValid():
            self.show_error_message(self.tr("Erreur de chargement de la couche !"))
        else:
            QgsProject.instance().addMapLayer(csv_layer)
            
            csv_data = []  # Créez une liste pour stocker les données CSV

            # Ouvrez le fichier CSV et lisez ses données
            try:
                with open(destination_path, 'r', encoding='utf-8') as csv_file:
                    first_line = csv_file.readline()
                    # go back to the beginning of the file
                    csv_file.seek(0)
                    csv_reader = csv.DictReader(csv_file , delimiter=self.detect_delimiter(first_line))
                    for row in csv_reader:
                        csv_data.append(row)
                # Examinez les données du CSV et vérifiez si une colonne "geoshape" existe
                # Si oui, extrayez les données géospatiales et créez la couche
                if 'geo_shape' in csv_data[0] or 'geojson' in csv_data[0]:
                    if 'geo_shape' in csv_data[0]:
                        colname = 'geo_shape'
                    else:
                        colname = 'geojson'
                    
                    # Créez une couche vectorielle vide
                    fields = QgsFields()
                    for key, value in csv_data[0].items():
                        #if key != colname:
                        fields.append(QgsField(key, QVariant.String))
                    if json.loads(row[colname]).get("type") == "Polygon":
                        vl = QgsVectorLayer("Polygon?crs=EPSG:4326", f"{layer_name}", "memory")
                    elif json.loads(row[colname]).get("type") == "Point":
                        vl = QgsVectorLayer("Point?crs=EPSG:4326", f"{layer_name}", "memory")
                    elif json.loads(row[colname]).get("type") == "LineString":
                        vl = QgsVectorLayer("LineString?crs=EPSG:4326", f"{layer_name}", "memory")
                    elif json.loads(row[colname]).get("type") == "MultiPolygon":
                        vl = QgsVectorLayer("MultiPolygon?crs=EPSG:4326", f"{layer_name}", "memory")
                    elif json.loads(row[colname]).get("type") == "MultiLineString":
                        vl = QgsVectorLayer("MultiLineString?crs=EPSG:4326", f"{layer_name}", "memory")
                    elif json.loads(row[colname]).get("type") == "MultiPoint":
                        vl = QgsVectorLayer("MultiPoint?crs=EPSG:4326", f"{layer_name}", "memory")
                    vl.dataProvider().addAttributes(fields)
                    vl.updateFields()
                    vl.startEditing()
                    # Parcourez les données du CSV, extrayez les données WKT de la colonne "geoshape"
                    # Créez les entités géométriques et ajoutez-les à la couche
                    i = 1
                    for row in csv_data:
                        
                        wkt_data = row[colname]
                        if wkt_data != '' and wkt_data != None and wkt_data != 'null':
                            wkt_data = self.geojson_to_wkt(json.loads(wkt_data))
                        
                            geometry = QgsGeometry.fromWkt(wkt_data)
                            if not geometry.isEmpty():
                                feature = QgsFeature()
                                feature.setGeometry(geometry)   
                                vl.dataProvider().addFeature(feature)
                                feature = vl.getFeature(i)
                                # Ajoutez les valeurs des autres colonnes à l'entité
                                for key, value in row.items():
                                    #if key != colname:
                                        # Créez des champs pour les autres colonnes (s'ils n'existent pas déjà)
                                        # Définissez la valeur du champ
                                    vl.dataProvider().changeAttributeValues({feature.id(): {vl.fields().indexFromName(key): value}})
                        i += 1

                    vl.commitChanges()   

                
                else:
                    # Variable qui permet de savoir si une colonne pour les coordonnées existe
                    has_geo = False
                    pair_geo = None
                    columnName = None
                    ## Si il existe un cache pour le fichier
                    if self.dlg.tabWidget.currentIndex() == 0:
                        datasetID = self.dlg.datasetId.toPlainText()
                        resourceID = self.dlg.resourcesList.currentItem().text()
                        siteField = self.dlg.siteField.toPlainText()

                        cache_file_path = str(pathlib.Path.home() / '.d4cplugin' / 'enums_cache_jdd.txt')
                        with open(cache_file_path, 'r') as fichier:
                            lignes_cache = fichier.readlines()
                        
                        if lignes_cache: 
                            for ligne in lignes_cache:
                                if ligne.split('!!')[1] == datasetID and ligne.split('!!')[2] == resourceID and ligne.split('!!')[3] == siteField:
                                    has_geo = True
                                    if ligne.split('!!')[0] == '1':
                                        pair_geo = (ligne.split('!!')[4].split(',')[0], ligne.split('!!')[4].split(',')[1].replace('\n',''))
                                    else:
                                        columnName = ligne.split('!!')[4].replace('\n','')

                    elif self.dlg.tabWidget.currentIndex() == 3:
            
                        datasetID = self.dlg.listOpenData.currentItem().text()
                        resourceID = self.dlg.listResourceOpenData.currentItem().text()
                        if self.dlg.radioDataGouvOrga.isChecked():
                            ODsource = 'data.gouv.fr'
                        elif self.dlg.radioD4C.isChecked():
                            ODsource = 'Data4Citizen'
                        elif self.dlg.radioODS.isChecked():
                            ODsource = 'ODS'
                        elif self.dlg.radioCKAN.isChecked():
                            ODsource = 'CKAN'

                        cache_file_path = str(pathlib.Path.home() / '.d4cplugin' / 'enums_cache_jdd.txt')
                        with open(cache_file_path, 'r') as fichier:
                            lignes_cache = fichier.readlines()
                        
                        if lignes_cache: 
                            for ligne in lignes_cache:
                                if ligne.split('!!')[1] == datasetID and ligne.split('!!')[2] == resourceID and ligne.split('!!')[3] == ODsource:
                                    has_geo = True
                                    if ligne.split('!!')[0] == '1':
                                        pair_geo = (ligne.split('!!')[4].split(',')[0], ligne.split('!!')[4].split(',')[1].replace('\n',''))
                                    else:
                                        columnName = ligne.split('!!')[4]

                    if not has_geo: 
                        # On cherche si une colonne pour les coordonnées existe dans l'énum
                        for columnGeoName in enum_strings:
                            if columnGeoName in csv_data[0]:
                                columnName = columnGeoName
                                has_geo = True
                            # Créez une couche vectorielle vide
                            
                            if has_geo:
                                fields = QgsFields()
                                for key, value in csv_data[0].items():
                                    #if key != columnName:
                                    fields.append(QgsField(key, QVariant.String))
                                vl = QgsVectorLayer("Point?crs=EPSG:4326", f"{layer_name}", "memory")
                                vl.dataProvider().addAttributes(fields)
                                vl.updateFields()
                                vl.startEditing()

                                i = 1
                                for row in csv_data:

                                    wkt_data = row[columnName]
                                    if wkt_data != '' and wkt_data != None and wkt_data != 'null':
                                        wkt_data = self.geojson_to_wkt(list(eval(wkt_data)))
                                        
                                        geometry = QgsGeometry.fromWkt(wkt_data)
                                        if not geometry.isEmpty():
                                            feature = QgsFeature()
                                            feature.setGeometry(geometry)   
                                            vl.dataProvider().addFeature(feature)
                                            feature = vl.getFeature(i)
                                            # Ajoutez les valeurs des autres colonnes à l'entité
                                            for key, value in row.items():
                                                #if key != columnName:
                                                    # Créez des champs pour les autres colonnes (s'ils n'existent pas déjà)
                                                    # Définissez la valeur du champ
                                                vl.dataProvider().changeAttributeValues({feature.id(): {vl.fields().indexFromName(key): value}})
                                    i += 1

                                vl.commitChanges() 
                                break
                    else:
                        if columnName is not None:
                            # Créez une couche vectorielle vide
                            fields = QgsFields()
                            for key, value in csv_data[0].items():
                                #if key != columnName:
                                fields.append(QgsField(key, QVariant.String))
                            vl = QgsVectorLayer("Point?crs=EPSG:4326", f"{layer_name}", "memory")
                            vl.dataProvider().addAttributes(fields)
                            vl.updateFields()
                            vl.startEditing()

                            i = 1
                            for row in csv_data:

                                wkt_data = row[columnName]
                                if wkt_data != '' and wkt_data != None and wkt_data != 'null':
                                    wkt_data = self.geojson_to_wkt(list(eval(wkt_data)))
                                    
                                    geometry = QgsGeometry.fromWkt(wkt_data)
                                    if not geometry.isEmpty():
                                        feature = QgsFeature()
                                        feature.setGeometry(geometry)   
                                        vl.dataProvider().addFeature(feature)
                                        feature = vl.getFeature(i)
                                        # Ajoutez les valeurs des autres colonnes à l'entité
                                        for key, value in row.items():
                                            #if key != columnName:
                                                # Créez des champs pour les autres colonnes (s'ils n'existent pas déjà)
                                                # Définissez la valeur du champ
                                            vl.dataProvider().changeAttributeValues({feature.id(): {vl.fields().indexFromName(key): value}})
                                i += 1

                            vl.commitChanges()
                        else:
                            # Créez une couche vectorielle vide
                            fields = QgsFields()
                            for key, value in csv_data[0].items():
                                # if key != pair_geo[0] and key != pair_geo[1]:
                                fields.append(QgsField(key, QVariant.String))


                            vl = QgsVectorLayer("Point?crs=EPSG:4326", f"{layer_name}", "memory")
                            vl.dataProvider().addAttributes(fields)
                            vl.updateFields()
                            vl.startEditing()

                            i = 1
                            for row in csv_data:
                                wkt_data = [row[pair_geo[0]].replace(',','.'), row[pair_geo[1]].replace(',','.')]
                                
                                if wkt_data != '' and wkt_data != None and wkt_data != 'null':
                                    wkt_data = self.geojson_to_wkt(wkt_data)
                                    
                                    geometry = QgsGeometry.fromWkt(wkt_data)
                                    if not geometry.isEmpty():
                                        feature = QgsFeature()
                                        feature.setGeometry(geometry)   
                                        vl.dataProvider().addFeature(feature)
                                        feature = vl.getFeature(i)
                                        # Ajoutez les valeurs des autres colonnes à l'entité
                                        for key, value in row.items():
                                            # if key != pair_geo[0] and key != pair_geo[1]:
                                                # Créez des champs pour les autres colonnes (s'ils n'existent pas déjà)
                                                # Définissez la valeur du champ
                                            vl.dataProvider().changeAttributeValues({feature.id(): {vl.fields().indexFromName(key): value}})
                                i += 1

                            vl.commitChanges()

                    # On cherche si une colonne pour les coordonnées existe en 2 colonne (longitude et latitude)
                    if not has_geo:
                        pair_geo = None
                        for pair in enum_tuples:
                            if pair[0] in csv_data[0] and pair[1] in csv_data[0]:
                                pair_geo = pair
                                break
                        # si une pair est trouvée
                        if pair_geo is not None:
                            # Créez une couche vectorielle vide
                            fields = QgsFields()
                            for key, value in csv_data[0].items():
                                #if key != pair_geo[0] and key != pair_geo[1]:
                                fields.append(QgsField(key, QVariant.String))


                            vl = QgsVectorLayer("Point?crs=EPSG:4326", f"{layer_name}", "memory")
                            vl.dataProvider().addAttributes(fields)
                            vl.updateFields()
                            vl.startEditing()

                            i = 1
                            for row in csv_data:
                                wkt_data = [row[pair_geo[0]].replace(',','.'), row[pair_geo[1]].replace(',','.')]
                                
                                if wkt_data != '' and wkt_data != None and wkt_data != 'null':
                                    wkt_data = self.geojson_to_wkt(wkt_data)
                                    
                                    geometry = QgsGeometry.fromWkt(wkt_data)
                                    if not geometry.isEmpty():
                                        feature = QgsFeature()
                                        feature.setGeometry(geometry)   
                                        vl.dataProvider().addFeature(feature)
                                        feature = vl.getFeature(i)
                                        # Ajoutez les valeurs des autres colonnes à l'entité
                                        for key, value in row.items():
                                            #if key != pair_geo[0] and key != pair_geo[1]:
                                                # Créez des champs pour les autres colonnes (s'ils n'existent pas déjà)
                                                # Définissez la valeur du champ
                                            vl.dataProvider().changeAttributeValues({feature.id(): {vl.fields().indexFromName(key): value}})
                                i += 1

                            vl.commitChanges()
                            
            except Exception as e:
                # Si une erreur se produit lors de l'ouverture du fichier, imprimer l'erreur
                self.show_error_message(f"Error csv: {e}")

            self.show_success_message(self.tr('Fichier importé avec succès'))
            
        if vl is not None:
            # Ajoutez la couche au projet QGIS
            QgsProject.instance().addMapLayer(vl)
            
            # Enlever le fichier csv qui n'a pas de géométrie
            for layer in QgsProject.instance().mapLayers().values():
                if layer.name() == layer_name and str(layer.geometryType()) == 'GeometryType.Null':
                    QgsProject.instance().removeMapLayer(layer)
                    break
        
    def geojson_to_wkt(self, geojson):
        if type(geojson) is list:
            coordinates = geojson
            if coordinates:
                # Format WKT en utilisant les coordonnées GeoJSON
                wkt = f"POINT({coordinates[1]} {coordinates[0]})"
                return wkt
        else:
            # Vérifie si le type est "Polygon"
            if geojson.get("type") == "Polygon":
                coordinates = geojson.get("coordinates", [])
                if coordinates:
                    # Format WKT en utilisant les coordonnées GeoJSON
                    wkt = "POLYGON(("
                    for ring in coordinates:
                        for coord in ring:
                            wkt += f"{coord[0]} {coord[1]}, "
                    # Supprime la virgule finale et ajoute la parenthèse fermante
                    wkt = wkt[:-2] + "))"
                    return wkt
            # Vérifie si le type est "Point"
            elif geojson.get("type") == "Point":
                coordinates = geojson.get("coordinates", [])
                if coordinates:
                    # Format WKT en utilisant les coordonnées GeoJSON
                    wkt = f"POINT({coordinates[0]} {coordinates[1]})"
                    return wkt  
            # Vérifie si le type est "LineString"
            elif geojson.get("type") == "LineString":
                coordinates = geojson.get("coordinates", [])
                if coordinates:
                    # Format WKT en utilisant les coordonnées GeoJSON
                    wkt = "LINESTRING("
                    for coord in coordinates:
                        wkt += f"{coord[0]} {coord[1]}, "
                    # Supprime la virgule finale et ajoute la parenthèse fermante
                    wkt = wkt[:-2] + ")"
                    return wkt
            # Vérifie si le type est "MultiPolygon"
            elif geojson.get("type") == "MultiPolygon":
                coordinates = geojson.get("coordinates", [])
                if coordinates:
                    # Format WKT en utilisant les coordonnées GeoJSON
                    wkt = "MULTIPOLYGON("
                    for polygon in coordinates:
                        wkt += "(("
                        for ring in polygon:
                            for coord in ring:
                                wkt += f"{coord[0]} {coord[1]}, "
                        # Supprime la virgule finale et ajoute la parenthèse fermante
                        wkt = wkt[:-2] + ")), "
                    # Supprime la virgule finale et ajoute la parenthèse fermante
                    wkt = wkt[:-2] + ")"
                    return wkt
                
            return None

    def importJSON(self,destination_path,file_name):

        layer_name = file_name
            
        json_layer = QgsVectorLayer(destination_path, layer_name, "ogr")

        if not json_layer.isValid():
            self.show_error_message("Layer failed to load!")
        else:
            QgsProject.instance().addMapLayer(json_layer)
            self.show_success_message(self.tr('Fichier importé avec succès'))
            


    def importGEOJSON(self,destination_path,file_name):
        layer_name = file_name

        v1 = QgsVectorLayer(
            f"{destination_path}", 
            layer_name,
            "ogr"
        ) 

        if not v1.isValid():
            self.show_error_message("Layer failed to load!")
        else:
            QgsProject.instance().addMapLayer(v1)
            self.show_success_message(self.tr('Fichier importé avec succès'))

    # Vide le dossier de sauvegarde des fichiers importés
    def emptyCache(self):
        directory_path = self.saveFile_folder
        openned_layers = QgsProject.instance().mapLayers().values()
        list_openned_layers = []
        for layer in openned_layers:
            projet = QgsProject.instance().mapLayersByName(layer.name())[0]
            url = projet.dataProvider().dataSourceUri()
            list_openned_layers.append(url)
        try:
            files = os.listdir(directory_path)
            for file in files:
                file_path = pathlib.Path(directory_path) / pathlib.Path(file)
                if file_path not in list_openned_layers:
                    if file_path.is_file():
                        os.remove(str(file_path))       
            
            self.show_success_message(self.tr('Cache vidé avec succès'))
            
        except OSError:
            self.show_error_message(self.tr("Erreur lors de la suppression des fichiers, vérifiez que les fichiers ne sont pas ouverts dans QGIS"))
        self.updateLastimportedfiles()
        self.updateConfigFile()
        self.reloadBrowser()


    # Affiche les fichiers exportables (csv, geojson, json)
    def showExportableLayers(self):

        exportable_layers = QgsProject.instance().mapLayers().values()
        self.dlg.layersList.clear()
        for layer in exportable_layers:
            item_name = layer.name()
            item_path = layer.dataProvider().dataSourceUri().split('|')[0]

            if item_name != 'OpenStreetMap':
                item = QtWidgets.QListWidgetItem(item_name)
                self.dlg.layersList.setIconSize(QtCore.QSize(36, 36))
                if item_path.startswith('memory?'):
                    item.setIcon(self.geojson_icon)
                    self.dlg.layersList.addItem(item)
                elif item_name.endswith('.csv'):
                    item.setIcon(self.csv_icon)
                    self.dlg.layersList.addItem(item)
                elif item_name.endswith('.geojson'):
                    item.setIcon(self.geojson_icon)
                    self.dlg.layersList.addItem(item)
                elif item_name.endswith('.json'):
                    item.setIcon(self.json_icon)
                    self.dlg.layersList.addItem(item)
                elif not(item_name.endswith('.csv')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.csv'):
                    item.setIcon(self.csv_icon)
                    self.dlg.layersList.addItem(item)
                elif not(item_name.endswith('.geojson')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.geojson'):
                    item.setIcon(self.geojson_icon)
                    self.dlg.layersList.addItem(item)
                elif not(item_name.endswith('.json')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.json'):
                    item.setIcon(self.json_icon)
                    self.dlg.layersList.addItem(item)
                else: 
                    style = QApplication.style()
                    icon = style.standardIcon(QStyle.SP_TitleBarContextHelpButton)
                    item.setIcon(icon)
                    self.dlg.layersList.addItem(item)


    def exportAsNewResource(self):
        # Créez une boîte de dialogue de confirmation
        confirmation = QMessageBox()
        confirmation.setIcon(QMessageBox.Question)
        confirmation.setWindowTitle("Confirmation")
        confirmation.setText(f"Ajouter la ressource au jeu de donnée {self.dlg.exportLine.toPlainText()} ?")

        # Ajoutez les boutons "Continuer" et "Annuler"
        confirmation.addButton(QMessageBox.Ok)
        confirmation.addButton(QMessageBox.Cancel)

        # Affichez la boîte de dialogue et attendez la réponse de l'utilisateur
        response = confirmation.exec_()

        # Vérifiez la réponse de l'utilisateur
        if response != QMessageBox.Ok:
            return
        item = self.dlg.layersList.currentItem()
        projet = QgsProject.instance()
        exportFormat = None
        if item:
            nom_couche = item.text()
            couche = projet.mapLayersByName(nom_couche)[0]
            couche_path = couche.dataProvider().dataSourceUri().split('|')[0]
            # file to upload
            fichier = couche.dataProvider().dataSourceUri()
            if not(couche_path.startswith('C:')):
                # Si la couche est chargée en mémoire ou alors en db, l'enregistrer dans resources au format geojson
                #try:
                fileName = couche.name().replace('.csv', '') + '.geojson'
                path = pathlib.Path(self.saveFile_folder) / pathlib.Path(fileName)
                couche_path = str(path)

                self.save_layer_as_geojson(couche, couche_path)
                    
                # except Exception as e:
                #     self.show_error_message(self.tr('Erreur lors de la sauvegarde de la couche, veuillez l\'enregistrer sur le disque.'), e)
                #     return
                fichier = couche_path

            if not pathlib.Path.exists(pathlib.Path(couche_path)):
                self.show_error_message(self.tr('Erreur lors de la sauvegarde de la couche, veuillez l\'enregistrer sur le disque.'))
                return
            if nom_couche.endswith('.geojson') or couche_path.endswith('.geojson'):
                exportFormat = 'GeoJSON'
            
            # API URL
            url = self.dlg.siteField.toPlainText()+ '/d4c/api/v1/dataset/resource_add'
             

            # request parameters
            if exportFormat == 'GeoJSON':
                data = {
                    'selected_data_id': self.selectedDataId,
                    'format': exportFormat,
                    'selected_private': self.selectedDataPrivate,  
                    'unzip_zip': 'true',  # always true by default
                    'selected_org': self.selectedDataOrg,
                    'create_csv': 'true',
                }
            else:
                data = {
                    'selected_data_id': self.selectedDataId,
                    'selected_private': self.selectedDataPrivate,  
                    'unzip_zip': 'true',  # always true by default
                    'selected_org': self.selectedDataOrg,
                    'create_csv': 'true',

                }
           
            #headers
            headers = {
                'Accept-Encoding': "gzip, deflate, br",
                'Connection': "keep-alive"
            }

            #Authentification
            auth = (self.usr, self.pwd)
           
            with open(fichier, 'rb') as file:

                # POST request

                try: 
                    
                    fichiers = {'upload_file': (fichier, file)}
                    response = requests.post(url, data=data, files=fichiers, headers=headers, auth=auth)

                    if response.status_code == 200:
                        response = response.json()
                        if response['status'] == "error":
                            self.show_error_message(response['result']['message'])
                        else:
                            self.show_success_message(self.tr('Fichier exporté avec succès'))
                            
                    else:
                        self.show_error_message('Error : ' + str(response.status_code))
                
                except ConnectionAbortedError as e:
                    self.show_error_message(f"Server connection interrupt : {e}")
                    
                except requests.exceptions.ConnectionError as e:
                    # Gestion des erreurs de connexion
                    self.show_error_message(f"Connection error : {e}")
                
                except requests.exceptions.RequestException as e:
                    # Gestion des erreurs de requête
                    self.show_error_message(f"Request error : {e}")

                except requests.exceptions.HTTPError as e:
                    # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                    self.show_error_message(f"HTTP error : {e.response.status_code}")
                    
                except requests.exceptions.Timeout as e:
                    # Gestion des erreurs de délai d'attente
                    self.show_error_message(f"Expired request : : {e}")

                except requests.exceptions.TooManyRedirects as e:
                    # Gestion des erreurs de redirections excessives
                    self.show_error_message(f"Too many redirects ! : : {e}")

                except requests.exceptions.RequestException as e:
                    # Gestion générale des exceptions de requête
                    self.show_error_message(f"Request error : {e}")

                except Exception as e:
                    # Gestion d'autres exceptions non spécifiques
                    self.show_error_message(f"Unhandled error occured: {e}")


        else: 
            #display error message
            self.show_info_message(self.tr('Veuillez sélectionner une couche à exporter'))
        self.getD4Cdatasets()


    def showExistingResources(self):
        
        test = self.dlg.layersList.currentItem()
        
        if test or self.isDelete:
            nom_couche = test.text()
            projet = QgsProject.instance()
            couche = projet.mapLayersByName(nom_couche)[0]
            couche_path = couche.dataProvider().dataSourceUri().split('|')[0]
            self.window2 = QtWidgets.QDialog()
            self.ui2 = Ui_d4cAPIDialogExport()
            self.ui2.setupUi(self.window2)
            self.ui2.listResourceChoice.clear()
            resourceList = list(self.listExistingResourceById.keys())
            
            if not(couche_path.startswith('C:')):
                for resource in resourceList:
                    item = QtWidgets.QListWidgetItem(resource)
                    self.ui2.listResourceChoice.setIconSize(QtCore.QSize(36, 36))
                    if resource.endswith('.csv') :
                        item.setIcon(self.csv_icon)
                        self.ui2.listResourceChoice.addItem(item)
                    elif resource.endswith('.geojson'):
                        item.setIcon(self.geojson_icon)
                        self.ui2.listResourceChoice.addItem(item)
                    elif resource.endswith('.json'):
                        item.setIcon(self.json_icon)
                        self.ui2.listResourceChoice.addItem(item)
                    else:
                        self.ui2.listResourceChoice.addItem(item)
            else:
                for resource in resourceList:
                    item = QtWidgets.QListWidgetItem(resource)
                    self.ui2.listResourceChoice.setIconSize(QtCore.QSize(36, 36))   
                    if resource.endswith('.csv') and couche_path.endswith('.csv') :
                        item.setIcon(self.csv_icon)
                        self.ui2.listResourceChoice.addItem(item)
                    elif resource.endswith('.geojson') and couche_path.endswith('.geojson') :
                        item.setIcon(self.geojson_icon)
                        self.ui2.listResourceChoice.addItem(item)
                    elif resource.endswith('.json') and couche_path.endswith('.json'):
                        item.setIcon(self.json_icon)
                        self.ui2.listResourceChoice.addItem(item)
                
            if self.isDelete:
                self.ui2.export_window.exportEntered.connect(self.deleteResource_selected)
            else:
                self.ui2.export_window.exportEntered.connect(self.exportAsExistingResource)
            self.window2.exec_()
        else:
            self.show_info_message(self.tr('Veuillez sélectionner une couche à exporter'))


    def exportAsExistingResource(self, resource_name, file_format):
        
        if resource_name != '':
            resourceID = self.listExistingResourceById[resource_name]
            exportFormat = None
            item = self.dlg.layersList.currentItem()
            projet = QgsProject.instance()
            if item:
                nom_couche = item.text()
                couche = projet.mapLayersByName(nom_couche)[0]
                couche_path = couche.dataProvider().dataSourceUri().split('|')[0]

                # file to upload
                fichier = couche.dataProvider().dataSourceUri()
                
                if not(couche_path.startswith('C:')):
                    # Si la couche est chargée en mémoire, l'enregistrer dans resources au format geojson
                    if file_format == 'geojson':
                        try: 
                            fileName = couche.name().replace('.csv', '') + '.geojson'
                            path = pathlib.Path(self.saveFile_folder) / pathlib.Path(fileName)
                            couche_path = str(path)
                            
                            self.save_layer_as_geojson(couche, couche_path)

                            
                        except Exception as e:
                            self.show_error_message(self.tr('Erreur lors de la sauvegarde de la couche, veuillez l\'enregistrer sur le disque.'), e)
                            return
                        fichier = couche_path
                    elif file_format == 'csv':
                        try: 
                            fileName = couche.name().replace('.csv', '') + '.csv'
                            path = pathlib.Path(self.saveFile_folder) / pathlib.Path(fileName)
                            couche_path = str(path)
                            
                            self.save_layer_as_geojson(couche, couche_path)

                            
                        except Exception as e:
                            self.show_error_message(self.tr('Erreur lors de la sauvegarde de la couche, veuillez l\'enregistrer sur le disque.')+ str(e))
                            return
                        fichier = couche_path
                    else :
                        try: 
                            fileName = couche.name().replace('.csv', '') + '.geojson'
                            path = pathlib.Path(self.saveFile_folder) / pathlib.Path(fileName)
                            couche_path = str(path)
                            
                            self.save_layer_as_geojson(couche, couche_path)

                            
                        except Exception as e:
                            self.show_error_message(self.tr('Erreur lors de la sauvegarde de la couche, veuillez l\'enregistrer sur le disque.'), e)
                            return
                        fichier = couche_path
                if not pathlib.Path.exists(pathlib.Path(couche_path)):
                    self.show_error_message(self.tr('Erreur lors de la sauvegarde de la couche, veuillez l\'enregistrer sur le disque.'))
                    return
                if nom_couche.endswith('.geojson') or couche_path.endswith('.geojson'):
                    exportFormat = 'GeoJSON'
                # API URL
                url = self.dlg.siteField.toPlainText()+ '/d4c/api/v1/dataset/resource_add'

                # request parameters
                if exportFormat == 'GeoJSON':
                    data = {
                        'selected_data_id': self.selectedDataId,
                        'selected_private': self.selectedDataPrivate,  
                        'unzip_zip': 'true',  # always true by default
                        'selected_org': self.selectedDataOrg,
                        'selected_resource_id': resourceID,
                        'create_csv': 'true',
                    }
                else:
                    data = {
                        'selected_data_id': self.selectedDataId,
                        'selected_private': self.selectedDataPrivate,  
                        'unzip_zip': 'true',  # always true by default
                        'selected_org': self.selectedDataOrg,
                        'selected_resource_id': resourceID,
                        'create_csv': 'true',
                        
                        
                    }
                #headers
                headers = {
                    'Accept-Encoding': "gzip, deflate, br",
                    'Connection': "keep-alive"
                }

                #Authentification
                auth = (self.usr, self.pwd)

                with open(fichier, 'rb') as file:

                    # POST request
                    try:
                    
                        fichiers = {'upload_file': (fichier, file)}
                        response = requests.post(url, data=data, files=fichiers, headers=headers, auth=auth)

                        response.raise_for_status()

                        self.show_success_message(self.tr('Fichier exporté avec succès'))
                        self.window2.close()
                        
                    except requests.exceptions.RequestException as e:
                        # Gestion des erreurs de requête
                        self.show_error_message(f"Request error : {e}")

                    except requests.exceptions.HTTPError as e:
                        # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                        self.show_error_message(f"HTTP error : {e.response.status_code}")

                    except requests.exceptions.ConnectionError as e:
                        # Gestion des erreurs de connexion
                        self.show_error_message(f"Connection error : {e}")

                    except requests.exceptions.Timeout as e:
                        # Gestion des erreurs de délai d'attente
                        self.show_error_message(f"Expired request : : {e}")

                    except requests.exceptions.TooManyRedirects as e:
                        # Gestion des erreurs de redirections excessives
                        self.show_error_message(f"Too many redirects ! : : {e}")

                    except requests.exceptions.RequestException as e:
                        # Gestion générale des exceptions de requête
                        self.show_error_message(f"Request error : {e}")

                    except Exception as e:
                        # Gestion d'autres exceptions non spécifiques
                        self.show_error_message(f"Unhandled error occured: {e}")

                    except ConnectionAbortedError as e:
                        self.show_error_message(f"Server connection interrupt : {e}")

            else: 
                #display error message
                self.show_info_message(self.tr('Veuillez sélectionner une couche à exporter'))
            self.getD4Cdatasets()
        else:
            self.show_info_message(self.tr('Veuillez sélectionner une ressource à remplacer'))

    def save_layer_as_geojson(self, layer, output_geojson_path):
        project = QgsProject.instance()
        # Initialiser l'application QGIS
        QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
        Processing.initialize()
        if layer.type() == QgsMapLayer.VectorLayer and (layer.dataProvider().name() == 'memory' or layer.dataProvider().name() == 'postgres'):
            # We do not manage sanitized name colision (if your
            # layer name is the same, code will try to write to
            # a GPKG with the same name and the same layer...)
            layer_name = layer.name().lower().replace(' ', '_')
            out = Processing.runAlgorithm("native:savefeatures", {
                'INPUT': layer,
                'OUTPUT': output_geojson_path,
                'LAYER_NAME':'',
                'DATASOURCE_OPTIONS':'',
                'LAYER_OPTIONS':''}
            )
            layer.setDataSource(f"{out['OUTPUT']}", layer.name(), 'ogr')
        project.write()
       
    def show_error_message(self, message):
        error_box = QMessageBox()
        error_box.setIcon(QMessageBox.Critical)
        error_box.setWindowTitle('Erreur')
        error_box.setText(message)
        error_box.exec_()


    def show_success_message(self, message):
        success_box = QMessageBox()
        success_box.setIcon(QMessageBox.Information)
        success_box.setWindowTitle('Succès')
        success_box.setText(message)
        success_box.exec_()
    

    def show_info_message(self, message):
        info_box = QMessageBox()
        info_box.setIcon(QMessageBox.Information)
        info_box.setWindowTitle('Information')
        info_box.setText(message)
        info_box.exec_()

    # Sauvegarde les informations de session
    def saveSession(self):
        site_url = self.sit
        username = self.usr
        password = self.pwd

        encrypted_password = self.fernet.encrypt(password.encode())
        
        datasets = self.dlg.datasetId.toPlainText()

        # Set up the destination folder
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin'):
            os.makedirs(str(pathlib.Path.home() / '.d4cplugin'))
            
        # Chargez les sessions existantes depuis le fichier JSON # Modifier le chemin selon vos besoins
        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'
        
        if os.path.exists(json_file_path):
            with open(str(json_file_path), 'r') as json_file:
                data = json.load(json_file)
        else:
            data = {
                "last_session": {
                    "sessions": []
                },
                "lang": ""
            }
        
        # Ajoutez la nouvelle session aux données
        new_session = {
            "site_url": site_url,
            "username": username,
            "datasets": datasets,
            "password": str(encrypted_password),
        }
        # Vérifier si la nouvelle entrée est identique à une entrée existante  
        if "sessions" in data["last_session"] and data["last_session"]["sessions"]:
            for session in data["last_session"]["sessions"]:
                if session["site_url"] == new_session["site_url"] and session["username"] == new_session["username"] and session["datasets"] == new_session["datasets"]:
                    # Si l'entrée est identique, ne la sauvegarde pas à nouveau
                    return
            data["last_session"]["sessions"].insert(0, new_session)
        else:
            data["last_session"]["sessions"].insert(0, new_session)

        # Limitez le nombre de sessions à 10
        if len(data["last_session"]["sessions"]) > 10:
            data["last_session"]["sessions"].pop()  # Supprime la session la plus ancienne

        # Enregistrez les données mises à jour dans le fichier JSON
        with open(str(json_file_path), 'w') as json_file:
            json.dump(data, json_file, indent=4)

    # Sauvegarde les informations de sites
    def saveSites(self):
        site_url = self.sit
        username = self.usr
        password = self.pwd

        encrypted_password = self.fernet.encrypt(password.encode())
         # Set up the destination folder
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin'):
            os.makedirs(str(pathlib.Path.home() / '.d4cplugin'))

        sites_file_path = pathlib.Path.home() / '.d4cplugin' / 'sites.json'

        if os.path.exists(sites_file_path):
            # Charger les données JSON existantes
            with open(str(sites_file_path), 'r') as json_file:
                site_data = json.load(json_file)
        else:
            site_data = {
                "saved_sites": {
                    "sites": []
                }
            }

        # Vérifier si la nouvelle entrée est identique à une entrée existante
        for site_info in site_data["saved_sites"]["sites"]:
            if site_info.get("site_url") == site_url and site_info.get("username") == username:
                # Si l'entrée est identique, ne la sauvegarde pas à nouveau
                return

        # Ajouter la nouvelle entrée aux données
        new_site_info = {
            "site_url": site_url,
            "name" : "",
            "username": username,
            "password": str(encrypted_password),  # N'oubliez pas de chiffrer le mot de passe
        }
        site_data["saved_sites"]["sites"].append(new_site_info)

        # Enregistrer les données mises à jour dans le fichier sites.json
        with open(str(sites_file_path), 'w') as json_file:
            json.dump(site_data, json_file, indent=4)

    # Actualise la liste des fichiers importés
    def updateHistory(self):
        
        self.dlg.historyList.clear()
        # Définir le chemin du fichier JSON
                # Set up the destination folder
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin'):
            os.makedirs(str(pathlib.Path.home() / '.d4cplugin'))
            

        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'
        json_sites_file_path = pathlib.Path.home() / '.d4cplugin' / 'sites.json'

        if pathlib.Path.exists(json_file_path) and pathlib.Path.exists(json_sites_file_path):
            with open(str(json_file_path), 'r') as json_file:
                data = json.load(json_file)
                
        
            with open(str(json_sites_file_path), 'r') as json_sites_file:
                data_sites = json.load(json_sites_file)
    

            sessions = data["last_session"]["sessions"]
            sites = data_sites["saved_sites"]["sites"]
            for session in sessions:
                if session["site_url"] != None:
                    for site in sites:
                        if site["site_url"] == session["site_url"] and site["username"] == session["username"] and site["name"] != "":
                            item = QtWidgets.QListWidgetItem(site["name"] + ' => ' + session["datasets"])
                            
                            break
                    
                        item = QtWidgets.QListWidgetItem(session["site_url"] + ' - ' + session["username"] + ' => ' + session["datasets"])
                    self.dlg.historyList.addItem(item)    

    # Purger l'historique
    def clearHistory(self):
        file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'
        
        if file_path.is_file():
            os.remove(str(file_path))
        
            json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'
            data = {
                    "last_session": {
                        "sessions": []
                    },
                    "lang": "fr",
                    "folder_path" : self.saveFile_folder
                }
                        # Enregistrez les données mises à jour dans le fichier JSON
            with open(str(json_file_path), 'w') as json_file:
                    json.dump(data, json_file, indent=4)
            self.updateHistory()
        self.updateConfigFile()
        self.reloadBrowser()

    # Charge les informations de la session sélectionnée
    def loadPreviousSession(self):
        session = self.dlg.historyList.currentItem()
        session_name = session.text().split(' => ')[0]
        sessionNb = self.dlg.historyList.currentRow()
        # Set up the destination folder
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin'):
            os.makedirs(pathlib.Path.home() / '.d4cplugin')
            
        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'
        if not(session):
            return
        with open(str(json_file_path), 'r') as json_file:
            data = json.load(json_file)
            previousSit = data["last_session"]["sessions"][sessionNb]["site_url"]
            previousUsr = data["last_session"]["sessions"][sessionNb]["username"]
            previousDataset = data["last_session"]["sessions"][sessionNb]["datasets"]
            mdp = data["last_session"]["sessions"][sessionNb]["password"]
        
        mdp = self.fernet.decrypt(mdp[1:-1])
        mdp = mdp.decode('utf-8')
        self.pwd = mdp
        self.sit = previousSit
        self.usr = previousUsr
        self.dlg.datasetId.setPlainText(previousDataset)
        self.dlg.siteField.setPlainText(previousSit) 
        self.dlg.userLabel_2.setText(previousUsr)
        self.dlg.sessionLabel_2.setText(session_name)

        self.getD4Cdatasets()


    def openAddDatasetWindow(self):
        if not self.dlg.layersList.currentItem():
            self.show_info_message(self.tr('Veuillez sélectionner une couche à exporter'))
            return
        self.window3 = QtWidgets.QDialog()
        self.ui3 = Ui_Dialog()
        self.ui3.setupUi(self.window3)
        site = self.sit + "/d4c/api/datasets/2.0/search/rows=1000&start=0"
        
        try: 
            org_list = requests.get(site)
            if org_list.status_code == 200:
                data = org_list.json()
                keyword_list = []
                theme_list = []

                for org in data['all_organizations']:
                    self.ui3.orgCombobox.addItem(org['name'])
                
                for dataset in data['result']['results']:
                    for keyword in dataset['tags']:
                        if keyword['name'] not in keyword_list:
                            keyword_list.append(keyword['name'])
                
                    for extra in dataset['extras']:
                        if extra['key'] == 'themes':
                            themes = json.loads(extra['value'])
                            for theme in themes:
                                if theme not in theme_list:
                                    theme_list.append(theme)
                
                sites_file_path = pathlib.Path.home() / '.d4cplugin' / 'sites.json'

                with open(str(sites_file_path), 'r') as json_file:
                    site_data = json.load(json_file)
                sites = site_data["saved_sites"]["sites"]
                i = 0
                for site in sites:
                    self.ui3.comboBox.addItem(site["name"])
                    if site["password"] == "":
                        #disable the item
                        self.ui3.comboBox.model().item(i).setEnabled(False)
                    i+=1
                        
                self.ui3.comboBox.setCurrentIndex(self.currentSiteIndex())
                
                self.ui3.scrollAreaWidgetContents.setLayout(self.ui3.scrollLayout2)
                self.ui3.scrollAreaWidgetContents_2.setLayout(self.ui3.scrollLayout3)
                
                for theme in theme_list:
                    checkbox = QtWidgets.QCheckBox(theme)
                    checkbox.setObjectName(theme)
                    self.ui3.themes_checkboxes.append(checkbox)
                    self.ui3.scrollLayout2.addWidget(checkbox)

                for keyword in keyword_list:
                    checkbox = QtWidgets.QCheckBox(keyword)
                    checkbox.setObjectName(keyword)
                    self.ui3.tags_checkboxes.append(checkbox)
                    self.ui3.scrollLayout3.addWidget(checkbox)
                
                self.ui3.comboBox.currentIndexChanged.connect(self.changeSite)
                self.ui3.keywordSearch.textChanged.connect(self.filter_keywords)
                self.ui3.dataset_entered.datasetEntered.connect(self.addDataset)
                self.ui3.pushExit.clicked.connect(self.window3.close)
                self.window3.exec_()
            else:
                self.show_error_message(self.tr('Erreur lors de la récupération des organisations'))
                return
        except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

        except requests.exceptions.HTTPError as e:
            # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
            self.show_error_message(f"HTTP error : {e.response.status_code}")

        except requests.exceptions.ConnectionError as e:
            # Gestion des erreurs de connexion
            self.show_error_message(f"Connection error : {e}")

        except requests.exceptions.Timeout as e:
            # Gestion des erreurs de délai d'attente
            self.show_error_message(f"Expired request : : {e}")

        except requests.exceptions.TooManyRedirects as e:
            # Gestion des erreurs de redirections excessives
            self.show_error_message(f"Too many redirects ! : : {e}")

        except requests.exceptions.RequestException as e:
            # Gestion générale des exceptions de requête
            self.show_error_message(f"Request error : {e}")

        except Exception as e:
            # Gestion d'autres exceptions non spécifiques
            self.show_error_message(f"Unhandled error occured: {e}")

    def filter_keywords(self):

        # Filtrer les éléments en fonction du texte de recherche
        search_text = self.ui3.keywordSearch.text().strip().lower()

        for index in range(self.ui3.scrollLayout3.count()):
            item = self.ui3.scrollLayout3.itemAt(index).widget()

            if isinstance(item, QtWidgets.QCheckBox):
                item_text = item.text().lower()
                item.setHidden(search_text not in item_text)

    # filter_keywords mais pour les métadatas
    def filter_keywords_md(self):

        # Filtrer les éléments en fonction du texte de recherche
        search_text = self.uimd.keywordSearch.text().strip().lower()

        for index in range(self.uimd.scrollLayout3.count()):
            item = self.uimd.scrollLayout3.itemAt(index).widget()

            if isinstance(item, QtWidgets.QCheckBox):
                item_text = item.text().lower()
                item.setHidden(search_text not in item_text)

    def clearLayout(self, layout):
        while layout.count():
            item = layout.takeAt(0)
            widget = item.widget()
            if widget is not None:
                widget.deleteLater()

    def changeSite(self):
        itemNb = self.ui3.comboBox.currentIndex()
        self.ui3.orgCombobox.clear()

        self.ui3.themes_checkboxes = []
        self.ui3.tags_checkboxes = []
        # Efface le contenu de scrollLayout2
        self.clearLayout(self.ui3.scrollLayout2)
        
        # Efface le contenu de scrollLayout3
        self.clearLayout(self.ui3.scrollLayout3)

        if itemNb != -1:
            sites_file_path = pathlib.Path.home() / '.d4cplugin' / 'sites.json'

            with open(str(sites_file_path), 'r') as json_file:
                site_data = json.load(json_file)
                sites = site_data["saved_sites"]["sites"]
                self.sit = sites[itemNb]["site_url"]
                self.usr = sites[itemNb]["username"]
                self.pwd = self.fernet.decrypt(sites[itemNb]["password"][1:-1])
                self.pwd = self.pwd.decode('utf-8')
                self.dlg.siteField.setPlainText(self.sit)
            site = self.sit + "/d4c/api/datasets/2.0/search?start=0&rows=1000"
        
            try: 
                org_list = requests.get(site)


                if org_list.status_code == 200:
                    data = org_list.json()
                    keyword_list = []
                    theme_list = []

                    for org in data['all_organizations']:
                        self.ui3.orgCombobox.addItem(org['name'])
                    
                    for dataset in data['result']['results']:
                        for keyword in dataset['tags']:
                            if keyword['name'] not in keyword_list:
                                keyword_list.append(keyword['name'])
                    
                        for extra in dataset['extras']:
                            if extra['key'] == 'themes':
                                themes = json.loads(extra['value'])
                                for theme in themes:
                                    if theme not in theme_list:
                                        theme_list.append(theme)
                    
                                
                    self.ui3.scrollAreaWidgetContents.setLayout(self.ui3.scrollLayout2)
                    self.ui3.scrollAreaWidgetContents_2.setLayout(self.ui3.scrollLayout3)
                    
                    for theme in theme_list:
                        checkbox = QtWidgets.QCheckBox(theme)
                        checkbox.setObjectName(theme)
                        self.ui3.themes_checkboxes.append(checkbox)
                        self.ui3.scrollLayout2.addWidget(checkbox)

                    for keyword in keyword_list:
                        checkbox = QtWidgets.QCheckBox(keyword)
                        checkbox.setObjectName(keyword)
                        self.ui3.tags_checkboxes.append(checkbox)
                        self.ui3.scrollLayout3.addWidget(checkbox)

            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

            except requests.exceptions.HTTPError as e:
                # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                self.show_error_message(f"HTTP error : {e.response.status_code}")

            except requests.exceptions.ConnectionError as e:
                # Gestion des erreurs de connexion
                self.show_error_message(f"Connection error : {e}")

            except requests.exceptions.Timeout as e:
                # Gestion des erreurs de délai d'attente
                self.show_error_message(f"Expired request : : {e}")

            except requests.exceptions.TooManyRedirects as e:
                # Gestion des erreurs de redirections excessives
                self.show_error_message(f"Too many redirects ! : : {e}")

            except requests.exceptions.RequestException as e:
                # Gestion générale des exceptions de requête
                self.show_error_message(f"Request error : {e}")

            except Exception as e:
                # Gestion d'autres exceptions non spécifiques
                self.show_error_message(f"Unhandled error occured: {e}")


    def addDataset(self, name, org, private):

        # get the index of the selected resource
        index = self.dlg.layersList.currentIndex()
        themes_checked = []
        for checkbox in self.ui3.themes_checkboxes:
            if checkbox.isChecked():
                themes_checked.append(checkbox.objectName())
        keywords_checked = []
        for checkbox in self.ui3.tags_checkboxes:
            if checkbox.isChecked():
                keywords_checked.append(checkbox.objectName())
        
        #create string for themes (and extras)
        
        extras_str = "{\"themes\":\"["
        for theme in themes_checked:
            extras_str += '\\\"' + theme + '\\\",'
        if themes_checked == []:
            extras_str = "{\"themes\":\"[]\""
        else:
            extras_str = extras_str[:-1] + "]\""

        if not(self.ui3.hideInCatalogue.isChecked()) and not(self.ui3.hideInGraph.isChecked()) and not(self.ui3.hideInMap.isChecked):
            extras_str += '}'
        else:
            if self.ui3.hideInCatalogue.isChecked():
                extras_str += ',\"dataset_not_visible\":"1",'
            else:
                extras_str += ',\"dataset_not_visible\":"0",'
            if self.ui3.hideInGraph.isChecked():
                extras_str += '\"not_visible_in_chart_interface\":"1",'
            else:
                extras_str += '\"not_visible_in_chart_interface\":"0",'
            if self.ui3.hideInMap.isChecked():
                extras_str += '\"not_visible_in_map_interface\":"1",'
            else:
                extras_str += '\"not_visible_in_map_interface\":"0",'
            extras_str = extras_str[:-1] + '}'



        #create string for keywords
        keywords_str = "["
        for keyword in keywords_checked:
            keywords_str += '\"' + keyword + '\",'
        keywords_str = keywords_str[:-1] + "]"

        data = {
            'name': name,
            'title': name,
            'selected_private': private,
            'selected_org': org,
            'extras': extras_str,
            'tags': keywords_str            
        }

        url = self.sit + '/d4c/api/v1/dataset/manage'

        auth = (self.usr, self.pwd)

        try: 
            response = requests.post(url, data=data, auth=auth)

            if response.status_code == 200:
                response = response.json()
                if response['status'] == "error":
                    self.show_error_message(self.tr('Erreur lors de la création du dataset'))
                else:
                    self.show_success_message(self.tr('Dataset ajouté avec succès'))

                    self.dlg.datasetId.setPlainText(response['result'])
                    self.dlg.exportLine.setPlainText(response['result'])
                    
                    self.getD4Cdatasets()
                    self.dlg.layersList.setCurrentIndex(index)
                    self.window3.close()
                    self.exportAsNewResource()
                    
        except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

        except requests.exceptions.HTTPError as e:
            # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
            self.show_error_message(f"HTTP error : {e.response.status_code}")

        except requests.exceptions.ConnectionError as e:
            # Gestion des erreurs de connexion
            self.show_error_message(f"Connection error : {e}")

        except requests.exceptions.Timeout as e:
            # Gestion des erreurs de délai d'attente
            self.show_error_message(f"Expired request : : {e}")

        except requests.exceptions.TooManyRedirects as e:
            # Gestion des erreurs de redirections excessives
            self.show_error_message(f"Too many redirects ! : : {e}")

        except requests.exceptions.RequestException as e:
            # Gestion générale des exceptions de requête
            self.show_error_message(f"Request error : {e}")

        except Exception as e:
            # Gestion d'autres exceptions non spécifiques
            self.show_error_message(f"Unhandled error occured: {e}")
    

    def deleteResource(self):
        
        self.isDelete = True
        self.showExistingResources()
        

    def deleteResource_selected(self, resource_name):
        # Créez une boîte de dialogue de confirmation
        confirmation = QMessageBox()
        confirmation.setIcon(QMessageBox.Question)
        confirmation.setWindowTitle("Confirmation")
        confirmation.setText("Êtes-vous sûr de vouloir supprimer la ressource ? Cette action est irréversible.")

        # Ajoutez les boutons "Continuer" et "Annuler"
        confirmation.addButton(QMessageBox.Ok)
        confirmation.addButton(QMessageBox.Cancel)

        # Affichez la boîte de dialogue et attendez la réponse de l'utilisateur
        response = confirmation.exec_()

        # Vérifiez la réponse de l'utilisateur
        if response == QMessageBox.Ok:
            # L'utilisateur a choisi de continuer, vous pouvez appeler la fonction de suppression ici
            if resource_name != '':
                resourceID = self.listExistingResourceById[resource_name]

                url = self.dlg.siteField.toPlainText()+ '/d4c/api/v1/dataset/resource_remove'

                data = {
                    'resource_id': resourceID,
                }

                try: 

                    response = requests.post(url, data=data, auth=(self.usr, self.pwd))

                    if response.status_code == 200:
                        response = response.json()
                        if response['status'] == "error":
                            self.show_error_message(self.tr('Erreur lors de la suppression de la ressource'))
                        else:
                            self.show_success_message(self.tr('Ressource supprimée avec succès'))
                            self.getD4Cdatasets()
                            self.window2.close()

                except requests.exceptions.RequestException as e:
                    # Gestion des erreurs de requête
                    self.show_error_message(f"Request error : {e}")

                except requests.exceptions.HTTPError as e:
                    # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                    self.show_error_message(f"HTTP error : {e.response.status_code}")

                except requests.exceptions.ConnectionError as e:
                    # Gestion des erreurs de connexion
                    self.show_error_message(f"Connection error : {e}")

                except requests.exceptions.Timeout as e:
                    # Gestion des erreurs de délai d'attente
                    self.show_error_message(f"Expired request : : {e}")

                except requests.exceptions.TooManyRedirects as e:
                    # Gestion des erreurs de redirections excessives
                    self.show_error_message(f"Too many redirects ! : : {e}")

                except requests.exceptions.RequestException as e:
                    # Gestion générale des exceptions de requête
                    self.show_error_message(f"Request error : {e}")

                except Exception as e:
                    # Gestion d'autres exceptions non spécifiques
                    self.show_error_message(f"Unhandled error occured: {e}")

                except ConnectionAbortedError as e:
                    self.show_error_message(f"Server connection interrupt : {e}")
        else:
            # L'utilisateur a choisi d'annuler, ne faites rien ou effectuez une action d'annulation si nécessaire
            pass
           
    
    def deleteDataset(self):
    
        # Créez une boîte de dialogue de confirmation
        confirmation = QMessageBox()
        confirmation.setIcon(QMessageBox.Question)
        confirmation.setWindowTitle("Confirmation")
        confirmation.setText("Êtes-vous sûr de vouloir supprimer le Jeu de Donnée ? Cette action est irréversible.")

        # Ajoutez les boutons "Continuer" et "Annuler"
        confirmation.addButton(QMessageBox.Ok)
        confirmation.addButton(QMessageBox.Cancel)

        # Affichez la boîte de dialogue et attendez la réponse de l'utilisateur
        response = confirmation.exec_()

        # Vérifiez la réponse de l'utilisateur
        if response == QMessageBox.Ok:
            url = self.dlg.siteField.toPlainText()+ '/d4c/api/v1/dataset/remove'

            data = {
                'dataset_id' : self.currentDataset_id
            }

            auth = (self.usr, self.pwd)

            try:

                response = requests.post(url, data=data, auth=auth)

                if response.status_code == 200:
                    response = response.json()
                    if response['status'] == "error":
                        self.show_error_message(self.tr('Erreur lors de la suppression du dataset'))
                    else:
                        self.show_success_message(self.tr('Dataset supprimé avec succès'))
                        # delete in sessions file
                        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'
                        if pathlib.Path.exists(json_file_path):
                            with open(str(json_file_path), 'r') as json_file:
                                data = json.load(json_file)
                            sessions = data["last_session"]["sessions"]
                            i = 0
                            for session in sessions:
                                if session["datasets"] == self.dlg.datasetId.toPlainText():
                                    sessions.pop(i)
                                            # Enregistrez les données mises à jour dans le fichier JSON
                                    with open(str(json_file_path), 'w') as json_file:
                                        json.dump(data, json_file, indent=4)
                                    break
                                i+=1
                        self.updateHistory()
                       
                       
                        self.dlg.datasetId.setPlainText('')
                        self.dlg.exportLine.setPlainText('')
                        self.dlg.resourcesList.clear()
                        
                        self.resetVariablesForDataset()
                else:
                    self.show_error_message('Error : ' + str(response.status_code))
            
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

            except requests.exceptions.HTTPError as e:
                # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                self.show_error_message(f"HTTP error : {e.response.status_code}")

            except requests.exceptions.ConnectionError as e:
                # Gestion des erreurs de connexion
                self.show_error_message(f"Connection error : {e}")

            except requests.exceptions.Timeout as e:
                # Gestion des erreurs de délai d'attente
                self.show_error_message(f"Expired request : : {e}")

            except requests.exceptions.TooManyRedirects as e:
                # Gestion des erreurs de redirections excessives
                self.show_error_message(f"Too many redirects ! : : {e}")

            except requests.exceptions.RequestException as e:
                # Gestion générale des exceptions de requête
                self.show_error_message(f"Request error : {e}")

            except Exception as e:
                # Gestion d'autres exceptions non spécifiques
                self.show_error_message(f"Unhandled error occured: {e}")

            except ConnectionAbortedError as e:
                self.show_error_message(f"Server connection interrupt : {e}")
        
        else:
            # L'utilisateur a choisi d'annuler, ne faites rien ou effectuez une action d'annulation si nécessaire
            pass


    def showInfoWindow(self):
        self.windowInfo = QtWidgets.QDialog()
        self.uiInfo = Ui_showInfos()
        self.uiInfo.setupUi(self.windowInfo)
        self.uiInfo.datasetTitlefield.setPlainText(self.data_title)
        self.uiInfo.datasetAuthorfield.setPlainText(self.data_author)
        self.uiInfo.datasetOrgfield.setPlainText(self.data_org)
        self.uiInfo.datasetLicensefield.setPlainText(self.data_license)
        self.uiInfo.datasetPrivatefield.setPlainText(str(self.data_private))
        self.uiInfo.datasetUrlfield.setPlainText(self.data_url)
        self.uiInfo.pushChangeMD.clicked.connect(self.changeMetadata)
        self.uiInfo.closeInfos.clicked.connect(self.windowInfo.close)
        self.windowInfo.exec_()

    def changeMetadata(self):
        self.windowmd = QtWidgets.QDialog()
        self.uimd = Ui_changeMetadatas()
        self.uimd.setupUi(self.windowmd)
        site = self.sit + "/d4c/api/datasets/2.0/search/rows=1000&start=0"
        
        try: 
            org_list = requests.get(site)


            if org_list.status_code == 200:
                data = org_list.json()
                keyword_list = []
                theme_list = []

                for org in data['all_organizations']:
                    self.uimd.orgCombobox.addItem(org['name'])
                
                for dataset in data['result']['results']:
                    for keyword in dataset['tags']:
                        if keyword['name'] not in keyword_list:
                            keyword_list.append(keyword['name'])
                
                    for extra in dataset['extras']:
                        if extra['key'] == 'themes':
                            themes = json.loads(extra['value'])
                            for theme in themes:
                                if theme not in theme_list:
                                    theme_list.append(theme)
            self.uimd.scrollAreaWidgetContents.setLayout(self.uimd.scrollLayout2)
            self.uimd.scrollAreaWidgetContents_2.setLayout(self.uimd.scrollLayout3)

            for theme in theme_list:
                    checkbox = QtWidgets.QCheckBox(theme)
                    checkbox.setObjectName(theme)
                    self.uimd.themes_checkboxes.append(checkbox)
                    self.uimd.scrollLayout2.addWidget(checkbox)

            for keyword in keyword_list:
                checkbox = QtWidgets.QCheckBox(keyword)
                checkbox.setObjectName(keyword)
                self.uimd.tags_checkboxes.append(checkbox)
                self.uimd.scrollLayout3.addWidget(checkbox)
            
            # Charger les données existantes

            self.uimd.newDatasetName.setText(self.data_title)
            

            if str(self.data_private) == 'True':
                self.uimd.checkPrivate.setChecked(True)
            else:
                self.uimd.checkPrivate.setChecked(False)
            url = self.sit + '/d4c/api/v1/dataset/find'

            data = {
                'dataset_id': self.currentDataset_id
            }


            response = requests.post(url, data=data, auth=(self.usr, self.pwd))
            if response.status_code == 200:
                response = response.json()
                if response['status'] == "error":
                    self.show_error_message(self.tr('Erreur lors de la récupération des métadonnées'))
                else:
                    
                    self.uimd.lic = response['result']['license_id']
                    self.uimd.desc = response['result']['notes']
                    org = response['result']['organization']['name']
                    self.uimd.orgCombobox.setCurrentText(org)

                    for extra in response['result']['extras']:
                        if extra['key'] == 'themes':
                            themes = json.loads(extra['value'])
                            for theme in themes:
                                for checkbox in self.uimd.themes_checkboxes:
                                    if checkbox.objectName() == theme:
                                        checkbox.setChecked(True)
                        elif extra['key'] == 'dataset_not_visible':
                            if extra['value'] == '1':
                                self.uimd.hideInCatalogue.setChecked(True)
                        elif extra['key'] == 'not_visible_in_chart_interface':
                            if extra['value'] == '1':
                                self.uimd.hideInGraph.setChecked(True)
                        elif extra['key'] == 'not_visible_in_map_interface':
                            if extra['value'] == '1':
                                self.uimd.hideInMap.setChecked(True)
                    for tag in response['result']['tags']:
                        for checkbox in self.uimd.tags_checkboxes:
                            if checkbox.objectName() == tag['name']:
                                checkbox.setChecked(True)
           
            
            else:
                self.show_error_message(self.tr('Erreur lors de la récupération des métadonnées'))
                return  
            
            self.uimd.pushOk.clicked.connect(self.changeMetadata_request)
            self.uimd.pushCancel.clicked.connect(self.windowmd.close)
            self.uimd.keywordSearch.textChanged.connect(self.filter_keywords_md)  
            self.uimd.checkChecked.stateChanged.connect(self.displayChecked_md)
            self.windowmd.exec_()

        except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

    def displayChecked_md(self):

        if self.uimd.checkChecked.isChecked():
            for checkbox in self.uimd.tags_checkboxes:
                if not(checkbox.isChecked()):
                    checkbox.setHidden(True)
        else:
            for checkbox in self.uimd.tags_checkboxes:
                checkbox.setHidden(False)
        
    def changeMetadata_request(self):

        themes_checked = []
        for checkbox in self.uimd.themes_checkboxes:
            if checkbox.isChecked():
                themes_checked.append(checkbox.objectName())
        keywords_checked = []
        for checkbox in self.uimd.tags_checkboxes:
            if checkbox.isChecked():
                keywords_checked.append(checkbox.objectName())
        
        #create string for themes (and extras)
        extras_str = "{\"themes\":\"["
        for theme in themes_checked:
            extras_str += '\\\"' + theme + '\\\",'
        extras_str = extras_str[:-1] + "]\""

        if not(self.uimd.hideInCatalogue.isChecked()) and not(self.uimd.hideInGraph.isChecked()) and not(self.uimd.hideInMap.isChecked):
            extras_str += '}'
        else:
            if self.uimd.hideInCatalogue.isChecked():
                extras_str += ',\"dataset_not_visible\":"1",'
            else:
                extras_str += ',\"dataset_not_visible\":"0",'
            if self.uimd.hideInGraph.isChecked():
                extras_str += '\"not_visible_in_chart_interface\":"1",'
            else:
                extras_str += '\"not_visible_in_chart_interface\":"0",'
            if self.uimd.hideInMap.isChecked():
                extras_str += '\"not_visible_in_map_interface\":"1",'
            else:
                extras_str += '\"not_visible_in_map_interface\":"0",'
            extras_str = extras_str[:-1] + '}'

        if self.uimd.checkPrivate.isChecked():
            private = 'true'
        else:
            private = 'false'
        
        org = self.uimd.orgCombobox.currentText()

        #create string for keywords
        keywords_str = "["
        for keyword in keywords_checked:
            keywords_str += '\"' + keyword + '\",'
        keywords_str = keywords_str[:-1] + "]"

        data = {
            'name': self.uimd.newDatasetName.text(),
            'title': self.uimd.newDatasetName.text(),
            'selected_private': private,
            'selected_org': org,
            'extras': extras_str,
            'tags': keywords_str,
            'dataset_id': self.currentDataset_id,
            'description': self.uimd.desc,
            'selected_lic': self.uimd.lic,

        }

        url = self.sit + '/d4c/api/v1/dataset/manage'

        auth = (self.usr, self.pwd)

        try: 
            response = requests.post(url, data=data, auth=auth)

            if response.status_code == 200:
                response = response.json()
                if response['status'] == "error":
                    self.show_error_message(self.tr('Erreur lors de la modification du dataset'))
                else:
                    self.show_success_message(self.tr('Dataset modifié avec succès'))
                    self.dlg.datasetId.setPlainText(response['result'])
                    self.dlg.exportLine.setPlainText(response['result'])
                    self.getD4Cdatasets()
                    self.windowmd.close()
        except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

        except requests.exceptions.HTTPError as e:
            # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
            self.show_error_message(f"HTTP error : {e.response.status_code}")

        except requests.exceptions.ConnectionError as e:
            # Gestion des erreurs de connexion
            self.show_error_message(f"Connection error : {e}")

        except requests.exceptions.Timeout as e:
            # Gestion des erreurs de délai d'attente
            self.show_error_message(f"Expired request : : {e}")

        except requests.exceptions.TooManyRedirects as e:
            # Gestion des erreurs de redirections excessives
            self.show_error_message(f"Too many redirects ! : : {e}")

        except requests.exceptions.RequestException as e:
            # Gestion générale des exceptions de requête
            self.show_error_message(f"Request error : {e}")

        except Exception as e:
            # Gestion d'autres exceptions non spécifiques
            self.show_error_message(f"Unhandled error occured: {e}")

    def updateLastimportedfiles(self):
        files_path = self.saveFile_folder
        files = os.listdir(files_path)

        self.dlg.filesList.clear()
        for file in files:
            if file.endswith('.csv') or file.endswith('.geojson') or file.endswith('.json'):
                self.dlg.filesList.addItem(file)
        
    # ouvre l'emplacement des fichiers importés
    def openResourceFile(self):
        os.startfile(self.saveFile_folder)

    # Ouvre une ressource déjà téléchargée dans qgis
    def openResourcefromFile(self):
        
        item = self.dlg.filesList.selectedItems()
        items = [item.text() for item in self.dlg.filesList.selectedItems()]
        
        if items != []:
            for item in items:
                file_name = item
                destination_path = self.plugin_dir / 'resources' / file_name
                if file_name.endswith('.csv'):
                    self.importCSV(str(destination_path), file_name)
                elif file_name.endswith('.geojson'):
                    self.importGEOJSON(str(destination_path), file_name)
                elif file_name.endswith('.json'):
                    self.importJSON(str(destination_path), file_name)
                else:
                    continue
        
          
    def openAllDatasets(self):
        self.dlg.setEnabled(False)
        self.windowAllDatasets = QtWidgets.QDialog()
        self.uiAllDatasets = Ui_searchDataset()
        self.uiAllDatasets.setupUi(self.windowAllDatasets)
        self.uiAllDatasets.checkDisplayGeo.setChecked(True)
        self.uiAllDatasets.datasetAllList.setSelectionMode(QtWidgets.QAbstractItemView.ExtendedSelection)
        self.uiAllDatasets.datasetAllList.setGridSize(QtCore.QSize(100, 70))
        self.uiAllDatasets.datasetAllList.setWordWrap(True)

        urlNoAuth = self.dlg.siteField.toPlainText()+ '/d4c/api/datasets/2.0/search?start=0&rows=1000'
        urlAuth = self.dlg.siteField.toPlainText()+ '/d4c/api/datasets/2.0/search?start=0&rows=1000&include_private=true'

        # if user has a password
        if self.pwd != '':
            url = urlAuth
        else:
            url = urlNoAuth
         
        if not(self.isAlldatasetsLoaded):
            self.Alldatasetlist = []
            try:
                self.show_info_message(self.tr(u'Veuillez patienter pendant le chargement des données'))
                
                response = requests.get(url)

            # [nom][format][tags][themes][organisation]
                if response.status_code == 200:
                    data = response.json()
                    data_fill = []
                    format_fill = []
                    tags_fill = []
                    themefound = False
                    for dataset in data['result']['results']:
                        if dataset['state'] == 'active':
                            data_fill.append(dataset['title'])
                            for resource in dataset['resources']:
                                if resource['name'].endswith('.geojson'):
                                    format_fill.append('GeoJSON')
                                if resource['name'].endswith('.csv') and 'geo' in dataset['metas']['features']:
                                    format_fill.append('csvGEO')
                                else:
                                    format_fill.append(resource['format'])
                            data_fill.append(format_fill)
                            for tag in dataset['tags']:
                                tags_fill.append(tag['name'])
                            data_fill.append(tags_fill)
                            for extra in dataset['extras']:
                                if extra['key'] == 'themes':
                                    themefound = True
                                    themes = json.loads(extra['value'])
                                    if isinstance(themes, list):
                                        data_fill.append(themes)
                                    else:
                                        data_fill.append(extra['value'])
                            if not(themefound):
                                data_fill.append([])
                            data_fill.append(dataset['organization']['title'])
                            data_fill.append(dataset['name'])
                            self.Alldatasetlist.append(data_fill)
                            data_fill = []
                            format_fill = []
                            tags_fill = []
                            themefound = False
                    self.isAlldatasetsLoaded = True

            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

            except requests.exceptions.HTTPError as e:
                # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                self.show_error_message(f"HTTP error : {e.response.status_code}")

            except requests.exceptions.ConnectionError as e:
                # Gestion des erreurs de connexion
                self.show_error_message(f"Connection error : {e}")

            except requests.exceptions.Timeout as e:
                # Gestion des erreurs de délai d'attente
                self.show_error_message(f"Expired request : : {e}")

            except requests.exceptions.TooManyRedirects as e:
                # Gestion des erreurs de redirections excessives
                self.show_error_message(f"Too many redirects ! : : {e}")

            except requests.exceptions.RequestException as e:
                # Gestion générale des exceptions de requête
                self.show_error_message(f"Request error : {e}")

            except Exception as e:
                # Gestion d'autres exceptions non spécifiques
                self.show_error_message(f"Unhandled error occured: {e}") 
      
        self.uiAllDatasets.datasetAllList.setIconSize(QtCore.QSize(24, 24))
        for i in range(len(self.Alldatasetlist)):
            if "GeoJSON" in self.Alldatasetlist[i][1] or "csvGEO" in self.Alldatasetlist[i][1]:
                item = QtWidgets.QListWidgetItem(self.Alldatasetlist[i][0])
                #get the width of the item
                itemWidth = self.uiAllDatasets.datasetAllList.sizeHintForColumn(0)
                item.setSizeHint(QtCore.QSize(itemWidth, 70))
                item.setIcon(self.geojson_icon)
                item.setToolTip(self.Alldatasetlist[i][0])
                self.uiAllDatasets.datasetAllList.addItem(item)
            else:
                item = QtWidgets.QListWidgetItem(self.Alldatasetlist[i][0])
                itemWidth = self.uiAllDatasets.datasetAllList.sizeHintForColumn(0)
                item.setSizeHint(QtCore.QSize(itemWidth, 70))
                item.setToolTip(self.Alldatasetlist[i][0])
                self.uiAllDatasets.datasetAllList.addItem(item)

        themes_set = set(theme for dataset in self.Alldatasetlist for theme in dataset[3])

        organizations_set = set(dataset[4] for dataset in self.Alldatasetlist)

        tags_set = set(tag for dataset in self.Alldatasetlist for tag in dataset[2])

        self.uiAllDatasets.dynamic_taglist = []

        self.uiAllDatasets.alldatasets = self.Alldatasetlist

        self.uiAllDatasets.scrollAreaWidgetContents_3.setLayout(self.uiAllDatasets.scrollLayout2)
        self.uiAllDatasets.scrollAreaWidgetContents_4.setLayout(self.uiAllDatasets.scrollLayout3)

        if self.dlg.languageBox.currentIndex() == 0:
            self.uiAllDatasets.comboBox.addItem("Choisir une organisation")
        else:
            self.uiAllDatasets.comboBox.addItem("Choose an organization")

        for organization in organizations_set:
            self.uiAllDatasets.comboBox.addItem(organization)
        self.uiAllDatasets.comboBox.setCurrentIndex(0)
        
        self.uiAllDatasets.themes_checkboxes = []
        for theme in themes_set:
            checkbox = QtWidgets.QCheckBox(theme)
            checkbox.setObjectName(theme)
            self.uiAllDatasets.themes_checkboxes.append(checkbox)
            self.uiAllDatasets.scrollLayout2.addWidget(checkbox)
        
        self.uiAllDatasets.tags_checkboxes = []
        for tag in tags_set:
            checkbox = QtWidgets.QCheckBox(tag)
            checkbox.setObjectName(tag)
            self.uiAllDatasets.tags_checkboxes.append(checkbox)
            self.uiAllDatasets.scrollLayout3.addWidget(checkbox)

        self.dlg.setEnabled(True) 
        # Connect different actions
        self.uiAllDatasets.checkDisplayGeo.setChecked(True)
        self.filterNonGeo(Qt.Checked)
        self.uiAllDatasets.checkDisplayGeo.stateChanged.connect(self.filterNonGeo)
        self.uiAllDatasets.pushFilter.clicked.connect(self.resetFilters)
        self.uiAllDatasets.lineSearchTags.textChanged.connect(self.filter_keywords_AllDatasets)
        
        self.uiAllDatasets.datasetAllList.itemSelectionChanged.connect(self.detectMultipleSelection)


        for checkbox in self.uiAllDatasets.themes_checkboxes + self.uiAllDatasets.tags_checkboxes:
            checkbox.stateChanged.connect(self.filterDatasetviaCheckbox)
        self.uiAllDatasets.comboBox.currentTextChanged.connect(self.filterDatasetviaCheckbox)
        self.uiAllDatasets.pushClose.clicked.connect(self.windowAllDatasets.close)
        self.uiAllDatasets.searchBarFilter.textChanged.connect(self.filterAllDatasets)
        self.uiAllDatasets.search_dataset.datasetEntered.connect(self.getD4CdatasetsfromAll)
        self.uiAllDatasets.checkAz.stateChanged.connect(self.sortDatasetAz)
        self.uiAllDatasets.checkZa.stateChanged.connect(self.sortDatasetZa)
        self.windowAllDatasets.exec_()

    def filter_keywords_AllDatasets(self):

        search_text = self.uiAllDatasets.lineSearchTags.text().strip().lower()

        for index in range(self.uiAllDatasets.scrollLayout3.count()):
            item = self.uiAllDatasets.scrollLayout3.itemAt(index).widget()

            if isinstance(item, QtWidgets.QCheckBox):
                item_text = item.text().lower()
                item.setHidden(search_text not in item_text)

    def detectMultipleSelection(self):
        if len(self.uiAllDatasets.datasetAllList.selectedItems()) > 1:
            self.uiAllDatasets.pushSelectDataset.setText("Sélection multiple")
            self.uiAllDatasets.pushSelectDataset.setGeometry(QtCore.QRect(250, 440, 101, 23))
        else:
            self.uiAllDatasets.pushSelectDataset.setText("Sélectionner")
            self.uiAllDatasets.pushSelectDataset.setGeometry(QtCore.QRect(250, 440, 81, 23))

    def filterAllDatasets(self):
        
        search_text = self.uiAllDatasets.searchBarFilter.text().strip().lower()
        # Parcourir les éléments du QListWidget
        for index in range(self.uiAllDatasets.datasetAllList.count()):
            item = self.uiAllDatasets.datasetAllList.item(index)
            item_text = item.text().lower()

            if self.uiAllDatasets.checkDisplayGeo.isChecked():
            # Vérifier si le texte de l'élément correspond à la recherche
                if not item.icon().isNull():
                    if search_text in item_text:
                        item.setHidden(False)
                    else:
                        item.setHidden(True)
            else:
                if search_text in item_text:
                    item.setHidden(False)
                else:
                    item.setHidden(True)


    def sortDatasetAz(self, state):
        if state == Qt.Checked:
            self.uiAllDatasets.datasetAllList.sortItems(Qt.AscendingOrder)
            self.uiAllDatasets.checkZa.setChecked(False)
        else:
            if not(self.uiAllDatasets.checkZa.isChecked() or self.uiAllDatasets.checkAz.isChecked()):
                self.filterDatasetviaCheckbox()
            


    def sortDatasetZa(self, state):
        if state == Qt.Checked:
            self.uiAllDatasets.datasetAllList.sortItems(Qt.DescendingOrder)
            self.uiAllDatasets.checkAz.setChecked(False)
        else:
            if not(self.uiAllDatasets.checkZa.isChecked() or self.uiAllDatasets.checkAz.isChecked()):
                self.filterDatasetviaCheckbox()

    def filterDatasetviaCheckbox(self):
        
        # Récupérez l'état de toutes les QCheckBox pour les thèmes
        selected_themes = [checkbox.text() for checkbox in self.uiAllDatasets.themes_checkboxes if checkbox.isChecked()]

        # Récupérez l'organisation sélectionnée
        selected_organizations = self.uiAllDatasets.comboBox.currentText()
        self.uiAllDatasets.dynamic_taglist = []

        # Récupérez l'état de toutes les QCheckBox pour les tags
        selected_tags = [checkbox.text() for checkbox in self.uiAllDatasets.tags_checkboxes if checkbox.isChecked()]

        if len(selected_themes) == 0 and len(selected_tags) == 0 and selected_organizations == "Choisir une organisation":
            self.uiAllDatasets.datasetAllList.clear()
            self.resetFilters()
            self.updateTagsCheckbox()
            return
        
        self.uiAllDatasets.datasetAllList.clear()
        
        for dataset in self.uiAllDatasets.alldatasets:
            nom = dataset[0]
            formats = dataset[1]
            tags = dataset[2]
            themes = dataset[3]
            organisation = dataset[4]
            
            hastheme = False
            for theme in selected_themes:
                if theme in themes:
                    hastheme = True
                    break

            hastag = True

            for tag in selected_tags:
                if tag not in tags:
                    hastag = False
                    break

            if hastag:
                for tag in tags:
                    self.uiAllDatasets.dynamic_taglist.append(tag)
                    
            hasorg = False

            if organisation == selected_organizations:
                hasorg = True
            
            if selected_themes == []:
                hastheme = True

            if selected_tags == []:
                hastag = True
                self.uiAllDatasets.dynamic_taglist = []

            if selected_organizations == "Choisir une organisation":
                hasorg = True

            if hastheme and hasorg and hastag:
                if "GeoJSON" in formats:
                    item = QtWidgets.QListWidgetItem(nom)
                    #get the width of the item
                    itemWidth = self.uiAllDatasets.datasetAllList.sizeHintForColumn(0)
                    item.setSizeHint(QtCore.QSize(itemWidth, 70))
                    item.setIcon(self.geojson_icon)
                    item.setToolTip(nom)
                    self.uiAllDatasets.datasetAllList.addItem(item)
                else:
                    item = QtWidgets.QListWidgetItem(nom)
                    #get the width of the item
                    itemWidth = self.uiAllDatasets.datasetAllList.sizeHintForColumn(0)
                    item.setSizeHint(QtCore.QSize(itemWidth, 70))
                    item.setToolTip(nom)
                    self.uiAllDatasets.datasetAllList.addItem(item)
        
        if self.uiAllDatasets.checkDisplayGeo.isChecked():
            self.filterNonGeo(Qt.Checked)
        else:
            self.filterNonGeo(Qt.Unchecked)
        
        self.updateTagsCheckbox()


    def updateTagsCheckbox(self):
        self.uiAllDatasets.dynamic_taglist = list(set(self.uiAllDatasets.dynamic_taglist))
        #check if 0 tags are checked
        if self.uiAllDatasets.dynamic_taglist == []:
            for checkbox in self.uiAllDatasets.tags_checkboxes:
                checkbox.setHidden(False)
            return
        for checkbox in self.uiAllDatasets.tags_checkboxes:
            if checkbox.text() not in self.uiAllDatasets.dynamic_taglist:
                checkbox.setHidden(True)
            else:
                checkbox.setHidden(False)
            

    def resetFilters(self):
        for checkbox in self.uiAllDatasets.themes_checkboxes + self.uiAllDatasets.tags_checkboxes:
            checkbox.setChecked(False)
        for i in range(len(self.Alldatasetlist)):
            if "GeoJSON" in self.Alldatasetlist[i][1]:
                item = QtWidgets.QListWidgetItem(self.Alldatasetlist[i][0])
                #get the width of the item
                itemWidth = self.uiAllDatasets.datasetAllList.sizeHintForColumn(0)
                item.setSizeHint(QtCore.QSize(itemWidth, 70))
                item.setIcon(self.geojson_icon)
                item.setToolTip(self.Alldatasetlist[i][0])
                self.uiAllDatasets.datasetAllList.addItem(item)
            else:
                item = QtWidgets.QListWidgetItem(self.Alldatasetlist[i][0])
                #get the width of the item
                itemWidth = self.uiAllDatasets.datasetAllList.sizeHintForColumn(0)
                item.setSizeHint(QtCore.QSize(itemWidth, 70))
                item.setToolTip(self.Alldatasetlist[i][0])
                self.uiAllDatasets.datasetAllList.addItem(item)
            
        if self.uiAllDatasets.checkDisplayGeo.isChecked():
            self.filterNonGeo(Qt.Checked)
        else:
            self.filterNonGeo(Qt.Unchecked)


    def filterNonGeo(self, state):
        
        if state == Qt.Checked:
            for row in range(self.uiAllDatasets.datasetAllList.count()):
                item = self.uiAllDatasets.datasetAllList.item(row)
                if item is not None:
                    # Vérifiez si l'élément a une icône
                    if item.icon().isNull():
                        item.setHidden(True)
        else : 
            for row in range(self.uiAllDatasets.datasetAllList.count()):
                item = self.uiAllDatasets.datasetAllList.item(row)
                if item is not None:
                    item.setHidden(False)


    def getD4CdatasetsfromAll(self, dataset_name):
        # Check if multiple datasets are selected
        if len(self.uiAllDatasets.datasetAllList.selectedItems()) > 1:
            # Get the selected datasets
            selected_datasets = self.uiAllDatasets.datasetAllList.selectedItems()
            # Get the dataset titles
            dataset_names = [dataset.text() for dataset in selected_datasets]
            # Get the dataset 
            self.windowAllDatasets.close()
            for datasetname in dataset_names:
                for dataset in self.Alldatasetlist:
                    if datasetname == dataset[0]:
                        datasetname = dataset[5]
                        break
                self.dlg.datasetId.setPlainText(datasetname)
                self.dlg.exportLine.setPlainText(datasetname)
                self.getD4Cdatasets()
                self.show_info_message(self.tr(u'Veuillez choisir le fichier à importer pour le dataset : ') + datasetname)
                # Create a dialog to choose the file to import
                self.openImportFile()
        else :
            #find the dataset name with the dataset title
            # [0] is the title of the dataset [5] is the name of the dataset
            for dataset in self.Alldatasetlist:
                if dataset_name == dataset[0]:
                    dataset_name = dataset[5]
                    break
            self.dlg.datasetId.setPlainText(dataset_name)
            self.dlg.exportLine.setPlainText(dataset_name)
            self.getD4Cdatasets()
            self.windowAllDatasets.close()
            
    def openImportFile(self):
        self.windowImportFile = QtWidgets.QDialog()
        self.uiImportFile = Ui_DialogImport()
        self.uiImportFile.setupUi(self.windowImportFile)
        # copy self.dlg.resourcesList to self.uiImportFile.listWidget
        self.uiImportFile.listWidget.setIconSize(QtCore.QSize(24, 24))
        for i in range(self.dlg.resourcesList.count()):
            item = QtWidgets.QListWidgetItem(self.dlg.resourcesList.item(i).text())
            item.setIcon(self.dlg.resourcesList.item(i).icon())
            self.uiImportFile.listWidget.addItem(item)

        self.uiImportFile.pushButton.clicked.connect(self.importFileSelected)
        self.windowImportFile.exec_()

    def importFileSelected(self):
        selected_item = self.uiImportFile.listWidget.currentItem()
        if selected_item:
            file_name = selected_item.text()

            url = self.resourceDict[file_name]

            destination_folder = self.saveFile_folder
            # Set up the file name
            if url.endswith('.json') and not(file_name.endswith('.json')):
                file_name = file_name + '.json'
            elif url.endswith('.csv') and not(file_name.endswith('.csv')):
                file_name = file_name + '.csv'
            elif url.endswith('.geojson') and not(file_name.endswith('.geojson')):
                file_name = file_name + '.geojson'    
            else:
                file_name = file_name
            
            
            destination_path = pathlib.Path(pathlib.Path(destination_folder)/ pathlib.Path(file_name.replace('/', '_')))

            # Download the file
            try : 
                response = requests.get(url)

                if response.status_code == 200:
                    #write file content
                    with open(str(destination_path), 'wb') as f:
                        f.write(response.content)
                else:
                    self.show_error_message('Error downloading file : ' + str(response.status_code))

                #CSV import 
                if file_name.endswith('.csv'):

                    self.importCSV(str(destination_path), file_name)
                    
                #JSON import
                if file_name.endswith('.json'):
                    
                    self.importJSON(str(destination_path), file_name)

                #GeoJSON import
                if file_name.endswith('.geojson'):
                    
                    self.importGEOJSON(str(destination_path), file_name)

            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

            except requests.exceptions.HTTPError as e:
                # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                self.show_error_message(f"HTTP error : {e.response.status_code}")

            except requests.exceptions.ConnectionError as e:
                # Gestion des erreurs de connexion
                self.show_error_message(f"Connection error : {e}")

            except requests.exceptions.Timeout as e:
                # Gestion des erreurs de délai d'attente
                self.show_error_message(f"Expired request : : {e}")

            except requests.exceptions.TooManyRedirects as e:
                # Gestion des erreurs de redirections excessives
                self.show_error_message(f"Too many redirects ! : : {e}")

            except requests.exceptions.RequestException as e:
                # Gestion générale des exceptions de requête
                self.show_error_message(f"Request error : {e}")

            except Exception as e:
                # Gestion d'autres exceptions non spécifiques
                self.show_error_message(f"Unhandled error occured: {e}")
            self.updateLastimportedfiles()
            
            self.windowImportFile.close()
        else:
            self.show_error_message(self.tr(u'Veuillez sélectionner un fichier à importer'))
        return

    def turnOffAllDatasetLoaded(self):
        self.isAlldatasetsLoaded = False

    def updateHistoryPush(self):
        selected_items = self.dlg.historyList.selectedItems()
        if len(selected_items) > 0:
            self.dlg.pushHistory.setEnabled(True)
        else:
            self.dlg.pushHistory.setEnabled(False)

    def updateFilesPush(self):
        selected_items = self.dlg.filesList.selectedItems()
        if len(selected_items) > 0:
            self.dlg.pushLoadHistoryfile.setEnabled(True)
        else:
            self.dlg.pushLoadHistoryfile.setEnabled(False)

    def currentSiteIndex(self):

        sites_file_path = pathlib.Path.home() / '.d4cplugin' / 'sites.json'
        with open(str(sites_file_path), 'r') as json_file:
            site_data = json.load(json_file)

        sites = site_data["saved_sites"]["sites"]
        for i in range(len(sites)):
            if sites[i]["site_url"] == self.sit and sites[i]["username"] == self.usr:
                return i
            
        return 0

    def updatePrevisu(self):
        
        selected_resource = self.dlg.resourcesList.currentItem()

        if selected_resource:
            data = None
            self.dlg.tableWidget.clear()
            
            selected_resource = selected_resource.text()        
            url = self.resourceDict[selected_resource]

            if not(url.endswith('.csv')):
                
                self.dlg.tableWidget.setRowCount(1)
                self.dlg.tableWidget.setColumnCount(1)
                self.dlg.tableWidget.setItem(0, 0, QtWidgets.QTableWidgetItem('Aperçu non disponible pour les fichiers non CSV'))
                return
            selected_resource_id = self.listExistingResourceById[selected_resource]
            url = self.sit + '/d4c/api/records/2.0/search/?resource_id=' + selected_resource_id

            try:
                response = requests.get(url)

                if response.status_code == 200:
                    data = response.json()
                    if data['success'] == False:
                        return
                    
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(f"Request error : {e}")

            except requests.exceptions.HTTPError as e:
                # Gestion des erreurs HTTP (erreurs 4xx et 5xx)
                self.show_error_message(f"HTTP error : {e.response.status_code}")

            except requests.exceptions.ConnectionError as e:
                # Gestion des erreurs de connexion
                self.show_error_message(f"Connection error : {e}")

            except requests.exceptions.Timeout as e:
                # Gestion des erreurs de délai d'attente
                self.show_error_message(f"Expired request : : {e}")

            except requests.exceptions.TooManyRedirects as e:
                # Gestion des erreurs de redirections excessives
                self.show_error_message(f"Too many redirects ! : : {e}")

            except requests.exceptions.RequestException as e:
                # Gestion générale des exceptions de requête
                self.show_error_message(f"Request error : {e}")

            except Exception as e:
                # Gestion d'autres exceptions non spécifiques
                self.show_error_message(f"Unhandled error occured: {e}") 

            if data is not None:
                datas = data['result']['records']
                headers = []
                for key in list(datas[0].keys()):
                    headers.append(key)
                nb_col = len(headers)
                nb_rows = data['result']['total']
                if nb_rows > 100:
                    nb_rows = 100
                self.dlg.tableWidget.setRowCount(nb_rows)
                self.dlg.tableWidget.setColumnCount(nb_col)
                self.dlg.tableWidget.setHorizontalHeaderLabels(headers)

                for i in range(nb_rows):
                    for j in range(nb_col):
                        self.dlg.tableWidget.setItem(i, j, QtWidgets.QTableWidgetItem(str(datas[i][headers[j]])))


    def openTableWindow(self):
        self.windowTable = TableWindow()

        if self.dlg.tableWidget.columnCount() == 1 and self.dlg.tableWidget.rowCount() == 1:
            return
        self.windowTable.table.setColumnCount(self.dlg.tableWidget.columnCount())
        self.windowTable.table.setRowCount(self.dlg.tableWidget.rowCount())


        self.windowTable.table.setHorizontalHeaderLabels(self.dlg.tableWidget.horizontalHeaderItem(i).text() for i in range(self.dlg.tableWidget.columnCount()))
        for row in range(self.dlg.tableWidget.rowCount()):
            for col in range(self.dlg.tableWidget.columnCount()):
                item = self.dlg.tableWidget.item(row, col)
                if item is not None:
                    new_item = QtWidgets.QTableWidgetItem(item.text())  
                    self.windowTable.table.setItem(row, col, new_item)
        self.windowTable.show()


    def openAbout(self):
        self.windowAbout = QtWidgets.QDialog()
        self.uiAbout = Ui_pluginInfos()
        self.uiAbout.setupUi(self.windowAbout)
        self.windowAbout.exec_()


    def openHelp(self):
        os.system("start \"\" https://wikijs.data4citizen.com/fr/qgis/d4c-extension")


    def changeLanguage(self):
        language_code = self.dlg.languageBox.currentIndex()
        if language_code == 0:
            lang = 'fr'
        else:
            lang = 'en'
        
        json_file_path = pathlib.Path.home() / '.d4cplugin' / 'history.json'


        with open(str(json_file_path), 'r') as json_file:
            data = json.load(json_file)
            data["lang"] = lang
        with open(str(json_file_path), 'w') as json_file:
            json.dump(data, json_file, indent=4)
        if lang == 'fr':
            self.show_info_message('Veuillez redémarrer QGIS pour appliquer les changements')
            # Quitter le plugin
            self.dlg.close()
            
        else: 
            self.show_info_message('Please restart QGIS to apply changes')
            # Quitter le plugin
            self.dlg.close()
            
    # Méthode pour gérer la séléction des comboboxes
    def updateManipulateCB(self):
        exportable_layers = QgsProject.instance().mapLayers().values()
        self.dlg.comboBoxLayer1F.clear()
        self.dlg.comboBoxLayer2F.clear()
        self.dlg.comboBoxLayerFPlus.clear()

        line_icon = QIcon(str(self.plugin_dir / 'img' /'line_icon.png'))
        shape_icon = QIcon(str(self.plugin_dir / 'img' /'shape_icon.png'))
        dot_icon = QIcon(str(self.plugin_dir / 'img' /'dot_icon.png'))
        

        for layer in exportable_layers:
            item_name = layer.name()

            if item_name != 'OpenStreetMap' and str(layer.geometryType()) != 'GeometryType.Null':
                item = item_name
                if layer.geometryType() == QgsWkbTypes.PointGeometry:
                    icon = dot_icon
                elif layer.geometryType() == QgsWkbTypes.LineGeometry:
                    icon = line_icon
                elif layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                    icon = shape_icon
                else:
                    icon = dot_icon

                if item_name.endswith('.csv'):
                    self.dlg.comboBoxLayer1F.addItem(icon, item)
                elif item_name.endswith('.geojson'):
                    self.dlg.comboBoxLayer1F.addItem(icon, item)
                elif item_name.endswith('.json'):
                    self.dlg.comboBoxLayer1F.addItem(icon, item)
                elif not(item_name.endswith('.geojson')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.geojson'):

                    self.dlg.comboBoxLayer1F.addItem(icon, item)
                elif not(item_name.endswith('.json')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.json'):

                    self.dlg.comboBoxLayer1F.addItem(icon, item)
        
        self.dlg.comboBoxLayer1F.setCurrentIndex(-1)
        self.dlg.comboBoxLayer2F.setCurrentIndex(-1)
        self.dlg.comboBoxLayerFPlus.setCurrentIndex(-1)
        self.dlg.comboBoxOperation.setCurrentIndex(0)
        self.dlg.checkCentroid.setEnabled(False)
        self.dlg.checkCentroid.setChecked(False)

    # Ajout du 1er layer dans la liste
    def addLayer1F(self):
        # Si le layer était déjà choisi
        if self.layer1isSet:
            self.dlg.layersListF.takeItem(0)
            if not(self.isAlreadyinList(self.dlg.comboBoxLayer1F.currentText())):
                self.dlg.layersListF.insertItem(0, self.dlg.comboBoxLayer1F.currentText())
            else:
                self.dlg.comboBoxLayer1F.setCurrentIndex(-1)
            
        else:
            self.dlg.layersListF.addItem(self.dlg.comboBoxLayer1F.currentText())
            self.layer1isSet = True

        self.dlg.comboBoxLayer2F.clear()
        line_icon = QIcon(str(self.plugin_dir / 'img' /'line_icon.png'))
        shape_icon = QIcon(str(self.plugin_dir / 'img' /'shape_icon.png'))
        dot_icon = QIcon(str(self.plugin_dir / 'img' /'dot_icon.png'))
        #Ajouter à la combobox 2 les layers avec la même géométrie sauf celui choisi : 
        exportable_layers = QgsProject.instance().mapLayers().values()
        for layer in exportable_layers:
            item_name = layer.name()
            if item_name != self.dlg.comboBoxLayer1F.currentText():
                if item_name != 'OpenStreetMap' and str(layer.geometryType()) != 'GeometryType.Null':
                    if str(layer.geometryType()) == self.getSelectionType(self.dlg.comboBoxLayer1F.currentText()):
                        item = item_name
                        if str(layer.geometryType()) == 'GeometryType.Point':
                            icon = dot_icon
                        elif layer.geometryType() == QgsWkbTypes.LineGeometry:
                            icon = line_icon
                        elif str(layer.geometryType()) == 'GeometryType.Polygon':
                            icon = shape_icon
                        else:
                            icon = dot_icon

                        if item_name.endswith('.csv'):
                            self.dlg.comboBoxLayer2F.addItem(icon, item)
                        elif item_name.endswith('.geojson'):
                            self.dlg.comboBoxLayer2F.addItem(icon, item)
                        elif item_name.endswith('.json'):
                            self.dlg.comboBoxLayer2F.addItem(icon, item)
                        elif not(item_name.endswith('.geojson')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.geojson'):

                            self.dlg.comboBoxLayer2F.addItem(icon, item)
                        elif not(item_name.endswith('.json')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.json'):

                            self.dlg.comboBoxLayer2F.addItem(icon, item)

        self.dlg.comboBoxLayer2F.setCurrentIndex(-1)
        self.dlg.comboBoxLayerFPlus.clear()
    
   
    # Ajout du 2e layer dans la liste
    def addLayer2F(self):
        if self.layer2isSet:
            self.dlg.layersListF.takeItem(1)
            if not(self.isAlreadyinList(self.dlg.comboBoxLayer2F.currentText())):
                self.dlg.layersListF.insertItem(1, self.dlg.comboBoxLayer2F.currentText()) 
            else:
                self.dlg.comboBoxLayer2F.setCurrentIndex(-1) 
        else: 
            self.dlg.layersListF.addItem(self.dlg.comboBoxLayer2F.currentText())
            self.layer2isSet = True
        line_icon = QIcon(str(self.plugin_dir / 'img' /'line_icon.png'))
        shape_icon = QIcon(str(self.plugin_dir / 'img' /'shape_icon.png'))
        dot_icon = QIcon(str(self.plugin_dir / 'img' /'dot_icon.png'))
        
        exportable_layers = QgsProject.instance().mapLayers().values()
        for layer in exportable_layers:
            item_name = layer.name()
            # On ajoute la couche si elle ne possède pas le même nom que les 2 autres sélectionnées
            if item_name != self.dlg.comboBoxLayer1F.currentText() and item_name != self.dlg.comboBoxLayer2F.currentText():
                if item_name != 'OpenStreetMap' and str(layer.geometryType()) != 'GeometryType.Null':
                    if str(layer.geometryType()) == self.getSelectionType(self.dlg.comboBoxLayer1F.currentText()):
                        item = item_name
                        if str(layer.geometryType()) == 'GeometryType.Point':
                            icon = dot_icon
                        elif layer.geometryType() == QgsWkbTypes.LineGeometry:
                            icon = line_icon
                        elif str(layer.geometryType()) == 'GeometryType.Polygon':
                            icon = shape_icon
                        else:
                            icon = dot_icon

                        if item_name.endswith('.csv'):
                            self.dlg.comboBoxLayerFPlus.addItem(icon, item)
                        elif item_name.endswith('.geojson'):
                            self.dlg.comboBoxLayerFPlus.addItem(icon, item)
                        elif item_name.endswith('.json'):
                            self.dlg.comboBoxLayerFPlus.addItem(icon, item)
                        elif not(item_name.endswith('.geojson')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.geojson'):

                            self.dlg.comboBoxLayerFPlus.addItem(icon, item)
                        elif not(item_name.endswith('.json')) and QgsProject.instance().mapLayersByName(item_name)[0].dataProvider().dataSourceUri().endswith('.json'):

                            self.dlg.comboBoxLayerFPlus.addItem(icon, item)
        
    
            
    # Ajouter des layers supplémentaires
    def addLayerFPlus(self):
        self.dlg.layersListF.addItem(self.dlg.comboBoxLayerFPlus.currentText())
        self.removeLayerFromComboBox(self.dlg.comboBoxLayerFPlus.currentText(), self.dlg.comboBoxLayerFPlus)

    #Supprimer un layer de la liste
    def removeSelectedLayerF(self):
        index = self.dlg.layersListF.currentRow()
        if index == -1:
            self.show_info_message(self.tr('Veuillez sélectionner une couche à supprimer !'))
            return
        text = self.dlg.layersListF.item(index).text()
        if index > 1:
            self.dlg.layersListF.takeItem(index)
        line_icon = QIcon(str(self.plugin_dir / 'img' /'line_icon.png'))
        shape_icon = QIcon(str(self.plugin_dir / 'img' /'shape_icon.png'))
        dot_icon = QIcon(str(self.plugin_dir / 'img' /'dot_icon.png'))
        if self.getSelectionType(text) == 'GeometryType.Point':
            icon = dot_icon
        elif self.getSelectionType(text) == 'GeometryType.LineString':
            icon = line_icon
        elif self.getSelectionType(text) == 'GeometryType.Polygon':
            icon = shape_icon
        else:
            icon = dot_icon
        self.dlg.comboBoxLayerFPlus.addItem(icon, text)
    
    # Retourne Vrai si un layer est déjà dans la liste
    def isAlreadyinList(self, text):
        for i in range(self.dlg.layersListF.count()):
            if text == self.dlg.layersListF.item(i).text():
                return True
        return False

    
    def createLayerF(self):
        if self.dlg.layerNameF.text() == '':
            self.show_info_message(self.tr('Veuillez entrer un nom pour la couche fusionnée !'))
            return
        layers= []
        # Récupérer les couches à partir de leurs noms (on traite le cas ou il y a plusieurs fois le meme nom)
        if self.dlg.comboBoxOperation.currentIndex() == 4:
            for couche in QgsProject.instance().mapLayersByName(self.dlg.layersListF.item(0).text()):
                if str(couche.geometryType()) != 'GeometryType.Null':
                    layer = couche
        else: 
            for i in range(self.dlg.layersListF.count()):
                for couche in QgsProject.instance().mapLayersByName(self.dlg.layersListF.item(i).text()):
                    if str(couche.geometryType()) != 'GeometryType.Null':
                        layers.append(couche)
        
        result_layer_name = self.dlg.layerNameF.text()
        path = pathlib.Path(self.saveFile_folder) / pathlib.Path(result_layer_name + '.geojson')
        result_layer_path = str(path)
        if self.dlg.comboBoxOperation.currentIndex() == 0:
            self.fusionner_couches_couche(result_layer_path, layers)
        elif self.dlg.comboBoxOperation.currentIndex() == 1:
            self.difference_couches_couche(result_layer_path, layers)
        elif self.dlg.comboBoxOperation.currentIndex() == 2:
            self.union_couches_couche(result_layer_path, layers)
        elif self.dlg.comboBoxOperation.currentIndex() == 3:
            self.intersection_couches_couche(result_layer_path, layers)
        elif self.dlg.comboBoxOperation.currentIndex() == 4:
            if self.dlg.checkCentroid.isChecked():
                self.centroids_couches_couche(result_layer_path, layer, True)
            else:
                self.centroids_couches_couche(result_layer_path, layer, False)
        self.updateLastimportedfiles()


    # Méthode de calcul pour les différents types de calculs
    def fusionner_couches_couche(self, result_layer_path, layers):
        # Initialiser l'application QGIS
        QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
        Processing.initialize()

        # Définir les paramètres de l'algorithme de fusion
        parameters = {
            'LAYERS': layers,
            'CRS': 'epsg:4326',
            'OUTPUT': result_layer_path
        }
        # Exécuter l'algorithme de fusion
        try:
            if QgsProject.instance().mapLayersByName(self.dlg.layerNameF.text()):
                self.show_error_message(self.tr('Une couche avec ce nom existe déjà'))
                return
            Processing.runAlgorithm("native:mergevectorlayers", parameters)
            # Ajouter la couche fusionnée à la carte de QGIS
            
            result_layer = QgsVectorLayer(result_layer_path, self.dlg.layerNameF.text() , 'ogr')
            
            if result_layer.isValid():
                QgsProject.instance().addMapLayer(result_layer)
                self.show_success_message(self.tr('Couche fusionnée créée avec succès'))
                
                    
        except Exception as e:
            self.show_error_message(self.tr(f'Erreur lors de la fusion des couches, vérifier que les couches sont compatibles. {e}'))
            # delete the file in the folder
            os.remove(result_layer_path)
            return
    

    def difference_couches_couche(self, result_layer_path, layers):
        if len(layers) != 2:
            self.show_error_message(self.tr('Veuillez sélectionner 2 couches uniquement pour la différence'))
            return
        # Initialiser l'application QGIS
        QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
        Processing.initialize()

        # Définir les paramètres de l'algorithme de différence
        parameters = {
            'INPUT': layers[0],
            'OVERLAY': layers[1],
            'OUTPUT': result_layer_path
        }
        # Exécuter l'algorithme de différence
        try:
            if QgsProject.instance().mapLayersByName(self.dlg.layerNameF.text()):
                self.show_error_message(self.tr('Une couche avec ce nom existe déjà'))
                return
            Processing.runAlgorithm("native:difference", parameters)
            # Ajouter la couche calculée à la carte de QGIS
            
            result_layer = QgsVectorLayer(result_layer_path, self.dlg.layerNameF.text() , 'ogr')
            
            if result_layer.isValid():
                QgsProject.instance().addMapLayer(result_layer)
                self.show_success_message(self.tr('Différence créée avec succès'))                
                
        except Exception as e:
            self.show_error_message(self.tr(f'Erreur lors de la différence des couches, vérifier que les couches sont compatibles. {e}'))
            # delete the file in the folder
            os.remove(result_layer_path)
            return
        

    def union_couches_couche(self, result_layer_path, layers):
        if len(layers) != 2:
            self.show_error_message(self.tr('Veuillez sélectionner 2 couches uniquement pour l\'union'))
            return
        # Initialiser l'application QGIS
        QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
        Processing.initialize()

        # Définir les paramètres de l'algorithme d'union
        parameters = {
            'INPUT': layers[0],
            'OVERLAY': layers[1],
            'OUTPUT': result_layer_path
        }
        # Exécuter l'algorithme d'union
        try:
            if QgsProject.instance().mapLayersByName(self.dlg.layerNameF.text()):
                
                self.show_error_message(self.tr('Une couche avec ce nom existe déjà'))
                return
            Processing.runAlgorithm("native:union", parameters)
            # Ajouter la couche calculée à la carte de QGIS
            
            result_layer = QgsVectorLayer(result_layer_path, self.dlg.layerNameF.text() , 'ogr')
            
            if result_layer.isValid():
                QgsProject.instance().addMapLayer(result_layer)
                self.show_success_message(self.tr('Union créée avec succès'))
                
                
        except Exception as e:
            self.show_error_message(self.tr(f'Erreur lors de l\'union des couches, vérifier que les couches sont compatibles. {e}'))
            # delete the file in the folder
            os.remove(result_layer_path)
            return
        

    def intersection_couches_couche(self, result_layer_path, layers):
        if len(layers) != 2:
            self.show_error_message(self.tr('Veuillez sélectionner 2 couches uniquement pour l\'intersection'))
            return
        # Initialiser l'application QGIS
        QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
        Processing.initialize()

        # Définir les paramètres de l'algorithme d'intersection
        parameters = {
            'INPUT': layers[0],
            'OVERLAY': layers[1],
            'OUTPUT': result_layer_path
        }
        # Exécuter l'algorithme d'intersection
        try:
            if QgsProject.instance().mapLayersByName(self.dlg.layerNameF.text()):
                
                self.show_error_message(self.tr('Une couche avec ce nom existe déjà'))
                return
            Processing.runAlgorithm("native:intersection", parameters)
            # Ajouter la couche calculée à la carte de QGIS
            
            result_layer = QgsVectorLayer(result_layer_path, self.dlg.layerNameF.text() , 'ogr')
            
            if result_layer.isValid():
                QgsProject.instance().addMapLayer(result_layer)
                self.show_success_message(self.tr('Intersection créée avec succès'))
                
        except Exception as e:
            self.show_error_message(self.tr(f'Erreur lors de l\'intersection des couches, vérifier que les couches sont compatibles. {e}'))
            os.remove(result_layer_path)
            return
        
    def centroids_couches_couche(self, result_layer_path, layer, all_parts):
        if not layer.isValid():
            self.show_error_message(self.tr('Veuillez sélectionner une couche valide'))
            return
        # Initialiser l'application QGIS
        QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())
        Processing.initialize()

        # Définir les paramètres de l'algorithme de centroide
        parameters = {
            'INPUT': layer,
            'ALL_PARTS': all_parts, 
            'OUTPUT': result_layer_path
        }
        # Exécuter l'algorithme de centroide
        try:
            
            if QgsProject.instance().mapLayersByName(self.dlg.layerNameF.text()):
                
                self.show_error_message(self.tr('Une couche avec ce nom existe déjà'))
                return
            Processing.runAlgorithm("native:centroids", parameters)
            # Ajouter la couche calculée à la carte de QGIS
            
            result_layer = QgsVectorLayer(result_layer_path, self.dlg.layerNameF.text() , 'ogr')
            
            if result_layer.isValid():
                QgsProject.instance().addMapLayer(result_layer)
                self.show_success_message(self.tr('Centroïde créée avec succès'))                
                
        except Exception as e:
            self.show_error_message(self.tr(f'Erreur lors du calcul des centroides. {e}'))
            # delete the file in the folder
            os.remove(result_layer_path)
            return

    def removeLayerFromComboBox(self, layer_name, combo_box):
        # Supprimer l'élément de la combobox si présent
        index = combo_box.findText(layer_name)
        if index != -1:
            combo_box.removeItem(index)

    def getSelectionType(self, layer_name):
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            if layer.name() == layer_name:
                return str(layer.geometryType())
        return 'GeometryType.Null'

    def displayCheckCentroid(self):
        if self.dlg.comboBoxOperation.currentIndex() == 4:
            self.dlg.checkCentroid.setEnabled(True)
        else:
            self.dlg.checkCentroid.setEnabled(False)
            self.dlg.checkCentroid.setChecked(False)


    def searchOpenDatas(self):
        self.dlg.listOpenData.clear()
        self.opendatadict = {}
        self.dlg.listResourceOpenData.clear()
        if self.dlg.radioDataGouv.isChecked():
            self.callDataGouvsearch()
        elif self.dlg.radioD4C.isChecked():
            self.callD4Csearch()
        elif self.dlg.radioODS.isChecked():
            self.callODSsearch()
        elif self.dlg.radioCKAN.isChecked():
            self.callCKANsearch()
        else:
            self.show_error_message(self.tr('Veuillez sélectionner un site à interroger'))
    
    # Métodes d'appel pour les différents sites OpenData
    def callDataGouvsearch(self):
        if self.dlg.radioDataGouvDataset.isChecked():
            self.dlg.OpenDataDatasetLabel.setText("Jeu de donnée :")
            self.dlg.OpenDataResourceLabel.setText("Ressource :")
            self.dlg.searchOpenData.setHidden(True)
            self.dlg.searchOpenData.setText("")
            if self.dlg.searchParamsOpenData.text() == '':
                self.show_info_message(self.tr('Veuillez entrer des paramètres de recherche'))
                return
            url = 'https://www.data.gouv.fr/api/1/datasets/?q=' + self.dlg.searchParamsOpenData.text()
        
            try:
                response = requests.get(url)

                if response.status_code == 200:
                    data = response.json()
                    self.dlg.listOpenData.clear()
                    if data['total'] == 0:
                        self.show_info_message(self.tr('Aucun résultat'))
                        self.dlg.listResourceOpenData.clear()
                        return
                    for dataset in data['data']:
                        item = QtWidgets.QListWidgetItem(dataset['title'])
                        item.setToolTip(dataset['title'])
                        self.dlg.listOpenData.addItem(item)
                        resourcelist = []
                        for resource in dataset['resources']:
                            resourcelist.append([resource['title'], resource['url'], resource['format']])
                        self.opendatadict[dataset['title']] = resourcelist
                else:
                    self.show_error_message(self.tr('Erreur : ' + str(response.status_code)))
                    return
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(self.tr(f"Erreur de requête : {e}"))

        elif self.dlg.radioDataGouvOrga.isChecked():
            self.dlg.OpenDataDatasetLabel.setText("Organisation :")
            self.dlg.OpenDataResourceLabel.setText("Jeu de donnée :")
            self.dlg.searchOpenData.setHidden(False)

            url = 'https://www.data.gouv.fr/api/1/organizations/?q=' + self.dlg.searchParamsOpenData.text()

            try:
                response = requests.get(url)
                if response.status_code == 200:
                    data = response.json()
                    if data['total'] == 0:
                        self.show_info_message(self.tr('Aucun résultat'))
                        self.dlg.listResourceOpenData.clear()
                        return
                    self.dlg.listOpenData.clear()
                    for org in data['data']:
                        self.dlg.listOpenData.addItem(org['name'])
                        self.opendatadict[org['name']] = org['id']
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(self.tr(f"Erreur de requête : {e}"))

    def callD4Csearch(self):
        
        site_index = self.dlg.D4CcomboBox.currentIndex()
        file_path = self.plugin_dir / 'D4C_sites.json'

        with open(str(file_path), 'r') as json_file:
            data = json.load(json_file)
            site_url = data["sites"][site_index]["site_url"]
        
        if site_url == 'https://data.libourne.fr':
            url = site_url + '/api/datasets/2.0/search/?q=' + self.dlg.searchParamsOpenData.text() + '&rows=500'
        else:
            url = site_url + '/d4c/api/datasets/2.0/search/?q=' + self.dlg.searchParamsOpenData.text() + '&rows=500'
        try:
            response = requests.get(url)
            if response.status_code == 200:
                data = response.json()
                self.dlg.listOpenData.clear()
                if data['success'] == False:
                    self.show_info_message(self.tr('Aucun résultat'))
                    self.dlg.listResourceOpenData.clear()
                    return
                for dataset in data['result']['results']:
                
                    item = QtWidgets.QListWidgetItem(dataset['title'])
                    item.setToolTip(dataset['title'])
                    if dataset['resources']:
                        self.dlg.listOpenData.addItem(item)
                    resourcelist = []
                    
                    for resource in dataset['resources']:
                        if resource['format'] == 'CSV' or resource['mimetype'] == 'text/csv' or resource['name'].endswith('.csv'):
                            res_format = 'csv'
                        elif resource['format'] == 'json' or resource['mimetype'] == 'application/json' or resource['name'].endswith('.json'):
                            res_format = 'json'
                        elif resource['format'] == 'GeoJSON' or resource['mimetype'] == 'application/geo+json' or resource['name'].endswith('.geojson'):
                            res_format = 'geojson'
                        else:
                            res_format = resource['format'] if resource['format'] else 'unknown'
                        if dataset['url']:
                            url_file = dataset['url'] + '/resource/' + resource['id'] + '/download/' + resource['name']
                        else:
                            url_file = site_url + '/d4c/api/records/2.0/downloadfile/resource_id=' + resource['id'] +'&format=' + res_format 
                        resourcelist.append([resource['name'], url_file, res_format if res_format else 'unknown'])
                    self.opendatadict[dataset['title']] = resourcelist
            else:
                self.show_error_message(self.tr('Erreur : ' + str(response.status_code)))
                return
        except requests.exceptions.RequestException as e:
            # Gestion des erreurs de requête
            self.show_error_message(self.tr(f"Erreur de requête : {e}"))

    def callODSsearch(self):
        if self.dlg.searchParamsOpenData.text() == '':
            self.show_info_message(self.tr('Veuillez entrer des paramètres de recherche'))
            return
        if self.dlg.OpenDataURL.text() == '':
            url = "https://public.opendatasoft.com/api/datasets/1.0/search/?rows=1000&q=" + self.dlg.searchParamsOpenData.text()

            try:
                response = requests.get(url)
                if response.status_code == 200:
                    data = response.json()
                    self.dlg.listOpenData.clear()
                    if data['nhits'] == 0:
                        self.show_info_message(self.tr('Aucun résultat'))
                        self.dlg.listResourceOpenData.clear()
                        return
                    for dataset in data["datasets"]:
                        item = QtWidgets.QListWidgetItem(dataset['metas']['title'])
                        item.setToolTip(dataset['metas']['title'])
                        self.dlg.listOpenData.addItem(item)
                        resourcelist = []
                        resourcelist.append(["CSV", "https://public.opendatasoft.com/api/explore/v2.1/catalog/datasets/" + dataset["datasetid"] + "/exports/csv?lang=fr&timezone=Europe%2FBerlin&use_labels=true&delimiter=%2C", "csv"])
                        resourcelist.append(["JSON", "https://public.opendatasoft.com/api/explore/v2.1/catalog/datasets/" + dataset["datasetid"] + "/exports/json?lang=fr&timezone=Europe%2FBerlin", "json"])
                        if "geometry_types" in dataset['metas']:
                            resourcelist.append(["GeoJSON", "https://public.opendatasoft.com/api/explore/v2.1/catalog/datasets/" + dataset["datasetid"] + "/exports/geojson?lang=fr&timezone=Europe%2FBerlin", "geojson"])
                        self.opendatadict[dataset['metas']['title']] = resourcelist
                else:
                    self.show_error_message(self.tr('Erreur : ' + str(response.status_code)))
                    return
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(self.tr(f"Erreur de requête : {e}"))
        else:
            url = "https://" + self.dlg.OpenDataURL.text().replace("https://","") + '/api/datasets/1.0/search/?rows=10000&q=' + self.dlg.searchParamsOpenData.text()

            try:
                response = requests.get(url)
                if response.status_code == 200:
                    data = response.json()
                    self.dlg.listOpenData.clear()
                    if data['nhits'] == 0:
                        self.show_info_message(self.tr('Aucun résultat'))
                        self.dlg.listResourceOpenData.clear()
                        return
                    for dataset in data["datasets"]:
                        item = QtWidgets.QListWidgetItem(dataset['metas']['title'])
                        item.setToolTip(dataset['metas']['title'])
                        self.dlg.listOpenData.addItem(item)
                        resourcelist = []
                        resourcelist.append(["CSV", "https://" + self.dlg.OpenDataURL.text().replace("https://","") + '/api/explore/v2.1/catalog/datasets/' + dataset["datasetid"] + "/exports/csv?lang=fr&timezone=Europe%2FBerlin&use_labels=true&delimiter=%2C", "csv"])
                        resourcelist.append(["JSON", "https://" + self.dlg.OpenDataURL.text().replace("https://","") + '/api/explore/v2.1/catalog/datasets/' + dataset["datasetid"] + "/exports/json?lang=fr&timezone=Europe%2FBerlin", "json"])
                        if "geometry_types" in dataset['metas']:
                            resourcelist.append(["GeoJSON", "https://" + self.dlg.OpenDataURL.text().replace("https://","") + '/api/explore/v2.1/catalog/datasets/' + dataset["datasetid"] + "/exports/geojson?lang=fr&timezone=Europe%2FBerlin", "geojson"])
                        self.opendatadict[dataset['metas']['title']] = resourcelist
                else:
                    self.show_error_message(self.tr('Erreur : ' + str(response.status_code)))
                    return
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(self.tr(f"Erreur de requête : {e}"))

    def callCKANsearch(self):
        if self.dlg.OpenDataURL.text() == '':
            self.show_info_message(self.tr('Veuillez entrer une URL'))
        else:
            url = "https://" + self.dlg.OpenDataURL.text().replace("https://","") + '/api/3/action/package_search?rows=1000&q=' + self.dlg.searchParamsOpenData.text().replace(' ', '_')

            try:
                response = requests.get(url)
                if response.status_code == 200:
                    data = response.json()
                    self.dlg.listOpenData.clear()
                    if data['result']['count'] == 0:
                        self.show_info_message(self.tr('Aucun résultat'))
                        self.dlg.listResourceOpenData.clear()
                        return
                    for dataset in data['result']['results']:
                        item = QtWidgets.QListWidgetItem(dataset['title'])
                        item.setToolTip(dataset['title'])
                        self.dlg.listOpenData.addItem(item)
                        resourcelist = []
                        for resource in dataset['resources']:
                            resourcelist.append([resource['name'], resource['url'], resource['format']])
                        self.opendatadict[dataset['title']] = resourcelist
                else:
                    self.show_error_message(self.tr('Erreur : ' + str(response.status_code)))
                    return
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(self.tr(f"Erreur de requête : {e}"))
    
    def displayOpenDataResources(self):
        if self.dlg.radioDataGouvOrga.isChecked():

            if type(self.opendatadict[self.dlg.listOpenData.currentItem().text()]) == list:
                return            
            url = "https://www.data.gouv.fr/api/1/datasets/?page_size=10000&organization=" + self.opendatadict[self.dlg.listOpenData.currentItem().text()]
            
            try:
                response = requests.get(url)
                if response.status_code == 200:
                    data = response.json()
                    self.dlg.listResourceOpenData.clear()
                    for dataset in data['data']:
                        item = QtWidgets.QListWidgetItem(dataset['title'])
                        item.setToolTip(dataset['title'])
                        self.dlg.listResourceOpenData.addItem(item)
                        resourcelist = []
                        resource = dataset['resources']
                        resourcelist.append([resource[0]['title'], resource[0]['url'], resource[0]['format']])
                        self.opendatadict[dataset['title']] = resourcelist

                else:
                    self.show_error_message(self.tr('Erreur : ' + str(response.status_code)))
            except requests.exceptions.RequestException as e:
                # Gestion des erreurs de requête
                self.show_error_message(self.tr(f"Erreur de requête : {e}"))

        else:
            if type(self.opendatadict[self.dlg.listOpenData.currentItem().text()]) == str:
                return
            self.dlg.listResourceOpenData.clear()
            dataset = self.dlg.listOpenData.currentItem().text()
            for resource in self.opendatadict[dataset]:
                item = QtWidgets.QListWidgetItem(resource[0])
                item.setToolTip(resource[0])
                self.dlg.listResourceOpenData.addItem(item)

    def downloadOpenDataResource(self):
        if self.dlg.listResourceOpenData.currentItem() is None:
            self.show_info_message(self.tr('Veuillez sélectionner une ressource à télécharger'))
            return
        
        resource_name = self.dlg.listResourceOpenData.currentItem().text()
        if self.dlg.radioDataGouvOrga.isChecked():
            url = self.opendatadict[self.dlg.listResourceOpenData.currentItem().text()][0][1]
            resource_format = self.opendatadict[self.dlg.listResourceOpenData.currentItem().text()][0][2]
            destination_folder = self.saveFile_folder
        else:

            url = self.opendatadict[self.dlg.listOpenData.currentItem().text()][self.dlg.listResourceOpenData.currentRow()][1]
            resource_format = self.opendatadict[self.dlg.listOpenData.currentItem().text()][self.dlg.listResourceOpenData.currentRow()][2]
            destination_folder = self.saveFile_folder

        # Download the file 
        response = requests.get(url)
        if response.status_code == 200:
            #write file content
            # check if the file already exists
            if not resource_name.endswith('.' + resource_format):
                resource_name = resource_name + '.' + resource_format
            i = 1
            pathfile = pathlib.Path(destination_folder) / pathlib.Path(resource_name.replace('/', '_'))
            while pathlib.Path.exists( pathfile ):
                if i == 1:
                    resource_name = resource_name.replace('.' + resource_format, '')
                    resource_name = resource_name + '_' + str(i) + '.' + resource_format

                else:   
                    resource_name = resource_name.replace('.' + resource_format, '')
                    resource_name = resource_name[:-1] + str(i) + '.' + resource_format
                i+=1
            
            
 
            with open(str(pathfile), 'wb') as f:
                f.write(response.content)
            # add to qgis workspace
            if resource_format == 'csv' or resource_format == 'CSV' or resource_format == 'Csv':
                self.importCSV(str(pathfile), resource_name)
            else:

                layer = QgsVectorLayer(str(pathfile), resource_name, 'ogr')
                if layer.isValid():
                    QgsProject.instance().addMapLayer(layer)
                    
                    self.show_success_message(self.tr('Couche ajoutée avec succès'))
                    self.updateLastimportedfiles()
                else:
                    self.show_error_message(self.tr('Erreur lors de l\'ajout de la couche'))
                
        else:
            self.show_error_message('Error downloading file : ' + str(response.status_code))

    def disableUrlField(self):
        if self.dlg.radioDataGouv.isChecked():
            self.dlg.label_urlOpendata.setHidden(True)
            self.dlg.OpenDataURL.setHidden(True)
            self.dlg.radioDataGouvOrga.setChecked(False)
            self.dlg.radioDataGouvOrga.setHidden(False)
            self.dlg.radioDataGouvDataset.setChecked(True)
            self.dlg.radioDataGouvDataset.setHidden(False)

            self.dlg.D4CcomboBox.setHidden(True)
            self.dlg.D4CcomboBox.setEnabled(False)
    
    def enableUrlField(self):
        self.dlg.label_urlOpendata.setEnabled(True)
        self.dlg.OpenDataDatasetLabel.setText("Jeu de donnée :")
        self.dlg.OpenDataResourceLabel.setText("Ressource :")
        self.dlg.searchOpenData.setHidden(True)
        self.dlg.searchOpenData.setText("")
        if self.dlg.radioD4C.isChecked():
            self.dlg.D4CcomboBox.setHidden(False)
            self.dlg.D4CcomboBox.setEnabled(True)

            self.dlg.OpenDataURL.setEnabled(False)
            self.dlg.label_urlOpendata.setHidden(True)
            self.dlg.OpenDataURL.setHidden(True)
            self.dlg.radioDataGouvOrga.setHidden(True)
            self.dlg.radioDataGouvDataset.setHidden(True)

        elif self.dlg.radioODS.isChecked():
            self.dlg.label_urlOpendata.setText("URL Opendatasoft :")
            self.dlg.OpenDataURL.setEnabled(True)
            self.dlg.label_urlOpendata.setHidden(False)
            self.dlg.OpenDataURL.setHidden(False)
            self.dlg.radioDataGouvOrga.setHidden(True)
            self.dlg.radioDataGouvDataset.setHidden(True)

            self.dlg.D4CcomboBox.setHidden(True)
            self.dlg.D4CcomboBox.setEnabled(False)
        elif self.dlg.radioCKAN.isChecked():
            self.dlg.label_urlOpendata.setText("URL CKAN :")
            self.dlg.OpenDataURL.setEnabled(True)
            self.dlg.label_urlOpendata.setHidden(False)
            self.dlg.OpenDataURL.setHidden(False)
            self.dlg.radioDataGouvOrga.setHidden(True)
            self.dlg.radioDataGouvDataset.setHidden(True)

            self.dlg.D4CcomboBox.setHidden(True)
            self.dlg.D4CcomboBox.setEnabled(False)

    # Simule le comportement de boutons radio pour les checkboxs
    def radioLikeForGouvData(self):
        if self.dlg.radioDataGouvOrga.isChecked():
            self.dlg.radioDataGouvOrga.setChecked(False)
            self.dlg.listResourceOpenData.clear()
            self.dlg.listOpenData.clear()
            self.opendatadict = {}
        self.dlg.radioDataGouvDataset.setChecked(True)
    
    def radioLikeForGouvOrga(self):
        if self.dlg.radioDataGouvDataset.isChecked():
            self.dlg.radioDataGouvDataset.setChecked(False)
            self.dlg.listResourceOpenData.clear()
            self.dlg.listOpenData.clear()
            self.opendatadict = {}
        self.dlg.radioDataGouvOrga.setChecked(True)

    # Agrandir la fenêtre pour afficher l'aperçu
    def showPreviewOpenData(self):
        if self.dlg.checkPreviewOpenData.isChecked():
            self.dlg.setMaximumSize(900,622)
            self.dlg.resize(900,622)
        else:
            self.dlg.setMaximumSize(627,622)
            self.dlg.resize(627,622)


    # Mise à jour de l'apperçu
    def updatePreviewOpenData(self):


        selected_resource = self.dlg.listResourceOpenData.currentItem()

        # No need to reload if the previous resource is the same
        if self.previousOpenDataResource is not None:
            if self.previousOpenDataResource == selected_resource.text():
                return
        self.previousOpenDataResource = selected_resource.text()
            

        if selected_resource:
            data = None
            self.dlg.tableWidget.clear()

            selected_resource = selected_resource.text()
            if self.dlg.radioDataGouvOrga.isChecked() and self.dlg.radioDataGouv.isChecked():
                resource_format = 'csv'
            else:
                if self.opendatadict[self.dlg.listOpenData.currentItem().text()][self.dlg.listResourceOpenData.currentRow()].__len__() == 3:
                    resource_format = self.opendatadict[self.dlg.listOpenData.currentItem().text()][self.dlg.listResourceOpenData.currentRow()][2]
                else:
                    return
            if resource_format != 'csv' and resource_format != 'CSV' and resource_format != 'Csv':
                
                self.dlg.tableWidget.setRowCount(1)
                self.dlg.tableWidget.setColumnCount(1)
                self.dlg.tableWidget.setItem(0, 0, QtWidgets.QTableWidgetItem('Aperçu non disponible pour les fichiers non CSV'))                  
                return
            else:
                # implement the method for data gouv
                if self.dlg.radioDataGouv.isChecked():
                    if self.dlg.radioDataGouvOrga.isChecked():
                        url = self.opendatadict[self.dlg.listResourceOpenData.currentItem().text()][0][1]
                    else:
                        url = self.opendatadict[self.dlg.listOpenData.currentItem().text()][self.dlg.listResourceOpenData.currentRow()][1]
                    response = requests.get(url)
                    if response.status_code == 200:
                        data = response.text
                        i = 0
                        try:

                            csv_data = csv.reader(data.splitlines(), delimiter=self.detect_delimiter(data.splitlines()[0]))
                            list_data = list(csv_data)
                        except Exception as e:
                            self.show_error_message('Impossible de charger la prévisualisation du fichier : ' + str(e))
                            return
                        self.dlg.tableWidget.setRowCount(100 if len(list_data) > 100 else len(list_data))
                        self.dlg.tableWidget.setColumnCount(len(list_data[0]))
                        self.dlg.tableWidget.setHorizontalHeaderLabels(list_data[0])
                        for line in list_data:
                            #skip the first line
                            if i == 0:
                                i+=1
                                continue
                            for j in range(len(line)):
                                self.dlg.tableWidget.setItem(i-1, j, QtWidgets.QTableWidgetItem(line[j]))
                            i+=1
                
                            
                    else:
                        self.show_error_message('Error downloading file : ' + str(response.status_code))
                        return
                    
                if self.dlg.radioCKAN.isChecked() or self.dlg.radioODS.isChecked() or self.dlg.radioD4C.isChecked():
                    url = self.opendatadict[self.dlg.listOpenData.currentItem().text()][self.dlg.listResourceOpenData.currentRow()][1]
                    response = requests.get(url)
                    if response.status_code == 200:
                        data = response.text
                        i = 0
                        try:
                            csv_data = csv.reader(data.splitlines(), delimiter=self.detect_delimiter(data.splitlines()[0]))
                            list_data = list(csv_data)
                        except Exception as e:
                            self.show_error_message('Impossible de charger la prévisualisation du fichier : ' + str(e))
                            return
                        self.dlg.tableWidget.setRowCount(100 if len(list_data) > 100 else len(list_data))
                        self.dlg.tableWidget.setColumnCount(len(list_data[0]))
                        self.dlg.tableWidget.setHorizontalHeaderLabels(list_data[0])
                        for line in list_data:
                            #skip the first line
                            if i == 0:
                                i+=1
                                continue
                            for j in range(len(line)):
                                self.dlg.tableWidget.setItem(i-1, j, QtWidgets.QTableWidgetItem(line[j]))
                            i+=1

    # Détecter le délimiteur d'un fichier CSV (, ou ;)
    def detect_delimiter(self, text):
        if ',' in text:
            return ','
        elif ';' in text:
            return ';'
        else:
            return ','
        
    # Ajoute les sites openData présent dans D4C_sites.json
    def setupD4CcomboBox(self):
        file_path = self.plugin_dir / 'D4C_sites.json'
        with open(str(file_path), 'r') as f:
            data = json.load(f)
            for site in data['sites']:
                self.dlg.D4CcomboBox.addItem(site['name'])

    def searchBarOpenData(self):

        search_text = self.dlg.searchOpenData.text().strip().lower()

        for index in range(self.dlg.listResourceOpenData.count()):
            item = self.dlg.listResourceOpenData.item(index)
            if search_text in item.text().lower():
                item.setHidden(False)
            else:
                item.setHidden(True)


    def openGeoParams(self):
        self.windowGeoParams = QtWidgets.QDialog()
        self.uiGeoParams = Ui_GeoParams()
        self.uiGeoParams.setupUi(self.windowGeoParams)

        self.uiGeoParams.lineGeo2.setHidden(True)
        self.uiGeoParams.label_lon.setHidden(True)
        if self.dlg.tabWidget.currentIndex() == 0:
            if self.dlg.resourcesList.currentItem() is None:
                return
            selected_resource = self.dlg.resourcesList.currentItem()
            if selected_resource:
                selected_resource = selected_resource.text()        
                url = self.resourceDict[selected_resource]
                if not(url.endswith('.csv')):
                    return
        if self.dlg.tabWidget.currentIndex() == 3:
            if self.dlg.listResourceOpenData.currentItem() is None:
                return
            # if preview is not available
            if self.dlg.tableWidget.item(0,1 ) is None:
                return 
            
        # Récupérer les headers du tablewidget 
        for i in range(self.dlg.tableWidget.columnCount()):
            if self.dlg.tableWidget.horizontalHeaderItem(i):
                self.uiGeoParams.lineGeo1.addItem(self.dlg.tableWidget.horizontalHeaderItem(i).text())
                self.uiGeoParams.lineGeo2.addItem(self.dlg.tableWidget.horizontalHeaderItem(i).text())
       
        
        self.uiGeoParams.pushAddGeoParam.clicked.connect(self.addGeoParam)
        self.uiGeoParams.comboColumnType.currentIndexChanged.connect(self.geoParamsColumnTypeChanged)
        self.uiGeoParams.pushCancel.clicked.connect(self.windowGeoParams.close)
        self.uiGeoParams.pushDeleteWord.clicked.connect(self.openDeleteGeoParam)
        
        if not pathlib.Path.exists(pathlib.Path.home() / '.d4cplugin' /  'enums_cache_jdd.txt'):
                with open(str(pathlib.Path.home() / '.d4cplugin' /  'enums_cache_jdd.txt'), 'w') as fichier:
                    fichier.write('')
        
        #Mettre les paramètres de la géolocalisation si ils sont enregistrés
        if self.dlg.tabWidget.currentIndex() == 0:
            datasetID = self.dlg.datasetId.toPlainText()
            resourceID = self.dlg.resourcesList.currentItem().text()
            siteField = self.dlg.siteField.toPlainText()

            
            cache_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_cache_jdd.txt')
            with open(cache_file_path, 'r') as fichier:
                lignes_cache = fichier.readlines()
            
            if lignes_cache: 
                for ligne in lignes_cache:
                    if ligne.split('!!')[1] == datasetID and ligne.split('!!')[2] == resourceID and ligne.split('!!')[3] == siteField:
                        if ligne.split('!!')[0] == '1':
                            self.uiGeoParams.comboColumnType.setCurrentIndex(1)

                            self.uiGeoParams.lineGeo1.setCurrentText(ligne.split('!!')[4].split(',')[0])
                            self.uiGeoParams.lineGeo2.setCurrentText(ligne.split('!!')[4].split(',')[1].replace('\n', ''))
                            
                        else:
                            self.uiGeoParams.lineGeo1.setCurrentText(ligne.split('!!')[4])
        elif self.dlg.tabWidget.currentIndex() == 3:
            
            datasetID = self.dlg.listOpenData.currentItem().text()
            resourceID = self.dlg.listResourceOpenData.currentItem().text()
            if self.dlg.radioDataGouvOrga.isChecked():
                ODsource = 'data.gouv.fr'
            elif self.dlg.radioD4C.isChecked():
                ODsource = 'Data4Citizen'
            elif self.dlg.radioODS.isChecked():
                ODsource = 'ODS'
            elif self.dlg.radioCKAN.isChecked():
                ODsource = 'CKAN'

            cache_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_cache_jdd.txt')
            with open(cache_file_path, 'r') as fichier:
                lignes_cache = fichier.readlines()
            
            if lignes_cache: 
                for ligne in lignes_cache:
                    if ligne.split('!!')[1] == datasetID and ligne.split('!!')[2] == resourceID and ligne.split('!!')[3] == ODsource:
                        if ligne.split('!!')[0] == '1':
                            self.uiGeoParams.comboColumnType.setCurrentIndex(1)                            

                            self.uiGeoParams.lineGeo1.setCurrentText(ligne.split('!!')[4].split(',')[0])
                            self.uiGeoParams.lineGeo2.setCurrentText(ligne.split('!!')[4].split(',')[1].replace('\n', ''))

                            
                        else:
                            self.uiGeoParams.lineGeo1.setCurrentText(ligne.split('!!')[4])

        self.windowGeoParams.exec_()


    def addGeoParam(self):
        if self.uiGeoParams.comboColumnType.currentIndex() == 0:
            
            if self.uiGeoParams.lineGeo1.currentText() == '':
                self.show_info_message(self.tr('Veuillez entrer un nom de colonne'))
                return
            
            # Mot ou tuple à ajouter
            geolabel = self.uiGeoParams.lineGeo1.currentText() 

            # Chemin du fichier d'énumération
            enum_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_geo.txt')
            
            # Lire les données actuelles du fichier
            with open(enum_file_path, 'r') as fichier:
                lignes = fichier.readlines()
            
            # Vérifier si le mot ou le tuple existe déjà
            if geolabel + '\n' not in lignes:
                # Ajouter le mot ou le tuple à la liste
                lignes.append(geolabel + '\n')
            
            # Ajouter dans le cache
            cache_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_cache_jdd.txt')

            # Lire les données actuelles du fichier
            with open(cache_file_path, 'r') as fichier:
                lignes_cache = fichier.readlines()

            if self.dlg.tabWidget.currentIndex() == 0:
                # Former le cache 
                cache = ('0' + '!!' 
                        + self.dlg.datasetId.toPlainText() + '!!'
                        +  self.dlg.resourcesList.currentItem().text() + '!!'
                        + self.dlg.siteField.toPlainText() + '!!'
                        + geolabel + '\n')
            elif self.dlg.tabWidget.currentIndex() == 3:
                
                if self.dlg.radioDataGouvOrga.isChecked():
                    ODsource = 'data.gouv.fr'
                elif self.dlg.radioD4C.isChecked():
                    ODsource = 'Data4Citizen'
                elif self.dlg.radioODS.isChecked():
                    ODsource = 'ODS'
                elif self.dlg.radioCKAN.isChecked():
                    ODsource = 'CKAN'
                cache = ('0' + '!!'
                         + self.dlg.listOpenData.currentItem().text() + '!!'
                         + self.dlg.listResourceOpenData.currentItem().text() + '!!'
                            + ODsource + '!!'
                            + geolabel + '\n')
            
        
            # Écrire les nouvelles données dans le fichier
            with open(cache_file_path, 'w') as fichier:
                if lignes_cache:
                    for ligne in lignes_cache:

                        if cache.split('!!')[1] == ligne.split('!!')[1] and cache.split('!!')[2] == ligne.split('!!')[2] and cache.split('!!')[3] == ligne.split('!!')[3]:
                            lignes_cache.remove(ligne)
                    if lignes_cache:
                        fichier.writelines(lignes_cache)
                        fichier.writelines(cache)
                    else:
                        fichier.writelines(cache)
                else:
                    fichier.writelines(cache)
                    


        if self.uiGeoParams.comboColumnType.currentIndex() == 1:

            if self.uiGeoParams.lineGeo1.currentText() == '':
                self.show_info_message(self.tr('Veuillez entrer un nom de colonne pour la latitude'))
                return
             
            if self.uiGeoParams.lineGeo2.currentText() == '':
                self.show_info_message(self.tr('Veuillez entrer un nom de colonne pour la longitude'))
                return
            
            # Mot ou tuple à ajouter
            if self.uiGeoParams.lineGeo1.currentText() == self.uiGeoParams.lineGeo2.currentText():
                self.show_info_message(self.tr('Veuillez entrer des noms de colonne différents'))
                return
            geolabel = (self.uiGeoParams.lineGeo1.currentText(), self.uiGeoParams.lineGeo2.currentText())
            enum_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_tuple_geo.txt')

            # Lire les données actuelles du fichier
            with open(enum_file_path, 'r') as fichier:
                lignes = fichier.readlines()

            # Convertir les chaînes en tuples
            tuples_existants = [tuple(ligne.strip().split(',')) for ligne in lignes]
            if geolabel not in tuples_existants:
                # Ajouter le tuple à la liste
                lignes.append(','.join(geolabel) + '\n')
            
            # Ajouter dans le cache
            cache_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_cache_jdd.txt')

            # Lire les données actuelles du fichier
            with open(cache_file_path, 'r') as fichier:
                lignes_cache = fichier.readlines()
            if self.dlg.tabWidget.currentIndex() == 0:
                
                # Former le cache 
                cache = ('1' + '!!' 
                        + self.dlg.datasetId.toPlainText() + '!!'
                        + self.dlg.resourcesList.currentItem().text() + '!!'
                        + self.dlg.siteField.toPlainText() + '!!'
                        + geolabel[0] + ',' + geolabel[1] + '\n')
            
            elif self.dlg.tabWidget.currentIndex() == 3:

                if self.dlg.radioDataGouvOrga.isChecked():
                    ODsource = 'data.gouv.fr'
                elif self.dlg.radioD4C.isChecked():
                    ODsource = 'Data4Citizen'
                elif self.dlg.radioODS.isChecked():
                    ODsource = 'ODS'
                elif self.dlg.radioCKAN.isChecked():
                    ODsource = 'CKAN'
                cache = ('1' + '!!'
                         + self.dlg.listOpenData.currentItem().text() + '!!'
                         + self.dlg.listResourceOpenData.currentItem().text() + '!!'
                         + ODsource + '!!'
                          + geolabel[0] + ',' + geolabel[1] + '\n')
            
            # Écrire les nouvelles données dans le fichier
            with open(cache_file_path, 'w') as fichier:
                if lignes_cache:
                    for ligne in lignes_cache:
                        if cache.split('!!')[1] == ligne.split('!!')[1] and cache.split('!!')[2] == ligne.split('!!')[2] and cache.split('!!')[3] == ligne.split('!!')[3]:
                            lignes_cache.remove(ligne)
                    if lignes_cache:
                        fichier.writelines(lignes_cache)
                        fichier.writelines(cache)
                    else:
                        fichier.writelines(cache)
                else:
                    fichier.writelines(cache)
            
        # Écrire les nouvelles données dans le fichier
        with open(enum_file_path, 'w') as fichier:
            fichier.writelines(lignes)
        self.show_success_message(f"{geolabel} ajouté avec succès.")
            
        
    def geoParamsColumnTypeChanged(self):
        
        if self.uiGeoParams.comboColumnType.currentIndex() == 0:
            self.uiGeoParams.lineGeo2.setHidden(True)
            self.uiGeoParams.label_lon.setHidden(True)
            self.uiGeoParams.label_lat.setText("Nom de la colonne :")
        
        if self.uiGeoParams.comboColumnType.currentIndex() == 1:
            self.uiGeoParams.lineGeo2.setHidden(False)
            self.uiGeoParams.label_lon.setHidden(False)
            self.uiGeoParams.label_lat.setText("Nom de la colonne pour la latitude :")
            self.uiGeoParams.label_lon.setText("Nom de la colonne pour la longitude :")


    def openDeleteGeoParam(self):
        #Create a dialog with a combobox to select the word to delete
        self.windowDeleteGeoParam = QtWidgets.QDialog()
        self.uiDeleteGeoParam = Ui_DeleteGeoParam()
        self.uiDeleteGeoParam.setupUi(self.windowDeleteGeoParam)

        with open(str(pathlib.Path.home() / '.d4cplugin' /  'enums_geo.txt'), 'r') as fichier:
            lignes = fichier.readlines()
            for ligne in lignes:
                self.uiDeleteGeoParam.comboBox_wordToDelete.addItem(ligne.replace('\n', ''))
        
        self.uiDeleteGeoParam.comboBox_wordToDelete.addItem('------ Tuples ------')

        with open(str(pathlib.Path.home() / '.d4cplugin' /  'enums_tuple_geo.txt'), 'r') as fichier:
            lignes = fichier.readlines()
            for ligne in lignes:
                self.uiDeleteGeoParam.comboBox_wordToDelete.addItem(ligne.replace('\n', ''))

        self.uiDeleteGeoParam.pushDelete.clicked.connect(self.deleteGeoParam)
        self.uiDeleteGeoParam.pushCancel.clicked.connect(self.windowDeleteGeoParam.close)

        self.windowDeleteGeoParam.exec_()

    def deleteGeoParam(self):

        word_to_delete = self.uiDeleteGeoParam.comboBox_wordToDelete.currentText()

        if word_to_delete == '------ Tuples ------':
            return
        if word_to_delete == '':
            self.show_info_message(self.tr('Veuillez sélectionner un mot ou un tuple à supprimer'))
            return
        
        if ',' in word_to_delete:
            enum_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_tuple_geo.txt')

            # Lire les données actuelles du fichier
            with open(enum_file_path, 'r') as fichier:
                lignes = fichier.readlines()

            # Convertir les chaînes en tuples
            tuples_existants = [tuple(ligne.strip().split(',')) for ligne in lignes]
            word_to_delete = tuple(word_to_delete.strip().split(','))
            
            # supprimer le tuple de la liste
            tuples_existants.remove(word_to_delete)

            # Écrire les nouvelles données dans le fichier
            with open(enum_file_path, 'w') as fichier:
                for ligne in tuples_existants:
                    fichier.write(','.join(ligne) + '\n')
        else:
            enum_file_path = str(pathlib.Path.home() / '.d4cplugin' /  'enums_geo.txt')

            # Lire les données actuelles du fichier
            with open(enum_file_path, 'r') as fichier:
                lignes = fichier.readlines()
            
            # supprimer le mot de la liste
            lignes.remove(word_to_delete + '\n')

            # Écrire les nouvelles données dans le fichier
            with open(enum_file_path, 'w') as fichier:
                fichier.writelines(lignes)

        self.show_success_message(f"{word_to_delete} supprimé avec succès.")
        self.windowDeleteGeoParam.close()

