/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var e=function(t,e){return void 0!==t?t:e};return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var e=function(t){this.name="DeveloperError",this.message=t;var e;try{throw new Error}catch(n){e=n.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^t>>>1^e[1&t];for(;n<this.N-1;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=t<<7&2636928640,t^=t<<15&4022730752,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,e,n,r){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(t){return t>0?1:0>t?-1:0},i.signNotZero=function(t){return 0>t?-1:1},i.toSNorm=function(t){return Math.round(255*(.5*i.clamp(t,-1,1)+.5))},i.fromSNorm=function(t){return i.clamp(t,0,255)/255*2-1},i.sinh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e-n)},i.cosh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e+n)},i.lerp=function(t,e,n){return(1-n)*t+n*e},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(t){return t*i.RADIANS_PER_DEGREE},i.toDegrees=function(t){return t*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(t){var e=i.TWO_PI,n=t-Math.floor(t/e)*e;return n<-Math.PI?n+e:n>=Math.PI?n-e:n},i.negativePiToPi=function(t){return i.zeroToTwoPi(t+i.PI)-i.PI},i.zeroToTwoPi=function(t){var e=i.mod(t,i.TWO_PI);return Math.abs(e)<i.EPSILON14&&Math.abs(t)>i.EPSILON14?i.TWO_PI:e},i.mod=function(t,e){return(t%e+e)%e},i.equalsEpsilon=function(t,n,r,i){i=e(i,r);var a=Math.abs(t-n);return i>=a||a<=r*Math.max(Math.abs(t),Math.abs(n))};var a=[1];i.factorial=function(t){var e=a.length;if(t>=e)for(var n=a[e-1],r=e;t>=r;r++)a.push(n*r);return a[t]},i.incrementWrap=function(t,n,r){return r=e(r,0),++t,t>n&&(t=r),t},i.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},i.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},i.clamp=function(t,e,n){return e>t?e:t>n?n:t};var o=new t;return i.setRandomNumberSeed=function(e){o=new t(e)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(t){return Math.acos(i.clamp(t,-1,1))},i.asinClamped=function(t){return Math.asin(i.clamp(t,-1,1))},i.chordLength=function(t,e){return 2*e*Math.sin(.5*t)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)};a.fromSpherical=function(n,r){e(r)||(r=new a);var i=n.clock,o=n.cone,u=t(n.magnitude,1),E=u*Math.sin(o);return r.x=E*Math.cos(i),r.y=E*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(t,n,r,i){return e(i)?(i.x=t,i.y=n,i.z=r,i):new a(t,n,r)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n):new a(t.x,t.y,t.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r]=e.z},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var E=new a,s=new a;a.angleBetween=function(t,e){a.normalize(t,E),a.normalize(e,s);var n=a.dot(E,s),r=a.magnitude(a.cross(E,s,E));return Math.atan2(r,n)};var _=new a;a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,_);return a.abs(n,n),e=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Z,e):n.y<=n.z?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_Z,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)&&i.equalsEpsilon(t.z,n.z,r,a)},a.cross=function(t,e,n){var r=t.x,i=t.y,a=t.z,o=e.x,u=e.y,E=e.z,s=i*E-a*u,_=a*o-r*E,c=r*u-i*o;return n.x=s,n.y=_,n.z=c,n},a.fromDegrees=function(t,e,n,r,o){var u=i.toRadians(t),E=i.toRadians(e);return a.fromRadians(u,E,n,r,o)};var c=new a,R=new a,T=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=t(i,0);var E=e(o)?o.radiiSquared:T,s=Math.cos(r);c.x=s*Math.cos(n),c.y=s*Math.sin(n),c.z=Math.sin(r),c=a.normalize(c,c),a.multiplyComponents(E,c,R);var _=Math.sqrt(a.dot(c,R));return R=a.divideByScalar(R,_,R),c=a.multiplyByScalar(c,i,c),e(u)||(u=new a),a.add(R,c,u)},a.fromDegreesArray=function(t,e,n){for(var r=new Array(t.length),o=0;o<t.length;o++)r[o]=i.toRadians(t[o]);return a.fromRadiansArray(r,e,n)},a.fromRadiansArray=function(t,n,r){var i=t.length;e(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=t[o],E=t[o+1];r[o/2]=a.fromRadians(u,E,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(t,e,n){for(var r=new Array(t.length),o=0;o<t.length;o+=3)r[o]=i.toRadians(t[o]),r[o+1]=i.toRadians(t[o+1]),r[o+2]=t[o+2];return a.fromRadiansArrayHeights(r,e,n)},a.fromRadiansArrayHeights=function(t,n,r){var i=t.length;e(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=t[o],E=t[o+1],s=t[o+2];r[o/3]=a.fromRadians(u,E,s,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)};return a.fromRadians=function(n,r,i,o){return i=t(i,0),e(o)?(o.longitude=n,o.latitude=r,o.height=i,o):new a(n,r,i)},a.fromDegrees=function(t,e,n,r){return t=i.toRadians(t),e=i.toRadians(e),a.fromRadians(t,e,n,r)},a.clone=function(t,n){return e(t)?e(n)?(n.longitude=t.longitude,n.latitude=t.latitude,n.height=t.height,n):new a(t.longitude,t.latitude,t.height):void 0},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.longitude===n.longitude&&t.latitude===n.latitude&&t.height===n.height},a.equalsEpsilon=function(t,n,r){return t===n||e(t)&&e(n)&&Math.abs(t.longitude-n.longitude)<=r&&Math.abs(t.latitude-n.latitude)<=r&&Math.abs(t.height-n.height)<=r},a.ZERO=r(new a(0,0,0)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(t,e){"use strict";var n={},r=function(e,r){t(n[e])||(n[e]=!0,console.log(r))};return r}),define("Core/defineProperties",["./defined"],function(t){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),n=Object.defineProperties;return e&&t(n)||(n=function(t){return t}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a,o,u){"use strict";function E(e,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),e._radii=new t(r,i,a),e._radiiSquared=new t(r*r,i*i,a*a),e._radiiToTheFourth=new t(r*r*r*r,i*i*i*i,a*a*a*a),e._oneOverRadii=new t(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),e._oneOverRadiiSquared=new t(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),e._minimumRadius=Math.min(r,i,a),e._maximumRadius=Math.max(r,i,a),e._centerToleranceSquared=u.EPSILON1}var s=function(t,e,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,E(this,t,e,n)};i(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(e,n){if(!r(e))return void 0;var i=e._radii;return r(n)?(t.clone(i,n._radii),t.clone(e._radiiSquared,n._radiiSquared),t.clone(e._radiiToTheFourth,n._radiiToTheFourth),t.clone(e._oneOverRadii,n._oneOverRadii),t.clone(e._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=e._minimumRadius,n._maximumRadius=e._maximumRadius,n._centerToleranceSquared=e._centerToleranceSquared,n):new s(i.x,i.y,i.z)},s.fromCartesian3=function(t,e){return r(e)||(e=new s),r(t)?(E(e,t.x,t.y,t.z),e):e},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(t){return s.clone(this,t)},s.packedLength=t.packedLength,s.pack=function(e,r,i){i=n(i,0),t.pack(e._radii,r,i)},s.unpack=function(e,r,i){r=n(r,0);var a=t.unpack(e,r);return s.fromCartesian3(a,i)},s.prototype.geocentricSurfaceNormal=t.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(e,n){var i=e.longitude,a=e.latitude,o=Math.cos(a),u=o*Math.cos(i),E=o*Math.sin(i),s=Math.sin(a);return r(n)||(n=new t),n.x=u,n.y=E,n.z=s,t.normalize(n,n)},s.prototype.geodeticSurfaceNormal=function(e,n){return r(n)||(n=new t),n=t.multiplyComponents(e,this._oneOverRadiiSquared,n),t.normalize(n,n)};var _=new t,c=new t;s.prototype.cartographicToCartesian=function(e,n){var i=_,a=c;this.geodeticSurfaceNormalCartographic(e,i),t.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(t.dot(i,a));return t.divideByScalar(a,o,a),t.multiplyByScalar(i,e.height,i),r(n)||(n=new t),t.add(a,i,n)},s.prototype.cartographicArrayToCartesianArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var i=0;n>i;i++)e[i]=this.cartographicToCartesian(t[i],e[i]);return e};var R=new t,T=new t,l=new t;s.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,T);if(!r(a))return void 0;var o=this.geodeticSurfaceNormal(a,R),E=t.subtract(n,a,l),s=Math.atan2(o.y,o.x),_=Math.asin(o.z),c=u.sign(t.dot(E,n))*t.magnitude(E);return r(i)?(i.longitude=s,i.latitude=_,i.height=c,i):new e(s,_,c)},s.prototype.cartesianArrayToCartographicArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var i=0;n>i;++i)e[i]=this.cartesianToCartographic(t[i],e[i]);return e};var A=new t,N=new t;return s.prototype.scaleToGeodeticSurface=function(e,n){var i=e.x,a=e.y,o=e.z,E=this._oneOverRadii,s=E.x,_=E.y,c=E.z,R=i*i*s*s,T=a*a*_*_,l=o*o*c*c,f=R+T+l,h=Math.sqrt(1/f),I=t.multiplyByScalar(e,h,A);if(f<this._centerToleranceSquared)return isFinite(h)?t.clone(I,n):void 0;var m=this._oneOverRadiiSquared,d=m.x,S=m.y,O=m.z,M=N;M.x=I.x*d*2,M.y=I.y*S*2,M.z=I.z*O*2;var y,p,C,F,L,U,P,v,D,w,B,x=(1-h)*t.magnitude(e)/(.5*t.magnitude(M)),g=0;do{x-=g,C=1/(1+x*d),F=1/(1+x*S),L=1/(1+x*O),U=C*C,P=F*F,v=L*L,D=U*C,w=P*F,B=v*L,y=R*U+T*P+l*v-1,p=R*D*d+T*w*S+l*B*O;var z=-2*p;g=y/z}while(Math.abs(y)>u.EPSILON12);return r(n)?(n.x=i*C,n.y=a*F,n.z=o*L,n):new t(i*C,a*F,o*L)},s.prototype.scaleToGeocentricSurface=function(e,n){r(n)||(n=new t);var i=e.x,a=e.y,o=e.z,u=this._oneOverRadiiSquared,E=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return t.multiplyByScalar(e,E,n)},s.prototype.transformPositionToScaledSpace=function(e,n){return r(n)||(n=new t),t.multiplyComponents(e,this._oneOverRadii,n)},s.prototype.transformPositionFromScaledSpace=function(e,n){return r(n)||(n=new t),t.multiplyComponents(e,this._radii,n)},s.prototype.equals=function(e){return this===e||r(e)&&t.equals(this._radii,e._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,e,n,r,i,a,o){"use strict";var u=function(t){this._ellipsoid=n(t,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(e,n){var i=this._semimajorAxis,a=e.longitude*i,o=e.latitude*i,u=e.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new t(a,o,u)},u.prototype.unproject=function(t,n){var i=this._oneOverSemimajorAxis,a=t.x*i,o=t.y*i,u=t.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new e(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return t(e)}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var e=function(e,n){this.start=t(e,0),this.stop=t(n,0)};return e}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)};a.fromElements=function(t,n,r,i,o){return e(o)?(o.x=t,o.y=n,o.z=r,o.w=i,o):new a(t,n,r,i)},a.fromColor=function(t,n){return e(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n.w=t.w,n):new a(t.x,t.y,t.z,t.w):void 0},a.packedLength=4,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n.w=Math.min(t.w,e.w),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n.w=Math.max(t.w,e.w),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e.w=t.w/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n.w=t.w*e.w,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n.w=t.w+e.w,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n.w=t.w-e.w,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n.w=t.w*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n.w=t.w/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e.w=Math.abs(t.w),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var E=new a;return a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,E);return a.abs(n,n),e=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,e):a.clone(a.UNIT_W,e):n.z<=n.w?a.clone(a.UNIT_Z,e):a.clone(a.UNIT_W,e):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_W,e):n.z<=n.w?a.clone(a.UNIT_Z,e):a.clone(a.UNIT_W,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z&&t.w===n.w},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]&&t.w===e[n+3]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)&&i.equalsEpsilon(t.z,n.z,r,a)&&i.equalsEpsilon(t.w,n.w,r,a)},a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a){"use strict";function o(t){for(var e=0,n=0;9>n;++n){var r=t[n];e+=r*r}return Math.sqrt(e)}function u(t){for(var e=0,n=0;3>n;++n){var r=t[s.getElementIndex(T[n],R[n])];e+=2*r*r}return Math.sqrt(e)}function E(t,e){for(var n=a.EPSILON15,r=0,i=1,o=0;3>o;++o){var u=Math.abs(t[s.getElementIndex(T[o],R[o])]);u>r&&(i=o,r=u)}var E=1,_=0,c=R[i],l=T[i];if(Math.abs(t[s.getElementIndex(l,c)])>n){var A,N=t[s.getElementIndex(l,l)],f=t[s.getElementIndex(c,c)],h=t[s.getElementIndex(l,c)],I=(N-f)/2/h;A=0>I?-1/(-I+Math.sqrt(1+I*I)):1/(I+Math.sqrt(1+I*I)),E=1/Math.sqrt(1+A*A),_=A*E}return e=s.clone(s.IDENTITY,e),e[s.getElementIndex(c,c)]=e[s.getElementIndex(l,l)]=E,e[s.getElementIndex(l,c)]=_,e[s.getElementIndex(c,l)]=-_,e}var s=function(t,n,r,i,a,o,u,E,s){this[0]=e(t,0),this[1]=e(i,0),this[2]=e(u,0),this[3]=e(n,0),this[4]=e(a,0),this[5]=e(E,0),this[6]=e(r,0),this[7]=e(o,0),this[8]=e(s,0)};s.packedLength=9,s.pack=function(t,n,r){r=e(r,0),n[r++]=t[0],n[r++]=t[1],n[r++]=t[2],n[r++]=t[3],n[r++]=t[4],n[r++]=t[5],n[r++]=t[6],n[r++]=t[7],n[r++]=t[8]},s.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new s),i[0]=t[r++],i[1]=t[r++],i[2]=t[r++],i[3]=t[r++],i[4]=t[r++],i[5]=t[r++],i[6]=t[r++],i[7]=t[r++],i[8]=t[r++],i},s.clone=function(t,e){return n(t)?n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new s(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},s.fromArray=function(t,r,i){return r=e(r,0),n(i)||(i=new s),i[0]=t[r],i[1]=t[r+1],i[2]=t[r+2],i[3]=t[r+3],i[4]=t[r+4],i[5]=t[r+5],i[6]=t[r+6],i[7]=t[r+7],i[8]=t[r+8],i},s.fromColumnMajorArray=function(t,e){return s.clone(t,e)},s.fromRowMajorArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new s(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},s.fromQuaternion=function(t,e){var r=t.x*t.x,i=t.x*t.y,a=t.x*t.z,o=t.x*t.w,u=t.y*t.y,E=t.y*t.z,_=t.y*t.w,c=t.z*t.z,R=t.z*t.w,T=t.w*t.w,l=r-u-c+T,A=2*(i-R),N=2*(a+_),f=2*(i+R),h=-r+u-c+T,I=2*(E-o),m=2*(a-_),d=2*(E+o),S=-r-u+c+T;return n(e)?(e[0]=l,e[1]=f,e[2]=m,e[3]=A,e[4]=h,e[5]=d,e[6]=N,e[7]=I,e[8]=S,e):new s(l,A,N,f,h,I,m,d,S)},s.fromScale=function(t,e){return n(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new s(t.x,0,0,0,t.y,0,0,0,t.z)},s.fromUniformScale=function(t,e){return n(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new s(t,0,0,0,t,0,0,0,t)},s.fromCrossProduct=function(t,e){return n(e)?(e[0]=0,e[1]=t.z,e[2]=-t.y,e[3]=-t.z,e[4]=0,e[5]=t.x,e[6]=t.y,e[7]=-t.x,e[8]=0,e):new s(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},s.fromRotationX=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=r,e[5]=i,e[6]=0,e[7]=-i,e[8]=r,e):new s(1,0,0,0,r,-i,0,i,r)},s.fromRotationY=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=0,e[2]=-i,e[3]=0,e[4]=1,e[5]=0,e[6]=i,e[7]=0,e[8]=r,e):new s(r,0,i,0,1,0,-i,0,r)},s.fromRotationZ=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=i,e[2]=0,e[3]=-i,e[4]=r,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new s(r,-i,0,i,r,0,0,0,1)},s.toArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},s.getElementIndex=function(t,e){return 3*t+e},s.getColumn=function(t,e,n){var r=3*e,i=t[r],a=t[r+1],o=t[r+2];return n.x=i,n.y=a,n.z=o,n},s.setColumn=function(t,e,n,r){r=s.clone(t,r);var i=3*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},s.getRow=function(t,e,n){var r=t[e],i=t[e+3],a=t[e+6];return n.x=r,n.y=i,n.z=a,n},s.setRow=function(t,e,n,r){return r=s.clone(t,r),r[e]=n.x,r[e+3]=n.y,r[e+6]=n.z,r};var _=new t;s.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],_)),n.y=t.magnitude(t.fromElements(e[3],e[4],e[5],_)),n.z=t.magnitude(t.fromElements(e[6],e[7],e[8],_)),n};var c=new t;s.getMaximumScale=function(e){return s.getScale(e,c),t.maximumComponent(c)},s.multiply=function(t,e,n){var r=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],i=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],a=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],o=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],u=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],E=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],s=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],_=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],c=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=E,n[6]=s,n[7]=_,n[8]=c,n},s.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n},s.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n},s.multiplyByVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[3]*i+t[6]*a,u=t[1]*r+t[4]*i+t[7]*a,E=t[2]*r+t[5]*i+t[8]*a;return n.x=o,n.y=u,n.z=E,n},s.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n},s.multiplyByScale=function(t,e,n){return n[0]=t[0]*e.x,n[1]=t[1]*e.x,n[2]=t[2]*e.x,n[3]=t[3]*e.y,n[4]=t[4]*e.y,n[5]=t[5]*e.y,n[6]=t[6]*e.z,n[7]=t[7]*e.z,n[8]=t[8]*e.z,n},s.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e},s.transpose=function(t,e){var n=t[0],r=t[3],i=t[6],a=t[1],o=t[4],u=t[7],E=t[2],s=t[5],_=t[8];return e[0]=n,e[1]=r,e[2]=i,e[3]=a,e[4]=o,e[5]=u,e[6]=E,e[7]=s,e[8]=_,e};var R=[1,0,0],T=[2,2,1],l=new s,A=new s;return s.computeEigenDecomposition=function(t,e){var r=a.EPSILON20,i=10,_=0,c=0;n(e)||(e={});for(var R=e.unitary=s.clone(s.IDENTITY,e.unitary),T=e.diagonal=s.clone(t,e.diagonal),N=r*o(T);i>c&&u(T)>N;)E(T,l),s.transpose(l,A),s.multiply(T,l,T),s.multiply(A,T,T),s.multiply(R,l,R),++_>2&&(++c,_=0);return e},s.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e},s.determinant=function(t){var e=t[0],n=t[3],r=t[6],i=t[1],a=t[4],o=t[7],u=t[2],E=t[5],s=t[8];return e*(a*s-E*o)+i*(E*r-n*s)+u*(n*o-a*r)},s.inverse=function(t,e){var n=t[0],i=t[1],o=t[2],u=t[3],E=t[4],_=t[5],c=t[6],R=t[7],T=t[8],l=s.determinant(t);if(Math.abs(l)<=a.EPSILON15)throw new r("matrix is not invertible");e[0]=E*T-R*_,e[1]=R*o-i*T,e[2]=i*_-E*o,e[3]=c*_-u*T,e[4]=n*T-c*o,e[5]=u*o-n*_,e[6]=u*R-c*E,e[7]=c*i-n*R,e[8]=n*E-u*i;var A=1/l;return s.multiplyByScalar(e,A,e)},s.equals=function(t,e){return t===e||n(t)&&n(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},s.equalsEpsilon=function(t,e,r){return t===e||n(t)&&n(e)&&Math.abs(t[0]-e[0])<=r&&Math.abs(t[1]-e[1])<=r&&Math.abs(t[2]-e[2])<=r&&Math.abs(t[3]-e[3])<=r&&Math.abs(t[4]-e[4])<=r&&Math.abs(t[5]-e[5])<=r&&Math.abs(t[6]-e[6])<=r&&Math.abs(t[7]-e[7])<=r&&Math.abs(t[8]-e[8])<=r},s.IDENTITY=i(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=i(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]},s.prototype.equalsEpsilon=function(t,e){return s.equalsEpsilon(this,t,e)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var e=function(t){this.name="RuntimeError",this.message=t;var e;try{throw new Error}catch(n){e=n.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,n,r,i,a,o,u,E){"use strict";var s=function(t,e,r,i,a,o,u,E,s,_,c,R,T,l,A,N){this[0]=n(t,0),this[1]=n(a,0),this[2]=n(s,0),this[3]=n(T,0),this[4]=n(e,0),this[5]=n(o,0),this[6]=n(_,0),this[7]=n(l,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(c,0),this[11]=n(A,0),this[12]=n(i,0),this[13]=n(E,0),this[14]=n(R,0),this[15]=n(N,0)};s.packedLength=16,s.pack=function(t,e,r){r=n(r,0),e[r++]=t[0],e[r++]=t[1],e[r++]=t[2],e[r++]=t[3],e[r++]=t[4],e[r++]=t[5],e[r++]=t[6],e[r++]=t[7],e[r++]=t[8],e[r++]=t[9],e[r++]=t[10],e[r++]=t[11],e[r++]=t[12],e[r++]=t[13],e[r++]=t[14],e[r]=t[15]},s.unpack=function(t,e,i){return e=n(e,0),r(i)||(i=new s),i[0]=t[e++],i[1]=t[e++],i[2]=t[e++],i[3]=t[e++],i[4]=t[e++],i[5]=t[e++],i[6]=t[e++],i[7]=t[e++],i[8]=t[e++],i[9]=t[e++],i[10]=t[e++],i[11]=t[e++],i[12]=t[e++],i[13]=t[e++],i[14]=t[e++],i[15]=t[e],i},s.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new s(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},s.fromArray=s.unpack,s.fromColumnMajorArray=function(t,e){return s.clone(t,e)},s.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new s(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},s.fromRotationTranslation=function(e,i,a){return i=n(i,t.ZERO),r(a)?(a[0]=e[0],a[1]=e[1],a[2]=e[2],a[3]=0,a[4]=e[3],a[5]=e[4],a[6]=e[5],a[7]=0,a[8]=e[6],a[9]=e[7],a[10]=e[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new s(e[0],e[3],e[6],i.x,e[1],e[4],e[7],i.y,e[2],e[5],e[8],i.z,0,0,0,1)},s.fromTranslationQuaternionRotationScale=function(t,e,n,i){r(i)||(i=new s);var a=n.x,o=n.y,u=n.z,E=e.x*e.x,_=e.x*e.y,c=e.x*e.z,R=e.x*e.w,T=e.y*e.y,l=e.y*e.z,A=e.y*e.w,N=e.z*e.z,f=e.z*e.w,h=e.w*e.w,I=E-T-N+h,m=2*(_-f),d=2*(c+A),S=2*(_+f),O=-E+T-N+h,M=2*(l-R),y=2*(c-A),p=2*(l+R),C=-E-T+N+h;return i[0]=I*a,i[1]=S*a,i[2]=y*a,i[3]=0,i[4]=m*o,i[5]=O*o,i[6]=p*o,i[7]=0,i[8]=d*u,i[9]=M*u,i[10]=C*u,i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i},s.fromTranslation=function(t,e){return s.fromRotationTranslation(u.IDENTITY,t,e)},s.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new s(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},s.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new s(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var _=new t,c=new t,R=new t;s.fromCamera=function(e,n){var i=e.eye,a=e.target,o=e.up;t.normalize(t.subtract(a,i,_),_),t.normalize(t.cross(_,o,c),c),t.normalize(t.cross(c,_,R),R);var u=c.x,E=c.y,T=c.z,l=_.x,A=_.y,N=_.z,f=R.x,h=R.y,I=R.z,m=i.x,d=i.y,S=i.z,O=u*-m+E*-d+T*-S,M=f*-m+h*-d+I*-S,y=l*m+A*d+N*S;return r(n)?(n[0]=u,n[1]=f,n[2]=-l,n[3]=0,n[4]=E,n[5]=h,n[6]=-A,n[7]=0,n[8]=T,n[9]=I,n[10]=-N,n[11]=0,n[12]=O,n[13]=M,n[14]=y,n[15]=1,n):new s(u,E,T,O,f,h,I,M,-l,-A,-N,y,0,0,0,1)},s.computePerspectiveFieldOfView=function(t,e,n,r,i){var a=Math.tan(.5*t),o=1/a,u=o/e,E=(r+n)/(n-r),s=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=E,i[11]=-1,i[12]=0,i[13]=0,i[14]=s,i[15]=0,i},s.computeOrthographicOffCenter=function(t,e,n,r,i,a,o){var u=1/(e-t),E=1/(r-n),s=1/(a-i),_=-(e+t)*u,c=-(r+n)*E,R=-(a+i)*s;return u*=2,E*=2,s*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=0,o[12]=_,o[13]=c,o[14]=R,o[15]=1,
o},s.computePerspectiveOffCenter=function(t,e,n,r,i,a,o){var u=2*i/(e-t),E=2*i/(r-n),s=(e+t)/(e-t),_=(r+n)/(r-n),c=-(a+i)/(a-i),R=-1,T=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=s,o[9]=_,o[10]=c,o[11]=R,o[12]=0,o[13]=0,o[14]=T,o[15]=0,o},s.computeInfinitePerspectiveOffCenter=function(t,e,n,r,i,a){var o=2*i/(e-t),u=2*i/(r-n),E=(e+t)/(e-t),s=(r+n)/(r-n),_=-1,c=-1,R=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=E,a[9]=s,a[10]=_,a[11]=c,a[12]=0,a[13]=0,a[14]=R,a[15]=0,a},s.computeViewportTransformation=function(t,e,r,i){t=n(t,n.EMPTY_OBJECT);var a=n(t.x,0),o=n(t.y,0),u=n(t.width,0),E=n(t.height,0);e=n(e,0),r=n(r,1);var s=.5*u,_=.5*E,c=.5*(r-e),R=s,T=_,l=c,A=a+s,N=o+_,f=e+c,h=1;return i[0]=R,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=T,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=l,i[11]=0,i[12]=A,i[13]=N,i[14]=f,i[15]=h,i},s.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},s.getElementIndex=function(t,e){return 4*t+e},s.getColumn=function(t,e,n){var r=4*e,i=t[r],a=t[r+1],o=t[r+2],u=t[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},s.setColumn=function(t,e,n,r){r=s.clone(t,r);var i=4*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},s.setTranslation=function(t,e,n){return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=t[15],n},s.getRow=function(t,e,n){var r=t[e],i=t[e+4],a=t[e+8],o=t[e+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},s.setRow=function(t,e,n,r){return r=s.clone(t,r),r[e]=n.x,r[e+4]=n.y,r[e+8]=n.z,r[e+12]=n.w,r};var T=new t;s.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],T)),n.y=t.magnitude(t.fromElements(e[4],e[5],e[6],T)),n.z=t.magnitude(t.fromElements(e[8],e[9],e[10],T)),n};var l=new t;s.getMaximumScale=function(e){return s.getScale(e,l),t.maximumComponent(l)},s.multiply=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[3],u=t[4],E=t[5],s=t[6],_=t[7],c=t[8],R=t[9],T=t[10],l=t[11],A=t[12],N=t[13],f=t[14],h=t[15],I=e[0],m=e[1],d=e[2],S=e[3],O=e[4],M=e[5],y=e[6],p=e[7],C=e[8],F=e[9],L=e[10],U=e[11],P=e[12],v=e[13],D=e[14],w=e[15],B=r*I+u*m+c*d+A*S,x=i*I+E*m+R*d+N*S,g=a*I+s*m+T*d+f*S,z=o*I+_*m+l*d+h*S,G=r*O+u*M+c*y+A*p,b=i*O+E*M+R*y+N*p,X=a*O+s*M+T*y+f*p,V=o*O+_*M+l*y+h*p,H=r*C+u*F+c*L+A*U,W=i*C+E*F+R*L+N*U,q=a*C+s*F+T*L+f*U,Y=o*C+_*F+l*L+h*U,K=r*P+u*v+c*D+A*w,k=i*P+E*v+R*D+N*w,Z=a*P+s*v+T*D+f*w,j=o*P+_*v+l*D+h*w;return n[0]=B,n[1]=x,n[2]=g,n[3]=z,n[4]=G,n[5]=b,n[6]=X,n[7]=V,n[8]=H,n[9]=W,n[10]=q,n[11]=Y,n[12]=K,n[13]=k,n[14]=Z,n[15]=j,n},s.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n[9]=t[9]+e[9],n[10]=t[10]+e[10],n[11]=t[11]+e[11],n[12]=t[12]+e[12],n[13]=t[13]+e[13],n[14]=t[14]+e[14],n[15]=t[15]+e[15],n},s.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n[9]=t[9]-e[9],n[10]=t[10]-e[10],n[11]=t[11]-e[11],n[12]=t[12]-e[12],n[13]=t[13]-e[13],n[14]=t[14]-e[14],n[15]=t[15]-e[15],n},s.multiplyTransformation=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[4],u=t[5],E=t[6],s=t[8],_=t[9],c=t[10],R=t[12],T=t[13],l=t[14],A=e[0],N=e[1],f=e[2],h=e[4],I=e[5],m=e[6],d=e[8],S=e[9],O=e[10],M=e[12],y=e[13],p=e[14],C=r*A+o*N+s*f,F=i*A+u*N+_*f,L=a*A+E*N+c*f,U=r*h+o*I+s*m,P=i*h+u*I+_*m,v=a*h+E*I+c*m,D=r*d+o*S+s*O,w=i*d+u*S+_*O,B=a*d+E*S+c*O,x=r*M+o*y+s*p+R,g=i*M+u*y+_*p+T,z=a*M+E*y+c*p+l;return n[0]=C,n[1]=F,n[2]=L,n[3]=0,n[4]=U,n[5]=P,n[6]=v,n[7]=0,n[8]=D,n[9]=w,n[10]=B,n[11]=0,n[12]=x,n[13]=g,n[14]=z,n[15]=1,n},s.multiplyByMatrix3=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[4],u=t[5],E=t[6],s=t[8],_=t[9],c=t[10],R=e[0],T=e[1],l=e[2],A=e[3],N=e[4],f=e[5],h=e[6],I=e[7],m=e[8],d=r*R+o*T+s*l,S=i*R+u*T+_*l,O=a*R+E*T+c*l,M=r*A+o*N+s*f,y=i*A+u*N+_*f,p=a*A+E*N+c*f,C=r*h+o*I+s*m,F=i*h+u*I+_*m,L=a*h+E*I+c*m;return n[0]=d,n[1]=S,n[2]=O,n[3]=0,n[4]=M,n[5]=y,n[6]=p,n[7]=0,n[8]=C,n[9]=F,n[10]=L,n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=t[15],n},s.multiplyByTranslation=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=r*t[0]+i*t[4]+a*t[8]+t[12],u=r*t[1]+i*t[5]+a*t[9]+t[13],E=r*t[2]+i*t[6]+a*t[10]+t[14];return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=o,n[13]=u,n[14]=E,n[15]=t[15],n};var A=new t;s.multiplyByUniformScale=function(t,e,n){return A.x=e,A.y=e,A.z=e,s.multiplyByScale(t,A,n)},s.multiplyByScale=function(t,e,n){var r=e.x,i=e.y,a=e.z;return 1===r&&1===i&&1===a?s.clone(t,n):(n[0]=r*t[0],n[1]=r*t[1],n[2]=r*t[2],n[3]=0,n[4]=i*t[4],n[5]=i*t[5],n[6]=i*t[6],n[7]=0,n[8]=a*t[8],n[9]=a*t[9],n[10]=a*t[10],n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=1,n)},s.multiplyByVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t[0]*r+t[4]*i+t[8]*a+t[12]*o,E=t[1]*r+t[5]*i+t[9]*a+t[13]*o,s=t[2]*r+t[6]*i+t[10]*a+t[14]*o,_=t[3]*r+t[7]*i+t[11]*a+t[15]*o;return n.x=u,n.y=E,n.z=s,n.w=_,n},s.multiplyByPointAsVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[4]*i+t[8]*a,u=t[1]*r+t[5]*i+t[9]*a,E=t[2]*r+t[6]*i+t[10]*a;return n.x=o,n.y=u,n.z=E,n},s.multiplyByPoint=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[4]*i+t[8]*a+t[12],u=t[1]*r+t[5]*i+t[9]*a+t[13],E=t[2]*r+t[6]*i+t[10]*a+t[14];return n.x=o,n.y=u,n.z=E,n},s.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n[9]=t[9]*e,n[10]=t[10]*e,n[11]=t[11]*e,n[12]=t[12]*e,n[13]=t[13]*e,n[14]=t[14]*e,n[15]=t[15]*e,n},s.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e},s.transpose=function(t,e){var n=t[1],r=t[2],i=t[3],a=t[6],o=t[7],u=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=n,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=r,e[9]=a,e[10]=t[10],e[11]=t[14],e[12]=i,e[13]=o,e[14]=u,e[15]=t[15],e},s.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[3]===e[3]&&t[7]===e[7]&&t[11]===e[11]&&t[15]===e[15]},s.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n&&Math.abs(t[9]-e[9])<=n&&Math.abs(t[10]-e[10])<=n&&Math.abs(t[11]-e[11])<=n&&Math.abs(t[12]-e[12])<=n&&Math.abs(t[13]-e[13])<=n&&Math.abs(t[14]-e[14])<=n&&Math.abs(t[15]-e[15])<=n},s.getTranslation=function(t,e){return e.x=t[12],e.y=t[13],e.z=t[14],e},s.getRotation=function(t,e){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e};var N=new u,f=new u,h=new e,I=new e(0,0,0,1);return s.inverse=function(t,n){if(u.equalsEpsilon(s.getRotation(t,N),f,o.EPSILON7)&&e.equals(s.getRow(t,3,h),I))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-t[12],n[13]=-t[13],n[14]=-t[14],n[15]=1,n;var r=t[0],i=t[4],a=t[8],_=t[12],c=t[1],R=t[5],T=t[9],l=t[13],A=t[2],m=t[6],d=t[10],S=t[14],O=t[3],M=t[7],y=t[11],p=t[15],C=d*p,F=S*y,L=m*p,U=S*M,P=m*y,v=d*M,D=A*p,w=S*O,B=A*y,x=d*O,g=A*M,z=m*O,G=C*R+U*T+P*l-(F*R+L*T+v*l),b=F*c+D*T+x*l-(C*c+w*T+B*l),X=L*c+w*R+g*l-(U*c+D*R+z*l),V=v*c+B*R+z*T-(P*c+x*R+g*T),H=F*i+L*a+v*_-(C*i+U*a+P*_),W=C*r+w*a+B*_-(F*r+D*a+x*_),q=U*r+D*i+z*_-(L*r+w*i+g*_),Y=P*r+x*i+g*a-(v*r+B*i+z*a);C=a*l,F=_*T,L=i*l,U=_*R,P=i*T,v=a*R,D=r*l,w=_*c,B=r*T,x=a*c,g=r*R,z=i*c;var K=C*M+U*y+P*p-(F*M+L*y+v*p),k=F*O+D*y+x*p-(C*O+w*y+B*p),Z=L*O+w*M+g*p-(U*O+D*M+z*p),j=v*O+B*M+z*y-(P*O+x*M+g*y),J=L*d+v*S+F*m-(P*S+C*m+U*d),Q=B*S+C*A+w*d-(D*d+x*S+F*A),$=D*m+z*S+U*A-(g*S+L*A+w*m),tt=g*d+P*A+x*m-(B*m+z*d+v*A),et=r*G+i*b+a*X+_*V;if(Math.abs(et)<o.EPSILON20)throw new E("matrix is not invertible because its determinate is zero.");return et=1/et,n[0]=G*et,n[1]=b*et,n[2]=X*et,n[3]=V*et,n[4]=H*et,n[5]=W*et,n[6]=q*et,n[7]=Y*et,n[8]=K*et,n[9]=k*et,n[10]=Z*et,n[11]=j*et,n[12]=J*et,n[13]=Q*et,n[14]=$*et,n[15]=tt*et,n},s.inverseTransformation=function(t,e){var n=t[0],r=t[1],i=t[2],a=t[4],o=t[5],u=t[6],E=t[8],s=t[9],_=t[10],c=t[12],R=t[13],T=t[14],l=-n*c-r*R-i*T,A=-a*c-o*R-u*T,N=-E*c-s*R-_*T;return e[0]=n,e[1]=a,e[2]=E,e[3]=0,e[4]=r,e[5]=o,e[6]=s,e[7]=0,e[8]=i,e[9]=u,e[10]=_,e[11]=0,e[12]=l,e[13]=A,e[14]=N,e[15]=1,e},s.IDENTITY=a(new s(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN0ROW3=3,s.COLUMN1ROW0=4,s.COLUMN1ROW1=5,s.COLUMN1ROW2=6,s.COLUMN1ROW3=7,s.COLUMN2ROW0=8,s.COLUMN2ROW1=9,s.COLUMN2ROW2=10,s.COLUMN2ROW3=11,s.COLUMN3ROW0=12,s.COLUMN3ROW1=13,s.COLUMN3ROW2=14,s.COLUMN3ROW3=15,s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]&&t[9]===e[n+9]&&t[10]===e[n+10]&&t[11]===e[n+11]&&t[12]===e[n+12]&&t[13]===e[n+13]&&t[14]===e[n+14]&&t[15]===e[n+15]},s.prototype.equalsEpsilon=function(t,e){return s.equalsEpsilon(this,t,e)},s.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},s}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(t,e,n,r){"use strict";var i=function(e,n){this.normal=t.clone(e),this.distance=n};i.fromPointNormal=function(n,r,a){var o=-t.dot(r,n);return e(a)?(t.clone(r,a.normal),a.distance=o,a):new i(r,o)};var a=new t;return i.fromCartesian4=function(n,r){var o=t.fromCartesian4(n,a),u=n.w;return e(r)?(t.clone(o,r.normal),r.distance=u,r):new i(o,u)},i.getPointDistance=function(e,n){return t.dot(e.normal,n)+e.distance},i.ORIGIN_XY_PLANE=r(new i(t.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=r(new i(t.UNIT_X,0)),i.ORIGIN_ZX_PLANE=r(new i(t.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(t,e,n,r,i,a,o,u){"use strict";var E=function(t,n,r,i){this.west=e(t,0),this.south=e(n,0),this.east=e(r,0),this.north=e(i,0)};r(E.prototype,{width:{get:function(){return E.computeWidth(this)}},height:{get:function(){return E.computeHeight(this)}}}),E.packedLength=4,E.pack=function(t,n,r){r=e(r,0),n[r++]=t.west,n[r++]=t.south,n[r++]=t.east,n[r]=t.north},E.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new E),i.west=t[r++],i.south=t[r++],i.east=t[r++],i.north=t[r],i},E.computeWidth=function(t){var e=t.east,n=t.west;return n>e&&(e+=u.TWO_PI),e-n},E.computeHeight=function(t){return t.north-t.south},E.fromDegrees=function(t,r,i,a,o){return t=u.toRadians(e(t,0)),r=u.toRadians(e(r,0)),i=u.toRadians(e(i,0)),a=u.toRadians(e(a,0)),n(o)?(o.west=t,o.south=r,o.east=i,o.north=a,o):new E(t,r,i,a)},E.fromCartographicArray=function(t,e){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,s=t.length;s>u;u++){var _=t[u];r=Math.min(r,_.longitude),i=Math.max(i,_.longitude),a=Math.min(a,_.latitude),o=Math.max(o,_.latitude)}return n(e)?(e.west=r,e.south=a,e.east=i,e.north=o,e):new E(r,a,i,o)},E.clone=function(t,e){return n(t)?n(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new E(t.west,t.south,t.east,t.north):void 0},E.prototype.clone=function(t){return E.clone(this,t)},E.prototype.equals=function(t){return E.equals(this,t)},E.equals=function(t,e){return t===e||n(t)&&n(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},E.prototype.equalsEpsilon=function(t,e){return n(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},E.validate=function(t){},E.southwest=function(e,r){return n(r)?(r.longitude=e.west,r.latitude=e.south,r.height=0,r):new t(e.west,e.south)},E.northwest=function(e,r){return n(r)?(r.longitude=e.west,r.latitude=e.north,r.height=0,r):new t(e.west,e.north)},E.northeast=function(e,r){return n(r)?(r.longitude=e.east,r.latitude=e.north,r.height=0,r):new t(e.east,e.north)},E.southeast=function(e,r){return n(r)?(r.longitude=e.east,r.latitude=e.south,r.height=0,r):new t(e.east,e.south)},E.center=function(e,r){var i=e.east,a=e.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),E=.5*(e.south+e.north);return n(r)?(r.longitude=o,r.latitude=E,r.height=0,r):new t(o,E)},E.intersection=function(t,e,r){var i=t.east,a=t.west,o=e.east,s=e.west;a>i&&o>0?i+=u.TWO_PI:s>o&&i>0&&(o+=u.TWO_PI),a>i&&0>s?s+=u.TWO_PI:s>o&&0>a&&(a+=u.TWO_PI);var _=u.negativePiToPi(Math.max(a,s)),c=u.negativePiToPi(Math.min(i,o));if((t.west<t.east||e.west<e.east)&&_>=c)return void 0;var R=Math.max(t.south,e.south),T=Math.min(t.north,e.north);return R>=T?void 0:n(r)?(r.west=_,r.south=R,r.east=c,r.north=T,r):new E(_,R,c,T)},E.contains=function(t,e){var n=e.longitude,r=e.latitude,i=t.west,a=t.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=t.south&&r<=t.north};var s=new t;return E.subsample=function(t,r,i,o){r=e(r,a.WGS84),i=e(i,0),n(o)||(o=[]);var _=0,c=t.north,R=t.south,T=t.east,l=t.west,A=s;A.height=i,A.longitude=l,A.latitude=c,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.longitude=T,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.latitude=R,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.longitude=l,o[_]=r.cartographicToCartesian(A,o[_]),_++,0>c?A.latitude=c:R>0?A.latitude=R:A.latitude=0;for(var N=1;8>N;++N)A.longitude=-Math.PI+N*u.PI_OVER_TWO,E.contains(t,A)&&(o[_]=r.cartographicToCartesian(A,o[_]),_++);return 0===A.latitude&&(A.longitude=l,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.longitude=T,o[_]=r.cartographicToCartesian(A,o[_]),_++),o.length=_,o},E.MAX_VALUE=o(new E(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),E}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(t,e,n,r,i,a,o,u,E,s,_,c,R){"use strict";var T=function(e,r){this.center=t.clone(n(e,t.ZERO)),this.radius=n(r,0)},l=new t,A=new t,N=new t,f=new t,h=new t,I=new t,m=new t,d=new t,S=new t,O=new t,M=new t,y=new t;T.fromPoints=function(e,n){if(r(n)||(n=new T),!r(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;for(var i=t.clone(e[0],m),a=t.clone(i,l),o=t.clone(i,A),u=t.clone(i,N),E=t.clone(i,f),s=t.clone(i,h),_=t.clone(i,I),c=e.length,R=1;c>R;R++){t.clone(e[R],i);var p=i.x,C=i.y,F=i.z;p<a.x&&t.clone(i,a),p>E.x&&t.clone(i,E),C<o.y&&t.clone(i,o),C>s.y&&t.clone(i,s),F<u.z&&t.clone(i,u),F>_.z&&t.clone(i,_)}var L=t.magnitudeSquared(t.subtract(E,a,d)),U=t.magnitudeSquared(t.subtract(s,o,d)),P=t.magnitudeSquared(t.subtract(_,u,d)),v=a,D=E,w=L;U>w&&(w=U,v=o,D=s),P>w&&(w=P,v=u,D=_);var B=S;B.x=.5*(v.x+D.x),B.y=.5*(v.y+D.y),B.z=.5*(v.z+D.z);var x=t.magnitudeSquared(t.subtract(D,B,d)),g=Math.sqrt(x),z=O;z.x=a.x,z.y=o.y,z.z=u.z;var G=M;G.x=E.x,G.y=s.y,G.z=_.z;var b=t.multiplyByScalar(t.add(z,G,d),.5,y),X=0;for(R=0;c>R;R++){t.clone(e[R],i);var V=t.magnitude(t.subtract(i,b,d));V>X&&(X=V);var H=t.magnitudeSquared(t.subtract(i,B,d));if(H>x){var W=Math.sqrt(H);g=.5*(g+W),x=g*g;var q=W-g;B.x=(g*B.x+q*i.x)/W,B.y=(g*B.y+q*i.y)/W,B.z=(g*B.z+q*i.z)/W}}return X>g?(t.clone(B,n.center),n.radius=g):(t.clone(b,n.center),n.radius=X),n};var p=new u,C=new t,F=new t,L=new e,U=new e;T.fromRectangle2D=function(t,e,n){return T.fromRectangleWithHeights2D(t,e,0,0,n)},T.fromRectangleWithHeights2D=function(e,i,a,o,u){if(r(u)||(u=new T),!r(e))return u.center=t.clone(t.ZERO,u.center),u.radius=0,u;i=n(i,p),R.southwest(e,L),L.height=a,R.northeast(e,U),U.height=o;var E=i.project(L,C),s=i.project(U,F),_=s.x-E.x,c=s.y-E.y,l=s.z-E.z;u.radius=.5*Math.sqrt(_*_+c*c+l*l);var A=u.center;return A.x=E.x+.5*_,A.y=E.y+.5*c,A.z=E.z+.5*l,u};var P=[];T.fromRectangle3D=function(t,e,i,a){e=n(e,o.WGS84),i=n(i,0);var u;return r(t)&&(u=R.subsample(t,e,i,P)),T.fromPoints(u,a)},T.fromVertices=function(e,i,a,o){if(r(o)||(o=new T),!r(e)||0===e.length)return o.center=t.clone(t.ZERO,o.center),o.radius=0,o;i=n(i,t.ZERO),a=n(a,3);var u=m;u.x=e[0]+i.x,u.y=e[1]+i.y,u.z=e[2]+i.z;for(var E=t.clone(u,l),s=t.clone(u,A),_=t.clone(u,N),c=t.clone(u,f),R=t.clone(u,h),p=t.clone(u,I),C=e.length,F=0;C>F;F+=a){var L=e[F]+i.x,U=e[F+1]+i.y,P=e[F+2]+i.z;u.x=L,u.y=U,u.z=P,L<E.x&&t.clone(u,E),L>c.x&&t.clone(u,c),U<s.y&&t.clone(u,s),U>R.y&&t.clone(u,R),P<_.z&&t.clone(u,_),P>p.z&&t.clone(u,p)}var v=t.magnitudeSquared(t.subtract(c,E,d)),D=t.magnitudeSquared(t.subtract(R,s,d)),w=t.magnitudeSquared(t.subtract(p,_,d)),B=E,x=c,g=v;D>g&&(g=D,B=s,x=R),w>g&&(g=w,B=_,x=p);var z=S;z.x=.5*(B.x+x.x),z.y=.5*(B.y+x.y),z.z=.5*(B.z+x.z);var G=t.magnitudeSquared(t.subtract(x,z,d)),b=Math.sqrt(G),X=O;X.x=E.x,X.y=s.y,X.z=_.z;var V=M;V.x=c.x,V.y=R.y,V.z=p.z;var H=t.multiplyByScalar(t.add(X,V,d),.5,y),W=0;for(F=0;C>F;F+=a){u.x=e[F]+i.x,u.y=e[F+1]+i.y,u.z=e[F+2]+i.z;var q=t.magnitude(t.subtract(u,H,d));q>W&&(W=q);var Y=t.magnitudeSquared(t.subtract(u,z,d));if(Y>G){var K=Math.sqrt(Y);b=.5*(b+K),G=b*b;var k=K-b;z.x=(b*z.x+k*u.x)/K,z.y=(b*z.y+k*u.y)/K,z.z=(b*z.z+k*u.z)/K}}return W>b?(t.clone(z,o.center),o.radius=b):(t.clone(H,o.center),o.radius=W),o},T.fromCornerPoints=function(e,n,i){r(i)||(i=new T);var a=i.center;return t.add(e,n,a),t.multiplyByScalar(a,.5,a),i.radius=t.distance(a,n),i},T.fromEllipsoid=function(e,n){return r(n)||(n=new T),t.clone(t.ZERO,n.center),n.radius=e.maximumRadius,n};var v=new t;T.fromBoundingSpheres=function(e,n){if(r(n)||(n=new T),!r(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;var i=e.length;if(1===i)return T.clone(e[0],n);if(2===i)return T.union(e[0],e[1],n);for(var a=[],o=0;i>o;o++)a.push(e[o].center);n=T.fromPoints(a,n);var u=n.center,E=n.radius;for(o=0;i>o;o++){var s=e[o];E=Math.max(E,t.distance(u,s.center,v)+s.radius)}return n.radius=E,n},T.clone=function(e,n){return r(e)?r(n)?(n.center=t.clone(e.center,n.center),n.radius=e.radius,n):new T(e.center,e.radius):void 0},T.packedLength=4,T.pack=function(t,e,r){r=n(r,0);var i=t.center;e[r++]=i.x,e[r++]=i.y,e[r++]=i.z,e[r]=t.radius},T.unpack=function(t,e,i){e=n(e,0),r(i)||(i=new T);var a=i.center;return a.x=t[e++],a.y=t[e++],a.z=t[e++],i.radius=t[e],i};var D=new t,w=new t;T.union=function(e,n,i){r(i)||(i=new T);var a=e.center,o=e.radius,u=n.center,E=n.radius,s=t.subtract(u,a,D),_=t.magnitude(s);if(o>=_+E)return e.clone(i),i;if(E>=_+o)return n.clone(i),i;var c=.5*(o+_+E),R=t.multiplyByScalar(s,(-o+c)/_,w);return t.add(R,a,R),t.clone(R,i.center),i.radius=c,i};var B=new t;T.expand=function(e,n,r){r=T.clone(e,r);var i=t.magnitude(t.subtract(n,r.center,B));return i>r.radius&&(r.radius=i),r},T.intersectPlane=function(e,n){var r=e.center,i=e.radius,a=n.normal,o=t.dot(a,r)+n.distance;return-i>o?E.OUTSIDE:i>o?E.INTERSECTING:E.INSIDE},T.transform=function(t,e,n){return r(n)||(n=new T),n.center=_.multiplyByPoint(e,t.center,n.center),n.radius=_.getMaximumScale(e)*t.radius,n};var x=new t;T.distanceSquaredTo=function(e,n){var r=t.subtract(e.center,n,x);return t.magnitudeSquared(r)-e.radius*e.radius},T.transformWithoutScale=function(t,e,n){return r(n)||(n=new T),n.center=_.multiplyByPoint(e,t.center,n.center),n.radius=t.radius,n};var g=new t;T.computePlaneDistances=function(e,n,i,a){r(a)||(a=new s);var o=t.subtract(e.center,n,g),u=t.dot(i,o);return a.start=u-e.radius,a.stop=u+e.radius,a};for(var z=new t,G=new t,b=new t,X=new t,V=new t,H=new e,W=new Array(8),q=0;8>q;++q)W[q]=new t;var Y=new u;return T.projectTo2D=function(e,r,i){r=n(r,Y);var a=r.ellipsoid,o=e.center,u=e.radius,E=a.geodeticSurfaceNormal(o,z),s=t.cross(t.UNIT_Z,E,G);t.normalize(s,s);var _=t.cross(E,s,b);t.normalize(_,_),t.multiplyByScalar(E,u,E),t.multiplyByScalar(_,u,_),t.multiplyByScalar(s,u,s);var c=t.negate(_,V),R=t.negate(s,X),l=W,A=l[0];t.add(E,_,A),t.add(A,s,A),A=l[1],t.add(E,_,A),t.add(A,R,A),A=l[2],t.add(E,c,A),t.add(A,R,A),A=l[3],t.add(E,c,A),t.add(A,s,A),t.negate(E,E),A=l[4],t.add(E,_,A),t.add(A,s,A),A=l[5],t.add(E,_,A),t.add(A,R,A),A=l[6],t.add(E,c,A),t.add(A,R,A),A=l[7],t.add(E,c,A),t.add(A,s,A);for(var N=l.length,f=0;N>f;++f){var h=l[f];t.add(o,h,h);var I=a.cartesianToCartographic(h,H);r.project(I,h)}i=T.fromPoints(l,i),o=i.center;var m=o.x,d=o.y,S=o.z;return o.x=S,o.y=m,o.z=d,i},T.isOccluded=function(t,e){return!e.isBoundingSphereVisible(t)},T.equals=function(e,n){return e===n||r(e)&&r(n)&&t.equals(e.center,n.center)&&e.radius===n.radius},T.prototype.intersectPlane=function(t){return T.intersectPlane(this,t)},T.prototype.distanceSquaredTo=function(t){return T.distanceSquaredTo(this,t)},T.prototype.computePlaneDistances=function(t,e,n){return T.computePlaneDistances(this,t,e,n)},T.prototype.isOccluded=function(t){return T.isOccluded(this,t)},T.prototype.equals=function(t){return T.equals(this,t)},T.prototype.clone=function(t){return T.clone(this,t)},T}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(t){"use strict";var e={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,
DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return t(e)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(t,e){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return e(i,{element:{get:function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(t(n))return n;n=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var E=a[o];i=E+"RequestFullscreen","function"==typeof e[i]?(r.requestFullscreen=i,n=!0):(i=E+"RequestFullScreen","function"==typeof e[i]&&(r.requestFullscreen=i,n=!0)),i=E+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=E+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=E+"FullscreenEnabled",t(document[i])?r.fullscreenEnabled=i:(i=E+"FullScreenEnabled",t(document[i])&&(r.fullscreenEnabled=i)),i=E+"FullscreenElement",t(document[i])?r.fullscreenElement=i:(i=E+"FullScreenElement",t(document[i])&&(r.fullscreenElement=i)),i=E+"fullscreenchange",t(document["on"+i])&&("ms"===E&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=E+"fullscreenerror",t(document["on"+i])&&("ms"===E&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(t){i.supportsFullscreen()&&t[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(t,e,n){"use strict";function r(t){for(var e=t.split("."),n=0,r=e.length;r>n;++n)e[n]=parseInt(e[n],10);return e}function i(){if(!e(N)){N=!1;var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(N=!0,f=r(t[1]))}return N}function a(){return i()&&f}function o(){if(!e(h)&&(h=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(h=!0,I=r(t[1]))}return h}function u(){return o()&&I}function E(){if(!e(m)){m=!1;var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==t&&(m=!0,d=r(t[1]),d.isNightly=!!t[2])}return m}function s(){return E()&&d}function _(){if(!e(S)){S=!1;var t;"Microsoft Internet Explorer"===navigator.appName?(t=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(S=!0,O=r(t[1]))):"Netscape"===navigator.appName&&(t=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(S=!0,O=r(t[1])))}return S}function c(){return _()&&O}function R(){if(!e(M)){M=!1;var t=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(M=!0,y=r(t[1]))}return M}function T(){return e(p)||(p=/Windows/i.test(navigator.appVersion)),p}function l(){return R()&&y}function A(){return e(C)||(C=e(window.PointerEvent)&&(!e(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),C}var N,f,h,I,m,d,S,O,M,y,p,C,F={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:E,webkitVersion:s,isInternetExplorer:_,internetExplorerVersion:c,isFirefox:R,firefoxVersion:l,isWindows:T,hardwareConcurrency:t(navigator.hardwareConcurrency,3),supportsPointerEvents:A};return F.supportsFullscreen=function(){return n.supportsFullscreen()},F.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},F.supportsWebWorkers=function(){return"undefined"!=typeof Worker},F}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(t,e,n,r,i,a){"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:t.BYTE,UNSIGNED_BYTE:t.UNSIGNED_BYTE,SHORT:t.SHORT,UNSIGNED_SHORT:t.UNSIGNED_SHORT,FLOAT:t.FLOAT,DOUBLE:t.DOUBLE};return o.getSizeInBytes=function(t){switch(t){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(t){return t instanceof Int8Array?o.BYTE:t instanceof Uint8Array?o.UNSIGNED_BYTE:t instanceof Int16Array?o.SHORT:t instanceof Uint16Array?o.UNSIGNED_SHORT:t instanceof Float32Array?o.FLOAT:t instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(t){return n(t)&&(t===o.BYTE||t===o.UNSIGNED_BYTE||t===o.SHORT||t===o.UNSIGNED_SHORT||t===o.FLOAT||t===o.DOUBLE)},o.createTypedArray=function(t,e){switch(t){case o.BYTE:return new Int8Array(e);case o.UNSIGNED_BYTE:return new Uint8Array(e);case o.SHORT:return new Int16Array(e);case o.UNSIGNED_SHORT:return new Uint16Array(e);case o.FLOAT:return new Float32Array(e);case o.DOUBLE:return new Float64Array(e);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(t,n,i,a){switch(i=e(i,0),a=e(a,(n.byteLength-i)/o.getSizeInBytes(t)),t){case o.BYTE:return new Int8Array(n,i,a);case o.UNSIGNED_BYTE:return new Uint8Array(n,i,a);case o.SHORT:return new Int16Array(n,i,a);case o.UNSIGNED_SHORT:return new Uint16Array(n,i,a);case o.FLOAT:return new Float32Array(n,i,a);case o.DOUBLE:return new Float64Array(n,i,a);default:throw new r("componentDatatype is not a valid value.")}},a(o)}),define("Core/GeometryType",["./freezeObject"],function(t){"use strict";var e={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return t(e)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(t,e){"use strict";var n={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(t){return t===n.POINTS||t===n.LINES||t===n.LINE_LOOP||t===n.LINE_STRIP||t===n.TRIANGLES||t===n.TRIANGLE_STRIP||t===n.TRIANGLE_FAN}};return e(n)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(t,e,n,r,i){"use strict";var a=function(e){e=t(e,t.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=t(e.primitiveType,i.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=t(e.geometryType,r.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(t){var r=-1;for(var i in t.attributes)if(t.attributes.hasOwnProperty(i)&&e(t.attributes[i])&&e(t.attributes[i].values)){var a=t.attributes[i],o=a.values.length/a.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t,e,n){"use strict";var r=function(e){e=t(e,t.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=t(e.normalize,!1),this.values=e.values};return r}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";var e=function(e){e=t(e,t.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.binormal=e.binormal,this.tangent=e.tangent,this.color=e.color};return e}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,n,r){"use strict";var i=function(e){e=t(e,t.EMPTY_OBJECT),this.position=t(e.position,!1),this.normal=t(e.normal,!1),this.st=t(e.st,!1),this.binormal=t(e.binormal,!1),this.tangent=t(e.tangent,!1),this.color=t(e.color,!1)};return i.POSITION_ONLY=r(new i({position:!0})),i.POSITION_AND_NORMAL=r(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=r(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=r(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=r(new i({position:!0,color:!0})),i.ALL=r(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(e,n,r){r=t(r,0),n[r++]=e.position?1:0,n[r++]=e.normal?1:0,n[r++]=e.st?1:0,n[r++]=e.binormal?1:0,n[r++]=e.tangent?1:0,n[r++]=e.color?1:0},i.unpack=function(n,r,a){return r=t(r,0),e(a)||(a=new i),a.position=1===n[r++],a.normal=1===n[r++],a.st=1===n[r++],a.binormal=1===n[r++],a.tangent=1===n[r++],a.color=1===n[r++],a},i.clone=function(t,n){return e(t)?(e(n)||(n=new i),n.position=t.position,n.normal=t.normal,n.st=t.st,n.binormal=t.binormal,n.tangent=t.tangent,n.color=t.color,n):void 0},i}),define("Core/BoxGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType","./VertexFormat"],function(t,e,n,r,i,a,o,u,E,s,_,c){"use strict";var R=new e,T=function(t){t=r(t,r.EMPTY_OBJECT);var n=t.minimum,o=t.maximum;!i(n)&&i(t.minimumCorner)&&(n=t.minimumCorner,a("BoxGeometry","options.minimumCorner is deprecated. Use options.minimum instead.")),!i(o)&&i(t.maximumCorner)&&(o=t.maximumCorner,a("BoxGeometry","options.maximumCorner is deprecated. Use options.maximum instead."));var u=r(t.vertexFormat,c.DEFAULT);this._minimum=e.clone(n),this._maximum=e.clone(o),this._vertexFormat=u,this._workerName="createBoxGeometry"};T.fromDimensions=function(t){t=r(t,r.EMPTY_OBJECT);var n=t.dimensions,i=e.multiplyByScalar(n,.5,new e);return new T({minimum:e.negate(i,new e),maximum:i,vertexFormat:t.vertexFormat})},T.fromAxisAlignedBoundingBox=function(t){if(!i(t))throw new o("boundingBox is required.");return new T({minimum:t.minimum,maximum:t.maximum})},T.fromAxisAlignedBoundingBox=function(t){if(!i(t))throw new o("boundingBox is required.");return new T({minimum:t.minimum,maximum:t.maximum})},T.packedLength=2*e.packedLength+c.packedLength,T.pack=function(t,n,i){i=r(i,0),e.pack(t._minimum,n,i),e.pack(t._maximum,n,i+e.packedLength),c.pack(t._vertexFormat,n,i+2*e.packedLength)};var l=new e,A=new e,N=new c,f={minimum:l,maximum:A,vertexFormat:N};return T.unpack=function(t,n,a){n=r(n,0);var o=e.unpack(t,n,l),u=e.unpack(t,n+e.packedLength,A),E=c.unpack(t,n+2*e.packedLength,N);return i(a)?(a._minimum=e.clone(o,a._minimum),a._maximum=e.clone(u,a._maximum),a._vertexFormat=c.clone(E,a._vertexFormat),a):new T(f)},T.createGeometry=function(r){var i,a,o=r._minimum,c=r._maximum,T=r._vertexFormat,l=new s;if(T.position&&(T.st||T.normal||T.binormal||T.tangent)){if(T.position&&(a=new Float64Array(72),a[0]=o.x,a[1]=o.y,a[2]=c.z,a[3]=c.x,a[4]=o.y,a[5]=c.z,a[6]=c.x,a[7]=c.y,a[8]=c.z,a[9]=o.x,a[10]=c.y,a[11]=c.z,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=c.x,a[16]=o.y,a[17]=o.z,a[18]=c.x,a[19]=c.y,a[20]=o.z,a[21]=o.x,a[22]=c.y,a[23]=o.z,a[24]=c.x,a[25]=o.y,a[26]=o.z,a[27]=c.x,a[28]=c.y,a[29]=o.z,a[30]=c.x,a[31]=c.y,a[32]=c.z,a[33]=c.x,a[34]=o.y,a[35]=c.z,a[36]=o.x,a[37]=o.y,a[38]=o.z,a[39]=o.x,a[40]=c.y,a[41]=o.z,a[42]=o.x,a[43]=c.y,a[44]=c.z,a[45]=o.x,a[46]=o.y,a[47]=c.z,a[48]=o.x,a[49]=c.y,a[50]=o.z,a[51]=c.x,a[52]=c.y,a[53]=o.z,a[54]=c.x,a[55]=c.y,a[56]=c.z,a[57]=o.x,a[58]=c.y,a[59]=c.z,a[60]=o.x,a[61]=o.y,a[62]=o.z,a[63]=c.x,a[64]=o.y,a[65]=o.z,a[66]=c.x,a[67]=o.y,a[68]=c.z,a[69]=o.x,a[70]=o.y,a[71]=c.z,l.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:a})),T.normal){var A=new Float32Array(72);A[0]=0,A[1]=0,A[2]=1,A[3]=0,A[4]=0,A[5]=1,A[6]=0,A[7]=0,A[8]=1,A[9]=0,A[10]=0,A[11]=1,A[12]=0,A[13]=0,A[14]=-1,A[15]=0,A[16]=0,A[17]=-1,A[18]=0,A[19]=0,A[20]=-1,A[21]=0,A[22]=0,A[23]=-1,A[24]=1,A[25]=0,A[26]=0,A[27]=1,A[28]=0,A[29]=0,A[30]=1,A[31]=0,A[32]=0,A[33]=1,A[34]=0,A[35]=0,A[36]=-1,A[37]=0,A[38]=0,A[39]=-1,A[40]=0,A[41]=0,A[42]=-1,A[43]=0,A[44]=0,A[45]=-1,A[46]=0,A[47]=0,A[48]=0,A[49]=1,A[50]=0,A[51]=0,A[52]=1,A[53]=0,A[54]=0,A[55]=1,A[56]=0,A[57]=0,A[58]=1,A[59]=0,A[60]=0,A[61]=-1,A[62]=0,A[63]=0,A[64]=-1,A[65]=0,A[66]=0,A[67]=-1,A[68]=0,A[69]=0,A[70]=-1,A[71]=0,l.normal=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:A})}if(T.st){var N=new Float32Array(48);N[0]=0,N[1]=0,N[2]=1,N[3]=0,N[4]=1,N[5]=1,N[6]=0,N[7]=1,N[8]=1,N[9]=0,N[10]=0,N[11]=0,N[12]=0,N[13]=1,N[14]=1,N[15]=1,N[16]=0,N[17]=0,N[18]=1,N[19]=0,N[20]=1,N[21]=1,N[22]=0,N[23]=1,N[24]=1,N[25]=0,N[26]=0,N[27]=0,N[28]=0,N[29]=1,N[30]=1,N[31]=1,N[32]=1,N[33]=0,N[34]=0,N[35]=0,N[36]=0,N[37]=1,N[38]=1,N[39]=1,N[40]=0,N[41]=0,N[42]=1,N[43]=0,N[44]=1,N[45]=1,N[46]=0,N[47]=1,l.st=new E({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:N})}if(T.tangent){var f=new Float32Array(72);f[0]=1,f[1]=0,f[2]=0,f[3]=1,f[4]=0,f[5]=0,f[6]=1,f[7]=0,f[8]=0,f[9]=1,f[10]=0,f[11]=0,f[12]=-1,f[13]=0,f[14]=0,f[15]=-1,f[16]=0,f[17]=0,f[18]=-1,f[19]=0,f[20]=0,f[21]=-1,f[22]=0,f[23]=0,f[24]=0,f[25]=1,f[26]=0,f[27]=0,f[28]=1,f[29]=0,f[30]=0,f[31]=1,f[32]=0,f[33]=0,f[34]=1,f[35]=0,f[36]=0,f[37]=-1,f[38]=0,f[39]=0,f[40]=-1,f[41]=0,f[42]=0,f[43]=-1,f[44]=0,f[45]=0,f[46]=-1,f[47]=0,f[48]=-1,f[49]=0,f[50]=0,f[51]=-1,f[52]=0,f[53]=0,f[54]=-1,f[55]=0,f[56]=0,f[57]=-1,f[58]=0,f[59]=0,f[60]=1,f[61]=0,f[62]=0,f[63]=1,f[64]=0,f[65]=0,f[66]=1,f[67]=0,f[68]=0,f[69]=1,f[70]=0,f[71]=0,l.tangent=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:f})}if(T.binormal){var h=new Float32Array(72);h[0]=0,h[1]=1,h[2]=0,h[3]=0,h[4]=1,h[5]=0,h[6]=0,h[7]=1,h[8]=0,h[9]=0,h[10]=1,h[11]=0,h[12]=0,h[13]=1,h[14]=0,h[15]=0,h[16]=1,h[17]=0,h[18]=0,h[19]=1,h[20]=0,h[21]=0,h[22]=1,h[23]=0,h[24]=0,h[25]=0,h[26]=1,h[27]=0,h[28]=0,h[29]=1,h[30]=0,h[31]=0,h[32]=1,h[33]=0,h[34]=0,h[35]=1,h[36]=0,h[37]=0,h[38]=1,h[39]=0,h[40]=0,h[41]=1,h[42]=0,h[43]=0,h[44]=1,h[45]=0,h[46]=0,h[47]=1,h[48]=0,h[49]=0,h[50]=1,h[51]=0,h[52]=0,h[53]=1,h[54]=0,h[55]=0,h[56]=1,h[57]=0,h[58]=0,h[59]=1,h[60]=0,h[61]=0,h[62]=1,h[63]=0,h[64]=0,h[65]=1,h[66]=0,h[67]=0,h[68]=1,h[69]=0,h[70]=0,h[71]=1,l.binormal=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:h})}i=new Uint16Array(36),i[0]=0,i[1]=1,i[2]=2,i[3]=0,i[4]=2,i[5]=3,i[6]=6,i[7]=5,i[8]=4,i[9]=7,i[10]=6,i[11]=4,i[12]=8,i[13]=9,i[14]=10,i[15]=8,i[16]=10,i[17]=11,i[18]=14,i[19]=13,i[20]=12,i[21]=15,i[22]=14,i[23]=12,i[24]=18,i[25]=17,i[26]=16,i[27]=19,i[28]=18,i[29]=16,i[30]=20,i[31]=21,i[32]=22,i[33]=20,i[34]=22,i[35]=23}else a=new Float64Array(24),a[0]=o.x,a[1]=o.y,a[2]=o.z,a[3]=c.x,a[4]=o.y,a[5]=o.z,a[6]=c.x,a[7]=c.y,a[8]=o.z,a[9]=o.x,a[10]=c.y,a[11]=o.z,a[12]=o.x,a[13]=o.y,a[14]=c.z,a[15]=c.x,a[16]=o.y,a[17]=c.z,a[18]=c.x,a[19]=c.y,a[20]=c.z,a[21]=o.x,a[22]=c.y,a[23]=c.z,l.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:a}),i=new Uint16Array(36),i[0]=4,i[1]=5,i[2]=6,i[3]=4,i[4]=6,i[5]=7,i[6]=1,i[7]=0,i[8]=3,i[9]=1,i[10]=3,i[11]=2,i[12]=1,i[13]=6,i[14]=5,i[15]=1,i[16]=2,i[17]=6,i[18]=2,i[19]=3,i[20]=7,i[21]=2,i[22]=7,i[23]=6,i[24]=3,i[25]=0,i[26]=4,i[27]=3,i[28]=4,i[29]=7,i[30]=0,i[31]=1,i[32]=5,i[33]=0,i[34]=5,i[35]=4;var I=e.subtract(c,o,R),m=.5*e.magnitude(I);return new u({attributes:l,indices:i,primitiveType:_.TRIANGLES,boundingSphere:new t(e.ZERO,m)})},T}),define("Workers/createBoxGeometry",["../Core/BoxGeometry","../Core/defined"],function(t,e){"use strict";return function(n,r){return e(r)&&(n=t.unpack(n,r)),t.createGeometry(n)}})}();