/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},a.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},a.lerp=function(e,t,n){return(1-n)*e+n*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,n,r,a){a=t(a,r);var i=Math.abs(e-n);return a>=i||i<=r*Math.max(Math.abs(e),Math.abs(n))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var n=i[t-1],r=t;e>=r;r++)i.push(n*r);return i[e]},a.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)};i.fromSpherical=function(n,r){t(r)||(r=new i);var a=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(o),r},i.fromElements=function(e,n,r,a){return t(a)?(a.x=e,a.y=n,a.z=r,a):new i(e,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var n=i.dot(s,c),r=i.magnitude(i.cross(s,c,s));return Math.atan2(r,n)};var l=new i;i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):n.y<=n.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)},i.cross=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-r*s,d=r*u-a*o;return n.x=c,n.y=l,n.z=d,n},i.fromDegrees=function(e,t,n,r,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,n,r,o)};var d=new i,f=new i,h=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(n,r,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:h,c=Math.cos(r);d.x=c*Math.cos(n),d.y=c*Math.sin(n),d.z=Math.sin(r),d=i.normalize(d,d),i.multiplyComponents(s,d,f);var l=Math.sqrt(i.dot(d,f));return f=i.divideByScalar(f,l,f),d=i.multiplyByScalar(d,a,d),t(u)||(u=new i),i.add(f,d,u)},i.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=a.toRadians(e[o]);return i.fromRadiansArray(r,t,n)},i.fromRadiansArray=function(e,n,r){var a=e.length;t(r)?r.length=a/2:r=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=i.fromRadians(u,s,0,n,r[o/2])}return r},i.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=a.toRadians(e[o]),r[o+1]=a.toRadians(e[o+1]),r[o+2]=e[o+2];return i.fromRadiansArrayHeights(r,t,n)},i.fromRadiansArrayHeights=function(e,n,r){var a=e.length;t(r)?r.length=a/3:r=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=i.fromRadians(u,s,c,n,r[o/3])}return r},i.ZERO=r(new i(0,0,0)),i.UNIT_X=r(new i(1,0,0)),i.UNIT_Y=r(new i(0,1,0)),i.UNIT_Z=r(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r){this.longitude=e(t,0),this.latitude=e(n,0),this.height=e(r,0)};return i.fromRadians=function(n,r,a,o){return a=e(a,0),t(o)?(o.longitude=n,o.latitude=r,o.height=a,o):new i(n,r,a)},i.fromDegrees=function(e,t,n,r){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.longitude=e.longitude,n.latitude=e.latitude,n.height=e.height,n):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.longitude===n.longitude&&e.latitude===n.latitude&&e.height===n.height},i.equalsEpsilon=function(e,n,r){return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=r&&Math.abs(e.latitude-n.latitude)<=r&&Math.abs(e.height-n.height)<=r},i.ZERO=r(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var n={},r=function(t,r){e(n[t])||(n[t]=!0,console.log(r))};return r}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,n)};a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,n){if(!r(t))return void 0;var a=t._radii;return r(n)?(e.clone(a,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new c(a.x,a.y,a.z)},c.fromCartesian3=function(e,t){return r(t)||(t=new c),r(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,r,a){a=n(a,0),e.pack(t._radii,r,a)},c.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return c.fromCartesian3(i,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,n){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},c.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var l=new e,d=new e;c.prototype.cartographicToCartesian=function(t,n){var a=l,i=d;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),r(n)||(n=new e),e.add(i,a,n)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var f=new e,h=new e,m=new e;c.prototype.cartesianToCartographic=function(n,a){var i=this.scaleToGeodeticSurface(n,h);if(!r(i))return void 0;var o=this.geodeticSurfaceNormal(i,f),s=e.subtract(n,i,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),d=u.sign(e.dot(s,n))*e.magnitude(s);return r(a)?(a.longitude=c,a.latitude=l,a.height=d,a):new t(c,l,d)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var p=new e,y=new e;return c.prototype.scaleToGeodeticSurface=function(t,n){var a=t.x,i=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,d=s.z,f=a*a*c*c,h=i*i*l*l,m=o*o*d*d,v=f+h+m,g=Math.sqrt(1/v),w=e.multiplyByScalar(t,g,p);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(w,n):void 0;var x=this._oneOverRadiiSquared,S=x.x,E=x.y,M=x.z,O=y;O.x=w.x*S*2,O.y=w.y*E*2,O.z=w.z*M*2;var _,P,R,C,z,T,I,N,b,A,D,q=(1-g)*e.magnitude(t)/(.5*e.magnitude(O)),U=0;do{q-=U,R=1/(1+q*S),C=1/(1+q*E),z=1/(1+q*M),T=R*R,I=C*C,N=z*z,b=T*R,A=I*C,D=N*z,_=f*T+h*I+m*N-1,P=f*b*S+h*A*E+m*D*M;var L=-2*P;U=_/L}while(Math.abs(_)>u.EPSILON12);return r(n)?(n.x=a*R,n.y=i*C,n.z=o*z,n):new e(a*R,i*C,o*z)},c.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},c.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},c.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,a,i,o){"use strict";var u=function(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new e(i,o,u)},u.prototype.unproject=function(e,n){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,n){this.start=e(t,0),this.stop=e(n,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r,a){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(a,0)};i.fromElements=function(e,n,r,a,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=a,o):new i(e,n,r,a)},i.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r++],a.w=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,s);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):n.y<=n.z?n.y<=n.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)&&a.equalsEpsilon(e.w,n.w,r,i)},i.ZERO=r(new i(0,0,0,0)),i.UNIT_X=r(new i(1,0,0,0)),i.UNIT_Y=r(new i(0,1,0,0)),i.UNIT_Z=r(new i(0,0,1,0)),i.UNIT_W=r(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function u(e){for(var t=0,n=0;3>n;++n){var r=e[c.getElementIndex(h[n],f[n])];t+=2*r*r}return Math.sqrt(t)}function s(e,t){for(var n=i.EPSILON15,r=0,a=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(h[o],f[o])]);u>r&&(a=o,r=u)}var s=1,l=0,d=f[a],m=h[a];if(Math.abs(e[c.getElementIndex(m,d)])>n){var p,y=e[c.getElementIndex(m,m)],v=e[c.getElementIndex(d,d)],g=e[c.getElementIndex(m,d)],w=(y-v)/2/g;p=0>w?-1/(-w+Math.sqrt(1+w*w)):1/(w+Math.sqrt(1+w*w)),s=1/Math.sqrt(1+p*p),l=p*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(d,d)]=t[c.getElementIndex(m,m)]=s,t[c.getElementIndex(m,d)]=l,t[c.getElementIndex(d,m)]=-l,t}var c=function(e,n,r,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},c.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new c),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,r,a){return r=t(r,0),n(a)||(a=new c),a[0]=e[r],a[1]=e[r+1],a[2]=e[r+2],a[3]=e[r+3],a[4]=e[r+4],a[5]=e[r+5],a[6]=e[r+6],a[7]=e[r+7],a[8]=e[r+8],a},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,d=e.z*e.z,f=e.z*e.w,h=e.w*e.w,m=r-u-d+h,p=2*(a-f),y=2*(i+l),v=2*(a+f),g=-r+u-d+h,w=2*(s-o),x=2*(i-l),S=2*(s+o),E=-r-u+d+h;return n(t)?(t[0]=m,t[1]=v,t[2]=x,t[3]=p,t[4]=g,t[5]=S,t[6]=y,t[7]=w,t[8]=E,t):new c(m,p,y,v,g,w,x,S,E)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new c(1,0,0,0,r,-a,0,a,r)},c.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new c(r,0,a,0,1,0,-a,0,r)},c.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(r,-a,0,a,r,0,0,0,1)},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[r+1],o=e[r+2];return n.x=a,n.y=i,n.z=o,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=3*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},c.getRow=function(e,t,n){var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var d=new e;c.getMaximumScale=function(t){return c.getScale(t,d),e.maximumComponent(d)},c.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=d,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[3]*a+e[6]*i,u=e[1]*r+e[4]*a+e[7]*i,s=e[2]*r+e[5]*a+e[8]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},c.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var f=[1,0,0],h=[2,2,1],m=new c,p=new c;return c.computeEigenDecomposition=function(e,t){var r=i.EPSILON20,a=10,l=0,d=0;n(t)||(t={});for(var f=t.unitary=c.clone(c.IDENTITY,t.unitary),h=t.diagonal=c.clone(e,t.diagonal),y=r*o(h);a>d&&u(h)>y;)s(h,m),c.transpose(m,p),c.multiply(h,m,h),c.multiply(p,h,h),c.multiply(f,m,f),++l>2&&(++d,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},c.inverse=function(e,t){var n=e[0],a=e[1],o=e[2],u=e[3],s=e[4],l=e[5],d=e[6],f=e[7],h=e[8],m=c.determinant(e);if(Math.abs(m)<=i.EPSILON15)throw new r("matrix is not invertible");t[0]=s*h-f*l,t[1]=f*o-a*h,t[2]=a*l-s*o,t[3]=d*l-u*h,t[4]=n*h-d*o,t[5]=u*o-n*l,t[6]=u*f-d*s,t[7]=d*a-n*f,t[8]=n*s-u*a;var p=1/m;return c.multiplyByScalar(t,p,t)},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},c.IDENTITY=a(new c(1,0,0,0,1,0,0,0,1)),c.ZERO=a(new c(0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,a,i,o,u,s){"use strict";var c=function(e,t,r,a,i,o,u,s,c,l,d,f,h,m,p,y){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(m,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(d,0),this[11]=n(p,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(f,0),this[15]=n(y,0)};c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=n(a,e.ZERO),r(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,a){r(a)||(a=new c);var i=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,d=t.x*t.z,f=t.x*t.w,h=t.y*t.y,m=t.y*t.z,p=t.y*t.w,y=t.z*t.z,v=t.z*t.w,g=t.w*t.w,w=s-h-y+g,x=2*(l-v),S=2*(d+p),E=2*(l+v),M=-s+h-y+g,O=2*(m-f),_=2*(d-p),P=2*(m+f),R=-s-h+y+g;return a[0]=w*i,a[1]=E*i,a[2]=_*i,a[3]=0,a[4]=x*o,a[5]=M*o,a[6]=P*o,a[7]=0,a[8]=S*u,a[9]=O*u,a[10]=R*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,d=new e,f=new e;c.fromCamera=function(t,n){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,d),d),e.normalize(e.cross(d,l,f),f);var u=d.x,s=d.y,h=d.z,m=l.x,p=l.y,y=l.z,v=f.x,g=f.y,w=f.z,x=a.x,S=a.y,E=a.z,M=u*-x+s*-S+h*-E,O=v*-x+g*-S+w*-E,_=m*x+p*S+y*E;return r(n)?(n[0]=u,n[1]=v,n[2]=-m,n[3]=0,n[4]=s,n[5]=g,n[6]=-p,n[7]=0,n[8]=h,n[9]=w,n[10]=-y,n[11]=0,n[12]=M,n[13]=O,n[14]=_,n[15]=1,n):new c(u,s,h,M,v,g,w,O,-m,-p,-y,_,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,n,r,a,i,o){var u=1/(t-e),s=1/(r-n),c=1/(i-a),l=-(t+e)*u,d=-(r+n)*s,f=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=d,o[14]=f,o[15]=1,
o},c.computePerspectiveOffCenter=function(e,t,n,r,a,i,o){var u=2*a/(t-e),s=2*a/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),d=-(i+a)/(i-a),f=-1,h=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=d,o[11]=f,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var o=2*a/(t-e),u=2*a/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,d=-1,f=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=d,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},c.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,d=.5*(r-t),f=c,h=l,m=d,p=i+c,y=o+l,v=t+d,g=1;return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=m,a[11]=0,a[12]=p,a[13]=y,a[14]=v,a[15]=g,a},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[r+1],o=e[r+2],u=e[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=4*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},c.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},c.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var h=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),n};var m=new e;c.getMaximumScale=function(t){return c.getScale(t,m),e.maximumComponent(m)},c.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],d=e[8],f=e[9],h=e[10],m=e[11],p=e[12],y=e[13],v=e[14],g=e[15],w=t[0],x=t[1],S=t[2],E=t[3],M=t[4],O=t[5],_=t[6],P=t[7],R=t[8],C=t[9],z=t[10],T=t[11],I=t[12],N=t[13],b=t[14],A=t[15],D=r*w+u*x+d*S+p*E,q=a*w+s*x+f*S+y*E,U=i*w+c*x+h*S+v*E,L=o*w+l*x+m*S+g*E,W=r*M+u*O+d*_+p*P,B=a*M+s*O+f*_+y*P,F=i*M+c*O+h*_+v*P,k=o*M+l*O+m*_+g*P,V=r*R+u*C+d*z+p*T,j=a*R+s*C+f*z+y*T,Z=i*R+c*C+h*z+v*T,H=o*R+l*C+m*z+g*T,Y=r*I+u*N+d*b+p*A,X=a*I+s*N+f*b+y*A,G=i*I+c*N+h*b+v*A,J=o*I+l*N+m*b+g*A;return n[0]=D,n[1]=q,n[2]=U,n[3]=L,n[4]=W,n[5]=B,n[6]=F,n[7]=k,n[8]=V,n[9]=j,n[10]=Z,n[11]=H,n[12]=Y,n[13]=X,n[14]=G,n[15]=J,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],d=e[10],f=e[12],h=e[13],m=e[14],p=t[0],y=t[1],v=t[2],g=t[4],w=t[5],x=t[6],S=t[8],E=t[9],M=t[10],O=t[12],_=t[13],P=t[14],R=r*p+o*y+c*v,C=a*p+u*y+l*v,z=i*p+s*y+d*v,T=r*g+o*w+c*x,I=a*g+u*w+l*x,N=i*g+s*w+d*x,b=r*S+o*E+c*M,A=a*S+u*E+l*M,D=i*S+s*E+d*M,q=r*O+o*_+c*P+f,U=a*O+u*_+l*P+h,L=i*O+s*_+d*P+m;return n[0]=R,n[1]=C,n[2]=z,n[3]=0,n[4]=T,n[5]=I,n[6]=N,n[7]=0,n[8]=b,n[9]=A,n[10]=D,n[11]=0,n[12]=q,n[13]=U,n[14]=L,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],d=e[10],f=t[0],h=t[1],m=t[2],p=t[3],y=t[4],v=t[5],g=t[6],w=t[7],x=t[8],S=r*f+o*h+c*m,E=a*f+u*h+l*m,M=i*f+s*h+d*m,O=r*p+o*y+c*v,_=a*p+u*y+l*v,P=i*p+s*y+d*v,R=r*g+o*w+c*x,C=a*g+u*w+l*x,z=i*g+s*w+d*x;return n[0]=S,n[1]=E,n[2]=M,n[3]=0,n[4]=O,n[5]=_,n[6]=P,n[7]=0,n[8]=R,n[9]=C,n[10]=z,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=r*e[0]+a*e[4]+i*e[8]+e[12],u=r*e[1]+a*e[5]+i*e[9]+e[13],s=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var p=new e;c.multiplyByUniformScale=function(e,t,n){return p.x=t,p.y=t,p.z=t,c.multiplyByScale(e,p,n)},c.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*r+e[4]*a+e[8]*i+e[12]*o,s=e[1]*r+e[5]*a+e[9]*i+e[13]*o,c=e[2]*r+e[6]*a+e[10]*i+e[14]*o,l=e[3]*r+e[7]*a+e[11]*i+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i,u=e[1]*r+e[5]*a+e[9]*i,s=e[2]*r+e[6]*a+e[10]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i+e[12],u=e[1]*r+e[5]*a+e[9]*i+e[13],s=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var y=new u,v=new u,g=new t,w=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,y),v,o.EPSILON7)&&t.equals(c.getRow(e,3,g),w))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],a=e[4],i=e[8],l=e[12],d=e[1],f=e[5],h=e[9],m=e[13],p=e[2],x=e[6],S=e[10],E=e[14],M=e[3],O=e[7],_=e[11],P=e[15],R=S*P,C=E*_,z=x*P,T=E*O,I=x*_,N=S*O,b=p*P,A=E*M,D=p*_,q=S*M,U=p*O,L=x*M,W=R*f+T*h+I*m-(C*f+z*h+N*m),B=C*d+b*h+q*m-(R*d+A*h+D*m),F=z*d+A*f+U*m-(T*d+b*f+L*m),k=N*d+D*f+L*h-(I*d+q*f+U*h),V=C*a+z*i+N*l-(R*a+T*i+I*l),j=R*r+A*i+D*l-(C*r+b*i+q*l),Z=T*r+b*a+L*l-(z*r+A*a+U*l),H=I*r+q*a+U*i-(N*r+D*a+L*i);R=i*m,C=l*h,z=a*m,T=l*f,I=a*h,N=i*f,b=r*m,A=l*d,D=r*h,q=i*d,U=r*f,L=a*d;var Y=R*O+T*_+I*P-(C*O+z*_+N*P),X=C*M+b*_+q*P-(R*M+A*_+D*P),G=z*M+A*O+U*P-(T*M+b*O+L*P),J=N*M+D*O+L*_-(I*M+q*O+U*_),Q=z*S+N*E+C*x-(I*E+R*x+T*S),$=D*E+R*p+A*S-(b*S+q*E+C*p),K=b*x+L*E+T*p-(U*E+z*p+A*x),ee=U*S+I*p+q*x-(D*x+L*S+N*p),te=r*W+a*B+i*F+l*k;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=W*te,n[1]=B*te,n[2]=F*te,n[3]=k*te,n[4]=V*te,n[5]=j*te,n[6]=Z*te,n[7]=H*te,n[8]=Y*te,n[9]=X*te,n[10]=G*te,n[11]=J*te,n[12]=Q*te,n[13]=$*te,n[14]=K*te,n[15]=ee*te,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],d=e[12],f=e[13],h=e[14],m=-n*d-r*f-a*h,p=-i*d-o*f-u*h,y=-s*d-c*f-l*h;return t[0]=n,t[1]=i,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=m,t[13]=p,t[14]=y,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";var a=function(t,n){this.normal=e.clone(t),this.distance=n};a.fromPointNormal=function(n,r,i){var o=-e.dot(r,n);return t(i)?(e.clone(r,i.normal),i.distance=o,i):new a(r,o)};var i=new e;return a.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,i),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new a(o,u)},a.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},a.ORIGIN_XY_PLANE=r(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=r(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=r(new a(e.UNIT_Y,0)),a}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,n,r,a){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(a,0)};r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.west=e[r++],a.south=e[r++],a.east=e[r++],a.north=e[r],a},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,a,i,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),n(o)?(o.west=e,o.south=r,o.east=a,o.north=i,o):new s(e,r,a,i)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];r=Math.min(r,l.longitude),a=Math.max(a,l.longitude),i=Math.min(i,l.latitude),o=Math.max(o,l.latitude)}return n(t)?(t.west=r,t.south=i,t.east=a,t.north=o,t):new s(r,i,a,o)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),d=u.negativePiToPi(Math.min(a,o));if((e.west<e.east||t.west<t.east)&&l>=d)return void 0;var f=Math.max(e.south,t.south),h=Math.min(e.north,t.north);return f>=h?void 0:n(r)?(r.west=l,r.south=f,r.east=d,r.north=h,r):new s(l,f,d,h)},s.contains=function(e,t){var n=t.longitude,r=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(i>n||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,a,o){r=t(r,i.WGS84),a=t(a,0),n(o)||(o=[]);var l=0,d=e.north,f=e.south,h=e.east,m=e.west,p=c;p.height=a,p.longitude=m,p.latitude=d,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.longitude=h,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.latitude=f,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.longitude=m,o[l]=r.cartographicToCartesian(p,o[l]),l++,0>d?p.latitude=d:f>0?p.latitude=f:p.latitude=0;for(var y=1;8>y;++y)p.longitude=-Math.PI+y*u.PI_OVER_TWO,s.contains(e,p)&&(o[l]=r.cartographicToCartesian(p,o[l]),l++);return 0===p.latitude&&(p.longitude=m,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.longitude=h,o[l]=r.cartographicToCartesian(p,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,d,f){"use strict";var h=function(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)},m=new e,p=new e,y=new e,v=new e,g=new e,w=new e,x=new e,S=new e,E=new e,M=new e,O=new e,_=new e;h.fromPoints=function(t,n){if(r(n)||(n=new h),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var a=e.clone(t[0],x),i=e.clone(a,m),o=e.clone(a,p),u=e.clone(a,y),s=e.clone(a,v),c=e.clone(a,g),l=e.clone(a,w),d=t.length,f=1;d>f;f++){e.clone(t[f],a);var P=a.x,R=a.y,C=a.z;P<i.x&&e.clone(a,i),P>s.x&&e.clone(a,s),R<o.y&&e.clone(a,o),R>c.y&&e.clone(a,c),C<u.z&&e.clone(a,u),C>l.z&&e.clone(a,l)}var z=e.magnitudeSquared(e.subtract(s,i,S)),T=e.magnitudeSquared(e.subtract(c,o,S)),I=e.magnitudeSquared(e.subtract(l,u,S)),N=i,b=s,A=z;T>A&&(A=T,N=o,b=c),I>A&&(A=I,N=u,b=l);var D=E;D.x=.5*(N.x+b.x),D.y=.5*(N.y+b.y),D.z=.5*(N.z+b.z);var q=e.magnitudeSquared(e.subtract(b,D,S)),U=Math.sqrt(q),L=M;L.x=i.x,L.y=o.y,L.z=u.z;var W=O;W.x=s.x,W.y=c.y,W.z=l.z;var B=e.multiplyByScalar(e.add(L,W,S),.5,_),F=0;for(f=0;d>f;f++){e.clone(t[f],a);var k=e.magnitude(e.subtract(a,B,S));k>F&&(F=k);var V=e.magnitudeSquared(e.subtract(a,D,S));if(V>q){var j=Math.sqrt(V);U=.5*(U+j),q=U*U;var Z=j-U;D.x=(U*D.x+Z*a.x)/j,D.y=(U*D.y+Z*a.y)/j,D.z=(U*D.z+Z*a.z)/j}}return F>U?(e.clone(D,n.center),n.radius=U):(e.clone(B,n.center),n.radius=F),n};var P=new u,R=new e,C=new e,z=new t,T=new t;h.fromRectangle2D=function(e,t,n){return h.fromRectangleWithHeights2D(e,t,0,0,n)},h.fromRectangleWithHeights2D=function(t,a,i,o,u){if(r(u)||(u=new h),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,P),f.southwest(t,z),z.height=i,f.northeast(t,T),T.height=o;var s=a.project(z,R),c=a.project(T,C),l=c.x-s.x,d=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(l*l+d*d+m*m);var p=u.center;return p.x=s.x+.5*l,p.y=s.y+.5*d,p.z=s.z+.5*m,u};var I=[];h.fromRectangle3D=function(e,t,a,i){t=n(t,o.WGS84),a=n(a,0);var u;return r(e)&&(u=f.subsample(e,t,a,I)),h.fromPoints(u,i)},h.fromVertices=function(t,a,i,o){if(r(o)||(o=new h),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=n(a,e.ZERO),i=n(i,3);var u=x;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,m),c=e.clone(u,p),l=e.clone(u,y),d=e.clone(u,v),f=e.clone(u,g),P=e.clone(u,w),R=t.length,C=0;R>C;C+=i){var z=t[C]+a.x,T=t[C+1]+a.y,I=t[C+2]+a.z;u.x=z,u.y=T,u.z=I,z<s.x&&e.clone(u,s),z>d.x&&e.clone(u,d),T<c.y&&e.clone(u,c),T>f.y&&e.clone(u,f),I<l.z&&e.clone(u,l),I>P.z&&e.clone(u,P)}var N=e.magnitudeSquared(e.subtract(d,s,S)),b=e.magnitudeSquared(e.subtract(f,c,S)),A=e.magnitudeSquared(e.subtract(P,l,S)),D=s,q=d,U=N;b>U&&(U=b,D=c,q=f),A>U&&(U=A,D=l,q=P);var L=E;L.x=.5*(D.x+q.x),L.y=.5*(D.y+q.y),L.z=.5*(D.z+q.z);var W=e.magnitudeSquared(e.subtract(q,L,S)),B=Math.sqrt(W),F=M;F.x=s.x,F.y=c.y,F.z=l.z;var k=O;k.x=d.x,k.y=f.y,k.z=P.z;var V=e.multiplyByScalar(e.add(F,k,S),.5,_),j=0;for(C=0;R>C;C+=i){u.x=t[C]+a.x,u.y=t[C+1]+a.y,u.z=t[C+2]+a.z;var Z=e.magnitude(e.subtract(u,V,S));Z>j&&(j=Z);var H=e.magnitudeSquared(e.subtract(u,L,S));if(H>W){var Y=Math.sqrt(H);B=.5*(B+Y),W=B*B;var X=Y-B;L.x=(B*L.x+X*u.x)/Y,L.y=(B*L.y+X*u.y)/Y,L.z=(B*L.z+X*u.z)/Y}}return j>B?(e.clone(L,o.center),o.radius=B):(e.clone(V,o.center),o.radius=j),o},h.fromCornerPoints=function(t,n,a){r(a)||(a=new h);var i=a.center;return e.add(t,n,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,n),a},h.fromEllipsoid=function(t,n){return r(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var N=new e;h.fromBoundingSpheres=function(t,n){if(r(n)||(n=new h),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=t.length;if(1===a)return h.clone(t[0],n);if(2===a)return h.union(t[0],t[1],n);for(var i=[],o=0;a>o;o++)i.push(t[o].center);n=h.fromPoints(i,n);var u=n.center,s=n.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,N)+c.radius)}return n.radius=s,n},h.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,r){r=n(r,0);var a=e.center;t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius},h.unpack=function(e,t,a){t=n(t,0),r(a)||(a=new h);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var b=new e,A=new e;h.union=function(t,n,a){r(a)||(a=new h);var i=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,i,b),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return n.clone(a),a;var d=.5*(o+l+s),f=e.multiplyByScalar(c,(-o+d)/l,A);return e.add(f,i,f),e.clone(f,a.center),a.radius=d,a};var D=new e;h.expand=function(t,n,r){r=h.clone(t,r);var a=e.magnitude(e.subtract(n,r.center,D));return a>r.radius&&(r.radius=a),r},h.intersectPlane=function(t,n){var r=t.center,a=t.radius,i=n.normal,o=e.dot(i,r)+n.distance;return-a>o?s.OUTSIDE:a>o?s.INTERSECTING:s.INSIDE},h.transform=function(e,t,n){return r(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var q=new e;h.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,q);return e.magnitudeSquared(r)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var U=new e;h.computePlaneDistances=function(t,n,a,i){r(i)||(i=new c);var o=e.subtract(t.center,n,U),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var L=new e,W=new e,B=new e,F=new e,k=new e,V=new t,j=new Array(8),Z=0;8>Z;++Z)j[Z]=new e;var H=new u;return h.projectTo2D=function(t,r,a){r=n(r,H);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,L),c=e.cross(e.UNIT_Z,s,W);e.normalize(c,c);var l=e.cross(s,c,B);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var d=e.negate(l,k),f=e.negate(c,F),m=j,p=m[0];e.add(s,l,p),e.add(p,c,p),p=m[1],e.add(s,l,p),e.add(p,f,p),p=m[2],e.add(s,d,p),e.add(p,f,p),p=m[3],e.add(s,d,p),e.add(p,c,p),e.negate(s,s),p=m[4],e.add(s,l,p),e.add(p,c,p),p=m[5],e.add(s,l,p),e.add(p,f,p),p=m[6],e.add(s,d,p),e.add(p,f,p),p=m[7],e.add(s,d,p),e.add(p,c,p);for(var y=m.length,v=0;y>v;++v){var g=m[v];e.add(o,g,g);var w=i.cartesianToCartographic(g,V);r.project(w,g)}a=h.fromPoints(m,a),o=a.center;var x=o.x,S=o.y,E=o.z;return o.x=E,o.y=x,o.z=S,a},h.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},h.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,n){return h.computePlaneDistances(this,e,t,n)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,t,n,r,a,i,o){"use strict";function u(e,n,r){var a=e.transformPositionToScaledSpace(n,m),i=t.magnitudeSquared(a),o=Math.sqrt(i),u=t.divideByScalar(a,o,p);i=Math.max(1,i),o=Math.max(1,o);var s=t.dot(u,r),c=t.magnitude(t.cross(u,r,u)),l=1/o,d=Math.sqrt(i-1)*l;return 1/(s*l-c*d)}function s(e,n,r){return 0>=n||n===1/0||n!==n?void 0:t.multiplyByScalar(e,n,r)}function c(e,n){return e.transformPositionToScaledSpace(n,y),t.normalize(y,y)}var l=function(e,n){this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,r(n)&&(this.cameraPosition=n)};a(l.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var n=this._ellipsoid,r=n.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),a=t.magnitudeSquared(r)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=r,this._distanceToLimbInScaledSpaceSquared=a}}});var d=new t;l.prototype.isPointVisible=function(e){var t=this._ellipsoid,n=t.transformPositionToScaledSpace(e,d);return this.isScaledSpacePointVisible(n)},l.prototype.isScaledSpacePointVisible=function(e){if(this._distanceToLimbInScaledSpaceSquared<0)return!0;var n=this._cameraPositionInScaledSpace,r=this._distanceToLimbInScaledSpaceSquared,a=t.subtract(e,n,d),i=-t.dot(a,n),o=i>r&&i*i/t.magnitudeSquared(a)>r;return!o},l.prototype.computeHorizonCullingPoint=function(e,n,a){r(a)||(a=new t);for(var i=this._ellipsoid,o=c(i,e),l=0,d=0,f=n.length;f>d;++d){var h=n[d],m=u(i,h,o);l=Math.max(l,m)}return s(o,l,a)};var f=new t;l.prototype.computeHorizonCullingPointFromVertices=function(e,a,i,o,l){r(l)||(l=new t),o=n(o,t.ZERO);for(var d=this._ellipsoid,h=c(d,e),m=0,p=0,y=a.length;y>p;p+=i){f.x=a[p]+o.x,f.y=a[p+1]+o.y,f.z=a[p+2]+o.z;var v=u(d,f,h);m=Math.max(m,v)}return s(h,m,l)};var h=[];l.prototype.computeHorizonCullingPointFromRectangle=function(n,r,a){var i=o.subsample(n,r,0,h),u=e.fromPoints(i);return t.magnitude(u.center)<.1*r.minimumRadius?void 0:this.computeHorizonCullingPoint(u.center,i,a)};var m=new t,p=new t,y=new t;return l}),define("Core/HeightmapTessellator",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math","./Rectangle"],function(e,t,n,r,a,i,o,u){"use strict";var s={};return s.DEFAULT_STRUCTURE=i({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1}),s.computeVertices=function(r){var i,c,l,d,f=Math.cos,h=Math.sin,m=Math.sqrt,p=Math.atan,y=Math.exp,v=o.PI_OVER_TWO,g=o.toRadians,w=r.vertices,x=r.heightmap,S=r.width,E=r.height,M=r.skirtHeight,O=t(r.isGeographic,!0),_=t(r.ellipsoid,a.WGS84),P=1/_.maximumRadius,R=r.nativeRectangle,C=r.rectangle;n(C)?(i=C.west,c=C.south,l=C.east,d=C.north):O?(i=g(R.west),c=g(R.south),l=g(R.east),d=g(R.north)):(i=R.west*P,c=v-2*p(y(-R.south*P)),l=R.east*P,d=v-2*p(y(-R.north*P)));var z=t(r.relativeToCenter,e.ZERO),T=t(r.structure,s.DEFAULT_STRUCTURE),I=t(T.heightScale,s.DEFAULT_STRUCTURE.heightScale),N=t(T.heightOffset,s.DEFAULT_STRUCTURE.heightOffset),b=t(T.elementsPerHeight,s.DEFAULT_STRUCTURE.elementsPerHeight),A=t(T.stride,s.DEFAULT_STRUCTURE.stride),D=t(T.elementMultiplier,s.DEFAULT_STRUCTURE.elementMultiplier),q=t(T.isBigEndian,s.DEFAULT_STRUCTURE.isBigEndian),U=u.computeWidth(R)/(S-1),L=u.computeHeight(R)/(E-1),W=_.radiiSquared,B=W.x,F=W.y,k=W.z,V=0,j=65536,Z=-65536,H=0,Y=E,X=0,G=S;M>0&&(--H,++Y,--X,++G);for(var J=H;Y>J;++J){var Q=J;0>Q&&(Q=0),Q>=E&&(Q=E-1);var $=R.north-L*Q;$=O?g($):v-2*p(y(-$*P));for(var K=f($),ee=h($),te=k*ee,ne=($-c)/(d-c),re=X;G>re;++re){var ae=re;0>ae&&(ae=0),ae>=S&&(ae=S-1);var ie=R.west+U*ae;O?ie=g(ie):ie*=P;var oe,ue=Q*S*A+ae*A;if(1===b)oe=x[ue];else{oe=0;var se;if(q)for(se=0;b>se;++se)oe=oe*D+x[ue+se];else for(se=b-1;se>=0;--se)oe=oe*D+x[ue+se]}oe=oe*I+N,Z=Math.max(Z,oe),j=Math.min(j,oe),(re!==ae||J!==Q)&&(oe-=M);var ce=K*f(ie),le=K*h(ie),de=B*ce,fe=F*le,he=m(de*ce+fe*le+te*ee),me=1/he,pe=de*me,ye=fe*me,ve=te*me;w[V++]=pe+ce*oe-z.x,w[V++]=ye+le*oe-z.y,w[V++]=ve+ee*oe-z.z,w[V++]=oe;var ge=(ie-i)/(l-i);w[V++]=ge,w[V++]=ne}}return{maximumHeight:Z,minimumHeight:j}},s}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n){this.x=e(t,0),this.y=e(n,0)};i.fromElements=function(e,n,r){return t(r)?(r.x=e,r.y=n,r):new i(e,n)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r]=t.y},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)},i.ZERO=r(new i(0,0)),i.UNIT_X=r(new i(1,0)),i.UNIT_Y=r(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,t,n,r,a,i,o){"use strict";var u=function(r,a,i){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i};u.fromPoints=function(t,r){if(n(r)||(r=new u),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,i=t[0].y,o=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,d=t.length,f=1;d>f;f++){var h=t[f],m=h.x,p=h.y,y=h.z;a=Math.min(m,a),s=Math.max(m,s),i=Math.min(p,i),c=Math.max(p,c),o=Math.min(y,o),l=Math.max(y,l)}var v=r.minimum;v.x=a,v.y=i,v.z=o;var g=r.maximum;g.x=s,g.y=c,g.z=l;var w=e.add(v,g,r.center);return e.multiplyByScalar(w,.5,w),r},u.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new u(t.minimum,t.maximum):void 0},u.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var s=new e;return u.intersectPlane=function(t,n){s=e.subtract(t.maximum,t.minimum,s);var r=e.multiplyByScalar(s,.5,s),a=n.normal,o=r.x*Math.abs(a.x)+r.y*Math.abs(a.y)+r.z*Math.abs(a.z),u=e.dot(t.center,a)+n.distance;return u-o>0?i.INSIDE:0>u+o?i.OUTSIDE:i.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var a=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(n)))<r?0:a}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,a){var i;if(0===e)return 0===r?[]:[-a/r];if(0===r){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-r/e,0>i?[i,0]:[0,i];var c=r*r,l=4*e*a,d=n(c,-l,t.EPSILON14);if(0>d)return[];var f=-.5*n(r,t.sign(r)*Math.sqrt(d),t.EPSILON14);return r>0?[f/e,a/f]:[a/f,f/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var a,i,o=e,u=t/3,s=n/3,c=r,l=o*s,d=u*c,f=u*u,h=s*s,m=o*s-f,p=o*c-u*s,y=u*c-h,v=4*m*y-p*p;if(0>v){var g,w,x;f*d>=l*h?(g=o,w=m,x=-2*u*m+o*p):(g=c,w=y,x=-c*p+2*s*y);var S=0>x?-1:1,E=-S*Math.abs(g)*Math.sqrt(-v);i=-x+E;var M=i/2,O=0>M?-Math.pow(-M,1/3):Math.pow(M,1/3),_=i===E?-O:-w/O;return a=0>=w?O+_:-x/(O*O+_*_+w),f*d>=l*h?[(a-u)/o]:[-c/(a+s)]}var P=m,R=-2*u*m+o*p,C=y,z=-c*p+2*s*y,T=Math.sqrt(v),I=Math.sqrt(3)/2,N=Math.abs(Math.atan2(o*T,-R)/3);a=2*Math.sqrt(-P);var b=Math.cos(N);i=a*b;
var A=a*(-b/2-I*Math.sin(N)),D=i+A>2*u?i-u:A-u,q=o,U=D/q;N=Math.abs(Math.atan2(c*T,-z)/3),a=2*Math.sqrt(-C),b=Math.cos(N),i=a*b,A=a*(-b/2-I*Math.sin(N));var L=-c,W=2*s>i+A?i+s:A+s,B=L/W,F=q*W,k=-D*W-q*L,V=D*L,j=(s*k-u*V)/(-u*k+s*F);return j>=U?B>=U?B>=j?[U,j,B]:[U,B,j]:[B,U,j]:B>=U?[j,U,B]:B>=j?[j,B,U]:[B,j,U]}var r={};return r.computeDiscriminant=function(e,t,n,r){var a=e*e,i=t*t,o=n*n,u=r*r,s=18*e*t*n*r+i*o-27*a*u-4*(e*o*n+i*t*r);return s},r.computeRealRoots=function(e,r,a,i){var o,u;if(0===e)return t.computeRealRoots(r,a,i);if(0===r){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,a,i)}return 0===a?0===i?(u=-r/e,0>u?[u,0,0]:[0,0,u]):n(e,r,0,i):0===i?(o=t.computeRealRoots(e,r,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,a,i)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,d=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(d.length>0){var f=-t/4,h=d[d.length-1];if(Math.abs(h)<n.EPSILON14){var m=r.computeRealRoots(1,s,l);if(2===m.length){var p,y=m[0],v=m[1];if(y>=0&&v>=0){var g=Math.sqrt(y),w=Math.sqrt(v);return[f-w,f-g,f+g,f+w]}if(y>=0&&0>v)return p=Math.sqrt(y),[f-p,f+p];if(0>y&&v>=0)return p=Math.sqrt(v),[f-p,f+p]}return[]}if(h>0){var x=Math.sqrt(h),S=(s+h-c/x)/2,E=(s+h+c/x)/2,M=r.computeRealRoots(1,x,S),O=r.computeRealRoots(1,-x,E);return 0!==M.length?(M[0]+=f,M[1]+=f,0!==O.length?(O[0]+=f,O[1]+=f,M[1]<=O[0]?[M[0],M[1],O[0],O[1]]:O[1]<=M[0]?[O[0],O[1],M[0],M[1]]:M[0]>=O[0]&&M[1]<=O[1]?[O[0],M[0],M[1],O[1]]:O[0]>=M[0]&&O[1]<=M[1]?[M[0],O[0],O[1],M[1]]:M[0]>O[0]&&M[0]<O[1]?[O[0],M[0],O[1],M[1]]:[M[0],O[0],M[1],O[1]]):M):0!==O.length?(O[0]+=f,O[1]+=f,O):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,d=i*t+s-4*o,f=c*o-i*a*t+u,h=e.computeRealRoots(1,l,d,f);if(h.length>0){var m,p,y=h[0],v=a-y,g=v*v,w=t/2,x=v/2,S=g-4*o,E=g+4*Math.abs(o),M=c-4*y,O=c+4*Math.abs(y);if(0>y||M*E>S*O){var _=Math.sqrt(M);m=_/2,p=0===_?0:(t*x-i)/_}else{var P=Math.sqrt(S);m=0===P?0:(t*x-i)/P,p=P/2}var R,C;0===w&&0===m?(R=0,C=0):n.sign(w)===n.sign(m)?(R=w+m,C=y/R):(C=w-m,R=y/C);var z,T;0===x&&0===p?(z=0,T=0):n.sign(x)===n.sign(p)?(z=x+p,T=o/z):(T=x-p,z=o/T);var I=r.computeRealRoots(1,R,z),N=r.computeRealRoots(1,C,T);if(0!==I.length)return 0!==N.length?I[1]<=N[0]?[I[0],I[1],N[0],N[1]]:N[1]<=I[0]?[N[0],N[1],I[0],I[1]]:I[0]>=N[0]&&I[1]<=N[1]?[N[0],I[0],I[1],N[1]]:N[0]>=I[0]&&N[1]<=I[1]?[I[0],N[0],N[1],I[1]]:I[0]>N[0]&&I[0]<N[1]?[N[0],I[0],N[1],I[1]]:[I[0],N[0],I[1],N[1]]:I;if(0!==N.length)return N}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=n*n,l=c*n,d=r*r,f=d*r,h=a*a,m=h*a,p=u*c*d-4*s*f-4*e*l*d+18*e*t*n*f-27*i*d*d+256*o*m+a*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*d+144*i*n*d)+h*(144*e*u*n-27*u*u-128*i*c-192*i*t*r);return p},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,d=u/t,f=s/t,h=0>c?1:0;switch(h+=0>l?h+1:h,h+=0>d?h+1:h,h+=0>f?h+1:h){case 0:return a(c,l,d,f);case 1:return i(c,l,d,f);case 2:return i(c,l,d,f);case 3:return a(c,l,d,f);case 4:return a(c,l,d,f);case 5:return i(c,l,d,f);case 6:return a(c,l,d,f);case 7:return a(c,l,d,f);case 8:return i(c,l,d,f);case 9:return a(c,l,d,f);case 10:return a(c,l,d,f);case 11:return i(c,l,d,f);case 12:return a(c,l,d,f);case 13:return a(c,l,d,f);case 14:return a(c,l,d,f);case 15:return a(c,l,d,f);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a=function(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r};return a.getPoint=function(t,r,a){return n(a)||(a=new e),a=e.multiplyByScalar(t.direction,r,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(t,r,a,o,u){u=n(u,!1);var s,c,l,d,f,h=t.origin,m=t.direction,p=e.subtract(a,r,y),S=e.subtract(o,r,v),E=e.cross(m,S,g),M=e.dot(p,E);if(u){if(M<i.EPSILON6)return void 0;if(s=e.subtract(h,r,w),l=e.dot(s,E),0>l||l>M)return void 0;if(c=e.cross(s,p,x),d=e.dot(m,c),0>d||l+d>M)return void 0;f=e.dot(S,c)/M}else{if(Math.abs(M)<i.EPSILON6)return void 0;var O=1/M;if(s=e.subtract(h,r,w),l=e.dot(s,E)*O,0>l||l>1)return void 0;if(c=e.cross(s,p,x),d=e.dot(m,c)*O,0>d||l+d>1)return void 0;f=e.dot(S,c)*O}return f}function d(e,t,n,r){var a=t*t-4*e*n;if(0>a)return void 0;if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);return 0===c?void 0:(r.root0=r.root1=c,r)}function f(t,n,a){r(a)||(a={});var i=t.origin,o=t.direction,u=n.center,s=n.radius*n.radius,c=e.subtract(i,u,g),l=e.dot(o,o),f=2*e.dot(o,c),h=e.magnitudeSquared(c)-s,m=d(l,f,h,E);return r(m)?(a.start=m.root0,a.stop=m.root1,a):void 0}function h(e,t,n){var r=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function m(t,n,r,a,c){var l,d=a*a,f=c*c,m=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*f,p=c*(a*h(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+n.y),y=t[o.COLUMN0ROW0]*d+t[o.COLUMN2ROW2]*f+a*n.x+r,v=f*h(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),g=c*(a*h(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+n.z),w=[];if(0===g&&0===v){if(l=u.computeRealRoots(m,p,y),0===l.length)return w;var x=l[0],S=Math.sqrt(Math.max(1-x*x,0));if(w.push(new e(a,c*x,c*-S)),w.push(new e(a,c*x,c*S)),2===l.length){var E=l[1],M=Math.sqrt(Math.max(1-E*E,0));w.push(new e(a,c*E,c*-M)),w.push(new e(a,c*E,c*M))}return w}var O=g*g,_=v*v,P=m*m,R=g*v,C=P+_,z=2*(p*m+R),T=2*y*m+p*p-_+O,I=2*(y*p-R),N=y*y-O;if(0===C&&0===z&&0===T&&0===I)return w;l=s.computeRealRoots(C,z,T,I,N);var b=l.length;if(0===b)return w;for(var A=0;b>A;++A){var D,q=l[A],U=q*q,L=Math.max(1-U,0),W=Math.sqrt(L);D=i.sign(m)===i.sign(y)?h(m*U+y,p*q,i.EPSILON12):i.sign(y)===i.sign(p*q)?h(m*U,p*q+y,i.EPSILON12):h(m*U+p*q,y,i.EPSILON12);var B=h(v*q,g,i.EPSILON15),F=D*B;0>F?w.push(new e(a,c*q,c*W)):F>0?w.push(new e(a,c*q,c*-W)):0!==W?(w.push(new e(a,c*q,c*-W)),w.push(new e(a,c*q,c*W)),++A):w.push(new e(a,c*q,c*W))}return w}var p={};p.rayPlane=function(t,n,a){r(a)||(a=new e);var o=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-n.distance-e.dot(s,o))/c;return 0>l?void 0:(a=e.multiplyByScalar(u,l,a),e.add(o,a,a))};var y=new e,v=new e,g=new e,w=new e,x=new e;p.rayTriangle=function(t,n,a,i,o,u){var s=l(t,n,a,i,o);return!r(s)||0>s?void 0:(r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var S=new c;p.lineSegmentTriangle=function(t,n,a,i,o,u,s){var c=S;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var d=l(c,a,i,o,u);return!r(d)||0>d||d>e.distance(t,n)?void 0:(r(s)||(s=new e),e.multiplyByScalar(c.direction,d,s),e.add(c.origin,s,s))};var E={root0:0,root1:0};p.raySphere=function(e,t,n){return n=f(e,t,n),!r(n)||n.stop<0?void 0:(n.start=Math.max(n.start,0),n)};var M=new c;p.lineSegmentSphere=function(t,n,a,i){var o=M,u=(e.clone(t,o.origin),e.subtract(n,t,o.direction)),s=e.magnitude(u);return e.normalize(u,u),i=f(o,a,i),!r(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var O=new e,_=new e;p.rayEllipsoid=function(t,n){var r,a,i,o,u,s=n.oneOverRadii,c=e.multiplyComponents(s,t.origin,O),l=e.multiplyComponents(s,t.direction,_),d=e.magnitudeSquared(c),f=e.dot(c,l);if(d>1){if(f>=0)return void 0;var h=f*f;if(r=d-1,a=e.magnitudeSquared(l),i=a*r,i>h)return void 0;if(h>i){o=f*f-i,u=-f+Math.sqrt(o);var m=u/a,p=r/u;return p>m?{start:m,stop:p}:{start:p,stop:m}}var y=Math.sqrt(r/a);return{start:y,stop:y}}return 1>d?(r=d-1,a=e.magnitudeSquared(l),i=a*r,o=f*f-i,u=-f+Math.sqrt(o),{start:0,stop:u/a}):0>f?(a=e.magnitudeSquared(l),{start:0,stop:-f/a}):void 0};var P=new e,R=new e,C=new e,z=new e,T=new e,I=new o,N=new o,b=new o,A=new o,D=new o,q=new o,U=new o,L=new e,W=new e,B=new t;p.grazingAltitudeLocation=function(t,n){var a=t.origin,u=t.direction,s=n.geodeticSurfaceNormal(a,P);if(e.dot(u,s)>=0)return a;var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(u,P),d=e.normalize(l,l),f=e.mostOrthogonalAxis(l,z),h=e.normalize(e.cross(f,d,R),R),p=e.normalize(e.cross(d,h,C),C),y=I;y[0]=d.x,y[1]=d.y,y[2]=d.z,y[3]=h.x,y[4]=h.y,y[5]=h.z,y[6]=p.x,y[7]=p.y,y[8]=p.z;var v=o.transpose(y,N),g=o.fromScale(n.radii,b),w=o.fromScale(n.oneOverRadii,A),x=D;x[0]=0,x[1]=-u.z,x[2]=u.y,x[3]=u.z,x[4]=0,x[5]=-u.x,x[6]=-u.y,x[7]=u.x,x[8]=0;var S,E,M=o.multiply(o.multiply(v,w,q),x,q),O=o.multiply(o.multiply(M,g,U),y,U),_=o.multiplyByVector(M,a,T),F=m(O,e.negate(_,P),0,0,1),k=F.length;if(k>0){for(var V=e.clone(e.ZERO,W),j=Number.NEGATIVE_INFINITY,Z=0;k>Z;++Z){S=o.multiplyByVector(g,o.multiplyByVector(y,F[Z],L),L);var H=e.normalize(e.subtract(S,a,z),z),Y=e.dot(H,u);Y>j&&(j=Y,V=e.clone(S,V))}var X=n.cartesianToCartographic(V,B);return j=i.clamp(j,0,1),E=e.magnitude(e.subtract(V,a,z))*Math.sqrt(1-j*j),E=c?-E:E,X.height=E,n.cartographicToCartesian(X,new e)}return void 0};var F=new e;return p.lineSegmentPlane=function(t,n,a,o){r(o)||(o=new e);var u=e.subtract(n,t,F),s=a.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),d=-(a.distance+l)/c;return 0>d||d>1?void 0:(e.multiplyByScalar(u,d,o),e.add(t,o,o),o)},p.trianglePlaneIntersection=function(t,n,r,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,n)+o<0,c=e.dot(i,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var d,f;if((1===l||2===l)&&(d=new e,f=new e),1===l){if(u)return p.lineSegmentPlane(t,n,a,d),p.lineSegmentPlane(t,r,a,f),{positions:[t,n,r,d,f],indices:[0,3,4,1,2,4,1,4,3]};if(s)return p.lineSegmentPlane(n,r,a,d),p.lineSegmentPlane(n,t,a,f),{positions:[t,n,r,d,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return p.lineSegmentPlane(r,t,a,d),p.lineSegmentPlane(r,n,a,f),{positions:[t,n,r,d,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return p.lineSegmentPlane(n,t,a,d),p.lineSegmentPlane(r,t,a,f),{positions:[t,n,r,d,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return p.lineSegmentPlane(r,n,a,d),p.lineSegmentPlane(t,n,a,f),{positions:[t,n,r,d,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return p.lineSegmentPlane(t,r,a,d),p.lineSegmentPlane(n,r,a,f),{positions:[t,n,r,d,f],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},p}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,a){return t(e).then(n,r,a)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=a(e),t}function n(t){return e(t,i)}function r(e){this.then=e}function a(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return i(r)}});return n}function i(e){var n=new r(function(n,r){try{return r?t(r(e)):i(e)}catch(a){return i(a)}});return n}function o(){function e(e,t,n){return f(e,t,n)}function n(e){return m(e)}function a(e){return m(i(e))}function u(e){return h(e)}var s,c,l,d,f,h,m;return c=new r(e),s={then:e,resolve:n,reject:a,progress:u,promise:c,resolver:{resolve:n,reject:a,progress:u}},l=[],d=[],f=function(e,t,n){var r,a;return r=o(),a="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,a)}),d.push(a),r.promise},h=function(e){return p(d,e),e},m=function(e){return e=t(e),f=e.then,m=t,h=v,p(l,e),d=l=S,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,a,i){return y(2,arguments),e(t,function(t){function u(e){p(e)}function s(e){m(e)}var c,l,d,f,h,m,p,y,g,w;if(g=t.length>>>0,c=Math.max(0,Math.min(n,g)),d=[],l=g-c+1,f=[],h=o(),c)for(y=h.progress,p=function(e){f.push(e),--l||(m=p=v,h.reject(f))},m=function(e){d.push(e),--c||(m=p=v,h.resolve(d))},w=0;g>w;++w)w in t&&e(t[w],s,u,y);else h.resolve(d);return h.then(r,a,i)})}function c(e,t,n,r){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,n,r)}function l(e,t,n,r){return y(1,arguments),f(e,g).then(t,n,r)}function d(){return f(arguments,g)}function f(t,n){return e(t,function(t){var r,a,i,u,s,c;if(i=a=t.length>>>0,r=[],c=o(),i)for(u=function(t,a){e(t,n).then(function(e){r[a]=e,--i||c.resolve(r)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(r);return c.promise})}function h(t,n){var r=x.call(arguments,1);return e(t,function(t){var a;return a=t.length,r[0]=function(t,r,i){return e(t,function(t){return e(r,function(e){return n(t,e,i,a)})})},w.apply(t,r)})}function m(t,n,r){var a=arguments.length>2;return e(t,function(e){return e=a?r:e,n.resolve(e),e},function(e){return n.reject(e),i(e)},n.progress)}function p(e,t){for(var n,r=0;n=e[r++];)n(t)}function y(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function v(){}function g(e){return e}var w,x,S;return e.defer=o,e.resolve=t,e.reject=n,e.join=d,e.all=l,e.map=f,e.reduce=h,e.any=c,e.some=s,e.chain=m,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(S,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(S,t)})})}},x=[].slice,w=[].reduce||function(e){var t,n,r,a,i;if(i=0,t=Object(this),a=t.length>>>0,n=arguments,n.length<=1)for(;;){if(i in t){r=t[i++];break}if(++i>=a)throw new TypeError}else r=n[1];for(;a>i;++i)i in t&&(r=e(r,t[i],i,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var n=function(e,t,n){for(var r,a,i=0,o=e.length-1;o>=i;)if(r=~~((i+o)/2),a=n(e[r],t),0>a)i=r+1;else{if(!(a>0))return r;o=r-1}return~(o+1)};return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],a=function(e,t,n,r){n||(n=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e},i=function(e,t,n,r,i,o){var u=r-e.length;return u>0&&(e=n||!i?a(e,r,o,n):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+a(c.toString(t),u||0,"0",!1),i(e,n,r,o,s)},u=function(e,t,n,r,a,o){return null!=r&&(e=e.slice(0,r)),i(e,"",t,n,a,o)},s=function(e,r,s,c,l,d,f){var h,m,p,y,v;if("%%"==e)return"%";for(var g=!1,w="",x=!1,S=!1,E=" ",M=s.length,O=0;s&&M>O;O++)switch(s.charAt(O)){case" ":w=" ";break;case"+":w="+";break;case"-":g=!0;break;case"'":E=s.charAt(O+1);break;case"0":x=!0;break;case"#":S=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,g=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(d=d?"*"==d?+t[n++]:"*"==d.charAt(0)?+t[d.slice(1,-1)]:+d:"fFeE".indexOf(f)>-1?6:"d"==f?0:void 0,v=r?t[r.slice(0,-1)]:t[n++],f){case"s":return u(String(v),g,c,d,x,E);case"c":return u(String.fromCharCode(+v),g,c,d,x);case"b":return o(v,2,S,g,c,d,x);case"o":return o(v,8,S,g,c,d,x);case"x":return o(v,16,S,g,c,d,x);case"X":return o(v,16,S,g,c,d,x).toUpperCase();case"u":return o(v,10,S,g,c,d,x);case"i":case"d":return h=+v||0,h=Math.round(h-h%1),m=0>h?"-":w,v=m+a(String(Math.abs(h)),d,"0",!1),i(v,m,g,c,x);case"e":case"E":case"f":case"F":case"g":case"G":return h=+v,m=0>h?"-":w,p=["toExponential","toFixed","toPrecision"]["efg".indexOf(f.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(f)%2],v=m+Math.abs(h)[p](d),i(v,m,g,c,x)[y]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,n,r,a,i,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t){return z.compare(e.julianDate,t.julianDate)}function d(e){g.julianDate=e;var n=z.leapSeconds,r=t(n,g,l);0>r&&(r=~r),r>=n.length&&(r=n.length-1);var a=n[r].offset;if(r>0){var i=z.secondsDifference(n[r].julianDate,e);i>a&&(r--,a=n[r].offset)}z.addSeconds(e,a,e)}function f(e,n){g.julianDate=e;var r=z.leapSeconds,a=t(r,g,l);if(0>a&&(a=~a),0===a)return z.addSeconds(e,-r[0].offset,n);if(a>=r.length)return z.addSeconds(e,-r[a-1].offset,n);var i=z.secondsDifference(r[a].julianDate,e);return 0===i?z.addSeconds(e,-r[a].offset,n):1>=i?void 0:z.addSeconds(e,-r[--a].offset,n)}function h(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,0>t&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function m(e,t,n,r,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,0>r&&(r+=24);var d=i+(r*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return d>=43200&&(l-=1),[l,d]}var p=new i,y=[31,28,31,30,31,30,31,31,30,31,30,31],v=29,g=new u,w=/^(\d{4})$/,x=/^(\d{4})-(\d{2})$/,S=/^(\d{4})-?(\d{3})$/,E=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,O=/([Z+\-])?(\d{2})?:?(\d{2})?$/,_=/^(\d{2})(\.\d+)?/.source+O.source,P=/^(\d{2}):?(\d{2})(\.\d+)?/.source+O.source,R=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+O.source,C="Invalid ISO 8601 date.",z=function(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,h(a,t,this),r===c.UTC&&d(this)};z.fromDate=function(e,t){var n=m(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(h(n[0],n[1],t),d(t),t):new z(n[0],n[1],c.UTC)},z.fromIso8601=function(e,t){e=e.replace(",",".");var n,i,u,s=e.split("T"),l=1,f=1,p=0,g=0,O=0,T=0,I=s[0],N=s[1];if(!r(I))throw new a(C);var b;if(s=I.match(M),null!==s){if(b=I.split("-").length-1,b>0&&2!==b)throw new a(C);n=+s[1],l=+s[2],f=+s[3]}else if(s=I.match(x),null!==s)n=+s[1],l=+s[2];else if(s=I.match(w),null!==s)n=+s[1];else{var A;if(s=I.match(S),null!==s){if(n=+s[1],A=+s[2],u=o(n),1>A||u&&A>366||!u&&A>365)throw new a(C)}else{if(s=I.match(E),null===s)throw new a(C);n=+s[1];var D=+s[2],q=+s[3]||0;if(b=I.split("-").length-1,b>0&&(!r(s[3])&&1!==b||r(s[3])&&2!==b))throw new a(C);var U=new Date(Date.UTC(n,0,4));A=7*D+q-U.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(A),l=i.getUTCMonth()+1,f=i.getUTCDate()}if(u=o(n),1>l||l>12||1>f||(2!==l||!u)&&f>y[l-1]||u&&2===l&&f>v)throw new a(C);var L;if(r(N)){if(s=N.match(R),null!==s){if(b=N.split(":").length-1,b>0&&2!==b&&3!==b)throw new a(C);p=+s[1],g=+s[2],O=+s[3],T=1e3*+(s[4]||0),L=5}else if(s=N.match(P),null!==s){if(b=N.split(":").length-1,b>0&&1!==b)throw new a(C);p=+s[1],g=+s[2],O=60*+(s[3]||0),L=4}else{if(s=N.match(_),null===s)throw new a(C);p=+s[1],g=60*+(s[2]||0),L=3}if(g>=60||O>=61||p>24||24===p&&(g>0||O>0||T>0))throw new a(C);var W=s[L],B=+s[L+1],F=+(s[L+2]||0);switch(W){case"+":p-=B,g-=F;break;case"-":p+=B,g+=F;break;case"Z":break;default:g+=new Date(Date.UTC(n,l-1,f,p,g)).getTimezoneOffset()}}else g+=new Date(n,l-1,f).getTimezoneOffset();var k=60===O;for(k&&O--;g>=60;)g-=60,p++;for(;p>=24;)p-=24,f++;for(i=u&&2===l?v:y[l-1];f>i;)f-=i,l++,l>12&&(l-=12,n++),i=u&&2===l?v:y[l-1];for(;0>g;)g+=60,p--;for(;0>p;)p+=24,f--;for(;1>f;)l--,1>l&&(l+=12,n--),i=u&&2===l?v:y[l-1],f+=i;var V=m(n,l,f,p,g,O,T);return r(t)?(h(V[0],V[1],t),d(t)):t=new z(V[0],V[1],c.UTC),k&&z.addSeconds(t,1,t),t},z.now=function(e){return z.fromDate(new Date,e)};var T=new z(0,0,c.TAI);return z.toGregorianDate=function(e,t){var n=!1,a=f(e,T);r(a)||(z.addSeconds(e,-1,T),a=f(T,T),n=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var d=4e3*(c+1)/1461001|0;c=c-(1461*d/4|0)+31|0;var h=80*c/2447|0,m=c-(2447*h/80|0)|0;c=h/11|0;var p=h+2-12*c|0,y=100*(l-49)+d+c|0,v=u/s.SECONDS_PER_HOUR|0,g=u-v*s.SECONDS_PER_HOUR,w=g/s.SECONDS_PER_MINUTE|0;g-=w*s.SECONDS_PER_MINUTE;var x=0|g,S=(g-x)/s.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),n&&(x+=1),r(t)?(t.year=y,t.month=p,t.day=m,t.hour=v,t.minute=w,t.second=x,t.millisecond=S,t.isLeapSecond=n,t):new i(y,p,m,v,w,x,S,n)},z.toDate=function(e){var t=z.toGregorianDate(e,p),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},z.toIso8601=function(t,n){var a,i=z.toGregorianDate(t,i);return r(n)||0===i.millisecond?r(n)&&0!==n?(a=(.01*i.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},z.clone=function(e,t){return r(e)?r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new z(e.dayNumber,e.secondsOfDay,c.TAI):void 0},z.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},z.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},z.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(z.secondsDifference(e,t))<=n},z.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},z.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},z.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},z.computeTaiMinusUtc=function(e){g.julianDate=e;var n=z.leapSeconds,r=t(n,g,l);return 0>r&&(r=~r,--r,0>r&&(r=0)),n[r].offset},z.addSeconds=function(e,t,n){return h(e.dayNumber,e.secondsOfDay+t,n)},z.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,r,n)},z.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,r,n)},z.addDays=function(e,t,n){var r=e.dayNumber+t;return h(r,e.secondsOfDay,n)},z.lessThan=function(e,t){return z.compare(e,t)<0},z.lessThanOrEquals=function(e,t){return z.compare(e,t)<=0},z.greaterThan=function(e,t){return z.compare(e,t)>0},z.greaterThanOrEquals=function(e,t){return z.compare(e,t)>=0},z.prototype.clone=function(e){return z.clone(this,e)},z.prototype.equals=function(e){return z.equals(this,e)},z.prototype.equalsEpsilon=function(e,t){return z.equalsEpsilon(this,e,t)},z.prototype.toString=function(){return z.toIso8601(this)},z.leapSeconds=[new u(new z(2441317,43210,c.TAI),10),new u(new z(2441499,43211,c.TAI),11),new u(new z(2441683,43212,c.TAI),12),new u(new z(2442048,43213,c.TAI),13),new u(new z(2442413,43214,c.TAI),14),new u(new z(2442778,43215,c.TAI),15),new u(new z(2443144,43216,c.TAI),16),new u(new z(2443509,43217,c.TAI),17),new u(new z(2443874,43218,c.TAI),18),new u(new z(2444239,43219,c.TAI),19),new u(new z(2444786,43220,c.TAI),20),new u(new z(2445151,43221,c.TAI),21),new u(new z(2445516,43222,c.TAI),22),new u(new z(2446247,43223,c.TAI),23),new u(new z(2447161,43224,c.TAI),24),new u(new z(2447892,43225,c.TAI),25),new u(new z(2448257,43226,c.TAI),26),new u(new z(2448804,43227,c.TAI),27),new u(new z(2449169,43228,c.TAI),28),new u(new z(2449534,43229,c.TAI),29),new u(new z(2450083,43230,c.TAI),30),new u(new z(2450630,43231,c.TAI),31),new u(new z(2451179,43232,c.TAI),32),new u(new z(2453736,43233,c.TAI),33),new u(new z(2454832,43234,c.TAI),34),new u(new z(2456109,43235,c.TAI),35),new u(new z(2457204,43236,c.TAI),36)],z}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var a=new n.constructor;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];r&&(o=t(o,r)),a[i]=o}return a};return t}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var n=function(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,n,r,a,i){"use strict";function o(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function u(e,t){for(var n=o(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function s(e,n){n=t(n,"");var a=e[1],i=!!e[2],s=e[3];switch(n){case"":case"text":return o(i,s);case"arraybuffer":return u(i,s);case"blob":var c=u(i,s);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(o(i,s),a);case"json":return JSON.parse(o(i,s));default:throw new r("Unhandled responseType: "+n)}}var c=function(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,a=t(n.method,"GET"),i=n.data,o=n.headers,u=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return c.load(t,r,a,i,o,n,u),n.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return c.load=function(e,t,r,o,u,c,d){var f=l.exec(e);if(null!==f)return void c.resolve(s(f,t));var h=new XMLHttpRequest;if(n(d)&&n(h.overrideMimeType)&&h.overrideMimeType(d),h.open(r,e,!0),n(u))for(var m in u)u.hasOwnProperty(m)&&h.setRequestHeader(m,u[m]);n(t)&&(h.responseType=t),h.onload=function(){200===h.status?n(h.response)?c.resolve(h.response):n(h.responseXML)&&h.responseXML.hasChildNodes()?c.resolve(h.responseXML):n(h.responseText)?c.resolve(h.responseText):c.reject(new i("unknown XMLHttpRequest response type.")):c.reject(new a(h.status,h.response,h.getAllResponseHeaders()))},h.onerror=function(e){c.reject(new a)},h.send(o)},c.defaultLoad=c.load,c}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,n){return e({url:t,headers:n})};return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";var a={Accept:"application/json,*/*;q=0.01"},i=function(n,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,r(n,i).then(function(e){return JSON.parse(e)})};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c,l,d){"use strict";function f(e,t){return o.compare(e.julianDate,t)}function h(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=n.columnNames.indexOf("modifiedJulianDateUtc"),i=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),h=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),m=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),p=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>h||0>m||0>p)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var y=e._samples=n.samples,v=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=m,e._taiMinusUtcSecondsColumn=p,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var g,w=e._addNewLeapSeconds,x=0,S=y.length;S>x;x+=e._columnCount){var E=y[x+a],M=y[x+p],O=E+l.MODIFIED_JULIAN_DATE_DIFFERENCE,_=new o(O,M,d.TAI);if(v.push(_),w){if(M!==g&&r(g)){var P=o.leapSeconds,R=t(P,_,f);if(0>R){var C=new u(_,M);P.splice(~R,0,C)}}g=M}}}function m(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function p(e,t,n){return t+e*(n-t)}function y(e,t,n,r,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||r.equals(c))return m(e,n,a,s,u),u;if(r.equals(l))return m(e,n,i,s,u),u;var d=o.secondsDifference(r,c)/o.secondsDifference(l,c),f=a*s,h=i*s,y=n[f+e._ut1MinusUtcSecondsColumn],v=n[h+e._ut1MinusUtcSecondsColumn],g=v-y;if(g>.5||-.5>g){var w=n[f+e._taiMinusUtcSecondsColumn],x=n[h+e._taiMinusUtcSecondsColumn];w!==x&&(l.equals(r)?y=v:v-=x-w)}return u.xPoleWander=p(d,n[f+e._xPoleWanderRadiansColumn],n[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=p(d,n[f+e._yPoleWanderRadiansColumn],n[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=p(d,n[f+e._xCelestialPoleOffsetRadiansColumn],n[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=p(d,n[f+e._yCelestialPoleOffsetRadiansColumn],n[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=p(d,y,v),u}var v=function(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))h(this,t.data);else if(r(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){h(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return v.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,
t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),v.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},v.prototype.compute=function(e,n){if(!r(this._samples)){if(r(this._dataError))throw new c(this._dataError);return void 0}if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var d=i[u],f=i[u+1],h=o.lessThanOrEquals(d,e),m=!r(f),p=m||o.greaterThanOrEquals(f,e);if(h&&p)return s=u,!m&&f.equals(e)&&++s,l=s+1,y(this,i,this._samples,e,s,l,n),n}var v=t(i,e,o.compare,this._dateColumn);return v>=0?(v<i.length-1&&i[v+1].equals(e)&&++v,s=v,l=v):(l=~v,s=l-1,0>s&&(s=0)),this._lastIndex=s,y(this,i,this._samples,e,s,l,n),n},v}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);("."==e||".."==e)&&n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,n,r){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;n>t;++t){var r=e[t].getAttribute("src"),a=d.exec(r);if(null!==a)return a[1]}return void 0}function i(){if(t(s))return s;var r;if(r="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(r))throw new n("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(r).resolve(new e(document.location.href))}function o(e){return r.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}var s,c,l,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,f=function(e){t(c)||(c=t(r.toUrl)?o:u),t(l)||(l=document.createElement("a"));var n=c(e);return l.href=n,l.href=l.href,l.href};return f._cesiumScriptRegex=d,f.setBaseUrl=function(t){s=new e(t).resolve(new e(document.location.href))},f}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,n){this.x=e,this.y=t,this.s=n};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,t,n){var r=d;return r.dayNumber=t,r.secondsOfDay=n,i.daysDifference(r,e._sampleZeroDateTT)}function c(n,a){if(n._chunkDownloadsInProgress[a])return n._chunkDownloadsInProgress[a];var i=e.defer();n._chunkDownloadsInProgress[a]=i;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[a]=!1;for(var t=n._samples,r=e.samples,o=a*n._samplesPerXysFile*3,u=0,s=r.length;s>u;++u)t[o+u]=r[u];i.resolve()}),i.promise}var l=function(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){r[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)},d=new i(0,0,u.TAI);return l.prototype.preload=function(t,n,r,a){var i=s(this,t,n),o=s(this,r,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var d=u/this._samplesPerXysFile|0,f=l/this._samplesPerXysFile|0,h=[],m=d;f>=m;++m)h.push(c(this,m));return e.all(h)},l.prototype.computeXysRadians=function(e,t,n){var i=s(this,e,t);if(0>i)return void 0;var o=i/this._stepSizeDays|0;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(u/2|0);0>l&&(l=0);var d=l+u;d>=this._totalSamples&&(d=this._totalSamples-1,l=d-u,0>l&&(l=0));var f=!1,h=this._samples;if(r(h[3*l])||(c(this,l/this._samplesPerXysFile|0),f=!0),r(h[3*d])||(c(this,d/this._samplesPerXysFile|0),f=!0),f)return void 0;r(n)?(n.x=0,n.y=0,n.s=0):n=new a(0,0,0);var m,p,y=i-l*this._stepSizeDays,v=this._work,g=this._denominators,w=this._coef,x=this._xTable;for(m=0;u>=m;++m)v[m]=y-x[m];for(m=0;u>=m;++m){for(w[m]=1,p=0;u>=p;++p)p!==m&&(w[m]*=v[p]);w[m]*=g[m];var S=3*(l+m);n.x+=w[m]*h[S++],n.y+=w[m]*h[S++],n.s+=w[m]*h[S]}return n},l}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?r.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(r.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[r.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function a(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,v=r(e[1]))}return y}function i(){return a()&&v}function o(){if(!t(g)&&(g=!1,!a()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,w=r(e[1]))}return g}function u(){return o()&&w}function s(){if(!t(x)){x=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(x=!0,S=r(e[1]),S.isNightly=!!e[2])}return x}function c(){return s()&&S}function l(){if(!t(E)){E=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,M=r(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,M=r(e[1])))}return E}function d(){return l()&&M}function f(){if(!t(O)){O=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(O=!0,_=r(e[1]))}return O}function h(){return t(P)||(P=/Windows/i.test(navigator.appVersion)),P}function m(){return f()&&_}function p(){return t(R)||(R=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),R}var y,v,g,w,x,S,E,M,O,_,P,R,C={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:d,isFirefox:f,firefoxVersion:m,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:p};return C.supportsFullscreen=function(){return n.supportsFullscreen()},C.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},C.supportsWebWorkers=function(){return"undefined"!=typeof Worker},C}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,n,r,a){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(a,0)},c=new e;s.fromAxisAngle=function(t,r,a){var i=r/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,d=c.z*o,f=Math.cos(i);return n(a)?(a.x=u,a.y=l,a.z=d,a.w=f,a):new s(u,l,d,f)};var l=[1,2,0],d=new Array(3);s.fromRotationMatrix=function(e,t){var r,a,i,o,c,f=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],p=f+h+m;if(p>0)r=Math.sqrt(p+1),c=.5*r,r=.5/r,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var y=l,v=0;h>f&&(v=1),m>f&&m>h&&(v=2);var g=y[v],w=y[g];r=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(g,g)]-e[u.getElementIndex(w,w)]+1);var x=d;x[v]=.5*r,r=.5/r,c=(e[u.getElementIndex(w,g)]-e[u.getElementIndex(g,w)])*r,x[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*r,x[w]=(e[u.getElementIndex(w,v)]+e[u.getElementIndex(v,w)])*r,a=-x[0],i=-x[1],o=-x[2]}return n(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var f=new s;s.fromHeadingPitchRoll=function(t,n,r,a){var i=s.fromAxisAngle(e.UNIT_X,r,f),o=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,f);return s.multiply(u,a,a)};var h=new e,m=new e,p=new s,y=new s,v=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.x=e[r],a.y=e[r+1],a.z=e[r+2],a.w=e[r+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,v),s.conjugate(v,v);for(var a=0,i=n-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),p),s.multiply(p,v,p),p.w<0&&s.negate(p,p),s.computeAxis(p,h);var u=s.computeAngle(p);r[o]=h.x*u,r[o+1]=h.y*u,r[o+2]=h.z*u}},s.unpackInterpolationResult=function(t,r,a,i,o){n(o)||(o=new s),e.fromArray(t,0,m);var u=e.magnitude(m);return s.unpack(r,4*i,y),0===u?s.clone(s.IDENTITY,p):s.fromAxisAngle(m,u,p),s.multiply(p,y,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,o=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,d=o*u+r*l+a*c-i*s,f=o*s-r*c+a*l+i*u,h=o*c+r*s-a*u+i*l,m=o*l-r*u-a*s-i*c;return n.x=d,n.y=f,n.z=h,n.w=m,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var g=new s;s.lerp=function(e,t,n,r){return g=s.multiplyByScalar(t,n,g),r=s.multiplyByScalar(e,1-n,r),s.add(g,r,r)};var w=new s,x=new s,S=new s;s.slerp=function(e,t,n,r){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=w=s.negate(t,w)),1-a<o.EPSILON6)return s.lerp(e,i,n,r);var u=Math.acos(a);return x=s.multiplyByScalar(e,Math.sin((1-n)*u),x),S=s.multiplyByScalar(i,Math.sin(n*u),S),r=s.add(x,S,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),a=0;return 0!==r&&(a=r/Math.sin(r)),e.multiplyByScalar(t,a,n)},s.exp=function(t,n){var r=e.magnitude(t),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(r),n};var E=new e,M=new e,O=new s,_=new s;s.computeInnerQuadrangle=function(t,n,r,a){var i=s.conjugate(n,O);s.multiply(i,r,_);var o=s.log(_,E);s.multiply(i,t,_);var u=s.log(_,M);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,O),s.multiply(n,O,a)},s.squad=function(e,t,n,r,a,i){var o=s.slerp(e,t,a,O),u=s.slerp(n,r,a,_);return s.slerp(o,u,2*a*(1-a),i)};for(var P=new s,R=1.9011074535173003,C=a.supportsTypedArrays()?new Float32Array(8):[],z=a.supportsTypedArrays()?new Float32Array(8):[],T=a.supportsTypedArrays()?new Float32Array(8):[],I=a.supportsTypedArrays()?new Float32Array(8):[],N=0;7>N;++N){var b=N+1,A=2*b+1;C[N]=1/(b*A),z[N]=b/A}return C[7]=R/136,z[7]=8*R/17,s.fastSlerp=function(e,t,n,r){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,c=n*n,l=u*u,d=7;d>=0;--d)T[d]=(C[d]*c-z[d])*o,I[d]=(C[d]*l-z[d])*o;var f=a*n*(1+T[0]*(1+T[1]*(1+T[2]*(1+T[3]*(1+T[4]*(1+T[5]*(1+T[6]*(1+T[7])))))))),h=u*(1+I[0]*(1+I[1]*(1+I[2]*(1+I[3]*(1+I[4]*(1+I[5]*(1+I[6]*(1+I[7])))))))),m=s.multiplyByScalar(e,h,P);return s.multiplyByScalar(t,f,r),s.add(m,r,r)},s.fastSquad=function(e,t,n,r,a,i){var o=s.fastSlerp(e,t,a,O),u=s.fastSlerp(n,r,a,_);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,a,i,o,u,s,c,l,d,f,h,m,p,y,v){"use strict";var g={},w=new n,x=new n,S=new n;g.eastNorthUpToFixedFrame=function(e,t,r){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-o,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=w,s=x,l=S;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=l.x,r[5]=l.y,r[6]=l.z,r[7]=0,r[8]=u.x,r[9]=u.y,r[10]=u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var E=new n,M=new n,O=new n;g.northEastDownToFixedFrame=function(e,t,r){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=E,s=M,l=O;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-u.x,r[9]=-u.y,r[10]=-u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},g.northUpEastToFixedFrame=function(e,t,r){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=o,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=w,s=x,l=S;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=u.x,r[5]=u.y,r[6]=u.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var _=new y,P=new n(1,1,1),R=new p;g.headingPitchRollToFixedFrame=function(e,t,r,a,i,o){var u=y.fromHeadingPitchRoll(t,r,a,_),s=p.fromTranslationQuaternionRotationScale(n.ZERO,u,P,R);return o=g.eastNorthUpToFixedFrame(e,i,o),p.multiply(o,s,o)};var C=new p,z=new m;g.headingPitchRollQuaternion=function(e,t,n,r,a,i){var o=g.headingPitchRollToFixedFrame(e,t,n,r,a,C),u=p.getRotation(o,z);return y.fromRotationMatrix(u,i)};var T=24110.54841,I=8640184.812866,N=.093104,b=-62e-7,A=1.1772758384668e-19,D=72921158553e-15,q=h.TWO_PI/86400,U=new f;g.computeTemeToPseudoFixedMatrix=function(e,t){U=f.addSeconds(e,-f.computeTaiMinusUtc(e),U);var n,r=U.dayNumber,a=U.secondsOfDay,o=r-2451545;n=a>=43200?(o+.5)/v.DAYS_PER_JULIAN_CENTURY:(o-.5)/v.DAYS_PER_JULIAN_CENTURY;var u=T+n*(I+n*(N+n*b)),s=u*q%h.TWO_PI,c=D+A*(r-2451545.5),l=(a+.5*v.SECONDS_PER_DAY)%v.SECONDS_PER_DAY,d=s+c*l,p=Math.cos(d),y=Math.sin(d);return i(t)?(t[0]=p,t[1]=-y,t[2]=0,t[3]=y,t[4]=p,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new m(p,y,0,-y,p,0,0,0,1)},g.iau2006XysData=new l,g.earthOrientationParameters=u.NONE;var L=32.184,W=2451545;g.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+L,a=t.stop.dayNumber,i=t.stop.secondsOfDay+L,o=g.iau2006XysData.preload(n,r,a,i),u=g.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},g.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new m);var n=g.computeFixedToIcrfMatrix(e,t);return i(n)?m.transpose(n,t):void 0};var B=new d(0,0,0),F=new s(0,0,0,0,0,0),k=new m,V=new m;g.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new m);var n=g.earthOrientationParameters.compute(e,F);if(!i(n))return void 0;var r=e.dayNumber,a=e.secondsOfDay+L,o=g.iau2006XysData.computeXysRadians(r,a,B);if(!i(o))return void 0;var u=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=k;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var d=m.fromRotationZ(-o.s,V),p=m.multiply(l,d,k),y=e.dayNumber,w=e.secondsOfDay-f.computeTaiMinusUtc(e)+n.ut1MinusUtc,x=y-2451545,S=w/v.SECONDS_PER_DAY,E=.779057273264+S+.00273781191135448*(x+S);E=E%1*h.TWO_PI;var M=m.fromRotationZ(E,V),O=m.multiply(p,M,k),_=Math.cos(n.xPoleWander),P=Math.cos(n.yPoleWander),R=Math.sin(n.xPoleWander),C=Math.sin(n.yPoleWander),z=r-W+a/v.SECONDS_PER_DAY;z/=36525;var T=-47e-6*z*h.RADIANS_PER_DEGREE/3600,I=Math.cos(T),N=Math.sin(T),b=V;return b[0]=_*I,b[1]=_*N,b[2]=R,b[3]=-P*N+C*R*I,b[4]=P*I+C*R*N,b[5]=-C*_,b[6]=-C*N-P*R*I,b[7]=C*I-P*R*N,b[8]=P*_,m.multiply(O,b,t)};var j=new r;g.pointToWindowCoordinates=function(e,t,n,r){return r=g.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},g.pointToGLWindowCoordinates=function(e,n,a,o){i(o)||(o=new t);var u=j;return p.multiplyByVector(e,r.fromElements(a.x,a.y,a.z,1,u),u),r.multiplyByScalar(u,1/u.w,u),p.multiplyByVector(n,u,u),t.fromCartesian4(u,o)};var Z=new n,H=new n,Y=new n;return g.rotationMatrixFromPositionVelocity=function(e,t,r,o){var u=a(r,c.WGS84).geodeticSurfaceNormal(e,Z),s=n.cross(t,u,H);n.equalsEpsilon(s,n.ZERO,h.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var l=n.cross(s,t,Y);return n.cross(t,l,s),n.negate(s,s),i(o)||(o=new m),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},g}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,d,f,h,m){"use strict";var p=new r,y=function(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=m.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(d.getColumn(r,0,p)),this._yAxis=n.fromCartesian4(d.getColumn(r,1,p));var i=n.fromCartesian4(d.getColumn(r,2,p));this._plane=f.fromPointNormal(e,i)};o(y.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var v=new e;y.fromPoints=function(t,n){var r=e.fromPoints(t,v);return new y(r.center,n)};var g=new h,w=new n;y.prototype.projectPointOntoPlane=function(e,r){var a=g;a.origin=e,n.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,w);if(i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,w)),i(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return i(r)?(r.x=s,r.y=l,r):new t(s,l)}return void 0},y.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var n=0,r=e.length,a=0;r>a;a++){var o=this.projectPointOntoPlane(e[a],t[n]);i(o)&&(t[n]=o,n++)}return t.length=n,t},y.prototype.projectPointToNearestOnPlane=function(e,r){i(r)||(r=new t);var a=g;a.origin=e,n.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,w);i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,w));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},y.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;n>r;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var x=new n;return y.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=x,l=0;r>l;++l){var d=e[l];n.multiplyByScalar(u,d.x,c),i(t[l])||(t[l]=new n);var f=n.add(o,c,t[l]);n.multiplyByScalar(s,d.y,c),n.add(f,c,f),a.scaleToGeocentricSurface(f,f)}return t},y}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,d,f,h,m){"use strict";var p=function(e,t){this.center=n.clone(a(e,n.ZERO)),this.halfAxes=f.clone(a(t,f.ZERO))},y=new n,v=new n,g=new n,w=new n,x=new n,S=new f,E={unitary:new f,diagonal:new f};p.fromPoints=function(e,t){if(i(t)||(t=new p),!i(e)||0===e.length)return t.halfAxes=f.ZERO,t.center=n.ZERO,t;var r,a=e.length,o=n.clone(e[0],y);for(r=1;a>r;r++)n.add(o,e[r],o);var u=1/a;n.multiplyByScalar(o,u,o);var s,c=0,l=0,d=0,h=0,m=0,M=0;for(r=0;a>r;r++)s=n.subtract(e[r],o,v),c+=s.x*s.x,l+=s.x*s.y,d+=s.x*s.z,h+=s.y*s.y,m+=s.y*s.z,M+=s.z*s.z;c*=u,l*=u,d*=u,h*=u,m*=u,M*=u;var O=S;O[0]=c,O[1]=l,O[2]=d,O[3]=l,O[4]=h,O[5]=m,O[6]=d,O[7]=m,O[8]=M;var _=f.computeEigenDecomposition(O,E),P=f.transpose(_.unitary,t.halfAxes);s=n.subtract(e[0],o,v);var R=f.multiplyByVector(P,s,g),C=n.clone(R,w),z=n.clone(R,x);for(r=1;a>r;r++)s=n.subtract(e[r],o,s),f.multiplyByVector(P,s,R),n.minimumByComponent(z,R,z),n.maximumByComponent(C,R,C);var T=n.add(z,C,g);n.multiplyByScalar(T,.5,T),f.multiplyByVector(P,T,T),n.add(o,T,t.center);var I=n.subtract(C,z,g);return n.multiplyByScalar(I,.5,I),f.multiplyByScale(t.halfAxes,I,t.halfAxes),t};var M=new n,O=new n,_=function(e,t,r,a,o,u,s,c){i(c)||(c=new p);var l=c.halfAxes;f.setColumn(l,0,e.xAxis,l),f.setColumn(l,1,e.yAxis,l),f.setColumn(l,2,e.zAxis,l);var d=M;d.x=(t+r)/2,d.y=(a+o)/2,d.z=(u+s)/2;var h=O;h.x=(r-t)/2,h.y=(o-a)/2,h.z=(s-u)/2;var m=c.center;return d=f.multiplyByVector(l,d,d),n.add(e.origin,d,m),f.multiplyByScale(l,h,l),c},P=new r,R=new n,C=[new r,new r,new r,new r,new r,new r,new r,new r],z=[new n,new n,new n,new n,new n,new n,new n,new n],T=[new t,new t,new t,new t,new t,new t,new t,new t];p.fromRectangle=function(e,t,n,r,i){t=a(t,0),n=a(n,0),r=a(r,u.WGS84);var o=m.center(e,P),c=r.cartographicToCartesian(o,R),l=new s(c,r),d=l.plane,f=C[0],p=C[1],y=C[2],v=C[3],g=C[4],w=C[5],x=C[6],S=C[7],E=o.longitude,M=e.south<0&&e.north>0?0:o.latitude;x.latitude=w.latitude=g.latitude=e.south,S.latitude=v.latitude=M,f.latitude=p.latitude=y.latitude=e.north,x.longitude=S.longitude=f.longitude=e.west,w.longitude=p.longitude=E,g.longitude=v.longitude=y.longitude=e.east,y.height=p.height=f.height=S.height=x.height=w.height=g.height=v.height=n,r.cartographicArrayToCartesianArray(C,z),l.projectPointsToNearestOnPlane(z,T);var O=Math.min(T[6].x,T[7].x,T[0].x),I=Math.max(T[2].x,T[3].x,T[4].x),N=Math.min(T[4].y,T[5].y,T[6].y),b=Math.max(T[0].y,T[1].y,T[2].y);y.height=f.height=g.height=x.height=t,r.cartographicArrayToCartesianArray(C,z);var A=Math.min(h.getPointDistance(d,z[0]),h.getPointDistance(d,z[2]),h.getPointDistance(d,z[4]),h.getPointDistance(d,z[6])),D=n;return _(l,O,I,N,b,A,D,i)},p.clone=function(e,t){return i(e)?i(t)?(n.clone(e.center,t.center),f.clone(e.halfAxes,t.halfAxes),t):new p(e.center,e.halfAxes):void 0},p.intersectPlane=function(e,t){var r=e.center,a=t.normal,i=e.halfAxes,o=a.x,u=a.y,s=a.z,l=Math.abs(o*i[f.COLUMN0ROW0]+u*i[f.COLUMN0ROW1]+s*i[f.COLUMN0ROW2])+Math.abs(o*i[f.COLUMN1ROW0]+u*i[f.COLUMN1ROW1]+s*i[f.COLUMN1ROW2])+Math.abs(o*i[f.COLUMN2ROW0]+u*i[f.COLUMN2ROW1]+s*i[f.COLUMN2ROW2]),d=n.dot(a,r)+t.distance;return-l>=d?c.OUTSIDE:d>=l?c.INSIDE:c.INTERSECTING};var I=new n,N=new n,b=new n,A=new n;p.distanceSquaredTo=function(e,t){var r=n.subtract(t,e.center,M),a=e.halfAxes,i=f.getColumn(a,0,I),o=f.getColumn(a,1,N),u=f.getColumn(a,2,b),s=n.magnitude(i),c=n.magnitude(o),l=n.magnitude(u);n.normalize(i,i),n.normalize(o,o),n.normalize(u,u);var d=A;d.x=n.dot(r,i),d.y=n.dot(r,o),d.z=n.dot(r,u);var h,m=0;return d.x<-s?(h=d.x+s,m+=h*h):d.x>s&&(h=d.x-s,m+=h*h),d.y<-c?(h=d.y+c,m+=h*h):d.y>c&&(h=d.y-c,m+=h*h),d.z<-l?(h=d.z+l,m+=h*h):d.z>l&&(h=d.z-l,m+=h*h),m};var D=new n,q=new n;new n;p.computePlaneDistances=function(e,t,r,a){i(a)||(a=new l);var o=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,s=e.center,c=e.halfAxes,d=f.getColumn(c,0,I),h=f.getColumn(c,1,N),m=f.getColumn(c,2,b),p=n.add(d,h,D);n.add(p,m,p),n.add(p,s,p);var y=n.subtract(p,t,q),v=n.dot(r,y);return o=Math.min(v,o),u=Math.max(v,u),n.add(s,d,p),n.add(p,h,p),n.subtract(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),n.add(s,d,p),n.subtract(p,h,p),n.add(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),n.add(s,d,p),n.subtract(p,h,p),n.subtract(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),n.subtract(s,d,p),n.add(p,h,p),n.add(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),n.subtract(s,d,p),n.add(p,h,p),n.subtract(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),n.subtract(s,d,p),n.subtract(p,h,p),n.add(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),n.subtract(s,d,p),n.subtract(p,h,p),n.subtract(p,m,p),n.subtract(p,t,y),v=n.dot(r,y),o=Math.min(v,o),u=Math.max(v,u),a.start=o,a.stop=u,a};var U=new e;return p.isOccluded=function(e,t){var r=e.halfAxes,a=f.getColumn(r,0,I),i=f.getColumn(r,1,N),o=f.getColumn(r,2,b),u=n.magnitude(a),s=n.magnitude(i),c=n.magnitude(o),l=U;return l.center=n.clone(e.center,l.center),l.radius=Math.max(u,s,c),!t.isBoundingSphereVisible(l)},p.prototype.intersectPlane=function(e){return p.intersectPlane(this,e)},p.prototype.distanceSquaredTo=function(e){return p.distanceSquaredTo(this,e)},p.prototype.computePlaneDistances=function(e,t,n){return p.computePlaneDistances(this,e,t,n)},p.prototype.isOccluded=function(e){return p.isOccluded(this,e)},p.equals=function(e,t){return e===t||i(e)&&i(t)&&n.equals(e.center,t.center)&&f.equals(e.halfAxes,t.halfAxes)},p.prototype.clone=function(e){return p.clone(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p}),define("Core/formatError",["./defined"],function(e){"use strict";var t=function(t){var n,r=t.name,a=t.message;n=e(r)&&e(a)?r+": "+a:t.toString();var i=t.stack;return e(i)&&(n+="\n"+i),n};return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,n){"use strict";var r=function(r){var a,i=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,i)}catch(c){c instanceof Error?o.error={name:c.name,message:c.message,stack:c.stack}:o.error=c}t(a)||(a=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(i.length=0);try{a(o,i)}catch(c){o.result=void 0,o.error="postMessage failed with error: "+n(c)+"\n  with responseMessage: "+JSON.stringify(o),a(o)}}};return r}),define("Workers/createVerticesFromHeightmap",["../Core/BoundingSphere","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/HeightmapTessellator","../Core/Math","../Core/OrientedBoundingBox","../Core/Rectangle","./createTaskProcessorWorker"],function(e,t,n,r,a,i,o,u){
"use strict";function s(u,s){var c=6,l=u.width,d=u.height;u.skirtHeight>0&&(l+=2,d+=2);var f=new Float32Array(l*d*c);s.push(f.buffer),u.ellipsoid=t.clone(u.ellipsoid),u.rectangle=o.clone(u.rectangle),u.vertices=f;var h,m=r.computeVertices(u),p=e.fromVertices(f,u.relativeToCenter,c);u.rectangle.width<a.PI_OVER_TWO+a.EPSILON5&&(h=i.fromRectangle(u.rectangle,m.minimumHeight,m.maximumHeight,u.ellipsoid));var y=u.ellipsoid,v=new n(y),g=v.computeHorizonCullingPointFromVertices(u.relativeToCenter,f,c,u.relativeToCenter);return{vertices:f.buffer,numberOfAttributes:c,minimumHeight:m.minimumHeight,maximumHeight:m.maximumHeight,gridWidth:l,gridHeight:d,boundingSphere3D:p,orientedBoundingBox:h,occludeePointInScaledSpace:g}}return u(s)})}();