/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var r=Object.freeze;return t(r)||(r=function(t){return t}),r}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var r=function(t,r){return void 0!==t?t:r};return r.EMPTY_OBJECT=t({}),r}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var r=function(t){this.name="DeveloperError",this.message=t;var r;try{throw new Error}catch(e){r=e.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return t(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var e;for(this.mti==this.N+1&&this.init_genrand(5489),e=0;e<this.N-this.M;e++)t=this.mt[e]&this.UPPER_MASK|this.mt[e+1]&this.LOWER_MASK,this.mt[e]=this.mt[e+this.M]^t>>>1^r[1&t];for(;e<this.N-1;e++)t=this.mt[e]&this.UPPER_MASK|this.mt[e+1]&this.LOWER_MASK,this.mt[e]=this.mt[e+(this.M-this.N)]^t>>>1^r[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^r[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=t<<7&2636928640,t^=t<<15&4022730752,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,r,e,n){"use strict";var o={};o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=function(t){return t>0?1:0>t?-1:0},o.signNotZero=function(t){return 0>t?-1:1},o.toSNorm=function(t){return Math.round(255*(.5*o.clamp(t,-1,1)+.5))},o.fromSNorm=function(t){return o.clamp(t,0,255)/255*2-1},o.sinh=function(t){var r=Math.pow(Math.E,t),e=Math.pow(Math.E,-1*t);return.5*(r-e)},o.cosh=function(t){var r=Math.pow(Math.E,t),e=Math.pow(Math.E,-1*t);return.5*(r+e)},o.lerp=function(t,r,e){return(1-e)*t+e*r},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=.5*Math.PI,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI*.5,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(t){return t*o.RADIANS_PER_DEGREE},o.toDegrees=function(t){return t*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(t){var r=o.TWO_PI,e=t-Math.floor(t/r)*r;return e<-Math.PI?e+r:e>=Math.PI?e-r:e},o.negativePiToPi=function(t){return o.zeroToTwoPi(t+o.PI)-o.PI},o.zeroToTwoPi=function(t){var r=o.mod(t,o.TWO_PI);return Math.abs(r)<o.EPSILON14&&Math.abs(t)>o.EPSILON14?o.TWO_PI:r},o.mod=function(t,r){return(t%r+r)%r},o.equalsEpsilon=function(t,e,n,o){o=r(o,n);var i=Math.abs(t-e);return o>=i||i<=n*Math.max(Math.abs(t),Math.abs(e))};var i=[1];o.factorial=function(t){var r=i.length;if(t>=r)for(var e=i[r-1],n=r;t>=n;n++)i.push(e*n);return i[t]},o.incrementWrap=function(t,e,n){return n=r(n,0),++t,t>e&&(t=n),t},o.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},o.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},o.clamp=function(t,r,e){return r>t?r:t>e?e:t};var a=new t;return o.setRandomNumberSeed=function(r){a=new t(r)},o.nextRandomNumber=function(){return a.random()},o.acosClamped=function(t){return Math.acos(o.clamp(t,-1,1))},o.asinClamped=function(t){return Math.asin(o.clamp(t,-1,1))},o.chordLength=function(t,r){return 2*r*Math.sin(.5*t)},o}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i=function(r,e,n){this.x=t(r,0),this.y=t(e,0),this.z=t(n,0)};i.fromSpherical=function(e,n){r(n)||(n=new i);var o=e.clock,a=e.cone,s=t(e.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(t,e,n,o){return r(o)?(o.x=t,o.y=e,o.z=n,o):new i(t,e,n)},i.clone=function(t,e){return r(t)?r(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e):new i(t.x,t.y,t.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(r,e,n){n=t(n,0),e[n++]=r.x,e[n++]=r.y,e[n]=r.z},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n],o},i.fromArray=i.unpack,i.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},i.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},i.minimumByComponent=function(t,r,e){return e.x=Math.min(t.x,r.x),e.y=Math.min(t.y,r.y),e.z=Math.min(t.z,r.z),e},i.maximumByComponent=function(t,r,e){return e.x=Math.max(t.x,r.x),e.y=Math.max(t.y,r.y),e.z=Math.max(t.z,r.z),e},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,r){return i.subtract(t,r,a),i.magnitude(a)},i.distanceSquared=function(t,r){return i.subtract(t,r,a),i.magnitudeSquared(a)},i.normalize=function(t,r){var e=i.magnitude(t);return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r},i.dot=function(t,r){return t.x*r.x+t.y*r.y+t.z*r.z},i.multiplyComponents=function(t,r,e){return e.x=t.x*r.x,e.y=t.y*r.y,e.z=t.z*r.z,e},i.add=function(t,r,e){return e.x=t.x+r.x,e.y=t.y+r.y,e.z=t.z+r.z,e},i.subtract=function(t,r,e){return e.x=t.x-r.x,e.y=t.y-r.y,e.z=t.z-r.z,e},i.multiplyByScalar=function(t,r,e){return e.x=t.x*r,e.y=t.y*r,e.z=t.z*r,e},i.divideByScalar=function(t,r,e){return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e},i.negate=function(t,r){return r.x=-t.x,r.y=-t.y,r.z=-t.z,r},i.abs=function(t,r){return r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new i;i.lerp=function(t,r,e,n){return i.multiplyByScalar(r,e,s),n=i.multiplyByScalar(t,1-e,n),i.add(s,n,n)};var u=new i,E=new i;i.angleBetween=function(t,r){i.normalize(t,u),i.normalize(r,E);var e=i.dot(u,E),n=i.magnitude(i.cross(u,E,u));return Math.atan2(n,e)};var l=new i;i.mostOrthogonalAxis=function(t,r){var e=i.normalize(t,l);return i.abs(e,e),r=e.x<=e.y?e.x<=e.z?i.clone(i.UNIT_X,r):i.clone(i.UNIT_Z,r):e.y<=e.z?i.clone(i.UNIT_Y,r):i.clone(i.UNIT_Z,r)},i.equals=function(t,e){return t===e||r(t)&&r(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z},i.equalsArray=function(t,r,e){return t.x===r[e]&&t.y===r[e+1]&&t.z===r[e+2]},i.equalsEpsilon=function(t,e,n,i){return t===e||r(t)&&r(e)&&o.equalsEpsilon(t.x,e.x,n,i)&&o.equalsEpsilon(t.y,e.y,n,i)&&o.equalsEpsilon(t.z,e.z,n,i)},i.cross=function(t,r,e){var n=t.x,o=t.y,i=t.z,a=r.x,s=r.y,u=r.z,E=o*u-i*s,l=i*a-n*u,c=n*s-o*a;return e.x=E,e.y=l,e.z=c,e},i.fromDegrees=function(t,r,e,n,a){var s=o.toRadians(t),u=o.toRadians(r);return i.fromRadians(s,u,e,n,a)};var c=new i,R=new i,_=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(e,n,o,a,s){o=t(o,0);var u=r(a)?a.radiiSquared:_,E=Math.cos(n);c.x=E*Math.cos(e),c.y=E*Math.sin(e),c.z=Math.sin(n),c=i.normalize(c,c),i.multiplyComponents(u,c,R);var l=Math.sqrt(i.dot(c,R));return R=i.divideByScalar(R,l,R),c=i.multiplyByScalar(c,o,c),r(s)||(s=new i),i.add(R,c,s)},i.fromDegreesArray=function(t,r,e){for(var n=new Array(t.length),a=0;a<t.length;a++)n[a]=o.toRadians(t[a]);return i.fromRadiansArray(n,r,e)},i.fromRadiansArray=function(t,e,n){var o=t.length;r(n)?n.length=o/2:n=new Array(o/2);for(var a=0;o>a;a+=2){var s=t[a],u=t[a+1];n[a/2]=i.fromRadians(s,u,0,e,n[a/2])}return n},i.fromDegreesArrayHeights=function(t,r,e){for(var n=new Array(t.length),a=0;a<t.length;a+=3)n[a]=o.toRadians(t[a]),n[a+1]=o.toRadians(t[a+1]),n[a+2]=t[a+2];return i.fromRadiansArrayHeights(n,r,e)},i.fromRadiansArrayHeights=function(t,e,n){var o=t.length;r(n)?n.length=o/3:n=new Array(o/3);for(var a=0;o>a;a+=3){var s=t[a],u=t[a+1],E=t[a+2];n[a/3]=i.fromRadians(s,u,E,e,n[a/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,r,e){return i.equalsEpsilon(this,t,r,e)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i=function(r,e,n){this.longitude=t(r,0),this.latitude=t(e,0),this.height=t(n,0)};return i.fromRadians=function(e,n,o,a){return o=t(o,0),r(a)?(a.longitude=e,a.latitude=n,a.height=o,a):new i(e,n,o)},i.fromDegrees=function(t,r,e,n){return t=o.toRadians(t),r=o.toRadians(r),i.fromRadians(t,r,e,n)},i.clone=function(t,e){return r(t)?r(e)?(e.longitude=t.longitude,e.latitude=t.latitude,e.height=t.height,e):new i(t.longitude,t.latitude,t.height):void 0},i.equals=function(t,e){return t===e||r(t)&&r(e)&&t.longitude===e.longitude&&t.latitude===e.latitude&&t.height===e.height},i.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t.longitude-e.longitude)<=n&&Math.abs(t.latitude-e.latitude)<=n&&Math.abs(t.height-e.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,r){return i.equalsEpsilon(this,t,r)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(t){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),e=Object.defineProperties;return r&&t(e)||(e=function(t){return t}),e}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o,i,a,s){"use strict";function u(r,n,o,i){n=e(n,0),o=e(o,0),i=e(i,0),r._radii=new t(n,o,i),r._radiiSquared=new t(n*n,o*o,i*i),r._radiiToTheFourth=new t(n*n*n*n,o*o*o*o,i*i*i*i),r._oneOverRadii=new t(0===n?0:1/n,0===o?0:1/o,0===i?0:1/i),r._oneOverRadiiSquared=new t(0===n?0:1/(n*n),0===o?0:1/(o*o),0===i?0:1/(i*i)),r._minimumRadius=Math.min(n,o,i),r._maximumRadius=Math.max(n,o,i),r._centerToleranceSquared=s.EPSILON1}var E=function(t,r,e){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,t,r,e)};o(E.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),E.clone=function(r,e){if(!n(r))return void 0;var o=r._radii;return n(e)?(t.clone(o,e._radii),t.clone(r._radiiSquared,e._radiiSquared),t.clone(r._radiiToTheFourth,e._radiiToTheFourth),t.clone(r._oneOverRadii,e._oneOverRadii),t.clone(r._oneOverRadiiSquared,e._oneOverRadiiSquared),e._minimumRadius=r._minimumRadius,e._maximumRadius=r._maximumRadius,e._centerToleranceSquared=r._centerToleranceSquared,e):new E(o.x,o.y,o.z)},E.fromCartesian3=function(t,r){return n(r)||(r=new E),n(t)?(u(r,t.x,t.y,t.z),r):r},E.WGS84=a(new E(6378137,6378137,6356752.314245179)),E.UNIT_SPHERE=a(new E(1,1,1)),E.MOON=a(new E(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),E.prototype.clone=function(t){return E.clone(this,t)},E.packedLength=t.packedLength,E.pack=function(r,n,o){o=e(o,0),t.pack(r._radii,n,o)},E.unpack=function(r,n,o){n=e(n,0);var i=t.unpack(r,n);return E.fromCartesian3(i,o)},E.prototype.geocentricSurfaceNormal=t.normalize,E.prototype.geodeticSurfaceNormalCartographic=function(r,e){var o=r.longitude,i=r.latitude,a=Math.cos(i),s=a*Math.cos(o),u=a*Math.sin(o),E=Math.sin(i);return n(e)||(e=new t),e.x=s,e.y=u,e.z=E,t.normalize(e,e)},E.prototype.geodeticSurfaceNormal=function(r,e){return n(e)||(e=new t),e=t.multiplyComponents(r,this._oneOverRadiiSquared,e),t.normalize(e,e)};var l=new t,c=new t;E.prototype.cartographicToCartesian=function(r,e){var o=l,i=c;this.geodeticSurfaceNormalCartographic(r,o),t.multiplyComponents(this._radiiSquared,o,i);var a=Math.sqrt(t.dot(o,i));return t.divideByScalar(i,a,i),t.multiplyByScalar(o,r.height,o),n(e)||(e=new t),t.add(i,o,e)},E.prototype.cartographicArrayToCartesianArray=function(t,r){var e=t.length;n(r)?r.length=e:r=new Array(e);for(var o=0;e>o;o++)r[o]=this.cartographicToCartesian(t[o],r[o]);return r};var R=new t,_=new t,f=new t;E.prototype.cartesianToCartographic=function(e,o){var i=this.scaleToGeodeticSurface(e,_);if(!n(i))return void 0;var a=this.geodeticSurfaceNormal(i,R),u=t.subtract(e,i,f),E=Math.atan2(a.y,a.x),l=Math.asin(a.z),c=s.sign(t.dot(u,e))*t.magnitude(u);return n(o)?(o.longitude=E,o.latitude=l,o.height=c,o):new r(E,l,c)},E.prototype.cartesianArrayToCartographicArray=function(t,r){var e=t.length;n(r)?r.length=e:r=new Array(e);for(var o=0;e>o;++o)r[o]=this.cartesianToCartographic(t[o],r[o]);return r};var T=new t,A=new t;return E.prototype.scaleToGeodeticSurface=function(r,e){var o=r.x,i=r.y,a=r.z,u=this._oneOverRadii,E=u.x,l=u.y,c=u.z,R=o*o*E*E,_=i*i*l*l,f=a*a*c*c,h=R+_+f,S=Math.sqrt(1/h),d=t.multiplyByScalar(r,S,T);if(h<this._centerToleranceSquared)return isFinite(S)?t.clone(d,e):void 0;var C=this._oneOverRadiiSquared,N=C.x,m=C.y,I=C.z,M=A;M.x=d.x*N*2,M.y=d.y*m*2,M.z=d.z*I*2;var O,p,g,y,F,L,v,U,D,P,B,w=(1-S)*t.magnitude(r)/(.5*t.magnitude(M)),x=0;do{w-=x,g=1/(1+w*N),y=1/(1+w*m),F=1/(1+w*I),L=g*g,v=y*y,U=F*F,D=L*g,P=v*y,B=U*F,O=R*L+_*v+f*U-1,p=R*D*N+_*P*m+f*B*I;var G=-2*p;x=O/G}while(Math.abs(O)>s.EPSILON12);return n(e)?(e.x=o*g,e.y=i*y,e.z=a*F,e):new t(o*g,i*y,a*F)},E.prototype.scaleToGeocentricSurface=function(r,e){n(e)||(e=new t);var o=r.x,i=r.y,a=r.z,s=this._oneOverRadiiSquared,u=1/Math.sqrt(o*o*s.x+i*i*s.y+a*a*s.z);return t.multiplyByScalar(r,u,e)},E.prototype.transformPositionToScaledSpace=function(r,e){return n(e)||(e=new t),t.multiplyComponents(r,this._oneOverRadii,e)},E.prototype.transformPositionFromScaledSpace=function(r,e){return n(e)||(e=new t),t.multiplyComponents(r,this._radii,e)},E.prototype.equals=function(r){return this===r||n(r)&&t.equals(this._radii,r._radii)},E.prototype.toString=function(){return this._radii.toString()},E}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(t,r){"use strict";var e={},n=function(r,n){t(e[r])||(e[r]=!0,console.log(n))};return n}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,r,e,n,o,i,a){"use strict";var s=function(t){this._ellipsoid=e(t,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,e){var o=this._semimajorAxis,i=r.longitude*o,a=r.latitude*o,s=r.height;return n(e)?(e.x=i,e.y=a,e.z=s,e):new t(i,a,s)},s.prototype.unproject=function(t,e){var o=this._oneOverSemimajorAxis,i=t.x*o,a=t.y*o,s=t.z;return n(e)?(e.longitude=i,e.latitude=a,e.height=s,e):new r(i,a,s)},s}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return t(r)}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var r=function(r,e){this.start=t(r,0),this.stop=t(e,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i=function(r,e,n,o){this.x=t(r,0),this.y=t(e,0),this.z=t(n,0),this.w=t(o,0)};i.fromElements=function(t,e,n,o,a){return r(a)?(a.x=t,a.y=e,a.z=n,a.w=o,a):new i(t,e,n,o)},i.fromColor=function(t,e){return r(e)?(e.x=t.red,e.y=t.green,e.z=t.blue,e.w=t.alpha,e):new i(t.red,t.green,t.blue,t.alpha)},i.clone=function(t,e){return r(t)?r(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e):new i(t.x,t.y,t.z,t.w):void 0},i.packedLength=4,i.pack=function(r,e,n){n=t(n,0),e[n++]=r.x,e[n++]=r.y,e[n++]=r.z,e[n]=r.w},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n++],o.w=e[n],o},i.fromArray=i.unpack,i.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},i.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},i.minimumByComponent=function(t,r,e){return e.x=Math.min(t.x,r.x),e.y=Math.min(t.y,r.y),e.z=Math.min(t.z,r.z),e.w=Math.min(t.w,r.w),e},i.maximumByComponent=function(t,r,e){return e.x=Math.max(t.x,r.x),e.y=Math.max(t.y,r.y),e.z=Math.max(t.z,r.z),e.w=Math.max(t.w,r.w),e},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,r){return i.subtract(t,r,a),i.magnitude(a)},i.distanceSquared=function(t,r){return i.subtract(t,r,a),i.magnitudeSquared(a)},i.normalize=function(t,r){var e=i.magnitude(t);return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r.w=t.w/e,r},i.dot=function(t,r){return t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},i.multiplyComponents=function(t,r,e){return e.x=t.x*r.x,e.y=t.y*r.y,e.z=t.z*r.z,e.w=t.w*r.w,e},i.add=function(t,r,e){return e.x=t.x+r.x,e.y=t.y+r.y,e.z=t.z+r.z,e.w=t.w+r.w,e},i.subtract=function(t,r,e){return e.x=t.x-r.x,e.y=t.y-r.y,e.z=t.z-r.z,e.w=t.w-r.w,e},i.multiplyByScalar=function(t,r,e){return e.x=t.x*r,e.y=t.y*r,e.z=t.z*r,e.w=t.w*r,e},i.divideByScalar=function(t,r,e){return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e.w=t.w/r,e},i.negate=function(t,r){return r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},i.abs=function(t,r){return r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new i;i.lerp=function(t,r,e,n){return i.multiplyByScalar(r,e,s),n=i.multiplyByScalar(t,1-e,n),i.add(s,n,n)};var u=new i;return i.mostOrthogonalAxis=function(t,r){var e=i.normalize(t,u);return i.abs(e,e),r=e.x<=e.y?e.x<=e.z?e.x<=e.w?i.clone(i.UNIT_X,r):i.clone(i.UNIT_W,r):e.z<=e.w?i.clone(i.UNIT_Z,r):i.clone(i.UNIT_W,r):e.y<=e.z?e.y<=e.w?i.clone(i.UNIT_Y,r):i.clone(i.UNIT_W,r):e.z<=e.w?i.clone(i.UNIT_Z,r):i.clone(i.UNIT_W,r)},i.equals=function(t,e){return t===e||r(t)&&r(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},i.equalsArray=function(t,r,e){return t.x===r[e]&&t.y===r[e+1]&&t.z===r[e+2]&&t.w===r[e+3]},i.equalsEpsilon=function(t,e,n,i){return t===e||r(t)&&r(e)&&o.equalsEpsilon(t.x,e.x,n,i)&&o.equalsEpsilon(t.y,e.y,n,i)&&o.equalsEpsilon(t.z,e.z,n,i)&&o.equalsEpsilon(t.w,e.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,r,e){return i.equalsEpsilon(this,t,r,e)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o,i){"use strict";function a(t){for(var r=0,e=0;9>e;++e){var n=t[e];r+=n*n}return Math.sqrt(r)}function s(t){for(var r=0,e=0;3>e;++e){var n=t[E.getElementIndex(_[e],R[e])];r+=2*n*n}return Math.sqrt(r)}function u(t,r){for(var e=i.EPSILON15,n=0,o=1,a=0;3>a;++a){var s=Math.abs(t[E.getElementIndex(_[a],R[a])]);s>n&&(o=a,n=s)}var u=1,l=0,c=R[o],f=_[o];if(Math.abs(t[E.getElementIndex(f,c)])>e){var T,A=t[E.getElementIndex(f,f)],h=t[E.getElementIndex(c,c)],S=t[E.getElementIndex(f,c)],d=(A-h)/2/S;T=0>d?-1/(-d+Math.sqrt(1+d*d)):1/(d+Math.sqrt(1+d*d)),u=1/Math.sqrt(1+T*T),l=T*u}return r=E.clone(E.IDENTITY,r),r[E.getElementIndex(c,c)]=r[E.getElementIndex(f,f)]=u,r[E.getElementIndex(f,c)]=l,r[E.getElementIndex(c,f)]=-l,r}var E=function(t,e,n,o,i,a,s,u,E){this[0]=r(t,0),this[1]=r(o,0),this[2]=r(s,0),this[3]=r(e,0),this[4]=r(i,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(E,0)};E.packedLength=9,E.pack=function(t,e,n){n=r(n,0),e[n++]=t[0],e[n++]=t[1],e[n++]=t[2],e[n++]=t[3],e[n++]=t[4],e[n++]=t[5],e[n++]=t[6],e[n++]=t[7],e[n++]=t[8]},E.unpack=function(t,n,o){return n=r(n,0),e(o)||(o=new E),o[0]=t[n++],o[1]=t[n++],o[2]=t[n++],o[3]=t[n++],o[4]=t[n++],o[5]=t[n++],o[6]=t[n++],o[7]=t[n++],o[8]=t[n++],o},E.clone=function(t,r){return e(t)?e(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r):new E(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},E.fromArray=function(t,n,o){return n=r(n,0),e(o)||(o=new E),o[0]=t[n],o[1]=t[n+1],o[2]=t[n+2],o[3]=t[n+3],o[4]=t[n+4],o[5]=t[n+5],o[6]=t[n+6],o[7]=t[n+7],o[8]=t[n+8],o},E.fromColumnMajorArray=function(t,r){return E.clone(t,r)},E.fromRowMajorArray=function(t,r){return e(r)?(r[0]=t[0],r[1]=t[3],r[2]=t[6],r[3]=t[1],r[4]=t[4],r[5]=t[7],r[6]=t[2],r[7]=t[5],r[8]=t[8],r):new E(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},E.fromQuaternion=function(t,r){var n=t.x*t.x,o=t.x*t.y,i=t.x*t.z,a=t.x*t.w,s=t.y*t.y,u=t.y*t.z,l=t.y*t.w,c=t.z*t.z,R=t.z*t.w,_=t.w*t.w,f=n-s-c+_,T=2*(o-R),A=2*(i+l),h=2*(o+R),S=-n+s-c+_,d=2*(u-a),C=2*(i-l),N=2*(u+a),m=-n-s+c+_;return e(r)?(r[0]=f,r[1]=h,r[2]=C,r[3]=T,r[4]=S,r[5]=N,r[6]=A,r[7]=d,r[8]=m,r):new E(f,T,A,h,S,d,C,N,m)},E.fromScale=function(t,r){return e(r)?(r[0]=t.x,r[1]=0,r[2]=0,r[3]=0,r[4]=t.y,r[5]=0,r[6]=0,r[7]=0,r[8]=t.z,r):new E(t.x,0,0,0,t.y,0,0,0,t.z)},E.fromUniformScale=function(t,r){return e(r)?(r[0]=t,r[1]=0,r[2]=0,r[3]=0,r[4]=t,r[5]=0,r[6]=0,r[7]=0,r[8]=t,r):new E(t,0,0,0,t,0,0,0,t)},E.fromCrossProduct=function(t,r){return e(r)?(r[0]=0,r[1]=t.z,r[2]=-t.y,r[3]=-t.z,r[4]=0,r[5]=t.x,r[6]=t.y,r[7]=-t.x,r[8]=0,r):new E(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},E.fromRotationX=function(t,r){var n=Math.cos(t),o=Math.sin(t);return e(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new E(1,0,0,0,n,-o,0,o,n)},E.fromRotationY=function(t,r){var n=Math.cos(t),o=Math.sin(t);return e(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new E(n,0,o,0,1,0,-o,0,n)},E.fromRotationZ=function(t,r){var n=Math.cos(t),o=Math.sin(t);return e(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new E(n,-o,0,o,n,0,0,0,1)},E.toArray=function(t,r){return e(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},E.getElementIndex=function(t,r){return 3*t+r},E.getColumn=function(t,r,e){var n=3*r,o=t[n],i=t[n+1],a=t[n+2];return e.x=o,e.y=i,e.z=a,e},E.setColumn=function(t,r,e,n){n=E.clone(t,n);var o=3*r;return n[o]=e.x,n[o+1]=e.y,n[o+2]=e.z,n},E.getRow=function(t,r,e){var n=t[r],o=t[r+3],i=t[r+6];return e.x=n,e.y=o,e.z=i,e},E.setRow=function(t,r,e,n){return n=E.clone(t,n),n[r]=e.x,n[r+3]=e.y,n[r+6]=e.z,n};var l=new t;E.getScale=function(r,e){return e.x=t.magnitude(t.fromElements(r[0],r[1],r[2],l)),e.y=t.magnitude(t.fromElements(r[3],r[4],r[5],l)),e.z=t.magnitude(t.fromElements(r[6],r[7],r[8],l)),e};var c=new t;E.getMaximumScale=function(r){return E.getScale(r,c),t.maximumComponent(c)},E.multiply=function(t,r,e){var n=t[0]*r[0]+t[3]*r[1]+t[6]*r[2],o=t[1]*r[0]+t[4]*r[1]+t[7]*r[2],i=t[2]*r[0]+t[5]*r[1]+t[8]*r[2],a=t[0]*r[3]+t[3]*r[4]+t[6]*r[5],s=t[1]*r[3]+t[4]*r[4]+t[7]*r[5],u=t[2]*r[3]+t[5]*r[4]+t[8]*r[5],E=t[0]*r[6]+t[3]*r[7]+t[6]*r[8],l=t[1]*r[6]+t[4]*r[7]+t[7]*r[8],c=t[2]*r[6]+t[5]*r[7]+t[8]*r[8];return e[0]=n,e[1]=o,e[2]=i,e[3]=a,e[4]=s,e[5]=u,e[6]=E,e[7]=l,e[8]=c,e},E.add=function(t,r,e){return e[0]=t[0]+r[0],e[1]=t[1]+r[1],e[2]=t[2]+r[2],e[3]=t[3]+r[3],e[4]=t[4]+r[4],e[5]=t[5]+r[5],e[6]=t[6]+r[6],e[7]=t[7]+r[7],e[8]=t[8]+r[8],e},E.subtract=function(t,r,e){return e[0]=t[0]-r[0],e[1]=t[1]-r[1],e[2]=t[2]-r[2],e[3]=t[3]-r[3],e[4]=t[4]-r[4],e[5]=t[5]-r[5],e[6]=t[6]-r[6],e[7]=t[7]-r[7],e[8]=t[8]-r[8],e},E.multiplyByVector=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=t[0]*n+t[3]*o+t[6]*i,s=t[1]*n+t[4]*o+t[7]*i,u=t[2]*n+t[5]*o+t[8]*i;return e.x=a,e.y=s,e.z=u,e},E.multiplyByScalar=function(t,r,e){return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*r,e[5]=t[5]*r,e[6]=t[6]*r,e[7]=t[7]*r,e[8]=t[8]*r,e},E.multiplyByScale=function(t,r,e){return e[0]=t[0]*r.x,e[1]=t[1]*r.x,e[2]=t[2]*r.x,e[3]=t[3]*r.y,e[4]=t[4]*r.y,e[5]=t[5]*r.y,e[6]=t[6]*r.z,e[7]=t[7]*r.z,e[8]=t[8]*r.z,e},E.negate=function(t,r){return r[0]=-t[0],r[1]=-t[1],r[2]=-t[2],r[3]=-t[3],r[4]=-t[4],r[5]=-t[5],r[6]=-t[6],r[7]=-t[7],r[8]=-t[8],r},E.transpose=function(t,r){var e=t[0],n=t[3],o=t[6],i=t[1],a=t[4],s=t[7],u=t[2],E=t[5],l=t[8];return r[0]=e,r[1]=n,r[2]=o,r[3]=i,r[4]=a,r[5]=s,r[6]=u,r[7]=E,r[8]=l,r};var R=[1,0,0],_=[2,2,1],f=new E,T=new E;return E.computeEigenDecomposition=function(t,r){var n=i.EPSILON20,o=10,l=0,c=0;e(r)||(r={});for(var R=r.unitary=E.clone(E.IDENTITY,r.unitary),_=r.diagonal=E.clone(t,r.diagonal),A=n*a(_);o>c&&s(_)>A;)u(_,f),E.transpose(f,T),E.multiply(_,f,_),E.multiply(T,_,_),E.multiply(R,f,R),++l>2&&(++c,l=0);return r},E.abs=function(t,r){return r[0]=Math.abs(t[0]),r[1]=Math.abs(t[1]),r[2]=Math.abs(t[2]),r[3]=Math.abs(t[3]),r[4]=Math.abs(t[4]),r[5]=Math.abs(t[5]),r[6]=Math.abs(t[6]),r[7]=Math.abs(t[7]),r[8]=Math.abs(t[8]),r},E.determinant=function(t){var r=t[0],e=t[3],n=t[6],o=t[1],i=t[4],a=t[7],s=t[2],u=t[5],E=t[8];return r*(i*E-u*a)+o*(u*n-e*E)+s*(e*a-i*n)},E.inverse=function(t,r){var e=t[0],o=t[1],a=t[2],s=t[3],u=t[4],l=t[5],c=t[6],R=t[7],_=t[8],f=E.determinant(t);if(Math.abs(f)<=i.EPSILON15)throw new n("matrix is not invertible");r[0]=u*_-R*l,r[1]=R*a-o*_,r[2]=o*l-u*a,r[3]=c*l-s*_,r[4]=e*_-c*a,r[5]=s*a-e*l,r[6]=s*R-c*u,r[7]=c*o-e*R,r[8]=e*u-s*o;var T=1/f;return E.multiplyByScalar(r,T,r)},E.equals=function(t,r){return t===r||e(t)&&e(r)&&t[0]===r[0]&&t[1]===r[1]&&t[2]===r[2]&&t[3]===r[3]&&t[4]===r[4]&&t[5]===r[5]&&t[6]===r[6]&&t[7]===r[7]&&t[8]===r[8]},E.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t[0]-r[0])<=n&&Math.abs(t[1]-r[1])<=n&&Math.abs(t[2]-r[2])<=n&&Math.abs(t[3]-r[3])<=n&&Math.abs(t[4]-r[4])<=n&&Math.abs(t[5]-r[5])<=n&&Math.abs(t[6]-r[6])<=n&&Math.abs(t[7]-r[7])<=n&&Math.abs(t[8]-r[8])<=n},E.IDENTITY=o(new E(1,0,0,0,1,0,0,0,1)),E.ZERO=o(new E(0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN1ROW0=3,E.COLUMN1ROW1=4,E.COLUMN1ROW2=5,E.COLUMN2ROW0=6,E.COLUMN2ROW1=7,E.COLUMN2ROW2=8,E.prototype.clone=function(t){return E.clone(this,t)},E.prototype.equals=function(t){return E.equals(this,t)},E.equalsArray=function(t,r,e){return t[0]===r[e]&&t[1]===r[e+1]&&t[2]===r[e+2]&&t[3]===r[e+3]&&t[4]===r[e+4]&&t[5]===r[e+5]&&t[6]===r[e+6]&&t[7]===r[e+7]&&t[8]===r[e+8]},E.prototype.equalsEpsilon=function(t,r){return E.equalsEpsilon(this,t,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},E}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var r=function(t){this.name="RuntimeError",this.message=t;var r;try{throw new Error}catch(e){r=e.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return t(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,r,e,n,o,i,a,s,u){"use strict";var E=function(t,r,n,o,i,a,s,u,E,l,c,R,_,f,T,A){this[0]=e(t,0),this[1]=e(i,0),this[2]=e(E,0),this[3]=e(_,0),this[4]=e(r,0),this[5]=e(a,0),this[6]=e(l,0),this[7]=e(f,0),this[8]=e(n,0),this[9]=e(s,0),this[10]=e(c,0),this[11]=e(T,0),this[12]=e(o,0),this[13]=e(u,0),this[14]=e(R,0),this[15]=e(A,0)};E.packedLength=16,E.pack=function(t,r,n){n=e(n,0),r[n++]=t[0],r[n++]=t[1],r[n++]=t[2],r[n++]=t[3],r[n++]=t[4],r[n++]=t[5],r[n++]=t[6],r[n++]=t[7],r[n++]=t[8],r[n++]=t[9],r[n++]=t[10],r[n++]=t[11],r[n++]=t[12],r[n++]=t[13],r[n++]=t[14],r[n]=t[15]},E.unpack=function(t,r,o){return r=e(r,0),n(o)||(o=new E),o[0]=t[r++],o[1]=t[r++],o[2]=t[r++],o[3]=t[r++],o[4]=t[r++],o[5]=t[r++],o[6]=t[r++],o[7]=t[r++],o[8]=t[r++],o[9]=t[r++],o[10]=t[r++],o[11]=t[r++],o[12]=t[r++],o[13]=t[r++],o[14]=t[r++],o[15]=t[r],o},E.clone=function(t,r){return n(t)?n(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r):new E(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},E.fromArray=E.unpack,E.fromColumnMajorArray=function(t,r){return E.clone(t,r)},E.fromRowMajorArray=function(t,r){return n(r)?(r[0]=t[0],r[1]=t[4],r[2]=t[8],r[3]=t[12],r[4]=t[1],r[5]=t[5],r[6]=t[9],r[7]=t[13],r[8]=t[2],r[9]=t[6],r[10]=t[10],r[11]=t[14],r[12]=t[3],r[13]=t[7],r[14]=t[11],r[15]=t[15],r):new E(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},E.fromRotationTranslation=function(r,o,i){return o=e(o,t.ZERO),n(i)?(i[0]=r[0],i[1]=r[1],i[2]=r[2],i[3]=0,i[4]=r[3],i[5]=r[4],i[6]=r[5],i[7]=0,i[8]=r[6],i[9]=r[7],i[10]=r[8],i[11]=0,i[12]=o.x,i[13]=o.y,i[14]=o.z,i[15]=1,i):new E(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(t,r,e,o){n(o)||(o=new E);var i=e.x,a=e.y,s=e.z,u=r.x*r.x,l=r.x*r.y,c=r.x*r.z,R=r.x*r.w,_=r.y*r.y,f=r.y*r.z,T=r.y*r.w,A=r.z*r.z,h=r.z*r.w,S=r.w*r.w,d=u-_-A+S,C=2*(l-h),N=2*(c+T),m=2*(l+h),I=-u+_-A+S,M=2*(f-R),O=2*(c-T),p=2*(f+R),g=-u-_+A+S;return o[0]=d*i,o[1]=m*i,o[2]=O*i,o[3]=0,o[4]=C*a,o[5]=I*a,o[6]=p*a,o[7]=0,o[8]=N*s,o[9]=M*s,o[10]=g*s,o[11]=0,o[12]=t.x,o[13]=t.y,o[14]=t.z,o[15]=1,o},E.fromTranslation=function(t,r){return E.fromRotationTranslation(s.IDENTITY,t,r)},E.fromScale=function(t,r){return n(r)?(r[0]=t.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=t.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=t.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},E.fromUniformScale=function(t,r){return n(r)?(r[0]=t,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=t,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=t,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var l=new t,c=new t,R=new t;E.fromCamera=function(r,e){var o=r.eye,i=r.target,a=r.up;t.normalize(t.subtract(i,o,l),l),t.normalize(t.cross(l,a,c),c),t.normalize(t.cross(c,l,R),R);var s=c.x,u=c.y,_=c.z,f=l.x,T=l.y,A=l.z,h=R.x,S=R.y,d=R.z,C=o.x,N=o.y,m=o.z,I=s*-C+u*-N+_*-m,M=h*-C+S*-N+d*-m,O=f*C+T*N+A*m;return n(e)?(e[0]=s,e[1]=h,e[2]=-f,e[3]=0,e[4]=u,e[5]=S,e[6]=-T,e[7]=0,e[8]=_,e[9]=d,e[10]=-A,e[11]=0,e[12]=I,e[13]=M,e[14]=O,e[15]=1,e):new E(s,u,_,I,h,S,d,M,-f,-T,-A,O,0,0,0,1)},E.computePerspectiveFieldOfView=function(t,r,e,n,o){var i=Math.tan(.5*t),a=1/i,s=a/r,u=(n+e)/(e-n),E=2*n*e/(e-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=u,o[11]=-1,o[12]=0,o[13]=0,o[14]=E,o[15]=0,o},E.computeOrthographicOffCenter=function(t,r,e,n,o,i,a){var s=1/(r-t),u=1/(n-e),E=1/(i-o),l=-(r+t)*s,c=-(n+e)*u,R=-(i+o)*E;return s*=2,u*=2,E*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=l,a[13]=c,a[14]=R,a[15]=1,
a},E.computePerspectiveOffCenter=function(t,r,e,n,o,i,a){var s=2*o/(r-t),u=2*o/(n-e),E=(r+t)/(r-t),l=(n+e)/(n-e),c=-(i+o)/(i-o),R=-1,_=-2*i*o/(i-o);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=E,a[9]=l,a[10]=c,a[11]=R,a[12]=0,a[13]=0,a[14]=_,a[15]=0,a},E.computeInfinitePerspectiveOffCenter=function(t,r,e,n,o,i){var a=2*o/(r-t),s=2*o/(n-e),u=(r+t)/(r-t),E=(n+e)/(n-e),l=-1,c=-1,R=-2*o;return i[0]=a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=u,i[9]=E,i[10]=l,i[11]=c,i[12]=0,i[13]=0,i[14]=R,i[15]=0,i},E.computeViewportTransformation=function(t,r,n,o){t=e(t,e.EMPTY_OBJECT);var i=e(t.x,0),a=e(t.y,0),s=e(t.width,0),u=e(t.height,0);r=e(r,0),n=e(n,1);var E=.5*s,l=.5*u,c=.5*(n-r),R=E,_=l,f=c,T=i+E,A=a+l,h=r+c,S=1;return o[0]=R,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=_,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=f,o[11]=0,o[12]=T,o[13]=A,o[14]=h,o[15]=S,o},E.toArray=function(t,r){return n(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},E.getElementIndex=function(t,r){return 4*t+r},E.getColumn=function(t,r,e){var n=4*r,o=t[n],i=t[n+1],a=t[n+2],s=t[n+3];return e.x=o,e.y=i,e.z=a,e.w=s,e},E.setColumn=function(t,r,e,n){n=E.clone(t,n);var o=4*r;return n[o]=e.x,n[o+1]=e.y,n[o+2]=e.z,n[o+3]=e.w,n},E.setTranslation=function(t,r,e){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=r.x,e[13]=r.y,e[14]=r.z,e[15]=t[15],e},E.getRow=function(t,r,e){var n=t[r],o=t[r+4],i=t[r+8],a=t[r+12];return e.x=n,e.y=o,e.z=i,e.w=a,e},E.setRow=function(t,r,e,n){return n=E.clone(t,n),n[r]=e.x,n[r+4]=e.y,n[r+8]=e.z,n[r+12]=e.w,n};var _=new t;E.getScale=function(r,e){return e.x=t.magnitude(t.fromElements(r[0],r[1],r[2],_)),e.y=t.magnitude(t.fromElements(r[4],r[5],r[6],_)),e.z=t.magnitude(t.fromElements(r[8],r[9],r[10],_)),e};var f=new t;E.getMaximumScale=function(r){return E.getScale(r,f),t.maximumComponent(f)},E.multiply=function(t,r,e){var n=t[0],o=t[1],i=t[2],a=t[3],s=t[4],u=t[5],E=t[6],l=t[7],c=t[8],R=t[9],_=t[10],f=t[11],T=t[12],A=t[13],h=t[14],S=t[15],d=r[0],C=r[1],N=r[2],m=r[3],I=r[4],M=r[5],O=r[6],p=r[7],g=r[8],y=r[9],F=r[10],L=r[11],v=r[12],U=r[13],D=r[14],P=r[15],B=n*d+s*C+c*N+T*m,w=o*d+u*C+R*N+A*m,x=i*d+E*C+_*N+h*m,G=a*d+l*C+f*N+S*m,b=n*I+s*M+c*O+T*p,z=o*I+u*M+R*O+A*p,H=i*I+E*M+_*O+h*p,V=a*I+l*M+f*O+S*p,X=n*g+s*y+c*F+T*L,W=o*g+u*y+R*F+A*L,q=i*g+E*y+_*F+h*L,Y=a*g+l*y+f*F+S*L,K=n*v+s*U+c*D+T*P,k=o*v+u*U+R*D+A*P,Z=i*v+E*U+_*D+h*P,j=a*v+l*U+f*D+S*P;return e[0]=B,e[1]=w,e[2]=x,e[3]=G,e[4]=b,e[5]=z,e[6]=H,e[7]=V,e[8]=X,e[9]=W,e[10]=q,e[11]=Y,e[12]=K,e[13]=k,e[14]=Z,e[15]=j,e},E.add=function(t,r,e){return e[0]=t[0]+r[0],e[1]=t[1]+r[1],e[2]=t[2]+r[2],e[3]=t[3]+r[3],e[4]=t[4]+r[4],e[5]=t[5]+r[5],e[6]=t[6]+r[6],e[7]=t[7]+r[7],e[8]=t[8]+r[8],e[9]=t[9]+r[9],e[10]=t[10]+r[10],e[11]=t[11]+r[11],e[12]=t[12]+r[12],e[13]=t[13]+r[13],e[14]=t[14]+r[14],e[15]=t[15]+r[15],e},E.subtract=function(t,r,e){return e[0]=t[0]-r[0],e[1]=t[1]-r[1],e[2]=t[2]-r[2],e[3]=t[3]-r[3],e[4]=t[4]-r[4],e[5]=t[5]-r[5],e[6]=t[6]-r[6],e[7]=t[7]-r[7],e[8]=t[8]-r[8],e[9]=t[9]-r[9],e[10]=t[10]-r[10],e[11]=t[11]-r[11],e[12]=t[12]-r[12],e[13]=t[13]-r[13],e[14]=t[14]-r[14],e[15]=t[15]-r[15],e},E.multiplyTransformation=function(t,r,e){var n=t[0],o=t[1],i=t[2],a=t[4],s=t[5],u=t[6],E=t[8],l=t[9],c=t[10],R=t[12],_=t[13],f=t[14],T=r[0],A=r[1],h=r[2],S=r[4],d=r[5],C=r[6],N=r[8],m=r[9],I=r[10],M=r[12],O=r[13],p=r[14],g=n*T+a*A+E*h,y=o*T+s*A+l*h,F=i*T+u*A+c*h,L=n*S+a*d+E*C,v=o*S+s*d+l*C,U=i*S+u*d+c*C,D=n*N+a*m+E*I,P=o*N+s*m+l*I,B=i*N+u*m+c*I,w=n*M+a*O+E*p+R,x=o*M+s*O+l*p+_,G=i*M+u*O+c*p+f;return e[0]=g,e[1]=y,e[2]=F,e[3]=0,e[4]=L,e[5]=v,e[6]=U,e[7]=0,e[8]=D,e[9]=P,e[10]=B,e[11]=0,e[12]=w,e[13]=x,e[14]=G,e[15]=1,e},E.multiplyByMatrix3=function(t,r,e){var n=t[0],o=t[1],i=t[2],a=t[4],s=t[5],u=t[6],E=t[8],l=t[9],c=t[10],R=r[0],_=r[1],f=r[2],T=r[3],A=r[4],h=r[5],S=r[6],d=r[7],C=r[8],N=n*R+a*_+E*f,m=o*R+s*_+l*f,I=i*R+u*_+c*f,M=n*T+a*A+E*h,O=o*T+s*A+l*h,p=i*T+u*A+c*h,g=n*S+a*d+E*C,y=o*S+s*d+l*C,F=i*S+u*d+c*C;return e[0]=N,e[1]=m,e[2]=I,e[3]=0,e[4]=M,e[5]=O,e[6]=p,e[7]=0,e[8]=g,e[9]=y,e[10]=F,e[11]=0,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},E.multiplyByTranslation=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=n*t[0]+o*t[4]+i*t[8]+t[12],s=n*t[1]+o*t[5]+i*t[9]+t[13],u=n*t[2]+o*t[6]+i*t[10]+t[14];return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=a,e[13]=s,e[14]=u,e[15]=t[15],e};var T=new t;E.multiplyByUniformScale=function(t,r,e){return T.x=r,T.y=r,T.z=r,E.multiplyByScale(t,T,e)},E.multiplyByScale=function(t,r,e){var n=r.x,o=r.y,i=r.z;return 1===n&&1===o&&1===i?E.clone(t,e):(e[0]=n*t[0],e[1]=n*t[1],e[2]=n*t[2],e[3]=0,e[4]=o*t[4],e[5]=o*t[5],e[6]=o*t[6],e[7]=0,e[8]=i*t[8],e[9]=i*t[9],e[10]=i*t[10],e[11]=0,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=1,e)},E.multiplyByVector=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=r.w,s=t[0]*n+t[4]*o+t[8]*i+t[12]*a,u=t[1]*n+t[5]*o+t[9]*i+t[13]*a,E=t[2]*n+t[6]*o+t[10]*i+t[14]*a,l=t[3]*n+t[7]*o+t[11]*i+t[15]*a;return e.x=s,e.y=u,e.z=E,e.w=l,e},E.multiplyByPointAsVector=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=t[0]*n+t[4]*o+t[8]*i,s=t[1]*n+t[5]*o+t[9]*i,u=t[2]*n+t[6]*o+t[10]*i;return e.x=a,e.y=s,e.z=u,e},E.multiplyByPoint=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=t[0]*n+t[4]*o+t[8]*i+t[12],s=t[1]*n+t[5]*o+t[9]*i+t[13],u=t[2]*n+t[6]*o+t[10]*i+t[14];return e.x=a,e.y=s,e.z=u,e},E.multiplyByScalar=function(t,r,e){return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*r,e[5]=t[5]*r,e[6]=t[6]*r,e[7]=t[7]*r,e[8]=t[8]*r,e[9]=t[9]*r,e[10]=t[10]*r,e[11]=t[11]*r,e[12]=t[12]*r,e[13]=t[13]*r,e[14]=t[14]*r,e[15]=t[15]*r,e},E.negate=function(t,r){return r[0]=-t[0],r[1]=-t[1],r[2]=-t[2],r[3]=-t[3],r[4]=-t[4],r[5]=-t[5],r[6]=-t[6],r[7]=-t[7],r[8]=-t[8],r[9]=-t[9],r[10]=-t[10],r[11]=-t[11],r[12]=-t[12],r[13]=-t[13],r[14]=-t[14],r[15]=-t[15],r},E.transpose=function(t,r){var e=t[1],n=t[2],o=t[3],i=t[6],a=t[7],s=t[11];return r[0]=t[0],r[1]=t[4],r[2]=t[8],r[3]=t[12],r[4]=e,r[5]=t[5],r[6]=t[9],r[7]=t[13],r[8]=n,r[9]=i,r[10]=t[10],r[11]=t[14],r[12]=o,r[13]=a,r[14]=s,r[15]=t[15],r},E.abs=function(t,r){return r[0]=Math.abs(t[0]),r[1]=Math.abs(t[1]),r[2]=Math.abs(t[2]),r[3]=Math.abs(t[3]),r[4]=Math.abs(t[4]),r[5]=Math.abs(t[5]),r[6]=Math.abs(t[6]),r[7]=Math.abs(t[7]),r[8]=Math.abs(t[8]),r[9]=Math.abs(t[9]),r[10]=Math.abs(t[10]),r[11]=Math.abs(t[11]),r[12]=Math.abs(t[12]),r[13]=Math.abs(t[13]),r[14]=Math.abs(t[14]),r[15]=Math.abs(t[15]),r},E.equals=function(t,r){return t===r||n(t)&&n(r)&&t[12]===r[12]&&t[13]===r[13]&&t[14]===r[14]&&t[0]===r[0]&&t[1]===r[1]&&t[2]===r[2]&&t[4]===r[4]&&t[5]===r[5]&&t[6]===r[6]&&t[8]===r[8]&&t[9]===r[9]&&t[10]===r[10]&&t[3]===r[3]&&t[7]===r[7]&&t[11]===r[11]&&t[15]===r[15]},E.equalsEpsilon=function(t,r,e){return t===r||n(t)&&n(r)&&Math.abs(t[0]-r[0])<=e&&Math.abs(t[1]-r[1])<=e&&Math.abs(t[2]-r[2])<=e&&Math.abs(t[3]-r[3])<=e&&Math.abs(t[4]-r[4])<=e&&Math.abs(t[5]-r[5])<=e&&Math.abs(t[6]-r[6])<=e&&Math.abs(t[7]-r[7])<=e&&Math.abs(t[8]-r[8])<=e&&Math.abs(t[9]-r[9])<=e&&Math.abs(t[10]-r[10])<=e&&Math.abs(t[11]-r[11])<=e&&Math.abs(t[12]-r[12])<=e&&Math.abs(t[13]-r[13])<=e&&Math.abs(t[14]-r[14])<=e&&Math.abs(t[15]-r[15])<=e},E.getTranslation=function(t,r){return r.x=t[12],r.y=t[13],r.z=t[14],r},E.getRotation=function(t,r){return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[4],r[4]=t[5],r[5]=t[6],r[6]=t[8],r[7]=t[9],r[8]=t[10],r};var A=new s,h=new s,S=new r,d=new r(0,0,0,1);return E.inverse=function(t,e){if(s.equalsEpsilon(E.getRotation(t,A),h,a.EPSILON7)&&r.equals(E.getRow(t,3,S),d))return e[0]=0,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=0,e[11]=0,e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=1,e;var n=t[0],o=t[4],i=t[8],l=t[12],c=t[1],R=t[5],_=t[9],f=t[13],T=t[2],C=t[6],N=t[10],m=t[14],I=t[3],M=t[7],O=t[11],p=t[15],g=N*p,y=m*O,F=C*p,L=m*M,v=C*O,U=N*M,D=T*p,P=m*I,B=T*O,w=N*I,x=T*M,G=C*I,b=g*R+L*_+v*f-(y*R+F*_+U*f),z=y*c+D*_+w*f-(g*c+P*_+B*f),H=F*c+P*R+x*f-(L*c+D*R+G*f),V=U*c+B*R+G*_-(v*c+w*R+x*_),X=y*o+F*i+U*l-(g*o+L*i+v*l),W=g*n+P*i+B*l-(y*n+D*i+w*l),q=L*n+D*o+G*l-(F*n+P*o+x*l),Y=v*n+w*o+x*i-(U*n+B*o+G*i);g=i*f,y=l*_,F=o*f,L=l*R,v=o*_,U=i*R,D=n*f,P=l*c,B=n*_,w=i*c,x=n*R,G=o*c;var K=g*M+L*O+v*p-(y*M+F*O+U*p),k=y*I+D*O+w*p-(g*I+P*O+B*p),Z=F*I+P*M+x*p-(L*I+D*M+G*p),j=U*I+B*M+G*O-(v*I+w*M+x*O),Q=F*N+U*m+y*C-(v*m+g*C+L*N),J=B*m+g*T+P*N-(D*N+w*m+y*T),$=D*C+G*m+L*T-(x*m+F*T+P*C),tt=x*N+v*T+w*C-(B*C+G*N+U*T),rt=n*b+o*z+i*H+l*V;if(Math.abs(rt)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return rt=1/rt,e[0]=b*rt,e[1]=z*rt,e[2]=H*rt,e[3]=V*rt,e[4]=X*rt,e[5]=W*rt,e[6]=q*rt,e[7]=Y*rt,e[8]=K*rt,e[9]=k*rt,e[10]=Z*rt,e[11]=j*rt,e[12]=Q*rt,e[13]=J*rt,e[14]=$*rt,e[15]=tt*rt,e},E.inverseTransformation=function(t,r){var e=t[0],n=t[1],o=t[2],i=t[4],a=t[5],s=t[6],u=t[8],E=t[9],l=t[10],c=t[12],R=t[13],_=t[14],f=-e*c-n*R-o*_,T=-i*c-a*R-s*_,A=-u*c-E*R-l*_;return r[0]=e,r[1]=i,r[2]=u,r[3]=0,r[4]=n,r[5]=a,r[6]=E,r[7]=0,r[8]=o,r[9]=s,r[10]=l,r[11]=0,r[12]=f,r[13]=T,r[14]=A,r[15]=1,r},E.IDENTITY=i(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=i(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,E.prototype.clone=function(t){return E.clone(this,t)},E.prototype.equals=function(t){return E.equals(this,t)},E.equalsArray=function(t,r,e){return t[0]===r[e]&&t[1]===r[e+1]&&t[2]===r[e+2]&&t[3]===r[e+3]&&t[4]===r[e+4]&&t[5]===r[e+5]&&t[6]===r[e+6]&&t[7]===r[e+7]&&t[8]===r[e+8]&&t[9]===r[e+9]&&t[10]===r[e+10]&&t[11]===r[e+11]&&t[12]===r[e+12]&&t[13]===r[e+13]&&t[14]===r[e+14]&&t[15]===r[e+15]},E.prototype.equalsEpsilon=function(t,r){return E.equalsEpsilon(this,t,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(t,r,e,n){"use strict";var o=function(r,e){this.normal=t.clone(r),this.distance=e};o.fromPointNormal=function(e,n,i){var a=-t.dot(n,e);return r(i)?(t.clone(n,i.normal),i.distance=a,i):new o(n,a)};var i=new t;return o.fromCartesian4=function(e,n){var a=t.fromCartesian4(e,i),s=e.w;return r(n)?(t.clone(a,n.normal),n.distance=s,n):new o(a,s)},o.getPointDistance=function(r,e){return t.dot(r.normal,e)+r.distance},o.ORIGIN_XY_PLANE=n(new o(t.UNIT_Z,0)),o.ORIGIN_YZ_PLANE=n(new o(t.UNIT_X,0)),o.ORIGIN_ZX_PLANE=n(new o(t.UNIT_Y,0)),o}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(t,r,e,n,o,i,a,s){"use strict";var u=function(t,e,n,o){this.west=r(t,0),this.south=r(e,0),this.east=r(n,0),this.north=r(o,0)};n(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(t,e,n){n=r(n,0),e[n++]=t.west,e[n++]=t.south,e[n++]=t.east,e[n]=t.north},u.unpack=function(t,n,o){return n=r(n,0),e(o)||(o=new u),o.west=t[n++],o.south=t[n++],o.east=t[n++],o.north=t[n],o},u.computeWidth=function(t){var r=t.east,e=t.west;return e>r&&(r+=s.TWO_PI),r-e},u.computeHeight=function(t){return t.north-t.south},u.fromDegrees=function(t,n,o,i,a){return t=s.toRadians(r(t,0)),n=s.toRadians(r(n,0)),o=s.toRadians(r(o,0)),i=s.toRadians(r(i,0)),e(a)?(a.west=t,a.south=n,a.east=o,a.north=i,a):new u(t,n,o,i)},u.fromCartographicArray=function(t,r){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,a=-Number.MAX_VALUE,s=0,E=t.length;E>s;s++){var l=t[s];n=Math.min(n,l.longitude),o=Math.max(o,l.longitude),i=Math.min(i,l.latitude),a=Math.max(a,l.latitude)}return e(r)?(r.west=n,r.south=i,r.east=o,r.north=a,r):new u(n,i,o,a)},u.clone=function(t,r){return e(t)?e(r)?(r.west=t.west,r.south=t.south,r.east=t.east,r.north=t.north,r):new u(t.west,t.south,t.east,t.north):void 0},u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.equals=function(t){return u.equals(this,t)},u.equals=function(t,r){return t===r||e(t)&&e(r)&&t.west===r.west&&t.south===r.south&&t.east===r.east&&t.north===r.north},u.prototype.equalsEpsilon=function(t,r){return e(t)&&Math.abs(this.west-t.west)<=r&&Math.abs(this.south-t.south)<=r&&Math.abs(this.east-t.east)<=r&&Math.abs(this.north-t.north)<=r},u.validate=function(t){},u.southwest=function(r,n){return e(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new t(r.west,r.south)},u.northwest=function(r,n){return e(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new t(r.west,r.north)},u.northeast=function(r,n){return e(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new t(r.east,r.north)},u.southeast=function(r,n){return e(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new t(r.east,r.south)},u.center=function(r,n){var o=r.east,i=r.west;i>o&&(o+=s.TWO_PI);var a=s.negativePiToPi(.5*(i+o)),u=.5*(r.south+r.north);return e(n)?(n.longitude=a,n.latitude=u,n.height=0,n):new t(a,u)},u.intersection=function(t,r,n){var o=t.east,i=t.west,a=r.east,E=r.west;i>o&&a>0?o+=s.TWO_PI:E>a&&o>0&&(a+=s.TWO_PI),i>o&&0>E?E+=s.TWO_PI:E>a&&0>i&&(i+=s.TWO_PI);var l=s.negativePiToPi(Math.max(i,E)),c=s.negativePiToPi(Math.min(o,a));if((t.west<t.east||r.west<r.east)&&l>=c)return void 0;var R=Math.max(t.south,r.south),_=Math.min(t.north,r.north);return R>=_?void 0:e(n)?(n.west=l,n.south=R,n.east=c,n.north=_,n):new u(l,R,c,_)},u.contains=function(t,r){var e=r.longitude,n=r.latitude,o=t.west,i=t.east;return o>i&&(i+=s.TWO_PI,0>e&&(e+=s.TWO_PI)),(e>o||s.equalsEpsilon(e,o,s.EPSILON14))&&(i>e||s.equalsEpsilon(e,i,s.EPSILON14))&&n>=t.south&&n<=t.north};var E=new t;return u.subsample=function(t,n,o,a){n=r(n,i.WGS84),o=r(o,0),e(a)||(a=[]);var l=0,c=t.north,R=t.south,_=t.east,f=t.west,T=E;T.height=o,T.longitude=f,T.latitude=c,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.longitude=_,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.latitude=R,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.longitude=f,a[l]=n.cartographicToCartesian(T,a[l]),l++,0>c?T.latitude=c:R>0?T.latitude=R:T.latitude=0;for(var A=1;8>A;++A)T.longitude=-Math.PI+A*s.PI_OVER_TWO,u.contains(t,T)&&(a[l]=n.cartographicToCartesian(T,a[l]),l++);return 0===T.latitude&&(T.longitude=f,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.longitude=_,a[l]=n.cartographicToCartesian(T,a[l]),l++),a.length=l,a},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(t,r,e,n,o,i,a,s,u,E,l,c,R){"use strict";var _=function(r,n){this.center=t.clone(e(r,t.ZERO)),this.radius=e(n,0)},f=new t,T=new t,A=new t,h=new t,S=new t,d=new t,C=new t,N=new t,m=new t,I=new t,M=new t,O=new t;_.fromPoints=function(r,e){if(n(e)||(e=new _),!n(r)||0===r.length)return e.center=t.clone(t.ZERO,e.center),e.radius=0,e;for(var o=t.clone(r[0],C),i=t.clone(o,f),a=t.clone(o,T),s=t.clone(o,A),u=t.clone(o,h),E=t.clone(o,S),l=t.clone(o,d),c=r.length,R=1;c>R;R++){t.clone(r[R],o);var p=o.x,g=o.y,y=o.z;p<i.x&&t.clone(o,i),p>u.x&&t.clone(o,u),g<a.y&&t.clone(o,a),g>E.y&&t.clone(o,E),y<s.z&&t.clone(o,s),y>l.z&&t.clone(o,l)}var F=t.magnitudeSquared(t.subtract(u,i,N)),L=t.magnitudeSquared(t.subtract(E,a,N)),v=t.magnitudeSquared(t.subtract(l,s,N)),U=i,D=u,P=F;L>P&&(P=L,U=a,D=E),v>P&&(P=v,U=s,D=l);var B=m;B.x=.5*(U.x+D.x),B.y=.5*(U.y+D.y),B.z=.5*(U.z+D.z);var w=t.magnitudeSquared(t.subtract(D,B,N)),x=Math.sqrt(w),G=I;G.x=i.x,G.y=a.y,G.z=s.z;var b=M;b.x=u.x,b.y=E.y,b.z=l.z;var z=t.multiplyByScalar(t.add(G,b,N),.5,O),H=0;for(R=0;c>R;R++){t.clone(r[R],o);var V=t.magnitude(t.subtract(o,z,N));V>H&&(H=V);var X=t.magnitudeSquared(t.subtract(o,B,N));if(X>w){var W=Math.sqrt(X);x=.5*(x+W),w=x*x;var q=W-x;B.x=(x*B.x+q*o.x)/W,B.y=(x*B.y+q*o.y)/W,B.z=(x*B.z+q*o.z)/W}}return H>x?(t.clone(B,e.center),e.radius=x):(t.clone(z,e.center),e.radius=H),e};var p=new s,g=new t,y=new t,F=new r,L=new r;_.fromRectangle2D=function(t,r,e){return _.fromRectangleWithHeights2D(t,r,0,0,e)},_.fromRectangleWithHeights2D=function(r,o,i,a,s){if(n(s)||(s=new _),!n(r))return s.center=t.clone(t.ZERO,s.center),s.radius=0,s;o=e(o,p),R.southwest(r,F),F.height=i,R.northeast(r,L),L.height=a;var u=o.project(F,g),E=o.project(L,y),l=E.x-u.x,c=E.y-u.y,f=E.z-u.z;s.radius=.5*Math.sqrt(l*l+c*c+f*f);var T=s.center;return T.x=u.x+.5*l,T.y=u.y+.5*c,T.z=u.z+.5*f,s};var v=[];_.fromRectangle3D=function(t,r,o,i){r=e(r,a.WGS84),o=e(o,0);var s;return n(t)&&(s=R.subsample(t,r,o,v)),_.fromPoints(s,i)},_.fromVertices=function(r,o,i,a){if(n(a)||(a=new _),!n(r)||0===r.length)return a.center=t.clone(t.ZERO,a.center),a.radius=0,a;o=e(o,t.ZERO),i=e(i,3);var s=C;s.x=r[0]+o.x,s.y=r[1]+o.y,s.z=r[2]+o.z;for(var u=t.clone(s,f),E=t.clone(s,T),l=t.clone(s,A),c=t.clone(s,h),R=t.clone(s,S),p=t.clone(s,d),g=r.length,y=0;g>y;y+=i){var F=r[y]+o.x,L=r[y+1]+o.y,v=r[y+2]+o.z;s.x=F,s.y=L,s.z=v,F<u.x&&t.clone(s,u),F>c.x&&t.clone(s,c),L<E.y&&t.clone(s,E),L>R.y&&t.clone(s,R),v<l.z&&t.clone(s,l),v>p.z&&t.clone(s,p)}var U=t.magnitudeSquared(t.subtract(c,u,N)),D=t.magnitudeSquared(t.subtract(R,E,N)),P=t.magnitudeSquared(t.subtract(p,l,N)),B=u,w=c,x=U;D>x&&(x=D,B=E,w=R),P>x&&(x=P,B=l,w=p);var G=m;G.x=.5*(B.x+w.x),G.y=.5*(B.y+w.y),G.z=.5*(B.z+w.z);var b=t.magnitudeSquared(t.subtract(w,G,N)),z=Math.sqrt(b),H=I;H.x=u.x,H.y=E.y,H.z=l.z;var V=M;V.x=c.x,V.y=R.y,V.z=p.z;var X=t.multiplyByScalar(t.add(H,V,N),.5,O),W=0;for(y=0;g>y;y+=i){s.x=r[y]+o.x,s.y=r[y+1]+o.y,s.z=r[y+2]+o.z;var q=t.magnitude(t.subtract(s,X,N));q>W&&(W=q);var Y=t.magnitudeSquared(t.subtract(s,G,N));if(Y>b){var K=Math.sqrt(Y);z=.5*(z+K),b=z*z;var k=K-z;G.x=(z*G.x+k*s.x)/K,G.y=(z*G.y+k*s.y)/K,G.z=(z*G.z+k*s.z)/K}}return W>z?(t.clone(G,a.center),a.radius=z):(t.clone(X,a.center),a.radius=W),a},_.fromCornerPoints=function(r,e,o){n(o)||(o=new _);var i=o.center;return t.add(r,e,i),t.multiplyByScalar(i,.5,i),o.radius=t.distance(i,e),o},_.fromEllipsoid=function(r,e){return n(e)||(e=new _),t.clone(t.ZERO,e.center),e.radius=r.maximumRadius,e};var U=new t;_.fromBoundingSpheres=function(r,e){if(n(e)||(e=new _),!n(r)||0===r.length)return e.center=t.clone(t.ZERO,e.center),e.radius=0,e;var o=r.length;if(1===o)return _.clone(r[0],e);if(2===o)return _.union(r[0],r[1],e);for(var i=[],a=0;o>a;a++)i.push(r[a].center);e=_.fromPoints(i,e);var s=e.center,u=e.radius;for(a=0;o>a;a++){var E=r[a];u=Math.max(u,t.distance(s,E.center,U)+E.radius)}return e.radius=u,e},_.clone=function(r,e){return n(r)?n(e)?(e.center=t.clone(r.center,e.center),e.radius=r.radius,e):new _(r.center,r.radius):void 0},_.packedLength=4,_.pack=function(t,r,n){n=e(n,0);var o=t.center;r[n++]=o.x,r[n++]=o.y,r[n++]=o.z,r[n]=t.radius},_.unpack=function(t,r,o){r=e(r,0),n(o)||(o=new _);var i=o.center;return i.x=t[r++],i.y=t[r++],i.z=t[r++],o.radius=t[r],o};var D=new t,P=new t;_.union=function(r,e,o){n(o)||(o=new _);var i=r.center,a=r.radius,s=e.center,u=e.radius,E=t.subtract(s,i,D),l=t.magnitude(E);if(a>=l+u)return r.clone(o),o;if(u>=l+a)return e.clone(o),o;var c=.5*(a+l+u),R=t.multiplyByScalar(E,(-a+c)/l,P);return t.add(R,i,R),t.clone(R,o.center),o.radius=c,o};var B=new t;_.expand=function(r,e,n){n=_.clone(r,n);var o=t.magnitude(t.subtract(e,n.center,B));return o>n.radius&&(n.radius=o),n},_.intersectPlane=function(r,e){var n=r.center,o=r.radius,i=e.normal,a=t.dot(i,n)+e.distance;return-o>a?u.OUTSIDE:o>a?u.INTERSECTING:u.INSIDE},_.transform=function(t,r,e){return n(e)||(e=new _),e.center=l.multiplyByPoint(r,t.center,e.center),e.radius=l.getMaximumScale(r)*t.radius,e};var w=new t;_.distanceSquaredTo=function(r,e){var n=t.subtract(r.center,e,w);return t.magnitudeSquared(n)-r.radius*r.radius},_.transformWithoutScale=function(t,r,e){return n(e)||(e=new _),e.center=l.multiplyByPoint(r,t.center,e.center),e.radius=t.radius,e};var x=new t;_.computePlaneDistances=function(r,e,o,i){n(i)||(i=new E);var a=t.subtract(r.center,e,x),s=t.dot(o,a);return i.start=s-r.radius,i.stop=s+r.radius,i};for(var G=new t,b=new t,z=new t,H=new t,V=new t,X=new r,W=new Array(8),q=0;8>q;++q)W[q]=new t;var Y=new s;return _.projectTo2D=function(r,n,o){n=e(n,Y);var i=n.ellipsoid,a=r.center,s=r.radius,u=i.geodeticSurfaceNormal(a,G),E=t.cross(t.UNIT_Z,u,b);t.normalize(E,E);var l=t.cross(u,E,z);t.normalize(l,l),t.multiplyByScalar(u,s,u),t.multiplyByScalar(l,s,l),t.multiplyByScalar(E,s,E);var c=t.negate(l,V),R=t.negate(E,H),f=W,T=f[0];t.add(u,l,T),t.add(T,E,T),T=f[1],t.add(u,l,T),t.add(T,R,T),T=f[2],t.add(u,c,T),t.add(T,R,T),T=f[3],t.add(u,c,T),t.add(T,E,T),t.negate(u,u),T=f[4],t.add(u,l,T),t.add(T,E,T),T=f[5],t.add(u,l,T),t.add(T,R,T),T=f[6],t.add(u,c,T),t.add(T,R,T),T=f[7],t.add(u,c,T),t.add(T,E,T);for(var A=f.length,h=0;A>h;++h){var S=f[h];t.add(a,S,S);var d=i.cartesianToCartographic(S,X);n.project(d,S)}o=_.fromPoints(f,o),a=o.center;var C=a.x,N=a.y,m=a.z;return a.x=m,a.y=C,a.z=N,o},_.isOccluded=function(t,r){return!r.isBoundingSphereVisible(t)},_.equals=function(r,e){return r===e||n(r)&&n(e)&&t.equals(r.center,e.center)&&r.radius===e.radius},_.prototype.intersectPlane=function(t){return _.intersectPlane(this,t)},_.prototype.distanceSquaredTo=function(t){return _.distanceSquaredTo(this,t)},_.prototype.computePlaneDistances=function(t,r,e){return _.computePlaneDistances(this,t,r,e)},_.prototype.isOccluded=function(t){return _.isOccluded(this,t)},_.prototype.equals=function(t){return _.equals(this,t)},_.prototype.clone=function(t){return _.clone(this,t)},_}),define("Core/Fullscreen",["./defined","./defineProperties"],function(t,r){"use strict";var e,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return r(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(t(e))return e;e=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",e=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,s=i.length;s>a;++a){var u=i[a];o=u+"RequestFullscreen","function"==typeof r[o]?(n.requestFullscreen=o,e=!0):(o=u+"RequestFullScreen","function"==typeof r[o]&&(n.requestFullscreen=o,e=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",t(document[o])?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",t(document[o])&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",t(document[o])?n.fullscreenElement=o:(o=u+"FullScreenElement",t(document[o])&&(n.fullscreenElement=o)),o=u+"fullscreenchange",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return e},o.requestFullscreen=function(t){o.supportsFullscreen()&&t[n.requestFullscreen]()},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(t,r,e){"use strict";function n(t){for(var r=t.split("."),e=0,n=r.length;n>e;++e)r[e]=parseInt(r[e],10);return r}function o(){if(!r(A)){A=!1;var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(A=!0,h=n(t[1]))}return A}function i(){return o()&&h}function a(){if(!r(S)&&(S=!1,!o()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(S=!0,d=n(t[1]))}return S}function s(){return a()&&d}function u(){if(!r(C)){C=!1;var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==t&&(C=!0,N=n(t[1]),N.isNightly=!!t[2])}return C}function E(){return u()&&N}function l(){if(!r(m)){m=!1;var t;"Microsoft Internet Explorer"===navigator.appName?(t=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(m=!0,I=n(t[1]))):"Netscape"===navigator.appName&&(t=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(m=!0,I=n(t[1])))}return m}function c(){return l()&&I}function R(){if(!r(M)){M=!1;var t=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(M=!0,O=n(t[1]))}return M}function _(){return r(p)||(p=/Windows/i.test(navigator.appVersion)),p}function f(){return R()&&O}function T(){return r(g)||(g=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),g}var A,h,S,d,C,N,m,I,M,O,p,g,y={isChrome:o,chromeVersion:i,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:E,isInternetExplorer:l,internetExplorerVersion:c,isFirefox:R,firefoxVersion:f,isWindows:_,hardwareConcurrency:t(navigator.hardwareConcurrency,3),supportsPointerEvents:T};return y.supportsFullscreen=function(){return e.supportsFullscreen()},y.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},y.supportsWebWorkers=function(){return"undefined"!=typeof Worker},y}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(t,r,e,n,o,i){"use strict";function a(t,r,e){return 0>e&&(e+=1),e>1&&(e-=1),1>6*e?t+6*(r-t)*e:1>2*e?r:2>3*e?t+(r-t)*(2/3-e)*6:t}var s=function(r,e,n,o){this.red=t(r,1),this.green=t(e,1),this.blue=t(n,1),this.alpha=t(o,1)};s.fromCartesian4=function(t,e){return r(e)?(e.red=t.x,e.green=t.y,e.blue=t.z,e.alpha=t.w,e):new s(t.x,t.y,t.z,t.w)},s.fromBytes=function(e,n,o,i,a){return e=s.byteToFloat(t(e,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),i=s.byteToFloat(t(i,255)),r(a)?(a.red=e,a.green=n,a.blue=o,a.alpha=i,a):new s(e,n,o,i)},s.fromAlpha=function(t,e,n){return r(n)?(n.red=t.red,n.green=t.green,n.blue=t.blue,n.alpha=e,n):new s(t.red,t.green,t.blue,e)};var u,E,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),E=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(t){return E[0]=t,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(r,e,n,o){r=t(r,0)%1,e=t(e,0),n=t(n,0),o=t(o,1);var i=n,u=n,E=n;if(0!==e){var l;l=.5>n?n*(1+e):n+e-n*e;var c=2*n-l;i=a(c,l,r+1/3),u=a(c,l,r),E=a(c,l,r-1/3)}return new s(i,u,E,o)},s.fromRandom=function(e,n){e=t(e,t.EMPTY_OBJECT);var o=e.red;if(!r(o)){var a=t(e.minimumRed,0),u=t(e.maximumRed,1);o=a+i.nextRandomNumber()*(u-a)}var E=e.green;if(!r(E)){var l=t(e.minimumGreen,0),c=t(e.maximumGreen,1);E=l+i.nextRandomNumber()*(c-l)}var R=e.blue;if(!r(R)){var _=t(e.minimumBlue,0),f=t(e.maximumBlue,1);R=_+i.nextRandomNumber()*(f-_)}var T=e.alpha;if(!r(T)){var A=t(e.minimumAlpha,0),h=t(e.maximumAlpha,1);T=A+i.nextRandomNumber()*(h-A)}return r(n)?(n.red=o,n.green=E,n.blue=R,n.alpha=T,n):new s(o,E,R,T)};var c=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,R=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,_=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,f=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(e){var n=s[e.toUpperCase()];if(r(n))return s.clone(n);var o=c.exec(e);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=R.exec(e),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=_.exec(e),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(t(o[4],"1.0"))):(o=f.exec(e),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(t(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,e,n){n=t(n,0),e[n++]=r.red,e[n++]=r.green,e[n++]=r.blue,e[n]=r.alpha},s.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new s),o.red=e[n++],o.green=e[n++],o.blue=e[n++],o.alpha=e[n],o},s.byteToFloat=function(t){return t/255},s.floatToByte=function(t){return 1===t?255:256*t|0},s.clone=function(t,e){return r(t)?r(e)?(e.red=t.red,e.green=t.green,e.blue=t.blue,e.alpha=t.alpha,e):new s(t.red,t.green,t.blue,t.alpha):void 0},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t.red===e.red&&t.green===e.green&&t.blue===e.blue&&t.alpha===e.alpha},s.equalsArray=function(t,r,e){return t.red===r[e]&&t.green===r[e+1]&&t.blue===r[e+2]&&t.alpha===r[e+3]},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.prototype.equalsEpsilon=function(t,e){return this===t||r(t)&&Math.abs(this.red-t.red)<=e&&Math.abs(this.green-t.green)<=e&&Math.abs(this.blue-t.blue)<=e&&Math.abs(this.alpha-t.alpha)<=e},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var t=s.floatToByte(this.red),r=s.floatToByte(this.green),e=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+t+","+r+","+e+")":"rgba("+t+","+r+","+e+","+this.alpha+")"},s.prototype.toBytes=function(t){var e=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),i=s.floatToByte(this.alpha);return r(t)?(t[0]=e,t[1]=n,t[2]=o,t[3]=i,t):[e,n,o,i]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),E[0]},s.prototype.brighten=function(t,r){return t=1-t,r.red=1-(1-this.red)*t,r.green=1-(1-this.green)*t,r.blue=1-(1-this.blue)*t,r.alpha=this.alpha,r},s.prototype.darken=function(t,r){return t=1-t,r.red=this.red*t,r.green=this.green*t,r.blue=this.blue*t,r.alpha=this.alpha,r},s.prototype.withAlpha=function(t,r){return s.fromAlpha(this,t,r)},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),
s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUSCHIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(t){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return t(r)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(t,r,e,n,o,i){"use strict";if(!o.supportsTypedArrays())return{};var a={BYTE:t.BYTE,UNSIGNED_BYTE:t.UNSIGNED_BYTE,SHORT:t.SHORT,UNSIGNED_SHORT:t.UNSIGNED_SHORT,FLOAT:t.FLOAT,DOUBLE:t.DOUBLE};return a.getSizeInBytes=function(t){switch(t){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(t){return t instanceof Int8Array?a.BYTE:t instanceof Uint8Array?a.UNSIGNED_BYTE:t instanceof Int16Array?a.SHORT:t instanceof Uint16Array?a.UNSIGNED_SHORT:t instanceof Float32Array?a.FLOAT:t instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(t){return e(t)&&(t===a.BYTE||t===a.UNSIGNED_BYTE||t===a.SHORT||t===a.UNSIGNED_SHORT||t===a.FLOAT||t===a.DOUBLE)},a.createTypedArray=function(t,r){switch(t){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(t,e,o,i){switch(o=r(o,0),i=r(i,(e.byteLength-o)/a.getSizeInBytes(t)),t){case a.BYTE:return new Int8Array(e,o,i);case a.UNSIGNED_BYTE:return new Uint8Array(e,o,i);case a.SHORT:return new Int16Array(e,o,i);case a.UNSIGNED_SHORT:return new Uint16Array(e,o,i);case a.FLOAT:return new Float32Array(e,o,i);case a.DOUBLE:return new Float64Array(e,o,i);default:throw new n("componentDatatype is not a valid value.")}},i(a)}),define("Core/GeometryType",["./freezeObject"],function(t){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return t(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(t,r){"use strict";var e={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return r(e)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(t,r,e,n,o){"use strict";var i=function(r){r=t(r,t.EMPTY_OBJECT),this.attributes=r.attributes,this.indices=r.indices,this.primitiveType=t(r.primitiveType,o.TRIANGLES),this.boundingSphere=r.boundingSphere,this.geometryType=t(r.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(t){var n=-1;for(var o in t.attributes)if(t.attributes.hasOwnProperty(o)&&r(t.attributes[o])&&r(t.attributes[o].values)){var i=t.attributes[o],a=i.values.length/i.componentsPerAttribute;if(n!==a&&-1!==n)throw new e("All attribute lists must have the same number of attributes.");n=a}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t,r,e){"use strict";var n=function(r){r=t(r,t.EMPTY_OBJECT),this.componentDatatype=r.componentDatatype,this.componentsPerAttribute=r.componentsPerAttribute,this.normalize=t(r.normalize,!1),this.values=r.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";var r=function(r){r=t(r,t.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i={UNSIGNED_BYTE:t.UNSIGNED_BYTE,UNSIGNED_SHORT:t.UNSIGNED_SHORT,UNSIGNED_INT:t.UNSIGNED_INT};return i.getSizeInBytes=function(t){switch(t){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(t){return r(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(t,r){return t>=o.SIXTY_FOUR_KILOBYTES?new Uint32Array(r):new Uint16Array(r)},i.createTypedArrayFromArrayBuffer=function(t,r,e,n){return t>=o.SIXTY_FOUR_KILOBYTES?new Uint32Array(r,e,n):new Uint16Array(r,e,n)},n(i)}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(t,r,e,n,o,i,a,s){"use strict";function u(t){var r=t._uSquared,e=t._ellipsoid.maximumRadius,n=t._ellipsoid.minimumRadius,o=(e-n)/e,i=Math.cos(t._startHeading),a=Math.sin(t._startHeading),s=(1-o)*Math.tan(t._start.latitude),u=1/Math.sqrt(1+s*s),E=u*s,l=Math.atan2(s,i),c=u*a,R=c*c,_=1-R,f=Math.sqrt(_),T=r/4,A=T*T,h=A*T,S=A*A,d=1+T-3*A/4+5*h/4-175*S/64,C=1-T+15*A/8-35*h/8,N=1-3*T+35*A/4,m=1-5*T,I=d*l-C*Math.sin(2*l)*T/2-N*Math.sin(4*l)*A/16-m*Math.sin(6*l)*h/48-5*Math.sin(8*l)*S/512,M=t._constants;M.a=e,M.b=n,M.f=o,M.cosineHeading=i,M.sineHeading=a,M.tanU=s,M.cosineU=u,M.sineU=E,M.sigma=l,M.sineAlpha=c,M.sineSquaredAlpha=R,M.cosineSquaredAlpha=_,M.cosineAlpha=f,M.u2Over4=T,M.u4Over16=A,M.u6Over64=h,M.u8Over256=S,M.a0=d,M.a1=C,M.a2=N,M.a3=m,M.distanceRatio=I}function E(t,r){return t*r*(4+t*(4-3*r))/16}function l(t,r,e,n,o,i,a){var s=E(t,e);return(1-s)*t*r*(n+s*o*(a+s*i*(2*a*a-1)))}function c(t,r,e,n,o,i,a){var u,E,c,R,_,f=(r-e)/r,T=i-n,A=Math.atan((1-f)*Math.tan(o)),h=Math.atan((1-f)*Math.tan(a)),S=Math.cos(A),d=Math.sin(A),C=Math.cos(h),N=Math.sin(h),m=S*C,I=S*N,M=d*N,O=d*C,p=T,g=s.TWO_PI,y=Math.cos(p),F=Math.sin(p);do{y=Math.cos(p),F=Math.sin(p);var L=I-O*y;c=Math.sqrt(C*C*F*F+L*L),E=M+m*y,u=Math.atan2(c,E);var v;0===c?(v=0,R=1):(v=m*F/c,R=1-v*v),g=p,_=E-2*M/R,isNaN(_)&&(_=0),p=T+l(f,v,R,u,c,E,_)}while(Math.abs(p-g)>s.EPSILON12);var U=R*(r*r-e*e)/(e*e),D=1+U*(4096+U*(U*(320-175*U)-768))/16384,P=U*(256+U*(U*(74-47*U)-128))/1024,B=_*_,w=P*c*(_+P*(E*(2*B-1)-P*_*(4*c*c-3)*(4*B-3)/6)/4),x=e*D*(u-w),G=Math.atan2(C*F,I-O*y),b=Math.atan2(S*F,I*y-O);t._distance=x,t._startHeading=G,t._endHeading=b,t._uSquared=U}function R(e,n,o,i){t.normalize(i.cartographicToCartesian(n,f),_),t.normalize(i.cartographicToCartesian(o,f),f);c(e,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,o.longitude,o.latitude),e._start=r.clone(n,e._start),e._end=r.clone(o,e._end),e._start.height=0,e._end.height=0,u(e)}var _=new t,f=new t,T=function(t,o,i){var s=e(i,a.WGS84);this._ellipsoid=s,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(t)&&n(o)&&R(this,t,o,s)};return o(T.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),T.prototype.setEndPoints=function(t,r){R(this,t,r,this._ellipsoid)},T.prototype.interpolateUsingFraction=function(t,r){return this.interpolateUsingSurfaceDistance(this._distance*t,r)},T.prototype.interpolateUsingSurfaceDistance=function(t,e){var o=this._constants,i=o.distanceRatio+t/o.b,a=Math.cos(2*i),s=Math.cos(4*i),u=Math.cos(6*i),E=Math.sin(2*i),c=Math.sin(4*i),R=Math.sin(6*i),_=Math.sin(8*i),f=i*i,T=i*f,A=o.u8Over256,h=o.u2Over4,S=o.u6Over64,d=o.u4Over16,C=2*T*A*a/3+i*(1-h+7*d/4-15*S/4+579*A/64-(d-15*S/4+187*A/16)*a-(5*S/4-115*A/16)*s-29*A*u/16)+(h/2-d+71*S/32-85*A/16)*E+(5*d/16-5*S/4+383*A/96)*c-f*((S-11*A/2)*E+5*A*c/2)+(29*S/96-29*A/16)*R+539*A*_/1536,N=Math.asin(Math.sin(C)*o.cosineAlpha),m=Math.atan(o.a/o.b*Math.tan(N));C-=o.sigma;var I=Math.cos(2*o.sigma+C),M=Math.sin(C),O=Math.cos(C),p=o.cosineU*O,g=o.sineU*M,y=Math.atan2(M*o.sineHeading,p-g*o.cosineHeading),F=y-l(o.f,o.sineAlpha,o.cosineSquaredAlpha,C,M,O,I);return n(e)?(e.longitude=this._start.longitude+F,e.latitude=m,e.height=0,e):new r(this._start.longitude+F,m,0)},T}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(t,r){"use strict";function e(t,e,n){var o=t+e;return r.sign(t)!==r.sign(e)&&Math.abs(o/Math.max(Math.abs(t),Math.abs(e)))<n?0:o}var n={};return n.computeDiscriminant=function(t,r,e){var n=r*r-4*t*e;return n},n.computeRealRoots=function(t,n,o){var i;if(0===t)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var a=Math.abs(o),s=Math.abs(t);if(s>a&&a/s<r.EPSILON14)return[0,0];if(a>s&&s/a<r.EPSILON14)return[];if(i=-o/t,0>i)return[];var u=Math.sqrt(i);return[-u,u]}if(0===o)return i=-n/t,0>i?[i,0]:[0,i];var E=n*n,l=4*t*o,c=e(E,-l,r.EPSILON14);if(0>c)return[];var R=-.5*e(n,r.sign(n)*Math.sqrt(c),r.EPSILON14);return n>0?[R/t,o/R]:[o/R,R/t]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(t,r){"use strict";function e(t,r,e,n){var o,i,a=t,s=r/3,u=e/3,E=n,l=a*u,c=s*E,R=s*s,_=u*u,f=a*u-R,T=a*E-s*u,A=s*E-_,h=4*f*A-T*T;if(0>h){var S,d,C;R*c>=l*_?(S=a,d=f,C=-2*s*f+a*T):(S=E,d=A,C=-E*T+2*u*A);var N=0>C?-1:1,m=-N*Math.abs(S)*Math.sqrt(-h);i=-C+m;var I=i/2,M=0>I?-Math.pow(-I,1/3):Math.pow(I,1/3),O=i===m?-M:-d/M;return o=0>=d?M+O:-C/(M*M+O*O+d),R*c>=l*_?[(o-s)/a]:[-E/(o+u)]}var p=f,g=-2*s*f+a*T,y=A,F=-E*T+2*u*A,L=Math.sqrt(h),v=Math.sqrt(3)/2,U=Math.abs(Math.atan2(a*L,-g)/3);o=2*Math.sqrt(-p);var D=Math.cos(U);i=o*D;var P=o*(-D/2-v*Math.sin(U)),B=i+P>2*s?i-s:P-s,w=a,x=B/w;U=Math.abs(Math.atan2(E*L,-F)/3),o=2*Math.sqrt(-y),D=Math.cos(U),i=o*D,P=o*(-D/2-v*Math.sin(U));var G=-E,b=2*u>i+P?i+u:P+u,z=G/b,H=w*b,V=-B*b-w*G,X=B*G,W=(u*V-s*X)/(-s*V+u*H);return W>=x?z>=x?z>=W?[x,W,z]:[x,z,W]:[z,x,W]:z>=x?[W,x,z]:z>=W?[W,z,x]:[z,W,x]}var n={};return n.computeDiscriminant=function(t,r,e,n){var o=t*t,i=r*r,a=e*e,s=n*n,u=18*t*r*e*n+i*a-27*o*s-4*(t*a*e+i*r*n);return u},n.computeRealRoots=function(t,n,o,i){var a,s;if(0===t)return r.computeRealRoots(n,o,i);if(0===n){if(0===o){if(0===i)return[0,0,0];s=-i/t;var u=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[u,u,u]}return 0===i?(a=r.computeRealRoots(t,0,o),0===a.Length?[0]:[a[0],0,a[1]]):e(t,0,o,i)}return 0===o?0===i?(s=-n/t,0>s?[s,0,0]:[0,0,s]):e(t,n,0,i):0===i?(a=r.computeRealRoots(t,n,o),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):e(t,n,o,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(t,r,e,n){"use strict";function o(r,o,i,a){var s=r*r,u=o-3*s/8,E=i-o*r/2+s*r/8,l=a-i*r/4+o*s/16-3*s*s/256,c=t.computeRealRoots(1,2*u,u*u-4*l,-E*E);if(c.length>0){var R=-r/4,_=c[c.length-1];if(Math.abs(_)<e.EPSILON14){var f=n.computeRealRoots(1,u,l);if(2===f.length){var T,A=f[0],h=f[1];if(A>=0&&h>=0){var S=Math.sqrt(A),d=Math.sqrt(h);return[R-d,R-S,R+S,R+d]}if(A>=0&&0>h)return T=Math.sqrt(A),[R-T,R+T];if(0>A&&h>=0)return T=Math.sqrt(h),[R-T,R+T]}return[]}if(_>0){var C=Math.sqrt(_),N=(u+_-E/C)/2,m=(u+_+E/C)/2,I=n.computeRealRoots(1,C,N),M=n.computeRealRoots(1,-C,m);return 0!==I.length?(I[0]+=R,I[1]+=R,0!==M.length?(M[0]+=R,M[1]+=R,I[1]<=M[0]?[I[0],I[1],M[0],M[1]]:M[1]<=I[0]?[M[0],M[1],I[0],I[1]]:I[0]>=M[0]&&I[1]<=M[1]?[M[0],I[0],I[1],M[1]]:M[0]>=I[0]&&M[1]<=I[1]?[I[0],M[0],M[1],I[1]]:I[0]>M[0]&&I[0]<M[1]?[M[0],I[0],M[1],I[1]]:[I[0],M[0],I[1],M[1]]):I):0!==M.length?(M[0]+=R,M[1]+=R,M):[]}}return[]}function i(r,o,i,a){var s=i*i,u=o*o,E=r*r,l=-2*o,c=i*r+u-4*a,R=E*a-i*o*r+s,_=t.computeRealRoots(1,l,c,R);if(_.length>0){var f,T,A=_[0],h=o-A,S=h*h,d=r/2,C=h/2,N=S-4*a,m=S+4*Math.abs(a),I=E-4*A,M=E+4*Math.abs(A);if(0>A||I*m>N*M){var O=Math.sqrt(I);f=O/2,T=0===O?0:(r*C-i)/O}else{var p=Math.sqrt(N);f=0===p?0:(r*C-i)/p,T=p/2}var g,y;0===d&&0===f?(g=0,y=0):e.sign(d)===e.sign(f)?(g=d+f,y=A/g):(y=d-f,g=A/y);var F,L;0===C&&0===T?(F=0,L=0):e.sign(C)===e.sign(T)?(F=C+T,L=a/F):(L=C-T,F=a/L);var v=n.computeRealRoots(1,g,F),U=n.computeRealRoots(1,y,L);if(0!==v.length)return 0!==U.length?v[1]<=U[0]?[v[0],v[1],U[0],U[1]]:U[1]<=v[0]?[U[0],U[1],v[0],v[1]]:v[0]>=U[0]&&v[1]<=U[1]?[U[0],v[0],v[1],U[1]]:U[0]>=v[0]&&U[1]<=v[1]?[v[0],U[0],U[1],v[1]]:v[0]>U[0]&&v[0]<U[1]?[U[0],v[0],U[1],v[1]]:[v[0],U[0],v[1],U[1]]:v;if(0!==U.length)return U}return[]}var a={};return a.computeDiscriminant=function(t,r,e,n,o){var i=t*t,a=i*t,s=r*r,u=s*r,E=e*e,l=E*e,c=n*n,R=c*n,_=o*o,f=_*o,T=s*E*c-4*u*R-4*t*l*c+18*t*r*e*R-27*i*c*c+256*a*f+o*(18*u*e*n-4*s*l+16*t*E*E-80*t*r*E*n-6*t*s*c+144*i*e*c)+_*(144*t*s*e-27*s*s-128*i*E-192*i*r*n);return T},a.computeRealRoots=function(r,n,a,s,u){if(Math.abs(r)<e.EPSILON15)return t.computeRealRoots(n,a,s,u);var E=n/r,l=a/r,c=s/r,R=u/r,_=0>E?1:0;switch(_+=0>l?_+1:_,_+=0>c?_+1:_,_+=0>R?_+1:_){case 0:return o(E,l,c,R);case 1:return i(E,l,c,R);case 2:return i(E,l,c,R);case 3:return o(E,l,c,R);case 4:return o(E,l,c,R);case 5:return i(E,l,c,R);case 6:return o(E,l,c,R);case 7:return o(E,l,c,R);case 8:return i(E,l,c,R);case 9:return o(E,l,c,R);case 10:return o(E,l,c,R);case 11:return i(E,l,c,R);case 12:return o(E,l,c,R);case 13:return o(E,l,c,R);case 14:return o(E,l,c,R);case 15:return o(E,l,c,R);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(t,r,e,n){"use strict";var o=function(e,n){n=t.clone(r(n,t.ZERO)),t.equals(n,t.ZERO)||t.normalize(n,n),this.origin=t.clone(r(e,t.ZERO)),this.direction=n};return o.getPoint=function(r,n,o){return e(o)||(o=new t),o=t.multiplyByScalar(r.direction,n,o),t.add(r.origin,o,o)},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(t,r,e,n,o,i,a,s,u,E){
"use strict";function l(r,n,o,a,s){s=e(s,!1);var u,E,l,c,R,_=r.origin,f=r.direction,T=t.subtract(o,n,A),N=t.subtract(a,n,h),m=t.cross(f,N,S),I=t.dot(T,m);if(s){if(I<i.EPSILON6)return void 0;if(u=t.subtract(_,n,d),l=t.dot(u,m),0>l||l>I)return void 0;if(E=t.cross(u,T,C),c=t.dot(f,E),0>c||l+c>I)return void 0;R=t.dot(N,E)/I}else{if(Math.abs(I)<i.EPSILON6)return void 0;var M=1/I;if(u=t.subtract(_,n,d),l=t.dot(u,m)*M,0>l||l>1)return void 0;if(E=t.cross(u,T,C),c=t.dot(f,E)*M,0>c||l+c>1)return void 0;R=t.dot(N,E)*M}return R}function c(t,r,e,n){var o=r*r-4*t*e;if(0>o)return void 0;if(o>0){var i=1/(2*t),a=Math.sqrt(o),s=(-r+a)*i,u=(-r-a)*i;return u>s?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var E=-r/(2*t);return 0===E?void 0:(n.root0=n.root1=E,n)}function R(r,e,o){n(o)||(o={});var i=r.origin,a=r.direction,s=e.center,u=e.radius*e.radius,E=t.subtract(i,s,S),l=t.dot(a,a),R=2*t.dot(a,E),_=t.magnitudeSquared(E)-u,f=c(l,R,_,m);return n(f)?(o.start=f.root0,o.stop=f.root1,o):void 0}function _(t,r,e){var n=t+r;return i.sign(t)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(t),Math.abs(r)))<e?0:n}function f(r,e,n,o,E){var l,c=o*o,R=E*E,f=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*R,T=E*(o*_(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+e.y),A=r[a.COLUMN0ROW0]*c+r[a.COLUMN2ROW2]*R+o*e.x+n,h=R*_(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),S=E*(o*_(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+e.z),d=[];if(0===S&&0===h){if(l=s.computeRealRoots(f,T,A),0===l.length)return d;var C=l[0],N=Math.sqrt(Math.max(1-C*C,0));if(d.push(new t(o,E*C,E*-N)),d.push(new t(o,E*C,E*N)),2===l.length){var m=l[1],I=Math.sqrt(Math.max(1-m*m,0));d.push(new t(o,E*m,E*-I)),d.push(new t(o,E*m,E*I))}return d}var M=S*S,O=h*h,p=f*f,g=S*h,y=p+O,F=2*(T*f+g),L=2*A*f+T*T-O+M,v=2*(A*T-g),U=A*A-M;if(0===y&&0===F&&0===L&&0===v)return d;l=u.computeRealRoots(y,F,L,v,U);var D=l.length;if(0===D)return d;for(var P=0;D>P;++P){var B,w=l[P],x=w*w,G=Math.max(1-x,0),b=Math.sqrt(G);B=i.sign(f)===i.sign(A)?_(f*x+A,T*w,i.EPSILON12):i.sign(A)===i.sign(T*w)?_(f*x,T*w+A,i.EPSILON12):_(f*x+T*w,A,i.EPSILON12);var z=_(h*w,S,i.EPSILON15),H=B*z;0>H?d.push(new t(o,E*w,E*b)):H>0?d.push(new t(o,E*w,E*-b)):0!==b?(d.push(new t(o,E*w,E*-b)),d.push(new t(o,E*w,E*b)),++P):d.push(new t(o,E*w,E*b))}return d}var T={};T.rayPlane=function(r,e,o){n(o)||(o=new t);var a=r.origin,s=r.direction,u=e.normal,E=t.dot(u,s);if(Math.abs(E)<i.EPSILON15)return void 0;var l=(-e.distance-t.dot(u,a))/E;return 0>l?void 0:(o=t.multiplyByScalar(s,l,o),t.add(a,o,o))};var A=new t,h=new t,S=new t,d=new t,C=new t;T.rayTriangle=function(r,e,o,i,a,s){var u=l(r,e,o,i,a);return!n(u)||0>u?void 0:(n(s)||(s=new t),t.multiplyByScalar(r.direction,u,s),t.add(r.origin,s,s))};var N=new E;T.lineSegmentTriangle=function(r,e,o,i,a,s,u){var E=N;t.clone(r,E.origin),t.subtract(e,r,E.direction),t.normalize(E.direction,E.direction);var c=l(E,o,i,a,s);return!n(c)||0>c||c>t.distance(r,e)?void 0:(n(u)||(u=new t),t.multiplyByScalar(E.direction,c,u),t.add(E.origin,u,u))};var m={root0:0,root1:0};T.raySphere=function(t,r,e){return e=R(t,r,e),!n(e)||e.stop<0?void 0:(e.start=Math.max(e.start,0),e)};var I=new E;T.lineSegmentSphere=function(r,e,o,i){var a=I,s=(t.clone(r,a.origin),t.subtract(e,r,a.direction)),u=t.magnitude(s);return t.normalize(s,s),i=R(a,o,i),!n(i)||i.stop<0||i.start>u?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,u),i)};var M=new t,O=new t;T.rayEllipsoid=function(r,e){var n,o,i,a,s,u=e.oneOverRadii,E=t.multiplyComponents(u,r.origin,M),l=t.multiplyComponents(u,r.direction,O),c=t.magnitudeSquared(E),R=t.dot(E,l);if(c>1){if(R>=0)return void 0;var _=R*R;if(n=c-1,o=t.magnitudeSquared(l),i=o*n,i>_)return void 0;if(_>i){a=R*R-i,s=-R+Math.sqrt(a);var f=s/o,T=n/s;return T>f?{start:f,stop:T}:{start:T,stop:f}}var A=Math.sqrt(n/o);return{start:A,stop:A}}return 1>c?(n=c-1,o=t.magnitudeSquared(l),i=o*n,a=R*R-i,s=-R+Math.sqrt(a),{start:0,stop:s/o}):0>R?(o=t.magnitudeSquared(l),{start:0,stop:-R/o}):void 0};var p=new t,g=new t,y=new t,F=new t,L=new t,v=new a,U=new a,D=new a,P=new a,B=new a,w=new a,x=new a,G=new t,b=new t,z=new r;T.grazingAltitudeLocation=function(r,e){var o=r.origin,s=r.direction,u=e.geodeticSurfaceNormal(o,p);if(t.dot(s,u)>=0)return o;var E=n(this.rayEllipsoid(r,e)),l=e.transformPositionToScaledSpace(s,p),c=t.normalize(l,l),R=t.mostOrthogonalAxis(l,F),_=t.normalize(t.cross(R,c,g),g),T=t.normalize(t.cross(c,_,y),y),A=v;A[0]=c.x,A[1]=c.y,A[2]=c.z,A[3]=_.x,A[4]=_.y,A[5]=_.z,A[6]=T.x,A[7]=T.y,A[8]=T.z;var h=a.transpose(A,U),S=a.fromScale(e.radii,D),d=a.fromScale(e.oneOverRadii,P),C=B;C[0]=0,C[1]=-s.z,C[2]=s.y,C[3]=s.z,C[4]=0,C[5]=-s.x,C[6]=-s.y,C[7]=s.x,C[8]=0;var N,m,I=a.multiply(a.multiply(h,d,w),C,w),M=a.multiply(a.multiply(I,S,x),A,x),O=a.multiplyByVector(I,o,L),H=f(M,t.negate(O,p),0,0,1),V=H.length;if(V>0){for(var X=t.clone(t.ZERO,b),W=Number.NEGATIVE_INFINITY,q=0;V>q;++q){N=a.multiplyByVector(S,a.multiplyByVector(A,H[q],G),G);var Y=t.normalize(t.subtract(N,o,F),F),K=t.dot(Y,s);K>W&&(W=K,X=t.clone(N,X))}var k=e.cartesianToCartographic(X,z);return W=i.clamp(W,0,1),m=t.magnitude(t.subtract(X,o,F))*Math.sqrt(1-W*W),m=E?-m:m,k.height=m,e.cartographicToCartesian(k,new t)}return void 0};var H=new t;return T.lineSegmentPlane=function(r,e,o,a){n(a)||(a=new t);var s=t.subtract(e,r,H),u=o.normal,E=t.dot(u,s);if(Math.abs(E)<i.EPSILON6)return void 0;var l=t.dot(u,r),c=-(o.distance+l)/E;return 0>c||c>1?void 0:(t.multiplyByScalar(s,c,a),t.add(r,a,a),a)},T.trianglePlaneIntersection=function(r,e,n,o){var i=o.normal,a=o.distance,s=t.dot(i,r)+a<0,u=t.dot(i,e)+a<0,E=t.dot(i,n)+a<0,l=0;l+=s?1:0,l+=u?1:0,l+=E?1:0;var c,R;if((1===l||2===l)&&(c=new t,R=new t),1===l){if(s)return T.lineSegmentPlane(r,e,o,c),T.lineSegmentPlane(r,n,o,R),{positions:[r,e,n,c,R],indices:[0,3,4,1,2,4,1,4,3]};if(u)return T.lineSegmentPlane(e,n,o,c),T.lineSegmentPlane(e,r,o,R),{positions:[r,e,n,c,R],indices:[1,3,4,2,0,4,2,4,3]};if(E)return T.lineSegmentPlane(n,r,o,c),T.lineSegmentPlane(n,e,o,R),{positions:[r,e,n,c,R],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!s)return T.lineSegmentPlane(e,r,o,c),T.lineSegmentPlane(n,r,o,R),{positions:[r,e,n,c,R],indices:[1,2,4,1,4,3,0,3,4]};if(!u)return T.lineSegmentPlane(n,e,o,c),T.lineSegmentPlane(r,e,o,R),{positions:[r,e,n,c,R],indices:[2,0,4,2,4,3,1,3,4]};if(!E)return T.lineSegmentPlane(r,n,o,c),T.lineSegmentPlane(e,n,o,R),{positions:[r,e,n,c,R],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},T}),define("Core/isArray",["./defined"],function(t){"use strict";var r=Array.isArray;return t(r)||(r=function(t){return"[object Array]"===Object.prototype.toString.call(t)}),r}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(t,r,e,n,o,i,a,s,u,E,l,c){"use strict";function R(t,r,e){var n=M;n.length=t;var o;if(r===e){for(o=0;t>o;o++)n[o]=r;return n}var i=e-r,a=i/t;for(o=0;t>o;o++){var s=r+o*a;n[o]=s}return n}function _(r,e,n,o,i,a,s,u){var E=o.scaleToGeodeticSurface(r,y),l=o.scaleToGeodeticSurface(e,F),c=f.numberOfPoints(r,e,n),_=o.cartesianToCartographic(E,O),T=o.cartesianToCartographic(l,p),A=R(c,i,a);L.setEndPoints(_,T);var h=L.surfaceDistance/c,S=u;_.height=i;var d=o.cartographicToCartesian(_,g);t.pack(d,s,S),S+=3;for(var C=1;c>C;C++){var N=L.interpolateUsingSurfaceDistance(C*h,p);N.height=A[C],d=o.cartographicToCartesian(N,g),t.pack(d,s,S),S+=3}return S}var f={};f.numberOfPoints=function(r,e,n){var o=t.distance(r,e);return Math.ceil(o/n)};var T=new r;f.extractHeights=function(t,r){for(var e=t.length,n=new Array(e),o=0;e>o;o++){var i=t[o];n[o]=r.cartesianToCartographic(i,T).height}return n};var A=new l,h=new t,S=new t,d=new c(t.ZERO,0),C=new t,N=new c(t.ZERO,0),m=new t,I=new t,M=[],O=new r,p=new r,g=new t,y=new t,F=new t,L=new a;f.wrapLongitude=function(r,o){var i=[],a=[];if(n(r)&&r.length>0){o=e(o,l.IDENTITY);var u=l.inverseTransformation(o,A),E=l.multiplyByPoint(u,t.ZERO,h),R=l.multiplyByPointAsVector(u,t.UNIT_Y,S),_=c.fromPointNormal(E,R,d),f=l.multiplyByPointAsVector(u,t.UNIT_X,C),T=c.fromPointNormal(E,f,N),M=1;i.push(t.clone(r[0]));for(var O=i[0],p=r.length,g=1;p>g;++g){var y=r[g];if(c.getPointDistance(T,O)<0||c.getPointDistance(T,y)<0){var F=s.lineSegmentPlane(O,y,_,m);if(n(F)){var L=t.multiplyByScalar(R,5e-9,I);c.getPointDistance(_,O)<0&&t.negate(L,L),i.push(t.add(F,L,new t)),a.push(M+1),t.negate(L,L),i.push(t.add(F,L,new t)),M=1}}i.push(t.clone(r[g])),M++,O=y}a.push(M)}return{positions:i,lengths:a}};var v=E.EPSILON7;return f.removeDuplicates=function(r){var e=r.length;if(2>e)return r;var n,o,i;for(n=1;e>n&&(o=r[n-1],i=r[n],!t.equalsEpsilon(o,i,v));++n);if(n===e)return r;for(var a=r.slice(0,n);e>n;++n)i=r[n],t.equalsEpsilon(o,i,v)||(a.push(t.clone(i)),o=i);return a},f.generateArc=function(r){n(r)||(r={});var o=r.positions,a=o.length,s=e(r.ellipsoid,i.WGS84),l=e(r.height,0);if(1>a)return[];if(1===a){var c=s.scaleToGeodeticSurface(o[0],y);if(0!==l){var R=s.geodeticSurfaceNormal(c,g);t.multiplyByScalar(R,l,R),t.add(c,R,c)}return[c.x,c.y,c.z]}var T=r.minDistance;if(!n(T)){var A=e(r.granularity,E.RADIANS_PER_DEGREE);T=E.chordLength(A,s.maximumRadius)}var h,S=0;for(h=0;a-1>h;h++)S+=f.numberOfPoints(o[h],o[h+1],T);var d=3*(S+1),C=new Array(d),N=0,m=u(l);for(h=0;a-1>h;h++){var I=o[h],p=o[h+1],F=m?l[h]:l,L=m?l[h+1]:l;N=_(I,p,T,s,F,L,C,N)}M.length=0;var v=o[a-1],U=s.cartesianToCartographic(v,O);U.height=m?l[a-1]:l;var D=s.cartographicToCartesian(U,g);return t.pack(D,C,d-3),C},f.generateCartesianArc=function(r){for(var e=f.generateArc(r),n=e.length/3,o=new Array(n),i=0;n>i;i++)o[i]=t.unpack(e,3*i);return o},f}),define("Core/SimplePolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType"],function(t,r,e,n,o,i,a,s,u,E,l,c,R,_,f){"use strict";function T(t,r,n,o,i,a,s){var u,E=_.numberOfPoints(t,r,i),l=n.red,c=n.green,R=n.blue,f=n.alpha,T=o.red,A=o.green,h=o.blue,S=o.alpha;if(e.equals(n,o)){for(u=0;E>u;u++)a[s++]=e.floatToByte(l),a[s++]=e.floatToByte(c),a[s++]=e.floatToByte(R),a[s++]=e.floatToByte(f);return s}var d=(T-l)/E,C=(A-c)/E,N=(h-R)/E,m=(S-f)/E,I=s;for(u=0;E>u;u++)a[I++]=e.floatToByte(l+u*d),a[I++]=e.floatToByte(c+u*C),a[I++]=e.floatToByte(R+u*N),a[I++]=e.floatToByte(f+u*m);return I}var A=function(t){t=o(t,o.EMPTY_OBJECT);var n=t.positions,a=t.colors,u=o(t.colorsPerVertex,!1);this._positions=n,this._colors=a,this._colorsPerVertex=u,this._followSurface=o(t.followSurface,!0),this._granularity=o(t.granularity,R.RADIANS_PER_DEGREE),this._ellipsoid=o(t.ellipsoid,s.WGS84),this._workerName="createSimplePolylineGeometry";var E=1+n.length*r.packedLength;E+=i(a)?1+a.length*e.packedLength:1,this.packedLength=E+s.packedLength+3};A.pack=function(t,n,a){a=o(a,0);var u,E=t._positions,l=E.length;for(n[a++]=l,u=0;l>u;++u,a+=r.packedLength)r.pack(E[u],n,a);var c=t._colors;for(l=i(c)?c.length:0,n[a++]=l,u=0;l>u;++u,a+=e.packedLength)e.pack(c[u],n,a);s.pack(t._ellipsoid,n,a),a+=s.packedLength,n[a++]=t._colorsPerVertex?1:0,n[a++]=t._followSurface?1:0,n[a]=t._granularity},A.unpack=function(t,n,a){n=o(n,0);var u,E=t[n++],l=new Array(E);for(u=0;E>u;++u,n+=r.packedLength)l[u]=r.unpack(t,n);E=t[n++];var c=E>0?new Array(E):void 0;for(u=0;E>u;++u,n+=e.packedLength)c[u]=e.unpack(t,n);var R=s.unpack(t,n);n+=s.packedLength;var _=1===t[n++],f=1===t[n++],T=t[n];return i(a)?(a._positions=l,a._colors=c,a._ellipsoid=R,a._colorsPerVertex=_,a._followSurface=f,a._granularity=T,a):new A({positions:l,colors:c,ellipsoid:R,colorsPerVertex:_,followSurface:f,granularity:T})};var h=new Array(2),S=new Array(2),d={positions:h,height:S,ellipsoid:void 0,minDistance:void 0};return A.createGeometry=function(o){var a,s,A,C,N,m=o._positions,I=o._colors,M=o._colorsPerVertex,O=o._followSurface,p=o._granularity,g=o._ellipsoid,y=R.chordLength(p,g.maximumRadius),F=i(I)&&!M,L=m.length,v=0;if(O){var U=_.extractHeights(m,g),D=d;if(D.minDistance=y,D.ellipsoid=g,F){var P=0;for(a=0;L-1>a;a++)P+=_.numberOfPoints(m[a],m[a+1],y)+1;s=new Float64Array(3*P),C=new Uint8Array(4*P),D.positions=h,D.height=S;var B=0;for(a=0;L-1>a;++a){h[0]=m[a],h[1]=m[a+1],S[0]=U[a],S[1]=U[a+1];var w=_.generateArc(D);if(i(I)){var x=w.length/3;N=I[a];for(var G=0;x>G;++G)C[B++]=e.floatToByte(N.red),C[B++]=e.floatToByte(N.green),C[B++]=e.floatToByte(N.blue),C[B++]=e.floatToByte(N.alpha)}s.set(w,v),v+=w.length}}else if(D.positions=m,D.height=U,s=new Float64Array(_.generateArc(D)),i(I)){for(C=new Uint8Array(s.length/3*4),a=0;L-1>a;++a){var b=m[a],z=m[a+1],H=I[a],V=I[a+1];v=T(b,z,H,V,y,C,v)}var X=I[L-1];C[v++]=e.floatToByte(X.red),C[v++]=e.floatToByte(X.green),C[v++]=e.floatToByte(X.blue),C[v++]=e.floatToByte(X.alpha)}}else{A=F?2*L-2:L,s=new Float64Array(3*A),C=i(I)?new Uint8Array(4*A):void 0;var W=0,q=0;for(a=0;L>a;++a){var Y=m[a];if(F&&a>0&&(r.pack(Y,s,W),W+=3,N=I[a-1],C[q++]=e.floatToByte(N.red),C[q++]=e.floatToByte(N.green),C[q++]=e.floatToByte(N.blue),C[q++]=e.floatToByte(N.alpha)),F&&a===L-1)break;r.pack(Y,s,W),W+=3,i(I)&&(N=I[a],C[q++]=e.floatToByte(N.red),C[q++]=e.floatToByte(N.green),C[q++]=e.floatToByte(N.blue),C[q++]=e.floatToByte(N.alpha))}}var K=new l;K.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:s}),i(I)&&(K.color=new E({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:C,normalize:!0})),A=s.length/3;var k=2*(A-1),Z=c.createTypedArray(A,k),j=0;for(a=0;A-1>a;++a)Z[j++]=a,Z[j++]=a+1;return new u({attributes:K,indices:Z,primitiveType:f.LINES,boundingSphere:t.fromPoints(m)})},A}),define("Workers/createSimplePolylineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/SimplePolylineGeometry"],function(t,r,e){"use strict";function n(n,o){return t(o)&&(n=e.unpack(n,o)),n._ellipsoid=r.clone(n._ellipsoid),e.createGeometry(n)}return n})}();