/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},a.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},a.lerp=function(e,t,n){return(1-n)*e+n*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,n,r,a){a=t(a,r);var i=Math.abs(e-n);return a>=i||i<=r*Math.max(Math.abs(e),Math.abs(n))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var n=i[t-1],r=t;e>=r;r++)i.push(n*r);return i[e]},a.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)};i.fromSpherical=function(n,r){t(r)||(r=new i);var a=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(o),r},i.fromElements=function(e,n,r,a){return t(a)?(a.x=e,a.y=n,a.z=r,a):new i(e,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var n=i.dot(s,c),r=i.magnitude(i.cross(s,c,s));return Math.atan2(r,n)};var l=new i;i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):n.y<=n.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)},i.cross=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-r*s,f=r*u-a*o;return n.x=c,n.y=l,n.z=f,n},i.fromDegrees=function(e,t,n,r,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,n,r,o)};var f=new i,h=new i,d=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(n,r,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(r);f.x=c*Math.cos(n),f.y=c*Math.sin(n),f.z=Math.sin(r),f=i.normalize(f,f),i.multiplyComponents(s,f,h);var l=Math.sqrt(i.dot(f,h));return h=i.divideByScalar(h,l,h),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(h,f,u)},i.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=a.toRadians(e[o]);return i.fromRadiansArray(r,t,n)},i.fromRadiansArray=function(e,n,r){var a=e.length;t(r)?r.length=a/2:r=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=i.fromRadians(u,s,0,n,r[o/2])}return r},i.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=a.toRadians(e[o]),r[o+1]=a.toRadians(e[o+1]),r[o+2]=e[o+2];return i.fromRadiansArrayHeights(r,t,n)},i.fromRadiansArrayHeights=function(e,n,r){var a=e.length;t(r)?r.length=a/3:r=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=i.fromRadians(u,s,c,n,r[o/3])}return r},i.ZERO=r(new i(0,0,0)),i.UNIT_X=r(new i(1,0,0)),i.UNIT_Y=r(new i(0,1,0)),i.UNIT_Z=r(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r){this.longitude=e(t,0),this.latitude=e(n,0),this.height=e(r,0)};return i.fromRadians=function(n,r,a,o){return a=e(a,0),t(o)?(o.longitude=n,o.latitude=r,o.height=a,o):new i(n,r,a)},i.fromDegrees=function(e,t,n,r){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.longitude=e.longitude,n.latitude=e.latitude,n.height=e.height,n):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.longitude===n.longitude&&e.latitude===n.latitude&&e.height===n.height},i.equalsEpsilon=function(e,n,r){return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=r&&Math.abs(e.latitude-n.latitude)<=r&&Math.abs(e.height-n.height)<=r},i.ZERO=r(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,n)};a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,n){if(!r(t))return void 0;var a=t._radii;return r(n)?(e.clone(a,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new c(a.x,a.y,a.z)},c.fromCartesian3=function(e,t){return r(t)||(t=new c),r(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,r,a){a=n(a,0),e.pack(t._radii,r,a)},c.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return c.fromCartesian3(i,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,n){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},c.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var l=new e,f=new e;c.prototype.cartographicToCartesian=function(t,n){var a=l,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),r(n)||(n=new e),e.add(i,a,n)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var h=new e,d=new e,E=new e;c.prototype.cartesianToCartographic=function(n,a){var i=this.scaleToGeodeticSurface(n,d);if(!r(i))return void 0;var o=this.geodeticSurfaceNormal(i,h),s=e.subtract(n,i,E),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,n))*e.magnitude(s);return r(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var _=new e,m=new e;return c.prototype.scaleToGeodeticSurface=function(t,n){var a=t.x,i=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,f=s.z,h=a*a*c*c,d=i*i*l*l,E=o*o*f*f,p=h+d+E,y=Math.sqrt(1/p),R=e.multiplyByScalar(t,y,_);if(p<this._centerToleranceSquared)return isFinite(y)?e.clone(R,n):void 0;var T=this._oneOverRadiiSquared,v=T.x,A=T.y,S=T.z,N=m;N.x=R.x*v*2,N.y=R.y*A*2,N.z=R.z*S*2;var O,I,M,g,w,C,x,P,D,U,L,F=(1-y)*e.magnitude(t)/(.5*e.magnitude(N)),B=0;do{F-=B,M=1/(1+F*v),g=1/(1+F*A),w=1/(1+F*S),C=M*M,x=g*g,P=w*w,D=C*M,U=x*g,L=P*w,O=h*C+d*x+E*P-1,I=h*D*v+d*U*A+E*L*S;var z=-2*I;B=O/z}while(Math.abs(O)>u.EPSILON12);return r(n)?(n.x=a*M,n.y=i*g,n.z=o*w,n):new e(a*M,i*g,o*w)},c.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},c.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},c.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n){this.x=e(t,0),this.y=e(n,0)};i.fromElements=function(e,n,r){return t(r)?(r.x=e,r.y=n,r):new i(e,n)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r]=t.y},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)},i.ZERO=r(new i(0,0)),i.UNIT_X=r(new i(1,0)),i.UNIT_Y=r(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,a,i,o){"use strict";var u=function(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new e(i,o,u)},u.prototype.unproject=function(e,n){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,n,r,a){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(a,0)};r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.west=e[r++],a.south=e[r++],a.east=e[r++],a.north=e[r],a},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,a,i,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),n(o)?(o.west=e,o.south=r,o.east=a,o.north=i,o):new s(e,r,a,i)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];r=Math.min(r,l.longitude),a=Math.max(a,l.longitude),i=Math.min(i,l.latitude),o=Math.max(o,l.latitude)}return n(t)?(t.west=r,t.south=i,t.east=a,t.north=o,t):new s(r,i,a,o)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if((e.west<e.east||t.west<t.east)&&l>=f)return void 0;var h=Math.max(e.south,t.south),d=Math.min(e.north,t.north);return h>=d?void 0:n(r)?(r.west=l,r.south=h,r.east=f,r.north=d,r):new s(l,h,f,d)},s.contains=function(e,t){var n=t.longitude,r=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(i>n||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,a,o){r=t(r,i.WGS84),a=t(a,0),n(o)||(o=[]);var l=0,f=e.north,h=e.south,d=e.east,E=e.west,_=c;_.height=a,_.longitude=E,_.latitude=f,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.longitude=d,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.latitude=h,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.longitude=E,o[l]=r.cartographicToCartesian(_,o[l]),l++,0>f?_.latitude=f:h>0?_.latitude=h:_.latitude=0;for(var m=1;8>m;++m)_.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,_)&&(o[l]=r.cartographicToCartesian(_,o[l]),l++);return 0===_.latitude&&(_.longitude=E,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.longitude=d,o[l]=r.cartographicToCartesian(_,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,t,r,a){this.x=n(e,0),this.y=n(t,0),this.width=n(r,0),this.height=n(a,0)};s.fromPoints=function(e,t){if(r(t)||(t=new s),!r(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var n=e.length,a=e[0].x,i=e[0].y,o=e[0].x,u=e[0].y,c=1;n>c;c++){var l=e[c],f=l.x,h=l.y;a=Math.min(f,a),o=Math.max(f,o),i=Math.min(h,i),u=Math.max(h,u)}return t.x=a,t.y=i,t.width=o-a,t.height=u-i,t};var c=new i,l=new t,f=new t;return s.fromRectangle=function(t,a,i){if(r(i)||(i=new s),!r(t))return i.x=0,i.y=0,i.width=0,i.height=0,i;a=n(a,c);var o=a.project(u.southwest(t,l)),h=a.project(u.northeast(t,f));return e.subtract(h,o,h),i.x=o.x,i.y=o.y,i.width=h.x,i.height=h.y,i},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,t,n){r(n)||(n=new s);var a=Math.min(e.x,t.x),i=Math.min(e.y,t.y),o=Math.max(e.x+e.width,t.x+t.width),u=Math.max(e.y+e.height,t.y+t.height);return n.x=a,n.y=i,n.width=o-a,n.height=u-i,n},s.expand=function(e,t,n){n=s.clone(e,n);var r=t.x-n.x,a=t.y-n.y;return r>n.width?n.width=r:0>r&&(n.width-=r,n.x=t.x),a>n.height?n.height=a:0>a&&(n.height-=a,n.y=t.y),n},s.intersect=function(e,t){var n=e.x,r=e.y,a=t.x,i=t.y;return n>a+t.width||n+e.width<a||r+e.height<i||r>i+t.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var n={},r=function(t,r){e(n[t])||(n[t]=!0,console.log(r))};return r}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,n){this.start=e(t,0),this.stop=e(n,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r,a){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(a,0)};i.fromElements=function(e,n,r,a,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=a,o):new i(e,n,r,a)},i.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r++],a.w=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,s);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):n.y<=n.z?n.y<=n.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)&&a.equalsEpsilon(e.w,n.w,r,i)},i.ZERO=r(new i(0,0,0,0)),i.UNIT_X=r(new i(1,0,0,0)),i.UNIT_Y=r(new i(0,1,0,0)),i.UNIT_Z=r(new i(0,0,1,0)),i.UNIT_W=r(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function u(e){for(var t=0,n=0;3>n;++n){var r=e[c.getElementIndex(d[n],h[n])];t+=2*r*r}return Math.sqrt(t)}function s(e,t){for(var n=i.EPSILON15,r=0,a=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(d[o],h[o])]);u>r&&(a=o,r=u)}var s=1,l=0,f=h[a],E=d[a];if(Math.abs(e[c.getElementIndex(E,f)])>n){var _,m=e[c.getElementIndex(E,E)],p=e[c.getElementIndex(f,f)],y=e[c.getElementIndex(E,f)],R=(m-p)/2/y;_=0>R?-1/(-R+Math.sqrt(1+R*R)):1/(R+Math.sqrt(1+R*R)),s=1/Math.sqrt(1+_*_),l=_*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(f,f)]=t[c.getElementIndex(E,E)]=s,t[c.getElementIndex(E,f)]=l,t[c.getElementIndex(f,E)]=-l,t}var c=function(e,n,r,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},c.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new c),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,r,a){return r=t(r,0),n(a)||(a=new c),a[0]=e[r],a[1]=e[r+1],a[2]=e[r+2],a[3]=e[r+3],a[4]=e[r+4],a[5]=e[r+5],a[6]=e[r+6],a[7]=e[r+7],a[8]=e[r+8],a},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,d=e.w*e.w,E=r-u-f+d,_=2*(a-h),m=2*(i+l),p=2*(a+h),y=-r+u-f+d,R=2*(s-o),T=2*(i-l),v=2*(s+o),A=-r-u+f+d;return n(t)?(t[0]=E,t[1]=p,t[2]=T,t[3]=_,t[4]=y,t[5]=v,t[6]=m,t[7]=R,t[8]=A,t):new c(E,_,m,p,y,R,T,v,A)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new c(1,0,0,0,r,-a,0,a,r)},c.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new c(r,0,a,0,1,0,-a,0,r)},c.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(r,-a,0,a,r,0,0,0,1)},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[r+1],o=e[r+2];return n.x=a,n.y=i,n.z=o,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=3*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},c.getRow=function(e,t,n){
var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var f=new e;c.getMaximumScale=function(t){return c.getScale(t,f),e.maximumComponent(f)},c.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=f,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[3]*a+e[6]*i,u=e[1]*r+e[4]*a+e[7]*i,s=e[2]*r+e[5]*a+e[8]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},c.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var h=[1,0,0],d=[2,2,1],E=new c,_=new c;return c.computeEigenDecomposition=function(e,t){var r=i.EPSILON20,a=10,l=0,f=0;n(t)||(t={});for(var h=t.unitary=c.clone(c.IDENTITY,t.unitary),d=t.diagonal=c.clone(e,t.diagonal),m=r*o(d);a>f&&u(d)>m;)s(d,E),c.transpose(E,_),c.multiply(d,E,d),c.multiply(_,d,d),c.multiply(h,E,h),++l>2&&(++f,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},c.inverse=function(e,t){var n=e[0],a=e[1],o=e[2],u=e[3],s=e[4],l=e[5],f=e[6],h=e[7],d=e[8],E=c.determinant(e);if(Math.abs(E)<=i.EPSILON15)throw new r("matrix is not invertible");t[0]=s*d-h*l,t[1]=h*o-a*d,t[2]=a*l-s*o,t[3]=f*l-u*d,t[4]=n*d-f*o,t[5]=u*o-n*l,t[6]=u*h-f*s,t[7]=f*a-n*h,t[8]=n*s-u*a;var _=1/E;return c.multiplyByScalar(t,_,t)},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},c.IDENTITY=a(new c(1,0,0,0,1,0,0,0,1)),c.ZERO=a(new c(0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,a,i,o,u,s){"use strict";var c=function(e,t,r,a,i,o,u,s,c,l,f,h,d,E,_,m){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(E,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(_,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(h,0),this[15]=n(m,0)};c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=n(a,e.ZERO),r(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,a){r(a)||(a=new c);var i=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,h=t.x*t.w,d=t.y*t.y,E=t.y*t.z,_=t.y*t.w,m=t.z*t.z,p=t.z*t.w,y=t.w*t.w,R=s-d-m+y,T=2*(l-p),v=2*(f+_),A=2*(l+p),S=-s+d-m+y,N=2*(E-h),O=2*(f-_),I=2*(E+h),M=-s-d+m+y;return a[0]=R*i,a[1]=A*i,a[2]=O*i,a[3]=0,a[4]=T*o,a[5]=S*o,a[6]=I*o,a[7]=0,a[8]=v*u,a[9]=N*u,a[10]=M*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,h=new e;c.fromCamera=function(t,n){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,h),h);var u=f.x,s=f.y,d=f.z,E=l.x,_=l.y,m=l.z,p=h.x,y=h.y,R=h.z,T=a.x,v=a.y,A=a.z,S=u*-T+s*-v+d*-A,N=p*-T+y*-v+R*-A,O=E*T+_*v+m*A;return r(n)?(n[0]=u,n[1]=p,n[2]=-E,n[3]=0,n[4]=s,n[5]=y,n[6]=-_,n[7]=0,n[8]=d,n[9]=R,n[10]=-m,n[11]=0,n[12]=S,n[13]=N,n[14]=O,n[15]=1,n):new c(u,s,d,S,p,y,R,N,-E,-_,-m,O,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,n,r,a,i,o){var u=1/(t-e),s=1/(r-n),c=1/(i-a),l=-(t+e)*u,f=-(r+n)*s,h=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,n,r,a,i,o){var u=2*a/(t-e),s=2*a/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),f=-(i+a)/(i-a),h=-1,d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var o=2*a/(t-e),u=2*a/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,f=-1,h=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=h,i[15]=0,i},c.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,f=.5*(r-t),h=c,d=l,E=f,_=i+c,m=o+l,p=t+f,y=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=_,a[13]=m,a[14]=p,a[15]=y,a},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[r+1],o=e[r+2],u=e[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=4*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},c.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},c.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var d=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),n};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],d=e[10],E=e[11],_=e[12],m=e[13],p=e[14],y=e[15],R=t[0],T=t[1],v=t[2],A=t[3],S=t[4],N=t[5],O=t[6],I=t[7],M=t[8],g=t[9],w=t[10],C=t[11],x=t[12],P=t[13],D=t[14],U=t[15],L=r*R+u*T+f*v+_*A,F=a*R+s*T+h*v+m*A,B=i*R+c*T+d*v+p*A,z=o*R+l*T+E*v+y*A,b=r*S+u*N+f*O+_*I,G=a*S+s*N+h*O+m*I,q=i*S+c*N+d*O+p*I,W=o*S+l*N+E*O+y*I,X=r*M+u*g+f*w+_*C,V=a*M+s*g+h*w+m*C,H=i*M+c*g+d*w+p*C,Y=o*M+l*g+E*w+y*C,k=r*x+u*P+f*D+_*U,j=a*x+s*P+h*D+m*U,Z=i*x+c*P+d*D+p*U,K=o*x+l*P+E*D+y*U;return n[0]=L,n[1]=F,n[2]=B,n[3]=z,n[4]=b,n[5]=G,n[6]=q,n[7]=W,n[8]=X,n[9]=V,n[10]=H,n[11]=Y,n[12]=k,n[13]=j,n[14]=Z,n[15]=K,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],E=e[14],_=t[0],m=t[1],p=t[2],y=t[4],R=t[5],T=t[6],v=t[8],A=t[9],S=t[10],N=t[12],O=t[13],I=t[14],M=r*_+o*m+c*p,g=a*_+u*m+l*p,w=i*_+s*m+f*p,C=r*y+o*R+c*T,x=a*y+u*R+l*T,P=i*y+s*R+f*T,D=r*v+o*A+c*S,U=a*v+u*A+l*S,L=i*v+s*A+f*S,F=r*N+o*O+c*I+h,B=a*N+u*O+l*I+d,z=i*N+s*O+f*I+E;return n[0]=M,n[1]=g,n[2]=w,n[3]=0,n[4]=C,n[5]=x,n[6]=P,n[7]=0,n[8]=D,n[9]=U,n[10]=L,n[11]=0,n[12]=F,n[13]=B,n[14]=z,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],d=t[1],E=t[2],_=t[3],m=t[4],p=t[5],y=t[6],R=t[7],T=t[8],v=r*h+o*d+c*E,A=a*h+u*d+l*E,S=i*h+s*d+f*E,N=r*_+o*m+c*p,O=a*_+u*m+l*p,I=i*_+s*m+f*p,M=r*y+o*R+c*T,g=a*y+u*R+l*T,w=i*y+s*R+f*T;return n[0]=v,n[1]=A,n[2]=S,n[3]=0,n[4]=N,n[5]=O,n[6]=I,n[7]=0,n[8]=M,n[9]=g,n[10]=w,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=r*e[0]+a*e[4]+i*e[8]+e[12],u=r*e[1]+a*e[5]+i*e[9]+e[13],s=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var _=new e;c.multiplyByUniformScale=function(e,t,n){return _.x=t,_.y=t,_.z=t,c.multiplyByScale(e,_,n)},c.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*r+e[4]*a+e[8]*i+e[12]*o,s=e[1]*r+e[5]*a+e[9]*i+e[13]*o,c=e[2]*r+e[6]*a+e[10]*i+e[14]*o,l=e[3]*r+e[7]*a+e[11]*i+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i,u=e[1]*r+e[5]*a+e[9]*i,s=e[2]*r+e[6]*a+e[10]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i+e[12],u=e[1]*r+e[5]*a+e[9]*i+e[13],s=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new u,p=new u,y=new t,R=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,m),p,o.EPSILON7)&&t.equals(c.getRow(e,3,y),R))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],a=e[4],i=e[8],l=e[12],f=e[1],h=e[5],d=e[9],E=e[13],_=e[2],T=e[6],v=e[10],A=e[14],S=e[3],N=e[7],O=e[11],I=e[15],M=v*I,g=A*O,w=T*I,C=A*N,x=T*O,P=v*N,D=_*I,U=A*S,L=_*O,F=v*S,B=_*N,z=T*S,b=M*h+C*d+x*E-(g*h+w*d+P*E),G=g*f+D*d+F*E-(M*f+U*d+L*E),q=w*f+U*h+B*E-(C*f+D*h+z*E),W=P*f+L*h+z*d-(x*f+F*h+B*d),X=g*a+w*i+P*l-(M*a+C*i+x*l),V=M*r+U*i+L*l-(g*r+D*i+F*l),H=C*r+D*a+z*l-(w*r+U*a+B*l),Y=x*r+F*a+B*i-(P*r+L*a+z*i);M=i*E,g=l*d,w=a*E,C=l*h,x=a*d,P=i*h,D=r*E,U=l*f,L=r*d,F=i*f,B=r*h,z=a*f;var k=M*N+C*O+x*I-(g*N+w*O+P*I),j=g*S+D*O+F*I-(M*S+U*O+L*I),Z=w*S+U*N+B*I-(C*S+D*N+z*I),K=P*S+L*N+z*O-(x*S+F*N+B*O),J=w*v+P*A+g*T-(x*A+M*T+C*v),Q=L*A+M*_+U*v-(D*v+F*A+g*_),$=D*T+z*A+C*_-(B*A+w*_+U*T),ee=B*v+x*_+F*T-(L*T+z*v+P*_),te=r*b+a*G+i*q+l*W;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=b*te,n[1]=G*te,n[2]=q*te,n[3]=W*te,n[4]=X*te,n[5]=V*te,n[6]=H*te,n[7]=Y*te,n[8]=k*te,n[9]=j*te,n[10]=Z*te,n[11]=K*te,n[12]=J*te,n[13]=Q*te,n[14]=$*te,n[15]=ee*te,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],d=e[14],E=-n*f-r*h-a*d,_=-i*f-o*h-u*d,m=-s*f-c*h-l*d;return t[0]=n,t[1]=i,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=E,t[13]=_,t[14]=m,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";var a=function(t,n){this.normal=e.clone(t),this.distance=n};a.fromPointNormal=function(n,r,i){var o=-e.dot(r,n);return t(i)?(e.clone(r,i.normal),i.distance=o,i):new a(r,o)};var i=new e;return a.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,i),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new a(o,u)},a.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},a.ORIGIN_XY_PLANE=r(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=r(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=r(new a(e.UNIT_Y,0)),a}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,f,h){"use strict";var d=function(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)},E=new e,_=new e,m=new e,p=new e,y=new e,R=new e,T=new e,v=new e,A=new e,S=new e,N=new e,O=new e;d.fromPoints=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var a=e.clone(t[0],T),i=e.clone(a,E),o=e.clone(a,_),u=e.clone(a,m),s=e.clone(a,p),c=e.clone(a,y),l=e.clone(a,R),f=t.length,h=1;f>h;h++){e.clone(t[h],a);var I=a.x,M=a.y,g=a.z;I<i.x&&e.clone(a,i),I>s.x&&e.clone(a,s),M<o.y&&e.clone(a,o),M>c.y&&e.clone(a,c),g<u.z&&e.clone(a,u),g>l.z&&e.clone(a,l)}var w=e.magnitudeSquared(e.subtract(s,i,v)),C=e.magnitudeSquared(e.subtract(c,o,v)),x=e.magnitudeSquared(e.subtract(l,u,v)),P=i,D=s,U=w;C>U&&(U=C,P=o,D=c),x>U&&(U=x,P=u,D=l);var L=A;L.x=.5*(P.x+D.x),L.y=.5*(P.y+D.y),L.z=.5*(P.z+D.z);var F=e.magnitudeSquared(e.subtract(D,L,v)),B=Math.sqrt(F),z=S;z.x=i.x,z.y=o.y,z.z=u.z;var b=N;b.x=s.x,b.y=c.y,b.z=l.z;var G=e.multiplyByScalar(e.add(z,b,v),.5,O),q=0;for(h=0;f>h;h++){e.clone(t[h],a);var W=e.magnitude(e.subtract(a,G,v));W>q&&(q=W);var X=e.magnitudeSquared(e.subtract(a,L,v));if(X>F){var V=Math.sqrt(X);B=.5*(B+V),F=B*B;var H=V-B;L.x=(B*L.x+H*a.x)/V,L.y=(B*L.y+H*a.y)/V,L.z=(B*L.z+H*a.z)/V}}return q>B?(e.clone(L,n.center),n.radius=B):(e.clone(G,n.center),n.radius=q),n};var I=new u,M=new e,g=new e,w=new t,C=new t;d.fromRectangle2D=function(e,t,n){return d.fromRectangleWithHeights2D(e,t,0,0,n)},d.fromRectangleWithHeights2D=function(t,a,i,o,u){if(r(u)||(u=new d),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,I),h.southwest(t,w),w.height=i,h.northeast(t,C),C.height=o;var s=a.project(w,M),c=a.project(C,g),l=c.x-s.x,f=c.y-s.y,E=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+E*E);var _=u.center;return _.x=s.x+.5*l,_.y=s.y+.5*f,_.z=s.z+.5*E,u};var x=[];d.fromRectangle3D=function(e,t,a,i){t=n(t,o.WGS84),a=n(a,0);var u;return r(e)&&(u=h.subsample(e,t,a,x)),d.fromPoints(u,i)},d.fromVertices=function(t,a,i,o){if(r(o)||(o=new d),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=n(a,e.ZERO),i=n(i,3);var u=T;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,E),c=e.clone(u,_),l=e.clone(u,m),f=e.clone(u,p),h=e.clone(u,y),I=e.clone(u,R),M=t.length,g=0;M>g;g+=i){var w=t[g]+a.x,C=t[g+1]+a.y,x=t[g+2]+a.z;u.x=w,u.y=C,u.z=x,w<s.x&&e.clone(u,s),w>f.x&&e.clone(u,f),C<c.y&&e.clone(u,c),C>h.y&&e.clone(u,h),x<l.z&&e.clone(u,l),x>I.z&&e.clone(u,I)}var P=e.magnitudeSquared(e.subtract(f,s,v)),D=e.magnitudeSquared(e.subtract(h,c,v)),U=e.magnitudeSquared(e.subtract(I,l,v)),L=s,F=f,B=P;D>B&&(B=D,L=c,F=h),U>B&&(B=U,L=l,F=I);var z=A;z.x=.5*(L.x+F.x),z.y=.5*(L.y+F.y),z.z=.5*(L.z+F.z);var b=e.magnitudeSquared(e.subtract(F,z,v)),G=Math.sqrt(b),q=S;q.x=s.x,q.y=c.y,q.z=l.z;var W=N;W.x=f.x,W.y=h.y,W.z=I.z;var X=e.multiplyByScalar(e.add(q,W,v),.5,O),V=0;for(g=0;M>g;g+=i){u.x=t[g]+a.x,u.y=t[g+1]+a.y,u.z=t[g+2]+a.z;var H=e.magnitude(e.subtract(u,X,v));H>V&&(V=H);var Y=e.magnitudeSquared(e.subtract(u,z,v));if(Y>b){var k=Math.sqrt(Y);G=.5*(G+k),b=G*G;var j=k-G;z.x=(G*z.x+j*u.x)/k,z.y=(G*z.y+j*u.y)/k,z.z=(G*z.z+j*u.z)/k}}return V>G?(e.clone(z,o.center),o.radius=G):(e.clone(X,o.center),o.radius=V),o},d.fromCornerPoints=function(t,n,a){r(a)||(a=new d);var i=a.center;return e.add(t,n,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,n),a},d.fromEllipsoid=function(t,n){return r(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;d.fromBoundingSpheres=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=t.length;if(1===a)return d.clone(t[0],n);if(2===a)return d.union(t[0],t[1],n);for(var i=[],o=0;a>o;o++)i.push(t[o].center);n=d.fromPoints(i,n);var u=n.center,s=n.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return n.radius=s,n},d.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,r){r=n(r,0);var a=e.center;t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius},d.unpack=function(e,t,a){t=n(t,0),r(a)||(a=new d);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var D=new e,U=new e;d.union=function(t,n,a){r(a)||(a=new d);var i=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,i,D),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return n.clone(a),a;var f=.5*(o+l+s),h=e.multiplyByScalar(c,(-o+f)/l,U);return e.add(h,i,h),e.clone(h,a.center),a.radius=f,a};var L=new e;d.expand=function(t,n,r){r=d.clone(t,r);var a=e.magnitude(e.subtract(n,r.center,L));return a>r.radius&&(r.radius=a),r},d.intersectPlane=function(t,n){var r=t.center,a=t.radius,i=n.normal,o=e.dot(i,r)+n.distance;return-a>o?s.OUTSIDE:a>o?s.INTERSECTING:s.INSIDE},d.transform=function(e,t,n){return r(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var F=new e;d.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,F);return e.magnitudeSquared(r)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var B=new e;d.computePlaneDistances=function(t,n,a,i){r(i)||(i=new c);var o=e.subtract(t.center,n,B),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var z=new e,b=new e,G=new e,q=new e,W=new e,X=new t,V=new Array(8),H=0;8>H;++H)V[H]=new e;var Y=new u;return d.projectTo2D=function(t,r,a){r=n(r,Y);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,z),c=e.cross(e.UNIT_Z,s,b);e.normalize(c,c);var l=e.cross(s,c,G);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,W),h=e.negate(c,q),E=V,_=E[0];e.add(s,l,_),e.add(_,c,_),_=E[1],e.add(s,l,_),e.add(_,h,_),_=E[2],e.add(s,f,_),e.add(_,h,_),_=E[3],e.add(s,f,_),e.add(_,c,_),e.negate(s,s),_=E[4],e.add(s,l,_),e.add(_,c,_),_=E[5],e.add(s,l,_),e.add(_,h,_),_=E[6],e.add(s,f,_),e.add(_,h,_),_=E[7],e.add(s,f,_),e.add(_,c,_);for(var m=E.length,p=0;m>p;++p){var y=E[p];e.add(o,y,y);var R=i.cartesianToCartographic(y,X);r.project(R,y)}a=d.fromPoints(E,a),o=a.center;var T=o.x,v=o.y,A=o.z;return o.x=A,o.y=T,o.z=v,a},d.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},d.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,n){return d.computePlaneDistances(this,e,t,n)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,
RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?r.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(r.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[r.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function a(){if(!t(m)){m=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,p=r(e[1]))}return m}function i(){return a()&&p}function o(){if(!t(y)&&(y=!1,!a()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,R=r(e[1]))}return y}function u(){return o()&&R}function s(){if(!t(T)){T=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(T=!0,v=r(e[1]),v.isNightly=!!e[2])}return T}function c(){return s()&&v}function l(){if(!t(A)){A=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,S=r(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,S=r(e[1])))}return A}function f(){return l()&&S}function h(){if(!t(N)){N=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(N=!0,O=r(e[1]))}return N}function d(){return t(I)||(I=/Windows/i.test(navigator.appVersion)),I}function E(){return h()&&O}function _(){return t(M)||(M=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),M}var m,p,y,R,T,v,A,S,N,O,I,M,g={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:E,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:_};return g.supportsFullscreen=function(){return n.supportsFullscreen()},g.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},g.supportsWebWorkers=function(){return"undefined"!=typeof Worker},g}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,a,i){"use strict";if(!a.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return n(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,n,a,i){switch(a=t(a,0),i=t(i,(n.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(n,a,i);case o.UNSIGNED_BYTE:return new Uint8Array(n,a,i);case o.SHORT:return new Int16Array(n,a,i);case o.UNSIGNED_SHORT:return new Uint16Array(n,a,i);case o.FLOAT:return new Float32Array(n,a,i);case o.DOUBLE:return new Float64Array(n,a,i);default:throw new r("componentDatatype is not a valid value.")}},i(o)}),define("Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var n={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===n.POINTS||e===n.LINES||e===n.LINE_LOOP||e===n.LINE_STRIP||e===n.TRIANGLES||e===n.TRIANGLE_STRIP||e===n.TRIANGLE_FAN}};return t(n)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,a){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var r=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return r}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,n,r){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,r):new Uint16Array(t,n,r)},r(i)}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,t,n,r,a,i,o){"use strict";var u=function(r,a,i){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i};u.fromPoints=function(t,r){if(n(r)||(r=new u),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,i=t[0].y,o=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;f>h;h++){var d=t[h],E=d.x,_=d.y,m=d.z;a=Math.min(E,a),s=Math.max(E,s),i=Math.min(_,i),c=Math.max(_,c),o=Math.min(m,o),l=Math.max(m,l)}var p=r.minimum;p.x=a,p.y=i,p.z=o;var y=r.maximum;y.x=s,y.y=c,y.z=l;var R=e.add(p,y,r.center);return e.multiplyByScalar(R,.5,R),r},u.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new u(t.minimum,t.maximum):void 0},u.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var s=new e;return u.intersectPlane=function(t,n){s=e.subtract(t.maximum,t.minimum,s);var r=e.multiplyByScalar(s,.5,s),a=n.normal,o=r.x*Math.abs(a.x)+r.y*Math.abs(a.y)+r.z*Math.abs(a.z),u=e.dot(t.center,a)+n.distance;return u-o>0?i.INSIDE:0>u+o?i.OUTSIDE:i.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var a=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(n)))<r?0:a}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,a){var i;if(0===e)return 0===r?[]:[-a/r];if(0===r){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-r/e,0>i?[i,0]:[0,i];var c=r*r,l=4*e*a,f=n(c,-l,t.EPSILON14);if(0>f)return[];var h=-.5*n(r,t.sign(r)*Math.sqrt(f),t.EPSILON14);return r>0?[h/e,a/h]:[a/h,h/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var a,i,o=e,u=t/3,s=n/3,c=r,l=o*s,f=u*c,h=u*u,d=s*s,E=o*s-h,_=o*c-u*s,m=u*c-d,p=4*E*m-_*_;if(0>p){var y,R,T;h*f>=l*d?(y=o,R=E,T=-2*u*E+o*_):(y=c,R=m,T=-c*_+2*s*m);var v=0>T?-1:1,A=-v*Math.abs(y)*Math.sqrt(-p);i=-T+A;var S=i/2,N=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),O=i===A?-N:-R/N;return a=0>=R?N+O:-T/(N*N+O*O+R),h*f>=l*d?[(a-u)/o]:[-c/(a+s)]}var I=E,M=-2*u*E+o*_,g=m,w=-c*_+2*s*m,C=Math.sqrt(p),x=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*C,-M)/3);a=2*Math.sqrt(-I);var D=Math.cos(P);i=a*D;var U=a*(-D/2-x*Math.sin(P)),L=i+U>2*u?i-u:U-u,F=o,B=L/F;P=Math.abs(Math.atan2(c*C,-w)/3),a=2*Math.sqrt(-g),D=Math.cos(P),i=a*D,U=a*(-D/2-x*Math.sin(P));var z=-c,b=2*s>i+U?i+s:U+s,G=z/b,q=F*b,W=-L*b-F*z,X=L*z,V=(s*W-u*X)/(-u*W+s*q);return V>=B?G>=B?G>=V?[B,V,G]:[B,G,V]:[G,B,V]:G>=B?[V,B,G]:G>=V?[V,G,B]:[G,V,B]}var r={};return r.computeDiscriminant=function(e,t,n,r){var a=e*e,i=t*t,o=n*n,u=r*r,s=18*e*t*n*r+i*o-27*a*u-4*(e*o*n+i*t*r);return s},r.computeRealRoots=function(e,r,a,i){var o,u;if(0===e)return t.computeRealRoots(r,a,i);if(0===r){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,a,i)}return 0===a?0===i?(u=-r/e,0>u?[u,0,0]:[0,0,u]):n(e,r,0,i):0===i?(o=t.computeRealRoots(e,r,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,a,i)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<n.EPSILON14){var E=r.computeRealRoots(1,s,l);if(2===E.length){var _,m=E[0],p=E[1];if(m>=0&&p>=0){var y=Math.sqrt(m),R=Math.sqrt(p);return[h-R,h-y,h+y,h+R]}if(m>=0&&0>p)return _=Math.sqrt(m),[h-_,h+_];if(0>m&&p>=0)return _=Math.sqrt(p),[h-_,h+_]}return[]}if(d>0){var T=Math.sqrt(d),v=(s+d-c/T)/2,A=(s+d+c/T)/2,S=r.computeRealRoots(1,T,v),N=r.computeRealRoots(1,-T,A);return 0!==S.length?(S[0]+=h,S[1]+=h,0!==N.length?(N[0]+=h,N[1]+=h,S[1]<=N[0]?[S[0],S[1],N[0],N[1]]:N[1]<=S[0]?[N[0],N[1],S[0],S[1]]:S[0]>=N[0]&&S[1]<=N[1]?[N[0],S[0],S[1],N[1]]:N[0]>=S[0]&&N[1]<=S[1]?[S[0],N[0],N[1],S[1]]:S[0]>N[0]&&S[0]<N[1]?[N[0],S[0],N[1],S[1]]:[S[0],N[0],S[1],N[1]]):S):0!==N.length?(N[0]+=h,N[1]+=h,N):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,h=c*o-i*a*t+u,d=e.computeRealRoots(1,l,f,h);if(d.length>0){var E,_,m=d[0],p=a-m,y=p*p,R=t/2,T=p/2,v=y-4*o,A=y+4*Math.abs(o),S=c-4*m,N=c+4*Math.abs(m);if(0>m||S*A>v*N){var O=Math.sqrt(S);E=O/2,_=0===O?0:(t*T-i)/O}else{var I=Math.sqrt(v);E=0===I?0:(t*T-i)/I,_=I/2}var M,g;0===R&&0===E?(M=0,g=0):n.sign(R)===n.sign(E)?(M=R+E,g=m/M):(g=R-E,M=m/g);var w,C;0===T&&0===_?(w=0,C=0):n.sign(T)===n.sign(_)?(w=T+_,C=o/w):(C=T-_,w=o/C);var x=r.computeRealRoots(1,M,w),P=r.computeRealRoots(1,g,C);if(0!==x.length)return 0!==P.length?x[1]<=P[0]?[x[0],x[1],P[0],P[1]]:P[1]<=x[0]?[P[0],P[1],x[0],x[1]]:x[0]>=P[0]&&x[1]<=P[1]?[P[0],x[0],x[1],P[1]]:P[0]>=x[0]&&P[1]<=x[1]?[x[0],P[0],P[1],x[1]]:x[0]>P[0]&&x[0]<P[1]?[P[0],x[0],P[1],x[1]]:[x[0],P[0],x[1],P[1]]:x;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=n*n,l=c*n,f=r*r,h=f*r,d=a*a,E=d*a,_=u*c*f-4*s*h-4*e*l*f+18*e*t*n*h-27*i*f*f+256*o*E+a*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*f+144*i*n*f)+d*(144*e*u*n-27*u*u-128*i*c-192*i*t*r);return _},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,f=u/t,h=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>f?d+1:d,d+=0>h?d+1:d){case 0:return a(c,l,f,h);case 1:return i(c,l,f,h);case 2:return i(c,l,f,h);case 3:return a(c,l,f,h);case 4:return a(c,l,f,h);case 5:return i(c,l,f,h);case 6:return a(c,l,f,h);case 7:return a(c,l,f,h);case 8:return i(c,l,f,h);case 9:return a(c,l,f,h);case 10:return a(c,l,f,h);case 11:return i(c,l,f,h);case 12:return a(c,l,f,h);case 13:return a(c,l,f,h);case 14:return a(c,l,f,h);case 15:return a(c,l,f,h);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a=function(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r};return a.getPoint=function(t,r,a){return n(a)||(a=new e),a=e.multiplyByScalar(t.direction,r,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(t,r,a,o,u){u=n(u,!1);var s,c,l,f,h,d=t.origin,E=t.direction,_=e.subtract(a,r,m),v=e.subtract(o,r,p),A=e.cross(E,v,y),S=e.dot(_,A);if(u){if(S<i.EPSILON6)return void 0;if(s=e.subtract(d,r,R),l=e.dot(s,A),0>l||l>S)return void 0;if(c=e.cross(s,_,T),f=e.dot(E,c),0>f||l+f>S)return void 0;h=e.dot(v,c)/S}else{if(Math.abs(S)<i.EPSILON6)return void 0;var N=1/S;if(s=e.subtract(d,r,R),l=e.dot(s,A)*N,0>l||l>1)return void 0;if(c=e.cross(s,_,T),f=e.dot(E,c)*N,0>f||l+f>1)return void 0;h=e.dot(v,c)*N}return h}function f(e,t,n,r){var a=t*t-4*e*n;if(0>a)return void 0;if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);return 0===c?void 0:(r.root0=r.root1=c,r)}function h(t,n,a){r(a)||(a={});var i=t.origin,o=t.direction,u=n.center,s=n.radius*n.radius,c=e.subtract(i,u,y),l=e.dot(o,o),h=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,E=f(l,h,d,A);return r(E)?(a.start=E.root0,a.stop=E.root1,a):void 0}function d(e,t,n){var r=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function E(t,n,r,a,c){var l,f=a*a,h=c*c,E=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*h,_=c*(a*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+n.y),m=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*h+a*n.x+r,p=h*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),y=c*(a*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+n.z),R=[];if(0===y&&0===p){if(l=u.computeRealRoots(E,_,m),0===l.length)return R;var T=l[0],v=Math.sqrt(Math.max(1-T*T,0));if(R.push(new e(a,c*T,c*-v)),R.push(new e(a,c*T,c*v)),2===l.length){var A=l[1],S=Math.sqrt(Math.max(1-A*A,0));R.push(new e(a,c*A,c*-S)),R.push(new e(a,c*A,c*S))}return R}var N=y*y,O=p*p,I=E*E,M=y*p,g=I+O,w=2*(_*E+M),C=2*m*E+_*_-O+N,x=2*(m*_-M),P=m*m-N;if(0===g&&0===w&&0===C&&0===x)return R;l=s.computeRealRoots(g,w,C,x,P);var D=l.length;if(0===D)return R;for(var U=0;D>U;++U){var L,F=l[U],B=F*F,z=Math.max(1-B,0),b=Math.sqrt(z);L=i.sign(E)===i.sign(m)?d(E*B+m,_*F,i.EPSILON12):i.sign(m)===i.sign(_*F)?d(E*B,_*F+m,i.EPSILON12):d(E*B+_*F,m,i.EPSILON12);var G=d(p*F,y,i.EPSILON15),q=L*G;0>q?R.push(new e(a,c*F,c*b)):q>0?R.push(new e(a,c*F,c*-b)):0!==b?(R.push(new e(a,c*F,c*-b)),R.push(new e(a,c*F,c*b)),++U):R.push(new e(a,c*F,c*b))}return R}var _={};_.rayPlane=function(t,n,a){r(a)||(a=new e);var o=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-n.distance-e.dot(s,o))/c;return 0>l?void 0:(a=e.multiplyByScalar(u,l,a),e.add(o,a,a))};var m=new e,p=new e,y=new e,R=new e,T=new e;_.rayTriangle=function(t,n,a,i,o,u){var s=l(t,n,a,i,o);return!r(s)||0>s?void 0:(r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var v=new c;_.lineSegmentTriangle=function(t,n,a,i,o,u,s){var c=v;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!r(f)||0>f||f>e.distance(t,n)?void 0:(r(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var A={root0:0,root1:0};_.raySphere=function(e,t,n){return n=h(e,t,n),!r(n)||n.stop<0?void 0:(n.start=Math.max(n.start,0),n)};var S=new c;_.lineSegmentSphere=function(t,n,a,i){var o=S,u=(e.clone(t,o.origin),e.subtract(n,t,o.direction)),s=e.magnitude(u);return e.normalize(u,u),i=h(o,a,i),!r(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var N=new e,O=new e;_.rayEllipsoid=function(t,n){var r,a,i,o,u,s=n.oneOverRadii,c=e.multiplyComponents(s,t.origin,N),l=e.multiplyComponents(s,t.direction,O),f=e.magnitudeSquared(c),h=e.dot(c,l);if(f>1){if(h>=0)return void 0;var d=h*h;if(r=f-1,a=e.magnitudeSquared(l),i=a*r,i>d)return void 0;if(d>i){o=h*h-i,u=-h+Math.sqrt(o);var E=u/a,_=r/u;return _>E?{start:E,stop:_}:{start:_,stop:E}}var m=Math.sqrt(r/a);return{start:m,stop:m}}return 1>f?(r=f-1,a=e.magnitudeSquared(l),i=a*r,o=h*h-i,u=-h+Math.sqrt(o),{start:0,stop:u/a}):0>h?(a=e.magnitudeSquared(l),{start:0,stop:-h/a}):void 0};var I=new e,M=new e,g=new e,w=new e,C=new e,x=new o,P=new o,D=new o,U=new o,L=new o,F=new o,B=new o,z=new e,b=new e,G=new t;_.grazingAltitudeLocation=function(t,n){var a=t.origin,u=t.direction,s=n.geodeticSurfaceNormal(a,I);if(e.dot(u,s)>=0)return a;var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(u,I),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,w),d=e.normalize(e.cross(h,f,M),M),_=e.normalize(e.cross(f,d,g),g),m=x;m[0]=f.x,m[1]=f.y,m[2]=f.z,m[3]=d.x,m[4]=d.y,m[5]=d.z,m[6]=_.x,m[7]=_.y,m[8]=_.z;var p=o.transpose(m,P),y=o.fromScale(n.radii,D),R=o.fromScale(n.oneOverRadii,U),T=L;T[0]=0,T[1]=-u.z,T[2]=u.y,T[3]=u.z,T[4]=0,T[5]=-u.x,T[6]=-u.y,T[7]=u.x,T[8]=0;var v,A,S=o.multiply(o.multiply(p,R,F),T,F),N=o.multiply(o.multiply(S,y,B),m,B),O=o.multiplyByVector(S,a,C),q=E(N,e.negate(O,I),0,0,1),W=q.length;if(W>0){for(var X=e.clone(e.ZERO,b),V=Number.NEGATIVE_INFINITY,H=0;W>H;++H){v=o.multiplyByVector(y,o.multiplyByVector(m,q[H],z),z);var Y=e.normalize(e.subtract(v,a,w),w),k=e.dot(Y,u);k>V&&(V=k,X=e.clone(v,X))}var j=n.cartesianToCartographic(X,G);return V=i.clamp(V,0,1),A=e.magnitude(e.subtract(X,a,w))*Math.sqrt(1-V*V),A=c?-A:A,j.height=A,n.cartographicToCartesian(j,new e)}return void 0};var q=new e;return _.lineSegmentPlane=function(t,n,a,o){r(o)||(o=new e);var u=e.subtract(n,t,q),s=a.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),f=-(a.distance+l)/c;return 0>f||f>1?void 0:(e.multiplyByScalar(u,f,o),e.add(t,o,o),o)},_.trianglePlaneIntersection=function(t,n,r,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,n)+o<0,c=e.dot(i,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if((1===l||2===l)&&(f=new e,h=new e),1===l){if(u)return _.lineSegmentPlane(t,n,a,f),_.lineSegmentPlane(t,r,a,h),{positions:[t,n,r,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return _.lineSegmentPlane(n,r,a,f),_.lineSegmentPlane(n,t,a,h),{positions:[t,n,r,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return _.lineSegmentPlane(r,t,a,f),_.lineSegmentPlane(r,n,a,h),{positions:[t,n,r,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return _.lineSegmentPlane(n,t,a,f),_.lineSegmentPlane(r,t,a,h),{positions:[t,n,r,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return _.lineSegmentPlane(r,n,a,f),_.lineSegmentPlane(t,n,a,h),{positions:[t,n,r,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return _.lineSegmentPlane(t,r,a,f),_.lineSegmentPlane(n,r,a,h),{positions:[t,n,r,f,h],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},_}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,a){return t(e).then(n,r,a)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=a(e),t}function n(t){return e(t,i)}function r(e){this.then=e}function a(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return i(r)}});return n}function i(e){var n=new r(function(n,r){try{return r?t(r(e)):i(e)}catch(a){return i(a)}});return n}function o(){function e(e,t,n){return h(e,t,n)}function n(e){return E(e)}function a(e){return E(i(e))}function u(e){return d(e)}var s,c,l,f,h,d,E;return c=new r(e),s={then:e,resolve:n,reject:a,progress:u,promise:c,resolver:{resolve:n,reject:a,progress:u}},l=[],f=[],h=function(e,t,n){var r,a;return r=o(),a="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,a)}),f.push(a),r.promise},d=function(e){return _(f,e),e},E=function(e){return e=t(e),h=e.then,E=t,d=p,_(l,e),f=l=v,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,a,i){return m(2,arguments),e(t,function(t){function u(e){_(e)}function s(e){E(e)}var c,l,f,h,d,E,_,m,y,R;if(y=t.length>>>0,c=Math.max(0,Math.min(n,y)),f=[],l=y-c+1,h=[],d=o(),c)for(m=d.progress,_=function(e){h.push(e),--l||(E=_=p,d.reject(h))},E=function(e){f.push(e),--c||(E=_=p,d.resolve(f))},R=0;y>R;++R)R in t&&e(t[R],s,u,m);else d.resolve(f);return d.then(r,a,i)})}function c(e,t,n,r){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,n,r)}function l(e,t,n,r){return m(1,arguments),h(e,y).then(t,n,r)}function f(){return h(arguments,y)}function h(t,n){return e(t,function(t){var r,a,i,u,s,c;if(i=a=t.length>>>0,r=[],c=o(),i)for(u=function(t,a){e(t,n).then(function(e){r[a]=e,--i||c.resolve(r)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(r);return c.promise})}function d(t,n){var r=T.call(arguments,1);return e(t,function(t){var a;return a=t.length,r[0]=function(t,r,i){return e(t,function(t){return e(r,function(e){return n(t,e,i,a)})})},R.apply(t,r)});
}function E(t,n,r){var a=arguments.length>2;return e(t,function(e){return e=a?r:e,n.resolve(e),e},function(e){return n.reject(e),i(e)},n.progress)}function _(e,t){for(var n,r=0;n=e[r++];)n(t)}function m(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function p(){}function y(e){return e}var R,T,v;return e.defer=o,e.resolve=t,e.reject=n,e.join=f,e.all=l,e.map=h,e.reduce=d,e.any=c,e.some=s,e.chain=E,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(v,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(v,t)})})}},T=[].slice,R=[].reduce||function(e){var t,n,r,a,i;if(i=0,t=Object(this),a=t.length>>>0,n=arguments,n.length<=1)for(;;){if(i in t){r=t[i++];break}if(++i>=a)throw new TypeError}else r=n[1];for(;a>i;++i)i in t&&(r=e(r,t[i],i,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var n=function(e,t,n){for(var r,a,i=0,o=e.length-1;o>=i;)if(r=~~((i+o)/2),a=n(e[r],t),0>a)i=r+1;else{if(!(a>0))return r;o=r-1}return~(o+1)};return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],a=function(e,t,n,r){n||(n=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e},i=function(e,t,n,r,i,o){var u=r-e.length;return u>0&&(e=n||!i?a(e,r,o,n):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+a(c.toString(t),u||0,"0",!1),i(e,n,r,o,s)},u=function(e,t,n,r,a,o){return null!=r&&(e=e.slice(0,r)),i(e,"",t,n,a,o)},s=function(e,r,s,c,l,f,h){var d,E,_,m,p;if("%%"==e)return"%";for(var y=!1,R="",T=!1,v=!1,A=" ",S=s.length,N=0;s&&S>N;N++)switch(s.charAt(N)){case" ":R=" ";break;case"+":R="+";break;case"-":y=!0;break;case"'":A=s.charAt(N+1);break;case"0":T=!0;break;case"#":v=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,y=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[n++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,p=r?t[r.slice(0,-1)]:t[n++],h){case"s":return u(String(p),y,c,f,T,A);case"c":return u(String.fromCharCode(+p),y,c,f,T);case"b":return o(p,2,v,y,c,f,T);case"o":return o(p,8,v,y,c,f,T);case"x":return o(p,16,v,y,c,f,T);case"X":return o(p,16,v,y,c,f,T).toUpperCase();case"u":return o(p,10,v,y,c,f,T);case"i":case"d":return d=+p||0,d=Math.round(d-d%1),E=0>d?"-":R,p=E+a(String(Math.abs(d)),f,"0",!1),i(p,E,y,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=+p,E=0>d?"-":R,_=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],p=E+Math.abs(d)[_](f),i(p,E,y,c,T)[m]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,n,r,a,i,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t){return w.compare(e.julianDate,t.julianDate)}function f(e){y.julianDate=e;var n=w.leapSeconds,r=t(n,y,l);0>r&&(r=~r),r>=n.length&&(r=n.length-1);var a=n[r].offset;if(r>0){var i=w.secondsDifference(n[r].julianDate,e);i>a&&(r--,a=n[r].offset)}w.addSeconds(e,a,e)}function h(e,n){y.julianDate=e;var r=w.leapSeconds,a=t(r,y,l);if(0>a&&(a=~a),0===a)return w.addSeconds(e,-r[0].offset,n);if(a>=r.length)return w.addSeconds(e,-r[a-1].offset,n);var i=w.secondsDifference(r[a].julianDate,e);return 0===i?w.addSeconds(e,-r[a].offset,n):1>=i?void 0:w.addSeconds(e,-r[--a].offset,n)}function d(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,0>t&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function E(e,t,n,r,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,0>r&&(r+=24);var f=i+(r*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}var _=new i,m=[31,28,31,30,31,30,31,31,30,31,30,31],p=29,y=new u,R=/^(\d{4})$/,T=/^(\d{4})-(\d{2})$/,v=/^(\d{4})-?(\d{3})$/,A=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,S=/^(\d{4})-?(\d{2})-?(\d{2})$/,N=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+N.source,I=/^(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,M=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,g="Invalid ISO 8601 date.",w=function(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,d(a,t,this),r===c.UTC&&f(this)};w.fromDate=function(e,t){var n=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(d(n[0],n[1],t),f(t),t):new w(n[0],n[1],c.UTC)},w.fromIso8601=function(e,t){e=e.replace(",",".");var n,i,u,s=e.split("T"),l=1,h=1,_=0,y=0,N=0,C=0,x=s[0],P=s[1];if(!r(x))throw new a(g);var D;if(s=x.match(S),null!==s){if(D=x.split("-").length-1,D>0&&2!==D)throw new a(g);n=+s[1],l=+s[2],h=+s[3]}else if(s=x.match(T),null!==s)n=+s[1],l=+s[2];else if(s=x.match(R),null!==s)n=+s[1];else{var U;if(s=x.match(v),null!==s){if(n=+s[1],U=+s[2],u=o(n),1>U||u&&U>366||!u&&U>365)throw new a(g)}else{if(s=x.match(A),null===s)throw new a(g);n=+s[1];var L=+s[2],F=+s[3]||0;if(D=x.split("-").length-1,D>0&&(!r(s[3])&&1!==D||r(s[3])&&2!==D))throw new a(g);var B=new Date(Date.UTC(n,0,4));U=7*L+F-B.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(U),l=i.getUTCMonth()+1,h=i.getUTCDate()}if(u=o(n),1>l||l>12||1>h||(2!==l||!u)&&h>m[l-1]||u&&2===l&&h>p)throw new a(g);var z;if(r(P)){if(s=P.match(M),null!==s){if(D=P.split(":").length-1,D>0&&2!==D&&3!==D)throw new a(g);_=+s[1],y=+s[2],N=+s[3],C=1e3*+(s[4]||0),z=5}else if(s=P.match(I),null!==s){if(D=P.split(":").length-1,D>0&&1!==D)throw new a(g);_=+s[1],y=+s[2],N=60*+(s[3]||0),z=4}else{if(s=P.match(O),null===s)throw new a(g);_=+s[1],y=60*+(s[2]||0),z=3}if(y>=60||N>=61||_>24||24===_&&(y>0||N>0||C>0))throw new a(g);var b=s[z],G=+s[z+1],q=+(s[z+2]||0);switch(b){case"+":_-=G,y-=q;break;case"-":_+=G,y+=q;break;case"Z":break;default:y+=new Date(Date.UTC(n,l-1,h,_,y)).getTimezoneOffset()}}else y+=new Date(n,l-1,h).getTimezoneOffset();var W=60===N;for(W&&N--;y>=60;)y-=60,_++;for(;_>=24;)_-=24,h++;for(i=u&&2===l?p:m[l-1];h>i;)h-=i,l++,l>12&&(l-=12,n++),i=u&&2===l?p:m[l-1];for(;0>y;)y+=60,_--;for(;0>_;)_+=24,h--;for(;1>h;)l--,1>l&&(l+=12,n--),i=u&&2===l?p:m[l-1],h+=i;var X=E(n,l,h,_,y,N,C);return r(t)?(d(X[0],X[1],t),f(t)):t=new w(X[0],X[1],c.UTC),W&&w.addSeconds(t,1,t),t},w.now=function(e){return w.fromDate(new Date,e)};var C=new w(0,0,c.TAI);return w.toGregorianDate=function(e,t){var n=!1,a=h(e,C);r(a)||(w.addSeconds(e,-1,C),a=h(C,C),n=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var d=80*c/2447|0,E=c-(2447*d/80|0)|0;c=d/11|0;var _=d+2-12*c|0,m=100*(l-49)+f+c|0,p=u/s.SECONDS_PER_HOUR|0,y=u-p*s.SECONDS_PER_HOUR,R=y/s.SECONDS_PER_MINUTE|0;y-=R*s.SECONDS_PER_MINUTE;var T=0|y,v=(y-T)/s.SECONDS_PER_MILLISECOND;return p+=12,p>23&&(p-=24),n&&(T+=1),r(t)?(t.year=m,t.month=_,t.day=E,t.hour=p,t.minute=R,t.second=T,t.millisecond=v,t.isLeapSecond=n,t):new i(m,_,E,p,R,T,v,n)},w.toDate=function(e){var t=w.toGregorianDate(e,_),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},w.toIso8601=function(t,n){var a,i=w.toGregorianDate(t,i);return r(n)||0===i.millisecond?r(n)&&0!==n?(a=(.01*i.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},w.clone=function(e,t){return r(e)?r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new w(e.dayNumber,e.secondsOfDay,c.TAI):void 0},w.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},w.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},w.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(w.secondsDifference(e,t))<=n},w.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},w.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},w.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},w.computeTaiMinusUtc=function(e){y.julianDate=e;var n=w.leapSeconds,r=t(n,y,l);return 0>r&&(r=~r,--r,0>r&&(r=0)),n[r].offset},w.addSeconds=function(e,t,n){return d(e.dayNumber,e.secondsOfDay+t,n)},w.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,r,n)},w.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,r,n)},w.addDays=function(e,t,n){var r=e.dayNumber+t;return d(r,e.secondsOfDay,n)},w.lessThan=function(e,t){return w.compare(e,t)<0},w.lessThanOrEquals=function(e,t){return w.compare(e,t)<=0},w.greaterThan=function(e,t){return w.compare(e,t)>0},w.greaterThanOrEquals=function(e,t){return w.compare(e,t)>=0},w.prototype.clone=function(e){return w.clone(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.equalsEpsilon=function(e,t){return w.equalsEpsilon(this,e,t)},w.prototype.toString=function(){return w.toIso8601(this)},w.leapSeconds=[new u(new w(2441317,43210,c.TAI),10),new u(new w(2441499,43211,c.TAI),11),new u(new w(2441683,43212,c.TAI),12),new u(new w(2442048,43213,c.TAI),13),new u(new w(2442413,43214,c.TAI),14),new u(new w(2442778,43215,c.TAI),15),new u(new w(2443144,43216,c.TAI),16),new u(new w(2443509,43217,c.TAI),17),new u(new w(2443874,43218,c.TAI),18),new u(new w(2444239,43219,c.TAI),19),new u(new w(2444786,43220,c.TAI),20),new u(new w(2445151,43221,c.TAI),21),new u(new w(2445516,43222,c.TAI),22),new u(new w(2446247,43223,c.TAI),23),new u(new w(2447161,43224,c.TAI),24),new u(new w(2447892,43225,c.TAI),25),new u(new w(2448257,43226,c.TAI),26),new u(new w(2448804,43227,c.TAI),27),new u(new w(2449169,43228,c.TAI),28),new u(new w(2449534,43229,c.TAI),29),new u(new w(2450083,43230,c.TAI),30),new u(new w(2450630,43231,c.TAI),31),new u(new w(2451179,43232,c.TAI),32),new u(new w(2453736,43233,c.TAI),33),new u(new w(2454832,43234,c.TAI),34),new u(new w(2456109,43235,c.TAI),35),new u(new w(2457204,43236,c.TAI),36)],w}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var a=new n.constructor;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];r&&(o=t(o,r)),a[i]=o}return a};return t}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var n=function(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,n,r,a,i){"use strict";function o(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function u(e,t){for(var n=o(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function s(e,n){n=t(n,"");var a=e[1],i=!!e[2],s=e[3];switch(n){case"":case"text":return o(i,s);case"arraybuffer":return u(i,s);case"blob":var c=u(i,s);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(o(i,s),a);case"json":return JSON.parse(o(i,s));default:throw new r("Unhandled responseType: "+n)}}var c=function(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,a=t(n.method,"GET"),i=n.data,o=n.headers,u=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return c.load(t,r,a,i,o,n,u),n.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return c.load=function(e,t,r,o,u,c,f){var h=l.exec(e);if(null!==h)return void c.resolve(s(h,t));var d=new XMLHttpRequest;if(n(f)&&n(d.overrideMimeType)&&d.overrideMimeType(f),d.open(r,e,!0),n(u))for(var E in u)u.hasOwnProperty(E)&&d.setRequestHeader(E,u[E]);n(t)&&(d.responseType=t),d.onload=function(){200===d.status?n(d.response)?c.resolve(d.response):n(d.responseXML)&&d.responseXML.hasChildNodes()?c.resolve(d.responseXML):n(d.responseText)?c.resolve(d.responseText):c.reject(new i("unknown XMLHttpRequest response type.")):c.reject(new a(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(e){c.reject(new a)},d.send(o)},c.defaultLoad=c.load,c}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,n){return e({url:t,headers:n})};return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";var a={Accept:"application/json,*/*;q=0.01"},i=function(n,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,r(n,i).then(function(e){return JSON.parse(e)})};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c,l,f){"use strict";function h(e,t){return o.compare(e.julianDate,t)}function d(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=n.columnNames.indexOf("modifiedJulianDateUtc"),i=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),d=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),_=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>d||0>E||0>_)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=n.samples,p=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=_,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var y,R=e._addNewLeapSeconds,T=0,v=m.length;v>T;T+=e._columnCount){var A=m[T+a],S=m[T+_],N=A+l.MODIFIED_JULIAN_DATE_DIFFERENCE,O=new o(N,S,f.TAI);if(p.push(O),R){if(S!==y&&r(y)){var I=o.leapSeconds,M=t(I,O,h);if(0>M){var g=new u(O,S);I.splice(~M,0,g)}}y=S}}}function E(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function _(e,t,n){return t+e*(n-t)}function m(e,t,n,r,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||r.equals(c))return E(e,n,a,s,u),u;if(r.equals(l))return E(e,n,i,s,u),u;var f=o.secondsDifference(r,c)/o.secondsDifference(l,c),h=a*s,d=i*s,m=n[h+e._ut1MinusUtcSecondsColumn],p=n[d+e._ut1MinusUtcSecondsColumn],y=p-m;if(y>.5||-.5>y){var R=n[h+e._taiMinusUtcSecondsColumn],T=n[d+e._taiMinusUtcSecondsColumn];R!==T&&(l.equals(r)?m=p:p-=T-R)}return u.xPoleWander=_(f,n[h+e._xPoleWanderRadiansColumn],n[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=_(f,n[h+e._yPoleWanderRadiansColumn],n[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=_(f,n[h+e._xCelestialPoleOffsetRadiansColumn],n[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=_(f,n[h+e._yCelestialPoleOffsetRadiansColumn],n[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=_(f,m,p),u}var p=function(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))d(this,t.data);else if(r(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){d(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return p.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,n){if(!r(this._samples)){if(r(this._dataError))throw new c(this._dataError);return void 0}if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var f=i[u],h=i[u+1],d=o.lessThanOrEquals(f,e),E=!r(h),_=E||o.greaterThanOrEquals(h,e);if(d&&_)return s=u,!E&&h.equals(e)&&++s,l=s+1,m(this,i,this._samples,e,s,l,n),n}var p=t(i,e,o.compare,this._dateColumn);return p>=0?(p<i.length-1&&i[p+1].equals(e)&&++p,s=p,l=p):(l=~p,s=l-1,0>s&&(s=0)),this._lastIndex=s,m(this,i,this._samples,e,s,l,n),n},p}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);("."==e||".."==e)&&n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,n,r){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;n>t;++t){var r=e[t].getAttribute("src"),a=f.exec(r);if(null!==a)return a[1]}return void 0}function i(){if(t(s))return s;var r;if(r="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(r))throw new n("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(r).resolve(new e(document.location.href))}function o(e){return r.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}var s,c,l,f=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){t(c)||(c=t(r.toUrl)?o:u),t(l)||(l=document.createElement("a"));var n=c(e);return l.href=n,l.href=l.href,l.href};return h._cesiumScriptRegex=f,h.setBaseUrl=function(t){s=new e(t).resolve(new e(document.location.href))},h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,n){this.x=e,this.y=t,this.s=n};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,t,n){var r=f;return r.dayNumber=t,r.secondsOfDay=n,i.daysDifference(r,e._sampleZeroDateTT)}function c(n,a){if(n._chunkDownloadsInProgress[a])return n._chunkDownloadsInProgress[a];var i=e.defer();n._chunkDownloadsInProgress[a]=i;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[a]=!1;for(var t=n._samples,r=e.samples,o=a*n._samplesPerXysFile*3,u=0,s=r.length;s>u;++u)t[o+u]=r[u];i.resolve()}),i.promise}var l=function(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){r[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)},f=new i(0,0,u.TAI);return l.prototype.preload=function(t,n,r,a){var i=s(this,t,n),o=s(this,r,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=l/this._samplesPerXysFile|0,d=[],E=f;h>=E;++E)d.push(c(this,E));return e.all(d)},l.prototype.computeXysRadians=function(e,t,n){var i=s(this,e,t);if(0>i)return void 0;var o=i/this._stepSizeDays|0;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(u/2|0);0>l&&(l=0);var f=l+u;f>=this._totalSamples&&(f=this._totalSamples-1,l=f-u,0>l&&(l=0));var h=!1,d=this._samples;if(r(d[3*l])||(c(this,l/this._samplesPerXysFile|0),h=!0),r(d[3*f])||(c(this,f/this._samplesPerXysFile|0),h=!0),h)return void 0;r(n)?(n.x=0,n.y=0,n.s=0):n=new a(0,0,0);var E,_,m=i-l*this._stepSizeDays,p=this._work,y=this._denominators,R=this._coef,T=this._xTable;for(E=0;u>=E;++E)p[E]=m-T[E];for(E=0;u>=E;++E){for(R[E]=1,_=0;u>=_;++_)_!==E&&(R[E]*=p[_]);R[E]*=y[E];var v=3*(l+E);n.x+=R[E]*d[v++],n.y+=R[E]*d[v++],n.s+=R[E]*d[v]}return n},l}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,n,r,a){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(a,0)},c=new e;s.fromAxisAngle=function(t,r,a){var i=r/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,h=Math.cos(i);return n(a)?(a.x=u,a.y=l,a.z=f,a.w=h,a):new s(u,l,f,h)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var r,a,i,o,c,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],E=e[u.COLUMN2ROW2],_=h+d+E;if(_>0)r=Math.sqrt(_+1),c=.5*r,r=.5/r,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var m=l,p=0;d>h&&(p=1),E>h&&E>d&&(p=2);var y=m[p],R=m[y];r=Math.sqrt(e[u.getElementIndex(p,p)]-e[u.getElementIndex(y,y)]-e[u.getElementIndex(R,R)]+1);var T=f;T[p]=.5*r,r=.5/r,c=(e[u.getElementIndex(R,y)]-e[u.getElementIndex(y,R)])*r,T[y]=(e[u.getElementIndex(y,p)]+e[u.getElementIndex(p,y)])*r,T[R]=(e[u.getElementIndex(R,p)]+e[u.getElementIndex(p,R)])*r,a=-T[0],i=-T[1],o=-T[2]}return n(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var h=new s;s.fromHeadingPitchRoll=function(t,n,r,a){var i=s.fromAxisAngle(e.UNIT_X,r,h),o=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,h);return s.multiply(u,a,a)};var d=new e,E=new e,_=new s,m=new s,p=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.x=e[r],a.y=e[r+1],a.z=e[r+2],a.w=e[r+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,p),s.conjugate(p,p);for(var a=0,i=n-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),_),s.multiply(_,p,_),_.w<0&&s.negate(_,_),s.computeAxis(_,d);var u=s.computeAngle(_);r[o]=d.x*u,r[o+1]=d.y*u,r[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,r,a,i,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*i,m),0===u?s.clone(s.IDENTITY,_):s.fromAxisAngle(E,u,_),s.multiply(_,m,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,o=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+r*l+a*c-i*s,h=o*s-r*c+a*l+i*u,d=o*c+r*s-a*u+i*l,E=o*l-r*u-a*s-i*c;return n.x=f,n.y=h,n.z=d,n.w=E,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var y=new s;s.lerp=function(e,t,n,r){return y=s.multiplyByScalar(t,n,y),r=s.multiplyByScalar(e,1-n,r),s.add(y,r,r)};var R=new s,T=new s,v=new s;s.slerp=function(e,t,n,r){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=R=s.negate(t,R)),1-a<o.EPSILON6)return s.lerp(e,i,n,r);var u=Math.acos(a);return T=s.multiplyByScalar(e,Math.sin((1-n)*u),T),v=s.multiplyByScalar(i,Math.sin(n*u),v),r=s.add(T,v,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),a=0;return 0!==r&&(a=r/Math.sin(r)),e.multiplyByScalar(t,a,n)},s.exp=function(t,n){var r=e.magnitude(t),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(r),n};var A=new e,S=new e,N=new s,O=new s;s.computeInnerQuadrangle=function(t,n,r,a){var i=s.conjugate(n,N);s.multiply(i,r,O);var o=s.log(O,A);s.multiply(i,t,O);var u=s.log(O,S);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,N),s.multiply(n,N,a)},s.squad=function(e,t,n,r,a,i){var o=s.slerp(e,t,a,N),u=s.slerp(n,r,a,O);return s.slerp(o,u,2*a*(1-a),i)};for(var I=new s,M=1.9011074535173003,g=a.supportsTypedArrays()?new Float32Array(8):[],w=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var D=P+1,U=2*D+1;g[P]=1/(D*U),w[P]=D/U}return g[7]=M/136,w[7]=8*M/17,s.fastSlerp=function(e,t,n,r){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,c=n*n,l=u*u,f=7;f>=0;--f)C[f]=(g[f]*c-w[f])*o,x[f]=(g[f]*l-w[f])*o;var h=a*n*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),d=u*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),E=s.multiplyByScalar(e,d,I);return s.multiplyByScalar(t,h,r),s.add(E,r,r)},s.fastSquad=function(e,t,n,r,a,i){var o=s.fastSlerp(e,t,a,N),u=s.fastSlerp(n,r,a,O);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r;
},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,_,m,p){"use strict";var y={},R=new n,T=new n,v=new n;y.eastNorthUpToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-o,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=R,s=T,l=v;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=l.x,r[5]=l.y,r[6]=l.z,r[7]=0,r[8]=u.x,r[9]=u.y,r[10]=u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var A=new n,S=new n,N=new n;y.northEastDownToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=A,s=S,l=N;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-u.x,r[9]=-u.y,r[10]=-u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},y.northUpEastToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=o,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=R,s=T,l=v;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=u.x,r[5]=u.y,r[6]=u.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var O=new m,I=new n(1,1,1),M=new _;y.headingPitchRollToFixedFrame=function(e,t,r,a,i,o){var u=m.fromHeadingPitchRoll(t,r,a,O),s=_.fromTranslationQuaternionRotationScale(n.ZERO,u,I,M);return o=y.eastNorthUpToFixedFrame(e,i,o),_.multiply(o,s,o)};var g=new _,w=new E;y.headingPitchRollQuaternion=function(e,t,n,r,a,i){var o=y.headingPitchRollToFixedFrame(e,t,n,r,a,g),u=_.getRotation(o,w);return m.fromRotationMatrix(u,i)};var C=24110.54841,x=8640184.812866,P=.093104,D=-62e-7,U=1.1772758384668e-19,L=72921158553e-15,F=d.TWO_PI/86400,B=new h;y.computeTemeToPseudoFixedMatrix=function(e,t){B=h.addSeconds(e,-h.computeTaiMinusUtc(e),B);var n,r=B.dayNumber,a=B.secondsOfDay,o=r-2451545;n=a>=43200?(o+.5)/p.DAYS_PER_JULIAN_CENTURY:(o-.5)/p.DAYS_PER_JULIAN_CENTURY;var u=C+n*(x+n*(P+n*D)),s=u*F%d.TWO_PI,c=L+U*(r-2451545.5),l=(a+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,f=s+c*l,_=Math.cos(f),m=Math.sin(f);return i(t)?(t[0]=_,t[1]=-m,t[2]=0,t[3]=m,t[4]=_,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(_,m,0,-m,_,0,0,0,1)},y.iau2006XysData=new l,y.earthOrientationParameters=u.NONE;var z=32.184,b=2451545;y.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+z,a=t.stop.dayNumber,i=t.stop.secondsOfDay+z,o=y.iau2006XysData.preload(n,r,a,i),u=y.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},y.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new E);var n=y.computeFixedToIcrfMatrix(e,t);return i(n)?E.transpose(n,t):void 0};var G=new f(0,0,0),q=new s(0,0,0,0,0,0),W=new E,X=new E;y.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new E);var n=y.earthOrientationParameters.compute(e,q);if(!i(n))return void 0;var r=e.dayNumber,a=e.secondsOfDay+z,o=y.iau2006XysData.computeXysRadians(r,a,G);if(!i(o))return void 0;var u=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=W;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=E.fromRotationZ(-o.s,X),_=E.multiply(l,f,W),m=e.dayNumber,R=e.secondsOfDay-h.computeTaiMinusUtc(e)+n.ut1MinusUtc,T=m-2451545,v=R/p.SECONDS_PER_DAY,A=.779057273264+v+.00273781191135448*(T+v);A=A%1*d.TWO_PI;var S=E.fromRotationZ(A,X),N=E.multiply(_,S,W),O=Math.cos(n.xPoleWander),I=Math.cos(n.yPoleWander),M=Math.sin(n.xPoleWander),g=Math.sin(n.yPoleWander),w=r-b+a/p.SECONDS_PER_DAY;w/=36525;var C=-47e-6*w*d.RADIANS_PER_DEGREE/3600,x=Math.cos(C),P=Math.sin(C),D=X;return D[0]=O*x,D[1]=O*P,D[2]=M,D[3]=-I*P+g*M*x,D[4]=I*x+g*M*P,D[5]=-g*O,D[6]=-g*P-I*M*x,D[7]=g*x-I*M*P,D[8]=I*O,E.multiply(N,D,t)};var V=new r;y.pointToWindowCoordinates=function(e,t,n,r){return r=y.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},y.pointToGLWindowCoordinates=function(e,n,a,o){i(o)||(o=new t);var u=V;return _.multiplyByVector(e,r.fromElements(a.x,a.y,a.z,1,u),u),r.multiplyByScalar(u,1/u.w,u),_.multiplyByVector(n,u,u),t.fromCartesian4(u,o)};var H=new n,Y=new n,k=new n;return y.rotationMatrixFromPositionVelocity=function(e,t,r,o){var u=a(r,c.WGS84).geodeticSurfaceNormal(e,H),s=n.cross(t,u,Y);n.equalsEpsilon(s,n.ZERO,d.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var l=n.cross(s,t,k);return n.cross(t,l,s),n.negate(s,s),i(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},y}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E){"use strict";var _=new r,m=function(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=E.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(f.getColumn(r,0,_)),this._yAxis=n.fromCartesian4(f.getColumn(r,1,_));var i=n.fromCartesian4(f.getColumn(r,2,_));this._plane=h.fromPointNormal(e,i)};o(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var p=new e;m.fromPoints=function(t,n){var r=e.fromPoints(t,p);return new m(r.center,n)};var y=new d,R=new n;m.prototype.projectPointOntoPlane=function(e,r){var a=y;a.origin=e,n.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,R);if(i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,R)),i(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return i(r)?(r.x=s,r.y=l,r):new t(s,l)}return void 0},m.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var n=0,r=e.length,a=0;r>a;a++){var o=this.projectPointOntoPlane(e[a],t[n]);i(o)&&(t[n]=o,n++)}return t.length=n,t},m.prototype.projectPointToNearestOnPlane=function(e,r){i(r)||(r=new t);var a=y;a.origin=e,n.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,R);i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,R));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},m.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;n>r;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var T=new n;return m.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=T,l=0;r>l;++l){var f=e[l];n.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new n);var h=n.add(o,c,t[l]);n.multiplyByScalar(s,f.y,c),n.add(h,c,h),a.scaleToGeocentricSurface(h,h)}return t},m}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a=new t,i=new t,o=new t,u=function(r,u,s,c,l){n(l)||(l=new t);var f,h,d,E,_,m,p,y;n(u.z)?(f=t.subtract(s,u,a),h=t.subtract(c,u,i),d=t.subtract(r,u,o),E=t.dot(f,f),_=t.dot(f,h),m=t.dot(f,d),p=t.dot(h,h),y=t.dot(h,d)):(f=e.subtract(s,u,a),h=e.subtract(c,u,i),d=e.subtract(r,u,o),E=e.dot(f,f),_=e.dot(f,h),m=e.dot(f,d),p=e.dot(h,h),y=e.dot(h,d));var R=1/(E*p-_*_);return l.y=(p*m-_*y)*R,l.z=(E*y-_*m)*R,l.x=1-l.y-l.z,l};return u}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";var n=new t,r=function(t,r,a,i){return e(t,r,a,i,n),n.x>0&&n.y>0&&n.z>0};return r}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e){var t=e._uSquared,n=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,a=(n-r)/n,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),f=s*o,h=f*f,d=1-h,E=Math.sqrt(d),_=t/4,m=_*_,p=m*_,y=m*m,R=1+_-3*m/4+5*p/4-175*y/64,T=1-_+15*m/8-35*p/8,v=1-3*_+35*m/4,A=1-5*_,S=R*l-T*Math.sin(2*l)*_/2-v*Math.sin(4*l)*m/16-A*Math.sin(6*l)*p/48-5*Math.sin(8*l)*y/512,N=e._constants;N.a=n,N.b=r,N.f=a,N.cosineHeading=i,N.sineHeading=o,N.tanU=u,N.cosineU=s,N.sineU=c,N.sigma=l,N.sineAlpha=f,N.sineSquaredAlpha=h,N.cosineSquaredAlpha=d,N.cosineAlpha=E,N.u2Over4=_,N.u4Over16=m,N.u6Over64=p,N.u8Over256=y,N.a0=R,N.a1=T,N.a2=v,N.a3=A,N.distanceRatio=S}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,n,r,a,i,o){var u=c(e,n);return(1-u)*e*t*(r+u*a*(o+u*i*(2*o*o-1)))}function f(e,t,n,r,a,i,o){var s,c,f,h,d,E=(t-n)/t,_=i-r,m=Math.atan((1-E)*Math.tan(a)),p=Math.atan((1-E)*Math.tan(o)),y=Math.cos(m),R=Math.sin(m),T=Math.cos(p),v=Math.sin(p),A=y*T,S=y*v,N=R*v,O=R*T,I=_,M=u.TWO_PI,g=Math.cos(I),w=Math.sin(I);do{g=Math.cos(I),w=Math.sin(I);var C=S-O*g;f=Math.sqrt(T*T*w*w+C*C),c=N+A*g,s=Math.atan2(f,c);var x;0===f?(x=0,h=1):(x=A*w/f,h=1-x*x),M=I,d=c-2*N/h,isNaN(d)&&(d=0),I=_+l(E,x,h,s,f,c,d)}while(Math.abs(I-M)>u.EPSILON12);var P=h*(t*t-n*n)/(n*n),D=1+P*(4096+P*(P*(320-175*P)-768))/16384,U=P*(256+P*(P*(74-47*P)-128))/1024,L=d*d,F=U*f*(d+U*(c*(2*L-1)-U*d*(4*f*f-3)*(4*L-3)/6)/4),B=n*D*(s-F),z=Math.atan2(T*w,S-O*g),b=Math.atan2(y*w,S*g-O);e._distance=B,e._startHeading=z,e._endHeading=b,e._uSquared=P}function h(n,r,a,i){e.normalize(i.cartographicToCartesian(r,E),d),e.normalize(i.cartographicToCartesian(a,E),E);f(n,i.maximumRadius,i.minimumRadius,r.longitude,r.latitude,a.longitude,a.latitude),n._start=t.clone(r,n._start),n._end=t.clone(a,n._end),n._start.height=0,n._end.height=0,s(n)}var d=new e,E=new e,_=function(e,a,i){var u=n(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,r(e)&&r(a)&&h(this,e,a,u)};return a(_.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),_.prototype.setEndPoints=function(e,t){h(this,e,t,this._ellipsoid)},_.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},_.prototype.interpolateUsingSurfaceDistance=function(e,n){var a=this._constants,i=a.distanceRatio+e/a.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),f=Math.sin(4*i),h=Math.sin(6*i),d=Math.sin(8*i),E=i*i,_=i*E,m=a.u8Over256,p=a.u2Over4,y=a.u6Over64,R=a.u4Over16,T=2*_*m*o/3+i*(1-p+7*R/4-15*y/4+579*m/64-(R-15*y/4+187*m/16)*o-(5*y/4-115*m/16)*u-29*m*s/16)+(p/2-R+71*y/32-85*m/16)*c+(5*R/16-5*y/4+383*m/96)*f-E*((y-11*m/2)*c+5*m*f/2)+(29*y/96-29*m/16)*h+539*m*d/1536,v=Math.asin(Math.sin(T)*a.cosineAlpha),A=Math.atan(a.a/a.b*Math.tan(v));T-=a.sigma;var S=Math.cos(2*a.sigma+T),N=Math.sin(T),O=Math.cos(T),I=a.cosineU*O,M=a.sineU*N,g=Math.atan2(N*a.sineHeading,I-M*a.cosineHeading),w=g-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,T,N,O,S);return r(n)?(n.longitude=this._start.longitude+w,n.latitude=A,n.height=0,n):new t(this._start.longitude+w,A,0)},_}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,n,r,a,i,o,u,s,c,l,f){"use strict";function h(e,t,n){var r=N;r.length=e;var a;if(t===n){for(a=0;e>a;a++)r[a]=t;return r}var i=n-t,o=i/e;for(a=0;e>a;a++){var u=t+a*o;r[a]=u}return r}function d(t,n,r,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,g),l=a.scaleToGeodeticSurface(n,w),f=E.numberOfPoints(t,n,r),d=a.cartesianToCartographic(c,O),_=a.cartesianToCartographic(l,I),m=h(f,i,o);C.setEndPoints(d,_);var p=C.surfaceDistance/f,y=s;d.height=i;var R=a.cartographicToCartesian(d,M);e.pack(R,u,y),y+=3;for(var T=1;f>T;T++){var v=C.interpolateUsingSurfaceDistance(T*p,I);v.height=m[T],R=a.cartographicToCartesian(v,M),e.pack(R,u,y),y+=3}return y}var E={};E.numberOfPoints=function(t,n,r){var a=e.distance(t,n);return Math.ceil(a/r)};var _=new t;E.extractHeights=function(e,t){for(var n=e.length,r=new Array(n),a=0;n>a;a++){var i=e[a];r[a]=t.cartesianToCartographic(i,_).height}return r};var m=new l,p=new e,y=new e,R=new f(e.ZERO,0),T=new e,v=new f(e.ZERO,0),A=new e,S=new e,N=[],O=new t,I=new t,M=new e,g=new e,w=new e,C=new o;E.wrapLongitude=function(t,a){var i=[],o=[];if(r(t)&&t.length>0){a=n(a,l.IDENTITY);var s=l.inverseTransformation(a,m),c=l.multiplyByPoint(s,e.ZERO,p),h=l.multiplyByPointAsVector(s,e.UNIT_Y,y),d=f.fromPointNormal(c,h,R),E=l.multiplyByPointAsVector(s,e.UNIT_X,T),_=f.fromPointNormal(c,E,v),N=1;i.push(e.clone(t[0]));for(var O=i[0],I=t.length,M=1;I>M;++M){var g=t[M];if(f.getPointDistance(_,O)<0||f.getPointDistance(_,g)<0){var w=u.lineSegmentPlane(O,g,d,A);if(r(w)){var C=e.multiplyByScalar(h,5e-9,S);f.getPointDistance(d,O)<0&&e.negate(C,C),i.push(e.add(w,C,new e)),o.push(N+1),e.negate(C,C),i.push(e.add(w,C,new e)),N=1}}i.push(e.clone(t[M])),N++,O=g}o.push(N)}return{positions:i,lengths:o}};var x=c.EPSILON7;return E.removeDuplicates=function(t){var n=t.length;if(2>n)return t;var r,a,i;for(r=1;n>r&&(a=t[r-1],i=t[r],!e.equalsEpsilon(a,i,x));++r);if(r===n)return t;for(var o=t.slice(0,r);n>r;++r)i=t[r],e.equalsEpsilon(a,i,x)||(o.push(e.clone(i)),a=i);return o},E.generateArc=function(t){r(t)||(t={});var a=t.positions,o=a.length,u=n(t.ellipsoid,i.WGS84),l=n(t.height,0);if(1>o)return[];if(1===o){var f=u.scaleToGeodeticSurface(a[0],g);if(0!==l){var h=u.geodeticSurfaceNormal(f,M);e.multiplyByScalar(h,l,h),e.add(f,h,f)}return[f.x,f.y,f.z]}var _=t.minDistance;if(!r(_)){var m=n(t.granularity,c.RADIANS_PER_DEGREE);_=c.chordLength(m,u.maximumRadius)}var p,y=0;for(p=0;o-1>p;p++)y+=E.numberOfPoints(a[p],a[p+1],_);var R=3*(y+1),T=new Array(R),v=0,A=s(l);for(p=0;o-1>p;p++){var S=a[p],I=a[p+1],w=A?l[p]:l,C=A?l[p+1]:l;v=d(S,I,_,u,w,C,T,v)}N.length=0;var x=a[o-1],P=u.cartesianToCartographic(x,O);P.height=A?l[o-1]:l;var D=u.cartographicToCartesian(P,M);return e.pack(D,T,R-3),T},E.generateCartesianArc=function(t){for(var n=E.generateArc(t),r=n.length/3,a=new Array(r),i=0;r>i;i++)a[i]=e.unpack(n,3*i);return a},E}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,n=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,n},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var n={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===n.CLOCKWISE||e===n.COUNTER_CLOCKWISE}};return t(n)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,_){"use strict";function m(t,n,r){var a=e.subtract(n,t,F),i=e.subtract(r,n,B);return a.x*i.y-a.y*i.x>=0}function p(e){for(var t=e[0].x,n=0,r=0;r<e.length;r++)e[r].x>t&&(t=e[r].x,n=r);return n}function y(e){for(var t=e[0][0].x,n=0,r=0;r<e.length;r++){var a=e[r][p(e[r])].x;a>t&&(t=a,n=r)}return n}function R(e){for(var t=[],n=0;n<e.length;n++){var r=e[(n-1+e.length)%e.length],a=e[n],i=e[(n+1)%e.length];m(r,a,i)||t.push(a)}return t}function T(t,n){for(var r=0;r<t.length;r++)if(e.equals(n,t[r]))return r;return-1}function v(n,a,i){i=r(i,[]);var o=Number.MAX_VALUE,u=p(a),s=new e(a[u].x,n.y);i.push(u),i.push((u+1)%a.length);for(var c=a[0].x,l=c,f=1;f<a.length;++f)a[f].x<c?c=a[f].x:a[f].x>l&&(l=a[f].x);l+=l-c;var h=new t(l,n.y,0);for(f=0;f<a.length;f++){var d=a[f],E=a[(f+1)%a.length];if((d.x>=n.x||E.x>=n.x)&&(d.y>=n.y&&E.y<=n.y||d.y<=n.y&&E.y>=n.y)){var _=(E.y-d.y)*(h.x-n.x)-(E.x-d.x)*(h.y-n.y);if(0!==_){_=1/_;var m=((E.x-d.x)*(n.y-d.y)-(E.y-d.y)*(n.x-d.x))*_,y=((h.x-n.x)*(n.y-d.y)-(h.y-n.y)*(n.x-d.x))*_;if(m>=0&&1>=m&&y>=0&&1>=y){var R=new e(n.x+m*(h.x-n.x),n.y+m*(h.y-n.y)),T=e.subtract(R,n,z);_=e.magnitudeSquared(T),o>_&&(s=R,o=_,i[0]=f,i[1]=(f+1)%a.length)}}}}return s}function A(t,n){var r=y(n),a=n[r],i=p(a),o=a[i],u=[],s=v(o,t,u),c=T(t,s);if(-1!==c)return c;var h=e.magnitudeSquared(e.subtract(t[u[0]],o,b)),d=e.magnitudeSquared(e.subtract(t[u[1]],o,b)),E=d>h?t[u[0]]:t[u[1]],_=R(t),m=_.indexOf(E);-1!==m&&_.splice(m,1);for(var A=[],S=0;S<_.length;S++){var N=_[S];f(N,o,s,E)&&A.push(N)}var O=Number.MAX_VALUE;if(A.length>0){var I=e.fromElements(1,0,b);for(S=0;S<A.length;S++){var M=e.subtract(A[S],o,G),g=e.magnitude(I)*e.magnitudeSquared(M);if(0!==g){var w=Math.abs(l.acosClamped(e.dot(I,M)/g));O>w&&(O=w,E=A[S])}}}return t.indexOf(E)}function S(e,n,r){for(var a=ee.computeWindingOrder2D(e),i=0;i<n.length;i++){var o=n[i];t.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ee.computeWindingOrder2D(o);s===a&&o.reverse()}var c=u.fromPoints(e,r),l=c.projectPointsOntoPlane(e),f=[];for(i=0;i<n.length;i++)f.push(c.projectPointsOntoPlane(n[i]));var h=A(l,f),d=y(f),E=p(f[d]),_=n[d],m=[];for(i=0;i<e.length;i++)m.push(e[i]);var R,T=[];if(0!==E)for(R=0;R<=_.length;R++){var v=(R+E)%_.length;0!==v&&T.push(_[v])}else for(R=0;R<_.length;R++)T.push(_[(R+E)%_.length]);var S=m.lastIndexOf(e[h]);T.push(e[S]);var N=m.slice(0,S+1),O=m.slice(S+1);return m=N.concat(T,O),n.splice(d,1),m}function N(e){var t=l.nextRandomNumber(),n=Math.floor(t*e);return n===e&&n--,n}function O(e,t,n,r){var a=r[e].position,i=r[t].position,o=r[n].position,u=o.x,s=o.y,c=a.x-u,l=a.y-s,f=i.x-u,h=i.y-s;return c*h-l*f}function I(e,t){return e.x*t.y-e.y*t.x}function M(e,t){var n=t.length,r=l.mod(e-1,n),a=l.mod(e+1,n);return 0===O(r,a,e,t)?!1:!0}function g(t,n){return e.magnitudeSquared(n)<e.magnitudeSquared(t)}function w(t,n,r){if(!M(t,r))return t;var a=r[t].position,i=r[n].position,o=r.length,u=l.mod(t-1,o);if(!M(u,r))return u;var s=l.mod(t+1,o);if(!M(s,r))return s;var c=e.subtract(r[u].position,a,X),f=e.subtract(r[s].position,a,V),h=e.subtract(i,a,H),d=I(c,h),E=I(f,h);if(0===d)return g(c,h)?q:W;if(0===E)return g(f,h)?q:W;var _=I(c,f);return 0>_?0>d&&E>0?q:W:_>0?d>0&&0>E?W:q:void 0}function C(e,t,n){return(e>t||e>n)&&(t>e||n>e)||t===n&&t===e}function x(t,n,r,a){var i=e.subtract(r,t,k),o=n.x*a.y-n.y*a.x,u=o*o,s=e.magnitudeSquared(n),c=e.magnitudeSquared(a);if(u>Y*s*c){var l=(i.x*a.y-i.y*a.x)/o;return e.add(t,e.multiplyByScalar(n,l,k),k)}return void 0}function P(t,n,r){for(var i=e.subtract(n,t,j),o=r.length,u=0;o>u;u++){var s=r[u].position,c=r[l.mod(u+1,o)].position;if(!(e.equals(t,s)||e.equals(n,c)||e.equals(t,c)||e.equals(n,s))){var f=e.subtract(c,s,Z),h=x(t,i,s,f);if(a(h)&&!(e.equals(h,t)||e.equals(h,n)||e.equals(h,s)||e.equals(h,c))){var d=h.x,E=h.y,_=C(d,t.x,n.x)&&C(E,t.y,n.y)&&C(d,s.x,c.x)&&C(E,s.y,c.y);if(_)return!0}}}return!1}function D(t,n,r){var a=w(t,n,r);if(a>=0)return a;var i=w(n,t,r);return i>=0?i:a!==q||i!==q||P(r[t].position,r[n].position,r)||e.equals(r[t].position,r[n].position)?J:K}function U(e){return 0===O(1,2,0,e)}function L(e){var t=e.length;if(3===t)return U(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new i("Invalid polygon: must have at least three vertices.");for(var n,r,a=0,o=10*e.length,u=J;K>u&&a++<o;){for(n=N(e.length),r=n+1;Math.abs(n-r)<2||Math.abs(n-r)>e.length-2;)r=N(e.length);if(n>r){var s=n;n=r,r=s}u=D(n,r,e)}if(u===K){var c=e.splice(n,r-n+1,e[n],e[r]);return L(e).concat(L(c))}return u>=0?(e.splice(u,1),L(e)):[]}var F=new e,B=new e,z=new e,b=new e(1,0),G=new e,q=-1,W=-2,X=new t,V=new t,H=new t,Y=l.EPSILON14,k=new e,j=(new e,new e),Z=new e,K=-1,J=-2,Q=new t,$=new t,ee={};ee.removeDuplicates=function(e){var n=h.removeDuplicates(e);return t.equals(n[0],n[n.length-1])?n.slice(1):n},ee.computeArea2D=function(e){for(var t=e.length,n=0,r=t-1,a=0;t>a;r=a++){var i=e[r],o=e[a];n+=i.x*o.y-o.x*i.y}return.5*n},ee.computeWindingOrder2D=function(e){var t=ee.computeArea2D(e);return t>0?_.COUNTER_CLOCKWISE:_.CLOCKWISE},ee.triangulate=function(e){for(var t=e.length,n=[],r=0;t>r;++r)n[r]={position:e[r],index:r};return L(n)};var te=new t,ne=new t,re=new t,ae=new t,ie=new t,oe=new t,ue=new t;return ee.computeSubdivision=function(e,i,o,u){u=r(u,l.RADIANS_PER_DEGREE);var f,h=o.slice(0),E=i.length,_=new Array(3*E),m=0;for(f=0;E>f;f++){var p=i[f];_[m++]=p.x,_[m++]=p.y,_[m++]=p.z}for(var y=[],R={},T=e.maximumRadius,v=l.chordLength(u,T),A=v*v;h.length>0;){var S,N,O=h.pop(),I=h.pop(),M=h.pop(),g=t.fromArray(_,3*M,te),w=t.fromArray(_,3*I,ne),C=t.fromArray(_,3*O,re),x=t.multiplyByScalar(t.normalize(g,ae),T,ae),P=t.multiplyByScalar(t.normalize(w,ie),T,ie),D=t.multiplyByScalar(t.normalize(C,oe),T,oe),U=t.magnitudeSquared(t.subtract(x,P,ue)),L=t.magnitudeSquared(t.subtract(P,D,ue)),F=t.magnitudeSquared(t.subtract(D,x,ue)),B=Math.max(U,L,F);B>A?U===B?(S=Math.min(M,I)+" "+Math.max(M,I),f=R[S],a(f)||(N=t.add(g,w,ue),t.multiplyByScalar(N,.5,N),_.push(N.x,N.y,N.z),f=_.length/3-1,R[S]=f),h.push(M,f,O),h.push(f,I,O)):L===B?(S=Math.min(I,O)+" "+Math.max(I,O),f=R[S],a(f)||(N=t.add(w,C,ue),t.multiplyByScalar(N,.5,N),_.push(N.x,N.y,N.z),f=_.length/3-1,R[S]=f),h.push(I,f,M),h.push(f,O,M)):F===B&&(S=Math.min(O,M)+" "+Math.max(O,M),f=R[S],a(f)||(N=t.add(C,g,ue),t.multiplyByScalar(N,.5,N),_.push(N.x,N.y,N.z),f=_.length/3-1,R[S]=f),h.push(O,f,I),h.push(f,M,I)):(y.push(M),y.push(I),y.push(O))}return new s({attributes:{position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:_})},indices:y,primitiveType:d.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,n,i,u){i=r(i,o.WGS84);var s=Q,c=$;if(n=r(n,0),u=r(u,!0),a(e)&&a(e.attributes)&&a(e.attributes.position))for(var l=e.attributes.position.values,f=l.length,h=0;f>h;h+=3)t.fromArray(l,h,c),u&&(c=i.scaleToGeodeticSurface(c,c)),s=i.geodeticSurfaceNormal(c,s),t.multiplyByScalar(s,n,s),t.add(c,s,c),l[h]=c.x,l[h+1]=c.y,l[h+2]=c.z;return e},ee.eliminateHoles=function(e,n,a){a=r(a,o.WGS84);for(var i=[],u=0;u<n.length;u++){for(var s=[],c=0;c<n[u].length;c++)s.push(t.clone(n[u][c]));i.push(s)}for(var l=e;i.length>0;)l=S(l,i,a);return l},ee}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,f){"use strict";function h(e,t){for(var n=new Array(e.length),r=0;r<e.length;r++){var a=e[r];U=t.cartesianToCartographic(a,U),n[r]=U.height,e[r]=t.scaleToGeodeticSurface(a,a)}return n}function d(e,n,r,a){var i,o=e[0],u=e[1],s=t.angleBetween(o,u),c=Math.ceil(s/a),l=new Array(c);if(n===r){for(i=0;c>i;i++)l[i]=n;return l.push(r),l}var f=r-n,h=f/c;for(i=1;c>i;i++){var d=n+i*h;l[i]=d}return l[0]=n,l.push(r),l}function E(n,r,a,o){var u=new i(a,o),s=u.projectPointOntoPlane(t.add(a,n,k),k),c=u.projectPointOntoPlane(t.add(a,r,j),j),l=e.angleBetween(s,c);return c.x*s.y-c.y*s.x>=0?-l:l}function _(e,n,r,a,i,o,c,l){var h=G,d=q;F=f.eastNorthUpToFixedFrame(e,i,F),h=s.multiplyByPointAsVector(F,L,h),h=t.normalize(h,h);var _=E(h,n,e,i);z=u.fromRotationZ(_,z),W.z=o,F=s.multiplyTransformation(F,s.fromRotationTranslation(z,W,B),F);var m=b;m[0]=c;for(var p=0;l>p;p++)for(var y=0;y<r.length;y+=3)d=t.fromArray(r,y,d),d=u.multiplyByVector(m,d,d),d=s.multiplyByPoint(F,d,d),a.push(d.x,d.y,d.z);return a}function m(e,n,r,a,i,o,u){for(var s=0;s<e.length;s+=3){var c=t.fromArray(e,s,X);a=_(c,n,r,a,i,o[s/3],u,1)}return a}function p(e,t){var n=e.length,r=new Array(6*n),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=e[0];r[a++]=u.x-i,r[a++]=0,r[a++]=u.y-o;for(var s=1;n>s;s++){u=e[s];var c=u.x-i,l=u.y-o;r[a++]=c,r[a++]=0,r[a++]=l,r[a++]=c,r[a++]=0,r[a++]=l}return u=e[0],r[a++]=u.x-i,r[a++]=0,r[a++]=u.y-o,r}function y(e,t){for(var n=e.length,r=new Array(3*n),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=0;n>u;u++)r[a++]=e[u].x-i,r[a++]=0,r[a++]=e[u].y-o;return r}function R(e,n,r,i,s,c,f,h,d,E){var m,p=t.angleBetween(t.subtract(n,e,x),t.subtract(r,e,P)),y=i===a.BEVELED?0:Math.ceil(p/o.toRadians(5));m=s?u.fromQuaternion(l.fromAxisAngle(t.negate(e,x),p/(y+1),V),Y):u.fromQuaternion(l.fromAxisAngle(e,p/(y+1),V),Y);var R,T;if(n=t.clone(n,H),y>0)for(var v=E?2:1,A=0;y>A;A++)n=u.multiplyByVector(m,n,n),R=t.subtract(n,e,x),R=t.normalize(R,R),s||(R=t.negate(R,R)),T=c.scaleToGeodeticSurface(n,P),f=_(T,R,h,f,c,d,1,v);else R=t.subtract(n,e,x),R=t.normalize(R,R),s||(R=t.negate(R,R)),T=c.scaleToGeodeticSurface(n,P),f=_(T,R,h,f,c,d,1,1),r=t.clone(r,H),R=t.subtract(r,e,x),R=t.normalize(R,R),s||(R=t.negate(R,R)),T=c.scaleToGeodeticSurface(r,P),f=_(T,R,h,f,c,d,1,1);return f}function T(e,t){return o.equalsEpsilon(e.latitude,t.latitude,o.EPSILON6)&&o.equalsEpsilon(e.longitude,t.longitude,o.EPSILON6)}var v=[new t,new t],A=new t,S=new t,N=new t,O=new t,I=new t,M=new t,g=new t,w=new t,C=new t,x=new t,P=new t,D={},U=new r,L=new t(-1,0,0),F=new s,B=new s,z=new u,b=u.IDENTITY.clone(),G=new t,q=new n,W=new t,X=new t,V=new l,H=new t,Y=new u;D.removeDuplicatesFromShape=function(t){for(var n=t.length,r=[],a=n-1,i=0;n>i;a=i++){var o=t[a],u=t[i];e.equals(o,u)||r.push(u)}return r};var k=new t,j=new t;D.angleIsGreaterThanPi=function(e,n,r,a){var o=new i(r,a),u=o.projectPointOntoPlane(t.add(r,e,k),k),s=o.projectPointOntoPlane(t.add(r,n,j),j);return s.x*u.y-s.y*u.x>=0};var Z=new r,K=new r;D.removeDuplicatesFromPositions=function(e,t){var n=e.length;if(2>n)return e.slice(0);var r=[];r.push(e[0]);for(var a=1;n>a;++a){var i=e[a-1],o=e[a],u=t.cartesianToCartographic(i,Z),s=t.cartesianToCartographic(o,K);T(u,s)||r.push(o)}return r};var J=new t,Q=new t;return D.computePositions=function(e,n,r,i,u){var s=i._ellipsoid,l=h(e,s),f=i._granularity,E=i._cornerType,T=u?p(n,r):y(n,r),P=u?y(n,r):void 0,U=r.height/2,L=r.width/2,F=e.length,B=[],z=u?[]:void 0,b=A,G=S,q=N,W=O,X=I,V=M,H=g,Y=w,k=C,j=e[0],Z=e[1];W=s.geodeticSurfaceNormal(j,W),b=t.subtract(Z,j,b),b=t.normalize(b,b),Y=t.cross(W,b,Y),Y=t.normalize(Y,Y);var K=l[0],$=l[1];u&&(z=_(j,Y,P,z,s,K+U,1,1)),k=t.clone(j,k),j=Z,G=t.negate(b,G);for(var ee,te,ne=1;F-1>ne;ne++){var re=u?2:1;Z=e[ne+1],b=t.subtract(Z,j,b),b=t.normalize(b,b),q=t.add(b,G,q),q=t.normalize(q,q),W=s.geodeticSurfaceNormal(j,W);var ae=t.multiplyByScalar(W,t.dot(b,W),J);t.subtract(b,ae,ae),t.normalize(ae,ae);var ie=t.multiplyByScalar(W,t.dot(G,W),Q);t.subtract(G,ie,ie),t.normalize(ie,ie);var oe=!o.equalsEpsilon(Math.abs(t.dot(ae,ie)),1,o.EPSILON7);if(oe){q=t.cross(q,W,q),q=t.cross(W,q,q),q=t.normalize(q,q);var ue=1/Math.max(.25,t.magnitude(t.cross(q,G,x))),se=D.angleIsGreaterThanPi(b,G,j,s);se?(X=t.add(j,t.multiplyByScalar(q,ue*L,q),X),V=t.add(X,t.multiplyByScalar(Y,L,V),V),v[0]=t.clone(k,v[0]),v[1]=t.clone(V,v[1]),ee=d(v,K+U,$+U,f),te=c.generateArc({positions:v,granularity:f,ellipsoid:s}),B=m(te,Y,T,B,s,ee,1),Y=t.cross(W,b,Y),Y=t.normalize(Y,Y),H=t.add(X,t.multiplyByScalar(Y,L,H),H),E===a.ROUNDED||E===a.BEVELED?R(X,V,H,E,se,s,B,T,$+U,u):(q=t.negate(q,q),B=_(j,q,T,B,s,$+U,ue,re)),k=t.clone(H,k)):(X=t.add(j,t.multiplyByScalar(q,ue*L,q),X),V=t.add(X,t.multiplyByScalar(Y,-L,V),V),v[0]=t.clone(k,v[0]),v[1]=t.clone(V,v[1]),ee=d(v,K+U,$+U,f),te=c.generateArc({positions:v,granularity:f,ellipsoid:s}),B=m(te,Y,T,B,s,ee,1),Y=t.cross(W,b,Y),Y=t.normalize(Y,Y),H=t.add(X,t.multiplyByScalar(Y,-L,H),H),E===a.ROUNDED||E===a.BEVELED?R(X,V,H,E,se,s,B,T,$+U,u):B=_(j,q,T,B,s,$+U,ue,re),k=t.clone(H,k)),G=t.negate(b,G)}else B=_(k,Y,T,B,s,K+U,1,1),k=j;K=$,$=l[ne+1],j=Z}v[0]=t.clone(k,v[0]),v[1]=t.clone(j,v[1]),ee=d(v,K+U,$+U,f),te=c.generateArc({positions:v,granularity:f,ellipsoid:s}),B=m(te,Y,T,B,s,ee,1),u&&(z=_(j,Y,P,z,s,$+U,1,1)),F=B.length;var ce=u?F+z.length:F,le=new Float64Array(ce);return le.set(B),u&&le.set(z,F),le},D}),define("Core/PolylineVolumeOutlineGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./WindingOrder"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,_,m,p,y){"use strict";function R(e,n){var r=new h;r.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:e});var i,o,u=n.length,s=r.position.values.length/3,c=e.length/3,E=c/u,_=d.createTypedArray(s,2*u*(E+1)),m=0;i=0;var y=i*u;for(o=0;u-1>o;o++)_[m++]=o+y,_[m++]=o+y+1;for(_[m++]=u-1+y,_[m++]=y,i=E-1,y=i*u,o=0;u-1>o;o++)_[m++]=o+y,_[m++]=o+y+1;for(_[m++]=u-1+y,_[m++]=y,i=0;E-1>i;i++){var R=u*i,T=R+u;for(o=0;u>o;o++)_[m++]=o+R,_[m++]=o+T}var v=new l({attributes:r,indices:d.createTypedArray(s,_),boundingSphere:t.fromVertices(e),primitiveType:p.LINES});return v}var T=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.polylinePositions,a=e.shapePositions;this._positions=t,this._shape=a,this._ellipsoid=c.clone(o(e.ellipsoid,c.WGS84)),this._cornerType=o(e.cornerType,i.ROUNDED),this._granularity=o(e.granularity,E.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";var u=1+t.length*r.packedLength;u+=1+a.length*n.packedLength,this.packedLength=u+c.packedLength+2};T.pack=function(e,t,a){a=o(a,0);var i,u=e._positions,s=u.length;for(t[a++]=s,i=0;s>i;++i,a+=r.packedLength)r.pack(u[i],t,a);var l=e._shape;for(s=l.length,t[a++]=s,i=0;s>i;++i,a+=n.packedLength)n.pack(l[i],t,a);c.pack(e._ellipsoid,t,a),a+=c.packedLength,t[a++]=e._cornerType,t[a]=e._granularity};var v=c.clone(c.UNIT_SPHERE),A={polylinePositions:void 0,shapePositions:void 0,ellipsoid:v,height:void 0,cornerType:void 0,granularity:void 0};T.unpack=function(e,t,a){t=o(t,0);var i,s=e[t++],l=new Array(s);for(i=0;s>i;++i,t+=r.packedLength)l[i]=r.unpack(e,t);
s=e[t++];var f=new Array(s);for(i=0;s>i;++i,t+=n.packedLength)f[i]=n.unpack(e,t);var h=c.unpack(e,t,v);t+=c.packedLength;var d=e[t++],E=e[t];return u(a)?(a._positions=l,a._shape=f,a._ellipsoid=c.clone(h,a._ellipsoid),a._cornerType=d,a._granularity=E,a):(A.polylinePositions=l,A.shapePositions=f,A.cornerType=d,A.granularity=E,new T(A))};var S=new e;return T.createGeometry=function(t){var n=t._positions,r=m.removeDuplicatesFromPositions(n,t._ellipsoid),a=t._shape;if(a=m.removeDuplicatesFromShape(a),r.length<2||a.length<3)return void 0;_.computeWindingOrder2D(a)===y.CLOCKWISE&&a.reverse();var i=e.fromPoints(a,S),o=m.computePositions(r,a,i,t,!1);return R(o,a)},T}),define("Workers/createPolylineVolumeOutlineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineVolumeOutlineGeometry"],function(e,t,n){"use strict";function r(r,a){return e(a)&&(r=n.unpack(r,a)),r._ellipsoid=t.clone(r._ellipsoid),n.createGeometry(r)}return r})}();