/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},i.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},i.lerp=function(e,t,n){return(1-n)*e+n*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,n,r,i){i=t(i,r);var a=Math.abs(e-n);return i>=a||a<=r*Math.max(Math.abs(e),Math.abs(n))};var a=[1];i.factorial=function(e){var t=a.length;if(e>=t)for(var n=a[t-1],r=t;e>=r;r++)a.push(n*r);return a[e]},i.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return i.setRandomNumberSeed=function(t){o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a=function(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)};a.fromSpherical=function(n,r){t(r)||(r=new a);var i=n.clock,o=n.cone,u=e(n.magnitude,1),E=u*Math.sin(o);return r.x=E*Math.cos(i),r.y=E*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(e,n,r,i){return t(i)?(i.x=e,i.y=n,i.z=r,i):new a(e,n,r)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var E=new a,s=new a;a.angleBetween=function(e,t){a.normalize(e,E),a.normalize(t,s);var n=a.dot(E,s),r=a.magnitude(a.cross(E,s,E));return Math.atan2(r,n)};var c=new a;a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,c);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Z,t):n.y<=n.z?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_Z,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)},a.cross=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=t.x,u=t.y,E=t.z,s=i*E-a*u,c=a*o-r*E,_=r*u-i*o;return n.x=s,n.y=c,n.z=_,n},a.fromDegrees=function(e,t,n,r,o){var u=i.toRadians(e),E=i.toRadians(t);return a.fromRadians(u,E,n,r,o)};var _=new a,l=new a,R=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=e(i,0);var E=t(o)?o.radiiSquared:R,s=Math.cos(r);_.x=s*Math.cos(n),_.y=s*Math.sin(n),_.z=Math.sin(r),_=a.normalize(_,_),a.multiplyComponents(E,_,l);var c=Math.sqrt(a.dot(_,l));return l=a.divideByScalar(l,c,l),_=a.multiplyByScalar(_,i,_),t(u)||(u=new a),a.add(l,_,u)},a.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=i.toRadians(e[o]);return a.fromRadiansArray(r,t,n)},a.fromRadiansArray=function(e,n,r){var i=e.length;t(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=e[o],E=e[o+1];r[o/2]=a.fromRadians(u,E,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=i.toRadians(e[o]),r[o+1]=i.toRadians(e[o+1]),r[o+2]=e[o+2];return a.fromRadiansArrayHeights(r,t,n)},a.fromRadiansArrayHeights=function(e,n,r){var i=e.length;t(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=e[o],E=e[o+1],s=e[o+2];r[o/3]=a.fromRadians(u,E,s,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a=function(t,n,r){this.longitude=e(t,0),this.latitude=e(n,0),this.height=e(r,0)};return a.fromRadians=function(n,r,i,o){return i=e(i,0),t(o)?(o.longitude=n,o.latitude=r,o.height=i,o):new a(n,r,i)},a.fromDegrees=function(e,t,n,r){return e=i.toRadians(e),t=i.toRadians(t),a.fromRadians(e,t,n,r)},a.clone=function(e,n){return t(e)?t(n)?(n.longitude=e.longitude,n.latitude=e.latitude,n.height=e.height,n):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.longitude===n.longitude&&e.latitude===n.latitude&&e.height===n.height},a.equalsEpsilon=function(e,n,r){return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=r&&Math.abs(e.latitude-n.latitude)<=r&&Math.abs(e.height-n.height)<=r},a.ZERO=r(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var n={},r=function(t,r){e(n[t])||(n[t]=!0,console.log(r))};return r}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";function E(t,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),t._radii=new e(r,i,a),t._radiiSquared=new e(r*r,i*i,a*a),t._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,i,a),t._maximumRadius=Math.max(r,i,a),t._centerToleranceSquared=u.EPSILON1}var s=function(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,E(this,e,t,n)};i(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(t,n){if(!r(t))return void 0;var i=t._radii;return r(n)?(e.clone(i,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new s(i.x,i.y,i.z)},s.fromCartesian3=function(e,t){return r(t)||(t=new s),r(e)?(E(t,e.x,e.y,e.z),t):t},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.packedLength=e.packedLength,s.pack=function(t,r,i){i=n(i,0),e.pack(t._radii,r,i)},s.unpack=function(t,r,i){r=n(r,0);var a=e.unpack(t,r);return s.fromCartesian3(a,i)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(t,n){var i=t.longitude,a=t.latitude,o=Math.cos(a),u=o*Math.cos(i),E=o*Math.sin(i),s=Math.sin(a);return r(n)||(n=new e),n.x=u,n.y=E,n.z=s,e.normalize(n,n)},s.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var c=new e,_=new e;s.prototype.cartographicToCartesian=function(t,n){var i=c,a=_;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),r(n)||(n=new e),e.add(a,i,n)},s.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var l=new e,R=new e,T=new e;s.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,R);if(!r(a))return void 0;var o=this.geodeticSurfaceNormal(a,l),E=e.subtract(n,a,T),s=Math.atan2(o.y,o.x),c=Math.asin(o.z),_=u.sign(e.dot(E,n))*e.magnitude(E);return r(i)?(i.longitude=s,i.latitude=c,i.height=_,i):new t(s,c,_)},s.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t};var A=new e,f=new e;return s.prototype.scaleToGeodeticSurface=function(t,n){var i=t.x,a=t.y,o=t.z,E=this._oneOverRadii,s=E.x,c=E.y,_=E.z,l=i*i*s*s,R=a*a*c*c,T=o*o*_*_,h=l+R+T,d=Math.sqrt(1/h),N=e.multiplyByScalar(t,d,A);if(h<this._centerToleranceSquared)return isFinite(d)?e.clone(N,n):void 0;var I=this._oneOverRadiiSquared,S=I.x,M=I.y,O=I.z,m=f;m.x=N.x*S*2,m.y=N.y*M*2,m.z=N.z*O*2;var y,p,C,U,L,v,F,w,P,x,g,B=(1-d)*e.magnitude(t)/(.5*e.magnitude(m)),D=0;do{B-=D,C=1/(1+B*S),U=1/(1+B*M),L=1/(1+B*O),v=C*C,F=U*U,w=L*L,P=v*C,x=F*U,g=w*L,y=l*v+R*F+T*w-1,p=l*P*S+R*x*M+T*g*O;var z=-2*p;D=y/z}while(Math.abs(y)>u.EPSILON12);return r(n)?(n.x=i*C,n.y=a*U,n.z=o*L,n):new e(i*C,a*U,o*L)},s.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var i=t.x,a=t.y,o=t.z,u=this._oneOverRadiiSquared,E=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return e.multiplyByScalar(t,E,n)},s.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},s.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},s.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,i,a,o){"use strict";var u=function(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new e(a,o,u)},u.prototype.unproject=function(e,n){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,u=e.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new t(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,n){this.start=e(t,0),this.stop=e(n,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a=function(t,n,r,i){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(i,0)};a.fromElements=function(e,n,r,i,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=i,o):new a(e,n,r,i)},a.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var E=new a;return a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,E);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)&&i.equalsEpsilon(e.w,n.w,r,a)},a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function u(e){for(var t=0,n=0;3>n;++n){var r=e[s.getElementIndex(R[n],l[n])];t+=2*r*r}return Math.sqrt(t)}function E(e,t){for(var n=a.EPSILON15,r=0,i=1,o=0;3>o;++o){var u=Math.abs(e[s.getElementIndex(R[o],l[o])]);u>r&&(i=o,r=u)}var E=1,c=0,_=l[i],T=R[i];if(Math.abs(e[s.getElementIndex(T,_)])>n){var A,f=e[s.getElementIndex(T,T)],h=e[s.getElementIndex(_,_)],d=e[s.getElementIndex(T,_)],N=(f-h)/2/d;A=0>N?-1/(-N+Math.sqrt(1+N*N)):1/(N+Math.sqrt(1+N*N)),E=1/Math.sqrt(1+A*A),c=A*E}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(_,_)]=t[s.getElementIndex(T,T)]=E,t[s.getElementIndex(T,_)]=c,t[s.getElementIndex(_,T)]=-c,t}var s=function(e,n,r,i,a,o,u,E,s){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(a,0),this[5]=t(E,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(s,0)};s.packedLength=9,s.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},s.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i[0]=e[r++],i[1]=e[r++],i[2]=e[r++],i[3]=e[r++],i[4]=e[r++],i[5]=e[r++],i[6]=e[r++],i[7]=e[r++],i[8]=e[r++],i},s.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},s.fromArray=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],i[4]=e[r+4],i[5]=e[r+5],i[6]=e[r+6],i[7]=e[r+7],i[8]=e[r+8],i},s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,t){var r=e.x*e.x,i=e.x*e.y,a=e.x*e.z,o=e.x*e.w,u=e.y*e.y,E=e.y*e.z,c=e.y*e.w,_=e.z*e.z,l=e.z*e.w,R=e.w*e.w,T=r-u-_+R,A=2*(i-l),f=2*(a+c),h=2*(i+l),d=-r+u-_+R,N=2*(E-o),I=2*(a-c),S=2*(E+o),M=-r-u+_+R;return n(t)?(t[0]=T,t[1]=h,t[2]=I,t[3]=A,t[4]=d,t[5]=S,t[6]=f,t[7]=N,t[8]=M,t):new s(T,A,f,h,d,N,I,S,M)},s.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=i,t[6]=0,t[7]=-i,t[8]=r,t):new s(1,0,0,0,r,-i,0,i,r)},s.fromRotationY=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=r,t):new s(r,0,i,0,1,0,-i,0,r)},s.fromRotationZ=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=i,t[2]=0,t[3]=-i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new s(r,-i,0,i,r,0,0,0,1)},s.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,t){return 3*e+t},s.getColumn=function(e,t,n){var r=3*t,i=e[r],a=e[r+1],o=e[r+2];return n.x=i,n.y=a,n.z=o,n},s.setColumn=function(e,t,n,r){r=s.clone(e,r);var i=3*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},s.getRow=function(e,t,n){var r=e[t],i=e[t+3],a=e[t+6];return n.x=r,n.y=i,n.z=a,n},s.setRow=function(e,t,n,r){return r=s.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var c=new e;s.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],c)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],c)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],c)),n};var _=new e;s.getMaximumScale=function(t){return s.getScale(t,_),e.maximumComponent(_)},s.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],i=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],E=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],s=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],c=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],_=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=E,n[6]=s,n[7]=c,n[8]=_,n},s.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},s.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},s.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[3]*i+e[6]*a,u=e[1]*r+e[4]*i+e[7]*a,E=e[2]*r+e[5]*i+e[8]*a;return n.x=o,n.y=u,n.z=E,n},s.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},s.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},s.transpose=function(e,t){var n=e[0],r=e[3],i=e[6],a=e[1],o=e[4],u=e[7],E=e[2],s=e[5],c=e[8];return t[0]=n,t[1]=r,t[2]=i,t[3]=a,t[4]=o,t[5]=u,t[6]=E,t[7]=s,t[8]=c,t};var l=[1,0,0],R=[2,2,1],T=new s,A=new s;return s.computeEigenDecomposition=function(e,t){var r=a.EPSILON20,i=10,c=0,_=0;n(t)||(t={});for(var l=t.unitary=s.clone(s.IDENTITY,t.unitary),R=t.diagonal=s.clone(e,t.diagonal),f=r*o(R);i>_&&u(R)>f;)E(R,T),s.transpose(T,A),s.multiply(R,T,R),s.multiply(A,R,R),s.multiply(l,T,l),++c>2&&(++_,c=0);return t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},s.determinant=function(e){var t=e[0],n=e[3],r=e[6],i=e[1],a=e[4],o=e[7],u=e[2],E=e[5],s=e[8];return t*(a*s-E*o)+i*(E*r-n*s)+u*(n*o-a*r)},s.inverse=function(e,t){var n=e[0],i=e[1],o=e[2],u=e[3],E=e[4],c=e[5],_=e[6],l=e[7],R=e[8],T=s.determinant(e);if(Math.abs(T)<=a.EPSILON15)throw new r("matrix is not invertible");t[0]=E*R-l*c,t[1]=l*o-i*R,t[2]=i*c-E*o,t[3]=_*c-u*R,t[4]=n*R-_*o,t[5]=u*o-n*c,t[6]=u*l-_*E,t[7]=_*i-n*l,t[8]=n*E-u*i;var A=1/T;return s.multiplyByScalar(t,A,t)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},s.IDENTITY=i(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=i(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,i,a,o,u,E){"use strict";var s=function(e,t,r,i,a,o,u,E,s,c,_,l,R,T,A,f){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(s,0),this[3]=n(R,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(c,0),this[7]=n(T,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(_,0),this[11]=n(A,0),this[12]=n(i,0),this[13]=n(E,0),this[14]=n(l,0),this[15]=n(f,0)};s.packedLength=16,s.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},s.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new s),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},s.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new s(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},s.fromArray=s.unpack,s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},s.fromRotationTranslation=function(t,i,a){return i=n(i,e.ZERO),r(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new s(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},s.fromTranslationQuaternionRotationScale=function(e,t,n,i){r(i)||(i=new s);var a=n.x,o=n.y,u=n.z,E=t.x*t.x,c=t.x*t.y,_=t.x*t.z,l=t.x*t.w,R=t.y*t.y,T=t.y*t.z,A=t.y*t.w,f=t.z*t.z,h=t.z*t.w,d=t.w*t.w,N=E-R-f+d,I=2*(c-h),S=2*(_+A),M=2*(c+h),O=-E+R-f+d,m=2*(T-l),y=2*(_-A),p=2*(T+l),C=-E-R+f+d;return i[0]=N*a,i[1]=M*a,i[2]=y*a,i[3]=0,i[4]=I*o,i[5]=O*o,i[6]=p*o,i[7]=0,i[8]=S*u,i[9]=m*u,i[10]=C*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},s.fromTranslation=function(e,t){return s.fromRotationTranslation(u.IDENTITY,e,t)},s.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new s(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},s.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new s(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,_=new e,l=new e;s.fromCamera=function(t,n){var i=t.eye,a=t.target,o=t.up;e.normalize(e.subtract(a,i,c),c),e.normalize(e.cross(c,o,_),_),e.normalize(e.cross(_,c,l),l);var u=_.x,E=_.y,R=_.z,T=c.x,A=c.y,f=c.z,h=l.x,d=l.y,N=l.z,I=i.x,S=i.y,M=i.z,O=u*-I+E*-S+R*-M,m=h*-I+d*-S+N*-M,y=T*I+A*S+f*M;return r(n)?(n[0]=u,n[1]=h,n[2]=-T,n[3]=0,n[4]=E,n[5]=d,n[6]=-A,n[7]=0,n[8]=R,n[9]=N,n[10]=-f,n[11]=0,n[12]=O,n[13]=m,n[14]=y,n[15]=1,n):new s(u,E,R,O,h,d,N,m,-T,-A,-f,y,0,0,0,1)},s.computePerspectiveFieldOfView=function(e,t,n,r,i){var a=Math.tan(.5*e),o=1/a,u=o/t,E=(r+n)/(n-r),s=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=E,i[11]=-1,i[12]=0,i[13]=0,i[14]=s,i[15]=0,i},s.computeOrthographicOffCenter=function(e,t,n,r,i,a,o){var u=1/(t-e),E=1/(r-n),s=1/(a-i),c=-(t+e)*u,_=-(r+n)*E,l=-(a+i)*s;return u*=2,E*=2,s*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=0,o[12]=c,o[13]=_,o[14]=l,o[15]=1,
o},s.computePerspectiveOffCenter=function(e,t,n,r,i,a,o){var u=2*i/(t-e),E=2*i/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),_=-(a+i)/(a-i),l=-1,R=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=s,o[9]=c,o[10]=_,o[11]=l,o[12]=0,o[13]=0,o[14]=R,o[15]=0,o},s.computeInfinitePerspectiveOffCenter=function(e,t,n,r,i,a){var o=2*i/(t-e),u=2*i/(r-n),E=(t+e)/(t-e),s=(r+n)/(r-n),c=-1,_=-1,l=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=E,a[9]=s,a[10]=c,a[11]=_,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},s.computeViewportTransformation=function(e,t,r,i){e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),o=n(e.y,0),u=n(e.width,0),E=n(e.height,0);t=n(t,0),r=n(r,1);var s=.5*u,c=.5*E,_=.5*(r-t),l=s,R=c,T=_,A=a+s,f=o+c,h=t+_,d=1;return i[0]=l,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=R,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=T,i[11]=0,i[12]=A,i[13]=f,i[14]=h,i[15]=d,i},s.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},s.getElementIndex=function(e,t){return 4*e+t},s.getColumn=function(e,t,n){var r=4*t,i=e[r],a=e[r+1],o=e[r+2],u=e[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},s.setColumn=function(e,t,n,r){r=s.clone(e,r);var i=4*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},s.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},s.getRow=function(e,t,n){var r=e[t],i=e[t+4],a=e[t+8],o=e[t+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},s.setRow=function(e,t,n,r){return r=s.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var R=new e;s.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],R)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],R)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],R)),n};var T=new e;s.getMaximumScale=function(t){return s.getScale(t,T),e.maximumComponent(T)},s.multiply=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[3],u=e[4],E=e[5],s=e[6],c=e[7],_=e[8],l=e[9],R=e[10],T=e[11],A=e[12],f=e[13],h=e[14],d=e[15],N=t[0],I=t[1],S=t[2],M=t[3],O=t[4],m=t[5],y=t[6],p=t[7],C=t[8],U=t[9],L=t[10],v=t[11],F=t[12],w=t[13],P=t[14],x=t[15],g=r*N+u*I+_*S+A*M,B=i*N+E*I+l*S+f*M,D=a*N+s*I+R*S+h*M,z=o*N+c*I+T*S+d*M,G=r*O+u*m+_*y+A*p,b=i*O+E*m+l*y+f*p,X=a*O+s*m+R*y+h*p,H=o*O+c*m+T*y+d*p,V=r*C+u*U+_*L+A*v,W=i*C+E*U+l*L+f*v,q=a*C+s*U+R*L+h*v,Y=o*C+c*U+T*L+d*v,K=r*F+u*w+_*P+A*x,k=i*F+E*w+l*P+f*x,Z=a*F+s*w+R*P+h*x,j=o*F+c*w+T*P+d*x;return n[0]=g,n[1]=B,n[2]=D,n[3]=z,n[4]=G,n[5]=b,n[6]=X,n[7]=H,n[8]=V,n[9]=W,n[10]=q,n[11]=Y,n[12]=K,n[13]=k,n[14]=Z,n[15]=j,n},s.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},s.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},s.multiplyTransformation=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],E=e[6],s=e[8],c=e[9],_=e[10],l=e[12],R=e[13],T=e[14],A=t[0],f=t[1],h=t[2],d=t[4],N=t[5],I=t[6],S=t[8],M=t[9],O=t[10],m=t[12],y=t[13],p=t[14],C=r*A+o*f+s*h,U=i*A+u*f+c*h,L=a*A+E*f+_*h,v=r*d+o*N+s*I,F=i*d+u*N+c*I,w=a*d+E*N+_*I,P=r*S+o*M+s*O,x=i*S+u*M+c*O,g=a*S+E*M+_*O,B=r*m+o*y+s*p+l,D=i*m+u*y+c*p+R,z=a*m+E*y+_*p+T;return n[0]=C,n[1]=U,n[2]=L,n[3]=0,n[4]=v,n[5]=F,n[6]=w,n[7]=0,n[8]=P,n[9]=x,n[10]=g,n[11]=0,n[12]=B,n[13]=D,n[14]=z,n[15]=1,n},s.multiplyByMatrix3=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],E=e[6],s=e[8],c=e[9],_=e[10],l=t[0],R=t[1],T=t[2],A=t[3],f=t[4],h=t[5],d=t[6],N=t[7],I=t[8],S=r*l+o*R+s*T,M=i*l+u*R+c*T,O=a*l+E*R+_*T,m=r*A+o*f+s*h,y=i*A+u*f+c*h,p=a*A+E*f+_*h,C=r*d+o*N+s*I,U=i*d+u*N+c*I,L=a*d+E*N+_*I;return n[0]=S,n[1]=M,n[2]=O,n[3]=0,n[4]=m,n[5]=y,n[6]=p,n[7]=0,n[8]=C,n[9]=U,n[10]=L,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},s.multiplyByTranslation=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=r*e[0]+i*e[4]+a*e[8]+e[12],u=r*e[1]+i*e[5]+a*e[9]+e[13],E=r*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=E,n[15]=e[15],n};var A=new e;s.multiplyByUniformScale=function(e,t,n){return A.x=t,A.y=t,A.z=t,s.multiplyByScale(e,A,n)},s.multiplyByScale=function(e,t,n){var r=t.x,i=t.y,a=t.z;return 1===r&&1===i&&1===a?s.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},s.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=t.w,u=e[0]*r+e[4]*i+e[8]*a+e[12]*o,E=e[1]*r+e[5]*i+e[9]*a+e[13]*o,s=e[2]*r+e[6]*i+e[10]*a+e[14]*o,c=e[3]*r+e[7]*i+e[11]*a+e[15]*o;return n.x=u,n.y=E,n.z=s,n.w=c,n},s.multiplyByPointAsVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a,u=e[1]*r+e[5]*i+e[9]*a,E=e[2]*r+e[6]*i+e[10]*a;return n.x=o,n.y=u,n.z=E,n},s.multiplyByPoint=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a+e[12],u=e[1]*r+e[5]*i+e[9]*a+e[13],E=e[2]*r+e[6]*i+e[10]*a+e[14];return n.x=o,n.y=u,n.z=E,n},s.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},s.transpose=function(e,t){var n=e[1],r=e[2],i=e[3],a=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=o,t[14]=u,t[15]=e[15],t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},s.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},s.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var f=new u,h=new u,d=new t,N=new t(0,0,0,1);return s.inverse=function(e,n){if(u.equalsEpsilon(s.getRotation(e,f),h,o.EPSILON7)&&t.equals(s.getRow(e,3,d),N))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],i=e[4],a=e[8],c=e[12],_=e[1],l=e[5],R=e[9],T=e[13],A=e[2],I=e[6],S=e[10],M=e[14],O=e[3],m=e[7],y=e[11],p=e[15],C=S*p,U=M*y,L=I*p,v=M*m,F=I*y,w=S*m,P=A*p,x=M*O,g=A*y,B=S*O,D=A*m,z=I*O,G=C*l+v*R+F*T-(U*l+L*R+w*T),b=U*_+P*R+B*T-(C*_+x*R+g*T),X=L*_+x*l+D*T-(v*_+P*l+z*T),H=w*_+g*l+z*R-(F*_+B*l+D*R),V=U*i+L*a+w*c-(C*i+v*a+F*c),W=C*r+x*a+g*c-(U*r+P*a+B*c),q=v*r+P*i+z*c-(L*r+x*i+D*c),Y=F*r+B*i+D*a-(w*r+g*i+z*a);C=a*T,U=c*R,L=i*T,v=c*l,F=i*R,w=a*l,P=r*T,x=c*_,g=r*R,B=a*_,D=r*l,z=i*_;var K=C*m+v*y+F*p-(U*m+L*y+w*p),k=U*O+P*y+B*p-(C*O+x*y+g*p),Z=L*O+x*m+D*p-(v*O+P*m+z*p),j=w*O+g*m+z*y-(F*O+B*m+D*y),Q=L*S+w*M+U*I-(F*M+C*I+v*S),J=g*M+C*A+x*S-(P*S+B*M+U*A),$=P*I+z*M+v*A-(D*M+L*A+x*I),ee=D*S+F*A+B*I-(g*I+z*S+w*A),te=r*G+i*b+a*X+c*H;if(Math.abs(te)<o.EPSILON20)throw new E("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=G*te,n[1]=b*te,n[2]=X*te,n[3]=H*te,n[4]=V*te,n[5]=W*te,n[6]=q*te,n[7]=Y*te,n[8]=K*te,n[9]=k*te,n[10]=Z*te,n[11]=j*te,n[12]=Q*te,n[13]=J*te,n[14]=$*te,n[15]=ee*te,n},s.inverseTransformation=function(e,t){var n=e[0],r=e[1],i=e[2],a=e[4],o=e[5],u=e[6],E=e[8],s=e[9],c=e[10],_=e[12],l=e[13],R=e[14],T=-n*_-r*l-i*R,A=-a*_-o*l-u*R,f=-E*_-s*l-c*R;return t[0]=n,t[1]=a,t[2]=E,t[3]=0,t[4]=r,t[5]=o,t[6]=s,t[7]=0,t[8]=i,t[9]=u,t[10]=c,t[11]=0,t[12]=T,t[13]=A,t[14]=f,t[15]=1,t},s.IDENTITY=a(new s(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN0ROW3=3,s.COLUMN1ROW0=4,s.COLUMN1ROW1=5,s.COLUMN1ROW2=6,s.COLUMN1ROW3=7,s.COLUMN2ROW0=8,s.COLUMN2ROW1=9,s.COLUMN2ROW2=10,s.COLUMN2ROW3=11,s.COLUMN3ROW0=12,s.COLUMN3ROW1=13,s.COLUMN3ROW2=14,s.COLUMN3ROW3=15,s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},s}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";var i=function(t,n){this.normal=e.clone(t),this.distance=n};i.fromPointNormal=function(n,r,a){var o=-e.dot(r,n);return t(a)?(e.clone(r,a.normal),a.distance=o,a):new i(r,o)};var a=new e;return i.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,a),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new i(o,u)},i.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},i.ORIGIN_XY_PLANE=r(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=r(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=r(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";var E=function(e,n,r,i){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(i,0)};r(E.prototype,{width:{get:function(){return E.computeWidth(this)}},height:{get:function(){return E.computeHeight(this)}}}),E.packedLength=4,E.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},E.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new E),i.west=e[r++],i.south=e[r++],i.east=e[r++],i.north=e[r],i},E.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},E.computeHeight=function(e){return e.north-e.south},E.fromDegrees=function(e,r,i,a,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),i=u.toRadians(t(i,0)),a=u.toRadians(t(a,0)),n(o)?(o.west=e,o.south=r,o.east=i,o.north=a,o):new E(e,r,i,a)},E.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,s=e.length;s>u;u++){var c=e[u];r=Math.min(r,c.longitude),i=Math.max(i,c.longitude),a=Math.min(a,c.latitude),o=Math.max(o,c.latitude)}return n(t)?(t.west=r,t.south=a,t.east=i,t.north=o,t):new E(r,a,i,o)},E.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new E(e.west,e.south,e.east,e.north):void 0},E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},E.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},E.validate=function(e){},E.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},E.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},E.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},E.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},E.center=function(t,r){var i=t.east,a=t.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),E=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=E,r.height=0,r):new e(o,E)},E.intersection=function(e,t,r){var i=e.east,a=e.west,o=t.east,s=t.west;a>i&&o>0?i+=u.TWO_PI:s>o&&i>0&&(o+=u.TWO_PI),a>i&&0>s?s+=u.TWO_PI:s>o&&0>a&&(a+=u.TWO_PI);var c=u.negativePiToPi(Math.max(a,s)),_=u.negativePiToPi(Math.min(i,o));if((e.west<e.east||t.west<t.east)&&c>=_)return void 0;var l=Math.max(e.south,t.south),R=Math.min(e.north,t.north);return l>=R?void 0:n(r)?(r.west=c,r.south=l,r.east=_,r.north=R,r):new E(c,l,_,R)},E.contains=function(e,t){var n=t.longitude,r=t.latitude,i=e.west,a=e.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=e.south&&r<=e.north};var s=new e;return E.subsample=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0),n(o)||(o=[]);var c=0,_=e.north,l=e.south,R=e.east,T=e.west,A=s;A.height=i,A.longitude=T,A.latitude=_,o[c]=r.cartographicToCartesian(A,o[c]),c++,A.longitude=R,o[c]=r.cartographicToCartesian(A,o[c]),c++,A.latitude=l,o[c]=r.cartographicToCartesian(A,o[c]),c++,A.longitude=T,o[c]=r.cartographicToCartesian(A,o[c]),c++,0>_?A.latitude=_:l>0?A.latitude=l:A.latitude=0;for(var f=1;8>f;++f)A.longitude=-Math.PI+f*u.PI_OVER_TWO,E.contains(e,A)&&(o[c]=r.cartographicToCartesian(A,o[c]),c++);return 0===A.latitude&&(A.longitude=T,o[c]=r.cartographicToCartesian(A,o[c]),c++,A.longitude=R,o[c]=r.cartographicToCartesian(A,o[c]),c++),o.length=c,o},E.MAX_VALUE=o(new E(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),E}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,i,a,o,u,E,s,c,_,l){"use strict";var R=function(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)},T=new e,A=new e,f=new e,h=new e,d=new e,N=new e,I=new e,S=new e,M=new e,O=new e,m=new e,y=new e;R.fromPoints=function(t,n){if(r(n)||(n=new R),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var i=e.clone(t[0],I),a=e.clone(i,T),o=e.clone(i,A),u=e.clone(i,f),E=e.clone(i,h),s=e.clone(i,d),c=e.clone(i,N),_=t.length,l=1;_>l;l++){e.clone(t[l],i);var p=i.x,C=i.y,U=i.z;p<a.x&&e.clone(i,a),p>E.x&&e.clone(i,E),C<o.y&&e.clone(i,o),C>s.y&&e.clone(i,s),U<u.z&&e.clone(i,u),U>c.z&&e.clone(i,c)}var L=e.magnitudeSquared(e.subtract(E,a,S)),v=e.magnitudeSquared(e.subtract(s,o,S)),F=e.magnitudeSquared(e.subtract(c,u,S)),w=a,P=E,x=L;v>x&&(x=v,w=o,P=s),F>x&&(x=F,w=u,P=c);var g=M;g.x=.5*(w.x+P.x),g.y=.5*(w.y+P.y),g.z=.5*(w.z+P.z);var B=e.magnitudeSquared(e.subtract(P,g,S)),D=Math.sqrt(B),z=O;z.x=a.x,z.y=o.y,z.z=u.z;var G=m;G.x=E.x,G.y=s.y,G.z=c.z;var b=e.multiplyByScalar(e.add(z,G,S),.5,y),X=0;for(l=0;_>l;l++){e.clone(t[l],i);var H=e.magnitude(e.subtract(i,b,S));H>X&&(X=H);var V=e.magnitudeSquared(e.subtract(i,g,S));if(V>B){var W=Math.sqrt(V);D=.5*(D+W),B=D*D;var q=W-D;g.x=(D*g.x+q*i.x)/W,g.y=(D*g.y+q*i.y)/W,g.z=(D*g.z+q*i.z)/W}}return X>D?(e.clone(g,n.center),n.radius=D):(e.clone(b,n.center),n.radius=X),n};var p=new u,C=new e,U=new e,L=new t,v=new t;R.fromRectangle2D=function(e,t,n){return R.fromRectangleWithHeights2D(e,t,0,0,n)},R.fromRectangleWithHeights2D=function(t,i,a,o,u){if(r(u)||(u=new R),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,p),l.southwest(t,L),L.height=a,l.northeast(t,v),v.height=o;var E=i.project(L,C),s=i.project(v,U),c=s.x-E.x,_=s.y-E.y,T=s.z-E.z;u.radius=.5*Math.sqrt(c*c+_*_+T*T);var A=u.center;return A.x=E.x+.5*c,A.y=E.y+.5*_,A.z=E.z+.5*T,u};var F=[];R.fromRectangle3D=function(e,t,i,a){t=n(t,o.WGS84),i=n(i,0);var u;return r(e)&&(u=l.subsample(e,t,i,F)),R.fromPoints(u,a)},R.fromVertices=function(t,i,a,o){if(r(o)||(o=new R),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;i=n(i,e.ZERO),a=n(a,3);var u=I;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;for(var E=e.clone(u,T),s=e.clone(u,A),c=e.clone(u,f),_=e.clone(u,h),l=e.clone(u,d),p=e.clone(u,N),C=t.length,U=0;C>U;U+=a){var L=t[U]+i.x,v=t[U+1]+i.y,F=t[U+2]+i.z;u.x=L,u.y=v,u.z=F,L<E.x&&e.clone(u,E),L>_.x&&e.clone(u,_),v<s.y&&e.clone(u,s),v>l.y&&e.clone(u,l),F<c.z&&e.clone(u,c),F>p.z&&e.clone(u,p)}var w=e.magnitudeSquared(e.subtract(_,E,S)),P=e.magnitudeSquared(e.subtract(l,s,S)),x=e.magnitudeSquared(e.subtract(p,c,S)),g=E,B=_,D=w;P>D&&(D=P,g=s,B=l),x>D&&(D=x,g=c,B=p);var z=M;z.x=.5*(g.x+B.x),z.y=.5*(g.y+B.y),z.z=.5*(g.z+B.z);var G=e.magnitudeSquared(e.subtract(B,z,S)),b=Math.sqrt(G),X=O;X.x=E.x,X.y=s.y,X.z=c.z;var H=m;H.x=_.x,H.y=l.y,H.z=p.z;var V=e.multiplyByScalar(e.add(X,H,S),.5,y),W=0;for(U=0;C>U;U+=a){u.x=t[U]+i.x,u.y=t[U+1]+i.y,u.z=t[U+2]+i.z;var q=e.magnitude(e.subtract(u,V,S));q>W&&(W=q);var Y=e.magnitudeSquared(e.subtract(u,z,S));if(Y>G){var K=Math.sqrt(Y);b=.5*(b+K),G=b*b;var k=K-b;z.x=(b*z.x+k*u.x)/K,z.y=(b*z.y+k*u.y)/K,z.z=(b*z.z+k*u.z)/K}}return W>b?(e.clone(z,o.center),o.radius=b):(e.clone(V,o.center),o.radius=W),o},R.fromCornerPoints=function(t,n,i){r(i)||(i=new R);var a=i.center;return e.add(t,n,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,n),i},R.fromEllipsoid=function(t,n){return r(n)||(n=new R),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var w=new e;R.fromBoundingSpheres=function(t,n){if(r(n)||(n=new R),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=t.length;if(1===i)return R.clone(t[0],n);if(2===i)return R.union(t[0],t[1],n);for(var a=[],o=0;i>o;o++)a.push(t[o].center);n=R.fromPoints(a,n);var u=n.center,E=n.radius;for(o=0;i>o;o++){var s=t[o];E=Math.max(E,e.distance(u,s.center,w)+s.radius)}return n.radius=E,n},R.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new R(t.center,t.radius):void 0},R.packedLength=4,R.pack=function(e,t,r){r=n(r,0);var i=e.center;t[r++]=i.x,t[r++]=i.y,t[r++]=i.z,t[r]=e.radius},R.unpack=function(e,t,i){t=n(t,0),r(i)||(i=new R);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var P=new e,x=new e;R.union=function(t,n,i){r(i)||(i=new R);var a=t.center,o=t.radius,u=n.center,E=n.radius,s=e.subtract(u,a,P),c=e.magnitude(s);if(o>=c+E)return t.clone(i),i;if(E>=c+o)return n.clone(i),i;var _=.5*(o+c+E),l=e.multiplyByScalar(s,(-o+_)/c,x);return e.add(l,a,l),e.clone(l,i.center),i.radius=_,i};var g=new e;R.expand=function(t,n,r){r=R.clone(t,r);var i=e.magnitude(e.subtract(n,r.center,g));return i>r.radius&&(r.radius=i),r},R.intersectPlane=function(t,n){var r=t.center,i=t.radius,a=n.normal,o=e.dot(a,r)+n.distance;return-i>o?E.OUTSIDE:i>o?E.INTERSECTING:E.INSIDE},R.transform=function(e,t,n){return r(n)||(n=new R),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=c.getMaximumScale(t)*e.radius,n};var B=new e;R.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,B);return e.magnitudeSquared(r)-t.radius*t.radius},R.transformWithoutScale=function(e,t,n){return r(n)||(n=new R),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var D=new e;R.computePlaneDistances=function(t,n,i,a){r(a)||(a=new s);var o=e.subtract(t.center,n,D),u=e.dot(i,o);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var z=new e,G=new e,b=new e,X=new e,H=new e,V=new t,W=new Array(8),q=0;8>q;++q)W[q]=new e;var Y=new u;return R.projectTo2D=function(t,r,i){r=n(r,Y);var a=r.ellipsoid,o=t.center,u=t.radius,E=a.geodeticSurfaceNormal(o,z),s=e.cross(e.UNIT_Z,E,G);e.normalize(s,s);var c=e.cross(E,s,b);e.normalize(c,c),e.multiplyByScalar(E,u,E),e.multiplyByScalar(c,u,c),e.multiplyByScalar(s,u,s);var _=e.negate(c,H),l=e.negate(s,X),T=W,A=T[0];e.add(E,c,A),e.add(A,s,A),A=T[1],e.add(E,c,A),e.add(A,l,A),A=T[2],e.add(E,_,A),e.add(A,l,A),A=T[3],e.add(E,_,A),e.add(A,s,A),e.negate(E,E),A=T[4],e.add(E,c,A),e.add(A,s,A),A=T[5],e.add(E,c,A),e.add(A,l,A),A=T[6],e.add(E,_,A),e.add(A,l,A),A=T[7],e.add(E,_,A),e.add(A,s,A);for(var f=T.length,h=0;f>h;++h){var d=T[h];e.add(o,d,d);var N=a.cartesianToCartographic(d,V);r.project(N,d)}i=R.fromPoints(T,i),o=i.center;var I=o.x,S=o.y,M=o.z;return o.x=M,o.y=I,o.z=S,i},R.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},R.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},R.prototype.intersectPlane=function(e){return R.intersectPlane(this,e)},R.prototype.distanceSquaredTo=function(e){return R.distanceSquaredTo(this,e)},R.prototype.computePlaneDistances=function(e,t,n){return R.computePlaneDistances(this,e,t,n)},R.prototype.isOccluded=function(e){return R.isOccluded(this,e)},R.prototype.equals=function(e){return R.equals(this,e)},R.prototype.clone=function(e){return R.clone(this,e)},R}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,
DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var E=a[o];i=E+"RequestFullscreen","function"==typeof t[i]?(r.requestFullscreen=i,n=!0):(i=E+"RequestFullScreen","function"==typeof t[i]&&(r.requestFullscreen=i,n=!0)),i=E+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=E+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=E+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=E+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=E+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=E+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=E+"fullscreenchange",e(document["on"+i])&&("ms"===E&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=E+"fullscreenerror",e(document["on"+i])&&("ms"===E&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function i(){if(!t(f)){f=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(f=!0,h=r(e[1]))}return f}function a(){return i()&&h}function o(){if(!t(d)&&(d=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(d=!0,N=r(e[1]))}return d}function u(){return o()&&N}function E(){if(!t(I)){I=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(I=!0,S=r(e[1]),S.isNightly=!!e[2])}return I}function s(){return E()&&S}function c(){if(!t(M)){M=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(M=!0,O=r(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(M=!0,O=r(e[1])))}return M}function _(){return c()&&O}function l(){if(!t(m)){m=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,y=r(e[1]))}return m}function R(){return t(p)||(p=/Windows/i.test(navigator.appVersion)),p}function T(){return l()&&y}function A(){return t(C)||(C=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),C}var f,h,d,N,I,S,M,O,m,y,p,C,U={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:E,webkitVersion:s,isInternetExplorer:c,internetExplorerVersion:_,isFirefox:l,firefoxVersion:T,isWindows:R,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:A};return U.supportsFullscreen=function(){return n.supportsFullscreen()},U.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},U.supportsWebWorkers=function(){return"undefined"!=typeof Worker},U}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,i,a){"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return n(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,n,i,a){switch(i=t(i,0),a=t(a,(n.byteLength-i)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(n,i,a);case o.UNSIGNED_BYTE:return new Uint8Array(n,i,a);case o.SHORT:return new Int16Array(n,i,a);case o.UNSIGNED_SHORT:return new Uint16Array(n,i,a);case o.FLOAT:return new Float32Array(n,i,a);case o.DOUBLE:return new Float64Array(n,i,a);default:throw new r("componentDatatype is not a valid value.")}},a(o)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,i,a,o,u){"use strict";var E=function(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)},s=new e;E.fromAxisAngle=function(t,r,i){var a=r/2,o=Math.sin(a);s=e.normalize(t,s);var u=s.x*o,c=s.y*o,_=s.z*o,l=Math.cos(a);return n(i)?(i.x=u,i.y=c,i.z=_,i.w=l,i):new E(u,c,_,l)};var c=[1,2,0],_=new Array(3);E.fromRotationMatrix=function(e,t){var r,i,a,o,s,l=e[u.COLUMN0ROW0],R=e[u.COLUMN1ROW1],T=e[u.COLUMN2ROW2],A=l+R+T;if(A>0)r=Math.sqrt(A+1),s=.5*r,r=.5/r,i=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var f=c,h=0;R>l&&(h=1),T>l&&T>R&&(h=2);var d=f[h],N=f[d];r=Math.sqrt(e[u.getElementIndex(h,h)]-e[u.getElementIndex(d,d)]-e[u.getElementIndex(N,N)]+1);var I=_;I[h]=.5*r,r=.5/r,s=(e[u.getElementIndex(N,d)]-e[u.getElementIndex(d,N)])*r,I[d]=(e[u.getElementIndex(d,h)]+e[u.getElementIndex(h,d)])*r,I[N]=(e[u.getElementIndex(N,h)]+e[u.getElementIndex(h,N)])*r,i=-I[0],a=-I[1],o=-I[2]}return n(t)?(t.x=i,t.y=a,t.z=o,t.w=s,t):new E(i,a,o,s)};var l=new E;E.fromHeadingPitchRoll=function(t,n,r,i){var a=E.fromAxisAngle(e.UNIT_X,r,l),o=E.fromAxisAngle(e.UNIT_Y,-n,i);i=E.multiply(o,a,o);var u=E.fromAxisAngle(e.UNIT_Z,-t,l);return E.multiply(u,i,i)};var R=new e,T=new e,A=new E,f=new E,h=new E;E.packedLength=4,E.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},E.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new E),i.x=e[r],i.y=e[r+1],i.z=e[r+2],i.w=e[r+3],i},E.packedInterpolationLength=3,E.convertPackedArrayForInterpolation=function(e,t,n,r){E.unpack(e,4*n,h),E.conjugate(h,h);for(var i=0,a=n-t+1;a>i;i++){var o=3*i;E.unpack(e,4*(t+i),A),E.multiply(A,h,A),A.w<0&&E.negate(A,A),E.computeAxis(A,R);var u=E.computeAngle(A);r[o]=R.x*u,r[o+1]=R.y*u,r[o+2]=R.z*u}},E.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new E),e.fromArray(t,0,T);var u=e.magnitude(T);return E.unpack(r,4*a,f),0===u?E.clone(E.IDENTITY,A):E.fromAxisAngle(T,u,A),E.multiply(A,f,o)},E.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new E(e.x,e.y,e.z,e.w):void 0},E.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},E.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},E.magnitude=function(e){return Math.sqrt(E.magnitudeSquared(e))},E.normalize=function(e,t){var n=1/E.magnitude(e),r=e.x*n,i=e.y*n,a=e.z*n,o=e.w*n;return t.x=r,t.y=i,t.z=a,t.w=o,t},E.inverse=function(e,t){var n=E.magnitudeSquared(e);return t=E.conjugate(e,t),E.multiplyByScalar(t,1/n,t)},E.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},E.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},E.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},E.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},E.multiply=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t.x,E=t.y,s=t.z,c=t.w,_=o*u+r*c+i*s-a*E,l=o*E-r*s+i*c+a*u,R=o*s+r*E-i*u+a*c,T=o*c-r*u-i*E-a*s;return n.x=_,n.y=l,n.z=R,n.w=T,n},E.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},E.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},E.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},E.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var d=new E;E.lerp=function(e,t,n,r){return d=E.multiplyByScalar(t,n,d),r=E.multiplyByScalar(e,1-n,r),E.add(d,r,r)};var N=new E,I=new E,S=new E;E.slerp=function(e,t,n,r){var i=E.dot(e,t),a=t;if(0>i&&(i=-i,a=N=E.negate(t,N)),1-i<o.EPSILON6)return E.lerp(e,a,n,r);var u=Math.acos(i);return I=E.multiplyByScalar(e,Math.sin((1-n)*u),I),S=E.multiplyByScalar(a,Math.sin(n*u),S),r=E.add(I,S,r),E.multiplyByScalar(r,1/Math.sin(u),r)},E.log=function(t,n){var r=o.acosClamped(t.w),i=0;return 0!==r&&(i=r/Math.sin(r)),e.multiplyByScalar(t,i,n)},E.exp=function(t,n){var r=e.magnitude(t),i=0;return 0!==r&&(i=Math.sin(r)/r),n.x=t.x*i,n.y=t.y*i,n.z=t.z*i,n.w=Math.cos(r),n};var M=new e,O=new e,m=new E,y=new E;E.computeInnerQuadrangle=function(t,n,r,i){var a=E.conjugate(n,m);E.multiply(a,r,y);var o=E.log(y,M);E.multiply(a,t,y);var u=E.log(y,O);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),E.exp(o,m),E.multiply(n,m,i)},E.squad=function(e,t,n,r,i,a){var o=E.slerp(e,t,i,m),u=E.slerp(n,r,i,y);return E.slerp(o,u,2*i*(1-i),a)};for(var p=new E,C=1.9011074535173003,U=i.supportsTypedArrays()?new Float32Array(8):[],L=i.supportsTypedArrays()?new Float32Array(8):[],v=i.supportsTypedArrays()?new Float32Array(8):[],F=i.supportsTypedArrays()?new Float32Array(8):[],w=0;7>w;++w){var P=w+1,x=2*P+1;U[w]=1/(P*x),L[w]=P/x}return U[7]=C/136,L[7]=8*C/17,E.fastSlerp=function(e,t,n,r){var i,a=E.dot(e,t);a>=0?i=1:(i=-1,a=-a);for(var o=a-1,u=1-n,s=n*n,c=u*u,_=7;_>=0;--_)v[_]=(U[_]*s-L[_])*o,F[_]=(U[_]*c-L[_])*o;var l=i*n*(1+v[0]*(1+v[1]*(1+v[2]*(1+v[3]*(1+v[4]*(1+v[5]*(1+v[6]*(1+v[7])))))))),R=u*(1+F[0]*(1+F[1]*(1+F[2]*(1+F[3]*(1+F[4]*(1+F[5]*(1+F[6]*(1+F[7])))))))),T=E.multiplyByScalar(e,R,p);return E.multiplyByScalar(t,l,r),E.add(T,r,r)},E.fastSquad=function(e,t,n,r,i,a){var o=E.fastSlerp(e,t,i,m),u=E.fastSlerp(n,r,i,y);return E.fastSlerp(o,u,2*i*(1-i),a)},E.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},E.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},E.ZERO=a(new E(0,0,0,0)),E.IDENTITY=a(new E(0,0,0,1)),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.prototype.equalsEpsilon=function(e,t){return E.equalsEpsilon(this,e,t)},E.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},E}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,n,r){"use strict";function i(t,i,a,c,_,l,R,T,A,f){var h=t+i;e.multiplyByScalar(c,Math.cos(h),o),e.multiplyByScalar(a,Math.sin(h),u),e.add(o,u,o);var d=Math.cos(t);d*=d;var N=Math.sin(t);N*=N;var I=l/Math.sqrt(R*d+_*N),S=I/T;return r.fromAxisAngle(o,S,E),n.fromQuaternion(E,s),n.multiplyByVector(s,A,f),e.normalize(f,f),e.multiplyByScalar(f,T,f),f}var a={},o=new e,u=new e,E=new r,s=new n,c=new e,_=new e,l=new e,R=new e;a.raisePositionsToHeight=function(t,n,r){for(var i=n.ellipsoid,a=n.height,o=n.extrudedHeight,u=r?t.length/3*2:t.length/3,E=new Float64Array(3*u),s=t.length,T=r?s:0,A=0;s>A;A+=3){var f=A+1,h=A+2,d=e.fromArray(t,A,c);i.scaleToGeodeticSurface(d,d);var N=e.clone(d,_),I=i.geodeticSurfaceNormal(d,R),S=e.multiplyByScalar(I,a,l);e.add(d,S,d),r&&(e.multiplyByScalar(I,o,S),e.add(N,S,N),E[A+T]=N.x,E[f+T]=N.y,E[h+T]=N.z),E[A]=d.x,E[f]=d.y,E[h]=d.z}return E};var T=new e,A=new e,f=new e;return a.computeEllipsePositions=function(n,r,a){var o=n.semiMinorAxis,u=n.semiMajorAxis,E=n.rotation,s=n.center,R=8*n.granularity,h=o*o,d=u*u,N=u*o,I=e.magnitude(s),S=e.normalize(s,T),M=e.cross(e.UNIT_Z,s,A);M=e.normalize(M,M);var O=e.cross(S,M,f),m=1+Math.ceil(t.PI_OVER_TWO/R),y=t.PI_OVER_TWO/(m-1),p=t.PI_OVER_TWO-m*y;0>p&&(m-=Math.ceil(Math.abs(p)/y));var C,U,L,v,F,w=2*m*(m+1),P=r?new Array(3*w):void 0,x=0,g=c,B=_,D=3*(2*m+2*(m-1)),z=D-1,G=0,b=a?new Array(D):void 0;for(p=t.PI_OVER_TWO,C=0;m>C;++C){if(g=i(p,E,O,M,h,N,d,I,S,g),B=i(Math.PI-p,E,O,M,h,N,d,I,S,B),r){for(P[x++]=g.x,P[x++]=g.y,P[x++]=g.z,L=2*C+2,U=1;L-1>U;++U)v=U/(L-1),F=e.lerp(g,B,v,l),P[x++]=F.x,P[x++]=F.y,P[x++]=F.z;P[x++]=B.x,P[x++]=B.y,P[x++]=B.z}a&&(b[z--]=g.z,b[z--]=g.y,b[z--]=g.x,0!==C&&(b[G++]=B.x,b[G++]=B.y,b[G++]=B.z)),p=t.PI_OVER_TWO-(C+1)*y}for(C=m;C>0;--C){if(p=t.PI_OVER_TWO-(C-1)*y,g=i(-p,E,O,M,h,N,d,I,S,g),B=i(p+Math.PI,E,O,M,h,N,d,I,S,B),r){for(P[x++]=g.x,P[x++]=g.y,P[x++]=g.z,L=2*(C-1)+2,U=1;L-1>U;++U)v=U/(L-1),F=e.lerp(g,B,v,l),P[x++]=F.x,P[x++]=F.y,P[x++]=F.z;P[x++]=B.x,P[x++]=B.y,P[x++]=B.z}a&&(b[z--]=g.z,b[z--]=g.y,b[z--]=g.x,1!==C&&(b[G++]=B.x,b[G++]=B.y,b[G++]=B.z))}var X={};return r&&(X.positions=P,X.numPts=m),a&&(X.outerPositions=b),X},a}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var n={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===n.POINTS||e===n.LINES||e===n.LINE_LOOP||e===n.LINE_STRIP||e===n.TRIANGLES||e===n.TRIANGLE_STRIP||e===n.TRIANGLE_FAN}};return t(n)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,i){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,i.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(e){var r=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return r}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(e){return t(e)&&(e===a.UNSIGNED_BYTE||e===a.UNSIGNED_SHORT||e===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,n,r){return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,r):new Uint16Array(t,n,r)},r(a)}),define("Core/EllipseOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,n,r,i,a,o,u,E,s,c,_,l,R){"use strict";function T(r){var i=r.center;h=t.multiplyByScalar(r.ellipsoid.geodeticSurfaceNormal(i,h),r.height,h),h=t.add(i,h,h);for(var a=new e(h,r.semiMajorAxis),u=o.computeEllipsePositions(r,!1,!0).outerPositions,E=new c({position:new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:o.raisePositionsToHeight(u,r,!1)})}),l=u.length/3,R=_.createTypedArray(l,2*l),T=0,A=0;l>A;++A)R[T++]=A,R[T++]=(A+1)%l;return{boundingSphere:a,attributes:E,indices:R}}function A(i){var a=r(i.numberOfVerticalLines,16);a=Math.max(a,0);var u=i.center,E=i.ellipsoid,l=i.semiMajorAxis,R=t.multiplyByScalar(E.geodeticSurfaceNormal(u,f),i.height,f);d.center=t.add(u,R,d.center),d.radius=l,R=t.multiplyByScalar(E.geodeticSurfaceNormal(u,R),i.extrudedHeight,R),N.center=t.add(u,R,N.center),N.radius=l;var T=o.computeEllipsePositions(i,!1,!0).outerPositions,A=new c({position:new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:o.raisePositionsToHeight(T,i,!0)})});T=A.position.values;var h=e.union(d,N),I=T.length/3,S=_.createTypedArray(I,2*I+2*a);I/=2;var M,O=0;for(M=0;I>M;++M)S[O++]=M,S[O++]=(M+1)%I,S[O++]=M+I,S[O++]=(M+1)%I+I;var m;if(a>0){var y=Math.min(a,I);m=Math.round(I/y)}var p=Math.min(m*a,I);if(a>0)for(M=0;p>M;M+=m)S[O++]=M,S[O++]=M+I;return{boundingSphere:h,attributes:A,indices:S}}var f=new t,h=new t,d=new e,N=new e,I=function(e){e=r(e,r.EMPTY_OBJECT);var n=e.center,a=r(e.ellipsoid,u.WGS84),o=e.semiMajorAxis,E=e.semiMinorAxis,s=r(e.granularity,l.RADIANS_PER_DEGREE),c=r(e.height,0),_=e.extrudedHeight,R=i(_)&&Math.abs(c-_)>1;this._center=t.clone(n),this._semiMajorAxis=o,this._semiMinorAxis=E,this._ellipsoid=u.clone(a),this._rotation=r(e.rotation,0),this._height=c,this._granularity=s,this._extrudedHeight=_,this._extrude=R,this._numberOfVerticalLines=Math.max(r(e.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"};I.packedLength=t.packedLength+u.packedLength+9,I.pack=function(e,n,a){a=r(a,0),t.pack(e._center,n,a),a+=t.packedLength,u.pack(e._ellipsoid,n,a),a+=u.packedLength,n[a++]=e._semiMajorAxis,n[a++]=e._semiMinorAxis,n[a++]=e._rotation,n[a++]=e._height,n[a++]=e._granularity,n[a++]=i(e._extrudedHeight)?1:0,n[a++]=r(e._extrudedHeight,0),n[a++]=e._extrude?1:0,n[a]=e._numberOfVerticalLines};var S=new t,M=new u,O={center:S,ellipsoid:M,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0};return I.unpack=function(e,n,a){n=r(n,0);var o=t.unpack(e,n,S);n+=t.packedLength;var E=u.unpack(e,n,M);n+=u.packedLength;var s=e[n++],c=e[n++],_=e[n++],l=e[n++],R=e[n++],T=e[n++],A=e[n++],f=1===e[n++],h=e[n];return i(a)?(a._center=t.clone(o,a._center),a._ellipsoid=u.clone(E,a._ellipsoid),a._semiMajorAxis=s,a._semiMinorAxis=c,a._rotation=_,a._height=l,a._granularity=R,a._extrudedHeight=T?A:void 0,a._extrude=f,a._numberOfVerticalLines=h,a):(O.height=l,O.extrudedHeight=T?A:void 0,O.granularity=R,O.rotation=_,O.semiMajorAxis=s,O.semiMinorAxis=c,O.numberOfVerticalLines=h,new I(O))},I.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,n={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(n.extrudedHeight=Math.min(e._extrudedHeight,e._height),n.height=Math.max(e._extrudedHeight,e._height),t=A(n)):t=T(n),new E({attributes:t.attributes,indices:t.indices,primitiveType:R.LINES,boundingSphere:t.boundingSphere})},I}),define("Workers/createEllipseOutlineGeometry",["../Core/Cartesian3","../Core/defined","../Core/EllipseOutlineGeometry","../Core/Ellipsoid"],function(e,t,n,r){"use strict";function i(i,a){return t(a)&&(i=n.unpack(i,a)),i._center=e.clone(i._center),i._ellipsoid=r.clone(i._ellipsoid),n.createGeometry(i)}return i})}();