/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,r,n,i){i=t(i,n);var a=Math.abs(e-r);return i>=a||a<=n*Math.max(Math.abs(e),Math.abs(r))};var a=[1];i.factorial=function(e){var t=a.length;if(e>=t)for(var r=a[t-1],n=t;e>=n;n++)a.push(r*n);return a[e]},i.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new e;return i.setRandomNumberSeed=function(t){o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};a.fromSpherical=function(r,n){t(n)||(n=new a);var i=r.clock,o=r.cone,u=e(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(i),n.y=s*Math.sin(i),n.z=u*Math.cos(o),n},a.fromElements=function(e,r,n,i){return t(i)?(i.x=e,i.y=r,i.z=n,i):new a(e,r,n)},a.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.x=r[n++],i.y=r[n++],i.z=r[n],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},a.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var r=a.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},a.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},a.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},a.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},a.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},a.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new a;a.lerp=function(e,t,r,n){return a.multiplyByScalar(t,r,u),n=a.multiplyByScalar(e,1-r,n),a.add(u,n,n)};var s=new a,c=new a;a.angleBetween=function(e,t){a.normalize(e,s),a.normalize(t,c);var r=a.dot(s,c),n=a.magnitude(a.cross(s,c,s));return Math.atan2(n,r)};var l=new a;a.mostOrthogonalAxis=function(e,t){var r=a.normalize(e,l);return a.abs(r,r),t=r.x<=r.y?r.x<=r.z?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Z,t):r.y<=r.z?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_Z,t)},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,r,n,a){return e===r||t(e)&&t(r)&&i.equalsEpsilon(e.x,r.x,n,a)&&i.equalsEpsilon(e.y,r.y,n,a)&&i.equalsEpsilon(e.z,r.z,n,a)},a.cross=function(e,t,r){var n=e.x,i=e.y,a=e.z,o=t.x,u=t.y,s=t.z,c=i*s-a*u,l=a*o-n*s,E=n*u-i*o;return r.x=c,r.y=l,r.z=E,r},a.fromDegrees=function(e,t,r,n,o){var u=i.toRadians(e),s=i.toRadians(t);return a.fromRadians(u,s,r,n,o)};var E=new a,f=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(r,n,i,o,u){i=e(i,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(n);E.x=c*Math.cos(r),E.y=c*Math.sin(r),E.z=Math.sin(n),E=a.normalize(E,E),a.multiplyComponents(s,E,f);var l=Math.sqrt(a.dot(E,f));return f=a.divideByScalar(f,l,f),E=a.multiplyByScalar(E,i,E),t(u)||(u=new a),a.add(f,E,u)},a.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=i.toRadians(e[o]);return a.fromRadiansArray(n,t,r)},a.fromRadiansArray=function(e,r,n){var i=e.length;t(n)?n.length=i/2:n=new Array(i/2);for(var o=0;i>o;o+=2){var u=e[o],s=e[o+1];n[o/2]=a.fromRadians(u,s,0,r,n[o/2])}return n},a.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o+=3)n[o]=i.toRadians(e[o]),n[o+1]=i.toRadians(e[o+1]),n[o+2]=e[o+2];return a.fromRadiansArrayHeights(n,t,r)},a.fromRadiansArrayHeights=function(e,r,n){var i=e.length;t(n)?n.length=i/3:n=new Array(i/3);for(var o=0;i>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];n[o/3]=a.fromRadians(u,s,c,r,n[o/3])}return n},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return a.fromRadians=function(r,n,i,o){return i=e(i,0),t(o)?(o.longitude=r,o.latitude=n,o.height=i,o):new a(r,n,i)},a.fromDegrees=function(e,t,r,n){return e=i.toRadians(e),t=i.toRadians(t),a.fromRadians(e,t,r,n)},a.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},a.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var r={},n=function(t,n){e(r[t])||(r[t]=!0,console.log(n))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(t,n,i,a){n=r(n,0),i=r(i,0),a=r(a,0),t._radii=new e(n,i,a),t._radiiSquared=new e(n*n,i*i,a*a),t._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(n,i,a),t._maximumRadius=Math.max(n,i,a),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,r)};i(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var i=t._radii;return n(r)?(e.clone(i,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(i.x,i.y,i.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,i){i=r(i,0),e.pack(t._radii,n,i)},c.unpack=function(t,n,i){n=r(n,0);var a=e.unpack(t,n);return c.fromCartesian3(a,i)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var i=t.longitude,a=t.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,E=new e;c.prototype.cartographicToCartesian=function(t,r){var i=l,a=E;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),n(r)||(r=new e),e.add(a,i,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;r>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var f=new e,d=new e,_=new e;c.prototype.cartesianToCartographic=function(r,i){var a=this.scaleToGeodeticSurface(r,d);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,f),s=e.subtract(r,a,_),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),E=u.sign(e.dot(s,r))*e.magnitude(s);return n(i)?(i.longitude=c,i.latitude=l,i.height=E,i):new t(c,l,E)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;r>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t};var h=new e,m=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var i=t.x,a=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,E=s.z,f=i*i*c*c,d=a*a*l*l,_=o*o*E*E,y=f+d+_,p=Math.sqrt(1/y),T=e.multiplyByScalar(t,p,h);if(y<this._centerToleranceSquared)return isFinite(p)?e.clone(T,r):void 0;var R=this._oneOverRadiiSquared,A=R.x,v=R.y,N=R.z,S=m;S.x=T.x*A*2,S.y=T.y*v*2,S.z=T.z*N*2;var I,M,O,g,x,w,C,L,P,F,U,b=(1-p)*e.magnitude(t)/(.5*e.magnitude(S)),D=0;do{b-=D,O=1/(1+b*A),g=1/(1+b*v),x=1/(1+b*N),w=O*O,C=g*g,L=x*x,P=w*O,F=C*g,U=L*x,I=f*w+d*C+_*L-1,M=f*P*A+d*F*v+_*U*N;var B=-2*M;D=I/B}while(Math.abs(I)>u.EPSILON12);return n(r)?(r.x=i*O,r.y=a*g,r.z=o*x,r):new e(i*O,a*g,o*x)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var i=t.x,a=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,u=e.z;return n(r)?(r.longitude=a,r.latitude=o,r.height=u,r):new t(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r,n,i){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(i,0)};a.fromElements=function(e,r,n,i,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=i,o):new a(e,r,n,i)},a.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.x=r[n++],i.y=r[n++],i.z=r[n++],i.w=r[n],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},a.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var r=a.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},a.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},a.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},a.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},a.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},a.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new a;a.lerp=function(e,t,r,n){return a.multiplyByScalar(t,r,u),n=a.multiplyByScalar(e,1-r,n),a.add(u,n,n)};var s=new a;return a.mostOrthogonalAxis=function(e,t){var r=a.normalize(e,s);return a.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?a.clone(a.UNIT_X,t):a.clone(a.UNIT_W,t):r.z<=r.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t):r.y<=r.z?r.y<=r.w?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_W,t):r.z<=r.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t)},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,r,n,a){return e===r||t(e)&&t(r)&&i.equalsEpsilon(e.x,r.x,n,a)&&i.equalsEpsilon(e.y,r.y,n,a)&&i.equalsEpsilon(e.z,r.z,n,a)&&i.equalsEpsilon(e.w,r.w,n,a)},a.ZERO=n(new a(0,0,0,0)),a.UNIT_X=n(new a(1,0,0,0)),a.UNIT_Y=n(new a(0,1,0,0)),a.UNIT_Z=n(new a(0,0,1,0)),a.UNIT_W=n(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function u(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(d[r],f[r])];t+=2*n*n}return Math.sqrt(t)}function s(e,t){for(var r=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(d[o],f[o])]);u>n&&(i=o,n=u)}var s=1,l=0,E=f[i],_=d[i];if(Math.abs(e[c.getElementIndex(_,E)])>r){var h,m=e[c.getElementIndex(_,_)],y=e[c.getElementIndex(E,E)],p=e[c.getElementIndex(_,E)],T=(m-y)/2/p;h=0>T?-1/(-T+Math.sqrt(1+T*T)):1/(T+Math.sqrt(1+T*T)),s=1/Math.sqrt(1+h*h),l=h*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(E,E)]=t[c.getElementIndex(_,_)]=s,t[c.getElementIndex(_,E)]=l,t[c.getElementIndex(E,_)]=-l,t}var c=function(e,r,n,i,a,o,u,s,c){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(a,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,i){return n=t(n,0),r(i)||(i=new c),i[0]=e[n++],i[1]=e[n++],i[2]=e[n++],i[3]=e[n++],i[4]=e[n++],i[5]=e[n++],i[6]=e[n++],i[7]=e[n++],i[8]=e[n++],i},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,i){return n=t(n,0),r(i)||(i=new c),i[0]=e[n],i[1]=e[n+1],i[2]=e[n+2],i[3]=e[n+3],i[4]=e[n+4],i[5]=e[n+5],i[6]=e[n+6],i[7]=e[n+7],i[8]=e[n+8],i},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,i=e.x*e.y,a=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,E=e.z*e.z,f=e.z*e.w,d=e.w*e.w,_=n-u-E+d,h=2*(i-f),m=2*(a+l),y=2*(i+f),p=-n+u-E+d,T=2*(s-o),R=2*(a-l),A=2*(s+o),v=-n-u+E+d;return r(t)?(t[0]=_,t[1]=y,t[2]=R,t[3]=h,t[4]=p,t[5]=A,t[6]=m,t[7]=T,t[8]=v,t):new c(_,h,m,y,p,T,R,A,v)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new c(1,0,0,0,n,-i,0,i,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new c(n,0,i,0,1,0,-i,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-i,0,i,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,i=e[n],a=e[n+1],o=e[n+2];return r.x=i,r.y=a,r.z=o,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var i=3*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n},c.getRow=function(e,t,r){var n=e[t],i=e[t+3],a=e[t+6];return r.x=n,r.y=i,r.z=a,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],i=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],E=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=E,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,i=t.y,a=t.z,o=e[0]*n+e[3]*i+e[6]*a,u=e[1]*n+e[4]*i+e[7]*a,s=e[2]*n+e[5]*i+e[8]*a;return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=i,t[3]=a,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var f=[1,0,0],d=[2,2,1],_=new c,h=new c;return c.computeEigenDecomposition=function(e,t){var n=a.EPSILON20,i=10,l=0,E=0;r(t)||(t={});for(var f=t.unitary=c.clone(c.IDENTITY,t.unitary),d=t.diagonal=c.clone(e,t.diagonal),m=n*o(d);i>E&&u(d)>m;)s(d,_),c.transpose(_,h),c.multiply(d,_,d),c.multiply(h,d,d),c.multiply(f,_,f),++l>2&&(++E,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],i=e[1],a=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(a*c-s*o)+i*(s*n-r*c)+u*(r*o-a*n)},c.inverse=function(e,t){var r=e[0],i=e[1],o=e[2],u=e[3],s=e[4],l=e[5],E=e[6],f=e[7],d=e[8],_=c.determinant(e);if(Math.abs(_)<=a.EPSILON15)throw new n("matrix is not invertible");t[0]=s*d-f*l,t[1]=f*o-i*d,t[2]=i*l-s*o,t[3]=E*l-u*d,t[4]=r*d-E*o,t[5]=u*o-r*l,t[6]=u*f-E*s,t[7]=E*i-r*f,t[8]=r*s-u*i;var h=1/_;return c.multiplyByScalar(t,h,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=i(new c(1,0,0,0,1,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s){"use strict";var c=function(e,t,n,i,a,o,u,s,c,l,E,f,d,_,h,m){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(c,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(_,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(E,0),this[11]=r(h,0),this[12]=r(i,0),this[13]=r(s,0),this[14]=r(f,0),this[15]=r(m,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,i){return t=r(t,0),n(i)||(i=new c),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,i,a){return i=r(i,e.ZERO),n(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new c(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,i){n(i)||(i=new c);var a=r.x,o=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,E=t.x*t.z,f=t.x*t.w,d=t.y*t.y,_=t.y*t.z,h=t.y*t.w,m=t.z*t.z,y=t.z*t.w,p=t.w*t.w,T=s-d-m+p,R=2*(l-y),A=2*(E+h),v=2*(l+y),N=-s+d-m+p,S=2*(_-f),I=2*(E-h),M=2*(_+f),O=-s-d+m+p;return i[0]=T*a,i[1]=v*a,i[2]=I*a,i[3]=0,i[4]=R*o,i[5]=N*o,i[6]=M*o,i[7]=0,i[8]=A*u,i[9]=S*u,i[10]=O*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,E=new e,f=new e;c.fromCamera=function(t,r){var i=t.eye,a=t.target,o=t.up;e.normalize(e.subtract(a,i,l),l),e.normalize(e.cross(l,o,E),E),e.normalize(e.cross(E,l,f),f);var u=E.x,s=E.y,d=E.z,_=l.x,h=l.y,m=l.z,y=f.x,p=f.y,T=f.z,R=i.x,A=i.y,v=i.z,N=u*-R+s*-A+d*-v,S=y*-R+p*-A+T*-v,I=_*R+h*A+m*v;return n(r)?(r[0]=u,r[1]=y,r[2]=-_,r[3]=0,r[4]=s,r[5]=p,r[6]=-h,r[7]=0,r[8]=d,r[9]=T,r[10]=-m,r[11]=0,r[12]=N,r[13]=S,r[14]=I,r[15]=1,r):new c(u,s,d,N,y,p,T,S,-_,-h,-m,I,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,i){var a=Math.tan(.5*e),o=1/a,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},c.computeOrthographicOffCenter=function(e,t,r,n,i,a,o){var u=1/(t-e),s=1/(n-r),c=1/(a-i),l=-(t+e)*u,E=-(n+r)*s,f=-(a+i)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=E,o[14]=f,o[15]=1,
o},c.computePerspectiveOffCenter=function(e,t,r,n,i,a,o){var u=2*i/(t-e),s=2*i/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),E=-(a+i)/(a-i),f=-1,d=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=E,o[11]=f,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,i,a){var o=2*i/(t-e),u=2*i/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,E=-1,f=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=c,a[10]=l,a[11]=E,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},c.computeViewportTransformation=function(e,t,n,i){e=r(e,r.EMPTY_OBJECT);var a=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,E=.5*(n-t),f=c,d=l,_=E,h=a+c,m=o+l,y=t+E,p=1;return i[0]=f,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=_,i[11]=0,i[12]=h,i[13]=m,i[14]=y,i[15]=p,i},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,i=e[n],a=e[n+1],o=e[n+2],u=e[n+3];return r.x=i,r.y=a,r.z=o,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var i=4*t;return n[i]=r.x,n[i+1]=r.y,n[i+2]=r.z,n[i+3]=r.w,n},c.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},c.getRow=function(e,t,r){var n=e[t],i=e[t+4],a=e[t+8],o=e[t+12];return r.x=n,r.y=i,r.z=a,r.w=o,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var d=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),r};var _=new e;c.getMaximumScale=function(t){return c.getScale(t,_),e.maximumComponent(_)},c.multiply=function(e,t,r){var n=e[0],i=e[1],a=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],E=e[8],f=e[9],d=e[10],_=e[11],h=e[12],m=e[13],y=e[14],p=e[15],T=t[0],R=t[1],A=t[2],v=t[3],N=t[4],S=t[5],I=t[6],M=t[7],O=t[8],g=t[9],x=t[10],w=t[11],C=t[12],L=t[13],P=t[14],F=t[15],U=n*T+u*R+E*A+h*v,b=i*T+s*R+f*A+m*v,D=a*T+c*R+d*A+y*v,B=o*T+l*R+_*A+p*v,z=n*N+u*S+E*I+h*M,G=i*N+s*S+f*I+m*M,V=a*N+c*S+d*I+y*M,q=o*N+l*S+_*I+p*M,H=n*O+u*g+E*x+h*w,X=i*O+s*g+f*x+m*w,W=a*O+c*g+d*x+y*w,Y=o*O+l*g+_*x+p*w,k=n*C+u*L+E*P+h*F,K=i*C+s*L+f*P+m*F,j=a*C+c*L+d*P+y*F,Z=o*C+l*L+_*P+p*F;return r[0]=U,r[1]=b,r[2]=D,r[3]=B,r[4]=z,r[5]=G,r[6]=V,r[7]=q,r[8]=H,r[9]=X,r[10]=W,r[11]=Y,r[12]=k,r[13]=K,r[14]=j,r[15]=Z,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=e[12],d=e[13],_=e[14],h=t[0],m=t[1],y=t[2],p=t[4],T=t[5],R=t[6],A=t[8],v=t[9],N=t[10],S=t[12],I=t[13],M=t[14],O=n*h+o*m+c*y,g=i*h+u*m+l*y,x=a*h+s*m+E*y,w=n*p+o*T+c*R,C=i*p+u*T+l*R,L=a*p+s*T+E*R,P=n*A+o*v+c*N,F=i*A+u*v+l*N,U=a*A+s*v+E*N,b=n*S+o*I+c*M+f,D=i*S+u*I+l*M+d,B=a*S+s*I+E*M+_;return r[0]=O,r[1]=g,r[2]=x,r[3]=0,r[4]=w,r[5]=C,r[6]=L,r[7]=0,r[8]=P,r[9]=F,r[10]=U,r[11]=0,r[12]=b,r[13]=D,r[14]=B,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=t[0],d=t[1],_=t[2],h=t[3],m=t[4],y=t[5],p=t[6],T=t[7],R=t[8],A=n*f+o*d+c*_,v=i*f+u*d+l*_,N=a*f+s*d+E*_,S=n*h+o*m+c*y,I=i*h+u*m+l*y,M=a*h+s*m+E*y,O=n*p+o*T+c*R,g=i*p+u*T+l*R,x=a*p+s*T+E*R;return r[0]=A,r[1]=v,r[2]=N,r[3]=0,r[4]=S,r[5]=I,r[6]=M,r[7]=0,r[8]=O,r[9]=g,r[10]=x,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,i=t.y,a=t.z,o=n*e[0]+i*e[4]+a*e[8]+e[12],u=n*e[1]+i*e[5]+a*e[9]+e[13],s=n*e[2]+i*e[6]+a*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var h=new e;c.multiplyByUniformScale=function(e,t,r){return h.x=t,h.y=t,h.z=t,c.multiplyByScale(e,h,r)},c.multiplyByScale=function(e,t,r){var n=t.x,i=t.y,a=t.z;return 1===n&&1===i&&1===a?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=i*e[4],r[5]=i*e[5],r[6]=i*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,i=t.y,a=t.z,o=t.w,u=e[0]*n+e[4]*i+e[8]*a+e[12]*o,s=e[1]*n+e[5]*i+e[9]*a+e[13]*o,c=e[2]*n+e[6]*i+e[10]*a+e[14]*o,l=e[3]*n+e[7]*i+e[11]*a+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,i=t.y,a=t.z,o=e[0]*n+e[4]*i+e[8]*a,u=e[1]*n+e[5]*i+e[9]*a,s=e[2]*n+e[6]*i+e[10]*a;return r.x=o,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,i=t.y,a=t.z,o=e[0]*n+e[4]*i+e[8]*a+e[12],u=e[1]*n+e[5]*i+e[9]*a+e[13],s=e[2]*n+e[6]*i+e[10]*a+e[14];return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],i=e[3],a=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new u,y=new u,p=new t,T=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,m),y,o.EPSILON7)&&t.equals(c.getRow(e,3,p),T))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],i=e[4],a=e[8],l=e[12],E=e[1],f=e[5],d=e[9],_=e[13],h=e[2],R=e[6],A=e[10],v=e[14],N=e[3],S=e[7],I=e[11],M=e[15],O=A*M,g=v*I,x=R*M,w=v*S,C=R*I,L=A*S,P=h*M,F=v*N,U=h*I,b=A*N,D=h*S,B=R*N,z=O*f+w*d+C*_-(g*f+x*d+L*_),G=g*E+P*d+b*_-(O*E+F*d+U*_),V=x*E+F*f+D*_-(w*E+P*f+B*_),q=L*E+U*f+B*d-(C*E+b*f+D*d),H=g*i+x*a+L*l-(O*i+w*a+C*l),X=O*n+F*a+U*l-(g*n+P*a+b*l),W=w*n+P*i+B*l-(x*n+F*i+D*l),Y=C*n+b*i+D*a-(L*n+U*i+B*a);O=a*_,g=l*d,x=i*_,w=l*f,C=i*d,L=a*f,P=n*_,F=l*E,U=n*d,b=a*E,D=n*f,B=i*E;var k=O*S+w*I+C*M-(g*S+x*I+L*M),K=g*N+P*I+b*M-(O*N+F*I+U*M),j=x*N+F*S+D*M-(w*N+P*S+B*M),Z=L*N+U*S+B*I-(C*N+b*S+D*I),Q=x*A+L*v+g*R-(C*v+O*R+w*A),J=U*v+O*h+F*A-(P*A+b*v+g*h),$=P*R+B*v+w*h-(D*v+x*h+F*R),ee=D*A+C*h+b*R-(U*R+B*A+L*h),te=n*z+i*G+a*V+l*q;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=z*te,r[1]=G*te,r[2]=V*te,r[3]=q*te,r[4]=H*te,r[5]=X*te,r[6]=W*te,r[7]=Y*te,r[8]=k*te,r[9]=K*te,r[10]=j*te,r[11]=Z*te,r[12]=Q*te,r[13]=J*te,r[14]=$*te,r[15]=ee*te,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],i=e[2],a=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],E=e[12],f=e[13],d=e[14],_=-r*E-n*f-i*d,h=-a*E-o*f-u*d,m=-s*E-c*f-l*d;return t[0]=r,t[1]=a,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=i,t[9]=u,t[10]=l,t[11]=0,t[12]=_,t[13]=h,t[14]=m,t[15]=1,t},c.IDENTITY=a(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=a(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r){this.normal=e.clone(t),this.distance=r};i.fromPointNormal=function(r,n,a){var o=-e.dot(n,r);return t(a)?(e.clone(n,a.normal),a.distance=o,a):new i(n,o)};var a=new e;return i.fromCartesian4=function(r,n){var o=e.fromCartesian4(r,a),u=r.w;return t(n)?(e.clone(o,n.normal),n.distance=u,n):new i(o,u)},i.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";var s=function(e,r,n,i){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,i){return n=t(n,0),r(i)||(i=new s),i.west=e[n++],i.south=e[n++],i.east=e[n++],i.north=e[n],i},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,i,a,o){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),i=u.toRadians(t(i,0)),a=u.toRadians(t(a,0)),r(o)?(o.west=e,o.south=n,o.east=i,o.north=a,o):new s(e,n,i,a)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];n=Math.min(n,l.longitude),i=Math.max(i,l.longitude),a=Math.min(a,l.latitude),o=Math.max(o,l.latitude)}return r(t)?(t.west=n,t.south=a,t.east=i,t.north=o,t):new s(n,a,i,o)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var i=t.east,a=t.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var i=e.east,a=e.west,o=t.east,c=t.west;a>i&&o>0?i+=u.TWO_PI:c>o&&i>0&&(o+=u.TWO_PI),a>i&&0>c?c+=u.TWO_PI:c>o&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,c)),E=u.negativePiToPi(Math.min(i,o));if((e.west<e.east||t.west<t.east)&&l>=E)return void 0;var f=Math.max(e.south,t.south),d=Math.min(e.north,t.north);return f>=d?void 0:r(n)?(n.west=l,n.south=f,n.east=E,n.north=d,n):new s(l,f,E,d)},s.contains=function(e,t){var r=t.longitude,n=t.latitude,i=e.west,a=e.east;return i>a&&(a+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>i||u.equalsEpsilon(r,i,u.EPSILON14))&&(a>r||u.equalsEpsilon(r,a,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,i,o){n=t(n,a.WGS84),i=t(i,0),r(o)||(o=[]);var l=0,E=e.north,f=e.south,d=e.east,_=e.west,h=c;h.height=i,h.longitude=_,h.latitude=E,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.longitude=d,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.latitude=f,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.longitude=_,o[l]=n.cartographicToCartesian(h,o[l]),l++,0>E?h.latitude=E:f>0?h.latitude=f:h.latitude=0;for(var m=1;8>m;++m)h.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,h)&&(o[l]=n.cartographicToCartesian(h,o[l]),l++);return 0===h.latitude&&(h.longitude=_,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.longitude=d,o[l]=n.cartographicToCartesian(h,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,l,E,f){"use strict";var d=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},_=new e,h=new e,m=new e,y=new e,p=new e,T=new e,R=new e,A=new e,v=new e,N=new e,S=new e,I=new e;d.fromPoints=function(t,r){if(n(r)||(r=new d),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var i=e.clone(t[0],R),a=e.clone(i,_),o=e.clone(i,h),u=e.clone(i,m),s=e.clone(i,y),c=e.clone(i,p),l=e.clone(i,T),E=t.length,f=1;E>f;f++){e.clone(t[f],i);var M=i.x,O=i.y,g=i.z;M<a.x&&e.clone(i,a),M>s.x&&e.clone(i,s),O<o.y&&e.clone(i,o),O>c.y&&e.clone(i,c),g<u.z&&e.clone(i,u),g>l.z&&e.clone(i,l)}var x=e.magnitudeSquared(e.subtract(s,a,A)),w=e.magnitudeSquared(e.subtract(c,o,A)),C=e.magnitudeSquared(e.subtract(l,u,A)),L=a,P=s,F=x;w>F&&(F=w,L=o,P=c),C>F&&(F=C,L=u,P=l);var U=v;U.x=.5*(L.x+P.x),U.y=.5*(L.y+P.y),U.z=.5*(L.z+P.z);var b=e.magnitudeSquared(e.subtract(P,U,A)),D=Math.sqrt(b),B=N;B.x=a.x,B.y=o.y,B.z=u.z;var z=S;z.x=s.x,z.y=c.y,z.z=l.z;var G=e.multiplyByScalar(e.add(B,z,A),.5,I),V=0;for(f=0;E>f;f++){e.clone(t[f],i);var q=e.magnitude(e.subtract(i,G,A));q>V&&(V=q);var H=e.magnitudeSquared(e.subtract(i,U,A));if(H>b){var X=Math.sqrt(H);D=.5*(D+X),b=D*D;var W=X-D;U.x=(D*U.x+W*i.x)/X,U.y=(D*U.y+W*i.y)/X,U.z=(D*U.z+W*i.z)/X}}return V>D?(e.clone(U,r.center),r.radius=D):(e.clone(G,r.center),r.radius=V),r};var M=new u,O=new e,g=new e,x=new t,w=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,i,a,o,u){if(n(u)||(u=new d),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=r(i,M),f.southwest(t,x),x.height=a,f.northeast(t,w),w.height=o;var s=i.project(x,O),c=i.project(w,g),l=c.x-s.x,E=c.y-s.y,_=c.z-s.z;u.radius=.5*Math.sqrt(l*l+E*E+_*_);var h=u.center;return h.x=s.x+.5*l,h.y=s.y+.5*E,h.z=s.z+.5*_,u};var C=[];d.fromRectangle3D=function(e,t,i,a){t=r(t,o.WGS84),i=r(i,0);var u;return n(e)&&(u=f.subsample(e,t,i,C)),d.fromPoints(u,a)},d.fromVertices=function(t,i,a,o){if(n(o)||(o=new d),!n(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;i=r(i,e.ZERO),a=r(a,3);var u=R;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;for(var s=e.clone(u,_),c=e.clone(u,h),l=e.clone(u,m),E=e.clone(u,y),f=e.clone(u,p),M=e.clone(u,T),O=t.length,g=0;O>g;g+=a){var x=t[g]+i.x,w=t[g+1]+i.y,C=t[g+2]+i.z;u.x=x,u.y=w,u.z=C,x<s.x&&e.clone(u,s),x>E.x&&e.clone(u,E),w<c.y&&e.clone(u,c),w>f.y&&e.clone(u,f),C<l.z&&e.clone(u,l),C>M.z&&e.clone(u,M)}var L=e.magnitudeSquared(e.subtract(E,s,A)),P=e.magnitudeSquared(e.subtract(f,c,A)),F=e.magnitudeSquared(e.subtract(M,l,A)),U=s,b=E,D=L;P>D&&(D=P,U=c,b=f),F>D&&(D=F,U=l,b=M);var B=v;B.x=.5*(U.x+b.x),B.y=.5*(U.y+b.y),B.z=.5*(U.z+b.z);var z=e.magnitudeSquared(e.subtract(b,B,A)),G=Math.sqrt(z),V=N;V.x=s.x,V.y=c.y,V.z=l.z;var q=S;q.x=E.x,q.y=f.y,q.z=M.z;var H=e.multiplyByScalar(e.add(V,q,A),.5,I),X=0;for(g=0;O>g;g+=a){u.x=t[g]+i.x,u.y=t[g+1]+i.y,u.z=t[g+2]+i.z;var W=e.magnitude(e.subtract(u,H,A));W>X&&(X=W);var Y=e.magnitudeSquared(e.subtract(u,B,A));if(Y>z){var k=Math.sqrt(Y);G=.5*(G+k),z=G*G;var K=k-G;B.x=(G*B.x+K*u.x)/k,B.y=(G*B.y+K*u.y)/k,B.z=(G*B.z+K*u.z)/k}}return X>G?(e.clone(B,o.center),o.radius=G):(e.clone(H,o.center),o.radius=X),o},d.fromCornerPoints=function(t,r,i){n(i)||(i=new d);var a=i.center;return e.add(t,r,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,r),i},d.fromEllipsoid=function(t,r){return n(r)||(r=new d),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var L=new e;d.fromBoundingSpheres=function(t,r){if(n(r)||(r=new d),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var i=t.length;if(1===i)return d.clone(t[0],r);if(2===i)return d.union(t[0],t[1],r);for(var a=[],o=0;i>o;o++)a.push(t[o].center);r=d.fromPoints(a,r);var u=r.center,s=r.radius;for(o=0;i>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,L)+c.radius)}return r.radius=s,r},d.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,n){n=r(n,0);var i=e.center;t[n++]=i.x,t[n++]=i.y,t[n++]=i.z,t[n]=e.radius},d.unpack=function(e,t,i){t=r(t,0),n(i)||(i=new d);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var P=new e,F=new e;d.union=function(t,r,i){n(i)||(i=new d);var a=t.center,o=t.radius,u=r.center,s=r.radius,c=e.subtract(u,a,P),l=e.magnitude(c);if(o>=l+s)return t.clone(i),i;if(s>=l+o)return r.clone(i),i;var E=.5*(o+l+s),f=e.multiplyByScalar(c,(-o+E)/l,F);return e.add(f,a,f),e.clone(f,i.center),i.radius=E,i};var U=new e;d.expand=function(t,r,n){n=d.clone(t,n);var i=e.magnitude(e.subtract(r,n.center,U));return i>n.radius&&(n.radius=i),n},d.intersectPlane=function(t,r){var n=t.center,i=t.radius,a=r.normal,o=e.dot(a,n)+r.distance;return-i>o?s.OUTSIDE:i>o?s.INTERSECTING:s.INSIDE},d.transform=function(e,t,r){return n(r)||(r=new d),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var b=new e;d.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,b);return e.magnitudeSquared(n)-t.radius*t.radius},d.transformWithoutScale=function(e,t,r){return n(r)||(r=new d),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var D=new e;d.computePlaneDistances=function(t,r,i,a){n(a)||(a=new c);var o=e.subtract(t.center,r,D),u=e.dot(i,o);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var B=new e,z=new e,G=new e,V=new e,q=new e,H=new t,X=new Array(8),W=0;8>W;++W)X[W]=new e;var Y=new u;return d.projectTo2D=function(t,n,i){n=r(n,Y);var a=n.ellipsoid,o=t.center,u=t.radius,s=a.geodeticSurfaceNormal(o,B),c=e.cross(e.UNIT_Z,s,z);e.normalize(c,c);var l=e.cross(s,c,G);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var E=e.negate(l,q),f=e.negate(c,V),_=X,h=_[0];e.add(s,l,h),e.add(h,c,h),h=_[1],e.add(s,l,h),e.add(h,f,h),h=_[2],e.add(s,E,h),e.add(h,f,h),h=_[3],e.add(s,E,h),e.add(h,c,h),e.negate(s,s),h=_[4],e.add(s,l,h),e.add(h,c,h),h=_[5],e.add(s,l,h),e.add(h,f,h),h=_[6],e.add(s,E,h),e.add(h,f,h),h=_[7],e.add(s,E,h),e.add(h,c,h);for(var m=_.length,y=0;m>y;++y){var p=_[y];e.add(o,p,p);var T=a.cartesianToCartographic(p,H);n.project(T,p)}i=d.fromPoints(_,i),o=i.center;var R=o.x,A=o.y,v=o.z;return o.x=v,o.y=R,o.z=A,i},d.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r){this.x=e(t,0),this.y=e(r,0)};a.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new a(e,r)},a.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.x=r[n++],i.y=r[n],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y)},a.minimumComponent=function(e){return Math.min(e.x,e.y)},a.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},a.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var r=a.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y},a.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},a.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},a.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},a.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},a.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new a;a.lerp=function(e,t,r,n){return a.multiplyByScalar(t,r,u),n=a.multiplyByScalar(e,1-r,n),a.add(u,n,n)};var s=new a,c=new a;a.angleBetween=function(e,t){return a.normalize(e,s),a.normalize(t,c),i.acosClamped(a.dot(s,c))};var l=new a;return a.mostOrthogonalAxis=function(e,t){var r=a.normalize(e,l);return a.abs(r,r),t=r.x<=r.y?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Y,t)},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,r,n,a){return e===r||t(e)&&t(r)&&i.equalsEpsilon(e.x,r.x,n,a)&&i.equalsEpsilon(e.y,r.y,n,a)},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,
DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function i(){if(!t(m)){m=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,y=n(e[1]))}return m}function a(){return i()&&y}function o(){if(!t(p)&&(p=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,T=n(e[1]))}return p}function u(){return o()&&T}function s(){if(!t(R)){R=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(R=!0,A=n(e[1]),A.isNightly=!!e[2])}return R}function c(){return s()&&A}function l(){if(!t(v)){v=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,N=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,N=n(e[1])))}return v}function E(){return l()&&N}function f(){if(!t(S)){S=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(S=!0,I=n(e[1]))}return S}function d(){return t(M)||(M=/Windows/i.test(navigator.appVersion)),M}function _(){return f()&&I}function h(){return t(O)||(O=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),O}var m,y,p,T,R,A,v,N,S,I,M,O,g={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:E,isFirefox:f,firefoxVersion:_,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:h};return g.supportsFullscreen=function(){return r.supportsFullscreen()},g.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},g.supportsWebWorkers=function(){return"undefined"!=typeof Worker},g}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,i,a){"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return r(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,r,i,a){switch(i=t(i,0),a=t(a,(r.byteLength-i)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(r,i,a);case o.UNSIGNED_BYTE:return new Uint8Array(r,i,a);case o.SHORT:return new Int16Array(r,i,a);case o.UNSIGNED_SHORT:return new Uint16Array(r,i,a);case o.FLOAT:return new Float32Array(r,i,a);case o.DOUBLE:return new Float64Array(r,i,a);default:throw new n("componentDatatype is not a valid value.")}},a(o)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,i,a,o,u){"use strict";var s=function(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)},c=new e;s.fromAxisAngle=function(t,n,i){var a=n/2,o=Math.sin(a);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,E=c.z*o,f=Math.cos(a);return r(i)?(i.x=u,i.y=l,i.z=E,i.w=f,i):new s(u,l,E,f)};var l=[1,2,0],E=new Array(3);s.fromRotationMatrix=function(e,t){var n,i,a,o,c,f=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],_=e[u.COLUMN2ROW2],h=f+d+_;if(h>0)n=Math.sqrt(h+1),c=.5*n,n=.5/n,i=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var m=l,y=0;d>f&&(y=1),_>f&&_>d&&(y=2);var p=m[y],T=m[p];n=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(p,p)]-e[u.getElementIndex(T,T)]+1);var R=E;R[y]=.5*n,n=.5/n,c=(e[u.getElementIndex(T,p)]-e[u.getElementIndex(p,T)])*n,R[p]=(e[u.getElementIndex(p,y)]+e[u.getElementIndex(y,p)])*n,R[T]=(e[u.getElementIndex(T,y)]+e[u.getElementIndex(y,T)])*n,i=-R[0],a=-R[1],o=-R[2]}return r(t)?(t.x=i,t.y=a,t.z=o,t.w=c,t):new s(i,a,o,c)};var f=new s;s.fromHeadingPitchRoll=function(t,r,n,i){var a=s.fromAxisAngle(e.UNIT_X,n,f),o=s.fromAxisAngle(e.UNIT_Y,-r,i);i=s.multiply(o,a,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,f);return s.multiply(u,i,i)};var d=new e,_=new e,h=new s,m=new s,y=new s;s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},s.unpack=function(e,n,i){return n=t(n,0),r(i)||(i=new s),i.x=e[n],i.y=e[n+1],i.z=e[n+2],i.w=e[n+3],i},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,y),s.conjugate(y,y);for(var i=0,a=r-t+1;a>i;i++){var o=3*i;s.unpack(e,4*(t+i),h),s.multiply(h,y,h),h.w<0&&s.negate(h,h),s.computeAxis(h,d);var u=s.computeAngle(h);n[o]=d.x*u,n[o+1]=d.y*u,n[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,n,i,a,o){r(o)||(o=new s),e.fromArray(t,0,_);var u=e.magnitude(_);return s.unpack(n,4*a,m),0===u?s.clone(s.IDENTITY,h):s.fromAxisAngle(_,u,h),s.multiply(h,m,o)},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,i=e.y*r,a=e.z*r,o=e.w*r;return t.x=n,t.y=i,t.z=a,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,r){var n=e.x,i=e.y,a=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,E=o*u+n*l+i*c-a*s,f=o*s-n*c+i*l+a*u,d=o*c+n*s-i*u+a*l,_=o*l-n*u-i*s-a*c;return r.x=E,r.y=f,r.z=d,r.w=_,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var p=new s;s.lerp=function(e,t,r,n){return p=s.multiplyByScalar(t,r,p),n=s.multiplyByScalar(e,1-r,n),s.add(p,n,n)};var T=new s,R=new s,A=new s;s.slerp=function(e,t,r,n){var i=s.dot(e,t),a=t;if(0>i&&(i=-i,a=T=s.negate(t,T)),1-i<o.EPSILON6)return s.lerp(e,a,r,n);var u=Math.acos(i);return R=s.multiplyByScalar(e,Math.sin((1-r)*u),R),A=s.multiplyByScalar(a,Math.sin(r*u),A),n=s.add(R,A,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),i=0;return 0!==n&&(i=n/Math.sin(n)),e.multiplyByScalar(t,i,r)},s.exp=function(t,r){var n=e.magnitude(t),i=0;return 0!==n&&(i=Math.sin(n)/n),r.x=t.x*i,r.y=t.y*i,r.z=t.z*i,r.w=Math.cos(n),r};var v=new e,N=new e,S=new s,I=new s;s.computeInnerQuadrangle=function(t,r,n,i){var a=s.conjugate(r,S);s.multiply(a,n,I);var o=s.log(I,v);s.multiply(a,t,I);var u=s.log(I,N);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,S),s.multiply(r,S,i)},s.squad=function(e,t,r,n,i,a){var o=s.slerp(e,t,i,S),u=s.slerp(r,n,i,I);return s.slerp(o,u,2*i*(1-i),a)};for(var M=new s,O=1.9011074535173003,g=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],w=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],L=0;7>L;++L){var P=L+1,F=2*P+1;g[L]=1/(P*F),x[L]=P/F}return g[7]=O/136,x[7]=8*O/17,s.fastSlerp=function(e,t,r,n){var i,a=s.dot(e,t);a>=0?i=1:(i=-1,a=-a);for(var o=a-1,u=1-r,c=r*r,l=u*u,E=7;E>=0;--E)w[E]=(g[E]*c-x[E])*o,C[E]=(g[E]*l-x[E])*o;var f=i*r*(1+w[0]*(1+w[1]*(1+w[2]*(1+w[3]*(1+w[4]*(1+w[5]*(1+w[6]*(1+w[7])))))))),d=u*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),_=s.multiplyByScalar(e,d,M);return s.multiplyByScalar(t,f,n),s.add(_,n,n)},s.fastSquad=function(e,t,r,n,i,a){var o=s.fastSlerp(e,t,i,S),u=s.fastSlerp(r,n,i,I);return s.fastSlerp(o,u,2*i*(1-i),a)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,r,n){"use strict";function i(t,i,a,l,E,f,d,_,h,m){var y=t+i;e.multiplyByScalar(l,Math.cos(y),o),e.multiplyByScalar(a,Math.sin(y),u),e.add(o,u,o);var p=Math.cos(t);p*=p;var T=Math.sin(t);T*=T;var R=f/Math.sqrt(d*p+E*T),A=R/_;return n.fromAxisAngle(o,A,s),r.fromQuaternion(s,c),r.multiplyByVector(c,h,m),e.normalize(m,m),e.multiplyByScalar(m,_,m),m}var a={},o=new e,u=new e,s=new n,c=new r,l=new e,E=new e,f=new e,d=new e;a.raisePositionsToHeight=function(t,r,n){for(var i=r.ellipsoid,a=r.height,o=r.extrudedHeight,u=n?t.length/3*2:t.length/3,s=new Float64Array(3*u),c=t.length,_=n?c:0,h=0;c>h;h+=3){var m=h+1,y=h+2,p=e.fromArray(t,h,l);i.scaleToGeodeticSurface(p,p);var T=e.clone(p,E),R=i.geodeticSurfaceNormal(p,d),A=e.multiplyByScalar(R,a,f);e.add(p,A,p),n&&(e.multiplyByScalar(R,o,A),e.add(T,A,T),s[h+_]=T.x,s[m+_]=T.y,s[y+_]=T.z),s[h]=p.x,s[m]=p.y,s[y]=p.z}return s};var _=new e,h=new e,m=new e;return a.computeEllipsePositions=function(r,n,a){var o=r.semiMinorAxis,u=r.semiMajorAxis,s=r.rotation,c=r.center,d=8*r.granularity,y=o*o,p=u*u,T=u*o,R=e.magnitude(c),A=e.normalize(c,_),v=e.cross(e.UNIT_Z,c,h);v=e.normalize(v,v);var N=e.cross(A,v,m),S=1+Math.ceil(t.PI_OVER_TWO/d),I=t.PI_OVER_TWO/(S-1),M=t.PI_OVER_TWO-S*I;0>M&&(S-=Math.ceil(Math.abs(M)/I));var O,g,x,w,C,L=2*S*(S+1),P=n?new Array(3*L):void 0,F=0,U=l,b=E,D=3*(2*S+2*(S-1)),B=D-1,z=0,G=a?new Array(D):void 0;for(M=t.PI_OVER_TWO,O=0;S>O;++O){if(U=i(M,s,N,v,y,T,p,R,A,U),b=i(Math.PI-M,s,N,v,y,T,p,R,A,b),n){for(P[F++]=U.x,P[F++]=U.y,P[F++]=U.z,x=2*O+2,g=1;x-1>g;++g)w=g/(x-1),C=e.lerp(U,b,w,f),P[F++]=C.x,P[F++]=C.y,P[F++]=C.z;P[F++]=b.x,P[F++]=b.y,P[F++]=b.z}a&&(G[B--]=U.z,G[B--]=U.y,G[B--]=U.x,0!==O&&(G[z++]=b.x,G[z++]=b.y,G[z++]=b.z)),M=t.PI_OVER_TWO-(O+1)*I}for(O=S;O>0;--O){if(M=t.PI_OVER_TWO-(O-1)*I,U=i(-M,s,N,v,y,T,p,R,A,U),b=i(M+Math.PI,s,N,v,y,T,p,R,A,b),n){for(P[F++]=U.x,P[F++]=U.y,P[F++]=U.z,x=2*(O-1)+2,g=1;x-1>g;++g)w=g/(x-1),C=e.lerp(U,b,w,f),P[F++]=C.x,P[F++]=C.y,P[F++]=C.z;P[F++]=b.x,P[F++]=b.y,P[F++]=b.z}a&&(G[B--]=U.z,G[B--]=U.y,G[B--]=U.x,1!==O&&(G[z++]=b.x,G[z++]=b.y,G[z++]=b.z))}var V={};return n&&(V.positions=P,V.numPts=S),a&&(V.outerPositions=G),V},a}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,i){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,i.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(e){var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,i){"use strict";var a={};a.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*i.signNotZero(r),t.y=(1-Math.abs(r))*i.signNotZero(n)}return t.x=i.toSNorm(t.x),t.y=i.toSNorm(t.y),t},a.octDecode=function(e,r,n){if(n.x=i.fromSNorm(e),n.y=i.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var a=n.x;n.x=(1-Math.abs(n.y))*i.signNotZero(a),n.y=(1-Math.abs(a))*i.signNotZero(n.y)}return t.normalize(n,n)},a.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),i=256*(r-n);return a.octDecode(n,i,t)},a.octPack=function(e,t,r,n){var i=a.octEncodeFloat(e),u=a.octEncodeFloat(t),s=a.octEncode(r,o);return n.x=65536*s.x+i,n.y=65536*s.y+u,n},a.octUnpack=function(e,t,r,n){var i=e.x/65536,o=Math.floor(i),u=65536*(i-o);i=e.y/65536;var s=Math.floor(i),c=65536*(i-s);a.octDecodeFloat(u,t),a.octDecodeFloat(c,r),a.octDecode(o,s,n)},a.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,r=1===e.y?4095:4096*e.y|0;return 4096*t+r},a.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},a}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=new t,a=new t,o=new t,u=function(n,u,s,c,l){r(l)||(l=new t);var E,f,d,_,h,m,y,p;r(u.z)?(E=t.subtract(s,u,i),f=t.subtract(c,u,a),d=t.subtract(n,u,o),_=t.dot(E,E),h=t.dot(E,f),m=t.dot(E,d),y=t.dot(f,f),p=t.dot(f,d)):(E=e.subtract(s,u,i),f=e.subtract(c,u,a),d=e.subtract(n,u,o),_=e.dot(E,E),h=e.dot(E,f),m=e.dot(E,d),y=e.dot(f,f),p=e.dot(f,d));var T=1/(_*y-h*h);return l.y=(y*m-h*p)*T,l.z=(_*p-h*m)*T,l.x=1-l.y-l.z,l};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var i={high:0,low:0};n.fromCartesian=function(e,r){t(r)||(r=new n);var a=r.high,o=r.low;return n.encode(e.x,i),a.x=i.high,o.x=i.low,n.encode(e.y,i),a.y=i.high,o.y=i.low,n.encode(e.z,i),a.z=i.high,o.z=i.low,r};var a=new n;return n.writeElements=function(e,t,r){n.fromCartesian(e,a);var i=a.high,o=a.low;t[r]=i.x,t[r+1]=i.y,t[r+2]=i.z,t[r+3]=o.x,t[r+4]=o.y,t[r+5]=o.z},n}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(e){return t(e)&&(e===a.UNSIGNED_BYTE||e===a.UNSIGNED_SHORT||e===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,r,n){return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,n):new Uint16Array(t,r,n)},n(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,i){var a;if(0===e)return 0===n?[]:[-i/n];if(0===n){if(0===i)return[0,0];var o=Math.abs(i),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(a=-i/e,0>a)return[];var s=Math.sqrt(a);return[-s,s]}if(0===i)return a=-n/e,0>a?[a,0]:[0,a];var c=n*n,l=4*e*i,E=r(c,-l,t.EPSILON14);if(0>E)return[];var f=-.5*r(n,t.sign(n)*Math.sqrt(E),t.EPSILON14);return n>0?[f/e,i/f]:[i/f,f/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,l=o*s,E=u*c,f=u*u,d=s*s,_=o*s-f,h=o*c-u*s,m=u*c-d,y=4*_*m-h*h;if(0>y){var p,T,R;f*E>=l*d?(p=o,T=_,R=-2*u*_+o*h):(p=c,T=m,R=-c*h+2*s*m);var A=0>R?-1:1,v=-A*Math.abs(p)*Math.sqrt(-y);a=-R+v;var N=a/2,S=0>N?-Math.pow(-N,1/3):Math.pow(N,1/3),I=a===v?-S:-T/S;return i=0>=T?S+I:-R/(S*S+I*I+T),f*E>=l*d?[(i-u)/o]:[-c/(i+s)]}var M=_,O=-2*u*_+o*h,g=m,x=-c*h+2*s*m,w=Math.sqrt(y),C=Math.sqrt(3)/2,L=Math.abs(Math.atan2(o*w,-O)/3);i=2*Math.sqrt(-M);var P=Math.cos(L);a=i*P;var F=i*(-P/2-C*Math.sin(L)),U=a+F>2*u?a-u:F-u,b=o,D=U/b;L=Math.abs(Math.atan2(c*w,-x)/3),i=2*Math.sqrt(-g),P=Math.cos(L),a=i*P,F=i*(-P/2-C*Math.sin(L));var B=-c,z=2*s>a+F?a+s:F+s,G=B/z,V=b*z,q=-U*z-b*B,H=U*B,X=(s*q-u*H)/(-u*q+s*V);return X>=D?G>=D?G>=X?[D,X,G]:[D,G,X]:[G,D,X]:G>=D?[X,D,G]:G>=X?[X,G,D]:[G,X,D]}var n={};return n.computeDiscriminant=function(e,t,r,n){var i=e*e,a=t*t,o=r*r,u=n*n,s=18*e*t*r*n+a*o-27*i*u-4*(e*o*r+a*t*n);return s},n.computeRealRoots=function(e,n,i,a){var o,u;if(0===e)return t.computeRealRoots(n,i,a);if(0===n){if(0===i){if(0===a)return[0,0,0];u=-a/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===a?(o=t.computeRealRoots(e,0,i),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,i,a)}return 0===i?0===a?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,a):0===a?(o=t.computeRealRoots(e,n,i),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,i,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,E=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(E.length>0){var f=-t/4,d=E[E.length-1];if(Math.abs(d)<r.EPSILON14){var _=n.computeRealRoots(1,s,l);if(2===_.length){var h,m=_[0],y=_[1];if(m>=0&&y>=0){var p=Math.sqrt(m),T=Math.sqrt(y);return[f-T,f-p,f+p,f+T]}if(m>=0&&0>y)return h=Math.sqrt(m),[f-h,f+h];if(0>m&&y>=0)return h=Math.sqrt(y),[f-h,f+h]}return[]}if(d>0){var R=Math.sqrt(d),A=(s+d-c/R)/2,v=(s+d+c/R)/2,N=n.computeRealRoots(1,R,A),S=n.computeRealRoots(1,-R,v);return 0!==N.length?(N[0]+=f,N[1]+=f,0!==S.length?(S[0]+=f,S[1]+=f,N[1]<=S[0]?[N[0],N[1],S[0],S[1]]:S[1]<=N[0]?[S[0],S[1],N[0],N[1]]:N[0]>=S[0]&&N[1]<=S[1]?[S[0],N[0],N[1],S[1]]:S[0]>=N[0]&&S[1]<=N[1]?[N[0],S[0],S[1],N[1]]:N[0]>S[0]&&N[0]<S[1]?[S[0],N[0],S[1],N[1]]:[N[0],S[0],N[1],S[1]]):N):0!==S.length?(S[0]+=f,S[1]+=f,S):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,l=-2*i,E=a*t+s-4*o,f=c*o-a*i*t+u,d=e.computeRealRoots(1,l,E,f);if(d.length>0){var _,h,m=d[0],y=i-m,p=y*y,T=t/2,R=y/2,A=p-4*o,v=p+4*Math.abs(o),N=c-4*m,S=c+4*Math.abs(m);if(0>m||N*v>A*S){var I=Math.sqrt(N);_=I/2,h=0===I?0:(t*R-a)/I}else{var M=Math.sqrt(A);_=0===M?0:(t*R-a)/M,h=M/2}var O,g;0===T&&0===_?(O=0,g=0):r.sign(T)===r.sign(_)?(O=T+_,g=m/O):(g=T-_,O=m/g);var x,w;0===R&&0===h?(x=0,w=0):r.sign(R)===r.sign(h)?(x=R+h,w=o/x):(w=R-h,x=o/w);var C=n.computeRealRoots(1,O,x),L=n.computeRealRoots(1,g,w);if(0!==C.length)return 0!==L.length?C[1]<=L[0]?[C[0],C[1],L[0],L[1]]:L[1]<=C[0]?[L[0],L[1],C[0],C[1]]:C[0]>=L[0]&&C[1]<=L[1]?[L[0],C[0],C[1],L[1]]:L[0]>=C[0]&&L[1]<=C[1]?[C[0],L[0],L[1],C[1]]:C[0]>L[0]&&C[0]<L[1]?[L[0],C[0],L[1],C[1]]:[C[0],L[0],C[1],L[1]]:C;if(0!==L.length)return L}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,i){var a=e*e,o=a*e,u=t*t,s=u*t,c=r*r,l=c*r,E=n*n,f=E*n,d=i*i,_=d*i,h=u*c*E-4*s*f-4*e*l*E+18*e*t*r*f-27*a*E*E+256*o*_+i*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*E+144*a*r*E)+d*(144*e*u*r-27*u*u-128*a*c-192*a*t*n);return h},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,E=u/t,f=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>E?d+1:d,d+=0>f?d+1:d){case 0:return i(c,l,E,f);case 1:return a(c,l,E,f);case 2:return a(c,l,E,f);case 3:return i(c,l,E,f);case 4:return i(c,l,E,f);case 5:return a(c,l,E,f);case 6:return i(c,l,E,f);case 7:return i(c,l,E,f);case 8:return a(c,l,E,f);case 9:return i(c,l,E,f);case 10:return i(c,l,E,f);case 11:return a(c,l,E,f);case 12:return i(c,l,E,f);case 13:return i(c,l,E,f);case 14:return i(c,l,E,f);case 15:return i(c,l,E,f);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return i.getPoint=function(t,n,i){return r(i)||(i=new e),i=e.multiplyByScalar(t.direction,n,i),e.add(t.origin,i,i)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(t,n,i,o,u){u=r(u,!1);var s,c,l,E,f,d=t.origin,_=t.direction,h=e.subtract(i,n,m),A=e.subtract(o,n,y),v=e.cross(_,A,p),N=e.dot(h,v);if(u){if(N<a.EPSILON6)return void 0;if(s=e.subtract(d,n,T),l=e.dot(s,v),0>l||l>N)return void 0;if(c=e.cross(s,h,R),E=e.dot(_,c),0>E||l+E>N)return void 0;f=e.dot(A,c)/N}else{if(Math.abs(N)<a.EPSILON6)return void 0;var S=1/N;if(s=e.subtract(d,n,T),l=e.dot(s,v)*S,0>l||l>1)return void 0;if(c=e.cross(s,h,R),E=e.dot(_,c)*S,0>E||l+E>1)return void 0;f=e.dot(A,c)*S}return f}function E(e,t,r,n){var i=t*t-4*e*r;if(0>i)return void 0;if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function f(t,r,i){n(i)||(i={});
var a=t.origin,o=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(a,u,p),l=e.dot(o,o),f=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,_=E(l,f,d,v);return n(_)?(i.start=_.root0,i.stop=_.root1,i):void 0}function d(e,t,r){var n=e+t;return a.sign(e)!==a.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function _(t,r,n,i,c){var l,E=i*i,f=c*c,_=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*f,h=c*(i*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],a.EPSILON15)+r.y),m=t[o.COLUMN0ROW0]*E+t[o.COLUMN2ROW2]*f+i*r.x+n,y=f*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],a.EPSILON15),p=c*(i*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+r.z),T=[];if(0===p&&0===y){if(l=u.computeRealRoots(_,h,m),0===l.length)return T;var R=l[0],A=Math.sqrt(Math.max(1-R*R,0));if(T.push(new e(i,c*R,c*-A)),T.push(new e(i,c*R,c*A)),2===l.length){var v=l[1],N=Math.sqrt(Math.max(1-v*v,0));T.push(new e(i,c*v,c*-N)),T.push(new e(i,c*v,c*N))}return T}var S=p*p,I=y*y,M=_*_,O=p*y,g=M+I,x=2*(h*_+O),w=2*m*_+h*h-I+S,C=2*(m*h-O),L=m*m-S;if(0===g&&0===x&&0===w&&0===C)return T;l=s.computeRealRoots(g,x,w,C,L);var P=l.length;if(0===P)return T;for(var F=0;P>F;++F){var U,b=l[F],D=b*b,B=Math.max(1-D,0),z=Math.sqrt(B);U=a.sign(_)===a.sign(m)?d(_*D+m,h*b,a.EPSILON12):a.sign(m)===a.sign(h*b)?d(_*D,h*b+m,a.EPSILON12):d(_*D+h*b,m,a.EPSILON12);var G=d(y*b,p,a.EPSILON15),V=U*G;0>V?T.push(new e(i,c*b,c*z)):V>0?T.push(new e(i,c*b,c*-z)):0!==z?(T.push(new e(i,c*b,c*-z)),T.push(new e(i,c*b,c*z)),++F):T.push(new e(i,c*b,c*z))}return T}var h={};h.rayPlane=function(t,r,i){n(i)||(i=new e);var o=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(Math.abs(c)<a.EPSILON15)return void 0;var l=(-r.distance-e.dot(s,o))/c;return 0>l?void 0:(i=e.multiplyByScalar(u,l,i),e.add(o,i,i))};var m=new e,y=new e,p=new e,T=new e,R=new e;h.rayTriangle=function(t,r,i,a,o,u){var s=l(t,r,i,a,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var A=new c;h.lineSegmentTriangle=function(t,r,i,a,o,u,s){var c=A;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var E=l(c,i,a,o,u);return!n(E)||0>E||E>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,E,s),e.add(c.origin,s,s))};var v={root0:0,root1:0};h.raySphere=function(e,t,r){return r=f(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var N=new c;h.lineSegmentSphere=function(t,r,i,a){var o=N,u=(e.clone(t,o.origin),e.subtract(r,t,o.direction)),s=e.magnitude(u);return e.normalize(u,u),a=f(o,i,a),!n(a)||a.stop<0||a.start>s?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,s),a)};var S=new e,I=new e;h.rayEllipsoid=function(t,r){var n,i,a,o,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,S),l=e.multiplyComponents(s,t.direction,I),E=e.magnitudeSquared(c),f=e.dot(c,l);if(E>1){if(f>=0)return void 0;var d=f*f;if(n=E-1,i=e.magnitudeSquared(l),a=i*n,a>d)return void 0;if(d>a){o=f*f-a,u=-f+Math.sqrt(o);var _=u/i,h=n/u;return h>_?{start:_,stop:h}:{start:h,stop:_}}var m=Math.sqrt(n/i);return{start:m,stop:m}}return 1>E?(n=E-1,i=e.magnitudeSquared(l),a=i*n,o=f*f-a,u=-f+Math.sqrt(o),{start:0,stop:u/i}):0>f?(i=e.magnitudeSquared(l),{start:0,stop:-f/i}):void 0};var M=new e,O=new e,g=new e,x=new e,w=new e,C=new o,L=new o,P=new o,F=new o,U=new o,b=new o,D=new o,B=new e,z=new e,G=new t;h.grazingAltitudeLocation=function(t,r){var i=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(i,M);if(e.dot(u,s)>=0)return i;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,M),E=e.normalize(l,l),f=e.mostOrthogonalAxis(l,x),d=e.normalize(e.cross(f,E,O),O),h=e.normalize(e.cross(E,d,g),g),m=C;m[0]=E.x,m[1]=E.y,m[2]=E.z,m[3]=d.x,m[4]=d.y,m[5]=d.z,m[6]=h.x,m[7]=h.y,m[8]=h.z;var y=o.transpose(m,L),p=o.fromScale(r.radii,P),T=o.fromScale(r.oneOverRadii,F),R=U;R[0]=0,R[1]=-u.z,R[2]=u.y,R[3]=u.z,R[4]=0,R[5]=-u.x,R[6]=-u.y,R[7]=u.x,R[8]=0;var A,v,N=o.multiply(o.multiply(y,T,b),R,b),S=o.multiply(o.multiply(N,p,D),m,D),I=o.multiplyByVector(N,i,w),V=_(S,e.negate(I,M),0,0,1),q=V.length;if(q>0){for(var H=e.clone(e.ZERO,z),X=Number.NEGATIVE_INFINITY,W=0;q>W;++W){A=o.multiplyByVector(p,o.multiplyByVector(m,V[W],B),B);var Y=e.normalize(e.subtract(A,i,x),x),k=e.dot(Y,u);k>X&&(X=k,H=e.clone(A,H))}var K=r.cartesianToCartographic(H,G);return X=a.clamp(X,0,1),v=e.magnitude(e.subtract(H,i,x))*Math.sqrt(1-X*X),v=c?-v:v,K.height=v,r.cartographicToCartesian(K,new e)}return void 0};var V=new e;return h.lineSegmentPlane=function(t,r,i,o){n(o)||(o=new e);var u=e.subtract(r,t,V),s=i.normal,c=e.dot(s,u);if(Math.abs(c)<a.EPSILON6)return void 0;var l=e.dot(s,t),E=-(i.distance+l)/c;return 0>E||E>1?void 0:(e.multiplyByScalar(u,E,o),e.add(t,o,o),o)},h.trianglePlaneIntersection=function(t,r,n,i){var a=i.normal,o=i.distance,u=e.dot(a,t)+o<0,s=e.dot(a,r)+o<0,c=e.dot(a,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var E,f;if((1===l||2===l)&&(E=new e,f=new e),1===l){if(u)return h.lineSegmentPlane(t,r,i,E),h.lineSegmentPlane(t,n,i,f),{positions:[t,r,n,E,f],indices:[0,3,4,1,2,4,1,4,3]};if(s)return h.lineSegmentPlane(r,n,i,E),h.lineSegmentPlane(r,t,i,f),{positions:[t,r,n,E,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return h.lineSegmentPlane(n,t,i,E),h.lineSegmentPlane(n,r,i,f),{positions:[t,r,n,E,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return h.lineSegmentPlane(r,t,i,E),h.lineSegmentPlane(n,t,i,f),{positions:[t,r,n,E,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return h.lineSegmentPlane(n,r,i,E),h.lineSegmentPlane(t,r,i,f),{positions:[t,r,n,E,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return h.lineSegmentPlane(t,n,i,E),h.lineSegmentPlane(r,n,i,f),{positions:[t,r,n,E,f],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},h}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,i=r.maximumIndex,a=e(r.cacheSize,24),o=n.length;if(!t(i)){i=0;for(var u=0,s=n[u];o>u;)s>i&&(i=s),++u,s=n[u]}for(var c=[],l=0;i+1>l;l++)c[l]=0;for(var E=a+1,f=0;o>f;++f)E-c[n[f]]>a&&(c[n[f]]=E,++E);return(E-a+1)/(o/3)},n.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function i(e,t,r,i,a,o,u){for(var s,c=-1,l=-1,E=0;E<r.length;){var f=r[E];i[f].numLiveTriangles&&(s=0,a-i[f].timeStamp+2*i[f].numLiveTriangles<=t&&(s=a-i[f].timeStamp),(s>l||-1===l)&&(l=s,c=f)),++E}return-1===c?n(i,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var a,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,E=0,f=o[E],d=c;if(t(u))l=u+1;else{for(;d>E;)f>l&&(l=f),++E,f=o[E];if(-1===l)return 0;++l}for(var _=[],h=0;l>h;h++)_[h]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};E=0;for(var m=0;d>E;)_[o[E]].vertexTriangles.push(m),++_[o[E]].numLiveTriangles,_[o[E+1]].vertexTriangles.push(m),++_[o[E+1]].numLiveTriangles,_[o[E+2]].vertexTriangles.push(m),++_[o[E+2]].numLiveTriangles,++m,E+=3;var y=0,p=s+1;a=1;var T,R,A=[],v=[],N=0,S=[],I=c/3,M=[];for(h=0;I>h;h++)M[h]=!1;for(var O,g;-1!==y;){A=[],R=_[y],g=R.vertexTriangles.length;for(var x=0;g>x;++x)if(m=R.vertexTriangles[x],!M[m]){M[m]=!0,E=m+m+m;for(var w=0;3>w;++w)O=o[E],A.push(O),v.push(O),S[N]=O,++N,T=_[O],--T.numLiveTriangles,p-T.timeStamp>s&&(T.timeStamp=p,++p),++E}y=i(o,s,A,_,p,v,l)}return S},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,i,a,o,u,s,c,l,E,f,d,_,h,m,y,p,T,R,A,v,N,S,I){"use strict";function M(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function O(e){for(var t=e.length,r=t/3*6,n=y.createTypedArray(t,r),i=0,a=0;t>a;a+=3,i+=6)M(n,i,e[a],e[a+1],e[a+2]);return n}function g(e){var t=e.length;if(t>=3){var r=6*(t-2),n=y.createTypedArray(t,r);M(n,0,e[0],e[1],e[2]);for(var i=6,a=3;t>a;++a,i+=6)M(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function x(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=y.createTypedArray(t,r),i=e[0],a=0,o=1;t>o;++o,a+=6)M(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function w(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new _({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function C(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[r*i.componentsPerAttribute+a])}function L(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;n>a;a+=3)i.unpack(r,a,ae),v.multiplyByPoint(e,ae,ae),i.pack(ae,r,a)}function P(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;n>a;a+=3)i.unpack(r,a,ae),A.multiplyByVector(e,ae,ae),ae=i.normalize(ae,ae),i.pack(ae,r,a)}function F(e,t){var r,n=e.length,i={},a=e[0][t].attributes;for(r in a)if(a.hasOwnProperty(r)&&c(a[r])&&c(a[r].values)){for(var o=a[r],s=o.values.length,l=!0,E=1;n>E;++E){var f=e[E][t].attributes[r];if(!c(f)||o.componentDatatype!==f.componentDatatype||o.componentsPerAttribute!==f.componentsPerAttribute||o.normalize!==f.normalize){l=!1;break}s+=f.values.length}l&&(i[r]=new _({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function U(e,t){var n,a,o,u,s,l,E,f=e.length,_=(e[0].modelMatrix,c(e[0][t].indices)),h=e[0][t].primitiveType,m=F(e,t);for(n in m)if(m.hasOwnProperty(n))for(s=m[n].values,u=0,a=0;f>a;++a)for(l=e[a][t].attributes[n].values,E=l.length,o=0;E>o;++o)s[u++]=l[o];var p;if(_){var T=0;for(a=0;f>a;++a)T+=e[a][t].indices.length;var R=d.computeNumberOfVertices(new d({attributes:m,primitiveType:S.POINTS})),A=y.createTypedArray(R,T),v=0,N=0;for(a=0;f>a;++a){var I=e[a][t].indices,M=I.length;for(u=0;M>u;++u)A[v++]=N+I[u];N+=d.computeNumberOfVertices(e[a][t])}p=A}var O,g=new i,x=0;for(a=0;f>a;++a){if(O=e[a][t].boundingSphere,!c(O)){g=void 0;break}i.add(O.center,g,g)}if(c(g))for(i.divideByScalar(g,f,g),a=0;f>a;++a){O=e[a][t].boundingSphere;var w=i.magnitude(i.subtract(O.center,g,se))+O.radius;w>x&&(x=w)}return new d({attributes:m,indices:p,primitiveType:h,boundingSphere:c(g)?new r(g,x):void 0})}function b(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function D(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;t>i;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=S.TRIANGLES,e}function B(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;t-1>i;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,t>i+2&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=S.TRIANGLES,e}function z(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function G(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;t>i;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=S.LINES,e}function V(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;t>i;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=S.LINES,e}function q(e){switch(e.primitiveType){case S.TRIANGLE_FAN:return D(e);case S.TRIANGLE_STRIP:return B(e);case S.TRIANGLES:return b(e);case S.LINE_STRIP:return G(e);case S.LINE_LOOP:return V(e);case S.LINES:return z(e)}return e}function H(e,t){Math.abs(e.y)<R.EPSILON6&&(t?e.y=-R.EPSILON6:e.y=R.EPSILON6)}function X(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return H(e,e.y<0),H(t,t.y<0),void H(r,r.y<0);var n,i=Math.abs(e.y),a=Math.abs(t.y),o=Math.abs(r.y);n=i>a?i>o?R.sign(e.y):R.sign(r.y):a>o?R.sign(t.y):R.sign(r.y);var u=0>n;H(e,u),H(t,u),H(r,u)}function W(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,Re),e.y/(e.y-t.y),Re),r),i.clone(r,n),H(r,!0),H(n,!1)}function Y(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;X(e,t,r);var n=e.y<0,i=t.y<0,a=r.y<0,o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=Ie.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(W(e,t,Ae,Ne),W(e,r,ve,Se),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(W(t,r,Ae,Ne),W(t,e,ve,Se),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(W(r,e,Ae,Ne),W(r,t,ve,Se),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(W(r,e,Ae,Ne),W(r,t,ve,Se),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(t,r,Ae,Ne),W(t,e,ve,Se),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,t,Ae,Ne),W(e,r,ve,Se),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ie.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Ae,s[4]=ve,s[5]=Ne,s[6]=Se,s.length=7),Ie}function k(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=d.computeNumberOfVertices(e);return e.indices=y.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function K(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new _({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new d({attributes:r,indices:[],primitiveType:e.primitiveType})}function j(e,t,r){var n=c(e.geometry.boundingSphere);t=k(t,n),r=k(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function Z(e,r,a,o,u,s,l,E,f,d,_){if(c(s)||c(l)||c(E)||c(f)){var h=i.fromArray(u,3*e,Me),m=i.fromArray(u,3*r,Oe),y=i.fromArray(u,3*a,ge),p=t(o,h,m,y,xe);if(c(s)){var T=i.fromArray(s,3*e,Me),R=i.fromArray(s,3*r,Oe),A=i.fromArray(s,3*a,ge);i.multiplyByScalar(T,p.x,T),i.multiplyByScalar(R,p.y,R),i.multiplyByScalar(A,p.z,A);var v=i.add(T,R,T);i.add(v,A,v),i.normalize(v,v),i.pack(v,d.normal.values,3*_)}if(c(l)){var N=i.fromArray(l,3*e,Me),S=i.fromArray(l,3*r,Oe),I=i.fromArray(l,3*a,ge);i.multiplyByScalar(N,p.x,N),i.multiplyByScalar(S,p.y,S),i.multiplyByScalar(I,p.z,I);var M=i.add(N,S,N);i.add(M,I,M),i.normalize(M,M),i.pack(M,d.binormal.values,3*_)}if(c(E)){var O=i.fromArray(E,3*e,Me),g=i.fromArray(E,3*r,Oe),x=i.fromArray(E,3*a,ge);i.multiplyByScalar(O,p.x,O),i.multiplyByScalar(g,p.y,g),i.multiplyByScalar(x,p.z,x);var w=i.add(O,g,O);i.add(w,x,w),i.normalize(w,w),i.pack(w,d.tangent.values,3*_)}if(c(f)){var C=n.fromArray(f,2*e,we),L=n.fromArray(f,2*r,Ce),P=n.fromArray(f,2*a,Le);n.multiplyByScalar(C,p.x,C),n.multiplyByScalar(L,p.y,L),n.multiplyByScalar(P,p.z,P);var F=n.add(C,L,C);n.add(F,P,F),n.pack(F,d.st.values,2*_)}}}function Q(e,t,r,n,i,a){var o=e.position.values.length/3;if(-1!==i){var u=n[i],s=r[u];return-1===s?(r[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}function J(e){var t,r,n,a,o,u=e.geometry,s=u.attributes,l=s.position.values,E=c(s.normal)?s.normal.values:void 0,f=c(s.binormal)?s.binormal.values:void 0,d=c(s.tangent)?s.tangent.values:void 0,_=c(s.st)?s.st.values:void 0,h=u.indices,m=K(u),y=K(u),p=[];p.length=l.length/3;var T=[];for(T.length=l.length/3,o=0;o<p.length;++o)p[o]=-1,T[o]=-1;var R=h.length;for(o=0;R>o;o+=3){var A=h[o],v=h[o+1],N=h[o+2],S=i.fromArray(l,3*A),I=i.fromArray(l,3*v),M=i.fromArray(l,3*N),O=Y(S,I,M);if(c(O)&&O.positions.length>3)for(var g=O.positions,x=O.indices,w=x.length,C=0;w>C;++C){var L=x[C],P=g[L];P.y<0?(t=y.attributes,r=y.indices,n=p):(t=m.attributes,r=m.indices,n=T),a=Q(t,r,n,h,3>L?o+L:-1,P),Z(A,v,N,P,l,E,f,d,_,t,a)}else c(O)&&(S=O.positions[0],I=O.positions[1],M=O.positions[2]),S.y<0?(t=y.attributes,r=y.indices,n=p):(t=m.attributes,r=m.indices,n=T),a=Q(t,r,n,h,o,S),Z(A,v,N,S,l,E,f,d,_,t,a),a=Q(t,r,n,h,o+1,I),Z(A,v,N,I,l,E,f,d,_,t,a),a=Q(t,r,n,h,o+2,M),Z(A,v,N,M,l,E,f,d,_,t,a)}j(e,y,m)}function $(e){var t,r=e.geometry,n=r.attributes,a=n.position.values,o=r.indices,u=K(r),s=K(r),l=o.length,E=[];E.length=a.length/3;var f=[];for(f.length=a.length/3,t=0;t<E.length;++t)E[t]=-1,f[t]=-1;for(t=0;l>t;t+=2){var d=o[t],_=o[t+1],h=i.fromArray(a,3*d,Me),m=i.fromArray(a,3*_,Oe);Math.abs(h.y)<R.EPSILON6&&(h.y<0?h.y=-R.EPSILON6:h.y=R.EPSILON6),Math.abs(m.y)<R.EPSILON6&&(m.y<0?m.y=-R.EPSILON6:m.y=R.EPSILON6);var y=u.attributes,p=u.indices,A=f,v=s.attributes,N=s.indices,S=E,I=T.lineSegmentPlane(h,m,Pe,ge);if(c(I)){var M=i.multiplyByScalar(i.UNIT_Y,5*R.EPSILON9,Fe);h.y<0&&(i.negate(M,M),y=s.attributes,p=s.indices,A=E,v=u.attributes,N=u.indices,S=f);var O=i.add(I,M,Ue);Q(y,p,A,o,t,h),Q(y,p,A,o,-1,O),i.negate(M,M),i.add(I,M,O),Q(v,N,S,o,-1,O),Q(v,N,S,o,t+1,m)}else{var g,x,w;h.y<0?(g=s.attributes,x=s.indices,w=E):(g=u.attributes,x=u.indices,w=f),Q(g,x,w,o,t,h),Q(g,x,w,o,t+1,m)}}j(e,s,u)}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,E=s.prevPosition.values,f=s.nextPosition.values,d=s.expandAndWidth.values,_=(u.indices,c(s.st)?s.st.values:void 0),h=c(s.color)?s.color.values:void 0,m=K(u),y=K(u),p=l.length/3;for(t=0;p>t;t+=4){var A=t,v=t+1,N=t+2,S=t+3,I=i.fromArray(l,3*A,Be),M=i.fromArray(l,3*v,ze),O=i.fromArray(l,3*N,Ge),g=i.fromArray(l,3*S,Ve);Math.abs(I.y)<R.EPSILON6&&(I.y=R.EPSILON6*(O.y<0?-1:1),M.y=I.y),Math.abs(O.y)<R.EPSILON6&&(O.y=R.EPSILON6*(I.y<0?-1:1),g.y=O.y);var x=m.attributes,w=m.indices,C=y.attributes,L=y.indices,P=T.lineSegmentPlane(I,O,Pe,qe);if(c(P)){var F=i.multiplyByScalar(i.UNIT_Y,5*R.EPSILON9,He);I.y<0&&(i.negate(F,F),x=y.attributes,w=y.indices,C=m.attributes,L=m.indices);var U=i.add(P,F,Xe);for(x.position.values.push(I.x,I.y,I.z,M.x,M.y,M.z),x.position.values.push(U.x,U.y,U.z),x.position.values.push(U.x,U.y,U.z),i.negate(F,F),i.add(P,F,U),C.position.values.push(U.x,U.y,U.z),C.position.values.push(U.x,U.y,U.z),C.position.values.push(O.x,O.y,O.z,g.x,g.y,g.z),r=3*A;3*A+6>r;++r)x.prevPosition.values.push(E[r]);for(x.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),C.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),r=3*N;3*N+6>r;++r)C.prevPosition.values.push(E[r]);for(r=3*A;3*A+6>r;++r)x.nextPosition.values.push(f[r]);for(x.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),C.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),r=3*N;3*N+6>r;++r)C.nextPosition.values.push(f[r]);var b=n.fromArray(d,2*A,be),D=Math.abs(b.y);x.expandAndWidth.values.push(-1,D,1,D),x.expandAndWidth.values.push(-1,-D,1,-D),C.expandAndWidth.values.push(-1,D,1,D),C.expandAndWidth.values.push(-1,-D,1,-D);var B=i.magnitudeSquared(i.subtract(P,I,Ve));if(B/=i.magnitudeSquared(i.subtract(O,I,Ve)),c(h)){var z=a.fromArray(h,4*A,We),G=a.fromArray(h,4*N,We),V=R.lerp(z.x,G.x,B),q=R.lerp(z.y,G.y,B),H=R.lerp(z.z,G.z,B),X=R.lerp(z.w,G.w,B);for(r=4*A;4*A+8>r;++r)x.color.values.push(h[r]);for(x.color.values.push(V,q,H,X),x.color.values.push(V,q,H,X),C.color.values.push(V,q,H,X),C.color.values.push(V,q,H,X),r=4*N;4*N+8>r;++r)C.color.values.push(h[r])}if(c(_)){var W=n.fromArray(_,2*A,be),Y=n.fromArray(_,2*(t+3),De),k=R.lerp(W.x,Y.x,B);for(r=2*A;2*A+4>r;++r)x.st.values.push(_[r]);for(x.st.values.push(k,W.y),x.st.values.push(k,Y.y),C.st.values.push(k,W.y),C.st.values.push(k,Y.y),r=2*N;2*N+4>r;++r)C.st.values.push(_[r])}o=x.position.values.length/3-4,w.push(o,o+2,o+1),w.push(o+1,o+2,o+3),o=C.position.values.length/3-4,L.push(o,o+2,o+1),L.push(o+1,o+2,o+3)}else{var Z,Q;for(I.y<0?(Z=y.attributes,Q=y.indices):(Z=m.attributes,Q=m.indices),Z.position.values.push(I.x,I.y,I.z),Z.position.values.push(M.x,M.y,M.z),Z.position.values.push(O.x,O.y,O.z),Z.position.values.push(g.x,g.y,g.z),r=3*t;3*t+12>r;++r)Z.prevPosition.values.push(E[r]),Z.nextPosition.values.push(f[r]);for(r=2*t;2*t+8>r;++r)Z.expandAndWidth.values.push(d[r]),c(_)&&Z.st.values.push(_[r]);if(c(h))for(r=4*t;4*t+16>r;++r)Z.color.values.push(h[r]);o=Z.position.values.length/3-4,Q.push(o,o+2,o+1),Q.push(o+1,o+2,o+3)}}j(e,y,m)}var te={};te.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case S.TRIANGLES:e.indices=O(t);break;case S.TRIANGLE_STRIP:e.indices=g(t);break;case S.TRIANGLE_FAN:e.indices=x(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=S.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,o=i.length,l=new Float64Array(2*o),E=0,f=0;o>f;f+=3)l[E++]=i[f],l[E++]=i[f+1],l[E++]=i[f+2],l[E++]=i[f]+a[f]*n,l[E++]=i[f+1]+a[f+1]*n,l[E++]=i[f+2]+a[f+2]*n;var h,m=e.boundingSphere;return c(m)&&(h=new r(m.center,m.radius+n)),new d({attributes:{position:new _({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:S.LINES,boundingSphere:h})},te.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,i={},a=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},te.reorderForPreVertexCache=function(e){var t=d.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;t>i;i++)n[i]=-1;for(var a,o=r,s=o.length,l=y.createTypedArray(t,s),E=0,f=0,_=0;s>E;)a=n[o[E]],-1!==a?l[f]=a:(a=o[E],n[a]=_,l[f]=_,++_),++E,++f;e.indices=l;var h=e.attributes;for(var m in h)if(h.hasOwnProperty(m)&&c(h[m])&&c(h[m].values)){for(var p=h[m],T=p.values,R=0,A=p.componentsPerAttribute,v=u.createTypedArray(p.componentDatatype,_*A);t>R;){var N=n[R];if(-1!==N)for(i=0;A>i;i++)v[A*N+i]=T[A*R+i];++R}p.values=v}}return e},te.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===S.TRIANGLES&&c(r)){for(var n=r.length,i=0,a=0;n>a;a++)r[a]>i&&(i=r[a]);e.indices=I.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],r=d.computeNumberOfVertices(e);if(c(e.indices)&&r>=R.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=w(e.attributes),s=e.indices,l=s.length;e.primitiveType===S.TRIANGLES?n=3:e.primitiveType===S.LINES?n=2:e.primitiveType===S.POINTS&&(n=1);for(var E=0;l>E;E+=n){for(var f=0;n>f;++f){var _=s[E+f],h=i[_];c(h)||(h=o++,i[_]=h,C(u,e.attributes,_)),a.push(h)}o+n>=R.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=w(e.attributes))}0!==a.length&&t.push(new d({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new i,ne=new o;te.projectTo2D=function(e,t,r,n,a){var o=e.attributes[t];a=c(a)?a:new f;for(var s=a.ellipsoid,E=o.values,d=new Float64Array(E.length),h=0,m=0;m<E.length;m+=3){var y=i.fromArray(E,m,re),p=s.cartesianToCartographic(y,ne);if(!c(p))throw new l("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var T=a.project(p,re);d[h++]=T.x,d[h++]=T.y,d[h++]=T.z}return e.attributes[r]=o,e.attributes[n]=new _({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[t],e};var ie={high:0,low:0};te.encodeAttribute=function(e,t,r,n){for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)E.encode(a[l],ie),s[l]=ie.high,c[l]=ie.low;var f=i.componentsPerAttribute;return e.attributes[r]=new _({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:s}),e.attributes[n]=new _({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:c}),delete e.attributes[t],e};var ae=new i,oe=new v,ue=new A;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(v.equals(t,v.IDENTITY))return e;var n=e.geometry.attributes;L(t,n.position),L(t,n.prevPosition),L(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(v.inverse(t,oe),v.transpose(oe,oe),v.getRotation(oe,ue),P(ue,n.normal),P(ue,n.binormal),P(ue,n.tangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=v.clone(v.IDENTITY),e};var se=new i;te.combineInstances=function(e){for(var t=[],r=[],n=e.length,i=0;n>i;++i){var a=e[i];c(a.geometry)?t.push(a):r.push(a)}var o=[];return t.length>0&&o.push(U(t,"geometry")),r.length>0&&(o.push(U(r,"westHemisphereGeometry")),o.push(U(r,"eastHemisphereGeometry"))),o};var ce=new i,le=new i,Ee=new i,fe=new i;te.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,a=r.position.values.length/3,o=t.length,s=new Array(a),c=new Array(o/3),l=new Array(o),E=0;a>E;E++)s[E]={indexOffset:0,count:0,currentCount:0};var f=0;for(E=0;o>E;E+=3){var d=t[E],h=t[E+1],m=t[E+2],y=3*d,p=3*h,T=3*m;le.x=n[y],le.y=n[y+1],le.z=n[y+2],Ee.x=n[p],Ee.y=n[p+1],Ee.z=n[p+2],fe.x=n[T],fe.y=n[T+1],fe.z=n[T+2],s[d].count++,s[h].count++,s[m].count++,i.subtract(Ee,le,Ee),i.subtract(fe,le,fe),c[f]=i.cross(Ee,fe,new i),f++}var R=0;for(E=0;a>E;E++)s[E].indexOffset+=R,R+=s[E].count;f=0;var A;for(E=0;o>E;E+=3){A=s[t[E]];var v=A.indexOffset+A.currentCount;l[v]=f,A.currentCount++,A=s[t[E+1]],v=A.indexOffset+A.currentCount,l[v]=f,A.currentCount++,A=s[t[E+2]],v=A.indexOffset+A.currentCount,l[v]=f,A.currentCount++,f++}var N=new Float32Array(3*a);for(E=0;a>E;E++){var S=3*E;if(A=s[E],A.count>0){for(i.clone(i.ZERO,ce),f=0;f<A.count;f++)i.add(ce,c[l[A.indexOffset+f]],ce);i.normalize(ce,ce),N[S]=ce.x,N[S+1]=ce.y,N[S+2]=ce.z}else N[S]=0,N[S+1]=0,N[S+2]=1}return e.attributes.normal=new _({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:N}),e};var de=new i,_e=new i,he=new i;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,n=e.attributes.normal.values,a=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var E,f,d;for(l=0;s>l;l+=3){var h=t[l],m=t[l+1],y=t[l+2];E=3*h,f=3*m,d=3*y;var p=2*h,T=2*m,R=2*y,A=r[E],v=r[E+1],N=r[E+2],S=a[p],I=a[p+1],M=a[T+1]-I,O=a[R+1]-I,g=1/((a[T]-S)*O-(a[R]-S)*M),x=(O*(r[f]-A)-M*(r[d]-A))*g,w=(O*(r[f+1]-v)-M*(r[d+1]-v))*g,C=(O*(r[f+2]-N)-M*(r[d+2]-N))*g;c[E]+=x,c[E+1]+=w,c[E+2]+=C,c[f]+=x,c[f+1]+=w,c[f+2]+=C,c[d]+=x,c[d+1]+=w,c[d+2]+=C}var L=new Float32Array(3*o),P=new Float32Array(3*o);for(l=0;o>l;l++){E=3*l,f=E+1,d=E+2;var F=i.fromArray(n,E,de),U=i.fromArray(c,E,he),b=i.dot(F,U);i.multiplyByScalar(F,b,_e),i.normalize(i.subtract(U,_e,U),U),P[E]=U.x,P[f]=U.y,P[d]=U.z,i.normalize(i.cross(F,U,U),U),L[E]=U.x,L[f]=U.y,L[d]=U.z}return e.attributes.tangent=new _({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e.attributes.binormal=new _({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e};var me=new n,ye=new i,pe=new i,Te=new i;te.compressVertices=function(t){var r=t.attributes.normal,a=t.attributes.st;if(!c(r)&&!c(a))return t;var o,s,l,E,f=t.attributes.tangent,d=t.attributes.binormal;c(r)&&(o=r.values),c(a)&&(s=a.values),c(f)&&(l=f.values),d&&(E=d.values);var h=c(o)?o.length:s.length,m=c(o)?3:2,y=h/m,p=y,T=c(s)&&c(o)?2:1;T+=c(l)||c(E)?1:0,p*=T;for(var R=new Float32Array(p),A=0,v=0;y>v;++v){c(s)&&(n.fromArray(s,2*v,me),R[A++]=e.compressTextureCoordinates(me));var N=3*v;c(o)&&c(l)&&c(E)?(i.fromArray(o,N,ye),i.fromArray(l,N,pe),i.fromArray(E,N,Te),e.octPack(ye,pe,Te,me),R[A++]=me.x,R[A++]=me.y):(c(o)&&(i.fromArray(o,N,ye),R[A++]=e.octEncodeFloat(ye)),c(l)&&(i.fromArray(l,N,ye),R[A++]=e.octEncodeFloat(ye)),c(E)&&(i.fromArray(E,N,ye),R[A++]=e.octEncodeFloat(ye)))}return t.attributes.compressedAttributes=new _({componentDatatype:u.FLOAT,componentsPerAttribute:T,values:R}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(E)&&delete t.attributes.binormal,t};var Re=new i,Ae=new i,ve=new i,Ne=new i,Se=new i,Ie={positions:new Array(7),indices:new Array(9)},Me=new i,Oe=new i,ge=new i,xe=new i,we=new n,Ce=new n,Le=new n,Pe=N.fromPointNormal(i.ZERO,i.UNIT_Y),Fe=new i,Ue=new i,be=new n,De=new n,Be=new i,ze=new i,Ge=new i,Ve=new i,qe=new i,He=new i,Xe=new i,We=new a;new a;return te.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var i=n.center.x-n.radius;if(i>0||r.intersectPlane(n,N.ORIGIN_ZX_PLANE)!==p.INTERSECTING)return e}if(t.geometryType!==m.NONE)switch(t.geometryType){case m.POLYLINES:ee(e);break;case m.TRIANGLES:J(e);break;case m.LINES:$(e)}else q(t),t.primitiveType===S.TRIANGLES?J(e):t.primitiveType===S.LINES&&$(e);return e},te}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.binormal?1:0,r[n++]=t.tangent?1:0,r[n++]=t.color?1:0},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.position=1===r[n++],a.normal=1===r[n++],a.st=1===r[n++],a.binormal=1===r[n++],a.tangent=1===r[n++],a.color=1===r[n++],a},i.clone=function(e,r){return t(e)?(t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},i}),define("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,n,i,a,o,u,s,c,l,E,f,d,_,h,m,y,p,T,R,A){"use strict";function v(e,n,a){var o=n.vertexFormat,u=n.center,c=n.semiMajorAxis,E=n.semiMinorAxis,_=n.ellipsoid,h=n.stRotation,m=a?e.length/3*2:e.length/3,y=o.st?new Float32Array(2*m):void 0,T=o.normal?new Float32Array(3*m):void 0,A=o.tangent?new Float32Array(3*m):void 0,v=o.binormal?new Float32Array(3*m):void 0,N=0,S=U,I=b,M=D,O=new l(_),C=O.project(_.cartesianToCartographic(u,B),z),q=_.scaleToGeodeticSurface(u,g);_.geodeticSurfaceNormal(q,q);for(var H=R.fromAxisAngle(q,h,F),X=p.fromQuaternion(H,P),W=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,G),Y=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,V),k=e.length,K=a?k:0,j=K/3*2,Z=0;k>Z;Z+=3){var Q=Z+1,J=Z+2,$=r.fromArray(e,Z,g);if(o.st){var ee=p.multiplyByVector(X,$,x),te=O.project(_.cartesianToCartographic(ee,B),w);r.subtract(te,C,te),L.x=(te.x+c)/(2*c),L.y=(te.y+E)/(2*E),W.x=Math.min(L.x,W.x),W.y=Math.min(L.y,W.y),Y.x=Math.max(L.x,Y.x),Y.y=Math.max(L.y,Y.y),a&&(y[N+j]=L.x,y[N+1+j]=L.y),y[N++]=L.x,y[N++]=L.y}S=_.geodeticSurfaceNormal($,S),(o.normal||o.tangent||o.binormal)&&((o.tangent||o.binormal)&&(I=r.cross(r.UNIT_Z,S,I),p.multiplyByVector(X,I,I)),o.normal&&(T[Z]=S.x,T[Q]=S.y,T[J]=S.z,a&&(T[Z+K]=-S.x,T[Q+K]=-S.y,T[J+K]=-S.z)),o.tangent&&(A[Z]=I.x,A[Q]=I.y,A[J]=I.z,a&&(A[Z+K]=-I.x,A[Q+K]=-I.y,A[J+K]=-I.z)),o.binormal&&(M=r.cross(S,I,M),v[Z]=M.x,v[Q]=M.y,v[J]=M.z,a&&(v[Z+K]=M.x,v[Q+K]=M.y,v[J+K]=M.z)))}if(o.st){k=y.length;for(var re=0;k>re;re+=2)y[re]=(y[re]-W.x)/(Y.x-W.x),y[re+1]=(y[re+1]-W.y)/(Y.y-W.y)}var ne=new d;if(o.position){var ie=s.raisePositionsToHeight(e,n,a);
ne.position=new f({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:ie})}return o.st&&(ne.st=new f({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:y})),o.normal&&(ne.normal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:T})),o.tangent&&(ne.tangent=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),o.binormal&&(ne.binormal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:v})),ne}function N(e){var t,r,n,i,a,o=new Array(2*e*(e+1)),u=0;for(i=1;e>i;++i){for(n=i*(i+1),t=(i-1)*i,o[u++]=n++,o[u++]=t,o[u++]=n,r=2*i,a=0;r-1>a;++a)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=n++,o[u++]=t,o[u++]=n}for(r=2*e,++n,++t,i=0;r-1>i;++i)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;for(++t,++n,i=e-1;i>0;--i){for(o[u++]=t++,o[u++]=t,o[u++]=n,r=2*i,a=0;r-1>a;++a)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=t++,o[u++]=t++,o[u++]=n++}return o}function S(t){var n=t.center;q=r.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(n,q),t.height,q),q=r.add(n,q,q);var i=new e(q,t.semiMajorAxis),a=s.computeEllipsePositions(t,!0,!1),o=a.positions,u=a.numPts,c=v(o,t,!1),l=N(u);return l=m.createTypedArray(o.length/3,l),{boundingSphere:i,attributes:c,indices:l}}function I(e,n){var a=n.vertexFormat,o=n.center,u=n.semiMajorAxis,s=n.semiMinorAxis,c=n.ellipsoid,E=n.height,_=n.extrudedHeight,h=n.stRotation,m=e.length/3*2,y=new Float64Array(3*m),T=a.st?new Float32Array(2*m):void 0,A=a.normal?new Float32Array(3*m):void 0,v=a.tangent?new Float32Array(3*m):void 0,N=a.binormal?new Float32Array(3*m):void 0,S=0,I=U,M=b,O=D,q=new l(c),H=q.project(c.cartesianToCartographic(o,B),z),X=c.scaleToGeodeticSurface(o,g);c.geodeticSurfaceNormal(X,X);for(var W=R.fromAxisAngle(X,h,F),Y=p.fromQuaternion(W,P),k=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,G),K=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,V),j=e.length,Z=j/3*2,Q=0;j>Q;Q+=3){var J,$=Q+1,ee=Q+2,te=r.fromArray(e,Q,g);if(a.st){var re=p.multiplyByVector(Y,te,x),ne=q.project(c.cartesianToCartographic(re,B),w);r.subtract(ne,H,ne),L.x=(ne.x+u)/(2*u),L.y=(ne.y+s)/(2*s),k.x=Math.min(L.x,k.x),k.y=Math.min(L.y,k.y),K.x=Math.max(L.x,K.x),K.y=Math.max(L.y,K.y),T[S+Z]=L.x,T[S+1+Z]=L.y,T[S++]=L.x,T[S++]=L.y}te=c.scaleToGeodeticSurface(te,te),J=r.clone(te,x),I=c.geodeticSurfaceNormal(te,I);var ie=r.multiplyByScalar(I,E,C);if(te=r.add(te,ie,te),ie=r.multiplyByScalar(I,_,ie),J=r.add(J,ie,J),a.position&&(y[Q+j]=J.x,y[$+j]=J.y,y[ee+j]=J.z,y[Q]=te.x,y[$]=te.y,y[ee]=te.z),a.normal||a.tangent||a.binormal){O=r.clone(I,O);var ae=r.fromArray(e,(Q+3)%j,C);r.subtract(ae,te,ae);var oe=r.subtract(J,te,w);I=r.normalize(r.cross(oe,ae,I),I),a.normal&&(A[Q]=I.x,A[$]=I.y,A[ee]=I.z,A[Q+j]=I.x,A[$+j]=I.y,A[ee+j]=I.z),a.tangent&&(M=r.normalize(r.cross(O,I,M),M),v[Q]=M.x,v[$]=M.y,v[ee]=M.z,v[Q+j]=M.x,v[Q+1+j]=M.y,v[Q+2+j]=M.z),a.binormal&&(N[Q]=O.x,N[$]=O.y,N[ee]=O.z,N[Q+j]=O.x,N[$+j]=O.y,N[ee+j]=O.z)}}if(a.st){j=T.length;for(var ue=0;j>ue;ue+=2)T[ue]=(T[ue]-k.x)/(K.x-k.x),T[ue+1]=(T[ue+1]-k.y)/(K.y-k.y)}var se=new d;return a.position&&(se.position=new f({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:y})),a.st&&(se.st=new f({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:T})),a.normal&&(se.normal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),a.tangent&&(se.tangent=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:v})),a.binormal&&(se.binormal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:N})),se}function M(e){for(var t=e.length/3,r=m.createTypedArray(t,6*t),n=0,i=0;t>i;i++){var a=i,o=i+t,u=(a+1)%t,s=u+t;r[n++]=a,r[n++]=o,r[n++]=u,r[n++]=u,r[n++]=o,r[n++]=s}return r}function O(t){var n=t.center,i=t.ellipsoid,a=t.semiMajorAxis,o=r.multiplyByScalar(i.geodeticSurfaceNormal(n,g),t.height,g);H.center=r.add(n,o,H.center),H.radius=a,o=r.multiplyByScalar(i.geodeticSurfaceNormal(n,o),t.extrudedHeight,o),X.center=r.add(n,o,X.center),X.radius=a;var u=s.computeEllipsePositions(t,!0,!0),c=u.positions,l=u.numPts,f=u.outerPositions,d=e.union(H,X),y=v(c,t,!0),p=N(l),R=p.length;p.length=2*R;for(var A=c.length/3,S=0;R>S;S+=3)p[S+R]=p[S+2]+A,p[S+1+R]=p[S+1]+A,p[S+2+R]=p[S]+A;var O=m.createTypedArray(2*A/3,p),x=new E({attributes:y,indices:O,primitiveType:T.TRIANGLES}),w=I(f,t);p=M(f);var C=m.createTypedArray(2*f.length/3,p),L=new E({attributes:w,indices:C,primitiveType:T.TRIANGLES}),P=h.combineInstances([new _({geometry:x}),new _({geometry:L})]);return{boundingSphere:d,attributes:P[0].attributes,indices:P[0].indices}}var g=new r,x=new r,w=new r,C=new r,L=new t,P=new p,F=new R,U=new r,b=new r,D=new r,B=new n,z=new r,G=new t,V=new t,q=new r,H=new e,X=new e,W=function(e){e=a(e,a.EMPTY_OBJECT);var t=e.center,n=a(e.ellipsoid,c.WGS84),i=e.semiMajorAxis,u=e.semiMinorAxis,s=a(e.granularity,y.RADIANS_PER_DEGREE),l=a(e.height,0),E=e.extrudedHeight,f=o(E)&&Math.abs(l-E)>1,d=a(e.vertexFormat,A.DEFAULT);this._center=r.clone(t),this._semiMajorAxis=i,this._semiMinorAxis=u,this._ellipsoid=c.clone(n),this._rotation=a(e.rotation,0),this._stRotation=a(e.stRotation,0),this._height=l,this._granularity=s,this._vertexFormat=A.clone(d),this._extrudedHeight=a(E,l),this._extrude=f,this._workerName="createEllipseGeometry"};W.packedLength=r.packedLength+c.packedLength+A.packedLength+8,W.pack=function(e,t,n){n=a(n,0),r.pack(e._center,t,n),n+=r.packedLength,c.pack(e._ellipsoid,t,n),n+=c.packedLength,A.pack(e._vertexFormat,t,n),n+=A.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n]=e._extrude?1:0};var Y=new r,k=new c,K=new A,j={center:Y,ellipsoid:k,vertexFormat:K,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return W.unpack=function(e,t,n){t=a(t,0);var i=r.unpack(e,t,Y);t+=r.packedLength;var u=c.unpack(e,t,k);t+=c.packedLength;var s=A.unpack(e,t,K);t+=A.packedLength;var l=e[t++],E=e[t++],f=e[t++],d=e[t++],_=e[t++],h=e[t++],m=e[t++],y=1===e[t];return o(n)?(n._center=r.clone(i,n._center),n._ellipsoid=c.clone(u,n._ellipsoid),n._vertexFormat=A.clone(s,n._vertexFormat),n._semiMajorAxis=l,n._semiMinorAxis=E,n._rotation=f,n._stRotation=d,n._height=_,n._granularity=h,n._extrudedHeight=m,n._extrude=y,n):(j.height=_,j.extrudedHeight=m,j.granularity=h,j.stRotation=d,j.rotation=f,j.semiMajorAxis=l,j.semiMinorAxis=E,new W(j))},W.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=O(r)):t=S(r),new E({attributes:t.attributes,indices:t.indices,primitiveType:T.TRIANGLES,boundingSphere:t.boundingSphere})},W.createShadowVolume=function(e,t,r){var n=e._granularity,i=e._ellipsoid,a=t(n,i),o=r(n,i);return new W({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:i,stRotation:e._stRotation,granularity:n,extrudedHeight:a,height:o,vertexFormat:A.POSITION_ONLY})},W}),define("Core/CircleGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseGeometry","./Ellipsoid","./Math","./VertexFormat"],function(e,t,r,n,i,a,o,u){"use strict";var s=function(e){e=t(e,t.EMPTY_OBJECT);var r=e.radius,n={center:e.center,semiMajorAxis:r,semiMinorAxis:r,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation};this._ellipseGeometry=new i(n),this._workerName="createCircleGeometry"};s.packedLength=i.packedLength,s.pack=function(e,t,r){i.pack(e._ellipseGeometry,t,r)};var c=new i({center:new e,semiMajorAxis:1,semiMinorAxis:1}),l={center:new e,radius:void 0,ellipsoid:a.clone(a.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new u,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return s.unpack=function(t,n,o){var E=i.unpack(t,n,c);return l.center=e.clone(E._center,l.center),l.ellipsoid=a.clone(E._ellipsoid,l.ellipsoid),l.height=E._height,l.extrudedHeight=E._extrudedHeight,l.granularity=E._granularity,l.vertexFormat=u.clone(E._vertexFormat,l.vertexFormat),l.stRotation=E._stRotation,r(o)?(l.semiMajorAxis=E._semiMajorAxis,l.semiMinorAxis=E._semiMinorAxis,o._ellipseGeometry=new i(l),o):(l.radius=E._semiMajorAxis,new s(l))},s.createGeometry=function(e){return i.createGeometry(e._ellipseGeometry)},s.createShadowVolume=function(e,t,r){var n=e._ellipseGeometry._granularity,i=e._ellipseGeometry._ellipsoid,a=t(n,i),o=r(n,i);return new s({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:i,stRotation:e._ellipseGeometry._stRotation,granularity:n,extrudedHeight:a,height:o,vertexFormat:u.POSITION_ONLY})},s}),define("Workers/createCircleGeometry",["../Core/Cartesian3","../Core/CircleGeometry","../Core/defined","../Core/Ellipsoid"],function(e,t,r,n){"use strict";function i(i,a){return r(a)&&(i=t.unpack(i,a)),i._ellipseGeometry._center=e.clone(i._ellipseGeometry._center),i._ellipseGeometry._ellipsoid=n.clone(i._ellipseGeometry._ellipsoid),t.createGeometry(i)}return i})}();