/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},a.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,r,n,a){a=t(a,n);var i=Math.abs(e-r);return a>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var r=i[t-1],n=t;e>=n;n++)i.push(r*n);return i[e]},a.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var a=r.clock,o=r.cone,u=e(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(o),n},i.fromElements=function(e,r,n,a){return t(a)?(a.x=e,a.y=r,a.z=n,a):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,f=n*u-a*o;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,r,n,o)};var f=new i,d=new i,h=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:h,c=Math.cos(n);f.x=c*Math.cos(r),f.y=c*Math.sin(r),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(s,f,d);var l=Math.sqrt(i.dot(f,d));return d=i.divideByScalar(d,l,d),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(d,f,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=a.toRadians(e[o]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var a=e.length;t(n)?n.length=a/2:n=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];n[o/2]=i.fromRadians(u,s,0,r,n[o/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o+=3)n[o]=a.toRadians(e[o]),n[o+1]=a.toRadians(e[o+1]),n[o+2]=e[o+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var a=e.length;t(n)?n.length=a/3:n=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];n[o/3]=i.fromRadians(u,s,c,r,n[o/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return i.fromRadians=function(r,n,a,o){return a=e(a,0),t(o)?(o.longitude=r,o.latitude=n,o.height=a,o):new i(r,n,a)},i.fromDegrees=function(e,t,r,n){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(t,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),t._radii=new e(n,a,i),t._radiiSquared=new e(n*n,a*a,i*i),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,a,i),t._maximumRadius=Math.max(n,a,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,r)};a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(a.x,a.y,a.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,a){a=r(a,0),e.pack(t._radii,n,a)},c.unpack=function(t,n,a){n=r(n,0);var i=e.unpack(t,n);return c.fromCartesian3(i,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,f=new e;c.prototype.cartographicToCartesian=function(t,r){var a=l,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,h=new e,E=new e;c.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,h);if(!n(i))return void 0;var o=this.geodeticSurfaceNormal(i,d),s=e.subtract(r,i,E),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var m=new e,p=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var a=t.x,i=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,f=s.z,d=a*a*c*c,h=i*i*l*l,E=o*o*f*f,y=d+h+E,_=Math.sqrt(1/y),v=e.multiplyByScalar(t,_,m);if(y<this._centerToleranceSquared)return isFinite(_)?e.clone(v,r):void 0;var T=this._oneOverRadiiSquared,R=T.x,A=T.y,S=T.z,g=p;g.x=v.x*R*2,g.y=v.y*A*2,g.z=v.z*S*2;var N,O,I,M,w,x,C,P,D,L,U,b=(1-_)*e.magnitude(t)/(.5*e.magnitude(g)),F=0;do{b-=F,I=1/(1+b*R),M=1/(1+b*A),w=1/(1+b*S),x=I*I,C=M*M,P=w*w,D=x*I,L=C*M,U=P*w,N=d*x+h*C+E*P-1,O=d*D*R+h*L*A+E*U*S;var z=-2*O;F=N/z}while(Math.abs(N)>u.EPSILON12);return n(r)?(r.x=a*I,r.y=i*M,r.z=o*w,r):new e(a*I,i*M,o*w)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,r,n,a){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(a,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,a,i,o){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),r(o)?(o.west=e,o.south=n,o.east=a,o.north=i,o):new s(e,n,a,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];n=Math.min(n,l.longitude),a=Math.max(a,l.longitude),i=Math.min(i,l.latitude),o=Math.max(o,l.latitude)}return r(t)?(t.west=n,t.south=i,t.east=a,t.north=o,t):new s(n,i,a,o)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if((e.west<e.east||t.west<t.east)&&l>=f)return void 0;var d=Math.max(e.south,t.south),h=Math.min(e.north,t.north);return d>=h?void 0:r(n)?(n.west=l,n.south=d,n.east=f,n.north=h,n):new s(l,d,f,h)},s.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>a||u.equalsEpsilon(r,a,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,a,o){n=t(n,i.WGS84),a=t(a,0),r(o)||(o=[]);var l=0,f=e.north,d=e.south,h=e.east,E=e.west,m=c;m.height=a,m.longitude=E,m.latitude=f,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.longitude=h,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.latitude=d,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.longitude=E,o[l]=n.cartographicToCartesian(m,o[l]),l++,0>f?m.latitude=f:d>0?m.latitude=d:m.latitude=0;for(var p=1;8>p;++p)m.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,m)&&(o[l]=n.cartographicToCartesian(m,o[l]),l++);return 0===m.latitude&&(m.longitude=E,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.longitude=h,o[l]=n.cartographicToCartesian(m,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var r={},n=function(t,n){e(r[t])||(r[t]=!0,console.log(n))};return n}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";var u=function(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n,a){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(a,0)};i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)&&a.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function u(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(h[r],d[r])];t+=2*n*n}return Math.sqrt(t)}function s(e,t){for(var r=i.EPSILON15,n=0,a=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(h[o],d[o])]);u>n&&(a=o,n=u)}var s=1,l=0,f=d[a],E=h[a];if(Math.abs(e[c.getElementIndex(E,f)])>r){var m,p=e[c.getElementIndex(E,E)],y=e[c.getElementIndex(f,f)],_=e[c.getElementIndex(E,f)],v=(p-y)/2/_;m=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),s=1/Math.sqrt(1+m*m),l=m*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(f,f)]=t[c.getElementIndex(E,E)]=s,t[c.getElementIndex(E,f)]=l,t[c.getElementIndex(f,E)]=-l,t}var c=function(e,r,n,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new c),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a[4]=e[n++],a[5]=e[n++],a[6]=e[n++],a[7]=e[n++],a[8]=e[n++],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,a){return n=t(n,0),r(a)||(a=new c),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a[4]=e[n+4],a[5]=e[n+5],a[6]=e[n+6],a[7]=e[n+7],a[8]=e[n+8],a},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,f=e.z*e.z,d=e.z*e.w,h=e.w*e.w,E=n-u-f+h,m=2*(a-d),p=2*(i+l),y=2*(a+d),_=-n+u-f+h,v=2*(s-o),T=2*(i-l),R=2*(s+o),A=-n-u+f+h;return r(t)?(t[0]=E,t[1]=y,t[2]=T,t[3]=m,t[4]=_,t[5]=R,t[6]=p,t[7]=v,t[8]=A,t):new c(E,m,p,y,_,v,T,R,A)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new c(1,0,0,0,n,-a,0,a,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new c(n,0,a,0,1,0,-a,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-a,0,a,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n},c.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var f=new e;c.getMaximumScale=function(t){return c.getScale(t,f),e.maximumComponent(f)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var d=[1,0,0],h=[2,2,1],E=new c,m=new c;return c.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,a=10,l=0,f=0;r(t)||(t={});for(var d=t.unitary=c.clone(c.IDENTITY,t.unitary),h=t.diagonal=c.clone(e,t.diagonal),p=n*o(h);a>f&&u(h)>p;)s(h,E),c.transpose(E,m),c.multiply(h,E,h),c.multiply(m,h,h),c.multiply(d,E,d),++l>2&&(++f,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},c.inverse=function(e,t){var r=e[0],a=e[1],o=e[2],u=e[3],s=e[4],l=e[5],f=e[6],d=e[7],h=e[8],E=c.determinant(e);if(Math.abs(E)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=s*h-d*l,t[1]=d*o-a*h,t[2]=a*l-s*o,t[3]=f*l-u*h,t[4]=r*h-f*o,t[5]=u*o-r*l,t[6]=u*d-f*s,t[7]=f*a-r*d,t[8]=r*s-u*a;var m=1/E;return c.multiplyByScalar(t,m,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=a(new c(1,0,0,0,1,0,0,0,1)),c.ZERO=a(new c(0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),
t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s){"use strict";var c=function(e,t,n,a,i,o,u,s,c,l,f,d,h,E,m,p){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(h,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(E,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(f,0),this[11]=r(m,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(d,0),this[15]=r(p,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=r(a,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,a){n(a)||(a=new c);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,d=t.x*t.w,h=t.y*t.y,E=t.y*t.z,m=t.y*t.w,p=t.z*t.z,y=t.z*t.w,_=t.w*t.w,v=s-h-p+_,T=2*(l-y),R=2*(f+m),A=2*(l+y),S=-s+h-p+_,g=2*(E-d),N=2*(f-m),O=2*(E+d),I=-s-h+p+_;return a[0]=v*i,a[1]=A*i,a[2]=N*i,a[3]=0,a[4]=T*o,a[5]=S*o,a[6]=O*o,a[7]=0,a[8]=R*u,a[9]=g*u,a[10]=I*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,d=new e;c.fromCamera=function(t,r){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,d),d);var u=f.x,s=f.y,h=f.z,E=l.x,m=l.y,p=l.z,y=d.x,_=d.y,v=d.z,T=a.x,R=a.y,A=a.z,S=u*-T+s*-R+h*-A,g=y*-T+_*-R+v*-A,N=E*T+m*R+p*A;return n(r)?(r[0]=u,r[1]=y,r[2]=-E,r[3]=0,r[4]=s,r[5]=_,r[6]=-m,r[7]=0,r[8]=h,r[9]=v,r[10]=-p,r[11]=0,r[12]=S,r[13]=g,r[14]=N,r[15]=1,r):new c(u,s,h,S,y,_,v,g,-E,-m,-p,N,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,f=-(n+r)*s,d=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=d,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+a)/(i-a),d=-1,h=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=d,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,f=-1,d=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=d,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,a){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,f=.5*(n-t),d=c,h=l,E=f,m=i+c,p=o+l,y=t+f,_=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=m,a[13]=p,a[14]=y,a[15]=_,a},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},c.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},c.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var h=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),r};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],d=e[9],h=e[10],E=e[11],m=e[12],p=e[13],y=e[14],_=e[15],v=t[0],T=t[1],R=t[2],A=t[3],S=t[4],g=t[5],N=t[6],O=t[7],I=t[8],M=t[9],w=t[10],x=t[11],C=t[12],P=t[13],D=t[14],L=t[15],U=n*v+u*T+f*R+m*A,b=a*v+s*T+d*R+p*A,F=i*v+c*T+h*R+y*A,z=o*v+l*T+E*R+_*A,B=n*S+u*g+f*N+m*O,G=a*S+s*g+d*N+p*O,q=i*S+c*g+h*N+y*O,W=o*S+l*g+E*N+_*O,H=n*I+u*M+f*w+m*x,X=a*I+s*M+d*w+p*x,V=i*I+c*M+h*w+y*x,Y=o*I+l*M+E*w+_*x,k=n*C+u*P+f*D+m*L,j=a*C+s*P+d*D+p*L,Z=i*C+c*P+h*D+y*L,K=o*C+l*P+E*D+_*L;return r[0]=U,r[1]=b,r[2]=F,r[3]=z,r[4]=B,r[5]=G,r[6]=q,r[7]=W,r[8]=H,r[9]=X,r[10]=V,r[11]=Y,r[12]=k,r[13]=j,r[14]=Z,r[15]=K,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=e[12],h=e[13],E=e[14],m=t[0],p=t[1],y=t[2],_=t[4],v=t[5],T=t[6],R=t[8],A=t[9],S=t[10],g=t[12],N=t[13],O=t[14],I=n*m+o*p+c*y,M=a*m+u*p+l*y,w=i*m+s*p+f*y,x=n*_+o*v+c*T,C=a*_+u*v+l*T,P=i*_+s*v+f*T,D=n*R+o*A+c*S,L=a*R+u*A+l*S,U=i*R+s*A+f*S,b=n*g+o*N+c*O+d,F=a*g+u*N+l*O+h,z=i*g+s*N+f*O+E;return r[0]=I,r[1]=M,r[2]=w,r[3]=0,r[4]=x,r[5]=C,r[6]=P,r[7]=0,r[8]=D,r[9]=L,r[10]=U,r[11]=0,r[12]=b,r[13]=F,r[14]=z,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=t[0],h=t[1],E=t[2],m=t[3],p=t[4],y=t[5],_=t[6],v=t[7],T=t[8],R=n*d+o*h+c*E,A=a*d+u*h+l*E,S=i*d+s*h+f*E,g=n*m+o*p+c*y,N=a*m+u*p+l*y,O=i*m+s*p+f*y,I=n*_+o*v+c*T,M=a*_+u*v+l*T,w=i*_+s*v+f*T;return r[0]=R,r[1]=A,r[2]=S,r[3]=0,r[4]=g,r[5]=N,r[6]=O,r[7]=0,r[8]=I,r[9]=M,r[10]=w,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var m=new e;c.multiplyByUniformScale=function(e,t,r){return m.x=t,m.y=t,m.z=t,c.multiplyByScale(e,m,r)},c.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var p=new u,y=new u,_=new t,v=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,p),y,o.EPSILON7)&&t.equals(c.getRow(e,3,_),v))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],l=e[12],f=e[1],d=e[5],h=e[9],E=e[13],m=e[2],T=e[6],R=e[10],A=e[14],S=e[3],g=e[7],N=e[11],O=e[15],I=R*O,M=A*N,w=T*O,x=A*g,C=T*N,P=R*g,D=m*O,L=A*S,U=m*N,b=R*S,F=m*g,z=T*S,B=I*d+x*h+C*E-(M*d+w*h+P*E),G=M*f+D*h+b*E-(I*f+L*h+U*E),q=w*f+L*d+F*E-(x*f+D*d+z*E),W=P*f+U*d+z*h-(C*f+b*d+F*h),H=M*a+w*i+P*l-(I*a+x*i+C*l),X=I*n+L*i+U*l-(M*n+D*i+b*l),V=x*n+D*a+z*l-(w*n+L*a+F*l),Y=C*n+b*a+F*i-(P*n+U*a+z*i);I=i*E,M=l*h,w=a*E,x=l*d,C=a*h,P=i*d,D=n*E,L=l*f,U=n*h,b=i*f,F=n*d,z=a*f;var k=I*g+x*N+C*O-(M*g+w*N+P*O),j=M*S+D*N+b*O-(I*S+L*N+U*O),Z=w*S+L*g+F*O-(x*S+D*g+z*O),K=P*S+U*g+z*N-(C*S+b*g+F*N),J=w*R+P*A+M*T-(C*A+I*T+x*R),Q=U*A+I*m+L*R-(D*R+b*A+M*m),$=D*T+z*A+x*m-(F*A+w*m+L*T),ee=F*R+C*m+b*T-(U*T+z*R+P*m),te=n*B+a*G+i*q+l*W;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=B*te,r[1]=G*te,r[2]=q*te,r[3]=W*te,r[4]=H*te,r[5]=X*te,r[6]=V*te,r[7]=Y*te,r[8]=k*te,r[9]=j*te,r[10]=Z*te,r[11]=K*te,r[12]=J*te,r[13]=Q*te,r[14]=$*te,r[15]=ee*te,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],d=e[13],h=e[14],E=-r*f-n*d-a*h,m=-i*f-o*d-u*h,p=-s*f-c*d-l*h;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=E,t[13]=m,t[14]=p,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var a=function(t,r){this.normal=e.clone(t),this.distance=r};a.fromPointNormal=function(r,n,i){var o=-e.dot(n,r);return t(i)?(e.clone(n,i.normal),i.distance=o,i):new a(n,o)};var i=new e;return a.fromCartesian4=function(r,n){var o=e.fromCartesian4(r,i),u=r.w;return t(n)?(e.clone(o,n.normal),n.distance=u,n):new a(o,u)},a.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},a.ORIGIN_XY_PLANE=n(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=n(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=n(new a(e.UNIT_Y,0)),a}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l,f,d){"use strict";var h=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},E=new e,m=new e,p=new e,y=new e,_=new e,v=new e,T=new e,R=new e,A=new e,S=new e,g=new e,N=new e;h.fromPoints=function(t,r){if(n(r)||(r=new h),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var a=e.clone(t[0],T),i=e.clone(a,E),o=e.clone(a,m),u=e.clone(a,p),s=e.clone(a,y),c=e.clone(a,_),l=e.clone(a,v),f=t.length,d=1;f>d;d++){e.clone(t[d],a);var O=a.x,I=a.y,M=a.z;O<i.x&&e.clone(a,i),O>s.x&&e.clone(a,s),I<o.y&&e.clone(a,o),I>c.y&&e.clone(a,c),M<u.z&&e.clone(a,u),M>l.z&&e.clone(a,l)}var w=e.magnitudeSquared(e.subtract(s,i,R)),x=e.magnitudeSquared(e.subtract(c,o,R)),C=e.magnitudeSquared(e.subtract(l,u,R)),P=i,D=s,L=w;x>L&&(L=x,P=o,D=c),C>L&&(L=C,P=u,D=l);var U=A;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var b=e.magnitudeSquared(e.subtract(D,U,R)),F=Math.sqrt(b),z=S;z.x=i.x,z.y=o.y,z.z=u.z;var B=g;B.x=s.x,B.y=c.y,B.z=l.z;var G=e.multiplyByScalar(e.add(z,B,R),.5,N),q=0;for(d=0;f>d;d++){e.clone(t[d],a);var W=e.magnitude(e.subtract(a,G,R));W>q&&(q=W);var H=e.magnitudeSquared(e.subtract(a,U,R));if(H>b){var X=Math.sqrt(H);F=.5*(F+X),b=F*F;var V=X-F;U.x=(F*U.x+V*a.x)/X,U.y=(F*U.y+V*a.y)/X,U.z=(F*U.z+V*a.z)/X}}return q>F?(e.clone(U,r.center),r.radius=F):(e.clone(G,r.center),r.radius=q),r};var O=new u,I=new e,M=new e,w=new t,x=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,a,i,o,u){if(n(u)||(u=new h),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=r(a,O),d.southwest(t,w),w.height=i,d.northeast(t,x),x.height=o;var s=a.project(w,I),c=a.project(x,M),l=c.x-s.x,f=c.y-s.y,E=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+E*E);var m=u.center;return m.x=s.x+.5*l,m.y=s.y+.5*f,m.z=s.z+.5*E,u};var C=[];h.fromRectangle3D=function(e,t,a,i){t=r(t,o.WGS84),a=r(a,0);var u;return n(e)&&(u=d.subsample(e,t,a,C)),h.fromPoints(u,i)},h.fromVertices=function(t,a,i,o){if(n(o)||(o=new h),!n(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=r(a,e.ZERO),i=r(i,3);var u=T;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,E),c=e.clone(u,m),l=e.clone(u,p),f=e.clone(u,y),d=e.clone(u,_),O=e.clone(u,v),I=t.length,M=0;I>M;M+=i){var w=t[M]+a.x,x=t[M+1]+a.y,C=t[M+2]+a.z;u.x=w,u.y=x,u.z=C,w<s.x&&e.clone(u,s),w>f.x&&e.clone(u,f),x<c.y&&e.clone(u,c),x>d.y&&e.clone(u,d),C<l.z&&e.clone(u,l),C>O.z&&e.clone(u,O)}var P=e.magnitudeSquared(e.subtract(f,s,R)),D=e.magnitudeSquared(e.subtract(d,c,R)),L=e.magnitudeSquared(e.subtract(O,l,R)),U=s,b=f,F=P;D>F&&(F=D,U=c,b=d),L>F&&(F=L,U=l,b=O);var z=A;z.x=.5*(U.x+b.x),z.y=.5*(U.y+b.y),z.z=.5*(U.z+b.z);var B=e.magnitudeSquared(e.subtract(b,z,R)),G=Math.sqrt(B),q=S;q.x=s.x,q.y=c.y,q.z=l.z;var W=g;W.x=f.x,W.y=d.y,W.z=O.z;var H=e.multiplyByScalar(e.add(q,W,R),.5,N),X=0;for(M=0;I>M;M+=i){u.x=t[M]+a.x,u.y=t[M+1]+a.y,u.z=t[M+2]+a.z;var V=e.magnitude(e.subtract(u,H,R));V>X&&(X=V);var Y=e.magnitudeSquared(e.subtract(u,z,R));if(Y>B){var k=Math.sqrt(Y);G=.5*(G+k),B=G*G;var j=k-G;z.x=(G*z.x+j*u.x)/k,z.y=(G*z.y+j*u.y)/k,z.z=(G*z.z+j*u.z)/k}}return X>G?(e.clone(z,o.center),o.radius=G):(e.clone(H,o.center),o.radius=X),o},h.fromCornerPoints=function(t,r,a){n(a)||(a=new h);var i=a.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,r),a},h.fromEllipsoid=function(t,r){return n(r)||(r=new h),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var P=new e;h.fromBoundingSpheres=function(t,r){if(n(r)||(r=new h),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var a=t.length;if(1===a)return h.clone(t[0],r);if(2===a)return h.union(t[0],t[1],r);for(var i=[],o=0;a>o;o++)i.push(t[o].center);r=h.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r},h.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,n){n=r(n,0);var a=e.center;t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius},h.unpack=function(e,t,a){t=r(t,0),n(a)||(a=new h);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var D=new e,L=new e;h.union=function(t,r,a){n(a)||(a=new h);var i=t.center,o=t.radius,u=r.center,s=r.radius,c=e.subtract(u,i,D),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return r.clone(a),a;var f=.5*(o+l+s),d=e.multiplyByScalar(c,(-o+f)/l,L);return e.add(d,i,d),e.clone(d,a.center),a.radius=f,a};var U=new e;h.expand=function(t,r,n){n=h.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,U));return a>n.radius&&(n.radius=a),n},h.intersectPlane=function(t,r){var n=t.center,a=t.radius,i=r.normal,o=e.dot(i,n)+r.distance;return-a>o?s.OUTSIDE:a>o?s.INTERSECTING:s.INSIDE},h.transform=function(e,t,r){return n(r)||(r=new h),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var b=new e;h.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,b);return e.magnitudeSquared(n)-t.radius*t.radius},h.transformWithoutScale=function(e,t,r){return n(r)||(r=new h),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var F=new e;h.computePlaneDistances=function(t,r,a,i){n(i)||(i=new c);var o=e.subtract(t.center,r,F),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var z=new e,B=new e,G=new e,q=new e,W=new e,H=new t,X=new Array(8),V=0;8>V;++V)X[V]=new e;var Y=new u;return h.projectTo2D=function(t,n,a){n=r(n,Y);var i=n.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,z),c=e.cross(e.UNIT_Z,s,B);e.normalize(c,c);var l=e.cross(s,c,G);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,W),d=e.negate(c,q),E=X,m=E[0];e.add(s,l,m),e.add(m,c,m),m=E[1],e.add(s,l,m),e.add(m,d,m),m=E[2],e.add(s,f,m),e.add(m,d,m),m=E[3],e.add(s,f,m),e.add(m,c,m),e.negate(s,s),m=E[4],e.add(s,l,m),e.add(m,c,m),m=E[5],e.add(s,l,m),e.add(m,d,m),m=E[6],e.add(s,f,m),e.add(m,d,m),m=E[7],e.add(s,f,m),e.add(m,c,m);for(var p=E.length,y=0;p>y;++y){var _=E[y];e.add(o,_,_);var v=i.cartesianToCartographic(_,H);n.project(v,_)}a=h.fromPoints(E,a),o=a.center;var T=o.x,R=o.y,A=o.z;return o.x=A,o.y=T,o.z=R,a},h.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,
DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?n.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(n.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[n.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,y=n(e[1]))}return p}function i(){return a()&&y}function o(){if(!t(_)&&(_=!1,!a()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,v=n(e[1]))}return _}function u(){return o()&&v}function s(){if(!t(T)){T=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(T=!0,R=n(e[1]),R.isNightly=!!e[2])}return T}function c(){return s()&&R}function l(){if(!t(A)){A=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,S=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,S=n(e[1])))}return A}function f(){return l()&&S}function d(){if(!t(g)){g=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,N=n(e[1]))}return g}function h(){return t(O)||(O=/Windows/i.test(navigator.appVersion)),O}function E(){return d()&&N}function m(){return t(I)||(I=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),I}var p,y,_,v,T,R,A,S,g,N,O,I,M={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:d,firefoxVersion:E,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return M.supportsFullscreen=function(){return r.supportsFullscreen()},M.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},M.supportsWebWorkers=function(){return"undefined"!=typeof Worker},M}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,a,i){"use strict";if(!a.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return r(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,r,a,i){switch(a=t(a,0),i=t(i,(r.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(r,a,i);case o.UNSIGNED_BYTE:return new Uint8Array(r,a,i);case o.SHORT:return new Int16Array(r,a,i);case o.UNSIGNED_SHORT:return new Uint16Array(r,a,i);case o.FLOAT:return new Float32Array(r,a,i);case o.DOUBLE:return new Float64Array(r,a,i);default:throw new n("componentDatatype is not a valid value.")}},i(o)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var n=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*a.signNotZero(r),t.y=(1-Math.abs(r))*a.signNotZero(n)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=a.fromSNorm(e),n.y=a.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*a.signNotZero(i),n.y=(1-Math.abs(i))*a.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),a=256*(r-n);return i.octDecode(n,a,t)},i.octPack=function(e,t,r,n){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,o);return n.x=65536*s.x+a,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(o,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,r=1===e.y?4095:4096*e.y|0;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a=new t,i=new t,o=new t,u=function(n,u,s,c,l){r(l)||(l=new t);var f,d,h,E,m,p,y,_;r(u.z)?(f=t.subtract(s,u,a),d=t.subtract(c,u,i),h=t.subtract(n,u,o),E=t.dot(f,f),m=t.dot(f,d),p=t.dot(f,h),y=t.dot(d,d),_=t.dot(d,h)):(f=e.subtract(s,u,a),d=e.subtract(c,u,i),h=e.subtract(n,u,o),E=e.dot(f,f),m=e.dot(f,d),p=e.dot(f,h),y=e.dot(d,d),_=e.dot(d,h));var v=1/(E*y-m*m);return l.y=(y*p-m*_)*v,l.z=(E*_-m*p)*v,l.x=1-l.y-l.z,l};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var a={high:0,low:0};n.fromCartesian=function(e,r){t(r)||(r=new n);var i=r.high,o=r.low;return n.encode(e.x,a),i.x=a.high,o.x=a.low,n.encode(e.y,a),i.y=a.high,o.y=a.low,n.encode(e.z,a),i.z=a.high,o.z=a.low,r};var i=new n;return n.writeElements=function(e,t,r){n.fromCartesian(e,i);var a=i.high,o=i.low;t[r]=a.x,t[r+1]=a.y,t[r+2]=a.z,t[r+3]=o.x,t[r+4]=o.y,t[r+5]=o.z},n}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,r,n){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,n):new Uint16Array(t,r,n)},n(i)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*a,f=r(c,-l,t.EPSILON14);if(0>f)return[];var d=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[d/e,a/d]:[a/d,d/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,d=u*u,h=s*s,E=o*s-d,m=o*c-u*s,p=u*c-h,y=4*E*p-m*m;if(0>y){var _,v,T;d*f>=l*h?(_=o,v=E,T=-2*u*E+o*m):(_=c,v=p,T=-c*m+2*s*p);var R=0>T?-1:1,A=-R*Math.abs(_)*Math.sqrt(-y);i=-T+A;var S=i/2,g=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),N=i===A?-g:-v/g;return a=0>=v?g+N:-T/(g*g+N*N+v),d*f>=l*h?[(a-u)/o]:[-c/(a+s)]}var O=E,I=-2*u*E+o*m,M=p,w=-c*m+2*s*p,x=Math.sqrt(y),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*x,-I)/3);a=2*Math.sqrt(-O);var D=Math.cos(P);i=a*D;var L=a*(-D/2-C*Math.sin(P)),U=i+L>2*u?i-u:L-u,b=o,F=U/b;P=Math.abs(Math.atan2(c*x,-w)/3),a=2*Math.sqrt(-M),D=Math.cos(P),i=a*D,L=a*(-D/2-C*Math.sin(P));var z=-c,B=2*s>i+L?i+s:L+s,G=z/B,q=b*B,W=-U*B-b*z,H=U*z,X=(s*W-u*H)/(-u*W+s*q);return X>=F?G>=F?G>=X?[F,X,G]:[F,G,X]:[G,F,X]:G>=F?[X,F,G]:G>=X?[X,G,F]:[G,X,F]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r,u=n*n,s=18*e*t*r*n+i*o-27*a*u-4*(e*o*r+i*t*n);return s},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var d=-t/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var E=n.computeRealRoots(1,s,l);if(2===E.length){var m,p=E[0],y=E[1];if(p>=0&&y>=0){var _=Math.sqrt(p),v=Math.sqrt(y);return[d-v,d-_,d+_,d+v]}if(p>=0&&0>y)return m=Math.sqrt(p),[d-m,d+m];if(0>p&&y>=0)return m=Math.sqrt(y),[d-m,d+m]}return[]}if(h>0){var T=Math.sqrt(h),R=(s+h-c/T)/2,A=(s+h+c/T)/2,S=n.computeRealRoots(1,T,R),g=n.computeRealRoots(1,-T,A);return 0!==S.length?(S[0]+=d,S[1]+=d,0!==g.length?(g[0]+=d,g[1]+=d,S[1]<=g[0]?[S[0],S[1],g[0],g[1]]:g[1]<=S[0]?[g[0],g[1],S[0],S[1]]:S[0]>=g[0]&&S[1]<=g[1]?[g[0],S[0],S[1],g[1]]:g[0]>=S[0]&&g[1]<=S[1]?[S[0],g[0],g[1],S[1]]:S[0]>g[0]&&S[0]<g[1]?[g[0],S[0],g[1],S[1]]:[S[0],g[0],S[1],g[1]]):S):0!==g.length?(g[0]+=d,g[1]+=d,g):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,d=c*o-i*a*t+u,h=e.computeRealRoots(1,l,f,d);if(h.length>0){var E,m,p=h[0],y=a-p,_=y*y,v=t/2,T=y/2,R=_-4*o,A=_+4*Math.abs(o),S=c-4*p,g=c+4*Math.abs(p);if(0>p||S*A>R*g){var N=Math.sqrt(S);E=N/2,m=0===N?0:(t*T-i)/N}else{var O=Math.sqrt(R);E=0===O?0:(t*T-i)/O,m=O/2}var I,M;0===v&&0===E?(I=0,M=0):r.sign(v)===r.sign(E)?(I=v+E,M=p/I):(M=v-E,I=p/M);var w,x;0===T&&0===m?(w=0,x=0):r.sign(T)===r.sign(m)?(w=T+m,x=o/w):(x=T-m,w=o/x);var C=n.computeRealRoots(1,I,w),P=n.computeRealRoots(1,M,x);if(0!==C.length)return 0!==P.length?C[1]<=P[0]?[C[0],C[1],P[0],P[1]]:P[1]<=C[0]?[P[0],P[1],C[0],C[1]]:C[0]>=P[0]&&C[1]<=P[1]?[P[0],C[0],C[1],P[1]]:P[0]>=C[0]&&P[1]<=C[1]?[C[0],P[0],P[1],C[1]]:C[0]>P[0]&&C[0]<P[1]?[P[0],C[0],P[1],C[1]]:[C[0],P[0],C[1],P[1]]:C;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,f=n*n,d=f*n,h=a*a,E=h*a,m=u*c*f-4*s*d-4*e*l*f+18*e*t*r*d-27*i*f*f+256*o*E+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*f+144*i*r*f)+h*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return m},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,f=u/t,d=s/t,h=0>c?1:0;switch(h+=0>l?h+1:h,h+=0>f?h+1:h,h+=0>d?h+1:h){case 0:return a(c,l,f,d);case 1:return i(c,l,f,d);case 2:return i(c,l,f,d);case 3:return a(c,l,f,d);case 4:return a(c,l,f,d);case 5:return i(c,l,f,d);case 6:return a(c,l,f,d);case 7:return a(c,l,f,d);case 8:return i(c,l,f,d);case 9:return a(c,l,f,d);case 10:return a(c,l,f,d);case 11:return i(c,l,f,d);case 12:return a(c,l,f,d);case 13:return a(c,l,f,d);case 14:return a(c,l,f,d);case 15:return a(c,l,f,d);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return a.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(t,n,a,o,u){u=r(u,!1);var s,c,l,f,d,h=t.origin,E=t.direction,m=e.subtract(a,n,p),R=e.subtract(o,n,y),A=e.cross(E,R,_),S=e.dot(m,A);if(u){if(S<i.EPSILON6)return void 0;if(s=e.subtract(h,n,v),l=e.dot(s,A),0>l||l>S)return void 0;if(c=e.cross(s,m,T),f=e.dot(E,c),0>f||l+f>S)return void 0;d=e.dot(R,c)/S}else{if(Math.abs(S)<i.EPSILON6)return void 0;var g=1/S;if(s=e.subtract(h,n,v),l=e.dot(s,A)*g,0>l||l>1)return void 0;if(c=e.cross(s,m,T),f=e.dot(E,c)*g,0>f||l+f>1)return void 0;d=e.dot(R,c)*g}return d}function f(e,t,r,n){var a=t*t-4*e*r;if(0>a)return void 0;if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function d(t,r,a){n(a)||(a={});var i=t.origin,o=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,_),l=e.dot(o,o),d=2*e.dot(o,c),h=e.magnitudeSquared(c)-s,E=f(l,d,h,A);return n(E)?(a.start=E.root0,a.stop=E.root1,a):void 0}function h(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function E(t,r,n,a,c){var l,f=a*a,d=c*c,E=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*d,m=c*(a*h(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+r.y),p=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*d+a*r.x+n,y=d*h(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),_=c*(a*h(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+r.z),v=[];if(0===_&&0===y){if(l=u.computeRealRoots(E,m,p),0===l.length)return v;var T=l[0],R=Math.sqrt(Math.max(1-T*T,0));if(v.push(new e(a,c*T,c*-R)),v.push(new e(a,c*T,c*R)),2===l.length){var A=l[1],S=Math.sqrt(Math.max(1-A*A,0));v.push(new e(a,c*A,c*-S)),v.push(new e(a,c*A,c*S))}return v}var g=_*_,N=y*y,O=E*E,I=_*y,M=O+N,w=2*(m*E+I),x=2*p*E+m*m-N+g,C=2*(p*m-I),P=p*p-g;if(0===M&&0===w&&0===x&&0===C)return v;l=s.computeRealRoots(M,w,x,C,P);var D=l.length;if(0===D)return v;for(var L=0;D>L;++L){var U,b=l[L],F=b*b,z=Math.max(1-F,0),B=Math.sqrt(z);U=i.sign(E)===i.sign(p)?h(E*F+p,m*b,i.EPSILON12):i.sign(p)===i.sign(m*b)?h(E*F,m*b+p,i.EPSILON12):h(E*F+m*b,p,i.EPSILON12);var G=h(y*b,_,i.EPSILON15),q=U*G;0>q?v.push(new e(a,c*b,c*B)):q>0?v.push(new e(a,c*b,c*-B)):0!==B?(v.push(new e(a,c*b,c*-B)),v.push(new e(a,c*b,c*B)),++L):v.push(new e(a,c*b,c*B))}return v}var m={};m.rayPlane=function(t,r,a){n(a)||(a=new e);var o=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-r.distance-e.dot(s,o))/c;return 0>l?void 0:(a=e.multiplyByScalar(u,l,a),e.add(o,a,a))};var p=new e,y=new e,_=new e,v=new e,T=new e;m.rayTriangle=function(t,r,a,i,o,u){var s=l(t,r,a,i,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var R=new c;m.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=R;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var A={root0:0,root1:0};m.raySphere=function(e,t,r){return r=d(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var S=new c;m.lineSegmentSphere=function(t,r,a,i){var o=S,u=(e.clone(t,o.origin),e.subtract(r,t,o.direction)),s=e.magnitude(u);return e.normalize(u,u),i=d(o,a,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var g=new e,N=new e;m.rayEllipsoid=function(t,r){var n,a,i,o,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,g),l=e.multiplyComponents(s,t.direction,N),f=e.magnitudeSquared(c),d=e.dot(c,l);if(f>1){if(d>=0)return void 0;var h=d*d;if(n=f-1,a=e.magnitudeSquared(l),i=a*n,i>h)return void 0;if(h>i){o=d*d-i,u=-d+Math.sqrt(o);var E=u/a,m=n/u;return m>E?{start:E,stop:m}:{start:m,stop:E}}var p=Math.sqrt(n/a);return{start:p,stop:p}}return 1>f?(n=f-1,a=e.magnitudeSquared(l),i=a*n,o=d*d-i,u=-d+Math.sqrt(o),{start:0,stop:u/a}):0>d?(a=e.magnitudeSquared(l),{start:0,stop:-d/a}):void 0};var O=new e,I=new e,M=new e,w=new e,x=new e,C=new o,P=new o,D=new o,L=new o,U=new o,b=new o,F=new o,z=new e,B=new e,G=new t;m.grazingAltitudeLocation=function(t,r){var a=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(a,O);if(e.dot(u,s)>=0)return a;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,O),f=e.normalize(l,l),d=e.mostOrthogonalAxis(l,w),h=e.normalize(e.cross(d,f,I),I),m=e.normalize(e.cross(f,h,M),M),p=C;p[0]=f.x,p[1]=f.y,p[2]=f.z,p[3]=h.x,p[4]=h.y,p[5]=h.z,p[6]=m.x,p[7]=m.y,p[8]=m.z;var y=o.transpose(p,P),_=o.fromScale(r.radii,D),v=o.fromScale(r.oneOverRadii,L),T=U;T[0]=0,T[1]=-u.z,T[2]=u.y,T[3]=u.z,T[4]=0,T[5]=-u.x,T[6]=-u.y,T[7]=u.x,T[8]=0;var R,A,S=o.multiply(o.multiply(y,v,b),T,b),g=o.multiply(o.multiply(S,_,F),p,F),N=o.multiplyByVector(S,a,x),q=E(g,e.negate(N,O),0,0,1),W=q.length;if(W>0){for(var H=e.clone(e.ZERO,B),X=Number.NEGATIVE_INFINITY,V=0;W>V;++V){R=o.multiplyByVector(_,o.multiplyByVector(p,q[V],z),z);var Y=e.normalize(e.subtract(R,a,w),w),k=e.dot(Y,u);k>X&&(X=k,H=e.clone(R,H))}var j=r.cartesianToCartographic(H,G);return X=i.clamp(X,0,1),A=e.magnitude(e.subtract(H,a,w))*Math.sqrt(1-X*X),A=c?-A:A,j.height=A,r.cartographicToCartesian(j,new e)}return void 0};var q=new e;return m.lineSegmentPlane=function(t,r,a,o){n(o)||(o=new e);var u=e.subtract(r,t,q),s=a.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),f=-(a.distance+l)/c;return 0>f||f>1?void 0:(e.multiplyByScalar(u,f,o),e.add(t,o,o),o)},m.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,d;if((1===l||2===l)&&(f=new e,d=new e),1===l){if(u)return m.lineSegmentPlane(t,r,a,f),m.lineSegmentPlane(t,n,a,d),{positions:[t,r,n,f,d],indices:[0,3,4,1,2,4,1,4,3]};if(s)return m.lineSegmentPlane(r,n,a,f),m.lineSegmentPlane(r,t,a,d),{positions:[t,r,n,f,d],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(n,t,a,f),m.lineSegmentPlane(n,r,a,d),{positions:[t,r,n,f,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return m.lineSegmentPlane(r,t,a,f),m.lineSegmentPlane(n,t,a,d),{positions:[t,r,n,f,d],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return m.lineSegmentPlane(n,r,a,f),m.lineSegmentPlane(t,r,a,d),{positions:[t,r,n,f,d],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(t,n,a,f),m.lineSegmentPlane(r,n,a,d),{positions:[t,r,n,f,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,a=r.maximumIndex,i=e(r.cacheSize,24),o=n.length;if(!t(a)){a=0;for(var u=0,s=n[u];o>u;)s>a&&(a=s),++u,s=n[u]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var f=i+1,d=0;o>d;++d)f-c[n[d]]>i&&(c[n[d]]=f,++f);return(f-i+1)/(o/3)},n.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,r,a,i,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var d=r[f];a[d].numLiveTriangles&&(s=0,i-a[d].timeStamp+2*a[d].numLiveTriangles<=t&&(s=i-a[d].timeStamp),(s>l||-1===l)&&(l=s,c=d)),++f}return-1===c?n(a,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,f=0,d=o[f],h=c;if(t(u))l=u+1;else{for(;h>f;)d>l&&(l=d),++f,d=o[f];if(-1===l)return 0;++l}for(var E=[],m=0;l>m;m++)E[m]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var p=0;h>f;)E[o[f]].vertexTriangles.push(p),++E[o[f]].numLiveTriangles,E[o[f+1]].vertexTriangles.push(p),++E[o[f+1]].numLiveTriangles,E[o[f+2]].vertexTriangles.push(p),++E[o[f+2]].numLiveTriangles,++p,f+=3;var y=0,_=s+1;i=1;var v,T,R=[],A=[],S=0,g=[],N=c/3,O=[];for(m=0;N>m;m++)O[m]=!1;for(var I,M;-1!==y;){R=[],T=E[y],M=T.vertexTriangles.length;for(var w=0;M>w;++w)if(p=T.vertexTriangles[w],!O[p]){O[p]=!0,f=p+p+p;for(var x=0;3>x;++x)I=o[f],R.push(I),A.push(I),g[S]=I,++S,v=E[I],--v.numLiveTriangles,_-v.timeStamp>s&&(v.timeStamp=_,++_),++f}y=a(o,s,R,E,_,A,l)}return g},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,E,m,p,y,_,v,T,R,A,S,g,N){"use strict";function O(e,t,r,n,a){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=a,e[t++]=a,e[t]=r}function I(e){for(var t=e.length,r=t/3*6,n=y.createTypedArray(t,r),a=0,i=0;t>i;i+=3,a+=6)O(n,a,e[i],e[i+1],e[i+2]);return n}function M(e){var t=e.length;if(t>=3){var r=6*(t-2),n=y.createTypedArray(t,r);O(n,0,e[0],e[1],e[2]);for(var a=6,i=3;t>i;++i,a+=6)O(n,a,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function w(e){
if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=y.createTypedArray(t,r),a=e[0],i=0,o=1;t>o;++o,i+=6)O(n,i,a,e[o],e[o+1]);return n}return new Uint16Array}function x(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new E({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function C(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var a=t[n],i=0;i<a.componentsPerAttribute;++i)e[n].values.push(a.values[r*a.componentsPerAttribute+i])}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,ie),A.multiplyByPoint(e,ie,ie),a.pack(ie,r,i)}function D(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,ie),R.multiplyByVector(e,ie,ie),ie=a.normalize(ie,ie),a.pack(ie,r,i)}function L(e,t){var r,n=e.length,a={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var o=i[r],s=o.values.length,l=!0,f=1;n>f;++f){var d=e[f][t].attributes[r];if(!c(d)||o.componentDatatype!==d.componentDatatype||o.componentsPerAttribute!==d.componentsPerAttribute||o.normalize!==d.normalize){l=!1;break}s+=d.values.length}l&&(a[r]=new E({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function U(e,t){var n,i,o,u,s,l,f,d=e.length,E=(e[0].modelMatrix,c(e[0][t].indices)),m=e[0][t].primitiveType,p=L(e,t);for(n in p)if(p.hasOwnProperty(n))for(s=p[n].values,u=0,i=0;d>i;++i)for(l=e[i][t].attributes[n].values,f=l.length,o=0;f>o;++o)s[u++]=l[o];var _;if(E){var v=0;for(i=0;d>i;++i)v+=e[i][t].indices.length;var T=h.computeNumberOfVertices(new h({attributes:p,primitiveType:g.POINTS})),R=y.createTypedArray(T,v),A=0,S=0;for(i=0;d>i;++i){var N=e[i][t].indices,O=N.length;for(u=0;O>u;++u)R[A++]=S+N[u];S+=h.computeNumberOfVertices(e[i][t])}_=R}var I,M=new a,w=0;for(i=0;d>i;++i){if(I=e[i][t].boundingSphere,!c(I)){M=void 0;break}a.add(I.center,M,M)}if(c(M))for(a.divideByScalar(M,d,M),i=0;d>i;++i){I=e[i][t].boundingSphere;var x=a.magnitude(a.subtract(I.center,M,se))+I.radius;x>w&&(w=x)}return new h({attributes:p,indices:_,primitiveType:m,boundingSphere:c(M)?new r(M,w):void 0})}function b(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function F(e){var t=h.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,a=3;t>a;++a)r[n++]=a-1,r[n++]=0,r[n++]=a;return e.indices=r,e.primitiveType=g.TRIANGLES,e}function z(e){var t=h.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,a=3;t-1>a;a+=2)r[n++]=a,r[n++]=a-1,r[n++]=a+1,t>a+2&&(r[n++]=a,r[n++]=a+1,r[n++]=a+2);return e.indices=r,e.primitiveType=g.TRIANGLES,e}function B(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function G(e){var t=h.computeNumberOfVertices(e),r=y.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return e.indices=r,e.primitiveType=g.LINES,e}function q(e){var t=h.computeNumberOfVertices(e),r=y.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=g.LINES,e}function W(e){switch(e.primitiveType){case g.TRIANGLE_FAN:return F(e);case g.TRIANGLE_STRIP:return z(e);case g.TRIANGLES:return b(e);case g.LINE_STRIP:return G(e);case g.LINE_LOOP:return q(e);case g.LINES:return B(e)}return e}function H(e,t){Math.abs(e.y)<T.EPSILON6&&(t?e.y=-T.EPSILON6:e.y=T.EPSILON6)}function X(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return H(e,e.y<0),H(t,t.y<0),void H(r,r.y<0);var n,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y);n=a>i?a>o?T.sign(e.y):T.sign(r.y):i>o?T.sign(t.y):T.sign(r.y);var u=0>n;H(e,u),H(t,u),H(r,u)}function V(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,Te),e.y/(e.y-t.y),Te),r),a.clone(r,n),H(r,!0),H(n,!1)}function Y(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;X(e,t,r);var n=e.y<0,a=t.y<0,i=r.y<0,o=0;o+=n?1:0,o+=a?1:0,o+=i?1:0;var u=Ne.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(V(e,t,Re,Se),V(e,r,Ae,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(V(t,r,Re,Se),V(t,e,Ae,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(V(r,e,Re,Se),V(r,t,Ae,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?a?i||(V(r,e,Re,Se),V(r,t,Ae,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(V(t,r,Re,Se),V(t,e,Ae,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(V(e,t,Re,Se),V(e,r,Ae,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ne.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Re,s[4]=Ae,s[5]=Se,s[6]=ge,s.length=7),Ne}function k(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var a in n)if(n.hasOwnProperty(a)&&c(n[a])&&c(n[a].values)){var i=n[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=h.computeNumberOfVertices(e);return e.indices=y.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function j(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var a=t[n];r[n]=new E({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var n=c(e.geometry.boundingSphere);t=k(t,n),r=k(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function K(e,r,i,o,u,s,l,f,d,h,E){if(c(s)||c(l)||c(f)||c(d)){var m=a.fromArray(u,3*e,Oe),p=a.fromArray(u,3*r,Ie),y=a.fromArray(u,3*i,Me),_=t(o,m,p,y,we);if(c(s)){var v=a.fromArray(s,3*e,Oe),T=a.fromArray(s,3*r,Ie),R=a.fromArray(s,3*i,Me);a.multiplyByScalar(v,_.x,v),a.multiplyByScalar(T,_.y,T),a.multiplyByScalar(R,_.z,R);var A=a.add(v,T,v);a.add(A,R,A),a.normalize(A,A),a.pack(A,h.normal.values,3*E)}if(c(l)){var S=a.fromArray(l,3*e,Oe),g=a.fromArray(l,3*r,Ie),N=a.fromArray(l,3*i,Me);a.multiplyByScalar(S,_.x,S),a.multiplyByScalar(g,_.y,g),a.multiplyByScalar(N,_.z,N);var O=a.add(S,g,S);a.add(O,N,O),a.normalize(O,O),a.pack(O,h.binormal.values,3*E)}if(c(f)){var I=a.fromArray(f,3*e,Oe),M=a.fromArray(f,3*r,Ie),w=a.fromArray(f,3*i,Me);a.multiplyByScalar(I,_.x,I),a.multiplyByScalar(M,_.y,M),a.multiplyByScalar(w,_.z,w);var x=a.add(I,M,I);a.add(x,w,x),a.normalize(x,x),a.pack(x,h.tangent.values,3*E)}if(c(d)){var C=n.fromArray(d,2*e,xe),P=n.fromArray(d,2*r,Ce),D=n.fromArray(d,2*i,Pe);n.multiplyByScalar(C,_.x,C),n.multiplyByScalar(P,_.y,P),n.multiplyByScalar(D,_.z,D);var L=n.add(C,P,C);n.add(L,D,L),n.pack(L,h.st.values,2*E)}}}function J(e,t,r,n,a,i){var o=e.position.values.length/3;if(-1!==a){var u=n[a],s=r[u];return-1===s?(r[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function Q(e){var t,r,n,i,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,d=c(s.binormal)?s.binormal.values:void 0,h=c(s.tangent)?s.tangent.values:void 0,E=c(s.st)?s.st.values:void 0,m=u.indices,p=j(u),y=j(u),_=[];_.length=l.length/3;var v=[];for(v.length=l.length/3,o=0;o<_.length;++o)_[o]=-1,v[o]=-1;var T=m.length;for(o=0;T>o;o+=3){var R=m[o],A=m[o+1],S=m[o+2],g=a.fromArray(l,3*R),N=a.fromArray(l,3*A),O=a.fromArray(l,3*S),I=Y(g,N,O);if(c(I)&&I.positions.length>3)for(var M=I.positions,w=I.indices,x=w.length,C=0;x>C;++C){var P=w[C],D=M[P];D.y<0?(t=y.attributes,r=y.indices,n=_):(t=p.attributes,r=p.indices,n=v),i=J(t,r,n,m,3>P?o+P:-1,D),K(R,A,S,D,l,f,d,h,E,t,i)}else c(I)&&(g=I.positions[0],N=I.positions[1],O=I.positions[2]),g.y<0?(t=y.attributes,r=y.indices,n=_):(t=p.attributes,r=p.indices,n=v),i=J(t,r,n,m,o,g),K(R,A,S,g,l,f,d,h,E,t,i),i=J(t,r,n,m,o+1,N),K(R,A,S,N,l,f,d,h,E,t,i),i=J(t,r,n,m,o+2,O),K(R,A,S,O,l,f,d,h,E,t,i)}Z(e,y,p)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,o=r.indices,u=j(r),s=j(r),l=o.length,f=[];f.length=i.length/3;var d=[];for(d.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,d[t]=-1;for(t=0;l>t;t+=2){var h=o[t],E=o[t+1],m=a.fromArray(i,3*h,Oe),p=a.fromArray(i,3*E,Ie);Math.abs(m.y)<T.EPSILON6&&(m.y<0?m.y=-T.EPSILON6:m.y=T.EPSILON6),Math.abs(p.y)<T.EPSILON6&&(p.y<0?p.y=-T.EPSILON6:p.y=T.EPSILON6);var y=u.attributes,_=u.indices,R=d,A=s.attributes,S=s.indices,g=f,N=v.lineSegmentPlane(m,p,De,Me);if(c(N)){var O=a.multiplyByScalar(a.UNIT_Y,5*T.EPSILON9,Le);m.y<0&&(a.negate(O,O),y=s.attributes,_=s.indices,R=f,A=u.attributes,S=u.indices,g=d);var I=a.add(N,O,Ue);J(y,_,R,o,t,m),J(y,_,R,o,-1,I),a.negate(O,O),a.add(N,O,I),J(A,S,g,o,-1,I),J(A,S,g,o,t+1,p)}else{var M,w,x;m.y<0?(M=s.attributes,w=s.indices,x=f):(M=u.attributes,w=u.indices,x=d),J(M,w,x,o,t,m),J(M,w,x,o,t+1,p)}}Z(e,s,u)}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,d=s.nextPosition.values,h=s.expandAndWidth.values,E=(u.indices,c(s.st)?s.st.values:void 0),m=c(s.color)?s.color.values:void 0,p=j(u),y=j(u),_=l.length/3;for(t=0;_>t;t+=4){var R=t,A=t+1,S=t+2,g=t+3,N=a.fromArray(l,3*R,ze),O=a.fromArray(l,3*A,Be),I=a.fromArray(l,3*S,Ge),M=a.fromArray(l,3*g,qe);Math.abs(N.y)<T.EPSILON6&&(N.y=T.EPSILON6*(I.y<0?-1:1),O.y=N.y),Math.abs(I.y)<T.EPSILON6&&(I.y=T.EPSILON6*(N.y<0?-1:1),M.y=I.y);var w=p.attributes,x=p.indices,C=y.attributes,P=y.indices,D=v.lineSegmentPlane(N,I,De,We);if(c(D)){var L=a.multiplyByScalar(a.UNIT_Y,5*T.EPSILON9,He);N.y<0&&(a.negate(L,L),w=y.attributes,x=y.indices,C=p.attributes,P=p.indices);var U=a.add(D,L,Xe);for(w.position.values.push(N.x,N.y,N.z,O.x,O.y,O.z),w.position.values.push(U.x,U.y,U.z),w.position.values.push(U.x,U.y,U.z),a.negate(L,L),a.add(D,L,U),C.position.values.push(U.x,U.y,U.z),C.position.values.push(U.x,U.y,U.z),C.position.values.push(I.x,I.y,I.z,M.x,M.y,M.z),r=3*R;3*R+6>r;++r)w.prevPosition.values.push(f[r]);for(w.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),C.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),r=3*S;3*S+6>r;++r)C.prevPosition.values.push(f[r]);for(r=3*R;3*R+6>r;++r)w.nextPosition.values.push(d[r]);for(w.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),C.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),r=3*S;3*S+6>r;++r)C.nextPosition.values.push(d[r]);var b=n.fromArray(h,2*R,be),F=Math.abs(b.y);w.expandAndWidth.values.push(-1,F,1,F),w.expandAndWidth.values.push(-1,-F,1,-F),C.expandAndWidth.values.push(-1,F,1,F),C.expandAndWidth.values.push(-1,-F,1,-F);var z=a.magnitudeSquared(a.subtract(D,N,qe));if(z/=a.magnitudeSquared(a.subtract(I,N,qe)),c(m)){var B=i.fromArray(m,4*R,Ve),G=i.fromArray(m,4*S,Ve),q=T.lerp(B.x,G.x,z),W=T.lerp(B.y,G.y,z),H=T.lerp(B.z,G.z,z),X=T.lerp(B.w,G.w,z);for(r=4*R;4*R+8>r;++r)w.color.values.push(m[r]);for(w.color.values.push(q,W,H,X),w.color.values.push(q,W,H,X),C.color.values.push(q,W,H,X),C.color.values.push(q,W,H,X),r=4*S;4*S+8>r;++r)C.color.values.push(m[r])}if(c(E)){var V=n.fromArray(E,2*R,be),Y=n.fromArray(E,2*(t+3),Fe),k=T.lerp(V.x,Y.x,z);for(r=2*R;2*R+4>r;++r)w.st.values.push(E[r]);for(w.st.values.push(k,V.y),w.st.values.push(k,Y.y),C.st.values.push(k,V.y),C.st.values.push(k,Y.y),r=2*S;2*S+4>r;++r)C.st.values.push(E[r])}o=w.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3),o=C.position.values.length/3-4,P.push(o,o+2,o+1),P.push(o+1,o+2,o+3)}else{var K,J;for(N.y<0?(K=y.attributes,J=y.indices):(K=p.attributes,J=p.indices),K.position.values.push(N.x,N.y,N.z),K.position.values.push(O.x,O.y,O.z),K.position.values.push(I.x,I.y,I.z),K.position.values.push(M.x,M.y,M.z),r=3*t;3*t+12>r;++r)K.prevPosition.values.push(f[r]),K.nextPosition.values.push(d[r]);for(r=2*t;2*t+8>r;++r)K.expandAndWidth.values.push(h[r]),c(E)&&K.st.values.push(E[r]);if(c(m))for(r=4*t;4*t+16>r;++r)K.color.values.push(m[r]);o=K.position.values.length/3-4,J.push(o,o+2,o+1),J.push(o+1,o+2,o+3)}}Z(e,y,p)}var te={};te.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case g.TRIANGLES:e.indices=I(t);break;case g.TRIANGLE_STRIP:e.indices=M(t);break;case g.TRIANGLE_FAN:e.indices=w(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=g.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),f=0,d=0;o>d;d+=3)l[f++]=a[d],l[f++]=a[d+1],l[f++]=a[d+2],l[f++]=a[d]+i[d]*n,l[f++]=a[d+1]+i[d+1]*n,l[f++]=a[d+2]+i[d+2]*n;var m,p=e.boundingSphere;return c(p)&&(m=new r(p.center,p.radius+n)),new h({attributes:{position:new E({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:g.LINES,boundingSphere:m})},te.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,a={},i=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(a[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},te.reorderForPreVertexCache=function(e){var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),a=0;t>a;a++)n[a]=-1;for(var i,o=r,s=o.length,l=y.createTypedArray(t,s),f=0,d=0,E=0;s>f;)i=n[o[f]],-1!==i?l[d]=i:(i=o[f],n[i]=E,l[d]=E,++E),++f,++d;e.indices=l;var m=e.attributes;for(var p in m)if(m.hasOwnProperty(p)&&c(m[p])&&c(m[p].values)){for(var _=m[p],v=_.values,T=0,R=_.componentsPerAttribute,A=u.createTypedArray(_.componentDatatype,E*R);t>T;){var S=n[T];if(-1!==S)for(a=0;R>a;a++)A[R*S+a]=v[R*T+a];++T}_.values=A}}return e},te.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===g.TRIANGLES&&c(r)){for(var n=r.length,a=0,i=0;n>i;i++)r[i]>a&&(a=r[i]);e.indices=N.tipsify({indices:r,maximumIndex:a,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>=T.SIXTY_FOUR_KILOBYTES){var n,a=[],i=[],o=0,u=x(e.attributes),s=e.indices,l=s.length;e.primitiveType===g.TRIANGLES?n=3:e.primitiveType===g.LINES?n=2:e.primitiveType===g.POINTS&&(n=1);for(var f=0;l>f;f+=n){for(var d=0;n>d;++d){var E=s[f+d],m=a[E];c(m)||(m=o++,a[E]=m,C(u,e.attributes,E)),i.push(m)}o+n>=T.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=x(e.attributes))}0!==i.length&&t.push(new h({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new a,ne=new o;te.projectTo2D=function(e,t,r,n,i){var o=e.attributes[t];i=c(i)?i:new d;for(var s=i.ellipsoid,f=o.values,h=new Float64Array(f.length),m=0,p=0;p<f.length;p+=3){var y=a.fromArray(f,p,re),_=s.cartesianToCartographic(y,ne);if(!c(_))throw new l("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var v=i.project(_,re);h[m++]=v.x,h[m++]=v.y,h[m++]=v.z}return e.attributes[r]=o,e.attributes[n]=new E({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var ae={high:0,low:0};te.encodeAttribute=function(e,t,r,n){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)f.encode(i[l],ae),s[l]=ae.high,c[l]=ae.low;var d=a.componentsPerAttribute;return e.attributes[r]=new E({componentDatatype:u.FLOAT,componentsPerAttribute:d,values:s}),e.attributes[n]=new E({componentDatatype:u.FLOAT,componentsPerAttribute:d,values:c}),delete e.attributes[t],e};var ie=new a,oe=new A,ue=new R;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(A.equals(t,A.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(A.inverse(t,oe),A.transpose(oe,oe),A.getRotation(oe,ue),D(ue,n.normal),D(ue,n.binormal),D(ue,n.tangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=r.transform(a,t,a)),e.modelMatrix=A.clone(A.IDENTITY),e};var se=new a;te.combineInstances=function(e){for(var t=[],r=[],n=e.length,a=0;n>a;++a){var i=e[a];c(i.geometry)?t.push(i):r.push(i)}var o=[];return t.length>0&&o.push(U(t,"geometry")),r.length>0&&(o.push(U(r,"westHemisphereGeometry")),o.push(U(r,"eastHemisphereGeometry"))),o};var ce=new a,le=new a,fe=new a,de=new a;te.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),f=0;i>f;f++)s[f]={indexOffset:0,count:0,currentCount:0};var d=0;for(f=0;o>f;f+=3){var h=t[f],m=t[f+1],p=t[f+2],y=3*h,_=3*m,v=3*p;le.x=n[y],le.y=n[y+1],le.z=n[y+2],fe.x=n[_],fe.y=n[_+1],fe.z=n[_+2],de.x=n[v],de.y=n[v+1],de.z=n[v+2],s[h].count++,s[m].count++,s[p].count++,a.subtract(fe,le,fe),a.subtract(de,le,de),c[d]=a.cross(fe,de,new a),d++}var T=0;for(f=0;i>f;f++)s[f].indexOffset+=T,T+=s[f].count;d=0;var R;for(f=0;o>f;f+=3){R=s[t[f]];var A=R.indexOffset+R.currentCount;l[A]=d,R.currentCount++,R=s[t[f+1]],A=R.indexOffset+R.currentCount,l[A]=d,R.currentCount++,R=s[t[f+2]],A=R.indexOffset+R.currentCount,l[A]=d,R.currentCount++,d++}var S=new Float32Array(3*i);for(f=0;i>f;f++){var g=3*f;if(R=s[f],R.count>0){for(a.clone(a.ZERO,ce),d=0;d<R.count;d++)a.add(ce,c[l[R.indexOffset+d]],ce);a.normalize(ce,ce),S[g]=ce.x,S[g+1]=ce.y,S[g+2]=ce.z}else S[g]=0,S[g+1]=0,S[g+2]=1}return e.attributes.normal=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var he=new a,Ee=new a,me=new a;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var f,d,h;for(l=0;s>l;l+=3){var m=t[l],p=t[l+1],y=t[l+2];f=3*m,d=3*p,h=3*y;var _=2*m,v=2*p,T=2*y,R=r[f],A=r[f+1],S=r[f+2],g=i[_],N=i[_+1],O=i[v+1]-N,I=i[T+1]-N,M=1/((i[v]-g)*I-(i[T]-g)*O),w=(I*(r[d]-R)-O*(r[h]-R))*M,x=(I*(r[d+1]-A)-O*(r[h+1]-A))*M,C=(I*(r[d+2]-S)-O*(r[h+2]-S))*M;c[f]+=w,c[f+1]+=x,c[f+2]+=C,c[d]+=w,c[d+1]+=x,c[d+2]+=C,c[h]+=w,c[h+1]+=x,c[h+2]+=C}var P=new Float32Array(3*o),D=new Float32Array(3*o);for(l=0;o>l;l++){f=3*l,d=f+1,h=f+2;var L=a.fromArray(n,f,he),U=a.fromArray(c,f,me),b=a.dot(L,U);a.multiplyByScalar(L,b,Ee),a.normalize(a.subtract(U,Ee,U),U),D[f]=U.x,D[d]=U.y,D[h]=U.z,a.normalize(a.cross(L,U,U),U),P[f]=U.x,P[d]=U.y,P[h]=U.z}return e.attributes.tangent=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.binormal=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e};var pe=new n,ye=new a,_e=new a,ve=new a;te.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var o,s,l,f,d=t.attributes.tangent,h=t.attributes.binormal;c(r)&&(o=r.values),c(i)&&(s=i.values),c(d)&&(l=d.values),h&&(f=h.values);var m=c(o)?o.length:s.length,p=c(o)?3:2,y=m/p,_=y,v=c(s)&&c(o)?2:1;v+=c(l)||c(f)?1:0,_*=v;for(var T=new Float32Array(_),R=0,A=0;y>A;++A){c(s)&&(n.fromArray(s,2*A,pe),T[R++]=e.compressTextureCoordinates(pe));var S=3*A;c(o)&&c(l)&&c(f)?(a.fromArray(o,S,ye),a.fromArray(l,S,_e),a.fromArray(f,S,ve),e.octPack(ye,_e,ve,pe),T[R++]=pe.x,T[R++]=pe.y):(c(o)&&(a.fromArray(o,S,ye),T[R++]=e.octEncodeFloat(ye)),c(l)&&(a.fromArray(l,S,ye),T[R++]=e.octEncodeFloat(ye)),c(f)&&(a.fromArray(f,S,ye),T[R++]=e.octEncodeFloat(ye)))}return t.attributes.compressedAttributes=new E({componentDatatype:u.FLOAT,componentsPerAttribute:v,values:T}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var Te=new a,Re=new a,Ae=new a,Se=new a,ge=new a,Ne={positions:new Array(7),indices:new Array(9)},Oe=new a,Ie=new a,Me=new a,we=new a,xe=new n,Ce=new n,Pe=new n,De=S.fromPointNormal(a.ZERO,a.UNIT_Y),Le=new a,Ue=new a,be=new n,Fe=new n,ze=new a,Be=new a,Ge=new a,qe=new a,We=new a,He=new a,Xe=new a,Ve=new i;new i;return te.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var a=n.center.x-n.radius;if(a>0||r.intersectPlane(n,S.ORIGIN_ZX_PLANE)!==_.INTERSECTING)return e}if(t.geometryType!==p.NONE)switch(t.geometryType){case p.POLYLINES:ee(e);break;case p.TRIANGLES:Q(e);break;case p.LINES:$(e)}else W(t),t.primitiveType===g.TRIANGLES?Q(e):t.primitiveType===g.LINES&&$(e);return e},te}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n,a){"use strict";var i=function(e,r,n,a){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(r,0),this[3]=t(a,0)};i.packedLength=4,i.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3]},i.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new i),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a},i.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new i(e[0],e[2],e[1],e[3]):void 0},i.fromArray=function(e,n,a){return n=t(n,0),r(a)||(a=new i),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a},i.fromColumnMajorArray=function(e,t){return i.clone(e,t)},i.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new i(e[0],e[1],e[2],e[3])},i.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new i(e.x,0,0,e.y)},i.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new i(e,0,0,e)},i.fromRotation=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=-a,t[3]=n,t):new i(n,-a,a,n)},i.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},i.getElementIndex=function(e,t){return 2*e+t},i.getColumn=function(e,t,r){var n=2*t,a=e[n],i=e[n+1];return r.x=a,r.y=i,r},i.setColumn=function(e,t,r,n){n=i.clone(e,n);var a=2*t;return n[a]=r.x,n[a+1]=r.y,n},i.getRow=function(e,t,r){var n=e[t],a=e[t+2];return r.x=n,r.y=a,r},i.setRow=function(e,t,r,n){return n=i.clone(e,n),n[t]=r.x,n[t+2]=r.y,n};var o=new e;i.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],o)),r.y=e.magnitude(e.fromElements(t[2],t[3],o)),r};var u=new e;return i.getMaximumScale=function(t){return i.getScale(t,u),e.maximumComponent(u)},i.multiply=function(e,t,r){var n=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],i=e[1]*t[0]+e[3]*t[1],o=e[1]*t[2]+e[3]*t[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},i.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r},i.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r},i.multiplyByVector=function(e,t,r){var n=e[0]*t.x+e[2]*t.y,a=e[1]*t.x+e[3]*t.y;return r.x=n,r.y=a,r},i.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r},i.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.y,r[3]=e[3]*t.y,r},i.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},i.transpose=function(e,t){var r=e[0],n=e[2],a=e[1],i=e[3];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t},i.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},i.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},i.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n},i.IDENTITY=a(new i(1,0,0,1)),i.ZERO=a(new i(0,0,0,0)),i.COLUMN0ROW0=0,i.COLUMN0ROW1=1,i.COLUMN1ROW0=2,i.COLUMN1ROW1=3,i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},i}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,t,r,n,a,i,o){"use strict";var u=function(n,a,i){this.minimum=e.clone(t(n,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),r(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i};u.fromPoints=function(t,n){if(r(n)||(n=new u),!r(t)||0===t.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var a=t[0].x,i=t[0].y,o=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,d=1;f>d;d++){var h=t[d],E=h.x,m=h.y,p=h.z;a=Math.min(E,a),s=Math.max(E,s),i=Math.min(m,i),c=Math.max(m,c),o=Math.min(p,o),l=Math.max(p,l)}var y=n.minimum;y.x=a,y.y=i,y.z=o;var _=n.maximum;_.x=s,_.y=c,_.z=l;var v=e.add(y,_,n.center);return e.multiplyByScalar(v,.5,v),n},u.clone=function(t,n){return r(t)?r(n)?(n.minimum=e.clone(t.minimum,n.minimum),n.maximum=e.clone(t.maximum,n.maximum),n.center=e.clone(t.center,n.center),n):new u(t.minimum,t.maximum):void 0},u.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&e.equals(t.minimum,n.minimum)&&e.equals(t.maximum,n.maximum)};var s=new e;return u.intersectPlane=function(t,r){s=e.subtract(t.maximum,t.minimum,s);var n=e.multiplyByScalar(s,.5,s),a=r.normal,o=n.x*Math.abs(a.x)+n.y*Math.abs(a.y)+n.z*Math.abs(a.z),u=e.dot(t.center,a)+r.distance;return u-o>0?i.INSIDE:0>u+o?i.OUTSIDE:i.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,a){return t(e).then(r,n,a)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=a(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function a(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(a){return i(a)}});return r}function o(){function e(e,t,r){return d(e,t,r)}function r(e){return E(e)}function a(e){return E(i(e))}function u(e){return h(e)}var s,c,l,f,d,h,E;return c=new n(e),s={then:e,resolve:r,reject:a,progress:u,promise:c,resolver:{resolve:r,reject:a,progress:u}},l=[],f=[],d=function(e,t,r){var n,a;return n=o(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,a)}),f.push(a),n.promise},h=function(e){return m(f,e),e},E=function(e){return e=t(e),d=e.then,E=t,h=y,m(l,e),f=l=R,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,a,i){return p(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){E(e)}var c,l,f,d,h,E,m,p,_,v;if(_=t.length>>>0,c=Math.max(0,Math.min(r,_)),f=[],l=_-c+1,d=[],h=o(),c)for(p=h.progress,m=function(e){d.push(e),--l||(E=m=y,h.reject(d))},E=function(e){f.push(e),--c||(E=m=y,h.resolve(f))},v=0;_>v;++v)v in t&&e(t[v],s,u,p);else h.resolve(f);return h.then(n,a,i)})}function c(e,t,r,n){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,r,n)}function l(e,t,r,n){return p(1,arguments),d(e,_).then(t,r,n)}function f(){return d(arguments,_)}function d(t,r){return e(t,function(t){var n,a,i,u,s,c;if(i=a=t.length>>>0,n=[],c=o(),i)for(u=function(t,a){e(t,r).then(function(e){n[a]=e,--i||c.resolve(n)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function h(t,r){var n=T.call(arguments,1);return e(t,function(t){var a;return a=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,a)})})},v.apply(t,n)})}function E(t,r,n){var a=arguments.length>2;return e(t,function(e){return e=a?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function y(){}function _(e){return e}var v,T,R;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=d,e.reduce=h,e.any=c,e.some=s,e.chain=E,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(R,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(R,t)})})}},T=[].slice,v=[].reduce||function(e){var t,r,n,a,i;if(i=0,t=Object(this),a=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=a)throw new TypeError}else n=r[1];for(;a>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(e,t,r){for(var n,a,i=0,o=e.length-1;o>=i;)if(n=~~((i+o)/2),a=r(e[n],t),0>a)i=n+1;else{if(!(a>0))return n;o=n-1}return~(o+1)};return r}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,r,n,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=a};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],a=function(e,t,r,n){r||(r=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+a:a+e},i=function(e,t,r,n,i,o){var u=n-e.length;return u>0&&(e=r||!i?a(e,n,o,r):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+a(c.toString(t),u||0,"0",!1),i(e,r,n,o,s)},u=function(e,t,r,n,a,o){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,a,o)},s=function(e,n,s,c,l,f,d){var h,E,m,p,y;if("%%"==e)return"%";for(var _=!1,v="",T=!1,R=!1,A=" ",S=s.length,g=0;s&&S>g;g++)switch(s.charAt(g)){case" ":v=" ";break;case"+":v="+";break;case"-":_=!0;break;case"'":A=s.charAt(g+1);break;case"0":T=!0;break;case"#":R=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,y=n?t[n.slice(0,-1)]:t[r++],d){case"s":return u(String(y),_,c,f,T,A);case"c":return u(String.fromCharCode(+y),_,c,f,T);case"b":return o(y,2,R,_,c,f,T);case"o":return o(y,8,R,_,c,f,T);case"x":return o(y,16,R,_,c,f,T);case"X":return o(y,16,R,_,c,f,T).toUpperCase();case"u":return o(y,10,R,_,c,f,T);case"i":case"d":return h=+y||0,h=Math.round(h-h%1),E=0>h?"-":v,y=E+a(String(Math.abs(h)),f,"0",!1),i(y,E,_,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return h=+y,E=0>h?"-":v,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],y=E+Math.abs(h)[m](f),i(y,E,_,c,T)[p]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,r,n,a,i,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t);
}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(e,t){return w.compare(e.julianDate,t.julianDate)}function f(e){_.julianDate=e;var r=w.leapSeconds,n=t(r,_,l);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var a=r[n].offset;if(n>0){var i=w.secondsDifference(r[n].julianDate,e);i>a&&(n--,a=r[n].offset)}w.addSeconds(e,a,e)}function d(e,r){_.julianDate=e;var n=w.leapSeconds,a=t(n,_,l);if(0>a&&(a=~a),0===a)return w.addSeconds(e,-n[0].offset,r);if(a>=n.length)return w.addSeconds(e,-n[a-1].offset,r);var i=w.secondsDifference(n[a].julianDate,e);return 0===i?w.addSeconds(e,-n[a].offset,r):1>=i?void 0:w.addSeconds(e,-n[--a].offset,r)}function h(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,0>n&&(n+=24);var f=i+(n*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}var m=new i,p=[31,28,31,30,31,30,31,31,30,31,30,31],y=29,_=new u,v=/^(\d{4})$/,T=/^(\d{4})-(\d{2})$/,R=/^(\d{4})-?(\d{3})$/,A=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,S=/^(\d{4})-?(\d{2})-?(\d{2})$/,g=/([Z+\-])?(\d{2})?:?(\d{2})?$/,N=/^(\d{2})(\.\d+)?/.source+g.source,O=/^(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,I=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,M="Invalid ISO 8601 date.",w=function(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,h(a,t,this),n===c.UTC&&f(this)};w.fromDate=function(e,t){var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),f(t),t):new w(r[0],r[1],c.UTC)},w.fromIso8601=function(e,t){e=e.replace(",",".");var r,i,u,s=e.split("T"),l=1,d=1,m=0,_=0,g=0,x=0,C=s[0],P=s[1];if(!n(C))throw new a(M);var D;if(s=C.match(S),null!==s){if(D=C.split("-").length-1,D>0&&2!==D)throw new a(M);r=+s[1],l=+s[2],d=+s[3]}else if(s=C.match(T),null!==s)r=+s[1],l=+s[2];else if(s=C.match(v),null!==s)r=+s[1];else{var L;if(s=C.match(R),null!==s){if(r=+s[1],L=+s[2],u=o(r),1>L||u&&L>366||!u&&L>365)throw new a(M)}else{if(s=C.match(A),null===s)throw new a(M);r=+s[1];var U=+s[2],b=+s[3]||0;if(D=C.split("-").length-1,D>0&&(!n(s[3])&&1!==D||n(s[3])&&2!==D))throw new a(M);var F=new Date(Date.UTC(r,0,4));L=7*U+b-F.getUTCDay()-3}i=new Date(Date.UTC(r,0,1)),i.setUTCDate(L),l=i.getUTCMonth()+1,d=i.getUTCDate()}if(u=o(r),1>l||l>12||1>d||(2!==l||!u)&&d>p[l-1]||u&&2===l&&d>y)throw new a(M);var z;if(n(P)){if(s=P.match(I),null!==s){if(D=P.split(":").length-1,D>0&&2!==D&&3!==D)throw new a(M);m=+s[1],_=+s[2],g=+s[3],x=1e3*+(s[4]||0),z=5}else if(s=P.match(O),null!==s){if(D=P.split(":").length-1,D>0&&1!==D)throw new a(M);m=+s[1],_=+s[2],g=60*+(s[3]||0),z=4}else{if(s=P.match(N),null===s)throw new a(M);m=+s[1],_=60*+(s[2]||0),z=3}if(_>=60||g>=61||m>24||24===m&&(_>0||g>0||x>0))throw new a(M);var B=s[z],G=+s[z+1],q=+(s[z+2]||0);switch(B){case"+":m-=G,_-=q;break;case"-":m+=G,_+=q;break;case"Z":break;default:_+=new Date(Date.UTC(r,l-1,d,m,_)).getTimezoneOffset()}}else _+=new Date(r,l-1,d).getTimezoneOffset();var W=60===g;for(W&&g--;_>=60;)_-=60,m++;for(;m>=24;)m-=24,d++;for(i=u&&2===l?y:p[l-1];d>i;)d-=i,l++,l>12&&(l-=12,r++),i=u&&2===l?y:p[l-1];for(;0>_;)_+=60,m--;for(;0>m;)m+=24,d--;for(;1>d;)l--,1>l&&(l+=12,r--),i=u&&2===l?y:p[l-1],d+=i;var H=E(r,l,d,m,_,g,x);return n(t)?(h(H[0],H[1],t),f(t)):t=new w(H[0],H[1],c.UTC),W&&w.addSeconds(t,1,t),t},w.now=function(e){return w.fromDate(new Date,e)};var x=new w(0,0,c.TAI);return w.toGregorianDate=function(e,t){var r=!1,a=d(e,x);n(a)||(w.addSeconds(e,-1,x),a=d(x,x),r=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var h=80*c/2447|0,E=c-(2447*h/80|0)|0;c=h/11|0;var m=h+2-12*c|0,p=100*(l-49)+f+c|0,y=u/s.SECONDS_PER_HOUR|0,_=u-y*s.SECONDS_PER_HOUR,v=_/s.SECONDS_PER_MINUTE|0;_-=v*s.SECONDS_PER_MINUTE;var T=0|_,R=(_-T)/s.SECONDS_PER_MILLISECOND;return y+=12,y>23&&(y-=24),r&&(T+=1),n(t)?(t.year=p,t.month=m,t.day=E,t.hour=y,t.minute=v,t.second=T,t.millisecond=R,t.isLeapSecond=r,t):new i(p,m,E,y,v,T,R,r)},w.toDate=function(e){var t=w.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},w.toIso8601=function(t,r){var a,i=w.toGregorianDate(t,i);return n(r)||0===i.millisecond?n(r)&&0!==r?(a=(.01*i.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},w.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new w(e.dayNumber,e.secondsOfDay,c.TAI):void 0},w.compare=function(e,t){var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},w.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},w.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(w.secondsDifference(e,t))<=r},w.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},w.secondsDifference=function(e,t){var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},w.daysDifference=function(e,t){var r=e.dayNumber-t.dayNumber,n=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+n},w.computeTaiMinusUtc=function(e){_.julianDate=e;var r=w.leapSeconds,n=t(r,_,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},w.addSeconds=function(e,t,r){return h(e.dayNumber,e.secondsOfDay+t,r)},w.addMinutes=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,n,r)},w.addHours=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,n,r)},w.addDays=function(e,t,r){var n=e.dayNumber+t;return h(n,e.secondsOfDay,r)},w.lessThan=function(e,t){return w.compare(e,t)<0},w.lessThanOrEquals=function(e,t){return w.compare(e,t)<=0},w.greaterThan=function(e,t){return w.compare(e,t)>0},w.greaterThanOrEquals=function(e,t){return w.compare(e,t)>=0},w.prototype.clone=function(e){return w.clone(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.equalsEpsilon=function(e,t){return w.equalsEpsilon(this,e,t)},w.prototype.toString=function(){return w.toIso8601(this)},w.leapSeconds=[new u(new w(2441317,43210,c.TAI),10),new u(new w(2441499,43211,c.TAI),11),new u(new w(2441683,43212,c.TAI),12),new u(new w(2442048,43213,c.TAI),13),new u(new w(2442413,43214,c.TAI),14),new u(new w(2442778,43215,c.TAI),15),new u(new w(2443144,43216,c.TAI),16),new u(new w(2443509,43217,c.TAI),17),new u(new w(2443874,43218,c.TAI),18),new u(new w(2444239,43219,c.TAI),19),new u(new w(2444786,43220,c.TAI),20),new u(new w(2445151,43221,c.TAI),21),new u(new w(2445516,43222,c.TAI),22),new u(new w(2446247,43223,c.TAI),23),new u(new w(2447161,43224,c.TAI),24),new u(new w(2447892,43225,c.TAI),25),new u(new w(2448257,43226,c.TAI),26),new u(new w(2448804,43227,c.TAI),27),new u(new w(2449169,43228,c.TAI),28),new u(new w(2449534,43229,c.TAI),29),new u(new w(2450083,43230,c.TAI),30),new u(new w(2450630,43231,c.TAI),31),new u(new w(2451179,43232,c.TAI),32),new u(new w(2453736,43233,c.TAI),33),new u(new w(2454832,43234,c.TAI),34),new u(new w(2456109,43235,c.TAI),35),new u(new w(2457204,43236,c.TAI),36)],w}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var a=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];n&&(o=t(o,n)),a[i]=o}return a};return t}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var a=r[n],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var r=function(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,r,n,a,i){"use strict";function o(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function u(e,t){for(var r=o(e,t),n=new ArrayBuffer(r.length),a=new Uint8Array(n),i=0;i<r.length;i++)a[i]=r.charCodeAt(i);return n}function s(e,r){r=t(r,"");var a=e[1],i=!!e[2],s=e[3];switch(r){case"":case"text":return o(i,s);case"arraybuffer":return u(i,s);case"blob":var c=u(i,s);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(o(i,s),a);case"json":return JSON.parse(o(i,s));default:throw new n("Unhandled responseType: "+r)}}var c=function(r){r=t(r,t.EMPTY_OBJECT);var n=r.responseType,a=t(r.method,"GET"),i=r.data,o=r.headers,u=r.overrideMimeType;return e(r.url,function(t){var r=e.defer();return c.load(t,n,a,i,o,r,u),r.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return c.load=function(e,t,n,o,u,c,f){var d=l.exec(e);if(null!==d)return void c.resolve(s(d,t));var h=new XMLHttpRequest;if(r(f)&&r(h.overrideMimeType)&&h.overrideMimeType(f),h.open(n,e,!0),r(u))for(var E in u)u.hasOwnProperty(E)&&h.setRequestHeader(E,u[E]);r(t)&&(h.responseType=t),h.onload=function(){200===h.status?r(h.response)?c.resolve(h.response):r(h.responseXML)&&h.responseXML.hasChildNodes()?c.resolve(h.responseXML):r(h.responseText)?c.resolve(h.responseText):c.reject(new i("unknown XMLHttpRequest response type.")):c.reject(new a(h.status,h.response,h.getAllResponseHeaders()))},h.onerror=function(e){c.reject(new a)},h.send(o)},c.defaultLoad=c.load,c}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,headers:r})};return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,n){"use strict";var a={Accept:"application/json,*/*;q=0.01"},i=function(r,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,n(r,i).then(function(e){return JSON.parse(e)})};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function d(e,t){return o.compare(e.julianDate,t)}function h(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),h=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>h||0>E||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var p=e._samples=r.samples,y=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,v=e._addNewLeapSeconds,T=0,R=p.length;R>T;T+=e._columnCount){var A=p[T+a],S=p[T+m],g=A+l.MODIFIED_JULIAN_DATE_DIFFERENCE,N=new o(g,S,f.TAI);if(y.push(N),v){if(S!==_&&n(_)){var O=o.leapSeconds,I=t(O,N,d);if(0>I){var M=new u(N,S);O.splice(~I,0,M)}}_=S}}}function E(e,t,r,n,a){var i=r*n;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function p(e,t,r,n,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||n.equals(c))return E(e,r,a,s,u),u;if(n.equals(l))return E(e,r,i,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),d=a*s,h=i*s,p=r[d+e._ut1MinusUtcSecondsColumn],y=r[h+e._ut1MinusUtcSecondsColumn],_=y-p;if(_>.5||-.5>_){var v=r[d+e._taiMinusUtcSecondsColumn],T=r[h+e._taiMinusUtcSecondsColumn];v!==T&&(l.equals(n)?p=y:y-=T-v)}return u.xPoleWander=m(f,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,p,y),u}var y=function(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))h(this,t.data);else if(n(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){h(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,r){if(!n(this._samples)){if(n(this._dataError))throw new c(this._dataError);return void 0}if(n(r)||(r=new a(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=i[u],d=i[u+1],h=o.lessThanOrEquals(f,e),E=!n(d),m=E||o.greaterThanOrEquals(d,e);if(h&&m)return s=u,!E&&d.equals(e)&&++s,l=s+1,p(this,i,this._samples,e,s,l,r),r}var y=t(i,e,o.compare,this._dateColumn);return y>=0?(y<i.length-1&&i[y+1].equals(e)&&++y,s=y,l=y):(l=~y,s=l-1,0>s&&(s=0)),this._lastIndex=s,p(this,i,this._samples,e,s,l,r),r},y}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,r,n){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),a=f.exec(n);if(null!==a)return a[1]}return void 0}function i(){if(t(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(n))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}var s,c,l,f=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,d=function(e){t(c)||(c=t(n.toUrl)?o:u),t(l)||(l=document.createElement("a"));var r=c(e);return l.href=r,l.href=l.href,l.href};return d._cesiumScriptRegex=f,d.setBaseUrl=function(t){s=new e(t).resolve(new e(document.location.href))},d}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,r){this.x=e,this.y=t,this.s=r};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function c(r,a){if(r._chunkDownloadsInProgress[a])return r._chunkDownloadsInProgress[a];var i=e.defer();r._chunkDownloadsInProgress[a]=i;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){r._chunkDownloadsInProgress[a]=!1;for(var t=r._samples,n=e.samples,o=a*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[o+u]=n[u];i.resolve()}),i.promise}var l=function(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){n[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(n[s]*=s-c);n[s]=1/n[s]}this._work=new Array(t+1),this._coef=new Array(t+1)},f=new i(0,0,u.TAI);return l.prototype.preload=function(t,r,n,a){var i=s(this,t,r),o=s(this,n,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,d=l/this._samplesPerXysFile|0,h=[],E=f;d>=E;++E)h.push(c(this,E));return e.all(h)},l.prototype.computeXysRadians=function(e,t,r){var i=s(this,e,t);if(0>i)return void 0;var o=i/this._stepSizeDays|0;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(u/2|0);0>l&&(l=0);var f=l+u;f>=this._totalSamples&&(f=this._totalSamples-1,l=f-u,0>l&&(l=0));var d=!1,h=this._samples;if(n(h[3*l])||(c(this,l/this._samplesPerXysFile|0),d=!0),n(h[3*f])||(c(this,f/this._samplesPerXysFile|0),d=!0),d)return void 0;n(r)?(r.x=0,r.y=0,r.s=0):r=new a(0,0,0);var E,m,p=i-l*this._stepSizeDays,y=this._work,_=this._denominators,v=this._coef,T=this._xTable;for(E=0;u>=E;++E)y[E]=p-T[E];for(E=0;u>=E;++E){for(v[E]=1,m=0;u>=m;++m)m!==E&&(v[E]*=y[m]);v[E]*=_[E];var R=3*(l+E);r.x+=v[E]*h[R++],r.y+=v[E]*h[R++],r.s+=v[E]*h[R]}return r},l}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)},c=new e;s.fromAxisAngle=function(t,n,a){var i=n/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,d=Math.cos(i);return r(a)?(a.x=u,a.y=l,a.z=f,a.w=d,a):new s(u,l,f,d)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var n,a,i,o,c,d=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],E=e[u.COLUMN2ROW2],m=d+h+E;if(m>0)n=Math.sqrt(m+1),c=.5*n,n=.5/n,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var p=l,y=0;h>d&&(y=1),E>d&&E>h&&(y=2);var _=p[y],v=p[_];n=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(v,v)]+1);var T=f;T[y]=.5*n,n=.5/n,c=(e[u.getElementIndex(v,_)]-e[u.getElementIndex(_,v)])*n,T[_]=(e[u.getElementIndex(_,y)]+e[u.getElementIndex(y,_)])*n,T[v]=(e[u.getElementIndex(v,y)]+e[u.getElementIndex(y,v)])*n,a=-T[0],i=-T[1],o=-T[2]}return r(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var d=new s;s.fromHeadingPitchRoll=function(t,r,n,a){var i=s.fromAxisAngle(e.UNIT_X,n,d),o=s.fromAxisAngle(e.UNIT_Y,-r,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,d);return s.multiply(u,a,a)};var h=new e,E=new e,m=new s,p=new s,y=new s;s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.x=e[n],a.y=e[n+1],a.z=e[n+2],a.w=e[n+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,y),s.conjugate(y,y);for(var a=0,i=r-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),m),s.multiply(m,y,m),m.w<0&&s.negate(m,m),s.computeAxis(m,h);var u=s.computeAngle(m);n[o]=h.x*u,n[o+1]=h.y*u,n[o+2]=h.z*u}},s.unpackInterpolationResult=function(t,n,a,i,o){r(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(n,4*i,p),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(E,u,m),s.multiply(m,p,o)},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,a=e.y*r,i=e.z*r,o=e.w*r;return t.x=n,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+n*l+a*c-i*s,d=o*s-n*c+a*l+i*u,h=o*c+n*s-a*u+i*l,E=o*l-n*u-a*s-i*c;return r.x=f,r.y=d,r.z=h,r.w=E,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var _=new s;s.lerp=function(e,t,r,n){return _=s.multiplyByScalar(t,r,_),n=s.multiplyByScalar(e,1-r,n),s.add(_,n,n)};var v=new s,T=new s,R=new s;s.slerp=function(e,t,r,n){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=v=s.negate(t,v)),1-a<o.EPSILON6)return s.lerp(e,i,r,n);var u=Math.acos(a);return T=s.multiplyByScalar(e,Math.sin((1-r)*u),T),R=s.multiplyByScalar(i,Math.sin(r*u),R),n=s.add(T,R,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),a=0;return 0!==n&&(a=n/Math.sin(n)),e.multiplyByScalar(t,a,r)},s.exp=function(t,r){var n=e.magnitude(t),a=0;return 0!==n&&(a=Math.sin(n)/n),r.x=t.x*a,r.y=t.y*a,r.z=t.z*a,r.w=Math.cos(n),r};var A=new e,S=new e,g=new s,N=new s;s.computeInnerQuadrangle=function(t,r,n,a){var i=s.conjugate(r,g);s.multiply(i,n,N);var o=s.log(N,A);s.multiply(i,t,N);var u=s.log(N,S);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,g),s.multiply(r,g,a)},s.squad=function(e,t,r,n,a,i){var o=s.slerp(e,t,a,g),u=s.slerp(r,n,a,N);return s.slerp(o,u,2*a*(1-a),i)};for(var O=new s,I=1.9011074535173003,M=a.supportsTypedArrays()?new Float32Array(8):[],w=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var D=P+1,L=2*D+1;M[P]=1/(D*L),w[P]=D/L}return M[7]=I/136,w[7]=8*I/17,s.fastSlerp=function(e,t,r,n){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-r,c=r*r,l=u*u,f=7;f>=0;--f)x[f]=(M[f]*c-w[f])*o,C[f]=(M[f]*l-w[f])*o;var d=a*r*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),h=u*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),E=s.multiplyByScalar(e,h,O);return s.multiplyByScalar(t,d,n),s.add(E,n,n)},s.fastSquad=function(e,t,r,n,a,i){var o=s.fastSlerp(e,t,a,g),u=s.fastSlerp(r,n,a,N);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,E,m,p,y){"use strict";var _={},v=new r,T=new r,R=new r;_.eastNorthUpToFixedFrame=function(e,t,n){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-o,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=o,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=v,s=T,l=R;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=s.x,n[1]=s.y,n[2]=s.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=u.x,n[9]=u.y,n[10]=u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var A=new r,S=new r,g=new r;_.northEastDownToFixedFrame=function(e,t,n){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(n)?(n[0]=-o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-o,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=A,s=S,l=g;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=-u.x,n[9]=-u.y,n[10]=-u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,t,n){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(n)?(n[0]=-o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=o,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=v,s=T,l=R;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=u.x,n[5]=u.y,n[6]=u.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var N=new p,O=new r(1,1,1),I=new m;_.headingPitchRollToFixedFrame=function(e,t,n,a,i,o){var u=p.fromHeadingPitchRoll(t,n,a,N),s=m.fromTranslationQuaternionRotationScale(r.ZERO,u,O,I);return o=_.eastNorthUpToFixedFrame(e,i,o),m.multiply(o,s,o)};var M=new m,w=new E;_.headingPitchRollQuaternion=function(e,t,r,n,a,i){var o=_.headingPitchRollToFixedFrame(e,t,r,n,a,M),u=m.getRotation(o,w);return p.fromRotationMatrix(u,i)};var x=24110.54841,C=8640184.812866,P=.093104,D=-62e-7,L=1.1772758384668e-19,U=72921158553e-15,b=h.TWO_PI/86400,F=new d;_.computeTemeToPseudoFixedMatrix=function(e,t){F=d.addSeconds(e,-d.computeTaiMinusUtc(e),F);var r,n=F.dayNumber,a=F.secondsOfDay,o=n-2451545;r=a>=43200?(o+.5)/y.DAYS_PER_JULIAN_CENTURY:(o-.5)/y.DAYS_PER_JULIAN_CENTURY;var u=x+r*(C+r*(P+r*D)),s=u*b%h.TWO_PI,c=U+L*(n-2451545.5),l=(a+.5*y.SECONDS_PER_DAY)%y.SECONDS_PER_DAY,f=s+c*l,m=Math.cos(f),p=Math.sin(f);return i(t)?(t[0]=m,t[1]=-p,t[2]=0,t[3]=p,t[4]=m,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(m,p,0,-p,m,0,0,0,1)},_.iau2006XysData=new l,_.earthOrientationParameters=u.NONE;var z=32.184,B=2451545;_.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+z,a=t.stop.dayNumber,i=t.stop.secondsOfDay+z,o=_.iau2006XysData.preload(r,n,a,i),u=_.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},_.computeIcrfToFixedMatrix=function(e,t){
i(t)||(t=new E);var r=_.computeFixedToIcrfMatrix(e,t);return i(r)?E.transpose(r,t):void 0};var G=new f(0,0,0),q=new s(0,0,0,0,0,0),W=new E,H=new E;_.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new E);var r=_.earthOrientationParameters.compute(e,q);if(!i(r))return void 0;var n=e.dayNumber,a=e.secondsOfDay+z,o=_.iau2006XysData.computeXysRadians(n,a,G);if(!i(o))return void 0;var u=o.x+r.xPoleOffset,s=o.y+r.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=W;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=E.fromRotationZ(-o.s,H),m=E.multiply(l,f,W),p=e.dayNumber,v=e.secondsOfDay-d.computeTaiMinusUtc(e)+r.ut1MinusUtc,T=p-2451545,R=v/y.SECONDS_PER_DAY,A=.779057273264+R+.00273781191135448*(T+R);A=A%1*h.TWO_PI;var S=E.fromRotationZ(A,H),g=E.multiply(m,S,W),N=Math.cos(r.xPoleWander),O=Math.cos(r.yPoleWander),I=Math.sin(r.xPoleWander),M=Math.sin(r.yPoleWander),w=n-B+a/y.SECONDS_PER_DAY;w/=36525;var x=-47e-6*w*h.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),D=H;return D[0]=N*C,D[1]=N*P,D[2]=I,D[3]=-O*P+M*I*C,D[4]=O*C+M*I*P,D[5]=-M*N,D[6]=-M*P-O*I*C,D[7]=M*C-O*I*P,D[8]=O*N,E.multiply(g,D,t)};var X=new n;_.pointToWindowCoordinates=function(e,t,r,n){return n=_.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},_.pointToGLWindowCoordinates=function(e,r,a,o){i(o)||(o=new t);var u=X;return m.multiplyByVector(e,n.fromElements(a.x,a.y,a.z,1,u),u),n.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(r,u,u),t.fromCartesian4(u,o)};var V=new r,Y=new r,k=new r;return _.rotationMatrixFromPositionVelocity=function(e,t,n,o){var u=a(n,c.WGS84).geodeticSurfaceNormal(e,V),s=r.cross(t,u,Y);r.equalsEpsilon(s,r.ZERO,h.EPSILON6)&&(s=r.clone(r.UNIT_X,s));var l=r.cross(s,t,k);return r.cross(t,l,s),r.negate(s,s),i(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},_}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,E){"use strict";var m=new n,p=function(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var n=E.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(f.getColumn(n,0,m)),this._yAxis=r.fromCartesian4(f.getColumn(n,1,m));var i=r.fromCartesian4(f.getColumn(n,2,m));this._plane=d.fromPointNormal(e,i)};o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var y=new e;p.fromPoints=function(t,r){var n=e.fromPoints(t,y);return new p(n.center,r)};var _=new h,v=new r;p.prototype.projectPointOntoPlane=function(e,n){var a=_;a.origin=e,r.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,v);if(i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,v)),i(o)){var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return i(n)?(n.x=s,n.y=l,n):new t(s,l)}return void 0},p.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var r=0,n=e.length,a=0;n>a;a++){var o=this.projectPointOntoPlane(e[a],t[r]);i(o)&&(t[r]=o,r++)}return t.length=r,t},p.prototype.projectPointToNearestOnPlane=function(e,n){i(n)||(n=new t);var a=_;a.origin=e,r.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,v);i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,v));var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return n.x=s,n.y=l,n},p.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;r>n;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var T=new r;return p.prototype.projectPointsOntoEllipsoid=function(e,t){var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=T,l=0;n>l;++l){var f=e[l];r.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new r);var d=r.add(o,c,t[l]);r.multiplyByScalar(s,f.y,c),r.add(d,c,d),a.scaleToGeocentricSurface(d,d)}return t},p}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";var r=new t,n=function(t,n,a,i){return e(t,n,a,i,r),r.x>0&&r.y>0&&r.z>0};return n}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,a=(r-n)/r,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),f=s*o,d=f*f,h=1-d,E=Math.sqrt(h),m=t/4,p=m*m,y=p*m,_=p*p,v=1+m-3*p/4+5*y/4-175*_/64,T=1-m+15*p/8-35*y/8,R=1-3*m+35*p/4,A=1-5*m,S=v*l-T*Math.sin(2*l)*m/2-R*Math.sin(4*l)*p/16-A*Math.sin(6*l)*y/48-5*Math.sin(8*l)*_/512,g=e._constants;g.a=r,g.b=n,g.f=a,g.cosineHeading=i,g.sineHeading=o,g.tanU=u,g.cosineU=s,g.sineU=c,g.sigma=l,g.sineAlpha=f,g.sineSquaredAlpha=d,g.cosineSquaredAlpha=h,g.cosineAlpha=E,g.u2Over4=m,g.u4Over16=p,g.u6Over64=y,g.u8Over256=_,g.a0=v,g.a1=T,g.a2=R,g.a3=A,g.distanceRatio=S}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,r,n,a,i,o){var u=c(e,r);return(1-u)*e*t*(n+u*a*(o+u*i*(2*o*o-1)))}function f(e,t,r,n,a,i,o){var s,c,f,d,h,E=(t-r)/t,m=i-n,p=Math.atan((1-E)*Math.tan(a)),y=Math.atan((1-E)*Math.tan(o)),_=Math.cos(p),v=Math.sin(p),T=Math.cos(y),R=Math.sin(y),A=_*T,S=_*R,g=v*R,N=v*T,O=m,I=u.TWO_PI,M=Math.cos(O),w=Math.sin(O);do{M=Math.cos(O),w=Math.sin(O);var x=S-N*M;f=Math.sqrt(T*T*w*w+x*x),c=g+A*M,s=Math.atan2(f,c);var C;0===f?(C=0,d=1):(C=A*w/f,d=1-C*C),I=O,h=c-2*g/d,isNaN(h)&&(h=0),O=m+l(E,C,d,s,f,c,h)}while(Math.abs(O-I)>u.EPSILON12);var P=d*(t*t-r*r)/(r*r),D=1+P*(4096+P*(P*(320-175*P)-768))/16384,L=P*(256+P*(P*(74-47*P)-128))/1024,U=h*h,b=L*f*(h+L*(c*(2*U-1)-L*h*(4*f*f-3)*(4*U-3)/6)/4),F=r*D*(s-b),z=Math.atan2(T*w,S-N*M),B=Math.atan2(_*w,S*M-N);e._distance=F,e._startHeading=z,e._endHeading=B,e._uSquared=P}function d(r,n,a,i){e.normalize(i.cartographicToCartesian(n,E),h),e.normalize(i.cartographicToCartesian(a,E),E);f(r,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,a.longitude,a.latitude),r._start=t.clone(n,r._start),r._end=t.clone(a,r._end),r._start.height=0,r._end.height=0,s(r)}var h=new e,E=new e,m=function(e,a,i){var u=r(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(a)&&d(this,e,a,u)};return a(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),m.prototype.setEndPoints=function(e,t){d(this,e,t,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},m.prototype.interpolateUsingSurfaceDistance=function(e,r){var a=this._constants,i=a.distanceRatio+e/a.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),f=Math.sin(4*i),d=Math.sin(6*i),h=Math.sin(8*i),E=i*i,m=i*E,p=a.u8Over256,y=a.u2Over4,_=a.u6Over64,v=a.u4Over16,T=2*m*p*o/3+i*(1-y+7*v/4-15*_/4+579*p/64-(v-15*_/4+187*p/16)*o-(5*_/4-115*p/16)*u-29*p*s/16)+(y/2-v+71*_/32-85*p/16)*c+(5*v/16-5*_/4+383*p/96)*f-E*((_-11*p/2)*c+5*p*f/2)+(29*_/96-29*p/16)*d+539*p*h/1536,R=Math.asin(Math.sin(T)*a.cosineAlpha),A=Math.atan(a.a/a.b*Math.tan(R));T-=a.sigma;var S=Math.cos(2*a.sigma+T),g=Math.sin(T),N=Math.cos(T),O=a.cosineU*N,I=a.sineU*g,M=Math.atan2(g*a.sineHeading,O-I*a.cosineHeading),w=M-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,T,g,N,S);return n(r)?(r.longitude=this._start.longitude+w,r.latitude=A,r.height=0,r):new t(this._start.longitude+w,A,0)},m}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function d(e,t,r){var n=g;n.length=e;var a;if(t===r){for(a=0;e>a;a++)n[a]=t;return n}var i=r-t,o=i/e;for(a=0;e>a;a++){var u=t+a*o;n[a]=u}return n}function h(t,r,n,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,M),l=a.scaleToGeodeticSurface(r,w),f=E.numberOfPoints(t,r,n),h=a.cartesianToCartographic(c,N),m=a.cartesianToCartographic(l,O),p=d(f,i,o);x.setEndPoints(h,m);var y=x.surfaceDistance/f,_=s;h.height=i;var v=a.cartographicToCartesian(h,I);e.pack(v,u,_),_+=3;for(var T=1;f>T;T++){var R=x.interpolateUsingSurfaceDistance(T*y,O);R.height=p[T],v=a.cartographicToCartesian(R,I),e.pack(v,u,_),_+=3}return _}var E={};E.numberOfPoints=function(t,r,n){var a=e.distance(t,r);return Math.ceil(a/n)};var m=new t;E.extractHeights=function(e,t){for(var r=e.length,n=new Array(r),a=0;r>a;a++){var i=e[a];n[a]=t.cartesianToCartographic(i,m).height}return n};var p=new l,y=new e,_=new e,v=new f(e.ZERO,0),T=new e,R=new f(e.ZERO,0),A=new e,S=new e,g=[],N=new t,O=new t,I=new e,M=new e,w=new e,x=new o;E.wrapLongitude=function(t,a){var i=[],o=[];if(n(t)&&t.length>0){a=r(a,l.IDENTITY);var s=l.inverseTransformation(a,p),c=l.multiplyByPoint(s,e.ZERO,y),d=l.multiplyByPointAsVector(s,e.UNIT_Y,_),h=f.fromPointNormal(c,d,v),E=l.multiplyByPointAsVector(s,e.UNIT_X,T),m=f.fromPointNormal(c,E,R),g=1;i.push(e.clone(t[0]));for(var N=i[0],O=t.length,I=1;O>I;++I){var M=t[I];if(f.getPointDistance(m,N)<0||f.getPointDistance(m,M)<0){var w=u.lineSegmentPlane(N,M,h,A);if(n(w)){var x=e.multiplyByScalar(d,5e-9,S);f.getPointDistance(h,N)<0&&e.negate(x,x),i.push(e.add(w,x,new e)),o.push(g+1),e.negate(x,x),i.push(e.add(w,x,new e)),g=1}}i.push(e.clone(t[I])),g++,N=M}o.push(g)}return{positions:i,lengths:o}};var C=c.EPSILON7;return E.removeDuplicates=function(t){var r=t.length;if(2>r)return t;var n,a,i;for(n=1;r>n&&(a=t[n-1],i=t[n],!e.equalsEpsilon(a,i,C));++n);if(n===r)return t;for(var o=t.slice(0,n);r>n;++n)i=t[n],e.equalsEpsilon(a,i,C)||(o.push(e.clone(i)),a=i);return o},E.generateArc=function(t){n(t)||(t={});var a=t.positions,o=a.length,u=r(t.ellipsoid,i.WGS84),l=r(t.height,0);if(1>o)return[];if(1===o){var f=u.scaleToGeodeticSurface(a[0],M);if(0!==l){var d=u.geodeticSurfaceNormal(f,I);e.multiplyByScalar(d,l,d),e.add(f,d,f)}return[f.x,f.y,f.z]}var m=t.minDistance;if(!n(m)){var p=r(t.granularity,c.RADIANS_PER_DEGREE);m=c.chordLength(p,u.maximumRadius)}var y,_=0;for(y=0;o-1>y;y++)_+=E.numberOfPoints(a[y],a[y+1],m);var v=3*(_+1),T=new Array(v),R=0,A=s(l);for(y=0;o-1>y;y++){var S=a[y],O=a[y+1],w=A?l[y]:l,x=A?l[y+1]:l;R=h(S,O,m,u,w,x,T,R)}g.length=0;var C=a[o-1],P=u.cartesianToCartographic(C,N);P.height=A?l[o-1]:l;var D=u.cartographicToCartesian(P,I);return e.pack(D,T,v-3),T},E.generateCartesianArc=function(t){for(var r=E.generateArc(t),n=r.length/3,a=new Array(n),i=0;n>i;i++)a[i]=e.unpack(r,3*i);return a},E}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,r},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return t(r)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,E,m){"use strict";function p(t,r,n){var a=e.subtract(r,t,b),i=e.subtract(n,r,F);return a.x*i.y-a.y*i.x>=0}function y(e){for(var t=e[0].x,r=0,n=0;n<e.length;n++)e[n].x>t&&(t=e[n].x,r=n);return r}function _(e){for(var t=e[0][0].x,r=0,n=0;n<e.length;n++){var a=e[n][y(e[n])].x;a>t&&(t=a,r=n)}return r}function v(e){for(var t=[],r=0;r<e.length;r++){var n=e[(r-1+e.length)%e.length],a=e[r],i=e[(r+1)%e.length];p(n,a,i)||t.push(a)}return t}function T(t,r){for(var n=0;n<t.length;n++)if(e.equals(r,t[n]))return n;return-1}function R(r,a,i){i=n(i,[]);var o=Number.MAX_VALUE,u=y(a),s=new e(a[u].x,r.y);i.push(u),i.push((u+1)%a.length);for(var c=a[0].x,l=c,f=1;f<a.length;++f)a[f].x<c?c=a[f].x:a[f].x>l&&(l=a[f].x);l+=l-c;var d=new t(l,r.y,0);for(f=0;f<a.length;f++){var h=a[f],E=a[(f+1)%a.length];if((h.x>=r.x||E.x>=r.x)&&(h.y>=r.y&&E.y<=r.y||h.y<=r.y&&E.y>=r.y)){var m=(E.y-h.y)*(d.x-r.x)-(E.x-h.x)*(d.y-r.y);if(0!==m){m=1/m;var p=((E.x-h.x)*(r.y-h.y)-(E.y-h.y)*(r.x-h.x))*m,_=((d.x-r.x)*(r.y-h.y)-(d.y-r.y)*(r.x-h.x))*m;if(p>=0&&1>=p&&_>=0&&1>=_){var v=new e(r.x+p*(d.x-r.x),r.y+p*(d.y-r.y)),T=e.subtract(v,r,z);m=e.magnitudeSquared(T),o>m&&(s=v,o=m,i[0]=f,i[1]=(f+1)%a.length)}}}}return s}function A(t,r){var n=_(r),a=r[n],i=y(a),o=a[i],u=[],s=R(o,t,u),c=T(t,s);if(-1!==c)return c;var d=e.magnitudeSquared(e.subtract(t[u[0]],o,B)),h=e.magnitudeSquared(e.subtract(t[u[1]],o,B)),E=h>d?t[u[0]]:t[u[1]],m=v(t),p=m.indexOf(E);-1!==p&&m.splice(p,1);for(var A=[],S=0;S<m.length;S++){var g=m[S];f(g,o,s,E)&&A.push(g)}var N=Number.MAX_VALUE;if(A.length>0){var O=e.fromElements(1,0,B);for(S=0;S<A.length;S++){var I=e.subtract(A[S],o,G),M=e.magnitude(O)*e.magnitudeSquared(I);if(0!==M){var w=Math.abs(l.acosClamped(e.dot(O,I)/M));N>w&&(N=w,E=A[S])}}}return t.indexOf(E)}function S(e,r,n){for(var a=ee.computeWindingOrder2D(e),i=0;i<r.length;i++){var o=r[i];t.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ee.computeWindingOrder2D(o);s===a&&o.reverse()}var c=u.fromPoints(e,n),l=c.projectPointsOntoPlane(e),f=[];for(i=0;i<r.length;i++)f.push(c.projectPointsOntoPlane(r[i]));var d=A(l,f),h=_(f),E=y(f[h]),m=r[h],p=[];for(i=0;i<e.length;i++)p.push(e[i]);var v,T=[];if(0!==E)for(v=0;v<=m.length;v++){var R=(v+E)%m.length;0!==R&&T.push(m[R])}else for(v=0;v<m.length;v++)T.push(m[(v+E)%m.length]);var S=p.lastIndexOf(e[d]);T.push(e[S]);var g=p.slice(0,S+1),N=p.slice(S+1);return p=g.concat(T,N),r.splice(h,1),p}function g(e){var t=l.nextRandomNumber(),r=Math.floor(t*e);return r===e&&r--,r}function N(e,t,r,n){var a=n[e].position,i=n[t].position,o=n[r].position,u=o.x,s=o.y,c=a.x-u,l=a.y-s,f=i.x-u,d=i.y-s;return c*d-l*f}function O(e,t){return e.x*t.y-e.y*t.x}function I(e,t){var r=t.length,n=l.mod(e-1,r),a=l.mod(e+1,r);return 0===N(n,a,e,t)?!1:!0}function M(t,r){return e.magnitudeSquared(r)<e.magnitudeSquared(t)}function w(t,r,n){if(!I(t,n))return t;var a=n[t].position,i=n[r].position,o=n.length,u=l.mod(t-1,o);if(!I(u,n))return u;var s=l.mod(t+1,o);if(!I(s,n))return s;var c=e.subtract(n[u].position,a,H),f=e.subtract(n[s].position,a,X),d=e.subtract(i,a,V),h=O(c,d),E=O(f,d);if(0===h)return M(c,d)?q:W;if(0===E)return M(f,d)?q:W;var m=O(c,f);return 0>m?0>h&&E>0?q:W:m>0?h>0&&0>E?W:q:void 0}function x(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function C(t,r,n,a){var i=e.subtract(n,t,k),o=r.x*a.y-r.y*a.x,u=o*o,s=e.magnitudeSquared(r),c=e.magnitudeSquared(a);if(u>Y*s*c){var l=(i.x*a.y-i.y*a.x)/o;return e.add(t,e.multiplyByScalar(r,l,k),k)}return void 0}function P(t,r,n){for(var i=e.subtract(r,t,j),o=n.length,u=0;o>u;u++){var s=n[u].position,c=n[l.mod(u+1,o)].position;if(!(e.equals(t,s)||e.equals(r,c)||e.equals(t,c)||e.equals(r,s))){var f=e.subtract(c,s,Z),d=C(t,i,s,f);if(a(d)&&!(e.equals(d,t)||e.equals(d,r)||e.equals(d,s)||e.equals(d,c))){var h=d.x,E=d.y,m=x(h,t.x,r.x)&&x(E,t.y,r.y)&&x(h,s.x,c.x)&&x(E,s.y,c.y);if(m)return!0}}}return!1}function D(t,r,n){var a=w(t,r,n);if(a>=0)return a;var i=w(r,t,n);return i>=0?i:a!==q||i!==q||P(n[t].position,n[r].position,n)||e.equals(n[t].position,n[r].position)?J:K}function L(e){return 0===N(1,2,0,e)}function U(e){var t=e.length;if(3===t)return L(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new i("Invalid polygon: must have at least three vertices.");for(var r,n,a=0,o=10*e.length,u=J;K>u&&a++<o;){for(r=g(e.length),n=r+1;Math.abs(r-n)<2||Math.abs(r-n)>e.length-2;)n=g(e.length);if(r>n){var s=r;r=n,n=s}u=D(r,n,e)}if(u===K){var c=e.splice(r,n-r+1,e[r],e[n]);return U(e).concat(U(c))}return u>=0?(e.splice(u,1),U(e)):[]}var b=new e,F=new e,z=new e,B=new e(1,0),G=new e,q=-1,W=-2,H=new t,X=new t,V=new t,Y=l.EPSILON14,k=new e,j=(new e,new e),Z=new e,K=-1,J=-2,Q=new t,$=new t,ee={};ee.removeDuplicates=function(e){var r=d.removeDuplicates(e);return t.equals(r[0],r[r.length-1])?r.slice(1):r},ee.computeArea2D=function(e){for(var t=e.length,r=0,n=t-1,a=0;t>a;n=a++){var i=e[n],o=e[a];r+=i.x*o.y-o.x*i.y}return.5*r},ee.computeWindingOrder2D=function(e){var t=ee.computeArea2D(e);return t>0?m.COUNTER_CLOCKWISE:m.CLOCKWISE},ee.triangulate=function(e){for(var t=e.length,r=[],n=0;t>n;++n)r[n]={position:e[n],index:n};return U(r)};var te=new t,re=new t,ne=new t,ae=new t,ie=new t,oe=new t,ue=new t;return ee.computeSubdivision=function(e,i,o,u){u=n(u,l.RADIANS_PER_DEGREE);var f,d=o.slice(0),E=i.length,m=new Array(3*E),p=0;for(f=0;E>f;f++){var y=i[f];m[p++]=y.x,m[p++]=y.y,m[p++]=y.z}for(var _=[],v={},T=e.maximumRadius,R=l.chordLength(u,T),A=R*R;d.length>0;){var S,g,N=d.pop(),O=d.pop(),I=d.pop(),M=t.fromArray(m,3*I,te),w=t.fromArray(m,3*O,re),x=t.fromArray(m,3*N,ne),C=t.multiplyByScalar(t.normalize(M,ae),T,ae),P=t.multiplyByScalar(t.normalize(w,ie),T,ie),D=t.multiplyByScalar(t.normalize(x,oe),T,oe),L=t.magnitudeSquared(t.subtract(C,P,ue)),U=t.magnitudeSquared(t.subtract(P,D,ue)),b=t.magnitudeSquared(t.subtract(D,C,ue)),F=Math.max(L,U,b);F>A?L===F?(S=Math.min(I,O)+" "+Math.max(I,O),f=v[S],a(f)||(g=t.add(M,w,ue),t.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),f=m.length/3-1,v[S]=f),d.push(I,f,N),d.push(f,O,N)):U===F?(S=Math.min(O,N)+" "+Math.max(O,N),f=v[S],a(f)||(g=t.add(w,x,ue),t.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),f=m.length/3-1,v[S]=f),d.push(O,f,I),d.push(f,N,I)):b===F&&(S=Math.min(N,I)+" "+Math.max(N,I),f=v[S],a(f)||(g=t.add(x,M,ue),t.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),f=m.length/3-1,v[S]=f),d.push(N,f,O),d.push(f,I,O)):(_.push(I),_.push(O),_.push(N))}return new s({attributes:{position:new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:m})},indices:_,primitiveType:h.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,r,i,u){i=n(i,o.WGS84);var s=Q,c=$;if(r=n(r,0),u=n(u,!0),a(e)&&a(e.attributes)&&a(e.attributes.position))for(var l=e.attributes.position.values,f=l.length,d=0;f>d;d+=3)t.fromArray(l,d,c),u&&(c=i.scaleToGeodeticSurface(c,c)),s=i.geodeticSurfaceNormal(c,s),t.multiplyByScalar(s,r,s),t.add(c,s,c),l[d]=c.x,l[d+1]=c.y,l[d+2]=c.z;return e},ee.eliminateHoles=function(e,r,a){a=n(a,o.WGS84);for(var i=[],u=0;u<r.length;u++){for(var s=[],c=0;c<r[u].length;c++)s.push(t.clone(r[u][c]));i.push(s)}for(var l=e;i.length>0;)l=S(l,i,a);return l},ee}),define("Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,t,r,n,a,i,o,u){"use strict";var s=Math.cos,c=Math.sin,l=Math.sqrt,f={};f.computePosition=function(e,t,n,a,i){var u=e.ellipsoid.radiiSquared,f=e.nwCorner,d=e.rectangle,h=f.latitude-e.granYCos*t+n*e.granXSin,E=s(h),m=c(h),p=u.z*m,y=f.longitude+t*e.granYSin+n*e.granXCos,_=E*s(y),v=E*c(y),T=u.x*_,R=u.y*v,A=l(T*_+R*v+p*m);a.x=T/A,a.y=R/A,a.z=p/A,r(e.vertexFormat)&&e.vertexFormat.st&&(i.x=(y-d.west)*e.lonScalar-.5,i.y=(h-d.south)*e.latScalar-.5,o.multiplyByVector(e.textureMatrix,i,i),i.x+=.5,i.y+=.5)};var d=new o,h=new e,E=new t,m=new e,p=new a;return f.computeOptions=function(t,a,s){var c,l,f,y,_,v=t._granularity,T=t._ellipsoid,R=t._surfaceHeight,A=t._rotation,S=t._extrudedHeight,g=a.east,N=a.west,O=a.north,I=a.south,M=O-I;N>g?(_=i.TWO_PI-N+g,c=Math.ceil(_/v)+1,l=Math.ceil(M/v)+1,f=_/(c-1),y=M/(l-1)):(_=g-N,c=Math.ceil(_/v)+1,l=Math.ceil(M/v)+1,f=_/(c-1),y=M/(l-1)),s=u.northwest(a,s);var w=u.center(a,E),x=y,C=f,P=0,D=0;if(r(A)){var L=Math.cos(A);x*=L,C*=L;var U=Math.sin(A);P=y*U,D=f*U,h=p.project(s,h),m=p.project(w,m),h=e.subtract(h,m,h);var b=o.fromRotation(A,d);h=o.multiplyByVector(b,h,h),h=e.add(h,m,h),s=p.unproject(h,s);var F=s.latitude,z=F+(c-1)*D,B=F-x*(l-1),G=F-x*(l-1)+(c-1)*D;O=Math.max(F,z,B,G),I=Math.min(F,z,B,G);var q=s.longitude,W=q+(c-1)*C,H=q+(l-1)*P,X=q+(l-1)*P+(c-1)*C;if(g=Math.max(q,W,H,X),N=Math.min(q,W,H,X),O<-i.PI_OVER_TWO||O>i.PI_OVER_TWO||I<-i.PI_OVER_TWO||I>i.PI_OVER_TWO)throw new n("Rotated extent is invalid.");a.north=O,a.south=I,a.east=g,a.west=N}return{granYCos:x,granYSin:P,granXCos:C,granXSin:D,ellipsoid:T,width:c,height:l,surfaceHeight:R,extrudedHeight:S,nwCorner:s,rectangle:a}},f}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return a.POSITION_ONLY=n(new a({position:!0})),a.POSITION_AND_NORMAL=n(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=n(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=n(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=n(new a({position:!0,color:!0})),a.ALL=n(new a({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.binormal?1:0,r[n++]=t.tangent?1:0,r[n++]=t.color?1:0},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.position=1===r[n++],i.normal=1===r[n++],i.st=1===r[n++],i.binormal=1===r[n++],i.tangent=1===r[n++],i.color=1===r[n++],i},a.clone=function(e,r){return t(e)?(t(r)||(r=new a),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},a}),define("Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Rectangle","./RectangleGeometryLibrary","./VertexFormat"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,E,m,p,y,_,v,T,R,A,S){"use strict";function g(e,t){var r=new c({attributes:new f,primitiveType:v.TRIANGLES});return r.attributes.position=new l({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(r.attributes.normal=new l({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(r.attributes.tangent=new l({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(r.attributes.binormal=new l({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.binormals})),r}function N(e,t,n,a){for(var i=e.length,o=t.normal?new Float32Array(i):void 0,u=t.tangent?new Float32Array(i):void 0,s=t.binormal?new Float32Array(i):void 0,c=0,l=L,f=D,d=P,h=0;i>h;h+=3){var E=r.fromArray(e,h,C),m=c+1,p=c+2;(t.normal||t.tangent||t.binormal)&&(d=n.geodeticSurfaceNormal(E,d),(t.tangent||t.binormal)&&(r.cross(r.UNIT_Z,d,f),y.multiplyByVector(a,f,f),r.normalize(f,f),t.binormal&&r.normalize(r.cross(d,f,l),l)),t.normal&&(o[c]=d.x,o[m]=d.y,o[p]=d.z),t.tangent&&(u[c]=f.x,u[m]=f.y,u[p]=f.z),t.binormal&&(s[c]=l.x,s[m]=l.y,s[p]=l.z)),c+=3}return g(t,{positions:e,normals:o,tangents:u,binormals:s})}function O(e,t,n){for(var a=e.length,i=t.normal?new Float32Array(a):void 0,o=t.tangent?new Float32Array(a):void 0,u=t.binormal?new Float32Array(a):void 0,s=0,c=0,l=0,f=!0,d=L,h=D,E=P,p=0;a>p;p+=6){var y=r.fromArray(e,p,C);if(t.normal||t.tangent||t.binormal){var _=r.fromArray(e,(p+6)%a,B);if(f){var v=r.fromArray(e,(p+3)%a,G);r.subtract(_,y,_),r.subtract(v,y,v),E=r.normalize(r.cross(v,_,E),E),f=!1}r.equalsEpsilon(_,y,m.EPSILON10)&&(f=!0),(t.tangent||t.binormal)&&(d=n.geodeticSurfaceNormal(y,d),t.tangent&&(h=r.normalize(r.cross(d,E,h),h))),t.normal&&(i[s++]=E.x,i[s++]=E.y,i[s++]=E.z,i[s++]=E.x,i[s++]=E.y,i[s++]=E.z),t.tangent&&(o[c++]=h.x,o[c++]=h.y,o[c++]=h.z,o[c++]=h.x,o[c++]=h.y,o[c++]=h.z),t.binormal&&(u[l++]=d.x,u[l++]=d.y,u[l++]=d.z,u[l++]=d.x,u[l++]=d.y,u[l++]=d.z)}}return g(t,{positions:e,normals:i,tangents:o,binormals:u})}function I(e){for(var t=e.vertexFormat,r=e.ellipsoid,n=e.size,i=e.height,o=e.width,u=t.position?new Float64Array(3*n):void 0,s=t.st?new Float32Array(2*n):void 0,c=0,f=0,d=C,h=b,m=Number.MAX_VALUE,p=Number.MAX_VALUE,y=Number.MIN_VALUE,_=Number.MIN_VALUE,v=0;i>v;++v)for(var T=0;o>T;++T)A.computePosition(e,v,T,d,h),u[c++]=d.x,u[c++]=d.y,u[c++]=d.z,t.st&&(s[f++]=h.x,s[f++]=h.y,m=Math.min(m,h.x),p=Math.min(p,h.y),y=Math.max(y,h.x),_=Math.max(_,h.y));if(t.st&&(0>m||0>p||y>1||_>1))for(var R=0;R<s.length;R+=2)s[R]=(s[R]-m)/(y-m),s[R+1]=(s[R+1]-p)/(_-p);for(var S=N(u,t,r,e.tangentRotationMatrix),g=6*(o-1)*(i-1),O=E.createTypedArray(n,g),I=0,M=0,w=0;i-1>w;++w){for(var x=0;o-1>x;++x){var P=I,D=P+o,L=D+1,U=P+1;O[M++]=P,O[M++]=D,O[M++]=U,O[M++]=U,O[M++]=D,O[M++]=L,++I}++I}return S.indices=O,t.st&&(S.attributes.st=new l({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:s})),S}function M(e,t,r,n,a){return e[t++]=n[r],e[t++]=n[r+1],e[t++]=n[r+2],e[t++]=a[r],e[t++]=a[r+1],e[t++]=a[r+2],e}function w(e,t,r,n){return e[t++]=n[r],e[t++]=n[r+1],e[t++]=n[r],e[t++]=n[r+1],e}function x(e){var t,n=e.vertexFormat,i=e.surfaceHeight,o=e.extrudedHeight,u=Math.min(o,i),s=Math.max(o,i),c=e.height,f=e.width,p=e.ellipsoid,y=I(e);if(m.equalsEpsilon(u,s,m.EPSILON10))return y;y=_.scaleToGeodeticHeight(y,s,p,!1);var v=new Float64Array(y.attributes.position.values),T=v.length,R=2*T,A=new Float64Array(R);A.set(v),y=_.scaleToGeodeticHeight(y,u,p);var S=y.attributes.position.values;A.set(S,T),y.attributes.position.values=A;var g,N=n.normal?new Float32Array(R):void 0,x=n.tangent?new Float32Array(R):void 0,C=n.binormal?new Float32Array(R):void 0,P=n.st?new Float32Array(R/3*2):void 0;if(n.normal){var D=y.attributes.normal.values;for(N.set(D),t=0;T>t;t++)D[t]=-D[t];N.set(D,T),y.attributes.normal.values=N}if(n.tangent){var L=y.attributes.tangent.values;for(x.set(L),t=0;T>t;t++)L[t]=-L[t];x.set(L,T),y.attributes.tangent.values=x}if(n.binormal){var U=y.attributes.binormal.values;C.set(U),C.set(U,T),y.attributes.binormal.values=C}n.st&&(g=y.attributes.st.values,P.set(g),P.set(g,T/3*2),y.attributes.st.values=P);var b=y.indices,F=b.length,z=T/3,q=E.createTypedArray(R/3,2*F);for(q.set(b),t=0;F>t;t+=3)q[t+F]=b[t+2]+z,q[t+1+F]=b[t+1]+z,q[t+2+F]=b[t]+z;y.indices=q;var W=2*f+2*c-4,H=2*(W+4),X=new Float64Array(3*H),V=n.st?new Float32Array(2*H):void 0,Y=0,k=0,j=f*c;for(t=0;j>t;t+=f)X=M(X,Y,3*t,v,S),Y+=6,n.st&&(V=w(V,k,2*t,g),k+=4);for(t=j-f;j>t;t++)X=M(X,Y,3*t,v,S),Y+=6,n.st&&(V=w(V,k,2*t,g),k+=4);for(t=j-1;t>0;t-=f)X=M(X,Y,3*t,v,S),Y+=6,n.st&&(V=w(V,k,2*t,g),k+=4);for(t=f-1;t>=0;t--)X=M(X,Y,3*t,v,S),Y+=6,n.st&&(V=w(V,k,2*t,g),k+=4);var Z=O(X,n,p);n.st&&(Z.attributes.st=new l({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:V}));var K,J,Q,$,ee=E.createTypedArray(H,6*W);T=X.length/3;var te=0;for(t=0;T-1>t;t+=2){K=t,$=(K+2)%T;var re=r.fromArray(X,3*K,B),ne=r.fromArray(X,3*$,G);r.equalsEpsilon(re,ne,m.EPSILON10)||(J=(K+1)%T,Q=(J+2)%T,ee[te++]=K,ee[te++]=J,ee[te++]=$,ee[te++]=$,ee[te++]=J,ee[te++]=Q)}return Z.indices=ee,Z=h.combineInstances([new d({geometry:y}),new d({geometry:Z})]),Z[0]}var C=new r,P=new r,D=new r,L=new r,U=new R,b=new t,F=new e,z=new e,B=new r,G=new r,q=function(e){e=i(e,i.EMPTY_OBJECT);var t=e.rectangle,r=i(e.granularity,m.RADIANS_PER_DEGREE),n=i(e.ellipsoid,s.WGS84),a=i(e.height,0),u=i(e.rotation,0),c=i(e.stRotation,0),l=i(e.vertexFormat,S.DEFAULT),f=e.extrudedHeight,d=o(f),h=i(e.closeTop,!0),E=i(e.closeBottom,!0);this._rectangle=t,this._granularity=r,this._ellipsoid=s.clone(n),this._surfaceHeight=a,this._rotation=u,this._stRotation=c,this._vertexFormat=S.clone(l),this._extrudedHeight=i(f,0),this._extrude=d,this._closeTop=h,this._closeBottom=E,this._workerName="createRectangleGeometry"};q.packedLength=R.packedLength+s.packedLength+S.packedLength+8,q.pack=function(e,t,r){r=i(r,0),R.pack(e._rectangle,t,r),r+=R.packedLength,s.pack(e._ellipsoid,t,r),r+=s.packedLength,S.pack(e._vertexFormat,t,r),r+=S.packedLength,t[r++]=e._granularity,t[r++]=e._surfaceHeight,t[r++]=e._rotation,t[r++]=e._stRotation,t[r++]=e._extrudedHeight,t[r++]=e._extrude?1:0,t[r++]=e._closeTop?1:0,t[r]=e._closeBottom?1:0};var W=new R,H=s.clone(s.UNIT_SPHERE),X=new S,V={rectangle:W,ellipsoid:H,vertexFormat:X,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,closeTop:void 0,closeBottom:void 0};q.unpack=function(e,t,r){t=i(t,0);var n=R.unpack(e,t,W);t+=R.packedLength;var a=s.unpack(e,t,H);t+=s.packedLength;var u=S.unpack(e,t,X);t+=S.packedLength;var c=e[t++],l=e[t++],f=e[t++],d=e[t++],h=e[t++],E=1===e[t++],m=1===e[t++],p=1===e[t];return o(r)?(r._rectangle=R.clone(n,r._rectangle),r._ellipsoid=s.clone(a,r._ellipsoid),r._vertexFormat=S.clone(u,r._vertexFormat),r._granularity=c,r._surfaceHeight=l,r._rotation=f,r._stRotation=d,r._extrudedHeight=E?h:void 0,r._extrude=E,r._closeTop=m,r._closeBottom=p,r):(V.granularity=c,V.height=l,V.rotation=f,V.stRotation=d,V.extrudedHeight=E?h:void 0,V.closeTop=m,V.closeBottom=p,new q(V))};var Y=new p,k=new y,j=new n,Z=new T,K=new n;return q.createGeometry=function(t){var n=R.clone(t._rectangle,U),a=t._ellipsoid,i=t._surfaceHeight,u=t._extrude,s=t._extrudedHeight,l=t._stRotation,d=t._vertexFormat,h=A.computeOptions(t,n,j),E=Y,m=k;if(o(l)){p.fromRotation(-l,E);var v=R.center(n,K),S=a.cartographicToCartesian(v,B);r.normalize(S,S),T.fromAxisAngle(S,-l,Z),y.fromQuaternion(Z,m)}else p.clone(p.IDENTITY,E),y.clone(y.IDENTITY,m);h.lonScalar=1/n.width,h.latScalar=1/n.height,h.vertexFormat=d,h.textureMatrix=E,h.tangentRotationMatrix=m,h.size=h.width*h.height;var g,N;if(n=t._rectangle,u){g=x(h);var O=e.fromRectangle3D(n,a,i,z),M=e.fromRectangle3D(n,a,s,F);N=e.union(O,M)}else g=I(h),g=_.scaleToGeodeticHeight(g,i,a,!1),N=e.fromRectangle3D(n,a,i);return d.position||delete g.attributes.position,new c({attributes:new f(g.attributes),indices:g.indices,primitiveType:g.primitiveType,boundingSphere:N})},q.createShadowVolume=function(e,t,r){var n=e._granularity,a=e._ellipsoid,i=t(n,a),o=r(n,a);return new q({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:a,stRotation:e._stRotation,granularity:n,extrudedHeight:o,height:i,closeTop:!0,closeBottom:!0,vertexFormat:S.POSITION_ONLY})},q}),define("Workers/createRectangleGeometry",["../Core/defined","../Core/Ellipsoid","../Core/Rectangle","../Core/RectangleGeometry"],function(e,t,r,n){"use strict";function a(a,i){return e(i)&&(a=n.unpack(a,i)),a._ellipsoid=t.clone(a._ellipsoid),a._rectangle=r.clone(a._rectangle),n.createGeometry(a)}return a})}();