/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var o={};o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=function(e){return e>0?1:0>e?-1:0},o.signNotZero=function(e){return 0>e?-1:1},o.toSNorm=function(e){return Math.round(255*(.5*o.clamp(e,-1,1)+.5))},o.fromSNorm=function(e){return o.clamp(e,0,255)/255*2-1},o.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},o.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},o.lerp=function(e,t,r){return(1-r)*e+r*t},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=.5*Math.PI,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI*.5,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(e){return e*o.RADIANS_PER_DEGREE},o.toDegrees=function(e){return e*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(e){var t=o.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},o.negativePiToPi=function(e){return o.zeroToTwoPi(e+o.PI)-o.PI},o.zeroToTwoPi=function(e){var t=o.mod(e,o.TWO_PI);return Math.abs(t)<o.EPSILON14&&Math.abs(e)>o.EPSILON14?o.TWO_PI:t},o.mod=function(e,t){return(e%t+t)%t},o.equalsEpsilon=function(e,r,n,o){o=t(o,n);var i=Math.abs(e-r);return o>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var i=[1];o.factorial=function(e){var t=i.length;if(e>=t)for(var r=i[t-1],n=t;e>=n;n++)i.push(r*n);return i[e]},o.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},o.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},o.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},o.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new e;return o.setRandomNumberSeed=function(t){a=new e(t)},o.nextRandomNumber=function(){return a.random()},o.acosClamped=function(e){return Math.acos(o.clamp(e,-1,1))},o.asinClamped=function(e){return Math.asin(o.clamp(e,-1,1))},o.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},o}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var o=r.clock,a=r.cone,u=e(r.magnitude,1),s=u*Math.sin(a);return n.x=s*Math.cos(o),n.y=s*Math.sin(o),n.z=u*Math.cos(a),n},i.fromElements=function(e,r,n,o){return t(o)?(o.x=e,o.y=r,o.z=n,o):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)&&o.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,o=e.y,i=e.z,a=t.x,u=t.y,s=t.z,c=o*s-i*u,l=i*a-n*s,E=n*u-o*a;return r.x=c,r.y=l,r.z=E,r},i.fromDegrees=function(e,t,r,n,a){var u=o.toRadians(e),s=o.toRadians(t);return i.fromRadians(u,s,r,n,a)};var E=new i,f=new i,h=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,o,a,u){o=e(o,0);var s=t(a)?a.radiiSquared:h,c=Math.cos(n);E.x=c*Math.cos(r),E.y=c*Math.sin(r),E.z=Math.sin(n),E=i.normalize(E,E),i.multiplyComponents(s,E,f);var l=Math.sqrt(i.dot(E,f));return f=i.divideByScalar(f,l,f),E=i.multiplyByScalar(E,o,E),t(u)||(u=new i),i.add(f,E,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),a=0;a<e.length;a++)n[a]=o.toRadians(e[a]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var o=e.length;t(n)?n.length=o/2:n=new Array(o/2);for(var a=0;o>a;a+=2){var u=e[a],s=e[a+1];n[a/2]=i.fromRadians(u,s,0,r,n[a/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),a=0;a<e.length;a+=3)n[a]=o.toRadians(e[a]),n[a+1]=o.toRadians(e[a+1]),n[a+2]=e[a+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var o=e.length;t(n)?n.length=o/3:n=new Array(o/3);for(var a=0;o>a;a+=3){var u=e[a],s=e[a+1],c=e[a+2];n[a/3]=i.fromRadians(u,s,c,r,n[a/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return i.fromRadians=function(r,n,o,a){return o=e(o,0),t(a)?(a.longitude=r,a.latitude=n,a.height=o,a):new i(r,n,o)},i.fromDegrees=function(e,t,r,n){return e=o.toRadians(e),t=o.toRadians(t),i.fromRadians(e,t,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var r={},n=function(t,n){e(r[t])||(r[t]=!0,console.log(n))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i,a,u){"use strict";function s(t,n,o,i){n=r(n,0),o=r(o,0),i=r(i,0),t._radii=new e(n,o,i),t._radiiSquared=new e(n*n,o*o,i*i),t._radiiToTheFourth=new e(n*n*n*n,o*o*o*o,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===o?0:1/o,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===o?0:1/(o*o),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,o,i),t._maximumRadius=Math.max(n,o,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,r)};o(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var o=t._radii;return n(r)?(e.clone(o,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(o.x,o.y,o.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=a(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=a(new c(1,1,1)),c.MOON=a(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,o){o=r(o,0),e.pack(t._radii,n,o)},c.unpack=function(t,n,o){n=r(n,0);var i=e.unpack(t,n);return c.fromCartesian3(i,o)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var o=t.longitude,i=t.latitude,a=Math.cos(i),u=a*Math.cos(o),s=a*Math.sin(o),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,E=new e;c.prototype.cartographicToCartesian=function(t,r){var o=l,i=E;this.geodeticSurfaceNormalCartographic(t,o),e.multiplyComponents(this._radiiSquared,o,i);var a=Math.sqrt(e.dot(o,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(o,t.height,o),n(r)||(r=new e),e.add(i,o,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var o=0;r>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var f=new e,h=new e,m=new e;c.prototype.cartesianToCartographic=function(r,o){var i=this.scaleToGeodeticSurface(r,h);if(!n(i))return void 0;var a=this.geodeticSurfaceNormal(i,f),s=e.subtract(r,i,m),c=Math.atan2(a.y,a.x),l=Math.asin(a.z),E=u.sign(e.dot(s,r))*e.magnitude(s);return n(o)?(o.longitude=c,o.latitude=l,o.height=E,o):new t(c,l,E)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var o=0;r>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var d=new e,p=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var o=t.x,i=t.y,a=t.z,s=this._oneOverRadii,c=s.x,l=s.y,E=s.z,f=o*o*c*c,h=i*i*l*l,m=a*a*E*E,T=f+h+m,R=Math.sqrt(1/T),A=e.multiplyByScalar(t,R,d);if(T<this._centerToleranceSquared)return isFinite(R)?e.clone(A,r):void 0;var _=this._oneOverRadiiSquared,v=_.x,y=_.y,S=_.z,C=p;C.x=A.x*v*2,C.y=A.y*y*2,C.z=A.z*S*2;var N,I,g,O,M,L,F,P,w,D,b,U=(1-R)*e.magnitude(t)/(.5*e.magnitude(C)),x=0;do{U-=x,g=1/(1+U*v),O=1/(1+U*y),M=1/(1+U*S),L=g*g,F=O*O,P=M*M,w=L*g,D=F*O,b=P*M,N=f*L+h*F+m*P-1,I=f*w*v+h*D*y+m*b*S;var B=-2*I;x=N/B}while(Math.abs(N)>u.EPSILON12);return n(r)?(r.x=o*g,r.y=i*O,r.z=a*M,r):new e(o*g,i*O,a*M)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var o=t.x,i=t.y,a=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(o*o*u.x+i*i*u.y+a*a*u.z);return e.multiplyByScalar(t,s,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,i,a){"use strict";var u=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,u=t.height;return n(r)?(r.x=i,r.y=a,r.z=u,r):new e(i,a,u)},u.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,i=e.x*o,a=e.y*o,u=e.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=u,r):new t(i,a,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n,o){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(o,0)};i.fromElements=function(e,r,n,o,a){return t(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new i(e,r,n,o)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)&&o.equalsEpsilon(e.z,r.z,n,i)&&o.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function u(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(h[r],f[r])];t+=2*n*n}return Math.sqrt(t)}function s(e,t){for(var r=i.EPSILON15,n=0,o=1,a=0;3>a;++a){var u=Math.abs(e[c.getElementIndex(h[a],f[a])]);u>n&&(o=a,n=u)}var s=1,l=0,E=f[o],m=h[o];if(Math.abs(e[c.getElementIndex(m,E)])>r){var d,p=e[c.getElementIndex(m,m)],T=e[c.getElementIndex(E,E)],R=e[c.getElementIndex(m,E)],A=(p-T)/2/R;d=0>A?-1/(-A+Math.sqrt(1+A*A)):1/(A+Math.sqrt(1+A*A)),s=1/Math.sqrt(1+d*d),l=d*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(E,E)]=t[c.getElementIndex(m,m)]=s,t[c.getElementIndex(m,E)]=l,t[c.getElementIndex(E,m)]=-l,t}var c=function(e,r,n,o,i,a,u,s,c){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new c),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,o){return n=t(n,0),r(o)||(o=new c),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,o=e.x*e.y,i=e.x*e.z,a=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,E=e.z*e.z,f=e.z*e.w,h=e.w*e.w,m=n-u-E+h,d=2*(o-f),p=2*(i+l),T=2*(o+f),R=-n+u-E+h,A=2*(s-a),_=2*(i-l),v=2*(s+a),y=-n-u+E+h;return r(t)?(t[0]=m,t[1]=T,t[2]=_,t[3]=d,t[4]=R,t[5]=v,t[6]=p,t[7]=A,t[8]=y,t):new c(m,d,p,T,R,A,_,v,y)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=o,t[6]=0,t[7]=-o,t[8]=n,t):new c(1,0,0,0,n,-o,0,o,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-o,t[3]=0,t[4]=1,t[5]=0,t[6]=o,t[7]=0,t[8]=n,t):new c(n,0,o,0,1,0,-o,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=o,t[2]=0,t[3]=-o,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-o,0,o,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,o=e[n],i=e[n+1],a=e[n+2];return r.x=o,r.y=i,r.z=a,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=3*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},c.getRow=function(e,t,r){var n=e[t],o=e[t+3],i=e[t+6];return r.x=n,r.y=o,r.z=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],a=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],E=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=E,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[3]*o+e[6]*i,u=e[1]*n+e[4]*o+e[7]*i,s=e[2]*n+e[5]*o+e[8]*i;return r.x=a,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=o,t[3]=i,t[4]=a,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var f=[1,0,0],h=[2,2,1],m=new c,d=new c;return c.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,o=10,l=0,E=0;r(t)||(t={});for(var f=t.unitary=c.clone(c.IDENTITY,t.unitary),h=t.diagonal=c.clone(e,t.diagonal),p=n*a(h);o>E&&u(h)>p;)s(h,m),c.transpose(m,d),c.multiply(h,m,h),c.multiply(d,h,h),c.multiply(f,m,f),++l>2&&(++E,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],o=e[1],i=e[4],a=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*a)+o*(s*n-r*c)+u*(r*a-i*n)},c.inverse=function(e,t){var r=e[0],o=e[1],a=e[2],u=e[3],s=e[4],l=e[5],E=e[6],f=e[7],h=e[8],m=c.determinant(e);if(Math.abs(m)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=s*h-f*l,t[1]=f*a-o*h,t[2]=o*l-s*a,t[3]=E*l-u*h,t[4]=r*h-E*a,t[5]=u*a-r*l,t[6]=u*f-E*s,t[7]=E*o-r*f,t[8]=r*s-u*o;var d=1/m;return c.multiplyByScalar(t,d,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=o(new c(1,0,0,0,1,0,0,0,1)),c.ZERO=o(new c(0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,i,a,u,s){"use strict";var c=function(e,t,n,o,i,a,u,s,c,l,E,f,h,m,d,p){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(h,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(l,0),this[7]=r(m,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(E,0),this[11]=r(d,0),this[12]=r(o,0),this[13]=r(s,0),this[14]=r(f,0),this[15]=r(p,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new c),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,o,i){return o=r(o,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=o.x,i[13]=o.y,i[14]=o.z,i[15]=1,i):new c(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,o){n(o)||(o=new c);var i=r.x,a=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,E=t.x*t.z,f=t.x*t.w,h=t.y*t.y,m=t.y*t.z,d=t.y*t.w,p=t.z*t.z,T=t.z*t.w,R=t.w*t.w,A=s-h-p+R,_=2*(l-T),v=2*(E+d),y=2*(l+T),S=-s+h-p+R,C=2*(m-f),N=2*(E-d),I=2*(m+f),g=-s-h+p+R;return o[0]=A*i,o[1]=y*i,o[2]=N*i,o[3]=0,o[4]=_*a,o[5]=S*a,o[6]=I*a,o[7]=0,o[8]=v*u,o[9]=C*u,o[10]=g*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,E=new e,f=new e;c.fromCamera=function(t,r){var o=t.eye,i=t.target,a=t.up;e.normalize(e.subtract(i,o,l),l),e.normalize(e.cross(l,a,E),E),e.normalize(e.cross(E,l,f),f);var u=E.x,s=E.y,h=E.z,m=l.x,d=l.y,p=l.z,T=f.x,R=f.y,A=f.z,_=o.x,v=o.y,y=o.z,S=u*-_+s*-v+h*-y,C=T*-_+R*-v+A*-y,N=m*_+d*v+p*y;return n(r)?(r[0]=u,r[1]=T,r[2]=-m,r[3]=0,r[4]=s,r[5]=R,r[6]=-d,r[7]=0,r[8]=h,r[9]=A,r[10]=-p,r[11]=0,r[12]=S,r[13]=C,r[14]=N,r[15]=1,r):new c(u,s,h,S,T,R,A,C,-m,-d,-p,N,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,o){var i=Math.tan(.5*e),a=1/i,u=a/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},c.computeOrthographicOffCenter=function(e,t,r,n,o,i,a){var u=1/(t-e),s=1/(n-r),c=1/(i-o),l=-(t+e)*u,E=-(n+r)*s,f=-(i+o)*c;return u*=2,s*=2,c*=-2,a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=0,a[12]=l,a[13]=E,a[14]=f,a[15]=1,
a},c.computePerspectiveOffCenter=function(e,t,r,n,o,i,a){var u=2*o/(t-e),s=2*o/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),E=-(i+o)/(i-o),f=-1,h=-2*i*o/(i-o);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=l,a[10]=E,a[11]=f,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,o,i){var a=2*o/(t-e),u=2*o/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,E=-1,f=-2*o;return i[0]=a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=E,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,o){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),a=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,E=.5*(n-t),f=c,h=l,m=E,d=i+c,p=a+l,T=t+E,R=1;return o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=h,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=m,o[11]=0,o[12]=d,o[13]=p,o[14]=T,o[15]=R,o},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,o=e[n],i=e[n+1],a=e[n+2],u=e[n+3];return r.x=o,r.y=i,r.z=a,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=4*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},c.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},c.getRow=function(e,t,r){var n=e[t],o=e[t+4],i=e[t+8],a=e[t+12];return r.x=n,r.y=o,r.z=i,r.w=a,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var h=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),r};var m=new e;c.getMaximumScale=function(t){return c.getScale(t,m),e.maximumComponent(m)},c.multiply=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[3],u=e[4],s=e[5],c=e[6],l=e[7],E=e[8],f=e[9],h=e[10],m=e[11],d=e[12],p=e[13],T=e[14],R=e[15],A=t[0],_=t[1],v=t[2],y=t[3],S=t[4],C=t[5],N=t[6],I=t[7],g=t[8],O=t[9],M=t[10],L=t[11],F=t[12],P=t[13],w=t[14],D=t[15],b=n*A+u*_+E*v+d*y,U=o*A+s*_+f*v+p*y,x=i*A+c*_+h*v+T*y,B=a*A+l*_+m*v+R*y,G=n*S+u*C+E*N+d*I,z=o*S+s*C+f*N+p*I,V=i*S+c*C+h*N+T*I,H=a*S+l*C+m*N+R*I,W=n*g+u*O+E*M+d*L,Y=o*g+s*O+f*M+p*L,q=i*g+c*O+h*M+T*L,X=a*g+l*O+m*M+R*L,k=n*F+u*P+E*w+d*D,K=o*F+s*P+f*w+p*D,Z=i*F+c*P+h*w+T*D,j=a*F+l*P+m*w+R*D;return r[0]=b,r[1]=U,r[2]=x,r[3]=B,r[4]=G,r[5]=z,r[6]=V,r[7]=H,r[8]=W,r[9]=Y,r[10]=q,r[11]=X,r[12]=k,r[13]=K,r[14]=Z,r[15]=j,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=e[12],h=e[13],m=e[14],d=t[0],p=t[1],T=t[2],R=t[4],A=t[5],_=t[6],v=t[8],y=t[9],S=t[10],C=t[12],N=t[13],I=t[14],g=n*d+a*p+c*T,O=o*d+u*p+l*T,M=i*d+s*p+E*T,L=n*R+a*A+c*_,F=o*R+u*A+l*_,P=i*R+s*A+E*_,w=n*v+a*y+c*S,D=o*v+u*y+l*S,b=i*v+s*y+E*S,U=n*C+a*N+c*I+f,x=o*C+u*N+l*I+h,B=i*C+s*N+E*I+m;return r[0]=g,r[1]=O,r[2]=M,r[3]=0,r[4]=L,r[5]=F,r[6]=P,r[7]=0,r[8]=w,r[9]=D,r[10]=b,r[11]=0,r[12]=U,r[13]=x,r[14]=B,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=t[0],h=t[1],m=t[2],d=t[3],p=t[4],T=t[5],R=t[6],A=t[7],_=t[8],v=n*f+a*h+c*m,y=o*f+u*h+l*m,S=i*f+s*h+E*m,C=n*d+a*p+c*T,N=o*d+u*p+l*T,I=i*d+s*p+E*T,g=n*R+a*A+c*_,O=o*R+u*A+l*_,M=i*R+s*A+E*_;return r[0]=v,r[1]=y,r[2]=S,r[3]=0,r[4]=C,r[5]=N,r[6]=I,r[7]=0,r[8]=g,r[9]=O,r[10]=M,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=n*e[0]+o*e[4]+i*e[8]+e[12],u=n*e[1]+o*e[5]+i*e[9]+e[13],s=n*e[2]+o*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=a,r[13]=u,r[14]=s,r[15]=e[15],r};var d=new e;c.multiplyByUniformScale=function(e,t,r){return d.x=t,d.y=t,d.z=t,c.multiplyByScale(e,d,r)},c.multiplyByScale=function(e,t,r){var n=t.x,o=t.y,i=t.z;return 1===n&&1===o&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=t.w,u=e[0]*n+e[4]*o+e[8]*i+e[12]*a,s=e[1]*n+e[5]*o+e[9]*i+e[13]*a,c=e[2]*n+e[6]*o+e[10]*i+e[14]*a,l=e[3]*n+e[7]*o+e[11]*i+e[15]*a;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[4]*o+e[8]*i,u=e[1]*n+e[5]*o+e[9]*i,s=e[2]*n+e[6]*o+e[10]*i;return r.x=a,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[4]*o+e[8]*i+e[12],u=e[1]*n+e[5]*o+e[9]*i+e[13],s=e[2]*n+e[6]*o+e[10]*i+e[14];return r.x=a,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],o=e[3],i=e[6],a=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=a,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var p=new u,T=new u,R=new t,A=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,p),T,a.EPSILON7)&&t.equals(c.getRow(e,3,R),A))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],o=e[4],i=e[8],l=e[12],E=e[1],f=e[5],h=e[9],m=e[13],d=e[2],_=e[6],v=e[10],y=e[14],S=e[3],C=e[7],N=e[11],I=e[15],g=v*I,O=y*N,M=_*I,L=y*C,F=_*N,P=v*C,w=d*I,D=y*S,b=d*N,U=v*S,x=d*C,B=_*S,G=g*f+L*h+F*m-(O*f+M*h+P*m),z=O*E+w*h+U*m-(g*E+D*h+b*m),V=M*E+D*f+x*m-(L*E+w*f+B*m),H=P*E+b*f+B*h-(F*E+U*f+x*h),W=O*o+M*i+P*l-(g*o+L*i+F*l),Y=g*n+D*i+b*l-(O*n+w*i+U*l),q=L*n+w*o+B*l-(M*n+D*o+x*l),X=F*n+U*o+x*i-(P*n+b*o+B*i);g=i*m,O=l*h,M=o*m,L=l*f,F=o*h,P=i*f,w=n*m,D=l*E,b=n*h,U=i*E,x=n*f,B=o*E;var k=g*C+L*N+F*I-(O*C+M*N+P*I),K=O*S+w*N+U*I-(g*S+D*N+b*I),Z=M*S+D*C+x*I-(L*S+w*C+B*I),j=P*S+b*C+B*N-(F*S+U*C+x*N),Q=M*v+P*y+O*_-(F*y+g*_+L*v),J=b*y+g*d+D*v-(w*v+U*y+O*d),$=w*_+B*y+L*d-(x*y+M*d+D*_),ee=x*v+F*d+U*_-(b*_+B*v+P*d),te=n*G+o*z+i*V+l*H;if(Math.abs(te)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=G*te,r[1]=z*te,r[2]=V*te,r[3]=H*te,r[4]=W*te,r[5]=Y*te,r[6]=q*te,r[7]=X*te,r[8]=k*te,r[9]=K*te,r[10]=Z*te,r[11]=j*te,r[12]=Q*te,r[13]=J*te,r[14]=$*te,r[15]=ee*te,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],o=e[2],i=e[4],a=e[5],u=e[6],s=e[8],c=e[9],l=e[10],E=e[12],f=e[13],h=e[14],m=-r*E-n*f-o*h,d=-i*E-a*f-u*h,p=-s*E-c*f-l*h;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=a,t[6]=c,t[7]=0,t[8]=o,t[9]=u,t[10]=l,t[11]=0,t[12]=m,t[13]=d,t[14]=p,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var o=function(t,r){this.normal=e.clone(t),this.distance=r};o.fromPointNormal=function(r,n,i){var a=-e.dot(n,r);return t(i)?(e.clone(n,i.normal),i.distance=a,i):new o(n,a)};var i=new e;return o.fromCartesian4=function(r,n){var a=e.fromCartesian4(r,i),u=r.w;return t(n)?(e.clone(a,n.normal),n.distance=u,n):new o(a,u)},o.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},o.ORIGIN_XY_PLANE=n(new o(e.UNIT_Z,0)),o.ORIGIN_YZ_PLANE=n(new o(e.UNIT_X,0)),o.ORIGIN_ZX_PLANE=n(new o(e.UNIT_Y,0)),o}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,i,a,u){"use strict";var s=function(e,r,n,o){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(o,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,o,i,a){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),o=u.toRadians(t(o,0)),i=u.toRadians(t(i,0)),r(a)?(a.west=e,a.south=n,a.east=o,a.north=i,a):new s(e,n,o,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,a=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];n=Math.min(n,l.longitude),o=Math.max(o,l.longitude),i=Math.min(i,l.latitude),a=Math.max(a,l.latitude)}return r(t)?(t.west=n,t.south=i,t.east=o,t.north=a,t):new s(n,i,o,a)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var o=t.east,i=t.west;i>o&&(o+=u.TWO_PI);var a=u.negativePiToPi(.5*(i+o)),s=.5*(t.south+t.north);return r(n)?(n.longitude=a,n.latitude=s,n.height=0,n):new e(a,s)},s.intersection=function(e,t,n){var o=e.east,i=e.west,a=t.east,c=t.west;i>o&&a>0?o+=u.TWO_PI:c>a&&o>0&&(a+=u.TWO_PI),i>o&&0>c?c+=u.TWO_PI:c>a&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),E=u.negativePiToPi(Math.min(o,a));if((e.west<e.east||t.west<t.east)&&l>=E)return void 0;var f=Math.max(e.south,t.south),h=Math.min(e.north,t.north);return f>=h?void 0:r(n)?(n.west=l,n.south=f,n.east=E,n.north=h,n):new s(l,f,E,h)},s.contains=function(e,t){var r=t.longitude,n=t.latitude,o=e.west,i=e.east;return o>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>o||u.equalsEpsilon(r,o,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,o,a){n=t(n,i.WGS84),o=t(o,0),r(a)||(a=[]);var l=0,E=e.north,f=e.south,h=e.east,m=e.west,d=c;d.height=o,d.longitude=m,d.latitude=E,a[l]=n.cartographicToCartesian(d,a[l]),l++,d.longitude=h,a[l]=n.cartographicToCartesian(d,a[l]),l++,d.latitude=f,a[l]=n.cartographicToCartesian(d,a[l]),l++,d.longitude=m,a[l]=n.cartographicToCartesian(d,a[l]),l++,0>E?d.latitude=E:f>0?d.latitude=f:d.latitude=0;for(var p=1;8>p;++p)d.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,d)&&(a[l]=n.cartographicToCartesian(d,a[l]),l++);return 0===d.latitude&&(d.longitude=m,a[l]=n.cartographicToCartesian(d,a[l]),l++,d.longitude=h,a[l]=n.cartographicToCartesian(d,a[l]),l++),a.length=l,a},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,r,n,o,i,a,u,s,c,l,E,f){"use strict";var h=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},m=new e,d=new e,p=new e,T=new e,R=new e,A=new e,_=new e,v=new e,y=new e,S=new e,C=new e,N=new e;h.fromPoints=function(t,r){if(n(r)||(r=new h),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var o=e.clone(t[0],_),i=e.clone(o,m),a=e.clone(o,d),u=e.clone(o,p),s=e.clone(o,T),c=e.clone(o,R),l=e.clone(o,A),E=t.length,f=1;E>f;f++){e.clone(t[f],o);var I=o.x,g=o.y,O=o.z;I<i.x&&e.clone(o,i),I>s.x&&e.clone(o,s),g<a.y&&e.clone(o,a),g>c.y&&e.clone(o,c),O<u.z&&e.clone(o,u),O>l.z&&e.clone(o,l)}var M=e.magnitudeSquared(e.subtract(s,i,v)),L=e.magnitudeSquared(e.subtract(c,a,v)),F=e.magnitudeSquared(e.subtract(l,u,v)),P=i,w=s,D=M;L>D&&(D=L,P=a,w=c),F>D&&(D=F,P=u,w=l);var b=y;b.x=.5*(P.x+w.x),b.y=.5*(P.y+w.y),b.z=.5*(P.z+w.z);var U=e.magnitudeSquared(e.subtract(w,b,v)),x=Math.sqrt(U),B=S;B.x=i.x,B.y=a.y,B.z=u.z;var G=C;G.x=s.x,G.y=c.y,G.z=l.z;var z=e.multiplyByScalar(e.add(B,G,v),.5,N),V=0;for(f=0;E>f;f++){e.clone(t[f],o);var H=e.magnitude(e.subtract(o,z,v));H>V&&(V=H);var W=e.magnitudeSquared(e.subtract(o,b,v));if(W>U){var Y=Math.sqrt(W);x=.5*(x+Y),U=x*x;var q=Y-x;b.x=(x*b.x+q*o.x)/Y,b.y=(x*b.y+q*o.y)/Y,b.z=(x*b.z+q*o.z)/Y}}return V>x?(e.clone(b,r.center),r.radius=x):(e.clone(z,r.center),r.radius=V),r};var I=new u,g=new e,O=new e,M=new t,L=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,o,i,a,u){if(n(u)||(u=new h),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;o=r(o,I),f.southwest(t,M),M.height=i,f.northeast(t,L),L.height=a;var s=o.project(M,g),c=o.project(L,O),l=c.x-s.x,E=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(l*l+E*E+m*m);var d=u.center;return d.x=s.x+.5*l,d.y=s.y+.5*E,d.z=s.z+.5*m,u};var F=[];h.fromRectangle3D=function(e,t,o,i){t=r(t,a.WGS84),o=r(o,0);var u;return n(e)&&(u=f.subsample(e,t,o,F)),h.fromPoints(u,i)},h.fromVertices=function(t,o,i,a){if(n(a)||(a=new h),!n(t)||0===t.length)return a.center=e.clone(e.ZERO,a.center),a.radius=0,a;o=r(o,e.ZERO),i=r(i,3);var u=_;u.x=t[0]+o.x,u.y=t[1]+o.y,u.z=t[2]+o.z;for(var s=e.clone(u,m),c=e.clone(u,d),l=e.clone(u,p),E=e.clone(u,T),f=e.clone(u,R),I=e.clone(u,A),g=t.length,O=0;g>O;O+=i){var M=t[O]+o.x,L=t[O+1]+o.y,F=t[O+2]+o.z;u.x=M,u.y=L,u.z=F,M<s.x&&e.clone(u,s),M>E.x&&e.clone(u,E),L<c.y&&e.clone(u,c),L>f.y&&e.clone(u,f),F<l.z&&e.clone(u,l),F>I.z&&e.clone(u,I)}var P=e.magnitudeSquared(e.subtract(E,s,v)),w=e.magnitudeSquared(e.subtract(f,c,v)),D=e.magnitudeSquared(e.subtract(I,l,v)),b=s,U=E,x=P;w>x&&(x=w,b=c,U=f),D>x&&(x=D,b=l,U=I);var B=y;B.x=.5*(b.x+U.x),B.y=.5*(b.y+U.y),B.z=.5*(b.z+U.z);var G=e.magnitudeSquared(e.subtract(U,B,v)),z=Math.sqrt(G),V=S;V.x=s.x,V.y=c.y,V.z=l.z;var H=C;H.x=E.x,H.y=f.y,H.z=I.z;var W=e.multiplyByScalar(e.add(V,H,v),.5,N),Y=0;for(O=0;g>O;O+=i){u.x=t[O]+o.x,u.y=t[O+1]+o.y,u.z=t[O+2]+o.z;var q=e.magnitude(e.subtract(u,W,v));q>Y&&(Y=q);var X=e.magnitudeSquared(e.subtract(u,B,v));if(X>G){var k=Math.sqrt(X);z=.5*(z+k),G=z*z;var K=k-z;B.x=(z*B.x+K*u.x)/k,B.y=(z*B.y+K*u.y)/k,B.z=(z*B.z+K*u.z)/k}}return Y>z?(e.clone(B,a.center),a.radius=z):(e.clone(W,a.center),a.radius=Y),a},h.fromCornerPoints=function(t,r,o){n(o)||(o=new h);var i=o.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),o.radius=e.distance(i,r),o},h.fromEllipsoid=function(t,r){return n(r)||(r=new h),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var P=new e;h.fromBoundingSpheres=function(t,r){if(n(r)||(r=new h),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var o=t.length;if(1===o)return h.clone(t[0],r);if(2===o)return h.union(t[0],t[1],r);for(var i=[],a=0;o>a;a++)i.push(t[a].center);r=h.fromPoints(i,r);var u=r.center,s=r.radius;for(a=0;o>a;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r},h.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,n){n=r(n,0);var o=e.center;t[n++]=o.x,t[n++]=o.y,t[n++]=o.z,t[n]=e.radius},h.unpack=function(e,t,o){t=r(t,0),n(o)||(o=new h);var i=o.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],o.radius=e[t],o};var w=new e,D=new e;h.union=function(t,r,o){n(o)||(o=new h);var i=t.center,a=t.radius,u=r.center,s=r.radius,c=e.subtract(u,i,w),l=e.magnitude(c);if(a>=l+s)return t.clone(o),o;if(s>=l+a)return r.clone(o),o;var E=.5*(a+l+s),f=e.multiplyByScalar(c,(-a+E)/l,D);return e.add(f,i,f),e.clone(f,o.center),o.radius=E,o};var b=new e;h.expand=function(t,r,n){n=h.clone(t,n);var o=e.magnitude(e.subtract(r,n.center,b));return o>n.radius&&(n.radius=o),n},h.intersectPlane=function(t,r){var n=t.center,o=t.radius,i=r.normal,a=e.dot(i,n)+r.distance;return-o>a?s.OUTSIDE:o>a?s.INTERSECTING:s.INSIDE},h.transform=function(e,t,r){return n(r)||(r=new h),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var U=new e;h.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,U);return e.magnitudeSquared(n)-t.radius*t.radius},h.transformWithoutScale=function(e,t,r){return n(r)||(r=new h),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var x=new e;h.computePlaneDistances=function(t,r,o,i){n(i)||(i=new c);var a=e.subtract(t.center,r,x),u=e.dot(o,a);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var B=new e,G=new e,z=new e,V=new e,H=new e,W=new t,Y=new Array(8),q=0;8>q;++q)Y[q]=new e;var X=new u;return h.projectTo2D=function(t,n,o){n=r(n,X);var i=n.ellipsoid,a=t.center,u=t.radius,s=i.geodeticSurfaceNormal(a,B),c=e.cross(e.UNIT_Z,s,G);e.normalize(c,c);var l=e.cross(s,c,z);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var E=e.negate(l,H),f=e.negate(c,V),m=Y,d=m[0];e.add(s,l,d),e.add(d,c,d),d=m[1],e.add(s,l,d),e.add(d,f,d),d=m[2],e.add(s,E,d),e.add(d,f,d),d=m[3],e.add(s,E,d),e.add(d,c,d),e.negate(s,s),d=m[4],e.add(s,l,d),e.add(d,c,d),d=m[5],e.add(s,l,d),e.add(d,f,d),d=m[6],e.add(s,E,d),e.add(d,f,d),d=m[7],e.add(s,E,d),e.add(d,c,d);for(var p=m.length,T=0;p>T;++T){var R=m[T];e.add(a,R,R);var A=i.cartesianToCartographic(R,W);n.project(A,R)}o=h.fromPoints(m,o),a=o.center;var _=a.x,v=a.y,y=a.z;return a.x=y,a.y=_,a.z=v,o},h.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,u=i.length;u>a;++a){var s=i[a];o=s+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=s+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=s+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=s+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=s+"FullscreenEnabled",e(document[o])?n.fullscreenEnabled=o:(o=s+"FullScreenEnabled",e(document[o])&&(n.fullscreenEnabled=o)),o=s+"FullscreenElement",e(document[o])?n.fullscreenElement=o:(o=s+"FullScreenElement",e(document[o])&&(n.fullscreenElement=o)),o=s+"fullscreenchange",e(document["on"+o])&&("ms"===s&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=s+"fullscreenerror",e(document["on"+o])&&("ms"===s&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e){o.supportsFullscreen()&&e[n.requestFullscreen]()},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,T=n(e[1]))}return p}function i(){return o()&&T}function a(){if(!t(R)&&(R=!1,!o()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(R=!0,A=n(e[1]))}return R}function u(){return a()&&A}function s(){if(!t(_)){_=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(_=!0,v=n(e[1]),v.isNightly=!!e[2])}return _}function c(){return s()&&v}function l(){if(!t(y)){y=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(y=!0,S=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(y=!0,S=n(e[1])))}return y}function E(){return l()&&S}function f(){if(!t(C)){C=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(C=!0,N=n(e[1]))}return C}function h(){return t(I)||(I=/Windows/i.test(navigator.appVersion)),I}function m(){return f()&&N}function d(){return t(g)||(g=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),g}var p,T,R,A,_,v,y,S,C,N,I,g,O={isChrome:o,chromeVersion:i,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:E,isFirefox:f,firefoxVersion:m,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:d};return O.supportsFullscreen=function(){return r.supportsFullscreen()},O.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},O.supportsWebWorkers=function(){return"undefined"!=typeof Worker},O}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+(t-e)*(2/3-r)*6:e}var u=function(t,r,n,o){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(o,1)};u.fromCartesian4=function(e,r){return t(r)?(r.red=e.x,r.green=e.y,r.blue=e.z,r.alpha=e.w,r):new u(e.x,e.y,e.z,e.w)},u.fromBytes=function(r,n,o,i,a){return r=u.byteToFloat(e(r,255)),n=u.byteToFloat(e(n,255)),o=u.byteToFloat(e(o,255)),i=u.byteToFloat(e(i,255)),t(a)?(a.red=r,a.green=n,a.blue=o,a.alpha=i,a):new u(r,n,o,i)},u.fromAlpha=function(e,r,n){return t(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=r,n):new u(e.red,e.green,e.blue,r)};var s,c,l;n.supportsTypedArrays()&&(s=new ArrayBuffer(4),c=new Uint32Array(s),l=new Uint8Array(s)),u.fromRgba=function(e){return c[0]=e,u.fromBytes(l[0],l[1],l[2],l[3])},u.fromHsl=function(t,r,n,o){t=e(t,0)%1,r=e(r,0),n=e(n,0),o=e(o,1);var i=n,s=n,c=n;if(0!==r){var l;l=.5>n?n*(1+r):n+r-n*r;var E=2*n-l;i=a(E,l,t+1/3),s=a(E,l,t),c=a(E,l,t-1/3)}return new u(i,s,c,o)},u.fromRandom=function(r,n){r=e(r,e.EMPTY_OBJECT);var o=r.red;if(!t(o)){var a=e(r.minimumRed,0),s=e(r.maximumRed,1);o=a+i.nextRandomNumber()*(s-a)}var c=r.green;if(!t(c)){var l=e(r.minimumGreen,0),E=e(r.maximumGreen,1);c=l+i.nextRandomNumber()*(E-l)}var f=r.blue;if(!t(f)){var h=e(r.minimumBlue,0),m=e(r.maximumBlue,1);f=h+i.nextRandomNumber()*(m-h)}var d=r.alpha;if(!t(d)){var p=e(r.minimumAlpha,0),T=e(r.maximumAlpha,1);d=p+i.nextRandomNumber()*(T-p)}return t(n)?(n.red=o,n.green=c,n.blue=f,n.alpha=d,n):new u(o,c,f,d)};var E=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,f=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,m=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(r){var n=u[r.toUpperCase()];if(t(n))return u.clone(n);var o=E.exec(r);return null!==o?new u(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=f.exec(r),null!==o?new u(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=h.exec(r),null!==o?new u(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=m.exec(r),null!==o?u.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},u.packedLength=4,u.pack=function(t,r,n){n=e(n,0),r[n++]=t.red,r[n++]=t.green,r[n++]=t.blue,r[n]=t.alpha},u.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new u),o.red=r[n++],o.green=r[n++],o.blue=r[n++],o.alpha=r[n],o},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:256*e|0},u.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new u(e.red,e.green,e.blue,e.alpha):void 0},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},u.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),t=u.floatToByte(this.green),r=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},u.prototype.toBytes=function(e){var r=u.floatToByte(this.red),n=u.floatToByte(this.green),o=u.floatToByte(this.blue),i=u.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=o,e[3]=i,e):[r,n,o,i]},u.prototype.toRgba=function(){return l[0]=u.floatToByte(this.red),l[1]=u.floatToByte(this.green),l[2]=u.floatToByte(this.blue),l[3]=u.floatToByte(this.alpha),c[0]},u.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},u.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},u.prototype.withAlpha=function(e,t){return u.fromAlpha(this,e,t)},u.ALICEBLUE=o(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=o(u.fromCssColorString("#FAEBD7")),u.AQUA=o(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=o(u.fromCssColorString("#7FFFD4")),u.AZURE=o(u.fromCssColorString("#F0FFFF")),u.BEIGE=o(u.fromCssColorString("#F5F5DC")),u.BISQUE=o(u.fromCssColorString("#FFE4C4")),u.BLACK=o(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=o(u.fromCssColorString("#FFEBCD")),u.BLUE=o(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=o(u.fromCssColorString("#8A2BE2")),u.BROWN=o(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=o(u.fromCssColorString("#DEB887")),u.CADETBLUE=o(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=o(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=o(u.fromCssColorString("#D2691E")),u.CORAL=o(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=o(u.fromCssColorString("#6495ED")),u.CORNSILK=o(u.fromCssColorString("#FFF8DC")),u.CRIMSON=o(u.fromCssColorString("#DC143C")),u.CYAN=o(u.fromCssColorString("#00FFFF")),u.DARKBLUE=o(u.fromCssColorString("#00008B")),u.DARKCYAN=o(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=o(u.fromCssColorString("#B8860B")),u.DARKGRAY=o(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=o(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=o(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=o(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=o(u.fromCssColorString("#556B2F")),u.DARKORANGE=o(u.fromCssColorString("#FF8C00")),u.DARKORCHID=o(u.fromCssColorString("#9932CC")),u.DARKRED=o(u.fromCssColorString("#8B0000")),
u.DARKSALMON=o(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=o(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=o(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=o(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=o(u.fromCssColorString("#00CED1")),u.DARKVIOLET=o(u.fromCssColorString("#9400D3")),u.DEEPPINK=o(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=o(u.fromCssColorString("#00BFFF")),u.DIMGRAY=o(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=o(u.fromCssColorString("#1E90FF")),u.FIREBRICK=o(u.fromCssColorString("#B22222")),u.FLORALWHITE=o(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=o(u.fromCssColorString("#228B22")),u.FUSCHIA=o(u.fromCssColorString("#FF00FF")),u.GAINSBORO=o(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=o(u.fromCssColorString("#F8F8FF")),u.GOLD=o(u.fromCssColorString("#FFD700")),u.GOLDENROD=o(u.fromCssColorString("#DAA520")),u.GRAY=o(u.fromCssColorString("#808080")),u.GREEN=o(u.fromCssColorString("#008000")),u.GREENYELLOW=o(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=o(u.fromCssColorString("#F0FFF0")),u.HOTPINK=o(u.fromCssColorString("#FF69B4")),u.INDIANRED=o(u.fromCssColorString("#CD5C5C")),u.INDIGO=o(u.fromCssColorString("#4B0082")),u.IVORY=o(u.fromCssColorString("#FFFFF0")),u.KHAKI=o(u.fromCssColorString("#F0E68C")),u.LAVENDER=o(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=o(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=o(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=o(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=o(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=o(u.fromCssColorString("#F08080")),u.LIGHTCYAN=o(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=o(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=o(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=o(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=o(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=o(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=o(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=o(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=o(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=o(u.fromCssColorString("#FFFFE0")),u.LIME=o(u.fromCssColorString("#00FF00")),u.LIMEGREEN=o(u.fromCssColorString("#32CD32")),u.LINEN=o(u.fromCssColorString("#FAF0E6")),u.MAGENTA=o(u.fromCssColorString("#FF00FF")),u.MAROON=o(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=o(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=o(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=o(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=o(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=o(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=o(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=o(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=o(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=o(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=o(u.fromCssColorString("#191970")),u.MINTCREAM=o(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=o(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=o(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=o(u.fromCssColorString("#FFDEAD")),u.NAVY=o(u.fromCssColorString("#000080")),u.OLDLACE=o(u.fromCssColorString("#FDF5E6")),u.OLIVE=o(u.fromCssColorString("#808000")),u.OLIVEDRAB=o(u.fromCssColorString("#6B8E23")),u.ORANGE=o(u.fromCssColorString("#FFA500")),u.ORANGERED=o(u.fromCssColorString("#FF4500")),u.ORCHID=o(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=o(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=o(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=o(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=o(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=o(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=o(u.fromCssColorString("#FFDAB9")),u.PERU=o(u.fromCssColorString("#CD853F")),u.PINK=o(u.fromCssColorString("#FFC0CB")),u.PLUM=o(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=o(u.fromCssColorString("#B0E0E6")),u.PURPLE=o(u.fromCssColorString("#800080")),u.RED=o(u.fromCssColorString("#FF0000")),u.ROSYBROWN=o(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=o(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=o(u.fromCssColorString("#8B4513")),u.SALMON=o(u.fromCssColorString("#FA8072")),u.SANDYBROWN=o(u.fromCssColorString("#F4A460")),u.SEAGREEN=o(u.fromCssColorString("#2E8B57")),u.SEASHELL=o(u.fromCssColorString("#FFF5EE")),u.SIENNA=o(u.fromCssColorString("#A0522D")),u.SILVER=o(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=o(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=o(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=o(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=o(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=o(u.fromCssColorString("#00FF7F")),u.STEELBLUE=o(u.fromCssColorString("#4682B4")),u.TAN=o(u.fromCssColorString("#D2B48C")),u.TEAL=o(u.fromCssColorString("#008080")),u.THISTLE=o(u.fromCssColorString("#D8BFD8")),u.TOMATO=o(u.fromCssColorString("#FF6347")),u.TURQUOISE=o(u.fromCssColorString("#40E0D0")),u.VIOLET=o(u.fromCssColorString("#EE82EE")),u.WHEAT=o(u.fromCssColorString("#F5DEB3")),u.WHITE=o(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=o(u.fromCssColorString("#F5F5F5")),u.YELLOW=o(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=o(u.fromCssColorString("#9ACD32")),u.TRANSPARENT=o(new u(0,0,0,0)),u}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,o,i){"use strict";if(!o.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return r(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,t){switch(e){case a.BYTE:return new Int8Array(t);case a.UNSIGNED_BYTE:return new Uint8Array(t);case a.SHORT:return new Int16Array(t);case a.UNSIGNED_SHORT:return new Uint16Array(t);case a.FLOAT:return new Float32Array(t);case a.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,r,o,i){switch(o=t(o,0),i=t(i,(r.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(r,o,i);case a.UNSIGNED_BYTE:return new Uint8Array(r,o,i);case a.SHORT:return new Int16Array(r,o,i);case a.UNSIGNED_SHORT:return new Uint16Array(r,o,i);case a.FLOAT:return new Float32Array(r,o,i);case a.DOUBLE:return new Float64Array(r,o,i);default:throw new n("componentDatatype is not a valid value.")}},i(a)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,o){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,o.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var n=-1;for(var o in e.attributes)if(e.attributes.hasOwnProperty(o)&&t(e.attributes[o])&&t(e.attributes[o].values)){var i=e.attributes[o],a=i.values.length/i.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),o.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,o){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*o.signNotZero(r),t.y=(1-Math.abs(r))*o.signNotZero(n)}return t.x=o.toSNorm(t.x),t.y=o.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=o.fromSNorm(e),n.y=o.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*o.signNotZero(i),n.y=(1-Math.abs(i))*o.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var a=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,a),i.octPackFloat(a)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),o=256*(r-n);return i.octDecode(n,o,t)},i.octPack=function(e,t,r,n){var o=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,a);return n.x=65536*s.x+o,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var o=e.x/65536,a=Math.floor(o),u=65536*(o-a);o=e.y/65536;var s=Math.floor(o),c=65536*(o-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(a,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,r=1===e.y?4095:4096*e.y|0;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var o=new t,i=new t,a=new t,u=function(n,u,s,c,l){r(l)||(l=new t);var E,f,h,m,d,p,T,R;r(u.z)?(E=t.subtract(s,u,o),f=t.subtract(c,u,i),h=t.subtract(n,u,a),m=t.dot(E,E),d=t.dot(E,f),p=t.dot(E,h),T=t.dot(f,f),R=t.dot(f,h)):(E=e.subtract(s,u,o),f=e.subtract(c,u,i),h=e.subtract(n,u,a),m=e.dot(E,E),d=e.dot(E,f),p=e.dot(E,h),T=e.dot(f,f),R=e.dot(f,h));var A=1/(m*T-d*d);return l.y=(T*p-d*R)*A,l.z=(m*R-d*p)*A,l.x=1-l.y-l.z,l};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var o={high:0,low:0};n.fromCartesian=function(e,r){t(r)||(r=new n);var i=r.high,a=r.low;return n.encode(e.x,o),i.x=o.high,a.x=o.low,n.encode(e.y,o),i.y=o.high,a.y=o.low,n.encode(e.z,o),i.z=o.high,a.z=o.low,r};var i=new n;return n.writeElements=function(e,t,r){n.fromCartesian(e,i);var o=i.high,a=i.low;t[r]=o.x,t[r+1]=o.y,t[r+2]=o.z,t[r+3]=a.x,t[r+4]=a.y,t[r+5]=a.z},n}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var o=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return o}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=o.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,r,n){return e>=o.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,n):new Uint16Array(t,r,n)},n(i)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var o=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,o){var i;if(0===e)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var a=Math.abs(o),u=Math.abs(e);if(u>a&&a/u<t.EPSILON14)return[0,0];if(a>u&&u/a<t.EPSILON14)return[];if(i=-o/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===o)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*o,E=r(c,-l,t.EPSILON14);if(0>E)return[];var f=-.5*r(n,t.sign(n)*Math.sqrt(E),t.EPSILON14);return n>0?[f/e,o/f]:[o/f,f/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var o,i,a=e,u=t/3,s=r/3,c=n,l=a*s,E=u*c,f=u*u,h=s*s,m=a*s-f,d=a*c-u*s,p=u*c-h,T=4*m*p-d*d;if(0>T){var R,A,_;f*E>=l*h?(R=a,A=m,_=-2*u*m+a*d):(R=c,A=p,_=-c*d+2*s*p);var v=0>_?-1:1,y=-v*Math.abs(R)*Math.sqrt(-T);i=-_+y;var S=i/2,C=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),N=i===y?-C:-A/C;return o=0>=A?C+N:-_/(C*C+N*N+A),f*E>=l*h?[(o-u)/a]:[-c/(o+s)]}var I=m,g=-2*u*m+a*d,O=p,M=-c*d+2*s*p,L=Math.sqrt(T),F=Math.sqrt(3)/2,P=Math.abs(Math.atan2(a*L,-g)/3);o=2*Math.sqrt(-I);var w=Math.cos(P);i=o*w;var D=o*(-w/2-F*Math.sin(P)),b=i+D>2*u?i-u:D-u,U=a,x=b/U;P=Math.abs(Math.atan2(c*L,-M)/3),o=2*Math.sqrt(-O),w=Math.cos(P),i=o*w,D=o*(-w/2-F*Math.sin(P));var B=-c,G=2*s>i+D?i+s:D+s,z=B/G,V=U*G,H=-b*G-U*B,W=b*B,Y=(s*H-u*W)/(-u*H+s*V);return Y>=x?z>=x?z>=Y?[x,Y,z]:[x,z,Y]:[z,x,Y]:z>=x?[Y,x,z]:z>=Y?[Y,z,x]:[z,Y,x]}var n={};return n.computeDiscriminant=function(e,t,r,n){var o=e*e,i=t*t,a=r*r,u=n*n,s=18*e*t*r*n+i*a-27*o*u-4*(e*a*r+i*t*n);return s},n.computeRealRoots=function(e,n,o,i){var a,u;if(0===e)return t.computeRealRoots(n,o,i);if(0===n){if(0===o){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(a=t.computeRealRoots(e,0,o),0===a.Length?[0]:[a[0],0,a[1]]):r(e,0,o,i)}return 0===o?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(a=t.computeRealRoots(e,n,o),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):r(e,n,o,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function o(t,o,i,a){var u=t*t,s=o-3*u/8,c=i-o*t/2+u*t/8,l=a-i*t/4+o*u/16-3*u*u/256,E=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(E.length>0){var f=-t/4,h=E[E.length-1];if(Math.abs(h)<r.EPSILON14){var m=n.computeRealRoots(1,s,l);if(2===m.length){var d,p=m[0],T=m[1];if(p>=0&&T>=0){var R=Math.sqrt(p),A=Math.sqrt(T);return[f-A,f-R,f+R,f+A]}if(p>=0&&0>T)return d=Math.sqrt(p),[f-d,f+d];if(0>p&&T>=0)return d=Math.sqrt(T),[f-d,f+d]}return[]}if(h>0){var _=Math.sqrt(h),v=(s+h-c/_)/2,y=(s+h+c/_)/2,S=n.computeRealRoots(1,_,v),C=n.computeRealRoots(1,-_,y);return 0!==S.length?(S[0]+=f,S[1]+=f,0!==C.length?(C[0]+=f,C[1]+=f,S[1]<=C[0]?[S[0],S[1],C[0],C[1]]:C[1]<=S[0]?[C[0],C[1],S[0],S[1]]:S[0]>=C[0]&&S[1]<=C[1]?[C[0],S[0],S[1],C[1]]:C[0]>=S[0]&&C[1]<=S[1]?[S[0],C[0],C[1],S[1]]:S[0]>C[0]&&S[0]<C[1]?[C[0],S[0],C[1],S[1]]:[S[0],C[0],S[1],C[1]]):S):0!==C.length?(C[0]+=f,C[1]+=f,C):[]}}return[]}function i(t,o,i,a){var u=i*i,s=o*o,c=t*t,l=-2*o,E=i*t+s-4*a,f=c*a-i*o*t+u,h=e.computeRealRoots(1,l,E,f);
if(h.length>0){var m,d,p=h[0],T=o-p,R=T*T,A=t/2,_=T/2,v=R-4*a,y=R+4*Math.abs(a),S=c-4*p,C=c+4*Math.abs(p);if(0>p||S*y>v*C){var N=Math.sqrt(S);m=N/2,d=0===N?0:(t*_-i)/N}else{var I=Math.sqrt(v);m=0===I?0:(t*_-i)/I,d=I/2}var g,O;0===A&&0===m?(g=0,O=0):r.sign(A)===r.sign(m)?(g=A+m,O=p/g):(O=A-m,g=p/O);var M,L;0===_&&0===d?(M=0,L=0):r.sign(_)===r.sign(d)?(M=_+d,L=a/M):(L=_-d,M=a/L);var F=n.computeRealRoots(1,g,M),P=n.computeRealRoots(1,O,L);if(0!==F.length)return 0!==P.length?F[1]<=P[0]?[F[0],F[1],P[0],P[1]]:P[1]<=F[0]?[P[0],P[1],F[0],F[1]]:F[0]>=P[0]&&F[1]<=P[1]?[P[0],F[0],F[1],P[1]]:P[0]>=F[0]&&P[1]<=F[1]?[F[0],P[0],P[1],F[1]]:F[0]>P[0]&&F[0]<P[1]?[P[0],F[0],P[1],F[1]]:[F[0],P[0],F[1],P[1]]:F;if(0!==P.length)return P}return[]}var a={};return a.computeDiscriminant=function(e,t,r,n,o){var i=e*e,a=i*e,u=t*t,s=u*t,c=r*r,l=c*r,E=n*n,f=E*n,h=o*o,m=h*o,d=u*c*E-4*s*f-4*e*l*E+18*e*t*r*f-27*i*E*E+256*a*m+o*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*E+144*i*r*E)+h*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return d},a.computeRealRoots=function(t,n,a,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,a,u,s);var c=n/t,l=a/t,E=u/t,f=s/t,h=0>c?1:0;switch(h+=0>l?h+1:h,h+=0>E?h+1:h,h+=0>f?h+1:h){case 0:return o(c,l,E,f);case 1:return i(c,l,E,f);case 2:return i(c,l,E,f);case 3:return o(c,l,E,f);case 4:return o(c,l,E,f);case 5:return i(c,l,E,f);case 6:return o(c,l,E,f);case 7:return o(c,l,E,f);case 8:return i(c,l,E,f);case 9:return o(c,l,E,f);case 10:return o(c,l,E,f);case 11:return i(c,l,E,f);case 12:return o(c,l,E,f);case 13:return o(c,l,E,f);case 14:return o(c,l,E,f);case 15:return o(c,l,E,f);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var o=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return o.getPoint=function(t,n,o){return r(o)||(o=new e),o=e.multiplyByScalar(t.direction,n,o),e.add(t.origin,o,o)},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,o,i,a,u,s,c){"use strict";function l(t,n,o,a,u){u=r(u,!1);var s,c,l,E,f,h=t.origin,m=t.direction,d=e.subtract(o,n,p),v=e.subtract(a,n,T),y=e.cross(m,v,R),S=e.dot(d,y);if(u){if(S<i.EPSILON6)return void 0;if(s=e.subtract(h,n,A),l=e.dot(s,y),0>l||l>S)return void 0;if(c=e.cross(s,d,_),E=e.dot(m,c),0>E||l+E>S)return void 0;f=e.dot(v,c)/S}else{if(Math.abs(S)<i.EPSILON6)return void 0;var C=1/S;if(s=e.subtract(h,n,A),l=e.dot(s,y)*C,0>l||l>1)return void 0;if(c=e.cross(s,d,_),E=e.dot(m,c)*C,0>E||l+E>1)return void 0;f=e.dot(v,c)*C}return f}function E(e,t,r,n){var o=t*t-4*e*r;if(0>o)return void 0;if(o>0){var i=1/(2*e),a=Math.sqrt(o),u=(-t+a)*i,s=(-t-a)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function f(t,r,o){n(o)||(o={});var i=t.origin,a=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,R),l=e.dot(a,a),f=2*e.dot(a,c),h=e.magnitudeSquared(c)-s,m=E(l,f,h,y);return n(m)?(o.start=m.root0,o.stop=m.root1,o):void 0}function h(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function m(t,r,n,o,c){var l,E=o*o,f=c*c,m=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*f,d=c*(o*h(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],i.EPSILON15)+r.y),p=t[a.COLUMN0ROW0]*E+t[a.COLUMN2ROW2]*f+o*r.x+n,T=f*h(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],i.EPSILON15),R=c*(o*h(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+r.z),A=[];if(0===R&&0===T){if(l=u.computeRealRoots(m,d,p),0===l.length)return A;var _=l[0],v=Math.sqrt(Math.max(1-_*_,0));if(A.push(new e(o,c*_,c*-v)),A.push(new e(o,c*_,c*v)),2===l.length){var y=l[1],S=Math.sqrt(Math.max(1-y*y,0));A.push(new e(o,c*y,c*-S)),A.push(new e(o,c*y,c*S))}return A}var C=R*R,N=T*T,I=m*m,g=R*T,O=I+N,M=2*(d*m+g),L=2*p*m+d*d-N+C,F=2*(p*d-g),P=p*p-C;if(0===O&&0===M&&0===L&&0===F)return A;l=s.computeRealRoots(O,M,L,F,P);var w=l.length;if(0===w)return A;for(var D=0;w>D;++D){var b,U=l[D],x=U*U,B=Math.max(1-x,0),G=Math.sqrt(B);b=i.sign(m)===i.sign(p)?h(m*x+p,d*U,i.EPSILON12):i.sign(p)===i.sign(d*U)?h(m*x,d*U+p,i.EPSILON12):h(m*x+d*U,p,i.EPSILON12);var z=h(T*U,R,i.EPSILON15),V=b*z;0>V?A.push(new e(o,c*U,c*G)):V>0?A.push(new e(o,c*U,c*-G)):0!==G?(A.push(new e(o,c*U,c*-G)),A.push(new e(o,c*U,c*G)),++D):A.push(new e(o,c*U,c*G))}return A}var d={};d.rayPlane=function(t,r,o){n(o)||(o=new e);var a=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-r.distance-e.dot(s,a))/c;return 0>l?void 0:(o=e.multiplyByScalar(u,l,o),e.add(a,o,o))};var p=new e,T=new e,R=new e,A=new e,_=new e;d.rayTriangle=function(t,r,o,i,a,u){var s=l(t,r,o,i,a);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var v=new c;d.lineSegmentTriangle=function(t,r,o,i,a,u,s){var c=v;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var E=l(c,o,i,a,u);return!n(E)||0>E||E>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,E,s),e.add(c.origin,s,s))};var y={root0:0,root1:0};d.raySphere=function(e,t,r){return r=f(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var S=new c;d.lineSegmentSphere=function(t,r,o,i){var a=S,u=(e.clone(t,a.origin),e.subtract(r,t,a.direction)),s=e.magnitude(u);return e.normalize(u,u),i=f(a,o,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var C=new e,N=new e;d.rayEllipsoid=function(t,r){var n,o,i,a,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,C),l=e.multiplyComponents(s,t.direction,N),E=e.magnitudeSquared(c),f=e.dot(c,l);if(E>1){if(f>=0)return void 0;var h=f*f;if(n=E-1,o=e.magnitudeSquared(l),i=o*n,i>h)return void 0;if(h>i){a=f*f-i,u=-f+Math.sqrt(a);var m=u/o,d=n/u;return d>m?{start:m,stop:d}:{start:d,stop:m}}var p=Math.sqrt(n/o);return{start:p,stop:p}}return 1>E?(n=E-1,o=e.magnitudeSquared(l),i=o*n,a=f*f-i,u=-f+Math.sqrt(a),{start:0,stop:u/o}):0>f?(o=e.magnitudeSquared(l),{start:0,stop:-f/o}):void 0};var I=new e,g=new e,O=new e,M=new e,L=new e,F=new a,P=new a,w=new a,D=new a,b=new a,U=new a,x=new a,B=new e,G=new e,z=new t;d.grazingAltitudeLocation=function(t,r){var o=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(o,I);if(e.dot(u,s)>=0)return o;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,I),E=e.normalize(l,l),f=e.mostOrthogonalAxis(l,M),h=e.normalize(e.cross(f,E,g),g),d=e.normalize(e.cross(E,h,O),O),p=F;p[0]=E.x,p[1]=E.y,p[2]=E.z,p[3]=h.x,p[4]=h.y,p[5]=h.z,p[6]=d.x,p[7]=d.y,p[8]=d.z;var T=a.transpose(p,P),R=a.fromScale(r.radii,w),A=a.fromScale(r.oneOverRadii,D),_=b;_[0]=0,_[1]=-u.z,_[2]=u.y,_[3]=u.z,_[4]=0,_[5]=-u.x,_[6]=-u.y,_[7]=u.x,_[8]=0;var v,y,S=a.multiply(a.multiply(T,A,U),_,U),C=a.multiply(a.multiply(S,R,x),p,x),N=a.multiplyByVector(S,o,L),V=m(C,e.negate(N,I),0,0,1),H=V.length;if(H>0){for(var W=e.clone(e.ZERO,G),Y=Number.NEGATIVE_INFINITY,q=0;H>q;++q){v=a.multiplyByVector(R,a.multiplyByVector(p,V[q],B),B);var X=e.normalize(e.subtract(v,o,M),M),k=e.dot(X,u);k>Y&&(Y=k,W=e.clone(v,W))}var K=r.cartesianToCartographic(W,z);return Y=i.clamp(Y,0,1),y=e.magnitude(e.subtract(W,o,M))*Math.sqrt(1-Y*Y),y=c?-y:y,K.height=y,r.cartographicToCartesian(K,new e)}return void 0};var V=new e;return d.lineSegmentPlane=function(t,r,o,a){n(a)||(a=new e);var u=e.subtract(r,t,V),s=o.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),E=-(o.distance+l)/c;return 0>E||E>1?void 0:(e.multiplyByScalar(u,E,a),e.add(t,a,a),a)},d.trianglePlaneIntersection=function(t,r,n,o){var i=o.normal,a=o.distance,u=e.dot(i,t)+a<0,s=e.dot(i,r)+a<0,c=e.dot(i,n)+a<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var E,f;if((1===l||2===l)&&(E=new e,f=new e),1===l){if(u)return d.lineSegmentPlane(t,r,o,E),d.lineSegmentPlane(t,n,o,f),{positions:[t,r,n,E,f],indices:[0,3,4,1,2,4,1,4,3]};if(s)return d.lineSegmentPlane(r,n,o,E),d.lineSegmentPlane(r,t,o,f),{positions:[t,r,n,E,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return d.lineSegmentPlane(n,t,o,E),d.lineSegmentPlane(n,r,o,f),{positions:[t,r,n,E,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return d.lineSegmentPlane(r,t,o,E),d.lineSegmentPlane(n,t,o,f),{positions:[t,r,n,E,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return d.lineSegmentPlane(n,r,o,E),d.lineSegmentPlane(t,r,o,f),{positions:[t,r,n,E,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return d.lineSegmentPlane(t,n,o,E),d.lineSegmentPlane(r,n,o,f),{positions:[t,r,n,E,f],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},d}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,o=r.maximumIndex,i=e(r.cacheSize,24),a=n.length;if(!t(o)){o=0;for(var u=0,s=n[u];a>u;)s>o&&(o=s),++u,s=n[u]}for(var c=[],l=0;o+1>l;l++)c[l]=0;for(var E=i+1,f=0;a>f;++f)E-c[n[f]]>i&&(c[n[f]]=E,++E);return(E-i+1)/(a/3)},n.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var o=t[t.length-1];if(t.splice(t.length-1,1),e[o].numLiveTriangles>0)return o}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function o(e,t,r,o,i,a,u){for(var s,c=-1,l=-1,E=0;E<r.length;){var f=r[E];o[f].numLiveTriangles&&(s=0,i-o[f].timeStamp+2*o[f].numLiveTriangles<=t&&(s=i-o[f].timeStamp),(s>l||-1===l)&&(l=s,c=f)),++E}return-1===c?n(o,a,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,a=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=a.length,l=0,E=0,f=a[E],h=c;if(t(u))l=u+1;else{for(;h>E;)f>l&&(l=f),++E,f=a[E];if(-1===l)return 0;++l}for(var m=[],d=0;l>d;d++)m[d]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};E=0;for(var p=0;h>E;)m[a[E]].vertexTriangles.push(p),++m[a[E]].numLiveTriangles,m[a[E+1]].vertexTriangles.push(p),++m[a[E+1]].numLiveTriangles,m[a[E+2]].vertexTriangles.push(p),++m[a[E+2]].numLiveTriangles,++p,E+=3;var T=0,R=s+1;i=1;var A,_,v=[],y=[],S=0,C=[],N=c/3,I=[];for(d=0;N>d;d++)I[d]=!1;for(var g,O;-1!==T;){v=[],_=m[T],O=_.vertexTriangles.length;for(var M=0;O>M;++M)if(p=_.vertexTriangles[M],!I[p]){I[p]=!0,E=p+p+p;for(var L=0;3>L;++L)g=a[E],v.push(g),y.push(g),C[S]=g,++S,A=m[g],--A.numLiveTriangles,R-A.timeStamp>s&&(A.timeStamp=R,++R),++E}T=o(a,s,v,m,R,y,l)}return C},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,o,i,a,u,s,c,l,E,f,h,m,d,p,T,R,A,_,v,y,S,C,N){"use strict";function I(e,t,r,n,o){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=o,e[t++]=o,e[t]=r}function g(e){for(var t=e.length,r=t/3*6,n=T.createTypedArray(t,r),o=0,i=0;t>i;i+=3,o+=6)I(n,o,e[i],e[i+1],e[i+2]);return n}function O(e){var t=e.length;if(t>=3){var r=6*(t-2),n=T.createTypedArray(t,r);I(n,0,e[0],e[1],e[2]);for(var o=6,i=3;t>i;++i,o+=6)I(n,o,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function M(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=T.createTypedArray(t,r),o=e[0],i=0,a=1;t>a;++a,i+=6)I(n,i,o,e[a],e[a+1]);return n}return new Uint16Array}function L(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new m({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function F(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var o=t[n],i=0;i<o.componentsPerAttribute;++i)e[n].values.push(o.values[r*o.componentsPerAttribute+i])}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)o.unpack(r,i,ie),y.multiplyByPoint(e,ie,ie),o.pack(ie,r,i)}function w(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)o.unpack(r,i,ie),v.multiplyByVector(e,ie,ie),ie=o.normalize(ie,ie),o.pack(ie,r,i)}function D(e,t){var r,n=e.length,o={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var a=i[r],s=a.values.length,l=!0,E=1;n>E;++E){var f=e[E][t].attributes[r];if(!c(f)||a.componentDatatype!==f.componentDatatype||a.componentsPerAttribute!==f.componentsPerAttribute||a.normalize!==f.normalize){l=!1;break}s+=f.values.length}l&&(o[r]=new m({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:u.createTypedArray(a.componentDatatype,s)}))}return o}function b(e,t){var n,i,a,u,s,l,E,f=e.length,m=(e[0].modelMatrix,c(e[0][t].indices)),d=e[0][t].primitiveType,p=D(e,t);for(n in p)if(p.hasOwnProperty(n))for(s=p[n].values,u=0,i=0;f>i;++i)for(l=e[i][t].attributes[n].values,E=l.length,a=0;E>a;++a)s[u++]=l[a];var R;if(m){var A=0;for(i=0;f>i;++i)A+=e[i][t].indices.length;var _=h.computeNumberOfVertices(new h({attributes:p,primitiveType:C.POINTS})),v=T.createTypedArray(_,A),y=0,S=0;for(i=0;f>i;++i){var N=e[i][t].indices,I=N.length;for(u=0;I>u;++u)v[y++]=S+N[u];S+=h.computeNumberOfVertices(e[i][t])}R=v}var g,O=new o,M=0;for(i=0;f>i;++i){if(g=e[i][t].boundingSphere,!c(g)){O=void 0;break}o.add(g.center,O,O)}if(c(O))for(o.divideByScalar(O,f,O),i=0;f>i;++i){g=e[i][t].boundingSphere;var L=o.magnitude(o.subtract(g.center,O,se))+g.radius;L>M&&(M=L)}return new h({attributes:p,indices:R,primitiveType:d,boundingSphere:c(O)?new r(O,M):void 0})}function U(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=T.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function x(e){var t=h.computeNumberOfVertices(e),r=T.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,o=3;t>o;++o)r[n++]=o-1,r[n++]=0,r[n++]=o;return e.indices=r,e.primitiveType=C.TRIANGLES,e}function B(e){var t=h.computeNumberOfVertices(e),r=T.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,o=3;t-1>o;o+=2)r[n++]=o,r[n++]=o-1,r[n++]=o+1,t>o+2&&(r[n++]=o,r[n++]=o+1,r[n++]=o+2);return e.indices=r,e.primitiveType=C.TRIANGLES,e}function G(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=T.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function z(e){var t=h.computeNumberOfVertices(e),r=T.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return e.indices=r,e.primitiveType=C.LINES,e}function V(e){var t=h.computeNumberOfVertices(e),r=T.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=C.LINES,e}function H(e){switch(e.primitiveType){case C.TRIANGLE_FAN:return x(e);case C.TRIANGLE_STRIP:return B(e);case C.TRIANGLES:return U(e);case C.LINE_STRIP:return z(e);case C.LINE_LOOP:return V(e);case C.LINES:return G(e)}return e}function W(e,t){Math.abs(e.y)<_.EPSILON6&&(t?e.y=-_.EPSILON6:e.y=_.EPSILON6)}function Y(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return W(e,e.y<0),W(t,t.y<0),void W(r,r.y<0);var n,o=Math.abs(e.y),i=Math.abs(t.y),a=Math.abs(r.y);n=o>i?o>a?_.sign(e.y):_.sign(r.y):i>a?_.sign(t.y):_.sign(r.y);var u=0>n;W(e,u),W(t,u),W(r,u)}function q(e,t,r,n){o.add(e,o.multiplyByScalar(o.subtract(t,e,_e),e.y/(e.y-t.y),_e),r),o.clone(r,n),W(r,!0),W(n,!1)}function X(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;Y(e,t,r);var n=e.y<0,o=t.y<0,i=r.y<0,a=0;a+=n?1:0,a+=o?1:0,a+=i?1:0;var u=Ne.indices;1===a?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(q(e,t,ve,Se),q(e,r,ye,Ce),u[0]=0,u[3]=1,u[4]=2,u[6]=1):o?(q(t,r,ve,Se),q(t,e,ye,Ce),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(q(r,e,ve,Se),q(r,t,ye,Ce),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?o?i||(q(r,e,ve,Se),q(r,t,ye,Ce),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(q(t,r,ve,Se),q(t,e,ye,Ce),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(q(e,t,ve,Se),q(e,r,ye,Ce),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ne.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===a||2===a)&&(s[3]=ve,s[4]=ye,s[5]=Se,s[6]=Ce,s.length=7),Ne}function k(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var o in n)if(n.hasOwnProperty(o)&&c(n[o])&&c(n[o].values)){var i=n[o];i.values=u.createTypedArray(i.componentDatatype,i.values)}var a=h.computeNumberOfVertices(e);return e.indices=T.createTypedArray(a,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function K(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var o=t[n];r[n]=new m({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var n=c(e.geometry.boundingSphere);t=k(t,n),r=k(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function j(e,r,i,a,u,s,l,E,f,h,m){if(c(s)||c(l)||c(E)||c(f)){var d=o.fromArray(u,3*e,Ie),p=o.fromArray(u,3*r,ge),T=o.fromArray(u,3*i,Oe),R=t(a,d,p,T,Me);if(c(s)){var A=o.fromArray(s,3*e,Ie),_=o.fromArray(s,3*r,ge),v=o.fromArray(s,3*i,Oe);o.multiplyByScalar(A,R.x,A),o.multiplyByScalar(_,R.y,_),o.multiplyByScalar(v,R.z,v);var y=o.add(A,_,A);o.add(y,v,y),o.normalize(y,y),o.pack(y,h.normal.values,3*m)}if(c(l)){var S=o.fromArray(l,3*e,Ie),C=o.fromArray(l,3*r,ge),N=o.fromArray(l,3*i,Oe);o.multiplyByScalar(S,R.x,S),o.multiplyByScalar(C,R.y,C),o.multiplyByScalar(N,R.z,N);var I=o.add(S,C,S);o.add(I,N,I),o.normalize(I,I),o.pack(I,h.binormal.values,3*m)}if(c(E)){var g=o.fromArray(E,3*e,Ie),O=o.fromArray(E,3*r,ge),M=o.fromArray(E,3*i,Oe);o.multiplyByScalar(g,R.x,g),o.multiplyByScalar(O,R.y,O),o.multiplyByScalar(M,R.z,M);var L=o.add(g,O,g);o.add(L,M,L),o.normalize(L,L),o.pack(L,h.tangent.values,3*m)}if(c(f)){var F=n.fromArray(f,2*e,Le),P=n.fromArray(f,2*r,Fe),w=n.fromArray(f,2*i,Pe);n.multiplyByScalar(F,R.x,F),n.multiplyByScalar(P,R.y,P),n.multiplyByScalar(w,R.z,w);var D=n.add(F,P,F);n.add(D,w,D),n.pack(D,h.st.values,2*m)}}}function Q(e,t,r,n,o,i){var a=e.position.values.length/3;if(-1!==o){var u=n[o],s=r[u];return-1===s?(r[u]=a,e.position.values.push(i.x,i.y,i.z),t.push(a),a):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(a),a}function J(e){var t,r,n,i,a,u=e.geometry,s=u.attributes,l=s.position.values,E=c(s.normal)?s.normal.values:void 0,f=c(s.binormal)?s.binormal.values:void 0,h=c(s.tangent)?s.tangent.values:void 0,m=c(s.st)?s.st.values:void 0,d=u.indices,p=K(u),T=K(u),R=[];R.length=l.length/3;var A=[];for(A.length=l.length/3,a=0;a<R.length;++a)R[a]=-1,A[a]=-1;var _=d.length;for(a=0;_>a;a+=3){var v=d[a],y=d[a+1],S=d[a+2],C=o.fromArray(l,3*v),N=o.fromArray(l,3*y),I=o.fromArray(l,3*S),g=X(C,N,I);if(c(g)&&g.positions.length>3)for(var O=g.positions,M=g.indices,L=M.length,F=0;L>F;++F){var P=M[F],w=O[P];w.y<0?(t=T.attributes,r=T.indices,n=R):(t=p.attributes,r=p.indices,n=A),i=Q(t,r,n,d,3>P?a+P:-1,w),j(v,y,S,w,l,E,f,h,m,t,i)}else c(g)&&(C=g.positions[0],N=g.positions[1],I=g.positions[2]),C.y<0?(t=T.attributes,r=T.indices,n=R):(t=p.attributes,r=p.indices,n=A),i=Q(t,r,n,d,a,C),j(v,y,S,C,l,E,f,h,m,t,i),i=Q(t,r,n,d,a+1,N),j(v,y,S,N,l,E,f,h,m,t,i),i=Q(t,r,n,d,a+2,I),j(v,y,S,I,l,E,f,h,m,t,i)}Z(e,T,p)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,a=r.indices,u=K(r),s=K(r),l=a.length,E=[];E.length=i.length/3;var f=[];for(f.length=i.length/3,t=0;t<E.length;++t)E[t]=-1,f[t]=-1;for(t=0;l>t;t+=2){var h=a[t],m=a[t+1],d=o.fromArray(i,3*h,Ie),p=o.fromArray(i,3*m,ge);Math.abs(d.y)<_.EPSILON6&&(d.y<0?d.y=-_.EPSILON6:d.y=_.EPSILON6),Math.abs(p.y)<_.EPSILON6&&(p.y<0?p.y=-_.EPSILON6:p.y=_.EPSILON6);var T=u.attributes,R=u.indices,v=f,y=s.attributes,S=s.indices,C=E,N=A.lineSegmentPlane(d,p,we,Oe);if(c(N)){var I=o.multiplyByScalar(o.UNIT_Y,5*_.EPSILON9,De);d.y<0&&(o.negate(I,I),T=s.attributes,R=s.indices,v=E,y=u.attributes,S=u.indices,C=f);var g=o.add(N,I,be);Q(T,R,v,a,t,d),Q(T,R,v,a,-1,g),o.negate(I,I),o.add(N,I,g),Q(y,S,C,a,-1,g),Q(y,S,C,a,t+1,p)}else{var O,M,L;d.y<0?(O=s.attributes,M=s.indices,L=E):(O=u.attributes,M=u.indices,L=f),Q(O,M,L,a,t,d),Q(O,M,L,a,t+1,p)}}Z(e,s,u)}function ee(e){var t,r,a,u=e.geometry,s=u.attributes,l=s.position.values,E=s.prevPosition.values,f=s.nextPosition.values,h=s.expandAndWidth.values,m=(u.indices,c(s.st)?s.st.values:void 0),d=c(s.color)?s.color.values:void 0,p=K(u),T=K(u),R=l.length/3;for(t=0;R>t;t+=4){var v=t,y=t+1,S=t+2,C=t+3,N=o.fromArray(l,3*v,Be),I=o.fromArray(l,3*y,Ge),g=o.fromArray(l,3*S,ze),O=o.fromArray(l,3*C,Ve);Math.abs(N.y)<_.EPSILON6&&(N.y=_.EPSILON6*(g.y<0?-1:1),I.y=N.y),Math.abs(g.y)<_.EPSILON6&&(g.y=_.EPSILON6*(N.y<0?-1:1),O.y=g.y);var M=p.attributes,L=p.indices,F=T.attributes,P=T.indices,w=A.lineSegmentPlane(N,g,we,He);if(c(w)){var D=o.multiplyByScalar(o.UNIT_Y,5*_.EPSILON9,We);N.y<0&&(o.negate(D,D),M=T.attributes,L=T.indices,F=p.attributes,P=p.indices);var b=o.add(w,D,Ye);for(M.position.values.push(N.x,N.y,N.z,I.x,I.y,I.z),M.position.values.push(b.x,b.y,b.z),M.position.values.push(b.x,b.y,b.z),o.negate(D,D),o.add(w,D,b),F.position.values.push(b.x,b.y,b.z),F.position.values.push(b.x,b.y,b.z),F.position.values.push(g.x,g.y,g.z,O.x,O.y,O.z),r=3*v;3*v+6>r;++r)M.prevPosition.values.push(E[r]);for(M.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),F.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),r=3*S;3*S+6>r;++r)F.prevPosition.values.push(E[r]);for(r=3*v;3*v+6>r;++r)M.nextPosition.values.push(f[r]);for(M.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),F.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),r=3*S;3*S+6>r;++r)F.nextPosition.values.push(f[r]);var U=n.fromArray(h,2*v,Ue),x=Math.abs(U.y);M.expandAndWidth.values.push(-1,x,1,x),M.expandAndWidth.values.push(-1,-x,1,-x),F.expandAndWidth.values.push(-1,x,1,x),F.expandAndWidth.values.push(-1,-x,1,-x);var B=o.magnitudeSquared(o.subtract(w,N,Ve));if(B/=o.magnitudeSquared(o.subtract(g,N,Ve)),c(d)){var G=i.fromArray(d,4*v,qe),z=i.fromArray(d,4*S,qe),V=_.lerp(G.x,z.x,B),H=_.lerp(G.y,z.y,B),W=_.lerp(G.z,z.z,B),Y=_.lerp(G.w,z.w,B);for(r=4*v;4*v+8>r;++r)M.color.values.push(d[r]);for(M.color.values.push(V,H,W,Y),M.color.values.push(V,H,W,Y),F.color.values.push(V,H,W,Y),F.color.values.push(V,H,W,Y),r=4*S;4*S+8>r;++r)F.color.values.push(d[r])}if(c(m)){var q=n.fromArray(m,2*v,Ue),X=n.fromArray(m,2*(t+3),xe),k=_.lerp(q.x,X.x,B);for(r=2*v;2*v+4>r;++r)M.st.values.push(m[r]);for(M.st.values.push(k,q.y),M.st.values.push(k,X.y),F.st.values.push(k,q.y),F.st.values.push(k,X.y),r=2*S;2*S+4>r;++r)F.st.values.push(m[r])}a=M.position.values.length/3-4,L.push(a,a+2,a+1),L.push(a+1,a+2,a+3),a=F.position.values.length/3-4,P.push(a,a+2,a+1),P.push(a+1,a+2,a+3)}else{var j,Q;for(N.y<0?(j=T.attributes,Q=T.indices):(j=p.attributes,Q=p.indices),j.position.values.push(N.x,N.y,N.z),j.position.values.push(I.x,I.y,I.z),j.position.values.push(g.x,g.y,g.z),j.position.values.push(O.x,O.y,O.z),r=3*t;3*t+12>r;++r)j.prevPosition.values.push(E[r]),j.nextPosition.values.push(f[r]);for(r=2*t;2*t+8>r;++r)j.expandAndWidth.values.push(h[r]),c(m)&&j.st.values.push(m[r]);if(c(d))for(r=4*t;4*t+16>r;++r)j.color.values.push(d[r]);a=j.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}Z(e,T,p)}var te={};te.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case C.TRIANGLES:e.indices=g(t);break;case C.TRIANGLE_STRIP:e.indices=O(t);break;case C.TRIANGLE_FAN:e.indices=M(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=C.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var o=e.attributes.position.values,i=e.attributes[t].values,a=o.length,l=new Float64Array(2*a),E=0,f=0;a>f;f+=3)l[E++]=o[f],l[E++]=o[f+1],l[E++]=o[f+2],l[E++]=o[f]+i[f]*n,l[E++]=o[f+1]+i[f+1]*n,l[E++]=o[f+2]+i[f+2]*n;var d,p=e.boundingSphere;return c(p)&&(d=new r(p.center,p.radius+n)),new h({attributes:{position:new m({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:C.LINES,boundingSphere:d})},te.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,o={},i=0,a=r.length;for(t=0;a>t;++t){var u=r[t];c(n[u])&&(o[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(o[s])&&(o[s]=i++);return o},te.reorderForPreVertexCache=function(e){var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),o=0;t>o;o++)n[o]=-1;for(var i,a=r,s=a.length,l=T.createTypedArray(t,s),E=0,f=0,m=0;s>E;)i=n[a[E]],-1!==i?l[f]=i:(i=a[E],n[i]=m,l[f]=m,++m),++E,++f;e.indices=l;var d=e.attributes;for(var p in d)if(d.hasOwnProperty(p)&&c(d[p])&&c(d[p].values)){for(var R=d[p],A=R.values,_=0,v=R.componentsPerAttribute,y=u.createTypedArray(R.componentDatatype,m*v);t>_;){var S=n[_];if(-1!==S)for(o=0;v>o;o++)y[v*S+o]=A[v*_+o];++_}R.values=y}}return e},te.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===C.TRIANGLES&&c(r)){for(var n=r.length,o=0,i=0;n>i;i++)r[i]>o&&(o=r[i]);e.indices=N.tipsify({indices:r,maximumIndex:o,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>=_.SIXTY_FOUR_KILOBYTES){var n,o=[],i=[],a=0,u=L(e.attributes),s=e.indices,l=s.length;e.primitiveType===C.TRIANGLES?n=3:e.primitiveType===C.LINES?n=2:e.primitiveType===C.POINTS&&(n=1);for(var E=0;l>E;E+=n){for(var f=0;n>f;++f){var m=s[E+f],d=o[m];c(d)||(d=a++,o[m]=d,F(u,e.attributes,m)),i.push(d)}a+n>=_.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),o=[],i=[],a=0,u=L(e.attributes))}0!==i.length&&t.push(new h({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new o,ne=new a;te.projectTo2D=function(e,t,r,n,i){var a=e.attributes[t];i=c(i)?i:new f;for(var s=i.ellipsoid,E=a.values,h=new Float64Array(E.length),d=0,p=0;p<E.length;p+=3){var T=o.fromArray(E,p,re),R=s.cartesianToCartographic(T,ne);if(!c(R))throw new l("Could not project point ("+T.x+", "+T.y+", "+T.z+") to 2D.");var A=i.project(R,re);h[d++]=A.x,h[d++]=A.y,h[d++]=A.z}return e.attributes[r]=a,e.attributes[n]=new m({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var oe={high:0,low:0};te.encodeAttribute=function(e,t,r,n){for(var o=e.attributes[t],i=o.values,a=i.length,s=new Float32Array(a),c=new Float32Array(a),l=0;a>l;++l)E.encode(i[l],oe),s[l]=oe.high,c[l]=oe.low;var f=o.componentsPerAttribute;return e.attributes[r]=new m({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:s}),e.attributes[n]=new m({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:c}),delete e.attributes[t],e};var ie=new o,ae=new y,ue=new v;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(y.equals(t,y.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(y.inverse(t,ae),y.transpose(ae,ae),y.getRotation(ae,ue),w(ue,n.normal),w(ue,n.binormal),w(ue,n.tangent));var o=e.geometry.boundingSphere;return c(o)&&(e.geometry.boundingSphere=r.transform(o,t,o)),e.modelMatrix=y.clone(y.IDENTITY),e};var se=new o;te.combineInstances=function(e){for(var t=[],r=[],n=e.length,o=0;n>o;++o){var i=e[o];c(i.geometry)?t.push(i):r.push(i)}var a=[];return t.length>0&&a.push(b(t,"geometry")),r.length>0&&(a.push(b(r,"westHemisphereGeometry")),a.push(b(r,"eastHemisphereGeometry"))),a};var ce=new o,le=new o,Ee=new o,fe=new o;te.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,a=t.length,s=new Array(i),c=new Array(a/3),l=new Array(a),E=0;i>E;E++)s[E]={indexOffset:0,count:0,currentCount:0};var f=0;for(E=0;a>E;E+=3){var h=t[E],d=t[E+1],p=t[E+2],T=3*h,R=3*d,A=3*p;le.x=n[T],le.y=n[T+1],le.z=n[T+2],Ee.x=n[R],Ee.y=n[R+1],Ee.z=n[R+2],fe.x=n[A],fe.y=n[A+1],fe.z=n[A+2],s[h].count++,s[d].count++,s[p].count++,o.subtract(Ee,le,Ee),o.subtract(fe,le,fe),c[f]=o.cross(Ee,fe,new o),f++}var _=0;for(E=0;i>E;E++)s[E].indexOffset+=_,_+=s[E].count;f=0;var v;for(E=0;a>E;E+=3){v=s[t[E]];var y=v.indexOffset+v.currentCount;l[y]=f,v.currentCount++,v=s[t[E+1]],y=v.indexOffset+v.currentCount,l[y]=f,v.currentCount++,v=s[t[E+2]],y=v.indexOffset+v.currentCount,l[y]=f,v.currentCount++,f++}var S=new Float32Array(3*i);for(E=0;i>E;E++){var C=3*E;if(v=s[E],v.count>0){for(o.clone(o.ZERO,ce),f=0;f<v.count;f++)o.add(ce,c[l[v.indexOffset+f]],ce);o.normalize(ce,ce),S[C]=ce.x,S[C+1]=ce.y,S[C+2]=ce.z}else S[C]=0,S[C+1]=0,S[C+2]=1}return e.attributes.normal=new m({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var he=new o,me=new o,de=new o;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,a=e.attributes.position.values.length/3,s=t.length,c=new Array(3*a),l=0;l<c.length;l++)c[l]=0;var E,f,h;for(l=0;s>l;l+=3){var d=t[l],p=t[l+1],T=t[l+2];E=3*d,f=3*p,h=3*T;var R=2*d,A=2*p,_=2*T,v=r[E],y=r[E+1],S=r[E+2],C=i[R],N=i[R+1],I=i[A+1]-N,g=i[_+1]-N,O=1/((i[A]-C)*g-(i[_]-C)*I),M=(g*(r[f]-v)-I*(r[h]-v))*O,L=(g*(r[f+1]-y)-I*(r[h+1]-y))*O,F=(g*(r[f+2]-S)-I*(r[h+2]-S))*O;c[E]+=M,c[E+1]+=L,c[E+2]+=F,c[f]+=M,c[f+1]+=L,c[f+2]+=F,c[h]+=M,c[h+1]+=L,c[h+2]+=F}var P=new Float32Array(3*a),w=new Float32Array(3*a);for(l=0;a>l;l++){E=3*l,f=E+1,h=E+2;var D=o.fromArray(n,E,he),b=o.fromArray(c,E,de),U=o.dot(D,b);o.multiplyByScalar(D,U,me),o.normalize(o.subtract(b,me,b),b),w[E]=b.x,w[f]=b.y,w[h]=b.z,o.normalize(o.cross(D,b,b),b),P[E]=b.x,P[f]=b.y,P[h]=b.z}return e.attributes.tangent=new m({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:w}),e.attributes.binormal=new m({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e};var pe=new n,Te=new o,Re=new o,Ae=new o;te.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var a,s,l,E,f=t.attributes.tangent,h=t.attributes.binormal;c(r)&&(a=r.values),c(i)&&(s=i.values),c(f)&&(l=f.values),h&&(E=h.values);var d=c(a)?a.length:s.length,p=c(a)?3:2,T=d/p,R=T,A=c(s)&&c(a)?2:1;A+=c(l)||c(E)?1:0,R*=A;for(var _=new Float32Array(R),v=0,y=0;T>y;++y){c(s)&&(n.fromArray(s,2*y,pe),_[v++]=e.compressTextureCoordinates(pe));var S=3*y;c(a)&&c(l)&&c(E)?(o.fromArray(a,S,Te),o.fromArray(l,S,Re),o.fromArray(E,S,Ae),e.octPack(Te,Re,Ae,pe),_[v++]=pe.x,_[v++]=pe.y):(c(a)&&(o.fromArray(a,S,Te),_[v++]=e.octEncodeFloat(Te)),c(l)&&(o.fromArray(l,S,Te),_[v++]=e.octEncodeFloat(Te)),c(E)&&(o.fromArray(E,S,Te),_[v++]=e.octEncodeFloat(Te)))}return t.attributes.compressedAttributes=new m({componentDatatype:u.FLOAT,componentsPerAttribute:A,values:_}),c(a)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(E)&&delete t.attributes.binormal,t};var _e=new o,ve=new o,ye=new o,Se=new o,Ce=new o,Ne={positions:new Array(7),indices:new Array(9)},Ie=new o,ge=new o,Oe=new o,Me=new o,Le=new n,Fe=new n,Pe=new n,we=S.fromPointNormal(o.ZERO,o.UNIT_Y),De=new o,be=new o,Ue=new n,xe=new n,Be=new o,Ge=new o,ze=new o,Ve=new o,He=new o,We=new o,Ye=new o,qe=new i;new i;return te.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var o=n.center.x-n.radius;if(o>0||r.intersectPlane(n,S.ORIGIN_ZX_PLANE)!==R.INTERSECTING)return e}if(t.geometryType!==p.NONE)switch(t.geometryType){case p.POLYLINES:ee(e);break;case p.TRIANGLES:J(e);break;case p.LINES:$(e)}else H(t),t.primitiveType===C.TRIANGLES?J(e):t.primitiveType===C.LINES&&$(e);return e},te}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,o,i,a,u){"use strict";var s=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,
this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=s.geodeticLatitudeToMercatorAngle(t.latitude)*o,u=t.height;return n(r)?(r.x=i,r.y=a,r.z=u,r):new e(i,a,u)},s.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,i=e.x*o,a=s.mercatorAngleToGeodeticLatitude(e.y*o),u=e.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=u,r):new t(i,a,u)},s}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,n,o,i,a,u,s,c,l,E,f,h,m,d){"use strict";function p(e,t,r){var n,o=!r,i=e.length;if(!o&&i>1){var a=e[0].modelMatrix;for(n=1;i>n;++n)if(!m.equals(a,e[n].modelMatrix)){o=!0;break}}if(o)for(n=0;i>n;++n)f.transformToWorldCoordinates(e[n]);else m.multiplyTransformation(t,e[0].modelMatrix,t)}function T(e,n){var o=e.attributes,i=o.position,a=4*(i.values.length/i.componentsPerAttribute);o.pickColor=new l({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var u=t.floatToByte(n.red),s=t.floatToByte(n.green),c=t.floatToByte(n.blue),E=t.floatToByte(n.alpha),f=o.pickColor.values,h=0;a>h;h+=4)f[h]=u,f[h+1]=s,f[h+2]=c,f[h+3]=E}function R(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n],a=t[n];o(i.geometry)?T(i.geometry,a):(T(i.westHemisphereGeometry,a),T(i.eastHemisphereGeometry,a))}}function A(e){var t,r=e.length,n=[],i=e[0].attributes;for(t in i)if(i.hasOwnProperty(t)){for(var a=i[t],u=!0,s=1;r>s;++s){var c=e[s].attributes[t];if(!o(c)||a.componentDatatype!==c.componentDatatype||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){u=!1;break}}u&&n.push(t)}return n}function _(e,t,n){for(var o=c.computeNumberOfVertices(t),i=n.length,a=0;i>a;++a){for(var u=n[a],s=e[u],E=s.componentDatatype,f=s.value,h=f.length,m=r.createTypedArray(E,o*h),d=0;o>d;++d)m.set(f,d*h);t.attributes[u]=new l({componentDatatype:E,componentsPerAttribute:h,normalize:s.normalize,values:m})}}function v(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n],a=i.attributes;o(i.geometry)?_(a,i.geometry,t):(_(a,i.westHemisphereGeometry,t),_(a,i.eastHemisphereGeometry,t))}}function y(t){var n,i,a=t.instances,u=t.pickIds,s=t.projection,c=t.elementIndexUintSupported,l=t.scene3DOnly,E=t.allowPicking,h=t.vertexCacheOptimize,m=t.compressVertices,d=t.modelMatrix,T=a.length;a[0].geometry.primitiveType;if(p(a,d,l),!l)for(n=0;T>n;++n)f.splitLongitude(a[n]);E&&R(a,u);var _=A(a);if(v(a,_),h)for(n=0;T>n;++n){var y=a[n];o(y.geometry)?(f.reorderForPostVertexCache(y.geometry),f.reorderForPreVertexCache(y.geometry)):(f.reorderForPostVertexCache(y.westHemisphereGeometry),f.reorderForPreVertexCache(y.westHemisphereGeometry),f.reorderForPostVertexCache(y.eastHemisphereGeometry),f.reorderForPreVertexCache(y.eastHemisphereGeometry))}var S=f.combineInstances(a);for(T=S.length,n=0;T>n;++n){i=S[n];var C,N=i.attributes;if(l)for(C in N)N.hasOwnProperty(C)&&N[C].componentDatatype===r.DOUBLE&&f.encodeAttribute(i,C,C+"3DHigh",C+"3DLow");else for(C in N)if(N.hasOwnProperty(C)&&N[C].componentDatatype===r.DOUBLE){var I=C+"3D",g=C+"2D";f.projectTo2D(i,C,I,g,s),o(i.boundingSphere)&&"position"===C&&(i.boundingSphereCV=e.fromVertices(i.attributes.position2D.values)),f.encodeAttribute(i,I,I+"High",I+"Low"),f.encodeAttribute(i,g,g+"High",g+"Low")}m&&f.compressVertices(i)}if(!c){var O=[];for(T=S.length,n=0;T>n;++n)i=S[n],O=O.concat(f.fitToUnsignedShortIndices(i));S=O}return S}function S(e,t,n){for(var o=[],i=e.attributes,a=n.length,u=0;a>u;++u){var s=n[u],c=i[s],l=c.componentDatatype;l===r.DOUBLE&&(l=r.FLOAT);var E=r.createTypedArray(l,c.values);o.push({index:t[s],componentDatatype:l,componentsPerAttribute:c.componentsPerAttribute,normalize:c.normalize,values:E}),delete i[s]}return o}function C(e,t,r,i,a,u,s,l,E){var f=c.computeNumberOfVertices(t);o(s[e])||(s[e]={boundingSphere:t.boundingSphere,boundingSphereCV:t.boundingSphereCV});for(var h=i.length,m=0;h>m;++m)for(var d=i[m],p=a[d],T=f;T>0;){for(var R,A=n(E[d],0),_=u[A],v=_.length,y=0;v>y&&(R=_[y],R.index!==p);++y);o(s[e][d])||(s[e][d]={dirty:!1,valid:!0,value:r[d].value,indices:[]});var S,C=R.values.length/R.componentsPerAttribute,N=n(l[d],0);C>N+T?(S=T,s[e][d].indices.push({attribute:R,offset:N,count:S}),l[d]=N+T):(S=C-N,s[e][d].indices.push({attribute:R,offset:N,count:S}),l[d]=0,E[d]=A+1),T-=S}}function N(e,t,r,n,i){var a,u,s,c=[],l=e.length,E={},f={};for(a=0;l>a;++a)u=e[a],s=u.attributes,o(u.geometry)&&C(a,u.geometry,s,i,n,r,c,E,f);for(a=0;l>a;++a)u=e[a],s=u.attributes,o(u.westHemisphereGeometry)&&C(a,u.westHemisphereGeometry,s,i,n,r,c,E,f);for(a=0;l>a;++a)u=e[a],s=u.attributes,o(u.eastHemisphereGeometry)&&C(a,u.eastHemisphereGeometry,s,i,n,r,c,E,f);for(l=t.length,a=0;l>a;++a){u=t[a],s=u.attributes;var h={};c.push(h);for(var m=i.length,d=0;m>d;++d){var p=i[d];h[p]={dirty:!1,valid:!1,value:s[p].value,indices:[]}}}return c}function I(e,t){var r=e.attributes;for(var n in r)if(r.hasOwnProperty(n)){var i=r[n];o(i)&&o(i.values)&&t.push(i.values.buffer)}o(e.indices)&&t.push(e.indices.buffer)}function g(e,t){for(var r=e.length,n=0;r>n;++n)I(e[n],t)}function O(e,t){for(var r=e.length,n=0;r>n;++n)for(var o=e[n],i=o.length,a=0;i>a;++a)t.push(o[a].values.buffer)}function M(t){for(var r=1,n=t.length,i=0;n>i;i++){var a=t[i];if(++r,o(a)){var u=a.attributes;r+=6+2*e.packedLength+(o(a.indices)?a.indices.length:0);for(var s in u)if(u.hasOwnProperty(s)&&o(u[s])){var c=u[s];r+=5+c.values.length}}}return r}function L(e,t){for(var r=e.length,n=new Uint32Array(e.length),o=0;r>o;++o)n[o]=e[o].toRgba();return t.push(n.buffer),n}function F(e){for(var r=e.length,n=new Array(r),o=0;r>o;o++)n[o]=t.fromRgba(e[o]);return n}function P(e){for(var t=e.length,r=1+17*t,n=0;t>n;n++){var i=e[n].attributes;for(var a in i)if(i.hasOwnProperty(a)&&o(i[a])){var u=i[a];r+=5+u.value.length}}return r}function w(e,t){var r=new Float64Array(P(e)),n={},i=[],a=e.length,u=0;r[u++]=a;for(var s=0;a>s;s++){var c=e[s];m.pack(c.modelMatrix,r,u),u+=m.packedLength;var l=c.attributes,E=[];for(var f in l)l.hasOwnProperty(f)&&o(l[f])&&(E.push(f),o(n[f])||(n[f]=i.length,i.push(f)));r[u++]=E.length;for(var h=0;h<E.length;h++){var d=E[h],p=l[d];r[u++]=n[d],r[u++]=p.componentDatatype,r[u++]=p.componentsPerAttribute,r[u++]=p.normalize,r[u++]=p.value.length,r.set(p.value,u),u+=p.value.length}}return t.push(r.buffer),{stringTable:i,packedData:r}}function D(e){for(var t=e.packedData,n=e.stringTable,o=new Array(t[0]),i=0,a=1;a<t.length;){var u=m.unpack(t,a);a+=m.packedLength;for(var s={},c=t[a++],l=0;c>l;l++){for(var E=n[t[a++]],f=t[a++],h=t[a++],d=0!==t[a++],p=t[a++],T=r.createTypedArray(f,p),R=0;p>R;R++)T[R]=t[a++];s[E]={componentDatatype:f,componentsPerAttribute:h,normalize:d,value:T}}o[i++]={attributes:s,modelMatrix:u}}return o}function b(t){for(var r=t.length,n=1+r,i=0;r>i;i++){var a=t[i];n+=2,n+=o(a.boundingSphere)?e.packedLength:0,n+=o(a.boundingSphereCV)?e.packedLength:0;for(var u in a)if(a.hasOwnProperty(u)&&o(a[u])&&"boundingSphere"!==u&&"boundingSphereCV"!==u){var s=a[u];n+=4+3*s.indices.length+s.value.length}}return n}function U(t,r){var n=new Float64Array(b(t)),i=[],a=[],u={},s=t.length,c=0;n[c++]=s;for(var l=0;s>l;l++){var E=t[l],f=E.boundingSphere,h=o(f);n[c++]=h?1:0,h&&(e.pack(f,n,c),c+=e.packedLength),f=E.boundingSphereCV,h=o(f),n[c++]=h?1:0,h&&(e.pack(f,n,c),c+=e.packedLength);var m=[];for(var d in E)E.hasOwnProperty(d)&&o(E[d])&&"boundingSphere"!==d&&"boundingSphereCV"!==d&&(m.push(d),o(u[d])||(u[d]=i.length,i.push(d)));n[c++]=m.length;for(var p=0;p<m.length;p++){var T=m[p],R=E[T];n[c++]=u[T],n[c++]=R.valid?1:0;var A=R.indices,_=A.length;n[c++]=_;for(var v=0;_>v;v++){var y=A[v];n[c++]=y.count,n[c++]=y.offset;var S=a.indexOf(y.attribute);-1===S&&(S=a.length,a.push(y.attribute)),n[c++]=S}n[c++]=R.value.length,n.set(R.value,c),c+=R.value.length}}return r.push(n.buffer),{stringTable:i,packedData:n,attributeTable:a}}function x(t,n){for(var o=t.stringTable,i=t.attributeTable,a=t.packedData,u=new Array(a[0]),s=0,c=1,l=a.length;l>c;){var E={},f=1===a[c++];f&&(E.boundingSphere=e.unpack(a,c),c+=e.packedLength),f=1===a[c++],f&&(E.boundingSphereCV=e.unpack(a,c),c+=e.packedLength);for(var h=a[c++],m=0;h>m;m++){for(var d=o[a[c++]],p=1===a[c++],T=a[c++],R=T>0?new Array(T):void 0,A=0;T>A;A++){var _={};_.count=a[c++],_.offset=a[c++],_.attribute=i[a[c++]],R[A]=_}for(var v=a[c++],y=p?r.createTypedArray(R[0].attribute.componentDatatype,v):new Array(v),S=0;v>S;S++)y[S]=a[c++];E[d]={dirty:!1,valid:p,indices:R,value:y}}u[s++]=E}return u}if(!u.supportsTypedArrays())return{};var B={};return B.combineGeometry=function(e){var t,r,n,i,a,u=e.instances,s=e.invalidInstances;if(u.length>0){t=y(e),r=f.createAttributeLocations(t[0]),i=A(u),n=[],a=t.length;for(var c=0;a>c;++c){var l=t[c];n.push(S(l,r,i))}}i=o(i)?i:A(s);var E=N(u,s,n,r,i);return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:r,vaAttributes:n,vaAttributeLocations:E,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.packCreateGeometryResults=function(t,r){var n=new Float64Array(M(t)),i=[],a={},u=t.length,s=0;n[s++]=u;for(var c=0;u>c;c++){var l=t[c],E=o(l);if(n[s++]=E?1:0,E){n[s++]=l.primitiveType,n[s++]=l.geometryType;var f=o(l.boundingSphere)?1:0;n[s++]=f,f&&e.pack(l.boundingSphere,n,s),s+=e.packedLength;var h=o(l.boundingSphereCV)?1:0;n[s++]=h,h&&e.pack(l.boundingSphereCV,n,s),s+=e.packedLength;var m=l.attributes,d=[];for(var p in m)m.hasOwnProperty(p)&&o(m[p])&&(d.push(p),o(a[p])||(a[p]=i.length,i.push(p)));n[s++]=d.length;for(var T=0;T<d.length;T++){var R=d[T],A=m[R];n[s++]=a[R],n[s++]=A.componentDatatype,n[s++]=A.componentsPerAttribute,n[s++]=A.normalize?1:0,n[s++]=A.values.length,n.set(A.values,s),s+=A.values.length}var _=o(l.indices)?l.indices.length:0;n[s++]=_,_>0&&(n.set(l.indices,s),s+=_)}}return r.push(n.buffer),{stringTable:i,packedData:n}},B.unpackCreateGeometryResults=function(t){for(var n,o=t.stringTable,i=t.packedData,a=new Array(i[0]),u=0,s=1;s<i.length;){var f=1===i[s++];if(f){var m,d,p=i[s++],T=i[s++],R=1===i[s++];R&&(m=e.unpack(i,s)),s+=e.packedLength;var A=1===i[s++];A&&(d=e.unpack(i,s)),s+=e.packedLength;var _,v,y,S=new E,C=i[s++];for(n=0;C>n;n++){var N=o[i[s++]],I=i[s++];y=i[s++];var g=0!==i[s++];_=i[s++],v=r.createTypedArray(I,_);for(var O=0;_>O;O++)v[O]=i[s++];S[N]=new l({componentDatatype:I,componentsPerAttribute:y,normalize:g,values:v})}var M;if(_=i[s++],_>0){var L=v.length/y;for(M=h.createTypedArray(L,_),n=0;_>n;n++)M[n]=i[s++]}a[u++]=new c({primitiveType:p,geometryType:T,boundingSphere:m,indices:M,attributes:S})}else a[u++]=void 0}return a},B.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,n=r.length,o=0;n>o;o++)t.push(r[o].packedData.buffer);var i;return e.allowPicking&&(i=L(e.pickIds,t)),{createGeometryResults:e.createGeometryResults,packedInstances:w(e.instances,t),packedPickIds:i,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof s,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},B.unpackCombineGeometryParameters=function(e){for(var t=D(e.packedInstances),r=e.allowPicking,n=r?F(e.packedPickIds):void 0,i=e.createGeometryResults,u=i.length,c=0,l=[],E=[],f=[],h=[],p=[],T=0;u>T;T++)for(var R=B.unpackCreateGeometryResults(i[T]),A=R.length,_=0;A>_;_++){var v=R[_],y=t[c];o(v)?(y.geometry=v,l.push(y),f.push(c),r&&p.push(n[c])):(E.push(y),h.push(c)),++c}var S=a.clone(e.ellipsoid),C=e.isGeographic?new s(S):new d(S);return{instances:l,invalidInstances:E,validInstancesIndices:f,invalidInstancesIndices:h,pickIds:p,ellipsoid:S,projection:C,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:m.clone(e.modelMatrix)}},B.packCombineGeometryResults=function(e,t){return o(e.geometries)&&(g(e.geometries,t),O(e.vaAttributes,t)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:U(e.vaAttributeLocations,t),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:x(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},B}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,o){return t(e).then(r,n,o)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=o(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function o(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(o){return i(o)}});return r}function a(){function e(e,t,r){return f(e,t,r)}function r(e){return m(e)}function o(e){return m(i(e))}function u(e){return h(e)}var s,c,l,E,f,h,m;return c=new n(e),s={then:e,resolve:r,reject:o,progress:u,promise:c,resolver:{resolve:r,reject:o,progress:u}},l=[],E=[],f=function(e,t,r){var n,o;return n=a(),o="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,o)}),E.push(o),n.promise},h=function(e){return d(E,e),e},m=function(e){return e=t(e),f=e.then,m=t,h=T,d(l,e),E=l=v,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,o,i){return p(2,arguments),e(t,function(t){function u(e){d(e)}function s(e){m(e)}var c,l,E,f,h,m,d,p,R,A;if(R=t.length>>>0,c=Math.max(0,Math.min(r,R)),E=[],l=R-c+1,f=[],h=a(),c)for(p=h.progress,d=function(e){f.push(e),--l||(m=d=T,h.reject(f))},m=function(e){E.push(e),--c||(m=d=T,h.resolve(E))},A=0;R>A;++A)A in t&&e(t[A],s,u,p);else h.resolve(E);return h.then(n,o,i)})}function c(e,t,r,n){function o(e){return t?t(e[0]):e[0]}return s(e,1,o,r,n)}function l(e,t,r,n){return p(1,arguments),f(e,R).then(t,r,n)}function E(){return f(arguments,R)}function f(t,r){return e(t,function(t){var n,o,i,u,s,c;if(i=o=t.length>>>0,n=[],c=a(),i)for(u=function(t,o){e(t,r).then(function(e){n[o]=e,--i||c.resolve(n)},c.reject)},s=0;o>s;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function h(t,r){var n=_.call(arguments,1);return e(t,function(t){var o;return o=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,o)})})},A.apply(t,n)})}function m(t,r,n){var o=arguments.length>2;return e(t,function(e){return e=o?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function d(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function T(){}function R(e){return e}var A,_,v;return e.defer=a,e.resolve=t,e.reject=r,e.join=E,e.all=l,e.map=f,e.reduce=h,e.any=c,e.some=s,e.chain=m,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(v,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(v,t)})})}},_=[].slice,A=[].reduce||function(e){var t,r,n,o,i;if(i=0,t=Object(this),o=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=o)throw new TypeError}else n=r[1];for(;o>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/formatError",["./defined"],function(e){"use strict";var t=function(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r};return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";var n=function(n){var o,i=[],a={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;i.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=n(s.parameters,i)}catch(c){c instanceof Error?a.error={name:c.name,message:c.message,stack:c.stack}:a.error=c}t(o)||(o=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(i.length=0);try{o(a,i)}catch(c){a.result=void 0,a.error="postMessage failed with error: "+r(c)+"\n  with responseMessage: "+JSON.stringify(a),o(a)}}};return n}),define("Workers/createGeometry",["../Core/defined","../Scene/PrimitivePipeline","../ThirdParty/when","./createTaskProcessorWorker","require"],function(e,t,r,n,o){"use strict";function i(t){var r=u[t];return e(r)||("object"==typeof exports?u[r]=r=o("Workers/"+t):o(["./"+t],function(e){r=e,u[r]=e})),r}function a(r,n){for(var o=r.subTasks,a=o.length,u=new Array(a),s=0;a>s;s++){var c=o[s],l=c.geometry,E=c.moduleName;if(e(E)){var f=i(E);u[s]=f(l,c.offset)}else u[s]=l}return t.packCreateGeometryResults(u,n)}var u={};return n(a)})}();