/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var e=function(t,e){return void 0!==t?t:e};return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var e=function(t){this.name="DeveloperError",this.message=t;var e=new Error;this.stack=e.stack};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,r,n){"use strict";var o=function(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)};o.fromSpherical=function(r,n){e(n)||(n=new o);var a=r.clock,i=r.cone,s=t(r.magnitude,1),u=s*Math.sin(i);return n.x=u*Math.cos(a),n.y=u*Math.sin(a),n.z=s*Math.cos(i),n},o.fromElements=function(t,r,n,a){return e(a)?(a.x=t,a.y=r,a.z=n,a):new o(t,r,n)},o.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r.z=t.z,r):new o(t.x,t.y,t.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z},o.unpack=function(r,n,a){return n=t(n,0),e(a)||(a=new o),a.x=r[n++],a.y=r[n++],a.z=r[n],a},o.fromArray=o.unpack,o.getMaximumComponent=function(t){return Math.max(t.x,t.y,t.z)},o.getMinimumComponent=function(t){return Math.min(t.x,t.y,t.z)},o.getMinimumByComponent=function(t,r,n){return e(n)||(n=new o),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.getMaximumByComponent=function(t,r,n){return e(n)||(n=new o),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(t){return Math.sqrt(o.magnitudeSquared(t))};var a=new o;o.distance=function(t,e){return o.subtract(t,e,a),o.magnitude(a)},o.normalize=function(t,r){var n=o.magnitude(t);return e(r)?(r.x=t.x/n,r.y=t.y/n,r.z=t.z/n,r):new o(t.x/n,t.y/n,t.z/n)},o.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},o.multiplyComponents=function(t,r,n){return e(n)?(n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n):new o(t.x*r.x,t.y*r.y,t.z*r.z)},o.add=function(t,r,n){return e(n)?(n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n):new o(t.x+r.x,t.y+r.y,t.z+r.z)},o.subtract=function(t,r,n){return e(n)?(n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n):new o(t.x-r.x,t.y-r.y,t.z-r.z)},o.multiplyByScalar=function(t,r,n){return e(n)?(n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n):new o(t.x*r,t.y*r,t.z*r)},o.divideByScalar=function(t,r,n){return e(n)?(n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n):new o(t.x/r,t.y/r,t.z/r)},o.negate=function(t,r){return e(r)?(r.x=-t.x,r.y=-t.y,r.z=-t.z,r):new o(-t.x,-t.y,-t.z)},o.abs=function(t,r){return e(r)?(r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r):new o(Math.abs(t.x),Math.abs(t.y),Math.abs(t.z))};var i=new o;o.lerp=function(t,e,r,n){return o.multiplyByScalar(e,r,i),n=o.multiplyByScalar(t,1-r,n),o.add(i,n,n)};var s=new o,u=new o;o.angleBetween=function(t,e){o.normalize(t,s),o.normalize(e,u);var r=o.dot(s,u),n=o.magnitude(o.cross(s,u,s));return Math.atan2(n,r)};var l=new o;return o.mostOrthogonalAxis=function(t,e){var r=o.normalize(t,l);return o.abs(r,r),e=r.x<=r.y?r.x<=r.z?o.clone(o.UNIT_X,e):o.clone(o.UNIT_Z,e):r.y<=r.z?o.clone(o.UNIT_Y,e):o.clone(o.UNIT_Z,e)},o.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y&&t.z===r.z},o.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t.x-r.x)<=n&&Math.abs(t.y-r.y)<=n&&Math.abs(t.z-r.z)<=n},o.cross=function(t,r,n){var a=t.x,i=t.y,s=t.z,u=r.x,l=r.y,c=r.z,f=i*c-s*l,h=s*u-a*c,m=a*l-i*u;return e(n)?(n.x=f,n.y=h,n.z=m,n):new o(f,h,m)},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(t){return o.clone(this,t)},o.prototype.equals=function(t){return o.equals(this,t)},o.prototype.equalsEpsilon=function(t,e){return o.equalsEpsilon(this,t,e)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,r,n){"use strict";var o=function(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)};o.fromElements=function(t,r,n,a,i){return e(i)?(i.x=t,i.y=r,i.z=n,i.w=a,i):new o(t,r,n,a)},o.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r.z=t.z,r.w=t.w,r):new o(t.x,t.y,t.z,t.w):void 0},o.packedLength=4,o.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},o.unpack=function(r,n,a){return n=t(n,0),e(a)||(a=new o),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},o.fromArray=o.unpack,o.getMaximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},o.getMinimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},o.getMinimumByComponent=function(t,r,n){return e(n)||(n=new o),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.getMaximumByComponent=function(t,r,n){return e(n)||(n=new o),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(t){return Math.sqrt(o.magnitudeSquared(t))};var a=new o;o.distance=function(t,e){return o.subtract(t,e,a),o.magnitude(a)},o.normalize=function(t,r){var n=o.magnitude(t);return e(r)?(r.x=t.x/n,r.y=t.y/n,r.z=t.z/n,r.w=t.w/n,r):new o(t.x/n,t.y/n,t.z/n,t.w/n)},o.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},o.multiplyComponents=function(t,r,n){return e(n)?(n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n):new o(t.x*r.x,t.y*r.y,t.z*r.z,t.w*r.w)},o.add=function(t,r,n){return e(n)?(n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n):new o(t.x+r.x,t.y+r.y,t.z+r.z,t.w+r.w)},o.subtract=function(t,r,n){return e(n)?(n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n):new o(t.x-r.x,t.y-r.y,t.z-r.z,t.w-r.w)},o.multiplyByScalar=function(t,r,n){return e(n)?(n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n):new o(t.x*r,t.y*r,t.z*r,t.w*r)},o.divideByScalar=function(t,r,n){return e(n)?(n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n):new o(t.x/r,t.y/r,t.z/r,t.w/r)},o.negate=function(t,r){return e(r)?(r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r):new o(-t.x,-t.y,-t.z,-t.w)},o.abs=function(t,r){return e(r)?(r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r):new o(Math.abs(t.x),Math.abs(t.y),Math.abs(t.z),Math.abs(t.w))};var i=new o;o.lerp=function(t,e,r,n){return o.multiplyByScalar(e,r,i),n=o.multiplyByScalar(t,1-r,n),o.add(i,n,n)};var s=new o;return o.mostOrthogonalAxis=function(t,e){var r=o.normalize(t,s);return o.abs(r,r),e=r.x<=r.y?r.x<=r.z?r.x<=r.w?o.clone(o.UNIT_X,e):o.clone(o.UNIT_W,e):r.z<=r.w?o.clone(o.UNIT_Z,e):o.clone(o.UNIT_W,e):r.y<=r.z?r.y<=r.w?o.clone(o.UNIT_Y,e):o.clone(o.UNIT_W,e):r.z<=r.w?o.clone(o.UNIT_Z,e):o.clone(o.UNIT_W,e)},o.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y&&t.z===r.z&&t.w===r.w},o.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t.x-r.x)<=n&&Math.abs(t.y-r.y)<=n&&Math.abs(t.z-r.z)<=n&&Math.abs(t.w-r.w)<=n},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(t){return o.clone(this,t)},o.prototype.equals=function(t){return o.equals(this,t)},o.prototype.equalsEpsilon=function(t,e){return o.equalsEpsilon(this,t,e)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)t=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^t>>>1^e[1&t];for(;r<this.N-1;r++)t=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=2636928640&t<<7,t^=4022730752&t<<15,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["./defaultValue","./defined","./DeveloperError","../ThirdParty/mersenne-twister"],function(t,e,r,n){"use strict";var o={};o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=function(t){return t>0?1:0>t?-1:0},o.sinh=function(t){var e=Math.pow(Math.E,t),r=Math.pow(Math.E,-1*t);return.5*(e-r)},o.cosh=function(t){var e=Math.pow(Math.E,t),r=Math.pow(Math.E,-1*t);return.5*(e+r)},o.lerp=function(t,e,r){return(1-r)*t+r*e},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=.5*Math.PI,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=.5*3*Math.PI,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(t){return t*o.RADIANS_PER_DEGREE},o.toDegrees=function(t){return t*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(t){var e=o.TWO_PI,r=t-Math.floor(t/e)*e;return r<-Math.PI?r+e:r>=Math.PI?r-e:r},o.negativePiToPi=function(t){for(var e=o.EPSILON10,r=o.PI,n=o.TWO_PI;-(r+e)>t;)t+=n;if(-r>t)return-r;for(;t>r+e;)t-=n;return t>r?r:t},o.zeroToTwoPi=function(t){var e=t%o.TWO_PI;return 0>e?(e+o.TWO_PI)%o.TWO_PI:e},o.equalsEpsilon=function(e,r,n){return n=t(n,0),Math.abs(e-r)<=n};var a=[1];o.factorial=function(t){var e=a.length;if(t>=e)for(var r=a[e-1],n=e;t>=n;n++)a.push(r*n);return a[t]},o.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},o.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},o.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},o.clamp=function(t,e,r){return e>t?e:t>r?r:t};var i=new n;return o.setRandomNumberSeed=function(t){i=new n(t)},o.nextRandomNumber=function(){return i.random()},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,o){"use strict";var a=function(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)};return a.fromDegrees=function(r,n,i,s){return r=o.toRadians(t(r,0)),n=o.toRadians(t(n,0)),i=t(i,0),e(s)?(s.longitude=r,s.latitude=n,s.height=i,s):new a(r,n,i)},a.clone=function(t,r){return e(t)?e(r)?(r.longitude=t.longitude,r.latitude=t.latitude,r.height=t.height,r):new a(t.longitude,t.latitude,t.height):void 0},a.equals=function(t,r){return t===r||e(t)&&e(r)&&t.longitude===r.longitude&&t.latitude===r.latitude&&t.height===r.height},a.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t.longitude-r.longitude)<=n&&Math.abs(t.latitude-r.latitude)<=n&&Math.abs(t.height-r.height)<=n},a.toString=function(t){return"("+t.longitude+", "+t.latitude+", "+t.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/Ellipsoid",["./freezeObject","./defaultValue","./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic"],function(t,e,r,n,o,a,i){"use strict";var s=function(t,r,n){t=e(t,0),r=e(r,0),n=e(n,0),this._radii=new a(t,r,n),this._radiiSquared=new a(t*t,r*r,n*n),this._radiiToTheFourth=new a(t*t*t*t,r*r*r*r,n*n*n*n),this._oneOverRadii=new a(0===t?0:1/t,0===r?0:1/r,0===n?0:1/n),this._oneOverRadiiSquared=new a(0===t?0:1/(t*t),0===r?0:1/(r*r),0===n?0:1/(n*n)),this._minimumRadius=Math.min(t,r,n),this._maximumRadius=Math.max(t,r,n),this._centerToleranceSquared=o.EPSILON1};s.clone=function(t,e){if(!r(t))return void 0;var n=t._radii;return r(e)?(a.clone(n,e._radii),a.clone(t._radiiSquared,e._radiiSquared),a.clone(t._radiiToTheFourth,e._radiiToTheFourth),a.clone(t._oneOverRadii,e._oneOverRadii),a.clone(t._oneOverRadiiSquared,e._oneOverRadiiSquared),e._minimumRadius=t._minimumRadius,e._maximumRadius=t._maximumRadius,e._centerToleranceSquared=t._centerToleranceSquared,e):new s(n.x,n.y,n.z)},s.fromCartesian3=function(t){return r(t)?new s(t.x,t.y,t.z):new s},s.WGS84=t(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=t(new s(1,1,1)),s.MOON=t(new s(o.LUNAR_RADIUS,o.LUNAR_RADIUS,o.LUNAR_RADIUS)),s.prototype.getRadii=function(){return this._radii},s.prototype.getRadiiSquared=function(){return this._radiiSquared},s.prototype.getRadiiToTheFourth=function(){return this._radiiToTheFourth},s.prototype.getOneOverRadii=function(){return this._oneOverRadii},s.prototype.getOneOverRadiiSquared=function(){return this._oneOverRadiiSquared},s.prototype.getMinimumRadius=function(){return this._minimumRadius},s.prototype.getMaximumRadius=function(){return this._maximumRadius},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.geocentricSurfaceNormal=a.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(t,e){var n=t.longitude,o=t.latitude,i=Math.cos(o),s=i*Math.cos(n),u=i*Math.sin(n),l=Math.sin(o);return r(e)||(e=new a),e.x=s,e.y=u,e.z=l,a.normalize(e,e)},s.prototype.geodeticSurfaceNormal=function(t,e){return e=a.multiplyComponents(t,this._oneOverRadiiSquared,e),a.normalize(e,e)};var u=new a,l=new a;s.prototype.cartographicToCartesian=function(t,e){var r=u,n=l;this.geodeticSurfaceNormalCartographic(t,r),a.multiplyComponents(this._radiiSquared,r,n);var o=Math.sqrt(a.dot(r,n));return a.divideByScalar(n,o,n),a.multiplyByScalar(r,t.height,r),a.add(n,r,e)},s.prototype.cartographicArrayToCartesianArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var o=0;n>o;o++)e[o]=this.cartographicToCartesian(t[o],e[o]);return e};var c=new a,f=new a,h=new a;s.prototype.cartesianToCartographic=function(t,e){var n=this.scaleToGeodeticSurface(t,f);if(!r(n))return void 0;var s=this.geodeticSurfaceNormal(n,c),u=a.subtract(t,n,h),l=Math.atan2(s.y,s.x),m=Math.asin(s.z),y=o.sign(a.dot(u,t))*a.magnitude(u);return r(e)?(e.longitude=l,e.latitude=m,e.height=y,e):new i(l,m,y)},s.prototype.cartesianArrayToCartographicArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var o=0;n>o;++o)e[o]=this.cartesianToCartographic(t[o],e[o]);return e};var m=new a,y=new a;return s.prototype.scaleToGeodeticSurface=function(t,e){var n=t.x,i=t.y,s=t.z,u=this._oneOverRadii,l=u.x,c=u.y,f=u.z,h=n*n*l*l,p=i*i*c*c,d=s*s*f*f,v=h+p+d,g=Math.sqrt(1/v),E=a.multiplyByScalar(t,g,m);if(v<this._centerToleranceSquared)return isFinite(g)?a.clone(E,e):void 0;var w=this._oneOverRadiiSquared,C=w.x,S=w.y,x=w.z,M=y;M.x=2*E.x*C,M.y=2*E.y*S,M.z=2*E.z*x;var A,b,T,O,I,N,R,z,L,F,D,P=(1-g)*a.magnitude(t)/(.5*a.magnitude(M)),_=0;do{P-=_,T=1/(1+P*C),O=1/(1+P*S),I=1/(1+P*x),N=T*T,R=O*O,z=I*I,L=N*T,F=R*O,D=z*I,A=h*N+p*R+d*z-1,b=h*L*C+p*F*S+d*D*x;var B=-2*b;_=A/B}while(Math.abs(A)>o.EPSILON12);return r(e)?(e.x=n*T,e.y=i*O,e.z=s*I,e):new a(n*T,i*O,s*I)},s.prototype.scaleToGeocentricSurface=function(t,e){var r=t.x,n=t.y,o=t.z,i=this._oneOverRadiiSquared,s=1/Math.sqrt(r*r*i.x+n*n*i.y+o*o*i.z);return a.multiplyByScalar(t,s,e)},s.prototype.transformPositionToScaledSpace=function(t,e){return a.multiplyComponents(t,this._oneOverRadii,e)},s.prototype.transformPositionFromScaledSpace=function(t,e){return a.multiplyComponents(t,this._radii,e)},s.prototype.equals=function(t){return this===t||r(t)&&a.equals(this._radii,t._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./defaultValue","./defined","./Cartesian3","./Cartographic","./Ellipsoid"],function(t,e,r,n,o){"use strict";var a=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.getMaximumRadius(),this._oneOverSemimajorAxis=1/this._semimajorAxis};return a.prototype.getEllipsoid=function(){return this._ellipsoid},a.prototype.project=function(t,n){var o=this._semimajorAxis,a=t.longitude*o,i=t.latitude*o,s=t.height;return e(n)?(n.x=a,n.y=i,n.z=s,n):new r(a,i,s)},a.prototype.unproject=function(t,r){var o=this._oneOverSemimajorAxis,a=t.x*o,i=t.y*o,s=t.z;return e(r)?(r.longitude=a,r.latitude=i,r.height=s,r):new n(a,i,s)},a}),define("Core/Enumeration",["./defined"],function(t){"use strict";var e=function(e,r,n){if(this.value=e,this.name=r,t(n))for(var o in n)n.hasOwnProperty(o)&&(this[o]=n[o])};return e.prototype.valueOf=function(){return this.value},e.prototype.toString=function(){return this.name},e}),define("Core/Intersect",["./Enumeration"],function(t){"use strict";var e={OUTSIDE:new t(-1,"OUTSIDE"),INTERSECTING:new t(0,"INTERSECTING"),INSIDE:new t(1,"INSIDE")};return e}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var e=function(e,r){this.start=t(e,0),this.stop=t(r,0)};return e}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,o,a){"use strict";function i(t){for(var e=0,r=0;9>r;++r){var n=t[r];e+=n*n}return Math.sqrt(e)}function s(t){for(var e=0,r=0;3>r;++r){var n=t[l.getElementIndex(f[r],c[r])];e+=2*n*n}return Math.sqrt(e)}function u(t,e){for(var r=a.EPSILON15,n=0,o=1,i=0;3>i;++i){var s=Math.abs(t[l.getElementIndex(f[i],c[i])]);s>n&&(o=i,n=s)}var u=1,h=0,m=c[o],y=f[o];if(Math.abs(t[l.getElementIndex(y,m)])>r){var p,d=t[l.getElementIndex(y,y)],v=t[l.getElementIndex(m,m)],g=t[l.getElementIndex(y,m)],E=(d-v)/2/g;p=0>E?-1/(-E+Math.sqrt(1+E*E)):1/(E+Math.sqrt(1+E*E)),u=1/Math.sqrt(1+p*p),h=p*u}return e=l.clone(l.IDENTITY,e),e[l.getElementIndex(m,m)]=e[l.getElementIndex(y,y)]=u,e[l.getElementIndex(y,m)]=h,e[l.getElementIndex(m,y)]=-h,e}var l=function(t,r,n,o,a,i,s,u,l){this[0]=e(t,0),this[1]=e(o,0),this[2]=e(s,0),this[3]=e(r,0),this[4]=e(a,0),this[5]=e(u,0),this[6]=e(n,0),this[7]=e(i,0),this[8]=e(l,0)};l.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new l(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},l.fromArray=function(t,n,o){return n=e(n,0),r(o)||(o=new l),o[0]=t[n],o[1]=t[n+1],o[2]=t[n+2],o[3]=t[n+3],o[4]=t[n+4],o[5]=t[n+5],o[6]=t[n+6],o[7]=t[n+7],o[8]=t[n+8],o[9]=t[n+9],o},l.fromColumnMajorArray=function(t,e){return l.clone(t,e)},l.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new l(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},l.fromQuaternion=function(t,e){var n=t.x*t.x,o=t.x*t.y,a=t.x*t.z,i=t.x*t.w,s=t.y*t.y,u=t.y*t.z,c=t.y*t.w,f=t.z*t.z,h=t.z*t.w,m=t.w*t.w,y=n-s-f+m,p=2*(o-h),d=2*(a+c),v=2*(o+h),g=-n+s-f+m,E=2*(u-i),w=2*(a-c),C=2*(u+i),S=-n-s+f+m;return r(e)?(e[0]=y,e[1]=v,e[2]=w,e[3]=p,e[4]=g,e[5]=C,e[6]=d,e[7]=E,e[8]=S,e):new l(y,p,d,v,g,E,w,C,S)},l.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new l(t.x,0,0,0,t.y,0,0,0,t.z)},l.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new l(t,0,0,0,t,0,0,0,t)},l.fromRotationX=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=n,e[5]=o,e[6]=0,e[7]=-o,e[8]=n,e):new l(1,0,0,0,n,-o,0,o,n)},l.fromRotationY=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=n,e[1]=0,e[2]=-o,e[3]=0,e[4]=1,e[5]=0,e[6]=o,e[7]=0,e[8]=n,e):new l(n,0,o,0,1,0,-o,0,n)},l.fromRotationZ=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=n,e[1]=o,e[2]=0,e[3]=-o,e[4]=n,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new l(n,-o,0,o,n,0,0,0,1)},l.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},l.getElementIndex=function(t,e){return 3*t+e},l.getColumn=function(e,n,o){var a=3*n,i=e[a],s=e[a+1],u=e[a+2];return r(o)?(o.x=i,o.y=s,o.z=u,o):new t(i,s,u)},l.setColumn=function(t,e,r,n){n=l.clone(t,n);var o=3*e;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},l.getRow=function(e,n,o){var a=e[n],i=e[n+3],s=e[n+6];return r(o)?(o.x=a,o.y=i,o.z=s,o):new t(a,i,s)},l.setRow=function(t,e,r,n){return n=l.clone(t,n),n[e]=r.x,n[e+3]=r.y,n[e+6]=r.z,n},l.multiply=function(t,e,n){var o=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],a=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],i=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],s=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],u=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],c=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],f=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],h=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],m=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return r(n)?(n[0]=o,n[1]=a,n[2]=i,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=h,n[8]=m,n):new l(o,s,f,a,u,h,i,c,m)},l.multiplyByVector=function(e,n,o){var a=n.x,i=n.y,s=n.z,u=e[0]*a+e[3]*i+e[6]*s,l=e[1]*a+e[4]*i+e[7]*s,c=e[2]*a+e[5]*i+e[8]*s;return r(o)?(o.x=u,o.y=l,o.z=c,o):new t(u,l,c)},l.multiplyByScalar=function(t,e,n){return r(n)?(n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n):new l(t[0]*e,t[3]*e,t[6]*e,t[1]*e,t[4]*e,t[7]*e,t[2]*e,t[5]*e,t[8]*e)},l.negate=function(t,e){return r(e)?(e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e):new l(-t[0],-t[3],-t[6],-t[1],-t[4],-t[7],-t[2],-t[5],-t[8])},l.transpose=function(t,e){var n=t[0],o=t[3],a=t[6],i=t[1],s=t[4],u=t[7],c=t[2],f=t[5],h=t[8];return r(e)?(e[0]=n,e[1]=o,e[2]=a,e[3]=i,e[4]=s,e[5]=u,e[6]=c,e[7]=f,e[8]=h,e):new l(n,i,c,o,s,f,a,u,h)};var c=[1,0,0],f=[2,2,1],h=new l,m=new l;return l.getEigenDecomposition=function(t,e){var n=a.EPSILON20,o=10,c=0,f=0;r(e)||(e={});for(var y=e.unitary=l.clone(l.IDENTITY,e.unitary),p=e.diagonal=l.clone(t,e.diagonal),d=n*i(p);o>f&&s(p)>d;)u(p,h),l.transpose(h,m),l.multiply(p,h,p),l.multiply(m,p,p),l.multiply(y,h,y),++c>2&&(++f,c=0);return e},l.abs=function(t,e){return r(e)?(e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e):new l(Math.abs(t[0]),Math.abs(t[3]),Math.abs(t[6]),Math.abs(t[1]),Math.abs(t[4]),Math.abs(t[7]),Math.abs(t[2]),Math.abs(t[5]),Math.abs(t[8]))},l.determinant=function(t){var e=t[0],r=t[3],n=t[6],o=t[1],a=t[4],i=t[7],s=t[2],u=t[5],l=t[8];return e*(a*l-u*i)+o*(u*n-r*l)+s*(r*i-a*n)},l.inverse=function(t,e){var r=t[0],o=t[1],i=t[2],s=t[3],u=t[4],c=t[5],f=t[6],h=t[7],m=t[8],y=l.determinant(t);if(Math.abs(y)<=a.EPSILON15)throw new n("matrix is not invertible");var p=new l(u*m-h*c,f*c-s*m,s*h-f*u,h*i-o*m,r*m-f*i,f*o-r*h,o*c-u*i,s*i-r*c,r*u-s*o),d=1/y;return l.multiplyByScalar(p,d,e)},l.equals=function(t,e){return t===e||r(t)&&r(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},l.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n},l.IDENTITY=o(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(t){return l.clone(this,t)},l.prototype.equals=function(t){return l.equals(this,t)},l.prototype.equalsEpsilon=function(t,e){return l.equalsEpsilon(this,t,e)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var e=function(t){this.name="RuntimeError",this.message=t;var e=new Error;this.stack=e.stack};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,r,n,o,a,i,s,u){"use strict";var l=function(t,e,n,o,a,i,s,u,l,c,f,h,m,y,p,d){this[0]=r(t,0),this[1]=r(a,0),this[2]=r(l,0),this[3]=r(m,0),this[4]=r(e,0),this[5]=r(i,0),this[6]=r(c,0),this[7]=r(y,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(o,0),this[13]=r(u,0),this[14]=r(h,0),this[15]=r(d,0)};l.clone=function(t,e){return n(t)?n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new l(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},l.fromArray=function(t,e,o){return e=r(e,0),n(o)||(o=new l),o[0]=t[e],o[1]=t[e+1],o[2]=t[e+2],o[3]=t[e+3],o[4]=t[e+4],o[5]=t[e+5],o[6]=t[e+6],o[7]=t[e+7],o[8]=t[e+8],o[9]=t[e+9],o[10]=t[e+10],o[11]=t[e+11],o[12]=t[e+12],o[13]=t[e+13],o[14]=t[e+14],o[15]=t[e+15],o},l.fromColumnMajorArray=function(t,e){return l.clone(t,e)},l.fromRowMajorArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new l(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},l.fromRotationTranslation=function(t,e,r){return n(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=0,r[4]=t[3],r[5]=t[4],r[6]=t[5],r[7]=0,r[8]=t[6],r[9]=t[7],r[10]=t[8],r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new l(t[0],t[3],t[6],e.x,t[1],t[4],t[7],e.y,t[2],t[5],t[8],e.z,0,0,0,1)},new s,l.fromTranslationQuaternionRotationScale=function(t,e,r,o){n(o)||(o=new l);var a=r.x,i=r.y,s=r.z,u=e.x*e.x,c=e.x*e.y,f=e.x*e.z,h=e.x*e.w,m=e.y*e.y,y=e.y*e.z,p=e.y*e.w,d=e.z*e.z,v=e.z*e.w,g=e.w*e.w,E=u-m-d+g,w=2*(c-v),C=2*(f+p),S=2*(c+v),x=-u+m-d+g,M=2*(y-h),A=2*(f-p),b=2*(y+h),T=-u-m+d+g;return o[0]=E*a,o[1]=S*a,o[2]=A*a,o[3]=0,o[4]=w*i,o[5]=x*i,o[6]=b*i,o[7]=0,o[8]=C*s,o[9]=M*s,o[10]=T*s,o[11]=0,o[12]=t.x,o[13]=t.y,o[14]=t.z,o[15]=1,o},l.fromTranslation=function(t,e){return l.fromRotationTranslation(s.IDENTITY,t,e)},l.fromScale=function(t,e){return n(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new l(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},l.fromUniformScale=function(t,e){return n(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new l(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var c=new t,f=new t,h=new t;l.fromCamera=function(e,r){var o=e.eye,a=e.target,i=e.up;t.normalize(t.subtract(a,o,c),c),t.normalize(t.cross(c,i,f),f),t.normalize(t.cross(f,c,h),h);var s=f.x,u=f.y,m=f.z,y=c.x,p=c.y,d=c.z,v=h.x,g=h.y,E=h.z,w=o.x,C=o.y,S=o.z,x=s*-w+u*-C+m*-S,M=v*-w+g*-C+E*-S,A=y*w+p*C+d*S;return n(r)?(r[0]=s,r[1]=v,r[2]=-y,r[3]=0,r[4]=u,r[5]=g,r[6]=-p,r[7]=0,r[8]=m,r[9]=E,r[10]=-d,r[11]=0,r[12]=x,r[13]=M,r[14]=A,r[15]=1,r):new l(s,u,m,x,v,g,E,M,-y,-p,-d,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(t,e,r,o,a){var i=Math.tan(.5*t),s=1/i,u=s/e,c=(o+r)/(r-o),f=2*o*r/(r-o);return n(a)?(a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a):new l(u,0,0,0,0,s,0,0,0,0,c,f,0,0,-1,0)},l.computeOrthographicOffCenter=function(t,e,r,o,a,i,s){var u=1/(e-t),c=1/(o-r),f=1/(i-a),h=-(e+t)*u,m=-(o+r)*c,y=-(i+a)*f;return u*=2,c*=2,f*=-2,n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=h,s[13]=m,s[14]=y,s[15]=1,s):new l(u,0,0,h,0,c,0,m,0,0,f,y,0,0,0,1)},l.computePerspectiveOffCenter=function(t,e,r,o,a,i,s){var u=2*a/(e-t),c=2*a/(o-r),f=(e+t)/(e-t),h=(o+r)/(o-r),m=-(i+a)/(i-a),y=-1,p=-2*i*a/(i-a);return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=h,s[10]=m,s[11]=y,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new l(u,0,f,0,0,c,h,0,0,0,m,p,0,0,y,0)},l.computeInfinitePerspectiveOffCenter=function(t,e,r,o,a,i){var s=2*a/(e-t),u=2*a/(o-r),c=(e+t)/(e-t),f=(o+r)/(o-r),h=-1,m=-1,y=-2*a;return n(i)?(i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=c,i[9]=f,i[10]=h,i[11]=m,i[12]=0,i[13]=0,i[14]=y,i[15]=0,i):new l(s,0,c,0,0,u,f,0,0,0,h,y,0,0,m,0)},l.computeViewportTransformation=function(t,e,o,a){t=r(t,r.EMPTY_OBJECT);var i=r(t.x,0),s=r(t.y,0),u=r(t.width,0),c=r(t.height,0);e=r(e,0),o=r(o,1);var f=.5*u,h=.5*c,m=.5*(o-e),y=f,p=h,d=m,v=i+f,g=s+h,E=e+m,w=1;return n(a)?(a[0]=y,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=p,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=d,a[11]=0,a[12]=v,a[13]=g,a[14]=E,a[15]=w,a):new l(y,0,0,v,0,p,0,g,0,0,d,E,0,0,0,w)},l.toArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},l.getElementIndex=function(t,e){return 4*t+e},l.getColumn=function(t,r,o){var a=4*r,i=t[a],s=t[a+1],u=t[a+2],l=t[a+3];return n(o)?(o.x=i,o.y=s,o.z=u,o.w=l,o):new e(i,s,u,l)},l.setColumn=function(t,e,r,n){n=l.clone(t,n);var o=4*e;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},l.getRow=function(t,r,o){var a=t[r],i=t[r+4],s=t[r+8],u=t[r+12];return n(o)?(o.x=a,o.y=i,o.z=s,o.w=u,o):new e(a,i,s,u)},l.setRow=function(t,e,r,n){return n=l.clone(t,n),n[e]=r.x,n[e+4]=r.y,n[e+8]=r.z,n[e+12]=r.w,n},l.multiply=function(t,e,r){var o=t[0],a=t[1],i=t[2],s=t[3],u=t[4],c=t[5],f=t[6],h=t[7],m=t[8],y=t[9],p=t[10],d=t[11],v=t[12],g=t[13],E=t[14],w=t[15],C=e[0],S=e[1],x=e[2],M=e[3],A=e[4],b=e[5],T=e[6],O=e[7],I=e[8],N=e[9],R=e[10],z=e[11],L=e[12],F=e[13],D=e[14],P=e[15],_=o*C+u*S+m*x+v*M,B=a*C+c*S+y*x+g*M,U=i*C+f*S+p*x+E*M,G=s*C+h*S+d*x+w*M,q=o*A+u*b+m*T+v*O,W=a*A+c*b+y*T+g*O,Y=i*A+f*b+p*T+E*O,V=s*A+h*b+d*T+w*O,H=o*I+u*N+m*R+v*z,k=a*I+c*N+y*R+g*z,j=i*I+f*N+p*R+E*z,K=s*I+h*N+d*R+w*z,Z=o*L+u*F+m*D+v*P,X=a*L+c*F+y*D+g*P,Q=i*L+f*F+p*D+E*P,J=s*L+h*F+d*D+w*P;return n(r)?(r[0]=_,r[1]=B,r[2]=U,r[3]=G,r[4]=q,r[5]=W,r[6]=Y,r[7]=V,r[8]=H,r[9]=k,r[10]=j,r[11]=K,r[12]=Z,r[13]=X,r[14]=Q,r[15]=J,r):new l(_,q,H,Z,B,W,k,X,U,Y,j,Q,G,V,K,J)},l.multiplyTransformation=function(t,e,r){var o=t[0],a=t[1],i=t[2],s=t[4],u=t[5],c=t[6],f=t[8],h=t[9],m=t[10],y=t[12],p=t[13],d=t[14],v=e[0],g=e[1],E=e[2],w=e[4],C=e[5],S=e[6],x=e[8],M=e[9],A=e[10],b=e[12],T=e[13],O=e[14],I=o*v+s*g+f*E,N=a*v+u*g+h*E,R=i*v+c*g+m*E,z=o*w+s*C+f*S,L=a*w+u*C+h*S,F=i*w+c*C+m*S,D=o*x+s*M+f*A,P=a*x+u*M+h*A,_=i*x+c*M+m*A,B=o*b+s*T+f*O+y,U=a*b+u*T+h*O+p,G=i*b+c*T+m*O+d;return n(r)?(r[0]=I,r[1]=N,r[2]=R,r[3]=0,r[4]=z,r[5]=L,r[6]=F,r[7]=0,r[8]=D,r[9]=P,r[10]=_,r[11]=0,r[12]=B,r[13]=U,r[14]=G,r[15]=1,r):new l(I,z,D,B,N,L,P,U,R,F,_,G,0,0,0,1)},l.multiplyByTranslation=function(t,e,r){var o=e.x,a=e.y,i=e.z,s=o*t[0]+a*t[4]+i*t[8]+t[12],u=o*t[1]+a*t[5]+i*t[9]+t[13],c=o*t[2]+a*t[6]+i*t[10]+t[14];return n(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=s,r[13]=u,r[14]=c,r[15]=t[15],r):new l(t[0],t[4],t[8],s,t[1],t[5],t[9],u,t[2],t[6],t[10],c,t[3],t[7],t[11],t[15])
};var m=new t;return l.multiplyByUniformScale=function(t,e,r){return m.x=e,m.y=e,m.z=e,l.multiplyByScale(t,m,r)},l.multiplyByScale=function(t,e,r){var o=e.x,a=e.y,i=e.z;return 1===o&&1===a&&1===i?l.clone(t,r):n(r)?(r[0]=o*t[0],r[1]=o*t[1],r[2]=o*t[2],r[3]=0,r[4]=a*t[4],r[5]=a*t[5],r[6]=a*t[6],r[7]=0,r[8]=i*t[8],r[9]=i*t[9],r[10]=i*t[10],r[11]=0,r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=1,r):new l(o*t[0],a*t[4],i*t[8],t[12],o*t[1],a*t[5],i*t[9],t[13],o*t[2],a*t[6],i*t[10],t[14],0,0,0,1)},l.multiplyByVector=function(t,r,o){var a=r.x,i=r.y,s=r.z,u=r.w,l=t[0]*a+t[4]*i+t[8]*s+t[12]*u,c=t[1]*a+t[5]*i+t[9]*s+t[13]*u,f=t[2]*a+t[6]*i+t[10]*s+t[14]*u,h=t[3]*a+t[7]*i+t[11]*s+t[15]*u;return n(o)?(o.x=l,o.y=c,o.z=f,o.w=h,o):new e(l,c,f,h)},l.multiplyByPointAsVector=function(e,r,o){var a=r.x,i=r.y,s=r.z,u=e[0]*a+e[4]*i+e[8]*s,l=e[1]*a+e[5]*i+e[9]*s,c=e[2]*a+e[6]*i+e[10]*s;return n(o)?(o.x=u,o.y=l,o.z=c,o):new t(u,l,c)},l.multiplyByPoint=function(e,r,o){var a=r.x,i=r.y,s=r.z,u=e[0]*a+e[4]*i+e[8]*s+e[12],l=e[1]*a+e[5]*i+e[9]*s+e[13],c=e[2]*a+e[6]*i+e[10]*s+e[14];return n(o)?(o.x=u,o.y=l,o.z=c,o):new t(u,l,c)},l.multiplyByScalar=function(t,e,r){return n(r)?(r[0]=t[0]*e,r[1]=t[1]*e,r[2]=t[2]*e,r[3]=t[3]*e,r[4]=t[4]*e,r[5]=t[5]*e,r[6]=t[6]*e,r[7]=t[7]*e,r[8]=t[8]*e,r[9]=t[9]*e,r[10]=t[10]*e,r[11]=t[11]*e,r[12]=t[12]*e,r[13]=t[13]*e,r[14]=t[14]*e,r[15]=t[15]*e,r):new l(t[0]*e,t[4]*e,t[8]*e,t[12]*e,t[1]*e,t[5]*e,t[9]*e,t[13]*e,t[2]*e,t[6]*e,t[10]*e,t[14]*e,t[3]*e,t[7]*e,t[11]*e,t[15]*e)},l.negate=function(t,e){return n(e)?(e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e):new l(-t[0],-t[4],-t[8],-t[12],-t[1],-t[5],-t[9],-t[13],-t[2],-t[6],-t[10],-t[14],-t[3],-t[7],-t[11],-t[15])},l.transpose=function(t,e){if(!n(e))return new l(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]);var r=t[1],o=t[2],a=t[3],i=t[6],s=t[7],u=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=r,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=o,e[9]=i,e[10]=t[10],e[11]=t[14],e[12]=a,e[13]=s,e[14]=u,e[15]=t[15],e},l.abs=function(t,e){return n(e)?(e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e):new l(Math.abs(t[0]),Math.abs(t[4]),Math.abs(t[8]),Math.abs(t[12]),Math.abs(t[1]),Math.abs(t[5]),Math.abs(t[9]),Math.abs(t[13]),Math.abs(t[2]),Math.abs(t[6]),Math.abs(t[10]),Math.abs(t[14]),Math.abs(t[3]),Math.abs(t[7]),Math.abs(t[11]),Math.abs(t[15]))},l.equals=function(t,e){return t===e||n(t)&&n(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},l.equalsEpsilon=function(t,e,r){return t===e||n(t)&&n(e)&&Math.abs(t[0]-e[0])<=r&&Math.abs(t[1]-e[1])<=r&&Math.abs(t[2]-e[2])<=r&&Math.abs(t[3]-e[3])<=r&&Math.abs(t[4]-e[4])<=r&&Math.abs(t[5]-e[5])<=r&&Math.abs(t[6]-e[6])<=r&&Math.abs(t[7]-e[7])<=r&&Math.abs(t[8]-e[8])<=r&&Math.abs(t[9]-e[9])<=r&&Math.abs(t[10]-e[10])<=r&&Math.abs(t[11]-e[11])<=r&&Math.abs(t[12]-e[12])<=r&&Math.abs(t[13]-e[13])<=r&&Math.abs(t[14]-e[14])<=r&&Math.abs(t[15]-e[15])<=r},l.getTranslation=function(e,r){return n(r)?(r.x=e[12],r.y=e[13],r.z=e[14],r):new t(e[12],e[13],e[14])},l.getRotation=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e):new s(t[0],t[4],t[8],t[1],t[5],t[9],t[2],t[6],t[10])},l.inverse=function(t,e){var r=t[0],o=t[4],a=t[8],s=t[12],c=t[1],f=t[5],h=t[9],m=t[13],y=t[2],p=t[6],d=t[10],v=t[14],g=t[3],E=t[7],w=t[11],C=t[15],S=d*C,x=v*w,M=p*C,A=v*E,b=p*w,T=d*E,O=y*C,I=v*g,N=y*w,R=d*g,z=y*E,L=p*g,F=S*f+A*h+b*m-(x*f+M*h+T*m),D=x*c+O*h+R*m-(S*c+I*h+N*m),P=M*c+I*f+z*m-(A*c+O*f+L*m),_=T*c+N*f+L*h-(b*c+R*f+z*h),B=x*o+M*a+T*s-(S*o+A*a+b*s),U=S*r+I*a+N*s-(x*r+O*a+R*s),G=A*r+O*o+L*s-(M*r+I*o+z*s),q=b*r+R*o+z*a-(T*r+N*o+L*a);S=a*m,x=s*h,M=o*m,A=s*f,b=o*h,T=a*f,O=r*m,I=s*c,N=r*h,R=a*c,z=r*f,L=o*c;var W=S*E+A*w+b*C-(x*E+M*w+T*C),Y=x*g+O*w+R*C-(S*g+I*w+N*C),V=M*g+I*E+z*C-(A*g+O*E+L*C),H=T*g+N*E+L*w-(b*g+R*E+z*w),k=M*d+T*v+x*p-(b*v+S*p+A*d),j=N*v+S*y+I*d-(O*d+R*v+x*y),K=O*p+L*v+A*y-(z*v+M*y+I*p),Z=z*d+b*y+R*p-(N*p+L*d+T*y),X=r*F+o*D+a*P+s*_;if(Math.abs(X)<i.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return X=1/X,n(e)?(e[0]=F*X,e[1]=D*X,e[2]=P*X,e[3]=_*X,e[4]=B*X,e[5]=U*X,e[6]=G*X,e[7]=q*X,e[8]=W*X,e[9]=Y*X,e[10]=V*X,e[11]=H*X,e[12]=k*X,e[13]=j*X,e[14]=K*X,e[15]=Z*X,e):new l(F*X,B*X,W*X,k*X,D*X,U*X,Y*X,j*X,P*X,G*X,V*X,K*X,_*X,q*X,H*X,Z*X)},l.inverseTransformation=function(t,e){var r=t[0],o=t[1],a=t[2],i=t[4],s=t[5],u=t[6],c=t[8],f=t[9],h=t[10],m=t[12],y=t[13],p=t[14],d=-r*m-o*y-a*p,v=-i*m-s*y-u*p,g=-c*m-f*y-h*p;return n(e)?(e[0]=r,e[1]=i,e[2]=c,e[3]=0,e[4]=o,e[5]=s,e[6]=f,e[7]=0,e[8]=a,e[9]=u,e[10]=h,e[11]=0,e[12]=d,e[13]=v,e[14]=g,e[15]=1,e):new l(r,o,a,d,i,s,u,v,c,f,h,g,0,0,0,1)},l.IDENTITY=a(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(t){return l.clone(this,t)},l.prototype.equals=function(t){return l.equals(this,t)},l.prototype.equalsEpsilon=function(t,e){return l.equalsEpsilon(this,t,e)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./defaultValue","./defined","./DeveloperError","./Cartesian3","./Cartesian4","./Cartographic","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4"],function(t,e,r,n,o,a,i,s,u,l,c){"use strict";var f=function(e,r){this.center=n.clone(t(e,n.ZERO)),this.radius=t(r,0)},h=new n,m=new n,y=new n,p=new n,d=new n,v=new n,g=new n,E=new n,w=new n,C=new n,S=new n,x=new n;f.fromPoints=function(t,r){if(e(r)||(r=new f),!e(t)||0===t.length)return r.center=n.clone(n.ZERO,r.center),r.radius=0,r;for(var o=n.clone(t[0],g),a=n.clone(o,h),i=n.clone(o,m),s=n.clone(o,y),u=n.clone(o,p),l=n.clone(o,d),c=n.clone(o,v),M=t.length,A=1;M>A;A++){n.clone(t[A],o);var b=o.x,T=o.y,O=o.z;b<a.x&&n.clone(o,a),b>u.x&&n.clone(o,u),T<i.y&&n.clone(o,i),T>l.y&&n.clone(o,l),O<s.z&&n.clone(o,s),O>c.z&&n.clone(o,c)}var I=n.magnitudeSquared(n.subtract(u,a,E)),N=n.magnitudeSquared(n.subtract(l,i,E)),R=n.magnitudeSquared(n.subtract(c,s,E)),z=a,L=u,F=I;N>F&&(F=N,z=i,L=l),R>F&&(F=R,z=s,L=c);var D=w;D.x=.5*(z.x+L.x),D.y=.5*(z.y+L.y),D.z=.5*(z.z+L.z);var P=n.magnitudeSquared(n.subtract(L,D,E)),_=Math.sqrt(P),B=C;B.x=a.x,B.y=i.y,B.z=s.z;var U=S;U.x=u.x,U.y=l.y,U.z=c.z;var G=n.multiplyByScalar(n.add(B,U,E),.5,x),q=0;for(A=0;M>A;A++){n.clone(t[A],o);var W=n.magnitude(n.subtract(o,G,E));W>q&&(q=W);var Y=n.magnitudeSquared(n.subtract(o,D,E));if(Y>P){var V=Math.sqrt(Y);_=.5*(_+V),P=_*_;var H=V-_;D.x=(_*D.x+H*o.x)/V,D.y=(_*D.y+H*o.y)/V,D.z=(_*D.z+H*o.z)/V}}return q>_?(n.clone(D,r.center),r.radius=_):(n.clone(G,r.center),r.radius=q),r};var M=new s,A=new n,b=new n,T=new a,O=new a;f.fromExtent2D=function(t,e,r){return f.fromExtentWithHeights2D(t,e,0,0,r)},f.fromExtentWithHeights2D=function(r,o,a,i,s){if(e(s)||(s=new f),!e(r))return s.center=n.clone(n.ZERO,s.center),s.radius=0,s;o=t(o,M),r.getSouthwest(T),T.height=a,r.getNortheast(O),O.height=i;var u=o.project(T,A),l=o.project(O,b),c=l.x-u.x,h=l.y-u.y,m=l.z-u.z;s.radius=.5*Math.sqrt(c*c+h*h+m*m);var y=s.center;return y.x=u.x+.5*c,y.y=u.y+.5*h,y.z=u.z+.5*m,s};var I=[];f.fromExtent3D=function(r,n,o,a){n=t(n,i.WGS84),o=t(o,0);var s;return e(r)&&(s=r.subsample(n,o,I)),f.fromPoints(s,a)},f.fromVertices=function(r,o,a,i){if(e(i)||(i=new f),!e(r)||0===r.length)return i.center=n.clone(n.ZERO,i.center),i.radius=0,i;o=t(o,n.ZERO),a=t(a,3);var s=g;s.x=r[0]+o.x,s.y=r[1]+o.y,s.z=r[2]+o.z;for(var u=n.clone(s,h),l=n.clone(s,m),c=n.clone(s,y),M=n.clone(s,p),A=n.clone(s,d),b=n.clone(s,v),T=r.length,O=0;T>O;O+=a){var I=r[O]+o.x,N=r[O+1]+o.y,R=r[O+2]+o.z;s.x=I,s.y=N,s.z=R,I<u.x&&n.clone(s,u),I>M.x&&n.clone(s,M),N<l.y&&n.clone(s,l),N>A.y&&n.clone(s,A),R<c.z&&n.clone(s,c),R>b.z&&n.clone(s,b)}var z=n.magnitudeSquared(n.subtract(M,u,E)),L=n.magnitudeSquared(n.subtract(A,l,E)),F=n.magnitudeSquared(n.subtract(b,c,E)),D=u,P=M,_=z;L>_&&(_=L,D=l,P=A),F>_&&(_=F,D=c,P=b);var B=w;B.x=.5*(D.x+P.x),B.y=.5*(D.y+P.y),B.z=.5*(D.z+P.z);var U=n.magnitudeSquared(n.subtract(P,B,E)),G=Math.sqrt(U),q=C;q.x=u.x,q.y=l.y,q.z=c.z;var W=S;W.x=M.x,W.y=A.y,W.z=b.z;var Y=n.multiplyByScalar(n.add(q,W,E),.5,x),V=0;for(O=0;T>O;O+=a){s.x=r[O]+o.x,s.y=r[O+1]+o.y,s.z=r[O+2]+o.z;var H=n.magnitude(n.subtract(s,Y,E));H>V&&(V=H);var k=n.magnitudeSquared(n.subtract(s,B,E));if(k>U){var j=Math.sqrt(k);G=.5*(G+j),U=G*G;var K=j-G;B.x=(G*B.x+K*s.x)/j,B.y=(G*B.y+K*s.y)/j,B.z=(G*B.z+K*s.z)/j}}return V>G?(n.clone(B,i.center),i.radius=G):(n.clone(Y,i.center),i.radius=V),i},f.fromCornerPoints=function(t,r,o){e(o)||(o=new f);var a=o.center;return n.add(t,r,a),n.multiplyByScalar(a,.5,a),o.radius=n.distance(a,r),o},f.fromEllipsoid=function(t,r){return e(r)||(r=new f),n.clone(n.ZERO,r.center),r.radius=t.getMaximumRadius(),r},f.clone=function(t,r){return e(t)?e(r)?(r.center=n.clone(t.center,r.center),r.radius=t.radius,r):new f(t.center,t.radius):void 0};var N=new n,R=new n;f.union=function(t,r,o){e(o)||(o=new f);var a=t.center,i=r.center;n.add(a,i,R);var s=n.multiplyByScalar(R,.5,R),u=n.magnitude(n.subtract(a,s,N))+t.radius,l=n.magnitude(n.subtract(i,s,N))+r.radius;return o.radius=Math.max(u,l),n.clone(s,o.center),o};var z=new n;f.expand=function(t,e,r){r=f.clone(t,r);var o=n.magnitude(n.subtract(e,r.center,z));return o>r.radius&&(r.radius=o),r},f.intersect=function(t,e){var r=t.center,o=t.radius,a=n.dot(e,r)+e.w;return-o>a?u.OUTSIDE:o>a?u.INTERSECTING:u.INSIDE};var L=new n;f.transform=function(t,r,o){return e(o)||(o=new f),o.center=c.multiplyByPoint(r,t.center,o.center),o.radius=Math.max(n.magnitude(c.getColumn(r,0,L)),n.magnitude(c.getColumn(r,1,L)),n.magnitude(c.getColumn(r,2,L)))*t.radius,o},f.transformWithoutScale=function(t,r,n){return e(n)||(n=new f),n.center=c.multiplyByPoint(r,t.center,n.center),n.radius=t.radius,n};var F=new n;f.getPlaneDistances=function(t,r,o,a){e(a)||(a=new l);var i=n.subtract(t.center,r,F),s=n.multiplyByScalar(o,n.dot(o,i),F),u=n.magnitude(s);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var D=new n,P=new n,_=new n,B=new n,U=new n,G=new a,q=new Array(8),W=0;8>W;++W)q[W]=new n;var Y=new s;return f.projectTo2D=function(e,r,o){r=t(r,Y);var a=r.getEllipsoid(),i=e.center,s=e.radius,u=a.geodeticSurfaceNormal(i,D),l=n.cross(n.UNIT_Z,u,P);n.normalize(l,l);var c=n.cross(u,l,_);n.normalize(c,c),n.multiplyByScalar(u,s,u),n.multiplyByScalar(c,s,c),n.multiplyByScalar(l,s,l);var h=n.negate(c,U),m=n.negate(l,B),y=q,p=y[0];n.add(u,c,p),n.add(p,l,p),p=y[1],n.add(u,c,p),n.add(p,m,p),p=y[2],n.add(u,h,p),n.add(p,m,p),p=y[3],n.add(u,h,p),n.add(p,l,p),n.negate(u,u),p=y[4],n.add(u,c,p),n.add(p,l,p),p=y[5],n.add(u,c,p),n.add(p,m,p),p=y[6],n.add(u,h,p),n.add(p,m,p),p=y[7],n.add(u,h,p),n.add(p,l,p);for(var d=y.length,v=0;d>v;++v){var g=y[v];n.add(i,g,g);var E=a.cartesianToCartographic(g,G);r.project(E,g)}o=f.fromPoints(y,o),i=o.center;var w=i.x,C=i.y,S=i.z;return i.x=S,i.y=w,i.z=C,o},f.equals=function(t,r){return t===r||e(t)&&e(r)&&n.equals(t.center,r.center)&&t.radius===r.radius},f.prototype.clone=function(t){return f.clone(this,t)},f.prototype.union=function(t,e){return f.union(this,t,e)},f.prototype.expand=function(t,e){return f.expand(this,t,e)},f.prototype.intersect=function(t){return f.intersect(this,t)},f.prototype.getPlaneDistances=function(t,e,r){return f.getPlaneDistances(this,t,e,r)},f.prototype.projectTo2D=function(t,e){return f.projectTo2D(this,t,e)},f.prototype.equals=function(t){return f.equals(this,t)},f}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,r,n){"use strict";var o=function(e,r){this.x=t(e,0),this.y=t(r,0)};o.fromElements=function(t,r,n){return e(n)?(n.x=t,n.y=r,n):new o(t,r)},o.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r):new o(t.x,t.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n]=e.y},o.unpack=function(r,n,a){return n=t(n,0),e(a)||(a=new o),a.x=r[n++],a.y=r[n],a},o.fromArray=o.unpack,o.getMaximumComponent=function(t){return Math.max(t.x,t.y)},o.getMinimumComponent=function(t){return Math.min(t.x,t.y)},o.getMinimumByComponent=function(t,r,n){return e(n)||(n=new o),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.getMaximumByComponent=function(t,r,n){return e(n)||(n=new o),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y},o.magnitude=function(t){return Math.sqrt(o.magnitudeSquared(t))};var a=new o;o.distance=function(t,e){return o.subtract(t,e,a),o.magnitude(a)},o.normalize=function(t,r){var n=o.magnitude(t);return e(r)?(r.x=t.x/n,r.y=t.y/n,r):new o(t.x/n,t.y/n)},o.dot=function(t,e){return t.x*e.x+t.y*e.y},o.multiplyComponents=function(t,r,n){return e(n)?(n.x=t.x*r.x,n.y=t.y*r.y,n):new o(t.x*r.x,t.y*r.y)},o.add=function(t,r,n){return e(n)?(n.x=t.x+r.x,n.y=t.y+r.y,n):new o(t.x+r.x,t.y+r.y)},o.subtract=function(t,r,n){return e(n)?(n.x=t.x-r.x,n.y=t.y-r.y,n):new o(t.x-r.x,t.y-r.y)},o.multiplyByScalar=function(t,r,n){return e(n)?(n.x=t.x*r,n.y=t.y*r,n):new o(t.x*r,t.y*r)},o.divideByScalar=function(t,r,n){return e(n)?(n.x=t.x/r,n.y=t.y/r,n):new o(t.x/r,t.y/r)},o.negate=function(t,r){return e(r)?(r.x=-t.x,r.y=-t.y,r):new o(-t.x,-t.y)},o.abs=function(t,r){return e(r)?(r.x=Math.abs(t.x),r.y=Math.abs(t.y),r):new o(Math.abs(t.x),Math.abs(t.y))};var i=new o;o.lerp=function(t,e,r,n){return o.multiplyByScalar(e,r,i),n=o.multiplyByScalar(t,1-r,n),o.add(i,n,n)};var s=new o,u=new o;o.angleBetween=function(t,e){return o.normalize(t,s),o.normalize(e,u),Math.acos(o.dot(s,u))};var l=new o;return o.mostOrthogonalAxis=function(t,e){var r=o.normalize(t,l);return o.abs(r,r),e=r.x<=r.y?o.clone(o.UNIT_X,e):o.clone(o.UNIT_Y,e)},o.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y},o.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t.x-r.x)<=n&&Math.abs(t.y-r.y)<=n},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(t){return o.clone(this,t)},o.prototype.equals=function(t){return o.equals(this,t)},o.prototype.equalsEpsilon=function(t,e){return o.equalsEpsilon(this,t,e)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Fullscreen",["./defined"],function(t){"use strict";var e,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return n.supportsFullscreen=function(){if(t(e))return e;e=!1;var n=document.body;if("function"==typeof n.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",e=!0;for(var o,a=["webkit","moz","o","ms","khtml"],i=0,s=a.length;s>i;++i){var u=a[i];o=u+"RequestFullscreen","function"==typeof n[o]?(r.requestFullscreen=o,e=!0):(o=u+"RequestFullScreen","function"==typeof n[o]&&(r.requestFullscreen=o,e=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?r.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(r.exitFullscreen=o)),o=u+"FullscreenEnabled",t(document[o])?r.fullscreenEnabled=o:(o=u+"FullScreenEnabled",t(document[o])&&(r.fullscreenEnabled=o)),o=u+"FullscreenElement",t(document[o])?r.fullscreenElement=o:(o=u+"FullScreenElement",t(document[o])&&(r.fullscreenElement=o)),o=u+"fullscreenchange",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenChange"),r.fullscreenchange=o),o=u+"fullscreenerror",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenError"),r.fullscreenerror=o)}return e},n.requestFullscreen=function(t){n.supportsFullscreen()&&t[r.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[r.exitFullscreen]()},n.isFullscreenEnabled=function(){return n.supportsFullscreen()?document[r.fullscreenEnabled]:void 0},n.getFullscreenElement=function(){return n.supportsFullscreen()?document[r.fullscreenElement]:void 0},n.isFullscreen=function(){return n.supportsFullscreen()?null!==n.getFullscreenElement():void 0},n.getFullscreenChangeEventName=function(){return n.supportsFullscreen()?r.fullscreenchange:void 0},n.getFullscreenErrorEventName=function(){return n.supportsFullscreen()?r.fullscreenerror:void 0},n}),define("Core/FeatureDetection",["./defined","./Fullscreen"],function(t,e){"use strict";function r(t){for(var e=t.split("."),r=0,n=e.length;n>r;++r)e[r]=parseInt(e[r],10);return e}function n(){if(!t(f)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?f=!1:(f=!0,h=r(e[1]))}return f}function o(){return n()&&h}function a(){if(!t(m))if(n()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))m=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?m=!1:(m=!0,y=r(e[1]))}return m}function i(){return a()&&y}function s(){if(!t(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,d=r(e[1]),d.isNightly=!!e[2])}return p}function u(){return s()&&d}function l(){if(!t(v)){var e=/ MSIE ([\.0-9]+)/.exec(navigator.userAgent);null===e?v=!1:(v=!0,g=r(e[1]))}return v}function c(){return l()&&g}var f,h,m,y,p,d,v,g,E,w={isChrome:n,chromeVersion:o,isSafari:a,safariVersion:i,isWebkit:s,webkitVersion:u,isInternetExplorer:l,internetExplorerVersion:c};return w.supportsCrossOriginImagery=function(){return t(E)||(E=a()&&u()[0]<536?!1:"withCredentials"in new XMLHttpRequest),E},w.supportsFullscreen=function(){return e.supportsFullscreen()},w.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},w}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./Enumeration"],function(t,e,r,n,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:new o(5120,"BYTE",{sizeInBytes:Int8Array.BYTES_PER_ELEMENT}),UNSIGNED_BYTE:new o(5121,"UNSIGNED_BYTE",{sizeInBytes:Uint8Array.BYTES_PER_ELEMENT}),SHORT:new o(5122,"SHORT",{sizeInBytes:Int16Array.BYTES_PER_ELEMENT}),UNSIGNED_SHORT:new o(5123,"UNSIGNED_SHORT",{sizeInBytes:Uint16Array.BYTES_PER_ELEMENT}),FLOAT:new o(5126,"FLOAT",{sizeInBytes:Float32Array.BYTES_PER_ELEMENT}),DOUBLE:new o(5130,"DOUBLE",{sizeInBytes:Float64Array.BYTES_PER_ELEMENT})};return a.validate=function(t){return e(t)&&e(t.value)&&(t.value===a.BYTE.value||t.value===a.UNSIGNED_BYTE.value||t.value===a.SHORT.value||t.value===a.UNSIGNED_SHORT.value||t.value===a.FLOAT.value||t.value===a.DOUBLE.value)},a.createTypedArray=function(t,e){switch(t.value){case a.BYTE.value:return new Int8Array(e);case a.UNSIGNED_BYTE.value:return new Uint8Array(e);case a.SHORT.value:return new Int16Array(e);case a.UNSIGNED_SHORT.value:return new Uint16Array(e);case a.FLOAT.value:return new Float32Array(e);case a.DOUBLE.value:return new Float64Array(e);default:throw new r("componentDatatype is not a valid enumeration value.")}},a.createArrayBufferView=function(e,n,o,i){switch(o=t(o,0),i=t(i,(n.byteLength-o)/e.sizeInBytes),e.value){case a.BYTE.value:return new Int8Array(n,o,i);case a.UNSIGNED_BYTE.value:return new Uint8Array(n,o,i);case a.SHORT.value:return new Int16Array(n,o,i);case a.UNSIGNED_SHORT.value:return new Uint16Array(n,o,i);case a.FLOAT.value:return new Float32Array(n,o,i);case a.DOUBLE.value:return new Float64Array(n,o,i);default:throw new r("componentDatatype is not a valid enumeration value.")}},a}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(t,e,r){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(t){switch(t){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},n.validate=function(e){return t(e)&&(e===n.UNSIGNED_BYTE||e===n.UNSIGNED_SHORT||e===n.UNSIGNED_INT)},n.createTypedArray=function(t,e){return t>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(e):new Uint16Array(e)},n}),define("Core/Extent",["./freezeObject","./defaultValue","./defined","./Ellipsoid","./Cartographic","./DeveloperError","./Math"],function(t,e,r,n,o,a,i){"use strict";var s=function(t,r,n,o){this.west=e(t,0),this.south=e(r,0),this.east=e(n,0),this.north=e(o,0)};s.fromDegrees=function(t,n,o,a,u){return t=i.toRadians(e(t,0)),n=i.toRadians(e(n,0)),o=i.toRadians(e(o,0)),a=i.toRadians(e(a,0)),r(u)?(u.west=t,u.south=n,u.east=o,u.north=a,u):new s(t,n,o,a)},s.fromCartographicArray=function(t,e){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,i=-Number.MAX_VALUE,u=0,l=t.length;l>u;u++){var c=t[u];n=Math.min(n,c.longitude),o=Math.max(o,c.longitude),a=Math.min(a,c.latitude),i=Math.max(i,c.latitude)}return r(e)?(e.west=n,e.south=a,e.east=o,e.north=i,e):new s(n,a,o,i)},s.clone=function(t,e){return r(t)?r(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new s(t.west,t.south,t.east,t.north):void 0},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},s.prototype.equalsEpsilon=function(t,e){return r(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},s.prototype.validate=function(){},s.prototype.getSouthwest=function(t){return r(t)?(t.longitude=this.west,t.latitude=this.south,t.height=0,t):new o(this.west,this.south)},s.prototype.getNorthwest=function(t){return r(t)?(t.longitude=this.west,t.latitude=this.north,t.height=0,t):new o(this.west,this.north)},s.prototype.getNortheast=function(t){return r(t)?(t.longitude=this.east,t.latitude=this.north,t.height=0,t):new o(this.east,this.north)},s.prototype.getSoutheast=function(t){return r(t)?(t.longitude=this.east,t.latitude=this.south,t.height=0,t):new o(this.east,this.south)},s.prototype.getCenter=function(t){return r(t)?(t.longitude=.5*(this.west+this.east),t.latitude=.5*(this.south+this.north),t.height=0,t):new o(.5*(this.west+this.east),.5*(this.south+this.north))},s.prototype.intersectWith=function(t,e){var n=Math.max(this.west,t.west),o=Math.max(this.south,t.south),a=Math.min(this.east,t.east),i=Math.min(this.north,t.north);return r(e)?(e.west=n,e.south=o,e.east=a,e.north=i,e):new s(n,o,a,i)},s.prototype.contains=function(t){return t.longitude>=this.west&&t.longitude<=this.east&&t.latitude>=this.south&&t.latitude<=this.north},s.prototype.isEmpty=function(){return this.west>=this.east||this.south>=this.north};var u=new o;return s.prototype.subsample=function(t,o,a){t=e(t,n.WGS84),o=e(o,0),r(a)||(a=[]);var s=0,l=this.north,c=this.south,f=this.east,h=this.west,m=u;m.height=o,m.longitude=h,m.latitude=l,a[s]=t.cartographicToCartesian(m,a[s]),s++,m.longitude=f,a[s]=t.cartographicToCartesian(m,a[s]),s++,m.latitude=c,a[s]=t.cartographicToCartesian(m,a[s]),s++,m.longitude=h,a[s]=t.cartographicToCartesian(m,a[s]),s++,m.latitude=0>l?l:c>0?c:0;for(var y=1;8>y;++y){var p=-Math.PI+y*i.PI_OVER_TWO;p>h&&f>p&&(m.longitude=p,a[s]=t.cartographicToCartesian(m,a[s]),s++)}return 0===m.latitude&&(m.longitude=h,a[s]=t.cartographicToCartesian(m,a[s]),s++,m.longitude=f,a[s]=t.cartographicToCartesian(m,a[s]),s++),a.length=s,a},s.MAX_VALUE=t(new s(-Math.PI,-i.PI_OVER_TWO,Math.PI,i.PI_OVER_TWO)),s}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./BoundingSphere"],function(t,e,r){"use strict";var n=function(e){e=t(e,t.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=e.primitiveType,this.boundingSphere=e.boundingSphere};return n.computeNumberOfVertices=function(t){var n=-1;for(var o in t.attributes)if(t.attributes.hasOwnProperty(o)&&e(t.attributes[o])&&e(t.attributes[o].values)){var a=t.attributes[o],i=a.values.length/a.componentsPerAttribute;if(n!==i&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=i}return n},n}),define("Core/GeometryInstanceAttribute",["./defaultValue","./defined","./DeveloperError"],function(t){"use strict";var e=function(e){e=t(e,t.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=t(e.normalize,!1),this.value=e.value};return e}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4","./Geometry","./GeometryInstanceAttribute"],function(t,e,r,n){"use strict";var o=function(e){e=t(e,t.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=n.clone(t(e.modelMatrix,n.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=t(e.attributes,{})};return o}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(t,e,r){"use strict";var n=new e,o=new e,a=new e,i=function(i,s,u,l,c){r(c)||(c=new e);var f,h,m,y,p,d,v,g;r(s.z)?(f=e.subtract(u,s,n),h=e.subtract(l,s,o),m=e.subtract(i,s,a),y=e.dot(f,f),p=e.dot(f,h),d=e.dot(f,m),v=e.dot(h,h),g=e.dot(h,m)):(f=t.subtract(u,s,n),h=t.subtract(l,s,o),m=t.subtract(i,s,a),y=t.dot(f,f),p=t.dot(f,h),d=t.dot(f,m),v=t.dot(h,h),g=t.dot(h,m));var E=1/(y*v-p*p);return c.y=(v*d-p*g)*E,c.z=(y*g-p*d)*E,c.x=1-c.y-c.z,c};return i}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(t,e){"use strict";var r=function(){this.high=t.clone(t.ZERO),this.low=t.clone(t.ZERO)};r.encode=function(t,r){e(r)||(r={high:0,low:0});var n;return t>=0?(n=65536*Math.floor(t/65536),r.high=n,r.low=t-n):(n=65536*Math.floor(-t/65536),r.high=-n,r.low=t+n),r};var n={high:0,low:0};r.fromCartesian=function(t,o){e(o)||(o=new r);var a=o.high,i=o.low;return r.encode(t.x,n),a.x=n.high,i.x=n.low,r.encode(t.y,n),a.y=n.high,i.y=n.low,r.encode(t.z,n),a.z=n.high,i.z=n.low,o};var o=new r;return r.writeElements=function(t,e,n){r.fromCartesian(t,o);var a=o.high,i=o.low;e[n]=a.x,e[n+1]=a.y,e[n+2]=a.z,e[n+3]=i.x,e[n+4]=i.y,e[n+5]=i.z},r}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(t,e){"use strict";function r(t,r,n){var o=t+r;return e.sign(t)!==e.sign(r)&&Math.abs(o/Math.max(Math.abs(t),Math.abs(r)))<n?0:o}var n={};return n.discriminant=function(t,e,r){var n=e*e-4*t*r;return n},n.realRoots=function(t,n,o){var a;if(0===t)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var i=Math.abs(o),s=Math.abs(t);if(s>i&&i/s<e.EPSILON14)return[0,0];if(i>s&&s/i<e.EPSILON14)return[];if(a=-o/t,0>a)return[];var u=Math.sqrt(a);return[-u,u]}if(0===o)return a=-n/t,0>a?[a,0]:[0,a];var l=n*n,c=4*t*o,f=r(l,-c,e.EPSILON14);if(0>f)return[];var h=-.5*r(n,e.sign(n)*Math.sqrt(f),e.EPSILON14);return n>0?[h/t,o/h]:[o/h,h/t]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(t,e){"use strict";function r(t,e,r,n){var o,a,i=t,s=e/3,u=r/3,l=n,c=i*u,f=s*l,h=s*s,m=u*u,y=i*u-h,p=i*l-s*u,d=s*l-m,v=4*y*d-p*p;if(0>v){var g,E,w;h*f>=c*m?(g=i,E=y,w=-2*s*y+i*p):(g=l,E=d,w=-l*p+2*u*d);var C=0>w?-1:1,S=-C*Math.abs(g)*Math.sqrt(-v);a=-w+S;var x=a/2,M=0>x?-Math.pow(-x,1/3):Math.pow(x,1/3),A=a===S?-M:-E/M;return o=0>=E?M+A:-w/(M*M+A*A+E),h*f>=c*m?[(o-s)/i]:[-l/(o+u)]}var b=y,T=-2*s*y+i*p,O=d,I=-l*p+2*u*d,N=Math.sqrt(v),R=Math.sqrt(3)/2,z=Math.abs(Math.atan2(i*N,-T)/3);o=2*Math.sqrt(-b);var L=Math.cos(z);a=o*L;var F=o*(-L/2-R*Math.sin(z)),D=a+F>2*s?a-s:F-s,P=i,_=D/P;z=Math.abs(Math.atan2(l*N,-I)/3),o=2*Math.sqrt(-O),L=Math.cos(z),a=o*L,F=o*(-L/2-R*Math.sin(z));var B=-l,U=2*u>a+F?a+u:F+u,G=B/U,q=P*U,W=-D*U-P*B,Y=D*B,V=(u*W-s*Y)/(-s*W+u*q);return V>=_?G>=_?G>=V?[_,V,G]:[_,G,V]:[G,_,V]:G>=_?[V,_,G]:G>=V?[V,G,_]:[G,V,_]}var n={};return n.discriminant=function(t,e,r,n){var o=t*t,a=e*e,i=r*r,s=n*n,u=18*t*e*r*n+a*i-27*o*s-4*(t*i*r+a*e*n);return u},n.realRoots=function(t,n,o,a){var i,s;if(0===t)return e.realRoots(n,o,a);if(0===n){if(0===o){if(0===a)return[0,0,0];s=-a/t;var u=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[u,u,u]}return 0===a?(i=e.realRoots(t,0,o),0===i.Length?[0]:[i[0],0,i[1]]):r(t,0,o,a)}return 0===o?0===a?(s=-n/t,0>s?[s,0,0]:[0,0,s]):r(t,n,0,a):0===a?(i=e.realRoots(t,n,o),0===i.length?[0]:i[1]<=0?[i[0],i[1],0]:i[0]>=0?[0,i[0],i[1]]:[i[0],0,i[1]]):r(t,n,o,a)},n}),define("Core/QuarticRealPolynomial",["./DeveloperError","./Math","./CubicRealPolynomial","./QuadraticRealPolynomial"],function(t,e,r,n){"use strict";function o(t,o,a,i){var s=t*t,u=o-3*s/8,l=a-o*t/2+s*t/8,c=i-a*t/4+o*s/16-3*s*s/256,f=r.realRoots(1,2*u,u*u-4*c,-l*l);if(f.length>0){var h=-t/4,m=f[f.length-1];if(Math.abs(m)<e.EPSILON14){var y=n.realRoots(1,u,c);if(2===y.length){var p,d=y[0],v=y[1];if(d>=0&&v>=0){var g=Math.sqrt(d),E=Math.sqrt(v);return[h-E,h-g,h+g,h+E]}if(d>=0&&0>v)return p=Math.sqrt(d),[h-p,h+p];if(0>d&&v>=0)return p=Math.sqrt(v),[h-p,h+p]}return[]}if(m>0){var w=Math.sqrt(m),C=(u+m-l/w)/2,S=(u+m+l/w)/2,x=n.realRoots(1,w,C),M=n.realRoots(1,-w,S);return 0!==x.length?(x[0]+=h,x[1]+=h,0!==M.length?(M[0]+=h,M[1]+=h,x[1]<=M[0]?[x[0],x[1],M[0],M[1]]:M[1]<=x[0]?[M[0],M[1],x[0],x[1]]:x[0]>=M[0]&&x[1]<=M[1]?[M[0],x[0],x[1],M[1]]:M[0]>=x[0]&&M[1]<=x[1]?[x[0],M[0],M[1],x[1]]:x[0]>M[0]&&x[0]<M[1]?[M[0],x[0],M[1],x[1]]:[x[0],M[0],x[1],M[1]]):x):0!==M.length?(M[0]+=h,M[1]+=h,M):[]}}return[]}function a(t,o,a,i){var s=a*a,u=o*o,l=t*t,c=-2*o,f=a*t+u-4*i,h=l*i-a*o*t+s,m=r.realRoots(1,c,f,h);if(m.length>0){var y,p,d=m[0],v=o-d,g=v*v,E=t/2,w=v/2,C=g-4*i,S=g+4*Math.abs(i),x=l-4*d,M=l+4*Math.abs(d);if(0>d||x*S>C*M){var A=Math.sqrt(x);y=A/2,p=0===A?0:(t*w-a)/A}else{var b=Math.sqrt(C);y=0===b?0:(t*w-a)/b,p=b/2}var T,O;0===E&&0===y?(T=0,O=0):e.sign(E)===e.sign(y)?(T=E+y,O=d/T):(O=E-y,T=d/O);var I,N;0===w&&0===p?(I=0,N=0):e.sign(w)===e.sign(p)?(I=w+p,N=i/I):(N=w-p,I=i/N);var R=n.realRoots(1,T,I),z=n.realRoots(1,O,N);if(0!==R.length)return 0!==z.length?R[1]<=z[0]?[R[0],R[1],z[0],z[1]]:z[1]<=R[0]?[z[0],z[1],R[0],R[1]]:R[0]>=z[0]&&R[1]<=z[1]?[z[0],R[0],R[1],z[1]]:z[0]>=R[0]&&z[1]<=R[1]?[R[0],z[0],z[1],R[1]]:R[0]>z[0]&&R[0]<z[1]?[z[0],R[0],z[1],R[1]]:[R[0],z[0],R[1],z[1]]:R;if(0!==z.length)return z}return[]}var i={};return i.discriminant=function(t,e,r,n,o){var a=t*t,i=a*t,s=e*e,u=s*e,l=r*r,c=l*r,f=n*n,h=f*n,m=o*o,y=m*o,p=s*l*f-4*u*h-4*t*c*f+18*t*e*r*h-27*a*f*f+256*i*y+o*(18*u*r*n-4*s*c+16*t*l*l-80*t*e*l*n-6*t*s*f+144*a*r*f)+m*(144*t*s*r-27*s*s-128*a*l-192*a*e*n);return p},i.realRoots=function(t,n,i,s,u){if(Math.abs(t)<e.EPSILON15)return r.realRoots(n,i,s,u);var l=n/t,c=i/t,f=s/t,h=u/t,m=0>l?1:0;switch(m+=0>c?m+1:m,m+=0>f?m+1:m,m+=0>h?m+1:m){case 0:return o(l,c,f,h);case 1:return a(l,c,f,h);case 2:return a(l,c,f,h);case 3:return o(l,c,f,h);case 4:return o(l,c,f,h);case 5:return a(l,c,f,h);case 6:return o(l,c,f,h);case 7:return o(l,c,f,h);case 8:return a(l,c,f,h);case 9:return o(l,c,f,h);case 10:return o(l,c,f,h);case 11:return a(l,c,f,h);case 12:return o(l,c,f,h);case 13:return o(l,c,f,h);case 14:return o(l,c,f,h);case 15:return o(l,c,f,h);default:return void 0}},i}),define("Core/IntersectionTests",["./defined","./DeveloperError","./Math","./Cartesian3","./Cartographic","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(t,e,r,n,o,a,i,s){"use strict";function u(t,e,n){var o=t+e;return r.sign(t)!==r.sign(e)&&Math.abs(o/Math.max(Math.abs(t),Math.abs(e)))<n?0:o
}function l(t,e,o,l,c){var f,h=l*l,m=c*c,y=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*m,p=c*(l*u(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],r.EPSILON15)+e.y),d=t[a.COLUMN0ROW0]*h+t[a.COLUMN2ROW2]*m+l*e.x+o,v=m*u(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],r.EPSILON15),g=c*(l*u(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+e.z),E=[];if(0===g&&0===v){if(f=i.realRoots(y,p,d),0===f.length)return E;var w=f[0],C=Math.sqrt(Math.max(1-w*w,0));if(E.push(new n(l,c*w,c*-C)),E.push(new n(l,c*w,c*C)),2===f.length){var S=f[1],x=Math.sqrt(Math.max(1-S*S,0));E.push(new n(l,c*S,c*-x)),E.push(new n(l,c*S,c*x))}return E}var M=g*g,A=v*v,b=y*y,T=g*v,O=b+A,I=2*(p*y+T),N=2*d*y+p*p-A+M,R=2*(d*p-T),z=d*d-M;if(0===O&&0===I&&0===N&&0===R)return E;f=s.realRoots(O,I,N,R,z);var L=f.length;if(0===L)return E;for(var F=0;L>F;++F){var D,P=f[F],_=P*P,B=Math.max(1-_,0),U=Math.sqrt(B);D=r.sign(y)===r.sign(d)?u(y*_+d,p*P,r.EPSILON12):r.sign(d)===r.sign(p*P)?u(y*_,p*P+d,r.EPSILON12):u(y*_+p*P,d,r.EPSILON12);var G=u(v*P,g,r.EPSILON15),q=D*G;0>q?E.push(new n(l,c*P,c*U)):q>0?E.push(new n(l,c*P,c*-U)):0!==U?(E.push(new n(l,c*P,c*-U)),E.push(new n(l,c*P,c*U)),++F):E.push(new n(l,c*P,c*U))}return E}var c={};c.rayPlane=function(t,e,o){var a=t.origin,i=t.direction,s=e.normal,u=n.dot(s,i);if(Math.abs(u)<r.EPSILON15)return void 0;var l=(-e.distance-n.dot(s,a))/u;return 0>l?void 0:(o=n.multiplyByScalar(i,l,o),n.add(a,o,o))};var f=new n,h=new n;c.rayEllipsoid=function(t,e){var r,o,a,i,s,u=e.getOneOverRadii(),l=n.multiplyComponents(u,t.origin,f),c=n.multiplyComponents(u,t.direction,h),m=n.magnitudeSquared(l),y=n.dot(l,c);if(m>1){if(y>=0)return void 0;var p=y*y;if(r=m-1,o=n.magnitudeSquared(c),a=o*r,a>p)return void 0;if(p>a){i=y*y-a,s=-y+Math.sqrt(i);var d=s/o,v=r/s;return v>d?{start:d,stop:v}:{start:v,stop:d}}var g=Math.sqrt(r/o);return{start:g,stop:g}}return 1>m?(r=m-1,o=n.magnitudeSquared(c),a=o*r,i=y*y-a,s=-y+Math.sqrt(i),{start:0,stop:s/o}):0>y?(o=n.magnitudeSquared(c),{start:0,stop:-y/o}):void 0},c.grazingAltitudeLocation=function(e,i){var s=e.origin,u=e.direction,c=i.geodeticSurfaceNormal(s);if(n.dot(u,c)>=0)return s;var f,h,m=t(this.rayEllipsoid(e,i)),y=i.transformPositionToScaledSpace(u),p=n.normalize(y),d=n.mostOrthogonalAxis(y),v=n.normalize(n.cross(d,p)),g=n.normalize(n.cross(p,v)),E=new a(p.x,v.x,g.x,p.y,v.y,g.y,p.z,v.z,g.z),w=a.transpose(E),C=a.fromScale(i.getRadii()),S=a.fromScale(i.getOneOverRadii()),x=new a(0,u.z,-u.y,-u.z,0,u.x,u.y,-u.x,0),M=a.multiply(a.multiply(w,S),x),A=a.multiply(a.multiply(M,C),E),b=a.multiplyByVector(M,s),T=l(A,n.negate(b),0,0,1),O=T.length;if(O>0){for(var I=n.ZERO,N=Number.NEGATIVE_INFINITY,R=0;O>R;++R){f=a.multiplyByVector(C,a.multiplyByVector(E,T[R]));var z=n.normalize(n.subtract(f,s)),L=n.dot(z,u);L>N&&(N=L,I=f)}var F=i.cartesianToCartographic(I);return N=r.clamp(N,0,1),h=n.magnitude(n.subtract(I,s))*Math.sqrt(1-N*N),h=m?-h:h,i.cartographicToCartesian(new o(F.longitude,F.latitude,h))}return void 0};var m=new n;return c.lineSegmentPlane=function(e,o,a,i){var s=n.subtract(o,e,m),u=a.normal,l=n.dot(u,s);if(Math.abs(l)<r.EPSILON6)return void 0;var c=n.dot(u,e),f=-(a.distance+c)/l;return 0>f||f>1?void 0:(t(i)||(i=new n),n.multiplyByScalar(s,f,i),n.add(e,i,i),i)},c.trianglePlaneIntersection=function(t,e,r,o){var a=o.normal,i=o.distance,s=n.dot(a,t)+i<0,u=n.dot(a,e)+i<0,l=n.dot(a,r)+i<0,f=0;f+=s?1:0,f+=u?1:0,f+=l?1:0;var h,m;if((1===f||2===f)&&(h=new n,m=new n),1===f){if(s)return c.lineSegmentPlane(t,e,o,h),c.lineSegmentPlane(t,r,o,m),{positions:[t,e,r,h,m],indices:[0,3,4,1,2,4,1,4,3]};if(u)return c.lineSegmentPlane(e,r,o,h),c.lineSegmentPlane(e,t,o,m),{positions:[t,e,r,h,m],indices:[1,3,4,2,0,4,2,4,3]};if(l)return c.lineSegmentPlane(r,t,o,h),c.lineSegmentPlane(r,e,o,m),{positions:[t,e,r,h,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===f){if(!s)return c.lineSegmentPlane(e,t,o,h),c.lineSegmentPlane(r,t,o,m),{positions:[t,e,r,h,m],indices:[1,2,4,1,4,3,0,3,4]};if(!u)return c.lineSegmentPlane(r,e,o,h),c.lineSegmentPlane(t,e,o,m),{positions:[t,e,r,h,m],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return c.lineSegmentPlane(t,r,o,h),c.lineSegmentPlane(e,r,o,m),{positions:[t,e,r,h,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(t,e){"use strict";var r=function(e,r){this.normal=t.clone(e),this.distance=r};return r.fromPointNormal=function(n,o,a){var i=-t.dot(o,n);return e(a)?(t.clone(o,a.normal),a.distance=i,a):new r(o,i)},r.getPointDistance=function(e,r){return t.dot(e.normal,r)+e.distance},r.prototype.getPointDistance=function(t){return r.getPointDistance(this,t)},r}),define("Core/PrimitiveType",[],function(){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return t}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(t,e){"use strict";var r={};return r.calculateACMR=function(r){r=t(r,t.EMPTY_OBJECT);var n=r.indices,o=r.maximumIndex,a=t(r.cacheSize,24),i=n.length;if(!e(o)){o=0;for(var s=0,u=n[s];i>s;)u>o&&(o=u),++s,u=n[s]}for(var l=[],c=0;o+1>c;c++)l[c]=0;for(var f=a+1,h=0;i>h;++h)f-l[n[h]]>a&&(l[n[h]]=f,++f);return(f-a+1)/(i/3)},r.tipsify=function(r){function n(t,e,r,n){for(;e.length>=1;){var o=e[e.length-1];if(e.splice(e.length-1,1),t[o].numLiveTriangles>0)return o}for(;n>a;){if(t[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(t,e,r,o,a,i,s){for(var u,l=-1,c=-1,f=0;f<r.length;){var h=r[f];o[h].numLiveTriangles&&(u=0,a-o[h].timeStamp+2*o[h].numLiveTriangles<=e&&(u=a-o[h].timeStamp),(u>c||-1===c)&&(c=u,l=h)),++f}return-1===l?n(o,i,t,s):l}r=t(r,t.EMPTY_OBJECT);var a,i=r.indices,s=r.maximumIndex,u=t(r.cacheSize,24),l=i.length,c=0,f=0,h=i[f],m=l;if(e(s))c=s+1;else{for(;m>f;)h>c&&(c=h),++f,h=i[f];if(-1===c)return 0;++c}for(var y=[],p=0;c>p;p++)y[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var d=0;m>f;)y[i[f]].vertexTriangles.push(d),++y[i[f]].numLiveTriangles,y[i[f+1]].vertexTriangles.push(d),++y[i[f+1]].numLiveTriangles,y[i[f+2]].vertexTriangles.push(d),++y[i[f+2]].numLiveTriangles,++d,f+=3;var v=0,g=u+1;a=1;var E,w,C=[],S=[],x=0,M=[],A=l/3,b=[];for(p=0;A>p;p++)b[p]=!1;for(var T,O;-1!==v;){C=[],w=y[v],O=w.vertexTriangles.length;for(var I=0;O>I;++I)if(d=w.vertexTriangles[I],!b[d]){b[d]=!0,f=d+d+d;for(var N=0;3>N;++N)T=i[f],C.push(T),S.push(T),M[x]=T,++x,E=y[T],--E.numLiveTriangles,g-E.timeStamp>u&&(E.timeStamp=g,++g),++f}v=o(i,u,C,y,g,S,c)}return M},r}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t){"use strict";var e=function(e){e=t(e,t.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=t(e.normalize,!1),this.values=e.values};return e}),define("Core/GeometryPipeline",["./barycentricCoordinates","./defaultValue","./defined","./DeveloperError","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./EncodedCartesian3","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./GeographicProjection","./ComponentDatatype","./IndexDatatype","./PrimitiveType","./Tipsify","./BoundingSphere","./Geometry","./GeometryAttribute"],function(t,e,r,n,o,a,i,s,u,l,c,f,h,m,y,p,d,v,g,E,w,C,S){"use strict";function x(t,e,r,n,o){t[e++]=r,t[e++]=n,t[e++]=n,t[e++]=o,t[e++]=o,t[e]=r}function M(t){for(var e=t.length,r=6*(e/3),n=v.createTypedArray(e,r),o=0,a=0;e>a;a+=3,o+=6)x(n,o,t[a],t[a+1],t[a+2]);return n}function A(t){var e=t.length;if(e>=3){var r=6*(e-2),n=v.createTypedArray(e,r);x(n,0,t[0],t[1],t[2]);for(var o=6,a=3;e>a;++a,o+=6)x(n,o,t[a-1],t[a],t[a-2]);return n}return new Uint16Array}function b(t){if(t.length>0){for(var e=t.length-1,r=6*(e-1),n=v.createTypedArray(e,r),o=t[0],a=0,i=1;e>i;++i,a+=6)x(n,a,o,t[i],t[i+1]);return n}return new Uint16Array}function T(t){var e={};for(var n in t)if(t.hasOwnProperty(n)&&r(t[n])&&r(t[n].values)){var o=t[n];e[n]=new S({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:[]})}return e}function O(t,e,n){for(var o in e)if(e.hasOwnProperty(o)&&r(e[o])&&r(e[o].values))for(var a=e[o],i=0;i<a.componentsPerAttribute;++i)t[o].values.push(a.values[n*a.componentsPerAttribute+i])}function I(t,e){if(r(e))for(var n=e.values,o=n.length,i=0;o>i;i+=3)a.unpack(n,i,Z),m.multiplyByPoint(t,Z,Z),a.pack(Z,n,i)}function N(t,e){if(r(e))for(var n=e.values,o=n.length,i=0;o>i;i+=3)a.unpack(n,i,Z),h.multiplyByVector(t,Z,Z),Z=a.normalize(Z,Z),a.pack(Z,n,i)}function R(t){var e,n=t.length,o={},a=t[0].geometry.attributes;for(e in a)if(a.hasOwnProperty(e)&&r(a[e])&&r(a[e].values)){for(var i=a[e],s=i.values.length,u=!0,l=1;n>l;++l){var c=t[l].geometry.attributes[e];if(!r(c)||i.componentDatatype.value!==c.componentDatatype.value||i.componentsPerAttribute!==c.componentsPerAttribute||i.normalize!==c.normalize){u=!1;break}s+=c.values.length}u&&(o[e]=new S({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:d.createTypedArray(i.componentDatatype,s)}))}return o}function z(t){if(r(t.indices))return t;for(var e=C.computeNumberOfVertices(t),n=v.createTypedArray(e,e),o=0;e>o;++o)n[o]=o;return t.indices=n,t}function L(t){var e=C.computeNumberOfVertices(t),r=v.createTypedArray(e,3*(e-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,o=3;e>o;++o)r[n++]=o-1,r[n++]=0,r[n++]=o;return t.indices=r,t.primitiveType=g.TRIANGLES,t}function F(t){var e=C.computeNumberOfVertices(t),r=v.createTypedArray(e,3*(e-2));r[0]=0,r[1]=1,r[2]=2,e>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,o=3;e-1>o;o+=2)r[n++]=o,r[n++]=o-1,r[n++]=o+1,e>o+2&&(r[n++]=o,r[n++]=o+1,r[n++]=o+2);return t.indices=r,t.primitiveType=g.TRIANGLES,t}function D(t){if(r(t.indices))return t;for(var e=C.computeNumberOfVertices(t),n=v.createTypedArray(e,e),o=0;e>o;++o)n[o]=o;return t.indices=n,t}function P(t){var e=C.computeNumberOfVertices(t),r=v.createTypedArray(e,2*(e-1));r[0]=0,r[1]=1;for(var n=2,o=2;e>o;++o)r[n++]=o-1,r[n++]=o;return t.indices=r,t.primitiveType=g.LINES,t}function _(t){var e=C.computeNumberOfVertices(t),r=v.createTypedArray(e,2*e);r[0]=0,r[1]=1;for(var n=2,o=2;e>o;++o)r[n++]=o-1,r[n++]=o;return r[n++]=e-1,r[n]=0,t.indices=r,t.primitiveType=g.LINES,t}function B(t){switch(t.primitiveType){case g.TRIANGLE_FAN:return L(t);case g.TRIANGLE_STRIP:return F(t);case g.TRIANGLES:return z(t);case g.LINE_STRIP:return P(t);case g.LINE_LOOP:return _(t);case g.LINES:return D(t)}return t}function U(t,e){Math.abs(t.y)<f.EPSILON11&&(t.y=e?-f.EPSILON11:f.EPSILON11)}function G(t,e,r,n){a.add(t,a.multiplyByScalar(a.subtract(e,t,ae),t.y/(t.y-e.y),ae),r),a.clone(r,n),U(r,!0),U(n,!1)}function q(t,e,r){if(t.x>=0||e.x>=0||r.x>=0)return void 0;var n=t.y<0,o=e.y<0,a=r.y<0;U(t,n),U(e,o),U(r,a);var i=0;i+=n?1:0,i+=o?1:0,i+=a?1:0;var s=ce.indices;1===i?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(G(t,e,ie,ue),G(t,r,se,le),s[0]=0,s[3]=1,s[4]=2,s[6]=1):o?(G(e,r,ie,ue),G(e,t,se,le),s[0]=1,s[3]=2,s[4]=0,s[6]=2):a&&(G(r,t,ie,ue),G(r,e,se,le),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===i&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?o?a||(G(r,t,ie,ue),G(r,e,se,le),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(G(e,r,ie,ue),G(e,t,se,le),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(G(t,e,ie,ue),G(t,r,se,le),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=ce.positions;return u[0]=t,u[1]=e,u[2]=r,ce.length=3,(1===i||2===i)&&(u[3]=ie,u[4]=se,u[5]=ue,u[6]=le,ce.length=7),ce}function W(e,n,i,s,u,l,c,f){if(r(u)||r(l)||r(c)||r(f)){var h,m,y,p,d,v,g,E,w,C,S,x,M,A,b,T,O,I,N=s.positions,R=N[0],z=N[1],L=N[2];r(u)&&(h=a.fromArray(u,3*e),m=a.fromArray(u,3*n),y=a.fromArray(u,3*i)),r(l)&&(p=a.fromArray(l,3*e),d=a.fromArray(l,3*n),v=a.fromArray(l,3*i)),r(c)&&(g=a.fromArray(c,3*e),E=a.fromArray(c,3*n),w=a.fromArray(c,3*i)),r(f)&&(C=o.fromArray(f,2*e),S=o.fromArray(f,2*n),x=o.fromArray(f,2*i));for(var F=3;F<N.length;++F){var D=N[F],P=t(D,R,z,L);if(r(u)){M=a.multiplyByScalar(h,P.x,M),A=a.multiplyByScalar(m,P.y,A),b=a.multiplyByScalar(y,P.z,b);var _=a.add(M,A);a.add(_,b,_),a.normalize(_,_),u.push(_.x,_.y,_.z)}if(r(l)){M=a.multiplyByScalar(p,P.x,M),A=a.multiplyByScalar(d,P.y,A),b=a.multiplyByScalar(v,P.z,b);var B=a.add(M,A);a.add(B,b,B),a.normalize(B,B),l.push(B.x,B.y,B.z)}if(r(c)){M=a.multiplyByScalar(g,P.x,M),A=a.multiplyByScalar(E,P.y,A),b=a.multiplyByScalar(w,P.z,b);var U=a.add(M,A);a.add(U,b,U),a.normalize(U,U),c.push(U.x,U.y,U.z)}if(r(f)){T=o.multiplyByScalar(C,P.x,T),O=o.multiplyByScalar(S,P.y,O),I=o.multiplyByScalar(x,P.z,I);var G=o.add(T,O);o.add(G,I,G),f.push(G.x,G.y)}}}}function Y(t){for(var e=t.attributes,n=e.position.values,o=r(e.normal)?e.normal.values:void 0,i=r(e.binormal)?e.binormal.values:void 0,s=r(e.tangent)?e.tangent.values:void 0,u=r(e.st)?e.st.values:void 0,l=t.indices,c=Array.prototype.slice.call(n,0),f=r(o)?Array.prototype.slice.call(o,0):void 0,h=r(i)?Array.prototype.slice.call(i,0):void 0,m=r(s)?Array.prototype.slice.call(s,0):void 0,y=r(u)?Array.prototype.slice.call(u,0):void 0,p=[],g=l.length,E=0;g>E;E+=3){var w=l[E],S=l[E+1],x=l[E+2],M=a.fromArray(n,3*w),A=a.fromArray(n,3*S),b=a.fromArray(n,3*x),T=q(M,A,b);if(r(T))if(c[3*w+1]=T.positions[0].y,c[3*S+1]=T.positions[1].y,c[3*x+1]=T.positions[2].y,T.length>3){for(var O=c.length/3,I=0;I<T.indices.length;++I){var N=T.indices[I];3>N?p.push(l[E+N]):p.push(N-3+O)}for(var R=3;R<T.positions.length;++R){var z=T.positions[R];c.push(z.x,z.y,z.z)}W(w,S,x,T,f,h,m,y)}else p.push(w,S,x);else p.push(w,S,x)}t.attributes.position.values=new Float64Array(c),r(f)&&(e.normal.values=d.createTypedArray(e.normal.componentDatatype,f)),r(h)&&(e.binormal.values=d.createTypedArray(e.binormal.componentDatatype,h)),r(m)&&(e.tangent.values=d.createTypedArray(e.tangent.componentDatatype,m)),r(y)&&(e.st.values=d.createTypedArray(e.st.componentDatatype,y));var L=C.computeNumberOfVertices(t);t.indices=v.createTypedArray(L,p)}function V(t){for(var e=t.attributes,n=e.position.values,o=t.indices,i=Array.prototype.slice.call(n,0),s=[],u=y.fromPointNormal(a.ZERO,a.UNIT_Y),l=o.length,h=0;l>h;h+=2){var m=o[h],p=o[h+1],d=a.fromArray(n,3*m),g=a.fromArray(n,3*p);if(Math.abs(d.y)<f.EPSILON6&&(d.y=d.y<0?-f.EPSILON6:f.EPSILON6,i[3*m+1]=d.y),Math.abs(g.y)<f.EPSILON6&&(g.y=g.y<0?-f.EPSILON6:f.EPSILON6,i[3*p+1]=g.y),s.push(m),d.x<0||g.x<0){var E=c.lineSegmentPlane(d,g,u);if(r(E)){var w=a.multiplyByScalar(a.UNIT_Y,5*f.EPSILON9);d.y<0&&a.negate(w,w);var S=i.length/3;s.push(S,S+1);var x=a.add(E,w);i.push(x.x,x.y,x.z),a.negate(w,w),a.add(E,w,x),i.push(x.x,x.y,x.z)}}s.push(p)}t.attributes.position.values=new Float64Array(i);var M=C.computeNumberOfVertices(t);t.indices=v.createTypedArray(M,s)}var H={};H.toWireframe=function(t){var e=t.indices;if(r(e)){switch(t.primitiveType){case g.TRIANGLES:t.indices=M(e);break;case g.TRIANGLE_STRIP:t.indices=A(e);break;case g.TRIANGLE_FAN:t.indices=b(e);break;default:throw new n("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}t.primitiveType=g.LINES}return t},H.createLineSegmentsForVectors=function(t,n,o){n=e(n,"normal"),o=e(o,1e4);for(var a=t.attributes.position.values,i=t.attributes[n].values,s=a.length,u=new Float64Array(2*s),l=0,c=0;s>c;c+=3)u[l++]=a[c],u[l++]=a[c+1],u[l++]=a[c+2],u[l++]=a[c]+i[c]*o,u[l++]=a[c+1]+i[c+1]*o,u[l++]=a[c+2]+i[c+2]*o;var f,h=t.boundingSphere;return r(h)&&(f=new w(h.center,h.radius+o)),new C({attributes:{position:new S({componentDatatype:d.DOUBLE,componentsPerAttribute:3,values:u})},primitiveType:g.LINES,boundingSphere:f})},H.createAttributeLocations=function(t){var e,n=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],o=t.attributes,a={},i=0,s=n.length;for(e=0;s>e;++e){var u=n[e];r(o[u])&&(a[u]=i++)}for(var l in o)o.hasOwnProperty(l)&&!r(a[l])&&(a[l]=i++);return a},H.reorderForPreVertexCache=function(t){var e=C.computeNumberOfVertices(t),n=t.indices;if(r(n)){for(var o=new Int32Array(e),a=0;e>a;a++)o[a]=-1;for(var i,s=n,u=s.length,l=v.createTypedArray(e,u),c=0,f=0,h=0;u>c;)i=o[s[c]],-1!==i?l[f]=i:(i=s[c],o[i]=h,l[f]=h,++h),++c,++f;t.indices=l;var m=t.attributes;for(var y in m)if(m.hasOwnProperty(y)&&r(m[y])&&r(m[y].values)){for(var p=m[y],g=p.values,E=0,w=p.componentsPerAttribute,S=d.createTypedArray(p.componentDatatype,h*w);e>E;){var x=o[E];if(-1!==x)for(a=0;w>a;a++)S[w*x+a]=g[w*E+a];++E}p.values=S}}return t},H.reorderForPostVertexCache=function(t,e){var n=t.indices;if(t.primitiveType===g.TRIANGLES&&r(n)){for(var o=n.length,a=0,i=0;o>i;i++)n[i]>a&&(a=n[i]);t.indices=E.tipsify({indices:n,maximumIndex:a,cacheSize:e})}return t},H.fitToUnsignedShortIndices=function(t){var e=[],n=C.computeNumberOfVertices(t);if(r(t.indices)&&n>f.SIXTY_FOUR_KILOBYTES){var o,a=[],i=[],s=0,u=T(t.attributes),l=t.indices,c=l.length;t.primitiveType===g.TRIANGLES?o=3:t.primitiveType===g.LINES?o=2:t.primitiveType===g.POINTS&&(o=1);for(var h=0;c>h;h+=o){for(var m=0;o>m;++m){var y=l[h+m],p=a[y];r(p)||(p=s++,a[y]=p,O(u,t.attributes,y)),i.push(p)}s+o>f.SIXTY_FOUR_KILOBYTES&&(e.push(new C({attributes:u,indices:i,primitiveType:t.primitiveType,boundingSphere:t.boundingSphere})),a=[],i=[],s=0,u=T(t.attributes))}0!==i.length&&e.push(new C({attributes:u,indices:i,primitiveType:t.primitiveType,boundingSphere:t.boundingSphere}))}else e.push(t);return e};var k=new a,j=new s;H.projectTo2D=function(t,e,o,i,s){var u=t.attributes[e];s=r(s)?s:new p;for(var l=s.getEllipsoid(),c=u.values,f=new Float64Array(c.length),h=0,m=0;m<c.length;m+=3){var y=a.fromArray(c,m,k),v=l.cartesianToCartographic(y,j);if(!r(v))throw new n("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var g=s.project(v,k);f[h++]=g.x,f[h++]=g.y,f[h++]=g.z}return t.attributes[o]=u,t.attributes[i]=new S({componentDatatype:d.DOUBLE,componentsPerAttribute:3,values:f}),delete t.attributes[e],t};var K={high:0,low:0};H.encodeAttribute=function(t,e,r,n){for(var o=t.attributes[e],a=o.values,i=a.length,s=new Float32Array(i),l=new Float32Array(i),c=0;i>c;++c)u.encode(a[c],K),s[c]=K.high,l[c]=K.low;var f=o.componentsPerAttribute;return t.attributes[r]=new S({componentDatatype:d.FLOAT,componentsPerAttribute:f,values:s}),t.attributes[n]=new S({componentDatatype:d.FLOAT,componentsPerAttribute:f,values:l}),delete t.attributes[e],t};var Z=new a,X=new m,Q=new h;H.transformToWorldCoordinates=function(t){var e=t.modelMatrix;if(m.equals(e,m.IDENTITY))return t;var n=t.geometry.attributes;I(e,n.position),I(e,n.prevPosition),I(e,n.nextPosition),(r(n.normal)||r(n.binormal)||r(n.tangent))&&(m.inverse(e,X),m.transpose(X,X),m.getRotation(X,Q),N(Q,n.normal),N(Q,n.binormal),N(Q,n.tangent));var o=t.geometry.boundingSphere;return r(o)&&(t.geometry.boundingSphere=w.transform(o,e,o)),t.modelMatrix=m.clone(m.IDENTITY),t},H.combine=function(t){var e,n,o,i,s=t.length;t[0].modelMatrix;var u,l,c,f=r(t[0].geometry.indices),h=t[0].geometry.primitiveType,m=R(t);for(e in m)if(m.hasOwnProperty(e))for(u=m[e].values,i=0,n=0;s>n;++n)for(l=t[n].geometry.attributes[e].values,c=l.length,o=0;c>o;++o)u[i++]=l[o];var y;if(f){var p=0;for(n=0;s>n;++n)p+=t[n].geometry.indices.length;var d=C.computeNumberOfVertices(new C({attributes:m,primitiveType:g.POINTS})),E=v.createTypedArray(d,p),S=0,x=0;for(n=0;s>n;++n){var M=t[n].geometry.indices,A=M.length;for(i=0;A>i;++i)E[S++]=x+M[i];x+=C.computeNumberOfVertices(t[n].geometry)}y=E}var b,T=new a,O=0;for(n=0;s>n;++n){if(b=t[n].geometry.boundingSphere,!r(b)){T=void 0;break}a.add(b.center,T,T)}if(r(T))for(a.divideByScalar(T,s,T),n=0;s>n;++n){b=t[n].geometry.boundingSphere;var I=a.magnitude(a.subtract(b.center,T))+b.radius;I>O&&(O=I)}return new C({attributes:m,indices:y,primitiveType:h,boundingSphere:r(T)?new w(T,O):void 0})};var J=new a,$=new a,te=new a,ee=new a;H.computeNormal=function(t){for(var e=t.indices,r=t.attributes,n=r.position.values,o=r.position.values.length/3,i=e.length,s=new Array(o),u=new Array(i/3),l=new Array(i),c=0;o>c;c++)s[c]={indexOffset:0,count:0,currentCount:0};var f=0;for(c=0;i>c;c+=3){var h=e[c],m=e[c+1],y=e[c+2],p=3*h,v=3*m,g=3*y;$.x=n[p],$.y=n[p+1],$.z=n[p+2],te.x=n[v],te.y=n[v+1],te.z=n[v+2],ee.x=n[g],ee.y=n[g+1],ee.z=n[g+2],s[h].count++,s[m].count++,s[y].count++,a.subtract(te,$,te),a.subtract(ee,$,ee),u[f]=a.cross(te,ee),f++}var E=0;for(c=0;o>c;c++)s[c].indexOffset+=E,E+=s[c].count;f=0;var w;for(c=0;i>c;c+=3){w=s[e[c]];var C=w.indexOffset+w.currentCount;l[C]=f,w.currentCount++,w=s[e[c+1]],C=w.indexOffset+w.currentCount,l[C]=f,w.currentCount++,w=s[e[c+2]],C=w.indexOffset+w.currentCount,l[C]=f,w.currentCount++,f++}var x=new Float32Array(3*o);for(c=0;o>c;c++){var M=3*c;if(w=s[c],w.count>0){for(a.clone(a.ZERO,J),f=0;f<w.count;f++)a.add(J,u[l[w.indexOffset+f]],J);a.normalize(J,J),x[M]=J.x,x[M+1]=J.y,x[M+2]=J.z}else x[M]=0,x[M+1]=0,x[M+2]=1}return t.attributes.normal=new S({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:x}),t};var re=new a,ne=new a,oe=new a;H.computeBinormalAndTangent=function(t){t.attributes;for(var e=t.indices,r=t.attributes.position.values,n=t.attributes.normal.values,o=t.attributes.st.values,i=t.attributes.position.values.length/3,s=e.length,u=new Array(3*i),l=0;l<u.length;l++)u[l]=0;var c,f,h;for(l=0;s>l;l+=3){var m=e[l],y=e[l+1],p=e[l+2];c=3*m,f=3*y,h=3*p;var v=2*m,g=2*y,E=2*p,w=r[c],C=r[c+1],x=r[c+2],M=o[v],A=o[v+1],b=o[g+1]-A,T=o[E+1]-A,O=1/((o[g]-M)*T-(o[E]-M)*b),I=(T*(r[f]-w)-b*(r[h]-w))*O,N=(T*(r[f+1]-C)-b*(r[h+1]-C))*O,R=(T*(r[f+2]-x)-b*(r[h+2]-x))*O;u[c]+=I,u[c+1]+=N,u[c+2]+=R,u[f]+=I,u[f+1]+=N,u[f+2]+=R,u[h]+=I,u[h+1]+=N,u[h+2]+=R}var z=new Float32Array(3*i),L=new Float32Array(3*i);for(l=0;i>l;l++){c=3*l,f=c+1,h=c+2;var F=a.fromArray(n,c,re),D=a.fromArray(u,c,oe),P=a.dot(F,D);a.multiplyByScalar(F,P,ne),a.normalize(a.subtract(D,ne,D),D),L[c]=D.x,L[f]=D.y,L[h]=D.z,a.normalize(a.cross(F,D,D),D),z[c]=D.x,z[f]=D.y,z[h]=D.z}return t.attributes.tangent=new S({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:L}),t.attributes.binormal=new S({componentDatatype:d.FLOAT,componentsPerAttribute:3,values:z}),t};var ae=new a,ie=new a,se=new a,ue=new a,le=new a,ce={positions:new Array(7),indices:new Array(9)};return H.wrapLongitude=function(t){var e=t.boundingSphere;if(r(e)){var n=e.center.x-e.radius;if(n>0||w.intersect(e,i.UNIT_Y)!==l.INTERSECTING)return t}return B(t),t.primitiveType===g.TRIANGLES?Y(t):t.primitiveType===g.LINES&&V(t),t},H}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";var e=function(e){e=t(e,t.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.binormal=e.binormal,this.tangent=e.tangent,this.color=e.color};return e}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,r,n,o){"use strict";var a=function(t,r,n,o){this[0]=e(t,0),this[1]=e(n,0),this[2]=e(r,0),this[3]=e(o,0)};return a.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e):new a(t[0],t[2],t[1],t[3]):void 0},a.fromArray=function(t,n,o){return n=e(n,0),r(o)||(o=new a),o[0]=t[n],o[1]=t[n+1],o[2]=t[n+2],o[3]=t[n+3],o},a.fromColumnMajorArray=function(t,e){return a.clone(t,e)},a.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[2],e[2]=t[1],e[3]=t[3],e):new a(t[0],t[1],t[2],t[3])},a.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=t.y,e):new a(t.x,0,0,t.y)},a.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=t,e):new a(t,0,0,t)},a.fromRotation=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=n,e[1]=o,e[2]=-o,e[3]=n,e):new a(n,-o,o,n)},a.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e):[t[0],t[1],t[2],t[3]]},a.getElementIndex=function(t,e){return 2*t+e},a.getColumn=function(e,n,o){var a=2*n,i=e[a],s=e[a+1];return r(o)?(o.x=i,o.y=s,o):new t(i,s)},a.setColumn=function(t,e,r,n){n=a.clone(t,n);var o=2*e;return n[o]=r.x,n[o+1]=r.y,n},a.getRow=function(e,n,o){var a=e[n],i=e[n+2];return r(o)?(o.x=a,o.y=i,o):new t(a,i)},a.setRow=function(t,e,r,n){return n=a.clone(t,n),n[e]=r.x,n[e+2]=r.y,n},a.multiply=function(t,e,n){var o=t[0]*e[0]+t[2]*e[1],i=t[0]*e[2]+t[2]*e[3],s=t[1]*e[0]+t[3]*e[1],u=t[1]*e[2]+t[3]*e[3];return r(n)?(n[0]=o,n[1]=s,n[2]=i,n[3]=u,n):new a(o,i,s,u)},a.multiplyByVector=function(e,n,o){var a=e[0]*n.x+e[2]*n.y,i=e[1]*n.x+e[3]*n.y;return r(o)?(o.x=a,o.y=i,o):new t(a,i)},a.multiplyByScalar=function(t,e,n){return r(n)?(n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n):new a(t[0]*e,t[2]*e,t[1]*e,t[3]*e)},a.negate=function(t,e){return r(e)?(e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e):new a(-t[0],-t[2],-t[1],-t[3])},a.transpose=function(t,e){var n=t[0],o=t[2],i=t[1],s=t[3];return r(e)?(e[0]=n,e[1]=o,e[2]=i,e[3]=s,e):new a(n,i,o,s)},a.abs=function(t,e){return r(e)?(e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e):new a(Math.abs(t[0]),Math.abs(t[2]),Math.abs(t[1]),Math.abs(t[3]))},a.equals=function(t,e){return t===e||r(t)&&r(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},a.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n},a.IDENTITY=o(new a(1,0,0,1)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n"+"("+this[1]+", "+this[3]+")"},a}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3"],function(t,e,r,n,o,a,i){"use strict";var s,u=function(t,r,n,o){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(o,0)};u.fromAxisAngle=function(e,n,o){var a=n/2,i=Math.sin(a);s=t.normalize(e,s);var l=s.x*i,c=s.y*i,f=s.z*i,h=Math.cos(a);return r(o)?(o.x=l,o.y=c,o.z=f,o.w=h,o):new u(l,c,f,h)};var l=[1,2,0],c=new Array(3);u.fromRotationMatrix=function(t,e){var n,o,a,s,f,h=t[i.COLUMN0ROW0],m=t[i.COLUMN1ROW1],y=t[i.COLUMN2ROW2],p=h+m+y;if(p>0)n=Math.sqrt(p+1),f=.5*n,n=.5/n,o=(t[i.COLUMN1ROW2]-t[i.COLUMN2ROW1])*n,a=(t[i.COLUMN2ROW0]-t[i.COLUMN0ROW2])*n,s=(t[i.COLUMN0ROW1]-t[i.COLUMN1ROW0])*n;else{var d=l,v=0;m>h&&(v=1),y>h&&y>m&&(v=2);var g=d[v],E=d[g];n=Math.sqrt(t[i.getElementIndex(v,v)]-t[i.getElementIndex(g,g)]-t[i.getElementIndex(E,E)]+1);var w=c;w[v]=.5*n,n=.5/n,f=(t[i.getElementIndex(E,g)]-t[i.getElementIndex(g,E)])*n,w[g]=(t[i.getElementIndex(g,v)]+t[i.getElementIndex(v,g)])*n,w[E]=(t[i.getElementIndex(E,v)]+t[i.getElementIndex(v,E)])*n,o=-w[0],a=-w[1],s=-w[2]}return r(e)?(e.x=o,e.y=a,e.z=s,e.w=f,e):new u(o,a,s,f)};var f=new t,h=new t,m=new u,y=new u,p=new u;u.packedLength=4,u.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},u.unpack=function(t,n,o){return n=e(n,0),r(o)||(o=new u),o.x=t[n],o.y=t[n+1],o.z=t[n+2],o.w=t[n+3],o},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(t,e,r,n){u.unpack(t,4*r,p),u.conjugate(p,p);for(var o=0,a=r-e+1;a>o;o++){var i=3*o;u.unpack(t,4*(e+o),m),u.multiply(m,p,m),m.w<0&&u.negate(m,m),u.getAxis(m,f);var s=u.getAngle(m);n[i]=f.x*s,n[i+1]=f.y*s,n[i+2]=f.z*s}},u.unpackInterpolationResult=function(e,n,o,a,i){r(i)||(i=new u),t.fromArray(e,0,h);var s=t.magnitude(h);return u.unpack(n,4*a,y),0===s?u.clone(u.IDENTITY,m):u.fromAxisAngle(h,s,m),u.multiply(m,y,i)},u.clone=function(t,e){return r(t)?r(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e):new u(t.x,t.y,t.z,t.w):void 0},u.conjugate=function(t,e){return r(e)?(e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=t.w,e):new u(-t.x,-t.y,-t.z,t.w)},u.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},u.magnitude=function(t){return Math.sqrt(u.magnitudeSquared(t))},u.normalize=function(t,e){var n=1/u.magnitude(t),o=t.x*n,a=t.y*n,i=t.z*n,s=t.w*n;return r(e)?(e.x=o,e.y=a,e.z=i,e.w=s,e):new u(o,a,i,s)},u.inverse=function(t,e){var r=u.magnitudeSquared(t);return e=u.conjugate(t,e),u.multiplyByScalar(e,1/r,e)},u.add=function(t,e,n){return r(n)?(n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n.w=t.w+e.w,n):new u(t.x+e.x,t.y+e.y,t.z+e.z,t.w+e.w)},u.subtract=function(t,e,n){return r(n)?(n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n.w=t.w-e.w,n):new u(t.x-e.x,t.y-e.y,t.z-e.z,t.w-e.w)},u.negate=function(t,e){return r(e)?(e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e):new u(-t.x,-t.y,-t.z,-t.w)},u.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},u.multiply=function(t,e,n){var o=t.x,a=t.y,i=t.z,s=t.w,l=e.x,c=e.y,f=e.z,h=e.w,m=s*l+o*h+a*f-i*c,y=s*c-o*f+a*h+i*l,p=s*f+o*c-a*l+i*h,d=s*h-o*l-a*c-i*f;return r(n)?(n.x=m,n.y=y,n.z=p,n.w=d,n):new u(m,y,p,d)},u.multiplyByScalar=function(t,e,n){return r(n)?(n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n.w=t.w*e,n):new u(t.x*e,t.y*e,t.z*e,t.w*e)},u.divideByScalar=function(t,e,n){return r(n)?(n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n.w=t.w/e,n):new u(t.x/e,t.y/e,t.z/e,t.w/e)},u.getAxis=function(e,n){var o=e.w;if(Math.abs(o-1)<a.EPSILON6)return r(n)?(n.x=n.y=n.z=0,n):new t;var i=1/Math.sqrt(1-o*o);return r(n)?(n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n):new t(e.x*i,e.y*i,e.z*i)},u.getAngle=function(t){return Math.abs(t.w-1)<a.EPSILON6?0:2*Math.acos(t.w)};var d;u.lerp=function(t,e,r,n){return d=u.multiplyByScalar(e,r,d),n=u.multiplyByScalar(t,1-r,n),u.add(d,n,n)};var v,g,E;u.slerp=function(t,e,r,n){var o=u.dot(t,e),i=e;if(0>o&&(o=-o,i=v=u.negate(e,v)),1-o<a.EPSILON6)return u.lerp(t,i,r,n);var s=Math.acos(o);return g=u.multiplyByScalar(t,Math.sin((1-r)*s),g),E=u.multiplyByScalar(i,Math.sin(r*s),E),n=u.add(g,E,n),u.multiplyByScalar(n,1/Math.sin(s),n)},u.log=function(e,n){var o=Math.acos(a.clamp(e.w,-1,1)),i=0;return 0!==o&&(i=o/Math.sin(o)),r(n)||(n=new t),t.multiplyByScalar(e,i,n)},new t,u.exp=function(e,n){var o=t.magnitude(e),a=0;return 0!==o&&(a=Math.sin(o)/o),r(n)||(n=new u),n.x=e.x*a,n.y=e.y*a,n.z=e.z*a,n.w=Math.cos(o),n};var w=new t,C=new t,S=new u,x=new u;u.innerQuadrangle=function(e,r,n,o){var a=u.conjugate(r,S);u.multiply(a,n,x);var i=u.log(x,w);u.multiply(a,e,x);var s=u.log(x,C);return t.add(i,s,i),t.multiplyByScalar(i,.25,i),t.negate(i,i),u.exp(i,S),u.multiply(r,S,o)},u.squad=function(t,e,r,n,o,a){var i=u.slerp(t,e,o,S),s=u.slerp(r,n,o,x);return u.slerp(i,s,2*o*(1-o),a)};for(var M=new u,A=1.9011074535173003,b=new Float32Array(8),T=new Float32Array(8),O=new Float32Array(8),I=new Float32Array(8),N=0;7>N;++N){var R=N+1,z=2*R+1;b[N]=1/(R*z),T[N]=R/z}return b[7]=A/136,T[7]=8*A/17,u.fastSlerp=function(t,e,n,o){r(o)||(o=new u);var a,i=u.dot(t,e);i>=0?a=1:(a=-1,i=-i);for(var s=i-1,l=1-n,c=n*n,f=l*l,h=7;h>=0;--h)O[h]=(b[h]*c-T[h])*s,I[h]=(b[h]*f-T[h])*s;var m=a*n*(1+O[0]*(1+O[1]*(1+O[2]*(1+O[3]*(1+O[4]*(1+O[5]*(1+O[6]*(1+O[7])))))))),y=l*(1+I[0]*(1+I[1]*(1+I[2]*(1+I[3]*(1+I[4]*(1+I[5]*(1+I[6]*(1+I[7])))))))),p=u.multiplyByScalar(t,y,M);return u.multiplyByScalar(e,m,o),u.add(p,o,o)},u.fastSquad=function(t,e,r,n,o,a){var i=u.fastSlerp(t,e,o,S),s=u.fastSlerp(r,n,o,x);return u.fastSlerp(i,s,2*o*(1-o),a)},u.equals=function(t,e){return t===e||r(t)&&r(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},u.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t.x-e.x)<=n&&Math.abs(t.y-e.y)<=n&&Math.abs(t.z-e.z)<=n&&Math.abs(t.w-e.w)<=n},u.ZERO=o(new u(0,0,0,0)),u.IDENTITY=o(new u(0,0,0,1)),u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.equals=function(t){return u.equals(this,t)},u.prototype.equalsEpsilon=function(t,e){return u.equalsEpsilon(this,t,e)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(t,e){"use strict";var r=function(e){e=t(e,t.EMPTY_OBJECT),this.position=t(e.position,!1),this.normal=t(e.normal,!1),this.st=t(e.st,!1),this.binormal=t(e.binormal,!1),this.tangent=t(e.tangent,!1)};return r.POSITION_ONLY=e(new r({position:!0})),r.POSITION_AND_NORMAL=e(new r({position:!0,normal:!0})),r.POSITION_NORMAL_AND_ST=e(new r({position:!0,normal:!0,st:!0})),r.POSITION_AND_ST=e(new r({position:!0,st:!0})),r.ALL=e(new r({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),r.DEFAULT=r.POSITION_NORMAL_AND_ST,r
}),define("Core/ExtentGeometry",["./defaultValue","./defined","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./IndexDatatype","./DeveloperError","./Ellipsoid","./Extent","./Geometry","./GeometryInstance","./GeometryPipeline","./GeographicProjection","./GeometryAttribute","./GeometryAttributes","./Math","./Matrix2","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(t,e,r,n,o,a,i,s,u,l,c,f,h,m,y,p,d,v,g,E,w,C,S){"use strict";function x(t,e){return t<-v.PI_OVER_TWO||t>v.PI_OVER_TWO?!1:e>v.PI||e<-v.PI?!1:!0}function M(t,r,n,o,a){var i=t.radiiSquared;z=D.latitude-t.granYCos*r+n*t.granXSin;var s=te(z),u=ee(z),l=i.z*u;L=D.longitude+r*t.granYSin+n*t.granXCos;var c=s*te(L),f=s*ee(L),h=i.x*c,m=i.y*f,y=re(h*c+m*f+l*u),p=h/y,d=m/y,v=l/y;e(o)&&(Y.x=p+c*o,Y.y=d+f*o,Y.z=v+u*o),e(a)&&(j.x=p+c*a,j.y=d+f*a,j.z=v+u*a)}function A(t,e){var r=new f({attributes:new d,primitiveType:w.TRIANGLES});return t.position&&(r.attributes.position=new p({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:e.positions})),t.normal&&(r.attributes.normal=new p({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:e.normals})),t.tangent&&(r.attributes.tangent=new p({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:e.tangents})),t.binormal&&(r.attributes.binormal=new p({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:e.binormals})),r}function b(t,e,r,n,a){var i=t.length,s=e.normal?new Float32Array(i):void 0,u=e.tangent?new Float32Array(i):void 0,l=e.binormal?new Float32Array(i):void 0,c=0,f=n?i/2:0;i=n&&a?i/2:i;for(var h=0;i>h;h+=3){var m=o.fromArray(t,h,Y),y=c+1,p=c+2;(e.normal||e.tangent||e.binormal)&&(V=r.geodeticSurfaceNormal(m,V),(e.tangent||e.binormal)&&(o.cross(o.UNIT_Z,V,H),E.multiplyByVector(q,H,H),o.normalize(H,H),e.binormal&&o.normalize(o.cross(V,H,k),k)),n&&(e.normal&&(s[c]=V.x,s[y]=V.y,s[p]=V.z),e.tangent&&(u[c]=H.x,u[y]=H.y,u[p]=H.z),e.binormal&&(l[c]=k.x,l[y]=k.y,l[p]=k.z)),a&&(e.normal&&(s[c+f]=-V.x,s[y+f]=-V.y,s[p+f]=-V.z),e.tangent&&(u[c+f]=-H.x,u[y+f]=-H.y,u[p+f]=-H.z),e.binormal&&(l[c+f]=k.x,l[y+f]=k.y,l[p+f]=k.z))),c+=3}return A(e,{positions:t,normals:s,tangents:u,binormals:l})}function T(t,e,r){for(var n=t.length,a=e.normal?new Float32Array(n):void 0,i=e.tangent?new Float32Array(n):void 0,s=e.binormal?new Float32Array(n):void 0,u=0,l=!0,c=n/2,f=0;c>f;f+=3){var h=o.fromArray(t,f,Y),m=u+1,y=u+2;if(e.normal||e.tangent||e.binormal){var p=o.fromArray(t,f+3,X);if(l){var d=o.fromArray(t,f+c,Q);o.subtract(p,h,p),o.subtract(d,h,d),V=o.normalize(o.cross(d,p,V),V),l=!1}o.equalsEpsilon(p,h,v.EPSILON10)&&(l=!0),(e.tangent||e.binormal)&&(k=r.geodeticSurfaceNormal(h,k),e.tangent&&(H=o.normalize(o.cross(k,V,H),H))),e.normal&&(a[u]=V.x,a[m]=V.y,a[y]=V.z,a[u+c]=V.x,a[m+c]=V.y,a[y+c]=V.z),e.tangent&&(i[u]=H.x,i[m]=H.y,i[y]=H.z,i[u+c]=H.x,i[m+c]=H.y,i[y+c]=H.z),e.binormal&&(s[u]=k.x,s[m]=k.y,s[y]=k.z,s[u+c]=k.x,s[m+c]=k.y,s[y+c]=k.z)}u+=3}return A(e,{positions:t,normals:a,tangents:i,binormals:s})}function O(t,r,n,o,a){return J.x=(L-B.west)*o.lonScalar-.5,J.y=(z-B.south)*o.latScalar-.5,g.multiplyByVector(U,J,J),J.x+=.5,J.y+=.5,e(a)&&(n[r+a]=J.x,n[r+1+a]=J.y),n[r++]=J.x,n[r++]=J.y,r}function I(t,e,r){return t[e+r]=j.x,t[e++]=Y.x,t[e+r]=j.y,t[e++]=Y.y,t[e+r]=j.z,t[e++]=Y.z,t}function N(t,e){for(var n=e.ellipsoid,o=e.size,a=e.height,u=e.width,l=e.surfaceHeight,c=0,f=t.position?new Float64Array(3*o):void 0,h=t.st?new Float32Array(2*o):void 0,m=0,y=0;a>y;++y)for(var d=0;u>d;++d)M(e,y,d,l),f[m++]=Y.x,f[m++]=Y.y,f[m++]=Y.z,t.st&&(J.x=(L-B.west)*e.lonScalar-.5,J.y=(z-B.south)*e.latScalar-.5,g.multiplyByVector(U,J,J),J.x+=.5,J.y+=.5,h[c++]=J.x,h[c++]=J.y);for(var v=b(f,t,n,!0,!1),E=6*(u-1)*(a-1),w=s.createTypedArray(o,E),C=0,S=0,x=0;a-1>x;++x){for(var A=0;u-1>A;++A){var T=C,O=T+u,I=O+1,N=T+1;w[S++]=T,w[S++]=O,w[S++]=N,w[S++]=N,w[S++]=O,w[S++]=I,++C}++C}return v.indices=w,t.st&&(v.attributes.st=new p({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:h})),{boundingSphere:r.fromExtent3D(e.extent,n,l),geometry:v}}function R(e,n){var a=n.surfaceHeight,u=n.extrudedHeight,l=Math.min(u,a),c=Math.max(u,a);if(v.equalsEpsilon(l,c,.1))return N(e,n);var f,y=n.height,d=n.width,g=n.size,E=n.ellipsoid,w=t(n.closeTop,!0),C=t(n.closeBottom,!0),S=2*d+2*y-4,x=2*(S+4),A=new Float64Array(3*x),R=e.st?new Float32Array(2*x):void 0,z=0,L=0,F=0,D=3*(x/2);for(f=0;y>f;f++)M(n,f,z,c,l),A=I(A,L,D),L+=3,e.st&&(F=O(e,F,R,n,x));for(f=y-1,z=0;d>z;z++)M(n,f,z,c,l),A=I(A,L,D),L+=3,e.st&&(F=O(e,F,R,n,x));for(z=d-1,f=y-1;f>=0;f--)M(n,f,z,c,l),A=I(A,L,D),L+=3,e.st&&(F=O(e,F,R,n,x));for(f=0,z=d-1;z>=0;z--)M(n,f,z,c,l),A=I(A,L,D),L+=3,e.st&&(F=O(e,F,R,n,x));var P=T(A,e,E);e.st&&(P.attributes.st=new p({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:R}));var _,B,U,G,q,W=s.createTypedArray(x,6*S),V=A.length/6,H=0;for(q=0;V-1>q;q++){_=q,G=_+1;var k=o.fromArray(A,3*_,X),J=o.fromArray(A,3*G,Q);o.equalsEpsilon(k,J,v.EPSILON10)||(B=_+V,U=B+1,W[H++]=_,W[H++]=B,W[H++]=G,W[H++]=G,W[H++]=B,W[H++]=U)}if(P.indices=W,C||w){var $,te,ee=0,re=0;w&&(ee+=g,re+=6*(d-1)*(y-1),$=c),C&&(ee+=g,re+=6*(d-1)*(y-1),te=l);var ne=new Float64Array(3*ee),oe=e.st?new Float32Array(2*ee):void 0,ae=s.createTypedArray(ee,re);for(L=0,F=0,D=C&&w?3*g:0,f=0;y>f;++f)for(z=0;d>z;++z)M(n,f,z,$,te),C&&(ne[L+D]=j.x,ne[L+1+D]=j.y,ne[L+2+D]=j.z),w&&(ne[L]=Y.x,ne[L+1]=Y.y,ne[L+2]=Y.z),e.st&&(F=O(e,F,oe,n,2*g)),L+=3;var ie=b(ne,e,E,w,C);e.st&&(ie.attributes.st=new p({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:oe}));var se=0;for(H=0,D/=3,q=0;y-1>q;++q){for(var ue=0;d-1>ue;++ue)_=H,B=_+d,U=B+1,G=_+1,C&&(ae[se++]=G+D,ae[se++]=B+D,ae[se++]=_+D,ae[se++]=U+D,ae[se++]=B+D,ae[se++]=G+D),w&&(ae[se++]=_,ae[se++]=B,ae[se++]=G,ae[se++]=G,ae[se++]=B,ae[se++]=U),++H;++H}ie.indices=ae,P=m.combine([new h({geometry:ie}),new h({geometry:P})])}var le=r.fromExtent3D(n.extent,E,c,Z),ce=r.fromExtent3D(n.extent,E,l,K),fe=r.union(le,ce);return{boundingSphere:fe,geometry:P}}var z,L,F=new o,D=new a,P=new a,_=new o,B=new c,U=new g,G=new g,q=new E,W=new y,Y=new o,V=new o,H=new o,k=new o,j=new o,K=new r,Z=new r,X=new o,Q=new o,J=new n,$=new C,te=Math.cos,ee=Math.sin,re=Math.sqrt,ne=function(e){e=t(e,t.EMPTY_OBJECT);var r=e.extent,n=t(e.granularity,v.RADIANS_PER_DEGREE),o=t(e.ellipsoid,l.WGS84),a=t(e.height,0),i=e.rotation,s=e.stRotation,u=t(e.vertexFormat,S.DEFAULT);this._extent=r,this._granularity=n,this._ellipsoid=o,this._surfaceHeight=a,this._rotation=i,this._stRotation=s,this._vertexFormat=u,this._extrudedHeight=e.extrudedHeight,this._closeTop=e.closeTop,this._closeBottom=e.closeBottom,this._workerName="createExtentGeometry"};return ne.createGeometry=function(t){var r=t._extent,n=t._granularity,a=t._ellipsoid,i=t._surfaceHeight,s=t._rotation,l=t._stRotation,h=t._vertexFormat,m=t._extrudedHeight,y=t._closeTop,p=t._closeBottom,v=Math.ceil((r.east-r.west)/n)+1,w=Math.ceil((r.north-r.south)/n)+1,S=(r.east-r.west)/(v-1),M=(r.north-r.south)/(w-1),A=a.getRadiiSquared();c.clone(r,B),r.getNorthwest(D),r.getCenter(P);var b=M,T=S,O=0,I=0;if(e(s)){var z=te(s);b*=z,T*=z;var L=ee(s);O=M*L,I=S*L,W.project(D,F),W.project(P,_),o.subtract(F,_,F),g.fromRotation(s,G),g.multiplyByVector(G,F,F),o.add(F,_,F),W.unproject(F,D);var Y=D.latitude,V=Y+(v-1)*I,H=Y-b*(w-1),k=Y-b*(w-1)+(v-1)*I,j=Math.max(Y,V,H,k),K=Math.min(Y,V,H,k),Z=D.longitude,Q=Z+(v-1)*T,J=Z+(w-1)*O,re=Z+(w-1)*O+(v-1)*T,ne=Math.max(Z,Q,J,re),oe=Math.min(Z,Q,J,re);if(!(x(j,oe)&&x(j,ne)&&x(K,oe)&&x(K,ne)))throw new u("Rotated extent is invalid.");B.north=j,B.south=K,B.east=ne,B.west=oe}var ae=1/(B.east-B.west),ie=1/(B.north-B.south),se=v*w;if(e(l)){g.fromRotation(-l,U);var ue=a.cartographicToCartesian(P,X);o.normalize(ue,ue),C.fromAxisAngle(ue,-l,$),E.fromQuaternion($,q)}else g.clone(g.IDENTITY,U),E.clone(E.IDENTITY,q);var le,ce={granYCos:b,granYSin:O,granXCos:T,granXSin:I,radiiSquared:A,ellipsoid:a,lonScalar:ae,latScalar:ie,extent:r,width:v,height:w,surfaceHeight:i,size:se,extrudedHeight:m,closeTop:y,closeBottom:p};le=e(m)?R(h,ce):N(h,ce);var fe=le.boundingSphere;return le=le.geometry,new f({attributes:new d(le.attributes),indices:le.indices,primitiveType:le.primitiveType,boundingSphere:fe})},ne}),define("Core/Color",["./defaultValue","./defined","./freezeObject","./DeveloperError","./FeatureDetection","./Math"],function(t,e,r,n,o,a){"use strict";function i(t,e,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?t+6*(e-t)*r:1>2*r?e:2>3*r?t+6*(e-t)*(2/3-r):t}var s=function(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)};s.fromBytes=function(e,r,n,o){return e=s.byteToFloat(t(e,255)),r=s.byteToFloat(t(r,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),new s(e,r,n,o)};var u,l,c;o.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(t){return l[0]=t,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(e,r,n,o){e=t(e,0)%1,r=t(r,0),n=t(n,0),o=t(o,1);var a=n,u=n,l=n;if(0!==r){var c;c=.5>n?n*(1+r):n+r-n*r;var f=2*n-c;a=i(f,c,e+1/3),u=i(f,c,e),l=i(f,c,e-1/3)}return new s(a,u,l,o)},s.fromRandom=function(r,n){r=t(r,t.EMPTY_OBJECT);var o=r.red;if(!e(o)){var i=t(r.minimumRed,0),u=t(r.maximumRed,1);o=i+a.nextRandomNumber()*(u-i)}var l=r.green;if(!e(l)){var c=t(r.minimumGreen,0),f=t(r.maximumGreen,1);l=c+a.nextRandomNumber()*(f-c)}var h=r.blue;if(!e(h)){var m=t(r.minimumBlue,0),y=t(r.maximumBlue,1);h=m+a.nextRandomNumber()*(y-m)}var p=r.alpha;if(!e(p)){var d=t(r.minimumAlpha,0),v=t(r.maximumAlpha,1);p=d+a.nextRandomNumber()*(v-d)}return e(n)?(n.red=o,n.green=l,n.blue=h,n.alpha=p,n):new s(o,l,h,p)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,y=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){var n=s[r.toUpperCase()];if(e(n))return s.clone(n);var o=f.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=m.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(t(o[4],"1.0"))):(o=y.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(t(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.red,r[n++]=e.green,r[n++]=e.blue,r[n]=e.alpha},s.unpack=function(r,n,o){return n=t(n,0),e(o)||(o=new s),o.red=r[n++],o.green=r[n++],o.blue=r[n++],o.alpha=r[n],o},s.byteToFloat=function(t){return t/255},s.floatToByte=function(t){return 1===t?255:0|256*t},s.clone=function(t,r){return e(t)?e(r)?(r.red=t.red,r.green=t.green,r.blue=t.blue,r.alpha=t.alpha,r):new s(t.red,t.green,t.blue,t.alpha):void 0},s.equals=function(t,r){return t===r||e(t)&&e(r)&&t.red===r.red&&t.green===r.green&&t.blue===r.blue&&t.alpha===r.alpha},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.prototype.equalsEpsilon=function(t,r){return this===t||e(t)&&Math.abs(this.red-t.red)<=r&&Math.abs(this.green-t.green)<=r&&Math.abs(this.blue-t.blue)<=r&&Math.abs(this.alpha-t.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var t=s.floatToByte(this.red),e=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+t+","+e+","+r+")":"rgba("+t+","+e+","+r+","+this.alpha+")"},s.prototype.toBytes=function(t){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),a=s.floatToByte(this.alpha);return e(t)?(t[0]=r,t[1]=n,t[2]=o,t[3]=a,t):[r,n,o,a]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s}),define("Scene/PrimitivePipeline",["../Core/defined","../Core/defaultValue","../Core/Color","../Core/ComponentDatatype","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/Matrix4"],function(t,e,r,n,o,a,i,s,u,l){"use strict";function c(t,e,r){var n,o=!r,a=t.length;if(!o&&a>1){var i=t[0].modelMatrix;for(n=1;a>n;++n)if(!l.equals(i,t[n].modelMatrix)){o=!0;break}}if(o)for(n=0;a>n;++n)u.transformToWorldCoordinates(t[n]);else l.clone(t[0].modelMatrix,e)}function f(t,e){for(var o=t.length,a=0;o>a;++a){var i=t[a],u=i.geometry,l=u.attributes,c=l.position,f=4*(c.values.length/c.componentsPerAttribute);l.pickColor=new s({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(f)});for(var h=e[a],m=r.floatToByte(h.red),y=r.floatToByte(h.green),p=r.floatToByte(h.blue),d=r.floatToByte(h.alpha),v=l.pickColor.values,g=0;f>g;g+=4)v[g]=m,v[g+1]=y,v[g+2]=p,v[g+3]=d}}function h(e){var r,n=e.length,o=[],a=e[0].attributes;for(r in a)if(a.hasOwnProperty(r)){for(var i=a[r],s=!0,u=1;n>u;++u){var l=e[u].attributes[r];if(!t(l)||i.componentDatatype.value!==l.componentDatatype.value||i.componentsPerAttribute!==l.componentsPerAttribute||i.normalize!==l.normalize){s=!1;break}}s&&o.push(r)}return o}function m(t,e){for(var r=t.length,o=0;r>o;++o)for(var a=t[o],u=a.attributes,l=a.geometry,c=i.computeNumberOfVertices(l),f=e.length,h=0;f>h;++h){for(var m=e[h],y=u[m],p=y.componentDatatype,d=y.value,v=d.length,g=n.createTypedArray(p,c*v),E=0;c>E;++E)g.set(d,E*v);l.attributes[m]=new s({componentDatatype:p,componentsPerAttribute:v,normalize:y.normalize,values:g})}}function y(t){var e,r=t.instances,o=t.pickIds,a=t.projection,i=t.elementIndexUintSupported,s=t.allow3DOnly,l=t.allowPicking,y=t.vertexCacheOptimize,p=t.modelMatrix,d=r.length;if(r[0].geometry.primitiveType,c(r,p,s),!s)for(e=0;d>e;++e)u.wrapLongitude(r[e].geometry);l&&f(r,o);var v=h(r);if(m(r,v),y)for(e=0;d>e;++e)u.reorderForPostVertexCache(r[e].geometry),u.reorderForPreVertexCache(r[e].geometry);var g,E=u.combine(r),w=E.attributes;if(s)for(g in w)w.hasOwnProperty(g)&&w[g].componentDatatype.value===n.DOUBLE.value&&u.encodeAttribute(E,g,g+"3DHigh",g+"3DLow");else for(g in w)if(w.hasOwnProperty(g)&&w[g].componentDatatype.value===n.DOUBLE.value){var C=g+"3D",S=g+"2D";u.projectTo2D(E,g,C,S,a),u.encodeAttribute(E,C,C+"High",C+"Low"),u.encodeAttribute(E,S,S+"High",S+"Low")}return i?[E]:u.fitToUnsignedShortIndices(E)}function p(t,e,r){for(var o=[],a=t.attributes,i=r.length,s=0;i>s;++s){var u=r[s],l=a[u],c=l.componentDatatype;c.value===n.DOUBLE.value&&(c=n.FLOAT);var f=n.createTypedArray(c,l.values);o.push({index:e[u],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:f}),delete a[u]}return o}function d(r,n,o){for(var a=[],s=h(r),u=r.length,l={},c={},f=0;u>f;++f)for(var m=r[f],y=i.computeNumberOfVertices(m.geometry),p=s.length,d=0;p>d;++d)for(var v=s[d],g=o[v],E=y;E>0;){for(var w,C=e(c[v],0),S=n[C],x=S.length,M=0;x>M&&(w=S[M],w.index!==g);++M);t(a[f])||(a[f]={}),t(a[f][v])||(a[f][v]={dirty:!1,value:m.attributes[v].value,indices:[]});var A,b=w.values.length/w.componentsPerAttribute,T=e(l[v],0);b>T+E?(A=E,a[f][v].indices.push({attribute:w,offset:T,count:A}),l[v]=T+E):(A=b-T,a[f][v].indices.push({attribute:w,offset:T,count:A}),l[v]=0,c[v]=C+1),E-=A}return a}function v(t){return{type:t.constructor.name,buffer:t.buffer}}function g(t){return new w[t.type](t.buffer)}if(!a.supportsTypedArrays())return{};var E={};E.combineGeometry=function(t){for(var e={instances:t.instances,pickIds:t.pickIds,ellipsoid:t.ellipsoid,projection:t.projection,elementIndexUintSupported:t.elementIndexUintSupported,allow3DOnly:t.allow3DOnly,allowPicking:t.allowPicking,vertexCacheOptimize:t.vertexCacheOptimize,modelMatrix:l.clone(t.modelMatrix)},r=y(e),n=u.createAttributeLocations(r[0]),o=e.instances,a=h(o),i=[],s=r.length,c=0;s>c;++c){var f=r[c];i.push(p(f,n,a))}var m=d(o,i,n);return{geometries:r,modelMatrix:e.modelMatrix,attributeLocations:n,vaAttributes:i,vaAttributeLocations:m}};var w={Int8Array:Int8Array,Uint8Array:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};return E.transferGeometry=function(e,r){var n,o=e.attributes;for(var a in o)o.hasOwnProperty(a)&&t(o[a])&&t(o[a].values)&&(n=o[a].values,r.indexOf(o[a].values.buffer)<0&&r.push(n.buffer),t(n.type)||(o[a].values=v(n)));t(e.indices)&&(n=e.indices,r.push(n.buffer),t(n.type)||(e.indices=v(e.indices)))},E.transferGeometries=function(t,e){for(var r=t.length,n=0;r>n;++n)E.transferGeometry(t[n],e)},E.transferPerInstanceAttributes=function(t,e){for(var r=t.length,n=0;r>n;++n)for(var o=t[n],a=o.length,i=0;a>i;++i){var s=o[i].values;e.push(s.buffer),o[i].values=v(s)}},E.transferInstances=function(t,e){for(var r=t.length,n=0;r>n;++n){var o=t[n];E.transferGeometry(o.geometry,e)}},E.receiveGeometry=function(e){var r=e.attributes;for(var n in r)r.hasOwnProperty(n)&&t(r[n])&&t(r[n].values)&&(r[n].values=g(r[n].values));t(e.indices)&&(e.indices=g(e.indices))},E.receiveGeometries=function(t){for(var e=t.length,r=0;e>r;++r)E.receiveGeometry(t[r])},E.receivePerInstanceAttributes=function(t){for(var e=t.length,r=0;e>r;++r)for(var n=t[r],o=n.length,a=0;o>a;++a)n[a].values=g(n[a].values)},E.receiveInstances=function(t){for(var e=t.length,r=0;e>r;++r){var n=t[r];E.receiveGeometry(n.geometry)}},E}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined"],function(t,e){"use strict";var r=function(r){var n,o=[],a={id:void 0,result:void 0,error:void 0};return function(i){var s=i.data;o.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=r(s.parameters,o)}catch(u){a.error=u}e(n)||(n=t(self.webkitPostMessage,self.postMessage));try{n(a,o)}catch(u){a.result=void 0,a.error="postMessage failed with error: "+u+"\n  with responseMessage: "+JSON.stringify(a),n(a)}}};return r}),define("Workers/createExtentGeometry",["../Core/ExtentGeometry","../Core/Ellipsoid","../Core/Extent","../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(t,e,r,n,o){"use strict";function a(o,a){var i=o.geometry;i._ellipsoid=e.clone(i._ellipsoid),i._extent=r.clone(i._extent);var s=t.createGeometry(i);return n.transferGeometry(s,a),{geometry:s,index:o.index}}return o(a)})}();