import os

from qgis.PyQt import QtWidgets, uic, QtCore
from qgis.PyQt.QtCore import pyqtSignal

from .cyanlove_config_read_intfile import readconfig

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'cyanlove_tencent_keyset_base.ui'))


class cyanlove_tencent_keyset(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(cyanlove_tencent_keyset, self).__init__(parent)
        self.setupUi(self)
        self.setFloating(True)
        self.setWindowFlags(QtCore.Qt.Dialog)  # 使对话框始终在前
        # 设置为模态窗口
        self.setWindowModality(QtCore.Qt.ApplicationModal)  # 或者使用 Qt.WindowModal
        _translate = QtCore.QCoreApplication.translate
        self.label_2.setText(_translate("SettingDialog",
                                        "<html><head/><body><style>p { margin: 0.5px;font-size:10px} </style><a "
                                        "href=\"https://lbs.qq.com/dev/console/home\"><span"
                                        "style=\" font-weight:600; text-decoration: underline; "
                                        "color:#808080;\">点击此处前往腾讯地图申请 Key</span></a>\n"
                                        "</body></html>"))
        self.label_2.setOpenExternalLinks(True)

        self.label_baidu_link.setText(_translate("SettingDialog",
                                        "<html><head/><body><style>p { margin: 0.5px;font-size:10px} </style><a "
                                        "href=\"https://lbsyun.baidu.com/\"><span"
                                        "style=\" font-weight:600; text-decoration: underline; "
                                        "color:#808080;\">点击此处前往百度地图申请 Key</span></a>\n"
                                        "</body></html>"))
        self.label_baidu_link.setOpenExternalLinks(True)

        self.pushButton.clicked.connect(self.writer_init_file_keyset)
        self.btn_baidu_key.clicked.connect(self.baidu_key)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def writer_init_file_keyset(self):
        self.label_show.setText("")
        text = self.textEdit.toPlainText().strip()
        if text != "":
            readconfig.write_ini_file('Settings', 'tencentKey', text)
            self.label_show.setText("写入成功！")
        else:
            self.label_show.setText("没有填写Key值")

    def baidu_key(self):
        self.label_show.setText("")
        text = self.textEdit_key_baidu.toPlainText().strip()
        if text != "":
            readconfig.write_ini_file('Settings', 'baidu_Key', text)
            self.label_show.setText("写入成功！")
        else:
            self.label_show.setText("没有填写Key值")
