import configparser
import os

# 配置文件int格式
pathsaveint = os.path.join(os.path.dirname(__file__), 'config.ini')


class readconfig:

    @staticmethod
    def write_ini_file(section, key, value):
        config = configparser.ConfigParser()

        # 读取现有的配置文件
        config.read(pathsaveint)

        # 检查是否存在节，如果没有则添加
        if not config.has_section(section):
            config.add_section(section)

        # 检查是否存在键，如果存在则修改，如果不存在则添加
        config.set(section, key, value)

        # 将修改后的配置写回文件
        with open(pathsaveint, 'w') as configfile:
            config.write(configfile)

    @staticmethod
    def read_ini_file(section, key):
        config = configparser.ConfigParser()
        config.read(pathsaveint)

        if config.has_section(section) and config.has_option(section, key):
            value = config.get(section, key)
            return value
        else:
            return None
