import ctypes
import os
import sys
from ctypes import CDLL

from PyQt5.QtCore import QThread
from PyQt5.QtWidgets import QApplication, QPushButton, QMainWindow, QFileDialog


class ExportThread(QThread):
    def __init__(self,  savpath):
        super().__init__()  # 初始化父类
        self.savpath = savpath  # 存储

    def run(self):
        # 调用函数创建并写入多边形数据
        self.write_polygon_file(self.savpath, "tab")

    def write_polygon_file(self, psz_dest, psz_mif_or_tab):
        # 创建数据集
        # 加载 mitab64.dll
        current_dir = os.path.dirname(__file__)
        relative_path = os.path.join(current_dir, 'scripts', 'mitab64.dll')
        print(relative_path)
        lib = CDLL(relative_path)
        self.setargtypes(lib)
        dataset = lib.mitab_c_create(
            psz_dest.encode('utf-8'),
            psz_mif_or_tab.encode('utf-8'),
            "CoordSys Earth Projection 1, 0".encode('utf-8'),
            90.0, 0.0, 180.0, -180.0
        )

        if dataset is None:
            print("Failed to create the file:", psz_mif_or_tab)
            print("Error:", lib.mitab_c_getlasterrormsg().decode('utf-8'))
            return

        # 添加字段
        lib.mitab_c_add_field(dataset, "没有啥问题".encode('utf-8'), 1, 254, 0, 0, 0)
        lib.mitab_c_add_field(dataset, "TestFloat".encode('utf-8'), 5, 254, 2, 0, 0)
        lib.mitab_c_add_field(dataset, "TestString".encode('utf-8'), 1, 254, 0, 0, 0)

        # 创建一个多边形 (区域类型)
        feature = lib.mitab_c_create_feature(dataset, 7)  # 7 = TABFC_Region

        # 设置多边形的点坐标 (WGS84 坐标系下的多边形顶点)
        x = (ctypes.c_double * 23)(
            106.739882, 106.73988, 106.739877, 106.739873, 106.739869, 106.739863, 106.739857, 106.73985, 106.739842,
            106.739833, 106.739823, 106.739813, 106.739802, 106.73979, 106.739778, 106.739765, 106.739752, 106.739738,
            106.739724, 106.73971, 106.739695, 106.73963, 106.739882  # 最后一个点与第一个点相同，以确保闭合
        )
        y = (ctypes.c_double * 23)(
            27.08034, 27.080326, 27.080313, 27.080299, 27.080286, 27.080273, 27.080261, 27.080249, 27.080237, 27.080226,
            27.080215, 27.080205, 27.080195, 27.080186, 27.080177, 27.08017, 27.080163, 27.080156, 27.080151, 27.080146,
            27.080142, 27.08036, 27.08034  # 同样，最后一个点与第一个点相同
        )

        # 设置多边形的点
        lib.mitab_c_set_points(feature, 0, 23, x, y)

        # 设置多边形的样式（例如填充颜色和轮廓）
        # 设置填充色 (RGB)，例如绿色
        lib.mitab_c_set_brush(feature, 0, 255, 0, 2)  # 红, 绿, 蓝, 填充样式（2 = 纯色）
        # 设置边框色 (RGB)，例如蓝色
        lib.mitab_c_set_pen(feature, 5, 2, 65535)  # 宽度 1, 样式 2, 颜色 65535 (蓝色)

        # 设置字段数据
        lib.mitab_c_set_field(feature, 0, "100".encode('utf-8'))
        lib.mitab_c_set_field(feature, 1, "100.5".encode('utf-8'))
        lib.mitab_c_set_field(feature, 2, "Test Polygon".encode('utf-8'))

        # 写入多边形要素
        lib.mitab_c_write_feature(dataset, feature)

        # 销毁特征对象
        lib.mitab_c_destroy_feature(feature)
        # 关闭数据集
        lib.mitab_c_close(dataset)
        print("Polygon feature written successfully.")

    @staticmethod
    def setargtypes(lib):
        # 设置 mitab_c_create 函数的参数类型和返回类型
        lib.mitab_c_create.argtypes = [
            ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p,
            ctypes.c_double, ctypes.c_double, ctypes.c_double, ctypes.c_double
        ]
        lib.mitab_c_create.restype = ctypes.POINTER(ctypes.c_void_p)

        # 设置 mitab_c_add_field 函数的参数类型和返回类型
        lib.mitab_c_add_field.argtypes = [
            ctypes.POINTER(ctypes.c_void_p), ctypes.c_char_p, ctypes.c_int, ctypes.c_int,
            ctypes.c_int, ctypes.c_int, ctypes.c_int
        ]
        lib.mitab_c_add_field.restype = ctypes.c_long

        # 设置 mitab_c_create_feature 函数的参数类型和返回类型
        lib.mitab_c_create_feature.argtypes = [
            ctypes.POINTER(ctypes.c_void_p), ctypes.c_int
        ]
        lib.mitab_c_create_feature.restype = ctypes.POINTER(ctypes.c_void_p)

        # 设置 mitab_c_set_points 函数的参数类型和返回类型
        lib.mitab_c_set_points.argtypes = [
            ctypes.POINTER(ctypes.c_void_p), ctypes.c_int, ctypes.c_int, ctypes.POINTER(ctypes.c_double),
            ctypes.POINTER(ctypes.c_double)
        ]
        lib.mitab_c_set_points.restype = None

        # 设置 mitab_c_set_brush 函数的参数类型和返回类型
        lib.mitab_c_set_brush.argtypes = [
            ctypes.POINTER(ctypes.c_void_p), ctypes.c_int, ctypes.c_int, ctypes.c_int, ctypes.c_int
        ]
        lib.mitab_c_set_brush.restype = None

        # 设置 mitab_c_set_pen 函数的参数类型和返回类型
        lib.mitab_c_set_pen.argtypes = [
            ctypes.POINTER(ctypes.c_void_p), ctypes.c_int, ctypes.c_int, ctypes.c_int
        ]
        lib.mitab_c_set_pen.restype = None

        # 设置 mitab_c_write_feature 函数的参数类型和返回类型
        lib.mitab_c_write_feature.argtypes = [
            ctypes.POINTER(ctypes.c_void_p), ctypes.POINTER(ctypes.c_void_p)
        ]
        lib.mitab_c_write_feature.restype = None

        # 设置 mitab_c_destroy_feature 函数的参数类型
        lib.mitab_c_destroy_feature.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
        lib.mitab_c_destroy_feature.restype = None

        # 设置 mitab_c_close 函数的参数类型
        lib.mitab_c_close.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
        lib.mitab_c_close.restype = None

        # 设置 mitab_c_getlasterrormsg 函数的参数类型和返回类型
        lib.mitab_c_getlasterrormsg.argtypes = []
        lib.mitab_c_getlasterrormsg.restype = ctypes.c_char_p


if __name__ == "__main__":

    export_thread = ExportThread("D:\\output_polygon.tab")
    export_thread.start()
    export_thread.wait()  # 等待线程完成
    print("Export completed.")
