import qgis
from qgis._core import QgsFillSymbol, QgsRenderContext, QgsLineSymbol

layer = qgis.utils.iface.activeLayer()  # 获取当前活动图层
context = QgsRenderContext()  # 创建渲染上下文

k = 0

# Get the renderer and symbols outside the feature loop
renderer = layer.renderer()  # 获取渲染器
symbols = renderer.symbols(context)  # 获取符号列表，传入上下文

# Assuming you want to process the first symbol only
if symbols:
    symbol = symbols[0]  # Get the first symbol
    if isinstance(symbol, QgsFillSymbol):  # Check if it is a fill symbol
        symbol_layer = symbol.symbolLayer(0)  # Get the first symbol layer
        outline_color = symbol_layer.properties().get('outline_color', 'Not set')
        outline_width = symbol_layer.properties().get('outline_width', 'Not set')
        transparency = symbol.opacity()  # 获取透明度
        for feature in layer.getFeatures():
            fill_color = symbol.color()  # Fill color
            r = fill_color.red()
            g = fill_color.green()
            b = fill_color.blue()
            a = fill_color.alpha()
            print(
                f"Fill Color: {fill_color}, "
                f"Outline Color: {outline_color}, "
                f"Outline Width: {outline_width},"
                f"Transparency: {transparency}"
            )

            k += 1
            if k >= 10:  # Limit to 10 features
                break
    else:
        print("The first symbol is not a fill symbol.")
else:
    print("No symbols found in the renderer.")



