import os

from PyQt5.QtCore import Qt, QThread, QStringListModel, QSize
from PyQt5.QtGui import QColor, QIcon
from qgis.PyQt import QtWidgets, uic, QtCore
from qgis.PyQt.QtCore import pyqtSignal
import re
from qgis._core import QgsFeatureRequest, QgsSpatialIndex, QgsVectorLayer, QgsProject, QgsSymbol, QgsRendererCategory, \
    QgsCategorizedSymbolRenderer, QgsMapLayerProxyModel
from qgis.utils import iface

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'cyanlove_cell_nodeb_search_base.ui'))


class cyanlove_cell_nodeb_search(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(cyanlove_cell_nodeb_search, self).__init__(parent)
        self.search_model = None
        self.search_data = None
        self.export_thread = None
        self.canvas = iface.mapCanvas()
        self.setupUi(self)

        self.property_dict = None  # 存储搜索出来的名称，图元中心经纬度
        self.is_running = False  # 线程状态标志
        self.setWindowFlags(QtCore.Qt.Dialog)  # 使对话框始终在前
        self.btn_clear_filter.setIcon(QIcon(':/plugins/cyanlove/icon/clear_one.svg'))
        self.btn_clear_filter.clicked.connect(self.clear_filter)

        self.mFieldComboBox.setLayer(self.mMapLayerComboBox.currentLayer())
        self.mMapLayerComboBox.currentIndexChanged.connect(self.selectindexchange)
        self.mohu_btn.clicked.connect(self.layer_search)
        self.jingque_btn.clicked.connect(self.layer_search)
        self.listView_show.setEditTriggers(QtWidgets.QAbstractItemView.NoEditTriggers)  # 设置为不可编辑
        self.search_model = QStringListModel()
        self.listView_show.setModel(self.search_model)
        # 列表连接双击信号
        self.listView_show.doubleClicked.connect(self.on_item_double_clicked)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        print("guan_cell")
        event.accept()

    def selectindexchange(self):
        self.mFieldComboBox.setLayer(self.mMapLayerComboBox.currentLayer())

    def updatelistview(self, search_data):
        self.search_model.setStringList(search_data)

    def clear_filter(self):
        # 获取当前选中的图层
        current_layer = self.mMapLayerComboBox.currentLayer()
        current_layer.setSubsetString("")
        current_layer.triggerRepaint()  # 强制刷新图层显示

    def on_thread_finished(self):
        self.is_running = False  # 线程结束时重置状态
        print("搜索完成！")

    def on_item_double_clicked(self, index):
        # 获取双击的项
        if not self.property_dict:
            return
        #  双击的文本
        item_text = self.search_model.data(index, QtCore.Qt.DisplayRole)
        feature_id_list = []
        featurecolname = None
        featuretype = None
        # 遍历字典并提取信息
        if item_text in self.property_dict:
            feature_list = self.property_dict[item_text]
            for feature_data in feature_list:
                # 提取每个字典中的字段信息
                featureid = feature_data['featureid']
                feature_id_list.append(featureid)
                featuretype = feature_data['featuretype']
                featurecolname = feature_data['featurecolname']

            layer = self.mMapLayerComboBox.currentLayer()
            # 平移到位置
            self.canvas.panToFeatureIds(layer, feature_id_list)
            # 如果闪烁功能开启，则闪烁
            if self.radioButton_shanshuo.isChecked():
                # 调用 flashFeatureIds
                self.canvas.flashFeatureIds(
                    layer,  # 图层
                    feature_id_list,  # 要素ID列表
                    startColor=QColor(255, 255, 0, 255),  # 开始颜色（红色）
                    endColor=QColor(255, 255, 0, 0),  # 结束颜色（透明）
                    flashes=6,  # 闪烁次数
                    duration=500  # 持续时间（毫秒）
                )
            # 如果过滤功能开启，则过滤
            if self.radioButton_filter.isChecked():
                expression = f"\"{featurecolname}\" = '{item_text}'"
                if featuretype != "String":
                    expression = f"\"{featurecolname}\" = {item_text}"
                layer.setSubsetString(expression)
                layer.selectByIds(feature_id_list)
        else:
            print(f"Name {item_text} not found in the dictionary.")

    def layer_search(self):
        if self.is_running:  # 检查线程是否在运行
            print("运行中...")
            return
        layerselect = self.mMapLayerComboBox.currentLayer()
        colname = self.mFieldComboBox.currentField()
        input_value = self.textEdit.toPlainText().strip()
        if layerselect is None or colname is None or input_value is None:
            self.search_data = ["没有选择必要字段！"]
            self.listView_show.setEditTriggers(QtWidgets.QAbstractItemView.NoEditTriggers)  # 设置为不可编辑
            self.search_model.setStringList(self.search_data)
            self.listView_show.setModel(self.search_model)
        else:
            # 创建查询表达式
            button = self.sender()  # 获取发送信号的对象
            if button:
                button_text = button.text()  # 获取按钮文本
                self.search_data = ["搜索中..."]
                self.listView_show.setEditTriggers(QtWidgets.QAbstractItemView.NoEditTriggers)  # 设置为不可编辑
                self.search_model.setStringList(self.search_data)
                self.listView_show.setModel(self.search_model)
                # 处理事件以更新界面
                QtWidgets.QApplication.processEvents()
                # 清空字典数据
                self.property_dict = {}
                if button_text == "模糊查找":
                    field_type = None  # 初始化字段类型变量
                    expression = f"\"{colname}\" LIKE '%{input_value}%'"
                    fields = layerselect.fields()  # 获取字段集合

                    # 遍历字段，查找指定字段
                    for field in fields:
                        if field.name() == colname:
                            field_type = field.typeName()  # 获取字段类型
                            break  # 找到后退出循环
                   
                    if field_type.lower() != "string":
                        expression = f"\"{colname}\" = '{input_value}'"
                    self.export_thread = ExportThread(layerselect, colname, input_value, expression, field_type,
                                                      self.property_dict)
                    self.export_thread.finished.connect(self.on_thread_finished)  # 连接线程结束信号
                    self.export_thread.updatelistview.connect(self.updatelistview)
                    self.is_running = True  # 设置为运行状态
                    self.export_thread.start()
                else:
                    expression = f"\"{colname}\" = '{input_value}'"
                    fields = layerselect.fields()  # 获取字段集合
                    field_type = None  # 初始化字段类型变量
                    # 遍历字段，查找指定字段
                    for field in fields:
                        if field.name() == colname:
                            field_type = field.typeName()  # 获取字段类型
                            break  # 找到后退出循环

                    self.export_thread = ExportThread(layerselect, colname, input_value, expression, field_type,
                                                      self.property_dict)
                    self.export_thread.finished.connect(self.on_thread_finished)  # 连接线程结束信号
                    self.export_thread.updatelistview.connect(self.updatelistview)
                    self.is_running = True  # 设置为运行状态
                    self.export_thread.start()

    @staticmethod
    def create_templayer(layer, featuregem):
        # 获取原图层的 CRS（坐标参考系统）
        crs = layer.crs()
        # 获取原图层的类型
        layer_type = layer.geometryType()  # 0:点图层, 1:线图层, 2:面图层
        # 根据图层类型创建新的空图层
        new_layer = ""
        if layer_type == 0:
            new_layer = QgsVectorLayer('Point?crs=' + crs.toWkt(), 'templayer', 'memory')
        elif layer_type == 1:
            new_layer = QgsVectorLayer('LineString?crs=' + crs.toWkt(), 'templayer', 'memory')
        elif layer_type == 2:
            new_layer = QgsVectorLayer('Polygon?crs=' + crs.toWkt(), 'templayer', 'memory')
        else:
            print("不支持的图层类型")
        # 复制原图层的字段结构
        fields = layer.fields()
        new_layer.dataProvider().addAttributes(fields)  # 将字段添加到新图层
        new_layer.updateFields()  # 更新新图层的字段
        # 将该要素添加到临时图层
        new_layer.startEditing()
        new_layer.addFeatures([featuregem])
        new_layer.commitChanges()
        # 添加临时图层到地图中
        QgsProject.instance().addMapLayer(new_layer)


class ExportThread(QThread):
    updatelistview = pyqtSignal(list)  # 声明一个更新listview新增信号

    def __init__(self, layerselect, colname, input_value, expression, field_type, property_dict):
        super().__init__()  # 初始化父类
        self.layerselect = layerselect
        self.colname = colname
        self.input_value = input_value
        self.field_type = field_type
        self.expression = expression
        self.property_dict = property_dict

    def run(self):
        # 应用查询
        request = QgsFeatureRequest()
        request.setFilterExpression(self.expression)
        # 执行请求并获取特征
        features = self.layerselect.getFeatures(request)
        print(self.expression)
        # 假设 self.property_dict 已经是一个字典
        for feature in features:
            name = feature[self.colname]
            # 如果键已经存在，则将 feature 添加到列表中
            if str(name) not in self.property_dict:
                self.property_dict[str(name)] = []  # 创建一个空列表

            # 将新的 feature 添加到对应键的列表中
            self.property_dict[str(name)].append({
                'featureid': feature.id(),
                'featuretype': self.field_type,
                'featurecolname': self.colname
            })

        # 更新listview
        if len(self.property_dict) > 0:
            self.updatelistview.emit(list(self.property_dict.keys()))
        else:
            self.updatelistview.emit(['无数据！'])
        print('ok')
