import csv
import math
import os
import re
import sqlite3
import subprocess
import tempfile
import time
from datetime import datetime

import numpy as np
import pandas as pd
import processing
from PyQt5.QtCore import QVariant, QThread, QCoreApplication, QAbstractTableModel, Qt, QModelIndex
from PyQt5.QtGui import QColor, QStandardItemModel, QStandardItem
from PyQt5.QtWidgets import QFileDialog, QStyledItemDelegate, QComboBox, QColorDialog, QPushButton, QWidget, \
    QAbstractItemView, QTableView, QItemDelegate, QTableWidgetItem, QHeaderView
from pyproj import Geod, Transformer
from qgis._core import QgsFeatureRequest, QgsMapLayer, QgsWkbTypes, QgsCoordinateReferenceSystem, \
    QgsCoordinateTransform, QgsProject, QgsGeometry, QgsGeometryCollection, QgsVectorLayer, QgsFields, QgsField, \
    QgsFeature, Qgis, QgsPointXY, QgsUnitTypes, QgsDistanceArea, QgsProcessingContext, QgsSpatialIndex, \
    QgsProcessingFeedback, QgsSymbol, QgsPoint, QgsPolygon, QgsFillSymbol, QgsSingleSymbolRenderer, QgsFeatureRenderer, \
    QgsRenderContext, QgsEmbeddedSymbolRenderer, QgsRectangle
from qgis.utils import iface

from qgis.PyQt import QtWidgets, uic, QtCore
from qgis.PyQt.QtCore import pyqtSignal
from scipy.spatial import KDTree, cKDTree

from .cyanlove_config_read_intfile import readconfig
from .cyanlove_config_csv_excel_read import CyanloveConfigCSVExcelRead

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'cyanlove_import_create_shange_geometry_base.ui'))


class cyanlove_import_create_shange_geometry(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(cyanlove_import_create_shange_geometry, self).__init__(parent)
        self.export_thread = None
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.setupUi(self)
        self.setFloating(True)

        self.is_running = False  # 线程状态标志
        self.setWindowFlags(QtCore.Qt.Dialog)  # 使对话框始终在前
        # 设置为模态窗口
        self.setWindowModality(QtCore.Qt.ApplicationModal)  # 或者使用 Qt.WindowModal
        self.comboBox_sqliteset.currentIndexChanged.connect(self.get_sqlite_table_columns)
        self.pushButton.clicked.connect(self.writer_shange_geometry)
        # 初始化调用获取sqlite表
        self.initget_sqlite_table()

    def initget_sqlite_table(self):
        db_path = readconfig.read_ini_file('Settings', 'sqlite_栅格分析')
        # 连接到 SQLite 数据库
        conn = sqlite3.connect(db_path, timeout=5)
        cursor = conn.cursor()
        try:
            # 执行查询以获取表名
            cursor.execute("SELECT name FROM sqlite_master WHERE type='table';")
            # 获取所有表名
            table_names = [row[0] for row in cursor.fetchall()]
            # 过滤掉空字符串
            table_names = [name for name in table_names if name]  # 只保留非空的表名
            self.comboBox_sqliteset.clear()
            self.comboBox_sqliteset.addItems(table_names)
            self.comboBox_sqliteset.setCurrentIndex(0)

        except Exception as e:
            self.label_show.setText(f"错误：{str(e)}")
        finally:
            # 关闭游标和连接
            cursor.close()
            conn.close()

    def get_sqlite_table_columns(self):
        current_text = self.comboBox_sqliteset.currentText()
        db_path = readconfig.read_ini_file('Settings', 'sqlite_栅格分析')
        # 连接到 SQLite 数据库
        conn = sqlite3.connect(db_path, timeout=5)
        cursor = conn.cursor()
        try:
            if current_text is not None:
                # 执行查询以获取表名
                cursor.execute(f"PRAGMA table_info([{current_text}]);")
                columns = cursor.fetchall()
                # 提取列名
                column_names = [column[1] for column in columns]  # column[1] 是列名
                self.comboBox_centerlng.clear()
                self.comboBox_centerlng.addItems(column_names)
                self.comboBox_centerlng.setCurrentIndex(0)
                self.comboBox_centerlat.clear()
                self.comboBox_centerlat.addItems(column_names)
                self.comboBox_centerlat.setCurrentIndex(0)
        except Exception as e:
            self.label_show.setText(f"错误：{str(e)}")
        finally:
            # 关闭游标和连接
            cursor.close()
            conn.close()

    def writer_shange_geometry(self):
        current_text = self.comboBox_sqliteset.currentText()
        lngstr = self.comboBox_centerlng.currentText()
        latstr = self.comboBox_centerlat.currentText()
        db_path = readconfig.read_ini_file('Settings', 'sqlite_栅格分析')
        # 连接到 SQLite 数据库
        conn = sqlite3.connect(db_path, timeout=5)
        cursor = conn.cursor()
        try:
            if current_text is not None:
                # 执行查询以获取表名
                cursor.execute(f"SELECT * FROM [" + current_text + "] limit 10;")
                # 获取所有行数据
                rows = cursor.fetchall()
                # 获取列名（可选）
                column_names = [description[0] for description in cursor.description]
                lngindex = column_names.index(lngstr)
                latindex = column_names.index(latstr)
                for row in rows:
                    # 按列名访问数据（如果有列名）

                    if isinstance(row[lngindex], (int, float)) and isinstance(row[latindex], (int, float)):
                        num1 = float(row[lngindex])
                        num2 = float(row[latindex])

                  

        except Exception as e:
            self.label_show.setText(f"错误：{str(e)}")
        finally:
            # 关闭游标和连接
            cursor.close()
            conn.close()
