import os

import processing
from PyQt5.QtCore import QTranslator, QSettings, Qt, QCoreApplication
from PyQt5 import QtWidgets
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction

from .cyanlove_sg_search import cyanlove_sg_search
from .cyanlove_postgresqlset import cyanlove_postgresqlset
from .cyanlove_create_luxianguihua import cyanlove_create_luxianguihua
from .cyanlove_export_centroid_geometry import cyanlove_export_centroid_geometry
from .cyanlove_custom_thematic_maps import cyanlove_custom_thematic_maps
from .cyanlove_create_hotmap import cyanlove_create_hotmap
from .cyanlove_aoi_draw import cyanlove_aoi_draw
from .cyanlove_import_create_sector_geometry import cyanlove_import_create_sector_geometry
from .cyanlove_import_cell_neight_tosqlite import cyanlove_import_cell_neight_tosqlite
from .cyanlove_customdraw import cyanlove_customdraw
from .cyanlove_import_create_point import cyanlove_createpoint
from .cyanlove_import_create_geometry import cyanlove_import_geometry
from .cyanlove_import_create_mutiline import cyanlove_import_create_mutiline
from .cyanlove_export_wkt import cyanlove_exportwkt
from .cyanlove_sqliteset import cyanlove_sqliteset
from .cyanlove_dockwidget import cyanloveDockWidget
from .cyanlove_export_sheetattribute import cyanlove_export_sheetattribute
from .cyanlove_import_csv_excel_sqlite import cyanlove_import_csv_excel_sqlite
from .cyanlove_zoom_to_longitude_latitude import cyanlove_zoom_to_longitude_latitude
from .cyanlove_tencent_keyset import cyanlove_tencent_keyset
from .cyanlove_cell_nodeb_search import cyanlove_cell_nodeb_search
from .cyanlove_export_tab_kml import cyanlove_export_tab_kml
from .cyanlove_buffer import cyanlove_buffer
from .cyanlove_import_layer_tosqlite import cyanlove_import_layerattribute_tosqlite
from .cyanlove_calc_area import cyanlove_calc_area
from .cyanlove_calc_intersects_area import cyanlove_calc_intersects_area
from .cyanlove_calc_intersects_geometry import cyanlove_calc_intersects_geometry
from .cyanlove_calc_contain_point_in_geometry import cyanlove_calc_contain_point_in_geometry
from .cyanlove_sqlite_create_index import cyanlove_sqlite_create_index
from .cyanlove_import_create_shange_geometry import cyanlove_import_create_shange_geometry

from .resources import *  # 初始化资源，没有这句，图标不会显示


class CyanLove:

    def __init__(self, iface):

        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'cyanlove_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.menu = None  # 用于存储主菜单
        self.actions = []  # 用于存储添加的动作
        self.dockwidget_create_hotmap = None
        self.dockwidget_aoi_draw = None
        self.dockwidget_create_secotr_geometry = None
        self.dockwidget_show_shange_neigth = None
        self.dockwidget_show_shange = None
        self.dockwidget_cell_nodeb_search = None
        self.dockwidget_custom_thematic_maps = None
        self.dockwidget_export_wkt_tocsv = None
        self.dockwidget_sqlite = None
        self.dockwidget_postgresql = None
        self.dockwidget_import_cell_neight_tosqlite = None
        self.dockwidget_import_csv_excel_tosqlite = None
        self.dockwidget_draw_polygon = None
        self.dockwidget_draw_mutiline = None
        self.dockwidget_custom_draw_polygon = None
        self.dockwidget_draw_point = None
        self.dockwidget_export_attribute = None
        self.dockwidget_zoom_to_longitude_latitude = None
        self.dockwidget_tencent_keyset = None
        self.dockwidget_create_shange_geometry = None
        self.dockwidget_export_tab_kml = None
        self.dockwidget_buffer = None
        self.dockwidget_import_layerattribute_tosqlite = None
        self.dockwidget_calc_area = None
        self.dockwidget_calc_intersects_area = None
        self.dockwidget_calc_intersects_geometry = None
        self.dockwidget_calc_contain_point_in_geometry = None
        self.dockwidget_calc_dissolve = None
        self.dockwidget_create_index_colname_sqlite = None
        self.dockwidget_calc_intersects_combine = None
        self.dockwidget_create_luxianguihua = None
        self.dockwidget_export_centroid = None
        self.dockwidget_custom_thematic_maps = None
        self.dockwidget_calc_min_distince = None
        self.toolbar = self.iface.addToolBar('申少军工具箱')
        self.toolbar.setObjectName('申少军工具箱')
        self.toolbar.setToolTip('申少军工具箱')

    def initGui(self):
        # 创建主菜单 "申少军工具箱"
        self.menu = QtWidgets.QMenu(QCoreApplication.translate("cyanlove", "申少军工具箱"))
        self.iface.mainWindow().menuBar().addMenu(self.menu)
        icon_path1 = ':/plugins/cyanlove/icon/flab-b-o-svgrepo-com.svg'
        icon_path2 = ':/plugins/cyanlove/icon/globe-users-svgrepo-com.svg'
        icon_path3 = ':/plugins/cyanlove/icon/map-search-svgrepo-com.svg'
        icon_path4 = ':/plugins/cyanlove/icon/location-man-svgrepo-com.svg'
        icon_path5 = ':/plugins/cyanlove/icon/location-on-svgrepo-com.svg'

        # 定义子菜单项
        db_submenu = [
            ("Sqlite数据库配置", self.sub_sqlite, icon_path2),
            ("PostGreSQL数据库配置", self.sub_postgresql, icon_path2),
            ("腾讯/百度/高德地图_Key值配置", self.sub_tencent_keyset, icon_path2)
        ]
        export_submenu = [
            ("边界经纬度集合导出", self.sub_export_wkt_tocsv, icon_path2),
            ("属性表信息导出", self.sub_export_attribute, icon_path2),
            ("几何中心/质心导出", self.sub_export_centroid, icon_path2),
            ("导出为TAB/KML格式", self.sub_export_tab_kml_file, icon_path2),

        ]
        # updatedata_submenu = [
        #     ("更新", self.sub_analysis2, icon_path2),
        #     ("过滤", self.sub_analysis2, icon_path2)
        # ]
        import_submenu = [
            ("选择图层数据导入(Sqlite)", self.sub_import_layerattribute_tosqlite, icon_path2),
            ("邻区表CSV导入(Sqlite)", self.sub_import_cell_neigth_file_tosqlite, icon_path2),
            ("其他文件CSV/Excel导入(Sqlite)", self.sub_import_csv_excel_tosqlite, icon_path2),
            ("创建索引(Sqlite)", self.sub_create_index_colname_sqlite, icon_path2),

        ]
        create_polygon_submenu = [
            ("创建点图层", self.sub_draw_point, icon_path2),
            ("创建线图层", self.sub_draw_mutiline, icon_path2),
            ("创建面图层", self.sub_draw_polygon, icon_path2),
            ("自定义点、线、面图层=>(逗号,分号)或WKT格式", self.sub_custom_draw_polygon, icon_path2),
            ("创建扇区图层", self.sub_create_secotr_geometry, icon_path2),
            ("创建热力图", self.sub_create_hotmap, icon_path2),
            ("创建自定义专题地图", self.sub_cyanlove_custom_thematic_maps, icon_path2),
            # ("创建自定义栅格图", self.sub_cyanlove_custom_shange_maps, icon_path2),
        ]
        zoom_location_submenu = [
            ("坐标定位/地理搜索", self.sub_zoom_to_longitude_latitude, icon_path2),
            ("小区/基站搜索定位", self.sub_cell_nodeb_search, icon_path2),
            ("AOI定位", self.sub_aoi_draw, icon_path2),
            ("路线规划", self.sub_create_luxianguihua, icon_path2),
        ]
        wangluoyouhua_submenu = [
            ("邻区显示(Sqlite)", self.sub_show_shange_neigth, icon_path2),
            ("栅格显示(PostGreSQL)", self.sub_show_shange, icon_path2),


        ]
        diliwenxi_submenu = [
            ("缓冲区分析", self.sub_buffer_meters, icon_path2),
            ("面积计算", self.sub_calc_area, icon_path2),
            ("相交面积计算", self.sub_calc_intersects_area, icon_path2),
            ("图层合并", self.sub_qgis_mergevectorlayers, icon_path2),
            ("关系计算_包含", self.sub_calc_contain_point_in_geometry, icon_path2),
            ("关系计算_相交", self.sub_calc_intersects_geometry, icon_path2),
            ("关系计算_合并", self.sub_qgis_dissolve, icon_path2),
            ("关系计算_多条件合并", self.sub_qgis_aggregate, icon_path2),
            ("关系计算_凸包", self.sub_qgis_convexhull, icon_path2),

        ]
        # transform_submenu = [
        #     ("WGS84 -> 腾讯/高德", self.sub_analysis2, icon_path2),
        #     ("WGS84 -> 百度", self.sub_analysis2, icon_path2),
        # ]
        # cluster_submenu = [
        #     ("DBSCAN聚类", self.sub_analysis2, icon_path2),
        #     ("最近邻分析", self.sub_analysis2, icon_path2),
        #     ("K均值聚类", self.sub_analysis2, icon_path2),
        # ]
        # 添加菜单项和子菜单

        self.add_menu_actions("数据配置", db_submenu)
        self.add_menu_actions("数据导出", export_submenu)
        self.add_menu_actions("数据入库", import_submenu)
        # self.add_menu_actions("数据更新", updatedata_submenu)

        # # 添加分隔符
        separator = QAction("1.", self.menu)
        separator.setSeparator(True)  # 设置为分隔符
        self.menu.addAction(separator)
        self.add_menu_actions("创建图层", create_polygon_submenu)
        self.add_menu_actions("定位/搜索", zoom_location_submenu)
        self.add_menu_actions("图形处理分析", diliwenxi_submenu)
        self.add_menu_actions("网络优化", wangluoyouhua_submenu)
        # 添加分隔符
        separator = QAction("2.", self.menu)
        separator.setSeparator(True)  # 设置为分隔符
        self.menu.addAction(separator)
        # self.add_menu_actions("坐标系转换", transform_submenu)
        # self.add_menu_actions("聚类分析", cluster_submenu)
        # 添加工具栏
        self.add_toolbar_actions(icon_path1, "坐标定位/地理搜索", self.sub_zoom_to_longitude_latitude)
        self.add_toolbar_actions(icon_path5, "小区/基站搜索定位", self.sub_cell_nodeb_search)
        self.add_toolbar_actions(icon_path3, "邻区显示", self.sub_show_shange_neigth)
        self.add_toolbar_actions(icon_path2, "栅格显示(PostGreSQL)", self.sub_show_shange)
        self.add_toolbar_actions(icon_path4, "AOI定位", self.sub_aoi_draw)

    def add_toolbar_actions(self, icon_path1, qtext, method):
        icon = QIcon(icon_path1)
        action = QAction(icon, qtext, self.iface.mainWindow())
        action.triggered.connect(method)
        action.setEnabled(True)
        self.toolbar.addAction(action)
        self.actions.append(action)

    def add_menu_actions(self, menu_name, submenu_items):
        """添加菜单项及其子菜单"""
        # 创建菜单项
        action = QtWidgets.QAction(QCoreApplication.translate("cyanlove", menu_name),
                                   self.iface.mainWindow())
        self.menu.addAction(action)
        self.actions.append(action)  # 保存动作

        # 创建子菜单
        submenu = self.create_submenu(menu_name, submenu_items)
        action.setMenu(submenu)

    def create_submenu(self, submenu_name, actions):
        """创建子菜单的通用函数"""
        submenu = QtWidgets.QMenu(QCoreApplication.translate("cyanlove", submenu_name), self.iface.mainWindow())
        for action_name, method, icon_path in actions:
            self.add_submenu_action(submenu, action_name, method, icon_path)
        return submenu

    def add_submenu_action(self, submenu, action_name, method, icon_path):
        """添加一个子菜单项的通用函数，带图标"""
        action = QtWidgets.QAction(QCoreApplication.translate("cyanlove", action_name), self.iface.mainWindow())
        action.triggered.connect(method)  # 连接到指定的方法
        action.setIcon(QIcon(icon_path))  # 添加图标
        submenu.addAction(action)  # 将动作添加到子菜单

    # 邻区显示
    def sub_show_shange_neigth(self):
        if self.dockwidget_show_shange_neigth is None:
            self.dockwidget_show_shange_neigth = cyanloveDockWidget()
        self.set_right_bottom(self.dockwidget_show_shange_neigth)

    # 栅格显示
    def sub_show_shange(self):
        if self.dockwidget_show_shange is None:
            self.dockwidget_show_shange = cyanlove_sg_search()
        self.set_right_bottom(self.dockwidget_show_shange)

    # 小区/基站信息搜索
    def sub_cell_nodeb_search(self):
        if self.dockwidget_cell_nodeb_search is None:
            self.dockwidget_cell_nodeb_search = cyanlove_cell_nodeb_search()
        self.set_right_bottom(self.dockwidget_cell_nodeb_search)

    # 导出WKT格式边界集
    def sub_export_wkt_tocsv(self):
        if self.dockwidget_export_wkt_tocsv is None:
            self.dockwidget_export_wkt_tocsv = cyanlove_exportwkt()
        self.set_center(self.dockwidget_export_wkt_tocsv)

    # sqlite数据库配置
    def sub_sqlite(self):
        if self.dockwidget_sqlite is None:
            self.dockwidget_sqlite = cyanlove_sqliteset()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_sqlite)
        self.dockwidget_sqlite.show()

    def sub_postgresql(self):
        if self.dockwidget_postgresql is None:
            self.dockwidget_postgresql = cyanlove_postgresqlset()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_postgresql)
        self.dockwidget_postgresql.show()

    # 导入小区和邻区表到sqlite数据库
    def sub_import_cell_neigth_file_tosqlite(self):
        if self.dockwidget_import_cell_neight_tosqlite is None:
            self.dockwidget_import_cell_neight_tosqlite = cyanlove_import_cell_neight_tosqlite()
        self.set_center(self.dockwidget_import_cell_neight_tosqlite)

    # 导入csv/excel到sqlite数据库
    def sub_import_csv_excel_tosqlite(self):
        if self.dockwidget_import_csv_excel_tosqlite is None:
            self.dockwidget_import_csv_excel_tosqlite = cyanlove_import_csv_excel_sqlite()
        self.set_center(self.dockwidget_import_csv_excel_tosqlite)

    # 选择csv/excel文件绘制多边形面
    def sub_draw_polygon(self):
        if self.dockwidget_draw_polygon is None:
            self.dockwidget_draw_polygon = cyanlove_import_geometry()
        self.set_center(self.dockwidget_draw_polygon)

    # 选择csv/excel文件绘制多条线
    def sub_draw_mutiline(self):
        if self.dockwidget_draw_mutiline is None:
            self.dockwidget_draw_mutiline = cyanlove_import_create_mutiline()
        self.set_center(self.dockwidget_draw_mutiline)

    # 输入经纬度集绘制点，线，面
    def sub_custom_draw_polygon(self):
        if self.dockwidget_custom_draw_polygon is None:
            self.dockwidget_custom_draw_polygon = cyanlove_customdraw()
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget_custom_draw_polygon)
        self.dockwidget_custom_draw_polygon.show()

    # 定位
    def sub_zoom_to_longitude_latitude(self):
        if self.dockwidget_zoom_to_longitude_latitude is None:
            self.dockwidget_zoom_to_longitude_latitude = cyanlove_zoom_to_longitude_latitude()
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget_zoom_to_longitude_latitude)
        self.dockwidget_zoom_to_longitude_latitude.show()

    # 选择点文件，创建点图层
    def sub_draw_point(self):
        if self.dockwidget_draw_point is None:
            self.dockwidget_draw_point = cyanlove_createpoint()
        self.set_center(self.dockwidget_draw_point)

    # 导出图层属性表
    def sub_export_attribute(self):
        if self.dockwidget_export_attribute is None:
            self.dockwidget_export_attribute = cyanlove_export_sheetattribute()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_export_attribute)
        self.set_center(self.dockwidget_export_attribute)

    # 腾讯key值设置
    def sub_tencent_keyset(self):
        if self.dockwidget_tencent_keyset is None:
            self.dockwidget_tencent_keyset = cyanlove_tencent_keyset()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_tencent_keyset)
        self.dockwidget_tencent_keyset.show()

    # 导出mapinfo TAB或者KML文件
    def sub_export_tab_kml_file(self):
        if self.dockwidget_export_tab_kml is None:
            self.dockwidget_export_tab_kml = cyanlove_export_tab_kml()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_export_tab_kml)
        self.set_center(self.dockwidget_export_tab_kml)

    # 实现米的缓冲
    def sub_buffer_meters(self):
        if self.dockwidget_buffer is None:
            self.dockwidget_buffer = cyanlove_buffer()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_buffer)
        self.set_center(self.dockwidget_buffer)

    # 实现图层数据入库
    def sub_import_layerattribute_tosqlite(self):
        if self.dockwidget_import_layerattribute_tosqlite is None:
            self.dockwidget_import_layerattribute_tosqlite = cyanlove_import_layerattribute_tosqlite()
        self.set_center(self.dockwidget_import_layerattribute_tosqlite)

    # 面积计算
    def sub_calc_area(self):
        if self.dockwidget_calc_area is None:
            self.dockwidget_calc_area = cyanlove_calc_area()
        self.set_center(self.dockwidget_calc_area)

    # 相交面积计算
    def sub_calc_intersects_area(self):
        if self.dockwidget_calc_intersects_area is None:
            self.dockwidget_calc_intersects_area = cyanlove_calc_intersects_area()
        self.set_center(self.dockwidget_calc_intersects_area)

    # 相交计算
    def sub_calc_intersects_geometry(self):
        if self.dockwidget_calc_intersects_geometry is None:
            self.dockwidget_calc_intersects_geometry = cyanlove_calc_intersects_geometry()
        self.set_center(self.dockwidget_calc_intersects_geometry)

    # 点是否在边界内计算
    def sub_calc_contain_point_in_geometry(self):
        if self.dockwidget_calc_contain_point_in_geometry is None:
            self.dockwidget_calc_contain_point_in_geometry = cyanlove_calc_contain_point_in_geometry()
        self.set_center(self.dockwidget_calc_contain_point_in_geometry)

    # 创建数据库索引
    def sub_create_index_colname_sqlite(self):
        if self.dockwidget_create_index_colname_sqlite is None:
            self.dockwidget_create_index_colname_sqlite = cyanlove_sqlite_create_index()
            self.iface.addDockWidget(Qt.AllDockWidgetAreas, self.dockwidget_create_index_colname_sqlite)
        self.dockwidget_create_index_colname_sqlite.show()

    # 创建扇区图
    def sub_create_secotr_geometry(self):
        if self.dockwidget_create_secotr_geometry is None:
            self.dockwidget_create_secotr_geometry = cyanlove_import_create_sector_geometry()
            self.iface.addDockWidget(Qt.DockWidgetArea_Mask, self.dockwidget_create_secotr_geometry)
        self.dockwidget_create_secotr_geometry.show()

    # 创建自定义栅格图
    def sub_cyanlove_custom_shange_maps(self):
        self.dockwidget_create_shange_geometry = cyanlove_import_create_shange_geometry()
        self.iface.addDockWidget(Qt.DockWidgetArea_Mask, self.dockwidget_create_shange_geometry)
        self.dockwidget_create_shange_geometry.show()

    # aoi绘制
    def sub_aoi_draw(self):
        if self.dockwidget_aoi_draw is None:
            self.dockwidget_aoi_draw = cyanlove_aoi_draw()
        self.set_right_bottom(self.dockwidget_aoi_draw)

    # 创建热力图
    def sub_create_hotmap(self):
        if self.dockwidget_create_hotmap is None:
            self.dockwidget_create_hotmap = cyanlove_create_hotmap()
        self.set_right_bottom(self.dockwidget_create_hotmap)

    # 自定义专题地图
    def sub_cyanlove_custom_thematic_maps(self):
        if self.dockwidget_custom_thematic_maps is None:
            self.dockwidget_custom_thematic_maps = cyanlove_custom_thematic_maps()
        self.set_right_bottom(self.dockwidget_custom_thematic_maps)

    # 导出中心点
    def sub_export_centroid(self):
        if self.dockwidget_export_centroid is None:
            self.dockwidget_export_centroid = cyanlove_export_centroid_geometry()
        self.set_center(self.dockwidget_export_centroid)

    # 路线规划
    def sub_create_luxianguihua(self):
        if self.dockwidget_create_luxianguihua is None:
            self.dockwidget_create_luxianguihua = cyanlove_create_luxianguihua()
        self.set_right_bottom(self.dockwidget_create_luxianguihua)

    # 要素之间最短线
    def sub_calc_min_distince(self):
        if self.dockwidget_calc_min_distince is None:
            self.dockwidget_calc_min_distince = cyanlove_create_luxianguihua()
        self.set_right_bottom(self.dockwidget_calc_min_distince)

    def set_center(self, dockwidget_a):
        self.iface.addDockWidget(Qt.BottomDockWidgetArea, dockwidget_a)
        # 获取dockwidget的尺寸
        dock_width = dockwidget_a.size().width()
        dock_height = dockwidget_a.size().height()

        # 获取主窗口的大小和位置
        main_window_rect = self.iface.mainWindow().geometry()
        main_window_width = main_window_rect.width()
        main_window_height = main_window_rect.height()
        # 计算主窗口中心的坐标
        center_x = (main_window_width - dock_width) // 2
        center_y = (main_window_height - dock_height) // 2

        # 设置dockwidget的位置和大小
        dockwidget_a.setGeometry(center_x, center_y, dock_width, dock_height)
        dockwidget_a.setFloating(True)
        # 每次点击时，显示 dockwidget
        dockwidget_a.show()
        dockwidget_a.raise_()  # 提升到最前面

    def set_right_bottom(self, dockwidget_b, widthset=10, heightset=10):
        # 获取dockwidget的尺寸
        self.iface.addDockWidget(Qt.BottomDockWidgetArea, dockwidget_b)
        dock_width = dockwidget_b.size().width()
        dock_height = dockwidget_b.size().height()

        # 获取主窗口的大小和位置
        main_window_rect = self.iface.mainWindow().geometry()
        main_window_width = main_window_rect.width()
        main_window_height = main_window_rect.height()

        # 计算右下角的位置
        dock_x = main_window_width - dock_width - widthset  # 右边距 10 像素
        dock_y = main_window_height - dock_height - heightset  # 下边距 10 像素

        # 设置dockwidget的位置和大小
        dockwidget_b.setGeometry(dock_x, dock_y, dock_width, dock_height)

        # 每次点击时显示dockwidget
        dockwidget_b.setFloating(True)
        dockwidget_b.show()
        dockwidget_b.raise_()  # 提升到最前面

    # 相交合并计算
    @staticmethod
    def sub_qgis_aggregate():
        processing.execAlgorithmDialog('qgis:aggregate')

    @staticmethod
    def sub_qgis_dissolve():
        processing.execAlgorithmDialog('qgis:dissolve')

    @staticmethod
    def sub_qgis_mergevectorlayers():
        processing.execAlgorithmDialog('qgis:mergevectorlayers')

    @staticmethod
    def sub_qgis_convexhull():
        processing.execAlgorithmDialog('qgis:convexhull')

    @staticmethod
    def sub_analysis2():
        # 这里添加子菜单分析2的逻辑
        msg_box = QtWidgets.QMessageBox()
        msg_box.setWindowTitle("标题")  # 设置窗体标题
        msg_box.setText("功能还没写，后续补充！")  # 设置显示的消息内容
        msg_box.setIcon(QtWidgets.QMessageBox.Information)  # 设置消息框图标
        msg_box.setStandardButtons(QtWidgets.QMessageBox.Ok)  # 添加“确定”按钮
        msg_box.exec_()  # 显示消息框

    def unload(self):
        # 清除菜单和动作
        if self.menu:
            self.iface.mainWindow().menuBar().removeAction(self.menu.menuAction())
            self.menu.deleteLater()  # 释放菜单资源

        # 清除所有动作
        for action in self.actions:
            action.setEnabled(False)  # 禁用动作，以免出现错误
            self.menu.removeAction(action)  # 从菜单中移除动作
            self.iface.removePluginVectorMenu("坐标定位/地理搜索", action)
            self.iface.removePluginVectorMenu("小区/基站搜索定位", action)
            self.iface.removePluginVectorMenu("栅格/邻区显示(PostGreSQL)", action)
            self.iface.removeToolBarIcon(action)
        self.actions.clear()  # 清空动作列表
