import os
import sqlite3

from PyQt5.QtWidgets import QFileDialog
from qgis.PyQt import uic, QtWidgets, QtCore

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'cyanlove_postgresqlset_base.ui'))
# 相对导入方式，不能用import 否则会找不到模块，相对导入会从当前目录搜索

from .cyanlove_config_read_intfile import *
from pathlib import Path


class cyanlove_postgresqlset(QtWidgets.QDockWidget, FORM_CLASS):

    def __init__(self, parent=None):
        super(cyanlove_postgresqlset, self).__init__(parent)
        self.setupUi(self)
        self.setWindowFlags(QtCore.Qt.Dialog)  # 使对话框始终在前
        # 设置为模态窗口
        self.setWindowModality(QtCore.Qt.ApplicationModal)  # 或者使用 Qt.WindowModal
        self.pushButton.clicked.connect(self.setpostgresql)
        # 可选：如果你希望这个窗口在其他窗口前面显示
        self.raise_()

    def setpostgresql(self):
        databaseset = self.textEdit_database.toPlainText()
        userset = self.textEdit_user.toPlainText()
        pwdset = self.textEdit_password.toPlainText()
        portset = self.textEdit_port.toPlainText()
        formatted_string = f"databaseset: {str(databaseset)} | userset: {str(userset)} | pwdset: {str(pwdset)} | portset: {str(portset)}"
        readconfig.write_ini_file('Settings', 'postgresql库配置', formatted_string)
        self.label_show.setText('PostgreSQL库配置成功!')
