import ast
import csv
import ctypes
import os

from PyQt5.QtCore import QVariant
from PyQt5.QtGui import QColor
from PyQt5.QtWidgets import QPushButton, QTableWidgetItem, QHeaderView, QColorDialog

from qgis.PyQt import QtWidgets, uic, QtCore
from qgis.PyQt.QtCore import pyqtSignal
from qgis._core import QgsProject, QgsVectorLayer, QgsFillSymbol, QgsSymbol, QgsRendererCategory, \
    QgsCategorizedSymbolRenderer, QgsRendererRange, QgsGraduatedSymbolRenderer, QgsField, QgsSingleSymbolRenderer, \
    QgsEmbeddedSymbolRenderer

from .cyanlove_config_read_intfile import readconfig

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'cyanlove_custom_thematic_maps_base.ui'))


class cyanlove_custom_thematic_maps(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(cyanlove_custom_thematic_maps, self).__init__(parent)
        self.data = None
        self.export_thread = None
        self.setupUi(self)
        self.setFloating(True)
        self.setWindowFlags(QtCore.Qt.Dialog)  # 使对话框始终在前
        # self.setWindowModality(QtCore.Qt.ApplicationModal)  # 或者使用 Qt.WindowModal
        self.mFieldComboBox.setLayer(self.mMapLayerComboBox.currentLayer())
        self.mMapLayerComboBox.currentIndexChanged.connect(self.selectindexchange)
        self.btn_delete_col.clicked.connect(self.btn_delete_colset)
        self.btn_add_col.clicked.connect(self.btn_add_colset)
        self.btn_sav_xml.clicked.connect(self.btn_sav_xmlset)
        self.btn_create_map.clicked.connect(self.btn_create_mapset)
        self.btn_clear_map.clicked.connect(self.btn_clear_mapset)
        self.tableview_init()

    def selectindexchange(self):
        self.mFieldComboBox.setLayer(self.mMapLayerComboBox.currentLayer())

    def tableview_init(self):
        self.tableWidget.setColumnCount(3)  # 列
        self.tableWidget.setHorizontalHeaderLabels(['最大值', '最小值', '颜色'])
        custom_thematic_maps_str = readconfig.read_ini_file('Settings', 'custom_thematic_maps')

        if custom_thematic_maps_str is None:
            self.data = [
                [-160, -120, '#FF4040'],
                [-120, -110, '#FF40FF'],
                [-110, -100, '#ffff00'],
                [-100, -90, '#0000ff'],
                [-90, 0, '#00FF00']
            ]
        else:
            self.data = ast.literal_eval(custom_thematic_maps_str)  # 安全地将字符串转换为列表

        self.tableWidget.setRowCount(len(self.data))
        # 填充数据
        self.tableWidget.setRowCount(len(self.data))
        for row_idx, row_data in enumerate(self.data):
            for col_idx, value in enumerate(row_data):
                if col_idx == 2:  # 颜色列，添加按钮
                    button = QPushButton("")
                    button.setStyleSheet(f"background-color: {value}")
                    button.clicked.connect(lambda checked, row=row_idx: self.change_color(row))
                    self.tableWidget.setCellWidget(row_idx, col_idx, button)
                else:
                    self.tableWidget.setItem(row_idx, col_idx, QTableWidgetItem(str(value)))
                # 设置列宽自适应，所有列均可以拉伸
        for i in range(3):
            self.tableWidget.setColumnWidth(i, 100)  # 设置初始宽度为100
            self.tableWidget.horizontalHeader().setMinimumSectionSize(100)  # 设置每一列的最小宽度为100

        header = self.tableWidget.horizontalHeader()
        header.setSectionResizeMode(0, QHeaderView.ResizeToContents)  # Color_Set 列根据内容自适应
        header.setSectionResizeMode(1, QHeaderView.ResizeToContents)  # 长度列根据内容自适应
        header.setSectionResizeMode(2, QHeaderView.Stretch)  # 颜色列填充剩余空间

    def change_color(self, row):
        # 弹出颜色对话框
        color = QColorDialog.getColor()

        if color.isValid():
            # 获取颜色按钮并改变背景色
            button = self.tableWidget.cellWidget(row, 2)
            button.setStyleSheet(f"background-color: {color.name()}")

    def btn_delete_colset(self):
        # 获取当前选中的行
        current_row = self.tableWidget.currentRow()
        if current_row >= 0:  # 检查是否有选中的行
            # 删除该行
            self.tableWidget.removeRow(current_row)
            # 更新数据列表以反映删除操作
            self.data.pop(current_row)
        else:
            print("没有选中的行可删除。")

    def btn_add_colset(self):
        # 在表格末尾添加新行
        row_count = self.tableWidget.rowCount()
        self.tableWidget.insertRow(row_count)  # 插入新行
        max_value = 100
        min_value = 1
        color = "#FFFFFF"
        # 填充新行的数据
        self.tableWidget.setItem(row_count, 0, QTableWidgetItem(str(max_value)))
        self.tableWidget.setItem(row_count, 1, QTableWidgetItem(str(min_value)))

        # 创建颜色按钮
        button = QPushButton("")
        button.setStyleSheet(f"background-color: {color}")
        button.clicked.connect(lambda checked, row=row_count: self.change_color(row))
        self.tableWidget.setCellWidget(row_count, 2, button)  # 颜色按钮列
        # 更新数据列表
        self.data.append([max_value, min_value, color])

    def btn_sav_xmlset(self):
        spin_box_data = str(self.get_all_data())  # 数据
        readconfig.write_ini_file('Settings', 'custom_thematic_maps', spin_box_data)
        self.label_show.setText('配置成功!')

    def btn_create_mapset(self):
        self.label_show.setText("")
        # 创建分类符号渲染器
        layer = self.mMapLayerComboBox.currentLayer()
        colname = self.mFieldComboBox.currentField()
        # 获取字段信息
        field_index = layer.fields().indexOf(colname)
        field_type = layer.fields().field(field_index).type()

        if field_type not in [QVariant.Int, QVariant.Double]:
            self.label_show.setText("不是数字列，无法创建！")
            return
        ranges = []

        intervals = self.get_all_data()
        if intervals is None:
            self.label_show.setText("设置区间错误！")
        else:
            for interval in intervals:
                lower_bound = float(interval[0])
                upper_bound = float(interval[1])
                color = interval[2]

                # 创建符号
                symbol = QgsSymbol.defaultSymbol(layer.geometryType())
                symbol.setColor(QColor(color))

                # 创建渲染类别
                rangeall = QgsRendererRange(lower_bound, upper_bound, symbol, f"{lower_bound} to {upper_bound}")
                ranges.append(rangeall)

            # 创建分类渲染器
            renderer = QgsGraduatedSymbolRenderer(colname, ranges)
            layer.setRenderer(renderer)

            # 刷新图层以应用新样式
            layer.triggerRepaint()
            self.label_show.setText("创建成功！")

    def btn_clear_mapset(self):
        layerselect = self.mMapLayerComboBox.currentLayer()
        renderer = layerselect.renderer()
        symbol = QgsSymbol.defaultSymbol(layerselect.geometryType())
        # 清除渲染器，设置为默认渲染器
        layerselect.setRenderer(QgsSingleSymbolRenderer(symbol))
        layerselect.triggerRepaint()

        self.label_show.setText('清空完毕！')

    def get_all_data(self):
        all_data = []
        row_count = self.tableWidget.rowCount()
        for row in range(row_count):
            row_data = self.get_row_data(row)
            all_data.append(row_data)
        return all_data

    def get_row_data(self, row):
        row_data = []
        for col in range(3):  # 3列
            item = self.tableWidget.item(row, col)

            if item:
                row_data.append(item.text())
            else:
                # 对于按钮列，获取按钮的背景色或其他相关信息
                button = self.tableWidget.cellWidget(row, col)
                if button:
                    # 获取按钮的背景色作为颜色列的值
                    button_color = button.styleSheet().split(':')[-1].strip()
                    row_data.append(button_color)
        return row_data
