# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CustomMapDownloaderDialog
                                 A QGIS plugin
 Download georeferenced maps from any layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-11-18
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Abhinav Jayswal
        email                : abhinavjayaswal10@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject, QgsCoordinateReferenceSystem

# This loads the .ui file so that PyQt can populate the plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'CustomMapDownloader_dialog_base.ui'))


class CustomMapDownloaderDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(CustomMapDownloaderDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # Connect the browse button to file dialog
        self.pushButton_browse.clicked.connect(self.select_output_file)
        
        # Populate CRS combo box
        self.populate_crs()
    
    def populate_layers(self):
        """Populate the layer combo box with all layers from the current project."""
        self.comboBox_layer.clear()
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            self.comboBox_layer.addItem(layer.name(), layer)
    
    def populate_crs(self):
        """Populate the CRS combo box with common coordinate reference systems."""
        self.comboBox_crs.clear()
        
        # Define common CRS options with their EPSG codes and descriptions
        crs_options = [
            ("EPSG:3857", "WGS 84 / Pseudo-Mercator (Web Mercator)"),
            ("EPSG:4326", "WGS 84 (Geographic, lat/lon)"),
            ("EPSG:3395", "WGS 84 / World Mercator"),
            ("EPSG:32633", "WGS 84 / UTM zone 33N"),
            ("EPSG:32634", "WGS 84 / UTM zone 34N"),
            ("EPSG:32635", "WGS 84 / UTM zone 35N"),
            ("EPSG:32636", "WGS 84 / UTM zone 36N"),
            ("EPSG:32637", "WGS 84 / UTM zone 37N"),
            ("EPSG:32638", "WGS 84 / UTM zone 38N"),
            ("EPSG:32639", "WGS 84 / UTM zone 39N"),
            ("EPSG:32640", "WGS 84 / UTM zone 40N"),
            ("EPSG:32641", "WGS 84 / UTM zone 41N"),
            ("EPSG:32642", "WGS 84 / UTM zone 42N"),
            ("EPSG:32643", "WGS 84 / UTM zone 43N"),
            ("EPSG:32644", "WGS 84 / UTM zone 44N"),
            ("EPSG:32645", "WGS 84 / UTM zone 45N"),
            ("EPSG:32646", "WGS 84 / UTM zone 46N"),
            ("EPSG:32733", "WGS 84 / UTM zone 33S"),
            ("EPSG:32734", "WGS 84 / UTM zone 34S"),
            ("EPSG:32735", "WGS 84 / UTM zone 35S"),
            ("EPSG:32736", "WGS 84 / UTM zone 36S"),
            ("EPSG:2154", "RGF93 / Lambert-93 (France)"),
            ("EPSG:27700", "OSGB 1936 / British National Grid"),
            ("EPSG:5514", "S-JTSK / Krovak East North"),
            ("EPSG:31370", "Belge 1972 / Belgian Lambert 72"),
            ("EPSG:25832", "ETRS89 / UTM zone 32N"),
            ("EPSG:25833", "ETRS89 / UTM zone 33N"),
            ("EPSG:2056", "CH1903+ / LV95 (Switzerland)"),
            ("EPSG:3035", "ETRS89 / LAEA Europe"),
            ("EPSG:3857", "WGS 84 / Pseudo-Mercator"),
        ]
        
        # Add CRS options to combo box
        for epsg_code, description in crs_options:
            crs = QgsCoordinateReferenceSystem(epsg_code)
            if crs.isValid():
                display_text = f"{epsg_code} - {description}"
                self.comboBox_crs.addItem(display_text, epsg_code)
        
        # Set default to EPSG:3857 (Web Mercator)
        default_index = self.comboBox_crs.findData("EPSG:3857")
        if default_index >= 0:
            self.comboBox_crs.setCurrentIndex(default_index)
    
    def select_output_file(self):
        """Open a file dialog to select the output file path."""
        filename, _ = QtWidgets.QFileDialog.getSaveFileName(
            self,
            "Select output file",
            "",
            "GeoTIFF Files (*.tif *.tiff);;All Files (*)"
        )
        if filename:
            self.lineEdit_output.setText(filename)
    
    def get_parameters(self):
        """Get all parameters from the dialog."""
        try:
            lat = float(self.lineEdit_lat.text())
            lon = float(self.lineEdit_lon.text())
            gsd = self.spinBox_gsd.value()
            width = self.spinBox_width.value()
            height = self.spinBox_height.value()
            layer = self.comboBox_layer.currentData()
            output_path = self.lineEdit_output.text()
            load_as_layer = self.checkBox_loadLayer.isChecked()
            add_georeferencing = self.checkBox_georeferencing.isChecked()
            
            # Get selected CRS
            crs_epsg = self.comboBox_crs.currentData()
            
            return {
                'lat': lat,
                'lon': lon,
                'gsd': gsd,
                'width': width,
                'height': height,
                'layer': layer,
                'output_path': output_path,
                'load_as_layer': load_as_layer,
                'add_georeferencing': add_georeferencing,
                'output_crs': crs_epsg
            }
        except ValueError as e:
            return None
