# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CustomMapDownloaderDialog
                                 A QGIS plugin
 Download georeferenced maps from any layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-11-18
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Abhinav Jayswal
        email                : abhinavjayaswal10@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject

# This loads the .ui file so that PyQt can populate the plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'CustomMapDownloader_dialog_base.ui'))


class CustomMapDownloaderDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(CustomMapDownloaderDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # Connect the browse button to file dialog
        self.pushButton_browse.clicked.connect(self.select_output_file)
    
    def populate_layers(self):
        """Populate the layer combo box with all layers from the current project."""
        self.comboBox_layer.clear()
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            self.comboBox_layer.addItem(layer.name(), layer)
    
    def select_output_file(self):
        """Open a file dialog to select the output file path."""
        filename, _ = QtWidgets.QFileDialog.getSaveFileName(
            self,
            "Select output file",
            "",
            "GeoTIFF Files (*.tif *.tiff);;All Files (*)"
        )
        if filename:
            self.lineEdit_output.setText(filename)
    
    def get_parameters(self):
        """Get all parameters from the dialog."""
        try:
            lat = float(self.lineEdit_lat.text())
            lon = float(self.lineEdit_lon.text())
            gsd = self.spinBox_gsd.value()
            width = self.spinBox_width.value()
            height = self.spinBox_height.value()
            layer = self.comboBox_layer.currentData()
            output_path = self.lineEdit_output.text()
            load_as_layer = self.checkBox_loadLayer.isChecked()
            add_georeferencing = self.checkBox_georeferencing.isChecked()
            
            return {
                'lat': lat,
                'lon': lon,
                'gsd': gsd,
                'width': width,
                'height': height,
                'layer': layer,
                'output_path': output_path,
                'load_as_layer': load_as_layer,
                'add_georeferencing': add_georeferencing
            }
        except ValueError as e:
            return None
