# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CurvaDeNivel
                                 A QGIS plugin
 Cria curvas de nivel a partir de dados geomorféticos do INPE
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-08
        copyright            : (C) 2024 by Daniel Hulshof Saint Martin
        email                : daniel.hulshof@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Daniel Hulshof Saint Martin'
__date__ = '2024-10-08'
__copyright__ = '(C) 2024 by Daniel Hulshof Saint Martin'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import inspect
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessingProvider
from .curva_de_nivel_algorithm import CurvaDeNivelAlgorithm


class CurvaDeNivelProvider(QgsProcessingProvider):

    def __init__(self):

        QgsProcessingProvider.__init__(self)

    def unload(self):

        pass

    def loadAlgorithms(self):

        self.addAlgorithm(CurvaDeNivelAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):

        return 'Curva de Nivel'

    def name(self):

        return self.tr('Curva de Nivel')

    def icon(self):
        
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon

    def longName(self):

        return self.name()
