# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CTX_Polar_CRS_Toolbox
                                 A QGIS plugin
 This plug-ins edits custom CTX Polar CRS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-19
        copyright            : (C) 2025 by Quentin Betton
        email                : quentin.btn45@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Quentin Betton'
__date__ = '2025-07-21'
__copyright__ = '(C) 2025 by Quentin Betton'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import re
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProject,
                       QgsProcessing,
                       QgsFeatureSink,
                       QgsRasterLayer,
                       QgsProcessingAlgorithm,
                       QgsCoordinateReferenceSystem,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink
                       )



class CTX_Polar_CRS_ToolboxAlgorithm(QgsProcessingAlgorithm):
    def initAlgorithm(self, config=None):
        pass


    def processAlgorithm(self, parameters, context, feedback):
        """
        Scan project raster layers for 'PolarStereographic mars' CRS and modify scale factor.
        """
        new_scale_factor = 1.0  # Can be a user parameter if needed
        changed_layers = 0

        for layer in QgsProject.instance().mapLayers().values():
            if not isinstance(layer, QgsRasterLayer):
                continue

            crs = layer.crs()
            if crs.description() != "PolarStereographic mars":
                continue

            proj_string = crs.toProj()
            feedback.pushInfo(f"Original PROJ string for layer '{layer.name()}': {proj_string}")

            if '+k=' not in proj_string and '+k_0=' not in proj_string:
                feedback.reportError(f"No +k or +k_0 found in layer '{layer.name()}'. Skipping.")
                continue

            if '+k=' in proj_string:
                new_proj = re.sub(r'\+k=\d+(\.\d+)?', f'+k={new_scale_factor}', proj_string)
            else:
                new_proj = re.sub(r'\+k_0=\d+(\.\d+)?', f'+k_0={new_scale_factor}', proj_string)

            new_crs = QgsCoordinateReferenceSystem()
            if not new_crs.createFromProj(new_proj):
                feedback.reportError(f"Failed to create CRS for layer '{layer.name()}'.")
                continue

            layer.setCrs(new_crs)
            changed_layers += 1
            feedback.pushInfo(f"Updated CRS scale factor for layer '{layer.name()}'.")

        feedback.pushInfo(f"Modified {changed_layers} layer(s) with new scale factor.")
        return {'message': f"Modified {changed_layers} layer(s) with new scale factor."}


    def name(self):
       return 'crs_checker'      # All lowercase, underscores only


    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr("CRS checker")

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Global processing'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return CTX_Polar_CRS_ToolboxAlgorithm()

# class check_footprint(object):
#     """docstring for check_footprint"""
#     def __init__(self, arg):
#         super(check_footprint, self).__init__()
#         self.arg = arg


#     def process algorithm(self, click_coordinates):
#         get the coordinates of the click
#         look into "/data/mars_mro_ctx_edr_c0a/mars_mro_ctx_edr_c0a.shp" for polygons containing the clicked area, order the result depending on how close to the center of the polygones the click is
#         return in the sidepanel the list of the images in this area, with the name extracted from the shapefile, as well as their download link
