
"""
/***************************************************************************
 CTX_Polar_CRS_Toolbox
                                 A QGIS plugin
 This plug-ins edits custom CTX Polar CRS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-19
        copyright            : (C) 2025 by Quentin Betton
        email                : quentin.btn45@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Quentin Betton'
__date__ = '2025-07-19'
__copyright__ = '(C) 2025 by Quentin Betton'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import re
import sys
import inspect

from qgis import processing
from qgis.core import (Qgis,
                        QgsProcessingAlgorithm,
                        QgsApplication,
                        QgsProject,
                        QgsRasterLayer,
                        QgsCoordinateReferenceSystem
                        )
from qgis.PyQt.QtWidgets import QAction
from .ctx_polar_crs_toolbox_provider import CTX_Polar_CRS_ToolboxProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class CTX_Polar_CRS_ToolboxPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface
        self.listener = RasterCrsListener(iface, target_crs='PolarStereographic mars')

    def initProcessing(self):
        self.provider = CTX_Polar_CRS_ToolboxProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        self.listener.start()

        # Add an action to the Plugins menu
        self.action_run = QAction("Run CRS Checker", self.iface.mainWindow())
        self.action_run.triggered.connect(self.run_algorithm_and_report)
        self.iface.addPluginToMenu("CTX Polar CRS Toolbox", self.action_run)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.listener.stop()
        self.iface.removePluginMenu("CTX Polar CRS Toolbox", self.action_run)

    def run_algorithm_and_report(self):
        result = processing.run(
            'ctx_crs_toolbox:crs_checker',  # Use your provider and algorithm IDs
            {}
        )
        # The algorithm should return a dict containing a 'message' field
        if result and 'message' in result:
            self.iface.messageBar().pushMessage(
                "CTX Polar CRS Toolbox",
                result['message'],
                level=Qgis.Info,
                duration=5  # seconds, adjust as needed
            )



class RasterCrsListener:
    def __init__(self, iface, target_crs='PolarStereographic mars'):
        self.iface = iface
        self.target_crs = target_crs
        self._conn = None

    def start(self):
        self._conn = QgsProject.instance().layerWasAdded.connect(self.on_layer_added)

    def stop(self):
        if self._conn:
            QgsProject.instance().layerWasAdded.disconnect(self.on_layer_added)

    def on_layer_added(self, layer):
        if isinstance(layer, QgsRasterLayer):
            crs_name = layer.crs().description() or ""
            if crs_name == self.target_crs:
                self.set_crs_scale_factor(layer, 1.0)

    def set_crs_scale_factor(self, layer, new_scale_factor):
        original_crs = layer.crs()
        proj_string = original_crs.toProj()

        if not proj_string:
            print("Could not get PROJ string from CRS.")
            return False

        print("Original PROJ string:", proj_string)

        # Modify +k or +k_0 (whichever appears)
        if '+k=' in proj_string:
            modified_proj = re.sub(r'\+k=\d+(\.\d+)?', f'+k={new_scale_factor}', proj_string)
        elif '+k_0=' in proj_string:
            modified_proj = re.sub(r'\+k_0=\d+(\.\d+)?', f'+k_0={new_scale_factor}', proj_string)
        else:
            print("No +k or +k_0 parameter found in PROJ string.")
            return False

        print("Modified PROJ string:", modified_proj)

        # Create new CRS from modified PROJ string
        new_crs = QgsCoordinateReferenceSystem()
        if not new_crs.createFromProj(modified_proj):
            print("Failed to create CRS from modified PROJ string.")
            return False

        # Apply new CRS
        layer.setCrs(new_crs)
        print(f"Set new CRS with scale factor {new_scale_factor}")
        return True